<div class="github-widget" data-repo="Siilwyn/awesome-pixel-art"></div>
## Awesome Pixel Art
[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://cdn.rawgit.com/Siilwyn/awesome-pixel-art/1d81c507/sheep-timelapse.gif" align="right" width="118">](https://twitter.com/mnrART)

 Awesome Pixel Art 是一个专门用于创建和学习像素艺术的存储库，并提供可帮助您参与社区的链接！ 在像素艺术中，每个放置的像素对于创建设想的图形都很重要. 您可以在下面找到从基本介绍元素到颜色和动画教程的帮助链接. 在游戏、动画和其他艺术家中有很多灵感点！

- [Tools](#tools) 

## Tutorials

### Basics
- [Introduction to pixel art](http://pixeljoint.com/forum/forum_posts.asp?TID=11299)
- [Creating a cube](http://vanmall.deviantart.com/art/How-to-start-with-pixel-art-121520884)
- [Creating round objects](http://vanmall.deviantart.com/art/How-to-make-round-objects-in-pixel-art-347907700)
- [Outline basics](http://samkeddy.com/pixel-art-outlines/)
- [Outline colors](http://samkeddy.com/pixel-art-outlines-part-2-using-color/)
- [Getting started from scratch with Aseprite](https://medium.com/pixel-grimoire/how-to-start-making-pixel-art-2d1e31a5ceab)

### Color
- [Creating a color palette](https://betterin2d.com/2014/08/02/pixel-art-tutorial-creating-a-colour-palette/)
- [Color palette and HSL](https://opengameart.org/content/chapter-5-color-palettes)
- [Moawling's color palette process](https://twitter.com/i/moments/948249159425056769)

### Animation
- [Walking animation cycle in games](https://finalbossblues.com/walk-cycles-p1/)
- [Tips for animating 2D games](http://www.gamasutra.com/view/news/176663/5_tips_for_making_great_animations_for_2D_games.php)

## Books
- [Pixel logic](https://gumroad.com/l/pixel-logic) - Pixel Logic 是一本深入的像素艺术教程书.
- [Make Your Own Pixel Art](https://nostarch.com/pixelart) - 逐步引导您了解可用的工具、像素艺术技术、形状、颜色、阴影的重要性，以及如何将您的艺术转化为动画.

## Inspiration
### Games
- [Super Mario World 2: Yoshi's Island](https://en.wikipedia.org/wiki/Yoshi%27s_Island)  - 扮演 Yoshi 带着 Baby Mario，穿越危险的世界. 绘画感和柔和的柔和色彩营造出一种温馨的手工风格，散发着儿童读物的魅力.
- [FEZ](http://www.fezgame.com/)  - 通过在三维空间中旋转来探索 2D 复古未来世界. 简约的风格、鲜艳的色彩和动态的灯光将 16 位时代带入了未来.
- [Superbrothers: Sword & Sworcery EP](http://www.swordandsworcery.com/)  - 在青铜时代的山区荒野中悠闲冒险. 受月相影响的生活世界中梦幻般柔和的色彩.
- [Shovel Knight: Treasure Trove](http://yachtclubgames.com/shovel-knight/) - 具有 8 位复古美学的经典动作冒险，采用现代 NES 游戏的外观.
- [Hyper Light Drifter](https://heartmachine.com/hyper-light)  - 在散发着光明和温暖的科幻世界中自上而下的行动. 使用色彩缤纷的调色板和千变万化的霓虹灯，营造出阴森森的氛围.
- [Owlboy](http://www.owlboygame.com/)  - 在云端探索详细的蒸汽朋克世界. 凭借一系列可爱的动画和表情，世界和角色变得栩栩如生.
- [Stardew Valley](https://stardewvalley.net/) - 从自上而下的角度管理农场，并在 16 位中融入迷人而欢快的世界.
- [Starbound](https://playstarbound.com/) - 穿越充满活力、色彩缤纷且广阔的星系，包括富有创意的动态动画.
- [Void Golf](https://cactusmancer.itch.io/void-golf) - 在极简主义的自上而下视图中使用引力场、反物理墙和虫洞将巨大的太空岩石射入黑洞.
- [Minit](https://www.devolverdigital.com/games/minit)  - 采用简约设计（只有两种调色板）.  Minit 是一次冒险，每次探索旅程都被限制在 60 秒以内.

### Videos
- [Sean Browning - Pixel Art Animation Reel 2018](https://vimeo.com/250991452) - 一系列 Sean Browning 的像素动画，从简单的场景到 Steven&#39;s Universe 和 RWBY 等热门节目的再现.
- [Pixel Paul - An Interview with Pixel Artist and Animator Paul Veer](https://vimeo.com/68038321) - 从事 Super Crate Box 等游戏工作的专业像素艺术家 Paul Veer 分享了他对像素艺术的兴趣以及他的工作流程和风格分解.
- [MortMort channel](https://www.youtube.com/channel/UCsn9MzwyPKeCE6MEGtMU4gg) - 创意视频和流，包括提示、讨论和教程.

### Other
- [Lospec palette list](https://lospec.com/palette-list) - 像素艺术调色板的集合，带有示例和艺术家信息.

## Community

### Artists
- [eBoy](http://hello.eboy.com/eboy/)  - 德国像素艺术团体，由 Kai Vermehr、Steffen Sauerteig 和 Svend Smital 于 1997 年创立. 他们被誉为“像素艺术教父”.
- [Paul Robertson](http://probertson.tumblr.com/) - 澳大利亚人，创造可爱的、有时是宇宙和迷幻的、有时是怪异的噩梦般的像素艺术.
- [Syosa](http://collet66.blog52.fc2.com/) - 日本少女风格，使用明亮有机的调色板创造可爱的人类和动物.
- [Thomas Feichtmeir](http://cyangmou.deviantart.com/) - 澳大利亚、黑暗和成熟：骑士、恐龙、海盗、史诗野兽、解剖学和历史以及一切扭曲和怪异的事物的粉丝.
- [Toyoi Yuuta](http://1041uuu.tumblr.com/) - 澳大利亚人，用不饱和的颜色捕捉日常生活中的小动画场景.
- [Slynyrd](https://www.patreon.com/slynyrd) - 美国游戏设计师，拥有大量材料、游戏特定知识和迷你教程.

### Hubs
- [Reddit /r/PixelArt](https://www.reddit.com/r/PixelArt/)
- [Pixelation](http://pixelation.org/)
- [Pixel Joint](http://pixeljoint.com/)

## Tools

### Editors
- [Aseprite](http://aseprite.org/)  - 付费且源代码可用，适用于 Linux、macOS 和 Windows. 很棒的用户界面，有很多漂亮的工具来简化像素艺术创作.
- [Pixen](https://pixenapp.com/)  - 付费，适用于 macOS 和 iOS. 出色的操作系统集成，使用压力感应绘图在平板电脑上创建像素艺术.
- [Pro Motion](http://www.cosmigo.com/pixel_animation_software)  - 付费试用，适用于 Windows. 专为游戏创建像素艺术而设计的高级功能.
- [GIMP](https://www.gimp.org/)  - 开源且免费，适用于 Linux、macOS 和 Windows. 不是专门用于创建像素艺术，但完全有能力这样做.
- [PixelCraft](https://rgab1508.github.io/PixelCraft/)  - 开源且免费，可在浏览器中使用. 易于在浏览器中试用并作为离线 PWA.
- [rx](https://rx.cloudhead.io/)  - 开源且免费，适用于 Linux、macOS 和 Windows. 极简主义和键盘驱动，支持动画.
- [Wobblepaint](https://www.lexaloffle.com/bbs/?tid=40058) - Pico8 编辑器，通过一点点摆动赋予像素艺术以生命.

### Miscellaneous
- [Broider](https://maxbittker.github.io/broider/) - 制作 9 补丁边框，导出为 CSS.
- [pixeldudesmaker](https://0x72.itch.io/pixeldudesmaker) - 小型角色生成器，包括基本动画.
