<div class="github-widget" data-repo="ecohealthalliance/awesome-parasite"></div>
Awesome Parasite [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
=========

> A curated list of amazingly awesome information and open-access databases related to parasites and host-pathogen interactions. 

Parasites are unique organisms studied in a variety of disciplines due to their health burden, diversity, and complex ecologies. 

Awesome parasite was created by [Anna Willoughby](https://arw36.github.io/) and is maintained in partnership with [EcoHealth Alliance](https://github.com/ecohealthalliance/awesome-parasite/blob/master/www.ecohealthalliance.org). Contributions welcome, please read the [contributing guidelines](https://github.com/ecohealthalliance/awesome-parasite/blob/master/contributing.md). 

- - -
## Databases
* [Arbovirus Catalog (ARBOCAT)](https://wwwn.cdc.gov/arbocat/) - The CDC-curated arbovirus information including dates of first isolation and wildlife hosts.
* [Arctos](http://arctos.database.museum/SpecimenSearch.cfm) - A collective management database for museum specimens. See below for specific collections. Data includes locality and collection dates, and is downloadable for any registered accounts. 
* [Benesh et al. 2017, Ecology](https://esajournals.onlinelibrary.wiley.com/doi/full/10.1002/ecy.1680) - Extensive database with 8,510 host species associations of parasites with complex life cycles (acanthocephalans, cestodes, and nematodes). Includes life‐history data such as development time and body size for each life cycle stage of the parasites.
* [ENHanCEd Infectious Diseases Database (EID2)](https://eid2.liverpool.ac.uk/) - A database that pulls organism associations from NCBI sequences and PubMed. See database and brief analysis in [Wardeh et al. 2015](https://www.nature.com/articles/sdata201549).
* [Global Biotic Interactions (GloBI)](https://www.globalbioticinteractions.org/data.html) - A species interaction repository that can be searched by 'parasite of', 'pathogen of', or 'host of'.
* [Global Mammal Parasite Database 2.0](https://esajournals.onlinelibrary.wiley.com/doi/full/10.1002/ecy.1799) - A database of the parasites of wild ungulates (artiodactyls and perissodactyls), carnivores, and primates.
* [Human Virus Database (HVD)](http://computationalbiology.cn/humanVirusBase/#/) - A database of human viruses, including information on infected tissues. See description and use in a predictive model in [Ye et al. 2022](https://academic.oup.com/bioinformatics/article-abstract/38/11/3087/6569817?redirectedFrom=fulltext)
* [Interaction Web Data (iwdb)](https://iwdb.nceas.ucsb.edu/resources.html#host_parasite) - Collation of fish host and parasites datasets from several Canadain liminological sites, including information on prevalence and intensity. Part of a larger database of species interactions in food webs and plant relationships originally developed in 2003 by NCEAS and is now hosted by the Department of Ecology at the University of São Paulo, Brazil.
* [MalAvi](http://130.235.244.92/Malavi/) - A database of avian blood parasites from the Plasmodium, Haemoproteus and Leucocytozoon genera including select host and vector information. See database description by [Bensch et al. 2009](https://onlinelibrary.wiley.com/doi/pdf/10.1111/j.1755-0998.2009.02692.x).
* [NHM Host-parasite database](http://www.nhm.ac.uk/research-curation/scientific-resources/taxonomy-systematics/host-parasites/) - A database of parasitic worms extracted from the scientific literature maintained by London Natural History Museum. Compilation started in 1922 by Dr H.A. Baylis, with curation through 2003 by LNHM staff. [Wells et al. 2018](http://nicholasjclark.weebly.com/uploads/4/4/9/4/44946407/wells_etal_2018_globchangbiol.pdf) provides a broad analysis of this database, and you can access data through the R package [helminthR](https://github.com/ropensci/helminthR). 
* [Olival et al. 2017, Nature](https://zenodo.org/record/807517#.Wv7kuFMvzOQ) - Mammal-virus database with [analysis](https://www.nature.com/articles/nature22975?sf90794030). 
* [PEARL](http://pearl.berkeley.edu/) - Conservation assessments of macroparasitic invertebrates.
* [PHI-base](http://www.phi-base.org/index.jsp) - A database with information on specific genes of fungal, Oomycete and bacterial pathogens that affect pathogenicity. Focused on agricultural and medical pathogens of importance. 
* [PREDICT](http://data.predict.global/) - Field data from the USAID PREDICT project 2008-2019, a global emerging virus surveillance program. This data is downloadable if you have a healthmap account. 
* [Shaw et al. 2020](https://figshare.com/articles/The_phylogenetic_range_of_bacterial_and_viral_pathogens_of_vertebrates_dataset_and_supplementary_material/8262779) - A human-curated database of 12,212 host-pathogen associations: 2,595 bacterial and viral pathogens infecting 2,656 vertebrate host species across 90 host orders. It also contains a mitochondrial genome phylogeny for the host species. [Analysis](https://onlinelibrary.wiley.com/doi/10.1111/mec.15463) published in Molecular Ecology.
* [Virus-Host DB](http://www.genome.jp/virushostdb/view/) - A synthesis of host-virus associations from genomes posted in NCBI/RefSeq and GenBank.
* [Web of Life](https://www.web-of-life.es/) -  An aggregated resource and graphical user interface for easily visualizing and downloading data on ecological networks, including host-parasite interactions. As of January 2024, the host-parasite communities are exclusively gleaned from [Hadfield et al. 2013](https://www.journals.uchicago.edu/doi/full/10.1086/674445) whose original data files are provided on [Dryad](https://datadryad.org/stash/dataset/doi:10.5061/dryad.jf3tj). 
* [Zover](http://www.mgc.ac.cn/cgi-bin/ZOVER/main.cgi) - A conglomeration of the previous bat ([DBatVir](https://github.com/ecohealthalliance/awesome-parasite/blob/master/www.mgc.ac.cn/DBatVir)) and rodent virus ([DRodVir](http://www.mgc.ac.cn/DRodVir/)) databases with the addition of mosquito- and tick- borne viruses. Database is described [here](https://academic.oup.com/nar/advance-article/doi/10.1093/nar/gkab862/6389491?login=true).

## Museums & Collections
* [Biological Collections of Oswaldo Cruz Institute in Rio de Janeiro, Brazil](https://portal.fiocruz.br/en/biological-collections) - scientific institution with the largest [helminth collection](http://chioc.fiocruz.br/catalogue) in Latin America with nearly 40,000 specimens. The institute also houses several other open-access catalogues of [protozoa](http://colprot.fiocruz.br/index?catalogue) and [medically important vector species](http://cavaisc.fiocruz.br/catalogue).
* [Denver Museum of Nature and Science](https://science.dmns.org/integrative-collections/dmns-zoology-collections/) - Collection of mammalian ecto- and endo- parasites primarily focused on the Rocky Mountain and Great Plains regions of the United States. Accessible through [Arctos](http://arctos.database.museum/SpecimenSearch.cfm). 
* [Harold W. Manter Laboratory of Parasitology Collection](http://hwml.unl.edu/resources/database-68) - Specimen collection focused "on the helminth parasites of mammals of the Nearctic and Neotropical regions stressing studies of the phylogeny and diversity of parasites of Rodentia, Marsupialia, Xenarthra, and Chiroptera." The archive site for the [American Society of Parasitologists](https://www.amsocparasit.org/). Accessible through [Arctos](http://arctos.database.museum/SpecimenSearch.cfm). 
* [Invertebrates Collection of the Swedish Museum of Natural History](https://www.nrm.se/english/researchandcollections/zoology/collections/invertebrates.305_en.html) - Swedish Museum with collection of >10,000 flatworms, >2,000 nematodes, and select other parasite groups. Accessible through [GBIF](https://www.gbif.org/dataset/56aa0680-0c60-11dd-84cd-b8a03c50a862).
* [Invertebrate Zoology collection of the Museum of Texas Tech University](https://www.depts.ttu.edu/nsrl/collections/Invertebrate_Zoology/index.php) - Previously the Medical Zoology Collection, a portion of this collection includs endo- and ecto-parasites of medical and veterinary importance. Accessible through [GBIF](https://www.gbif.org/dataset/13fdfab7-e281-428d-8c1f-e72eb7398e97).
* [Meguro Parasite Museum](https://www.kiseichu.org/e-top) - Museum in Tokyo, Japan focused on human parasites with over 60,000 specimens. Data is not digitized, though the museum's founder, Dr. S. Yamaguti, described many of the specimens in 10 volumes of [Systema Helminthum](https://www.worldcat.org/title/systema-helminthum/oclc/427905372/editions?editionsView=true&referer=br). Collections primarily from Japan, Indonesia and Hawaii. 
* [Muséum National d'Histoire Naturelle (MNHN - Paris)](https://www.mnhn.fr/en/collections/collection-groups/marine-invertebrates/parasitic-worms-helminths) - Helminth collection with more than 30,000 occurences of helminths with particular focus in tropical regions. Accessible through [GBIF](https://www.gbif.org/dataset/e0ebf2a1-3656-468a-b0b6-1aa93ff43fef#description). 
* [Museum of Southwestern Biology, Division of Parasites](https://msb.unm.edu/divisions/parasites/index.html) - Specimen collection of parasites amphibians, reptiles, birds, and mammals. Particular focus on parasites of small mammals in high altidude locations and Sevilleta Long Term Ecological Research Station in New Mexico, and parasites of seabirds in the artic and Antartica. Accessible through [Arctos](http://arctos.database.museum/SpecimenSearch.cfm). 
* [Ohio State University Acarology Collection](https://acarology.osu.edu/database) - Nearly 70,000 vouchered specimens of mites from around the globe starting from 1864. Information includes host species, collection gps points, collection location (e.g. ear), and collection method. Can also be accessed through [GBIF](https://www.gbif.org/dataset/96b54e8c-f762-11e1-a439-00145eb45e9a).
* [South Australian Museum’s Australian Helminthological Collection](http://www.samuseum.sa.gov.au/collections/biological-sciences/parasites/the-australian-helminthological-collection-database) - Downloadable excel document of nearly 50,000 specimens of helminths primarily from Australian vertebrates. Most specimens are Platyhelminths, Acanthocephala, or Nematoda from mammals, birds, or Elasmobranchii. Some specimens are included in the [LNHM database](http://www.nhm.ac.uk/research-curation/scientific-resources/taxonomy-systematics/host-parasites/) and accessible through [helminthR](https://github.com/ropensci/helminthR). 
* [The International Outbreak Museum](http://www.outbreakmuseum.com) - Museum focused on human food-borne outbreaks, with each [exhibit](http://www.outbreakmuseum.com/exhibits/) being a different historical outbreak. Part of [The Northwest Center for Foodborne Outbreak Management, Epidemiology, and Surveillance](https://health.oregonstate.edu/fomes). 
* [U.S. National Parasite Collection](https://www.nal.usda.gov/exhibits/speccoll/exhibits/show/parasitic-diseases-with-econom/u-s--national-animal-parasite-) - Specimen collection maintained by USDA that focuses on agriculturally important helminths and protozoans from North America. Accessible through [Arctos](http://arctos.database.museum/SpecimenSearch.cfm). 

## Citizen Science Projects 
 * [Garden Wildlife Health](https://www.gardenwildlifehealth.org) - This is a UK collaborative project between the Zoological Society of London (ZSL), the British Trust for Ornithology (BTO), Froglife and the Royal Society for the Protection of Birds (RSPB) that historically has been running since the 1980's (previously as Garden Bird Health initiative and Frog Mortality Project). Citizens can submit sickness and mortality reports, as well as animal wildlife samples, for wild birds, amphibians, reptiles, and hedgehogs. 
 * [Project Monarch Health](https://www.monarchparasites.org/) - A citizen science project running since 2006 to test adult monarch butterflies from the U.S. and Canada for the protozoan parasite _Ophryocystis elektroscirrha_. Participants submit spore samples collected from adult abdomems with tape for laboratory assessment at University of Georgia. 

## Reporting Systems 
* [EMPRES-i+ Global Animal Disease Information System](https://empres-i.apps.fao.org/) - A web platform maintained by FAO that provides geolocated data on animal diseases such as rabies, foot-and-mouth disease, or MERS coronavirus. This is a tracking service in which countries and veterinarians can opt-in to reporting.  
* [Healthmap](https://www.healthmap.org/en/) - A web platform that provides infectious disease outbreak alerts for humans and animals.
* [NORS](https://wwwn.cdc.gov/norsdashboard/) - A web platform that provides human foodborne, waterborne, and other enteric infectious disease outbreaks  for the United States. Available from 1971. 
* [Program for Monitoring Emerging Diseases (ProMed)](http://www.promedmail.org/) - An early warning of outbreaks of emerging and re-emerging diseases. Sources of information include media reports, official reports, online summaries, local observers, and others. [EIDR-Connect](https://eidr-connect.eha.io/events/auto) parses ProMed reports into disease outbreak events, curated by disease experts. 
* [The Contagion Outbreak Monitor](https://www.contagionlive.com/outbreak-monitor) - An interactive map of human bloodborne or foodborne outbreaks in the past two years. Targeted to practitioners and clinicians. 
* [WHISPers](https://whispers.usgs.gov/) - Wildlife Health Information Sharing Partnership event reporting system managed by USGS National Wildlife Health Center. Events of North American wildlife mortality (death) and morbidity (illness) involving five or more individuals are reported. 
* [World Animal Health Information System (WAHIS)](http://www.oie.int/wahis_2/public/wahid.php/Diseaseinformation/reportarchive) - The OIE archive of country alerts and regular reports of certain pathogens. They also have some nice interfaces to show disease distribution and timelines.
 
## Taxonomy
* [GBIF Backbone Taxonomy](https://www.gbif.org/en/dataset/d7dddbf4-2cf0-4f39-9b2a-bb099caae36c) - Aggregation and synonymization of taxonomy for animals, bacteria, protozoa, and viruses that synthesizes 56 taxonomy sources.
* [ICTV](https://talk.ictvonline.org/taxonomy/) - The viral taxonomy authority with excellent archives and [open reports](https://talk.ictvonline.org/ictv-reports/).
* [IUCN Redlist](http://www.iucnredlist.org/) - Online database that provides taxonomic information for wild hosts. You can use the R package `rredlist` and the [API](http://apiv3.iucnredlist.org/api/v3/docs) to access the data directly. 
* [Mammal Diversity Database](https://www.mammaldiversity.org/) - Mammal taxonomic authority maintained by American Society of Mammalogists. Versions are updated and recorded on Zenodo. Full desrciption by [Burgin et al. (2018)](https://academic.oup.com/jmammal/article/99/1/1/4834091?login=false). 
* [NCBI Taxonomy](https://www.ncbi.nlm.nih.gov/taxonomy) - The Taxonomy Database is a curated classification and nomenclature for all of the organisms in the public sequence databases, both parasites and hosts.

## Scientific Journals 
* [American Journal of Tropical Medicine and Hygiene](http://www.ajtmh.org/) - AJTMH publishes a broad range of papers covering topics in tropical medicine. Their archive is open-access after a 12-month embargo.
* [Annals of Parasitology](https://annals-parasitology.eu/go.live.php/PL-H54/archive.html) - Open-access scientific journal of the Polish Parasitological Society, formerly _Wiadomości Parazytologiczne_, that publishes issues quarterly. Open archives start from 2002. 
* [EFSA Journal](https://efsa.onlinelibrary.wiley.com/journal/18314732) - Open-access journal of the European Food Safety Authority with yearly reports of food-borne outbreaks and cases of zoonotic agents and antibiotic resistance emergence in humans and animals. 
* [Emerging Infectious Diseases](https://wwwnc.cdc.gov/eid/) - The CDC open-access journal.
* [Journal of the Egyptian Society of Parasitology](https://jesp.journals.ekb.eg/) - Open-access (2013 - present) scientific journal of The Eyptian Society of Parasitology. Published since the 1970s, their archive is indexed in Pub-Med since 1972 (Index Medicus ISSN: 0253-5890).
* [Journal of Wildlife Diseases](http://www.jwildlifedis.org/loi/jwdi) - JWD provides many open-access articles on new parasite expansions or discoveries.
* [Mitteilungen der Österreichischen Gesellschaft für Tropenmedizin und Parasitologie](https://www.zobodat.at/publikation_series.php?id=1351) - 23 open access volumes (1971-2001) of the scientific journal of the Austrian Society for Tropical Medicine and Parasitology.
* [Parasite](https://www.parasite-journal.org/) - Open access journal associated with the Société Française de Parasitologie. Focuses on both animal and human parasites.  
* [Parasitologia Hungarica](http://publication.nhmus.hu/parasitologia/bannales.php?volume=1) - 31 open-access volumes (1960-1998) of Parasitologia Hungarica, a scientific journal hosted by the Hungarian Natural History Museum.
 

## License
<a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/by-nc.svg" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a>.
