<div class="github-widget" data-repo="44bits/awesome-opensource-documents"></div>
## Awesome Open Source Documents

这不是免费编程书籍的列表. 这是一个精选的开源或开源许可文档、指南和书籍列表，可以在相同的许可下阅读、使用、修改、翻译、重新分发甚至重写.

## Document Template

```
作者的 [标题][存储库 url]（[站点][站点 url]，许可证）- 简短说明
```



<a name='subjects'></a>
## Subjects
<a name='computer_science'></a>
### Computer Science

* [Crypto 101][repo-crypto-101] ([Site][site-crypto-101], cc-nc) - 密码学入门书
* [操作系统开发小书][repo-littleosbook] ([站点][site-littleosbook], cc-nc-sa) - 这是《操作系统开发小书》一书的源代码
* 如何设计程序 ([Site][site-htdp], cc-nc-nd)
* 计算机程序的结构和解释（[Site][site-sicp]，cc-sa）
* 编程语言：应用与解释（[Site][site-plai], cc-nc-sa）
* 编程语言实用基础 ([Site][site-pfpl], cc-nc-nd)
* Algorithms, Etc. ([Site][site-algorithm-etc], cc-nc-sa) - 此页面包含 Jeff Erickson 在伊利诺伊大学香槟分校任教的各种算法课程的讲义和其他课程材料.
* Introduction to Theory of Computation ([Site][site-michiel-computation], cc-sa) - 这是计算理论本科课程的免费教科书，自 2002 年以来我们一直在卡尔顿大学教授该课程
* Discrete Structures for Computer Science: Counting, Recursion, and Probability ([站点][site-michiel-structures], cc-nc-sa) - 这是一本关于计算机科学离散结构本科课程的免费教科书，我自 2013 年以来一直在卡尔顿大学任教
 * [graphbook][repo-graphbook] (GNU-FDL) - David Joyner、Minh Van Nguyen 和 David Phillips 编写的关于算法图论的 GNU-FDL 书籍. 这是一本算法图论的入门书
* [操作系统和中间件：支持受控交互][repo-operating-middleware] ([Site][site-operating-middleware] cc-sa) - 关于操作系统原理的免费、可修改教科书
* Programming on Parallel Machines ([Site][site-parallel-machine], cc-nd) - 本书的目的是帮助您在不危及您的理智的情况下对共享内存并行机进行编程
* [Is Parallel Programming Hard, And, If So, You Can Do About It?][repo-perfbook] ([Site][site-perfbook], cc-sa) - 这本书的目的是教新程序员和科学家关于高性能计算的基础知识
* 高性能计算（[站点][站点高性能计算]，抄送）
* Natural Language Processing for the Working Programmer ([Site][site-nlpwp], cc) - 我们将深入研究所谓的计算语言学家用来分析人类语言结构并将其转化为某种形式的许多技术与计算机一起工作
* Fundamentals of Programming: With Object Oriented Programming ([Site][site-funop], cc-nc-sa) - 这本书提供了一种平衡而灵活的方法，将面向对象的原则纳入使用 Python 的入门课程
 * Introduction to Computing ([Site][site-introtocom], cc-nc-sa) - 这本书使用 Scheme 和 Python 编程语言介绍了计算中最重要的思想. 它着重于如何通过定义程序来描述信息过程，如何分析执行程序所需的成本，以及可以和不能机械计算的基本限制
 * [Computer Science from the Bottom Up][repo-csftbu] ([Site][site-csftbu], cc-sa) - Computer Science from the Bottom Up — 一本免费的在线书籍，旨在从底层教授计算机科学向上. 涵盖的主题包括二进制和二进制逻辑、操作系统内部、工具链基础知识和系统库基础知识
* [Problem Solving with Algorithms and Data Structures][repo-psads]​​ ([Site][site-psads]​​, cc-nc-sa) - 使用 Python 使用算法和数据结构解决问题的示例和工作
* Data Compression Explained ([Site][site-dce], custom liscense) - 本书适合想要了解数据压缩工作原理或想要编写数据压缩软件的读者.

[网站-dce]：http://mattmahoney.net/dc/dce.html
[repo-psads]​​：https://github.com/ErikRHanson/Problem-Solving-with-Algorithms-and-Data-Structures-Using-Python
[站点 psads]​​：http://interactivepython.org/runestone/static/pythonds/index.html
[repo-csftbu]: https://github.com/ianw/bottomupcs
[网站-csftbu]：http://www.bottomupcs.com/
[网站介绍]：http://www.computingbook.org/
[site-funop]: https://books.google.lk/books?printsec=frontcover&id=TZ-qjncsv6QC&hl=ko#v=onepage&q&f=false
[网站-pfpl]：http://www.cs.cmu.edu/~rwh/plbook/
[网站页面]：http://cs.brown.edu/~sk/Publications/Books/ProgLangs/2007-04-26/
[站点 sicp]：https://mitpress.mit.edu/sicp/full-text/book/book.html
[网站-htdp]：http://www.ccs.neu.edu/home/matthias/HtDP2e/
[网站-crypto-101]：https://www.crypto101.io/
[repo-crypto-101]：https://github.com/crypto101/book
[repo-littleosbook]：https://github.com/littleosbook/littleosbook
[站点-littleosbook]：http://littleosbook.github.io/
[站点 ods]：http://opendatastructures.org/
[repo-ods]: https://github.com/patmorin/ods
[网站算法等]：http://jeffe.cs.illinois.edu/teaching/algorithms/
[站点-michiel-结构]：http://cglab.ca/~michiel/DiscreteStructures/
[网站-michiel-computation]：http://cglab.ca/~michiel/TheoryOfComputation/
[repo-graphbook]：https://code.google.com/p/graphbook/
[站点操作中间件]：https://gustavus.edu/+max/os-book/
[repo-operating-middleware]：https://github.com/Max-Hailperin/Operating-Systems-and-Middleware--Supporting-Controlled-Interaction
[站点并行机]：http://heather.cs.ucdavis.edu/parprocbook
[repo-perfbook]：https://github.com/sbinet/perfbook
[站点性能手册]：https://www.kernel.org/pub/linux/kernel/people/paulmck/perfbook/perfbook.html
[站点高性能计算]：http://open.umich.edu/education/si/resources/hpc-opentextbook/2009
[网站-nlpwp]：http://nlpwp.org/book/

<a name='data_science'></a>
### Data Science and Statistics

* [Think Stats][repo-thinkstats] ([Site][site-thinkstats], cc-sa) - 程序员的概率和统计
* 神经网络简介 ([Site][site-abinn], cc-nc-nd)
* 大众数据挖掘 ([PDF][site-dmftm], cc)
* [Bayesian Methods for Hackers][repo-baymh]（[Site][site-baymh]，麻省理工学院） - 从计算/理解第一，数学第二的角度介绍贝叶斯方法和概率编程
* 统计软件杂志（[站点][site-jstatsoft]，cc-by）
* [The Book Of Jupyter][repo-jupyter-book] ([Site][site-jupyter-book], cc) - 这是涵盖高级 Jupyter/IPython SciPy 教程的一些材料，现在/过去/将来2015年7月给予

[repo-jupyter-book]：https://github.com/Carreau/jupyter-book
[site-jupyter-book]: https://carreau.gitbooks.io/jupyter-book/content/
[网站-jstatsoft]：http://www.jstatsoft.org/index
[site-baymh]：http://camdavidsonpilon.github.io/Probabilistic-Programming-and-Bayesian-Methods-for-Hackers/
[repo-baymh]：https://github.com/CamDavidsonPilon/Probabilistic-Programming-and-Bayesian-Methods-for-Hackers
[site-dmftm]:http://docs.rapidminer.com/downloads/DataMiningForTheMasses.pdf
[site-abinn]: http://www.dkriesel.com/en/science/neural_networks
[repo-thinkstats]：https://github.com/AllenDowney/ThinkStats2
[网站-thinkstats]：http://greenteapress.com/thinkstats/
[repo-leads]：https://github.com/nborwankar/LearnDataScience

<a name='devops'></a>
### Devops

* [Ops School Curriculum][repo-ops-school] ([Site][site-ops-school], cc) - Ops School 是一个全面的项目，可以帮助你学习成为一名运维工程师
* [Twelve Factor App][repo-twelve-factor] ([Site][site-twelve-factor], MIT) - 十二因素应用程序是构建软件即服务应用程序的方法
* Digital Oceans - 教程 ([Site][site-do-tutorials], cc-nc-sa) - 开发和系统管理员教程
* [.htaccess 片段][repo-htaccess]（公共领域）- 一组有用的 .htaccess 片段，全部集中在一个地方.
* [Travis CI][repo-travis-docs] ([Site][site-travis-docs], MIT) - Travis 文档
* [CoreOS 文档][repo-coreos]（[站点][site-coreos]，Apache 2.0）- CoreOS 文档
* [Packer Documentation][repo-packer] ([Site][site-packer], MPL) - Packer 文档
* [命令行的艺术][repo-art-command-line] (cc-sa) - 在一页中掌握命令行
* [命令行文本处理][repo-cli-text-processing] ([Site][site-cli-text-processing], cc-nc-sa) - 从查找文本到搜索替换，从排序到美化文本和更多
* [Linux Command Line][repo-linux-cli] ([Site][site-linux-cli], cc-nc-sa) - Linux 命令和 Shell 脚本简介

[repo-linux-cli]：https://github.com/learnbyexample/Linux_command_line
[站点-linux-cli]：https://learnbyexample.gitbooks.io/linux-command-line/content/index.html
[repo-cli-text-processing]：https://github.com/learnbyexample/Command-line-text-processing
[站点-cli-文本处理]：https://learnbyexample.gitbooks.io/command-line-text-processing/content/
[回购艺术命令行]：https://github.com/jlevy/the-art-of-command-line
[回购打包机]：https://github.com/mitchellh/packer/tree/master/website/source/docs
[站点打包器]：https://www.packer.io/docs/
[网站-coreos]：https://coreos.com/docs/
[repo-coreos]：https://github.com/coreos/docs/
[site-travis-docs]: https://docs.travis-ci.com/
[repo-travis-docs]：https://github.com/travis-ci/docs-travis-ci-com
[回购十二因素]：https://github.com/heroku/12factor
[站点十二因素]：http://12factor.net/
[回购 htaccess]：https://github.com/phanan/htaccess
[网站教程]：https://www.digitalocean.com/community/tutorials
[站点操作学校]：http://ops-school.readthedocs.org/en/latest/
[repo-ops-school]：https://github.com/opsschool/curriculum

<a name='mathematics'></a>
### Mathematics & Physics

* [同伦类型理论][repo-hott-book] ([Site][site-hott-book], BSD) - 同伦类型理论是 Martin-Löf 的内涵类型理论对抽象同伦理论的解释.
* [Collision Detection][repo-jeff-collision] ([Site][site-jeff-collision], cc-nc-sa) - 一本关于碰撞检测的书和例子

[repo-jeff-collision]：https://github.com/jeffThompson/CollisionDetection
[站点杰夫碰撞]：http://www.jeffreythompson.org/collision-detection/
[repo-hott-book]：https://github.com/HoTT/HoTT
[site-hott-book]：http://homotopytypetheory.org/


<a name='open_source'></a>
### Open Source

* [开源应用的架构1][repo-aosa] ([站点][site-aosa], cc-nc-sa)
* [开源应用的架构2][repo-aosa] ([站点][site-aosa], cc-nc-sa)
* [开源应用的性能][repo-aosa] ([站点][site-aosa], cc-nc-sa)
* [Free Software Free Society: Selected Essays][repo-fsfs] ([Site][site-fsfs], GNU-FDL) - 开源应用程序的架构
* [Free as in Freedom (2.0)][repo-free-freedom-2] ([Site][site-free-freedom-2], GNU-FDL) - Free as in Freedom (2.0) 是 Stallman 对原始传记.
* The Daemon, the GNU &amp; the Penguin ~ by Dr. Peter Salus ([Site][site-tdtgtp], cc-nc-nd)

[repo-free-freedom-2]：http://bzr.savannah.gnu.org/lh/books/changes
[site-free-freedom-2]：http://shop.fsf.org/product/free-as-in-freedom-2/
[网站-tdtgtp]：http://www.groklaw.net/staticpages/index.php?page=20051013231901859
[网站-fsfs]：http://shop.fsf.org/product/free-software-free-society-2/
[repo-fsfs]：http://bzr.savannah.gnu.org/lh/books/changes
[site-aosa]: http://aosabook.org/en/index.html
[repo-aosa]: https://github.com/aosabook/aosabook


<a name='progromming'></a>
### Programming

* [500 行或更少][repo-500 行] (cc &amp; mit) - 这是 500 行或更少这本书的来源，是开源应用程序体系结构系列的第四本.
* [Guides][repo-thoughtbot-guides] (cc) - 完成工作、良好编程和风格化编程的指南.
* [An App Launch Guide][repo-app-launch-guide]（[Site][site-app-launch-guide]，Public Domain）——本指南介绍了验证、构建、营销的所有必要步骤，并发布您的产品，特别专注于应用程序开发.
* [初学者逆向工程][repo-refb-book]（[站点][site-refb-book]，cc-nc-nd）——讨论的主题：x86/x64、ARM/ARM64、MIPS、Java/JVM.
* [Build Podcast][repo-build-podcast] ([Site][site-build-podcast], Public Domain) - Build Podcast 是一个关于设计和开发技术工具的节目，所有这些都本着黑客的有趣精神，创造和建设的东西！
* Mozilla Developer Network ([Site][site-mdn], cc-by-sa) - 开放网络的共享知识
* [The Little Introduction To Programming][repo-tlitp] ([Site][site-tlitp], cc-nc) - 这本书将教你编程的基础知识，并作为你实现任何编程目标的基础.
* [The Programming Historian][repo-tphistorian] ([Site][site-tphistorian], cc) - The Programming Historian 是一个在线、开放访问、同行评审的教程套件，可帮助人文主义者学习广泛的数字工具、技术和工作流程，以促进他们的研究.
* [WHAT IS CODE?][repo-what-is-code] ([Site][site-what-is-code], cc-nc-nd) - Paul Ford 的“What Is Code?”

[网站代码]：http://www.bloomberg.com/graphics/2015-paul-ford-what-is-code/
[repo-what-is-code]：https://github.com/BloombergMedia/whatiscode
[repo-tphistorian]：https://github.com/programminghistorian/jekyll
[网站-tphistorian]：http://programminghistorian.org/
[repo-tlitp]：https://github.com/karlseguin/the-little-introduction-to-programming
[网站-tlitp]：http://codingintro.com/
[网站-mdn]：https://developer.mozilla.org/en-US/
[repo-build-podcast]：https://github.com/sayanee/build-podcast
[网站建设播客]：http://build-podcast.com/
[repo-thoughtbot-guides]: https://github.com/thoughtbot/guides
[repo-refb-book]：https://github.com/dennis714/RE-for-beginners
[网站参考书]：http://beginners.re/
[repo-app-launch-guide]：https://github.com/adamwulf/app-launch-guide
[站点应用程序启动指南]：http://www.applaunchguide.com/

<a name='database'></a>
### Database

* [Elasticsearch - 权威指南][repo-elastic-dg] ([Site][site-elastic-dg], cc-nc-nd) - Elasticsearch 权威指南

[repo-elastic-dg]：https://github.com/elastic/elasticsearch-definitive-guide
[站点弹性 dg]：https://www.elastic.co/guide/en/elasticsearch/guide/current/index.html

<a name='world_wide_web'></a>
### World Wide Web

* [HTTP API 设计指南][repo-http-api] (cc) - 从 Heroku 平台 API 上的工作中提取的 HTTP API 设计指南
* [Dive Into HTML5][repo-diveintohtml5] ([Site][site-diveintohtml5], cc) - Dive Into HTML5 阐述了从 HTML5 规范和其他优秀标准中精心挑选的功能
* [Web Fundamentals][repo-web-fundamentles]（[Site][site-web-fundamentles]，Apache 2.0）——现代 web 开发的最佳实践
* [Code Guide][repo-code-guide] ([Site][site-code-guide], MIT) - 灵活、持久和可持续的 HTML 和 CSS 标准
* [HTML 最佳实践][repo-html-best] (cc0) - 用于编写可维护和可扩展的 HTML 文档
* [WebComponents.org][repo-webcomponents] ([Site][site-webcomponents], cc-sa) - 一个讨论和发展 Web 组件最佳实践的地方
* [How to lose weight (in the browser)][repo-browser-diet] ([Site][site-browser-diet], cc-sa, MIT) - 权威的前端性能指南
* [North][repo-north] ([Site][site-north], MIT) - MIT 设计和开发标准，以协调和指导您的项目.
* RESTful Web APIs ([Site][site-restful-web-apis], cc-nc-nd) - Restful Web APIs 是 RESTful 设计的第一本书，也是 RESTful Web APIs 的前身.
* DOM Enlightenment ([Site][site-domenlight], cc-nc-nd) - 探索 JavaScript 与现代 HTML DOM 之间的关系
* [http2 explained][repo-http2-explained] ([Site][site-http2-explained], cc-nc-nd) - http2 explained 是解释和记录 HTTP/2 的详细文档，它是广受欢迎的继承者HTTP/1.1协议
* RESTful API Guidelines ([Site][zalando-guidelines], cc) - Zalando 开发的全面的“API 优先”设计指南

[站点-http2-解释]：http://daniel.haxx.se/http2/
[repo-http2-explained]：https://github.com/bagder/http2-explained
[repo-browser-diet]：https://github.com/zenorocha/browser-diet
[网站浏览器饮食]：http://browserdiet.com/
[网站-domenlight]：http://domenlightenment.com/
[站点-restful-web-apis]：http://restfulwebapis.org/rws.html
[回购北]：https://github.com/north/north
[北站]：http://pointnorth.io/
[repo-webcomponents]: https://github.com/webcomponents/webcomponents.github.io
[站点网络组件]：http://webcomponents.org/
[repo-html-best]：https://github.com/hail2u/html-best-practices
[repo-web-fundamentles]：https://github.com/google/WebFundamentals/
[站点网络基础]：https://developers.google.com/web/fundamentals/
[回购代码指南]：https://github.com/mdo/code-guide
[站点代码指南]：http://codeguide.co/
[repo-diveintohtml5]：https://github.com/diveintomark/diveintohtml5
[网站-diveintohtml5]：http://diveintohtml5.info/
[repo-500-lines]：https://github.com/aosabook/500lines
[repo-http-api]：https://github.com/interagent/http-api-design
[zalando-指南]：https://zalando.github.io/restful-api-guidelines/index.html

<a name='writing_and_documentation'></a>
### Writing and Documentation

* [Write the Docs][repo-write-the-docs] ([Site][site-write-the-docs], cc) - Sphinx 文档和一般写作的地方.
* [The Hitchhiker&#39;s Guide to Documentation!][repo-thgtd] ([Site][site-thgtd], cc-nc-sa) - 本指南旨在提供有关创建文档的建议和最佳实践手册.
* [CommonMark Spec][repo-commonmark-spec] ([Site][site-commonmark-spec], cc-sa) - CommonMark 是 Markdown 语法的合理化版本，具有 C 和 BSD 许可的参考实现JavaScript.
* reStructuredText 标记规范（[站点][站点-rst-规范]，公共领域）
* [Prose for Programmers][repo-prose-prog] (cc-nc-nd) - 一本帮助软件开发人员编写更好的散文的书.

[repo-prose-prog]：https://github.com/joshuacc/prose-for-programmers
[repo-commonmark-spec]: https://github.com/jgm/CommonMark
[网站-commonmark-spec]：http://spec.commonmark.org/
[网站-rst-规范]：http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html
[网站-thgtd]：http://docs-guide.readthedocs.org/en/latest/
[repo-thgtd]：https://github.com/chrismedrela/docs-guide
[网站编写文档]：http://docs.writhedocs.org/
[repo-write-the-docs]：https://github.com/writethedocs/docs/

<a name='journalism_and_visualization'></a>
### Journalism and Visualization

* [Data Journalism Handbook][site-data-journalism-handbook] (cc-sa) - The Data Journalism Handbook 是一本免费的开源参考书，适合对新兴数据新闻领域感兴趣的任何人
* [D3.js 简介][repo-intro-to-d3]（[站点][site-intro-to-d3]，Apache 2.0）- 本教程提供了 D3.js 的快速介绍，这是一个 Javascript 库，用于在浏览器中创建数据可视化.
* [The Nature of Code][repo-natureofcode] ([Site][site-natureofcode], cc-nc, LGPL) - 本书重点介绍使用 Processing 对自然系统进行计算机模拟背后的编程策略和技术
* [Data Science 45-min Intros][repo-data-science-45min]（公共领域）- Ipython notebook 演示文稿，用于入门基本编程、统计和机器学习技术
* [Data + Design][repo-data-design] ([Site][site-data-design], cc-nc-sa) - 准备和可视化信息的简单介绍
* [D3 101 Screencasts][repo-d3-101-screencasts]（[Site][site-d3-101-screencasts]，麻省理工学院）- Curran Kelleher 的 D3.js screencasts
* [Thematic Cartography Guide][repo-themacg] ([Site][site-themacg], cc-nc) - 关于专题制图基本原则的简短、友好的指南.

[repo-themacg]：https://github.com/axismaps/thematic-cartography
[站点-themacg]：http://axismaps.github.io/thematic-cartography/
[site-d3-101-screencasts]：https://www.youtube.com/watch?v=iuA-gmvJ5n0&amp;list=PL9yYRbwpkykvjkfuRslECO9c1qTq3GgUb
[repo-d3-101-screencasts]：https://github.com/curran/screencasts/
[回购数据设计]：https://github.com/infoactive/data-design/
[站点数据设计]：https://infoactive.co/data-design
[repo-data-science-45min]：https://github.com/DrSkippy/Data-Science-45min-Intros
[repo-natureofcode]：https://github.com/shiffman/The-Nature-of-Code
[网站-natureofcode]：http://natureofcode.com/
[repo-intro-to-d3]：https://github.com/square/intro-to-d3
[站点介绍到 d3]：https://square.github.io/intro-to-d3/
[站点数据新闻手册]：http://datajournalismhandbook.org/1.0/en/

<a name='android_development'></a>
### Android Development

* Android Developers - API Guide ([Site][site-android-api-guide], cc) - Android 开发文档
* [Android 开发最佳实践][repo-android-bp] (cc) - Android 开发的注意事项，Futurice 开发人员

[repo-android-bp]：https://github.com/futurice/android-best-practices
[网站-android-api-指南]：http://developer.android.com/guide/index.html

<a name='ios_development'></a>
### IOS Development

* [iOS 良好实践][repo-ios-good-practices] (cc) - iOS 开发的好主意，由 Futurice 开发人员提供.
* [iOS Developer and Designer Interview Questions][repo-ios-questions] (MIT) - 一份小指南，可帮助那些希望为 iOS 工作聘请开发人员或设计师的人.

[repo-ios-questions]：https://github.com/CameronBanga/iOS-Developer-and-Designer-Interview-Questions
[repo-ios-good-practices]：https://github.com/futurice/ios-good-practices

<a name='subject-etc'></a>
### ETC

 * [Cocktails for programmers][repo-cocktails-for-programmer] (MIT) - 为程序员准备的鸡尾酒. 程序员的鸡尾酒.
* [Solarized][repo-solarized] ([Site][site-solarized], MIT) - 机器和人的精确颜色
* [ØMQ - 指南][repo-zguide] ([Site][site-zguide] cc-nc-sa) - 学习和使用 ØMQ
* [NPR Visuals 的最佳实践][repo-npr-bp] (cc) - NPR Visuals 团队的最佳实践和编码约定.
* [10up Engineering Best Practices][repo-10up-bp] ([Site][site-10up-bp], MIT) - 本指南规定了我们作为一家公司如何设计网站
* [Peco REAMDE][repo-peco] (MIT) - Peco 文档（简单的交互式过滤工具）
 * [在 Y 分钟内学习 X][repo-xyminutes] ([Site][site-xyminutes], cc-sa) - 旋风式浏览您下一个最喜欢的语言. 社区驱动！
* [RxMarbles][repo-rxmarbles] ([Site][site-rxmarbles], BSD) - Interactive diagrams of Rx Observables

[站点 rxmarbles]：http://rxmarbles.com/
[repo-rxmarbles]：https://github.com/staltz/rxmarbles
[repo-npr-bp]：https://github.com/nprapps/bestpractices
[网站-xyminutes]：https://learnxinyminutes.com/
[repo-xyminutes]：https://github.com/adambard/learnxinyminutes-docs
[回购片]：https://github.com/peco/peco
[repo-10up-bp]：https://github.com/10up/Engineering-Best-Practices
[站点 10up-bp]：https://10up.github.io/Engineering-Best-Practices/
[网站-zguide]：http://zguide.zeromq.org/
[repo-zguide]: https://github.com/imatix/zguide
[回购太阳能]：https://github.com/altercation/ethanschoonover.com/tree/master/projects/solarized
[网站太阳能化]：http://ethanschoonover.com/solarized
[repo-cocktails-for-programmer]：https://github.com/cocktails-for-programmers/cocktails_for_programmers

<a name="programming_languages"></a>
## Programming Languages

<a name='language-assembly'></a>
### Assembly

* [Some Assembly Required][repo-sar] (cc-sa) - 对 Assembly 的简单介绍

[回购 sar]：https://github.com/hackclub/some-assembly-required/

<a name='language-c'></a>
### C

* [C Style][repo-cstyle] (cc-sa) - 我最喜欢的 C 编程实践
* C Programming ([Site][site-c-programming], cc-sa) - 全面了解 C 编程语言及其特性

[repo-cstyle]: https://github.com/mcinglis/c-style
[站点-c-编程]：https://en.wikibooks.org/wiki/C_Programming

<a name='coffeescript'></a>
### Cofeescript

* [Cofeescript Cookbook][repo-coffee-cookbook] ([Site][site-coffee-cookbook], cc) - 社区的 CoffeeScript 食谱.

[站点咖啡食谱]：https://coffeescript-cookbook.github.io/
[repo-coffee-cookbook]：https://github.com/coffeescript-cookbook/coffeescript-cookbook.github.io

<a name='css'></a>
### CSS

* [Bootstrap][repo-bootstrap] ([Site][site-bootstrap], cc) - Bootstrap 是最流行的 HTML、CSS 和 JS 框架，用于在网络上开发响应式、移动优先的项目.
* [idiomatic CSS][repo-idiomatic-css] (cc) - 编写原则一致
* [Font Awesome][repo-font-awesome] ([Site][site-font-awesome], cc) - 标志性字体和 CSS 工具包

[repo-font-awesome]：https://github.com/FortAwesome/Font-Awesome/tree/master/src
[网站字体真棒]：http://fortawesome.github.io/Font-Awesome/
[网站引导]：http://getbootstrap.com/
[回购引导]：https://github.com/twbs/bootstrap/tree/master/docs
[repo-idiomatic-css]：https://github.com/necolas/idiomatic-css

<a name='fortran'></a>
### Fortran

* Introduction to Programming using Fortran 95 ([Site][site-ipufortran], cc-nc-sa) - 本文介绍了使用 Fortran 95 编程语言进行编程和解决问题.

[网站-ipufortran]：http://www.egr.unlv.edu/~ed/fortran

<a name='ruby'></a>
### Ruby

 * [Why&#39;s Poignant Guide to Ruby][repo-poignant-ruby] ([Site][site-poignant-ruby], cc-sa) - 这只是一本 Ruby 小书. 它不会压垮你. 轻如鸿毛
* [Rails Guide][repo-rails-guide] ([Site][site-rails-guide], cc-sa) - Ruby on Rails 官方指南
* [Rails 风格指南][repo-rails-style-guide] (cc) - 社区驱动的 Ruby on Rails 4 风格指南
* [Ruby 风格指南][repo-ruby-style-guide] (cc) - 社区驱动的 Ruby 编码风格指南
* [Better Spec][repo-better-spec] ([Site][site-better-spec], MIT) - RSpec 最佳实践
* [Ruby Hacking Guide][repo-rhg] ([Site][site-rhg-english], cc-nc-sa) - Ruby hacking guide 英文翻译
* Practicing Ruby ([Site][site-practing-ruby], cc-sa) - 我们提供广泛的不同主题的集中编程经验
* [Ruby 最佳实践][repo-rbp] (cc-nc-sa) - Ruby 最佳实践，作者：Gregory Brown
* [Neo Ruby Koans][repo-ruby-koan] ([Site][site-ruby-koan], cc-nc-sa) - 一组用于教授 Ruby 语言的 Koans
* [Middleman][repo-middleman] ([Site][site-middleman], cc) - 中间人文档
* [Jekyll][repo-jekyll] ([Site][site-jekyll], MIT) - Jekyll 文档
* [Ruby Scripting][repo-ruby-scripting] ([Site][site-ruby-scripting], cc-nc-sa) - 基于示例的 Ruby 脚本指南
* [Ruby Regexp][repo-ruby-regexp] ([Site][site-ruby-regexp], cc-nc-sa) - Ruby 正则表达式分步指南

[repo-ruby-scripting]：https://github.com/learnbyexample/Ruby_Scripting
[网站红宝石脚本]：https://learnbyexample.gitbooks.io/ruby-scripting/content/index.html
[repo-jekyll]：https://jekyllrb.com/
[网站杰基尔]：https://github.com/jekyll/jekyll/tree/master/site
[回购中间人]：https://github.com/middleman/middleman-guides
[站点中间人]：https://middlemanapp.com/
[repo-ruby-koan]：https://github.com/neo/ruby_koans
[站点红宝石公案]：https://github.com/neo/ruby_koans
[repo-rbp]：https://github.com/practicingruby/rbp-book
[网站练习红宝石]：https://practicingruby.com/about
[repo-ruby-style-guide]：https://github.com/bbatsov/ruby-style-guide
[repo-rails-style-guide]：https://github.com/bbatsov/rails-style-guide
[site-rhg-english]: https://ruby-hacking-guide.github.io/
[repo-rhg]：https://github.com/tmm1/ruby-hacking-guide
[repo-better-spec]：https://github.com/andreareginato/betterspecs/
[site-better-spec]: http://betterspecs.org/#books
[repo-rails-guide]：https://github.com/rails/rails/tree/master/guides
[站点导轨指南]：http://guides.rubyonrails.org/
[repo-poignant-ruby]：https://github.com/mislav/poignant-guide
[site-poignant-ruby]：http://poignant.guide/book/
[repo-ruby-regexp]：https://github.com/learnbyexample/Ruby_Regexp
[站点红宝石正则表达式]：https://github.com/learnbyexample/Ruby_Regexp/blob/master/ruby_regexp.md

<a name='clojure'></a>
### Clojure

* [ClojureDocs][repo-clojure-docs]（[站点][site-clojure-docs]，Eclipse 公共许可证）- Clojure 编程语言的社区文档和示例存储库
* [Clojure Documentation][repo-clojure-doc] ([Site][site-clojure-doc], cc) - Clojure 编程语言的社区驱动文档站点

[网站-clojure-docs]：http://clojuredocs.org
[repo-clojure-docs]：https://github.com/zk/clojuredocs
[网站-clojure-doc]：http://clojure-doc.org/
[repo-clojure-doc]：https://github.com/clojuredocs/guides

<a name='elixir'></a>
### Elixir

* [Elixir 入门][repo-elixir-getting-started]（[站点][site-elixir-getting-started]，Apache 2.0）- 官方 Elixir 教程
* [repo-30-days-of-elixir][repo-30-days-of-elixir] (MIT) - 在 30 个练习中逐步了解 Elixir 语言
* [Elixir 风格指南][repo-elixir-style-guide] (cc) - Elixir 的社区驱动风格指南

[repo-elixir-style-guide]：https://github.com/niftyn8/el​​ixir_style_guide
[repo-elixir-getting-started]：https://github.com/elixir-lang/elixir-lang.github.com
[网站-elixir-getting-started]：http://elixir-lang.org/getting-started/introduction.html
[repo-30-days-of-elixir]：https://github.com/seven1m/30-days-of-elixir

<a name='forth'></a>
### Forth

* Thinking Forth 项目 Thinking Forth 项目 ([PDF][site-thinking-forth], cc-nc-sa)

[网站思考]：http://www.dnd.utwente.nl/~tim/colorforth/Leo-Brodie/thinking-forth.pdf

<a name='erlang'></a>
### Erlang

 * 学习一些 Erlang 非常有用！  ([站点][站点-lysefgg], cc-nc-nd)
* [Structure and Interpretation of Computer Programs][repo-sicp-lfe] ([Site][site-sicp-lfe], cc-sa) - Structure and Interpretation of Computer Programs, LFE 版

[回购-sicp-lfe]：https://github.com/lfe/sicp
[网站-sicp-lfe]：http://lfe.gitbooks.io/sicp/
[网站-lysefgg]：http://learnyousomeerlang.com/content

<a name='go'></a>
### Go

* [Go by Example][repo-go-by-example] (cc) - Go by Example 是使用带注释的示例程序对 Go 的动手介绍
* [使用 Golang 构建 Web 应用程序][repo-bwawg] (cc-sa) - 一本介绍如何使用 golang 构建 Web 的 golang 电子书

[repo-bwawg]：https://github.com/astaxie/build-web-application-with-golang
[repo-go-by-example]：https://github.com/mmcgrana/gobyexample

<a name='haskell'></a>
### Haskell

 * 学 Haskell 学个好东西！  ([Site][site-lyhfgg], cc-nc-sa) - 学习 Haskell 非常有用！ 是一本关于这种复杂函数式语言的搞笑图文并茂的指南
* [How to learn Haskell][repo-howtlh] (cc0) - 这是基于帮助他人的经验推荐的学习 Haskell 的路径
* [Haskell By Example][repo-haskell-example] ([Site][site-haskell-example], cc) - Haskell by Example 是 Go by Example 到 Haskell 的端口

[repo-haskell-example]：https://github.com/lotz84/haskellbyexample
[站点 haskell 示例]：http://lotz84.github.io/haskellbyexample/
[repo-howtlh]：https://github.com/bitemyapp/learnhaskell
[网站-lyhfgg]：http://learnyouahaskell.com/chapters

<a name='javascript'></a>
### Javascript

* Learning JavaScript Design Patterns ([Site][site-ljdp], cc-nc-nd) - 在本书中，我们将探索将经典和现代设计模式应用于 JavaScript 编程语言
* [JavaScript-Garden][repo-javascript-garden] ([Site][site-javascript-garden], MIT) - 关于 JavaScript 语言最古怪部分的文档集合
* [ECMAScript 6 Features][repo-es6-features] (MIT) - ECMAScript 6，也称为 ECMAScript 2015，是 ECMAScript 标准的最新版本
* [React Primer Draft][repo-react-primer] (GNU) - 使用 React 构建单页应用程序的入门
* [Angular Style Guide][repo-angular-style-guide] (MIT) - Angular 风格指南：Angular 开发团队通过良好实践提供一致性的起点
* [JavaScript : The Right Way][repo-jstherightway] ([Site][site-jstherightway], cc-nc-sa) - 本指南旨在向新开发人员介绍 JavaScript 并帮助有经验的开发人员更多地了解它的优点做法
* [惯用 JavaScript][repo-idiomatic-js] (cc) - 编写一致、惯用 JavaScript 的原则
* [Angular 测试模式][repo-angular-test-pattern] (MIT) - 测试 Angular 1.x 应用程序的高质量指南
* [Airbnb JavaScript 风格指南][repo-airbnb-javascript] (MIT) - 一种最合理的 JavaScript 方法
* [JavaScript Garden][repo-js-garden] ([Site][site-js-garden], MIT) - 关于 JavaScript 语言最古怪部分的文档集合
 * [Node.js Style Guide][repo-node-style-guide] (cc-sa) - 样式化 node.js / JavaScript 代码的指南. 分叉并根据您的口味进行调整
 * [Node.js Best Practices][repo-nodejs-bp] ([Site][site-nodejs-bp], MIT) - 这是编写健壮的 Node.js 代码的最佳实践列表. 它受到其他公会的启发，例如 Felix Geisendörfer 的 Node Style Guide 以及社区中流行的东西
* [function qualityGuide () {][repo-function-quality] (MIT) - 本风格指南旨在为应用程序的 JavaScript 代码提供基本规则，使其在团队中的不同开发人员之间具有高度可读性和一致性
* [The Node Beginner Book][repo-node-biginner] ([Site][site-node-biginner], cc-nc-sa) - The Node Beginner Book 全面介绍了 Node.js 和其他一些函数式编程等高级 JavaScript 主题
 * [学习 Node.js 大获成功！][repo-learn-node-win] (MIT) - 学习 Node.js 大获成功！ 通过一组自导式研讨会介绍 Node.js.
 * Understanding ECMAScript 6 ([Site][site-understanding-es6], cc-nc-nd) - ECMAScript 6 即将到来，你准备好了吗？ 有很多新概念需要学习和理解. 阅读本书，抢先一步！
* [Node.js 简介][repo-art-of-node] (cc-sa) - node.js 的简短介绍
* [stream-handbook][repo-stream-handbook] (cc) - 如何用流编写节点程序
 * [You Don&#39;t Know JS][repo-you-dont-know-js] ([Site][site-you-dont-know-js], cc-nc-nd) - 关于 JavaScript 的系列丛书.  @YDKJS 在推特上.
* Eloquent JavaScript ([Site][site-eloquent-javascript], cc-nc) - 关于 JavaScript、编程和数字奇迹
* [CasperJS][repo-casperjs] ([Site][site-casperjs], MIT) - CasperJS 文档
* [Ember.js Guide][repo-emberjs] ([Site][site-emberjs], MIT) - Ember.js 官方指南
* [React Document][repo-react] ([Site][site-react], cc) - React 文档
* [Flux Application Architecture][repo-flux] ([Site][site-flux], cc) - Flux 应用架构文档
* [Redux Document][repo-redux] ([Site][site-redux], MIT) - Redux 文档
* [JavaScript RegExp][repo-js-regexp] ([Site][site-js-regexp], cc-nc-sa) - JavaScript 正则表达式分步指南

[repo-node-style-guide]: https://github.com/felixge/node-style-guide
[回购通量]：https://facebook.github.io/react/docs/flux-overview.html
[站点通量]：https://github.com/facebook/react/tree/master/docs
[repo-redux]：https://github.com/rackt/redux/blob/master/README.md
[站点归约]：https://rackt.github.io/redux/
[回购反应]：https://github.com/facebook/react/tree/master/docs
[站点反应]：https://facebook.github.io/react/docs/getting-started.html
[repo-emberjs]：https://github.com/emberjs/guides/
[网站-emberjs]：https://guides.emberjs.com/v2.0.0/
[站点-casperjs]：https://casperjs.readthedocs.org/en/latest/
[repo-casperjs]：https://github.com/n1k0/casperjs/blob/master/docs
[site-you-dont-know-js]：https://www.kickstarter.com/projects/getify/you-dont-know-js-book-series
[repo-you-dont-know-js]：https://github.com/getify/You-Dont-Know-JS
[回购流手册]：https://github.com/substack/stream-handbook
[repo-art-of-node]：https://github.com/maxogden/art-of-node
[site-understanding-es6]: https://leanpub.com/understandinges6/read
[repo-learn-node-win]：https://github.com/workshopper/learnyounode
[repo-node-biginner]：https://github.com/manuelkiessling/nodebeginner.org
[站点节点 biginner]：http://www.nodebeginner.org/
[回购功能质量]：https://github.com/bevacqua/js
[站点-nodejs-bp]：http://justbuildsomething.com/node-js-best-practices/
[repo-nodejs-bp]：https://github.com/alanjames1987/Node.js-Best-Practices
[repo-angular-style-guide]：https://github.com/johnpapa/angular-styleguide
[回购反应底漆]：https://github.com/mikechau/react-primer-draft/
[repo-es6-features]：https://github.com/lukehoban/es6features
[repo-javascript-garden]：https://github.com/BonsaiDen/JavaScript-Garden
[网站-javascript-花园]：http://bonsaiden.github.io/JavaScript-Garden/
[repo-jstherightway]：https://github.com/braziljs/js-the-right-way
[site-jstherightway]: http://jstherightway.org/
[repo-idiomatic-js]：https://github.com/rwaldron/idiomatic.js
[网站-ljdp]：https://addyosmani.com/resources/essentialjsdesignpatterns/book/
[repo-angular-test-pattern]：https://github.com/daniellmb/angular-test-patterns
[repo-airbnb-javascript]：https://github.com/airbnb/javascript
[repo-js-garden]：https://github.com/BonsaiDen/JavaScript-Garden
[网站-js-花园]：http://bonsaiden.github.io/JavaScript-Garden/
[repo-js-regexp]：https://github.com/learnbyexample/learn_js_regexp
[站点 js 正则表达式]：https://github.com/learnbyexample/learn_js_regexp/blob/master/js_regexp.md
[网站雄辩的javascript]：https://eloquentjavascript.net/

<a name='lisp'></a>
### Lisp

* [DIY Lisp][repo-diy-lisp] (BSD) - 一个实践、测试驱动的指南，用于实现一种简单的编程语言.
* [Build Your Own Lisp][repo-buildyourownlisp] ([Site][site-buildyourownlisp], cc-nc-sa) - 学习 C 并在 1000 行代码中构建您自己的编程语言！

[repo-diy-lisp]：https://github.com/kvalle/diy-lisp
[repo-buildyourownlisp]：https://github.com/orangeduck/BuildYourOwnLisp
[site-buildyourownlisp]: http://www.buildyourownlisp.com/

<a name='objective-c'></a>
### Objective-C

* [NYTimes Objective-C Style Guide][repo-nytimes-objective-c-style-guide] (MIT) - 该风格指南概述了纽约时报 iOS 团队的编码惯例.

[repo-nytimes-objective-c-style-guide]：https://github.com/NYTimes/objective-c-style-guide

<a name='ocaml'></a>
### Ocaml

* Real World OCaml ([Site][site-real-world-ocaml], cc-nc-nd) - Real World OCaml is aimed at programmers who have some experience with conventional programming languages, but not specifically with statically typed functional programming.

[网站-真实世界-ocaml]：https://realworldocaml.org/v1/en/html/

<a name='perl'></a>
### Perl

* [Perl intro][repo-perl-intro] ([Site][site-perl-intro], cc-nc-sa) - 通过示例介绍 Perl 5 的入门课程

[repo-perl-intro]：https://github.com/learnbyexample/Perl_intro
[站点 perl 介绍]：https://learnbyexample.gitbooks.io/perl-introduction/content/

<a name='php'></a>
### PHP

* [PHP: The Right Way][repo-php-right-way] ([Site][site-php-right-way], by-nc-sa) - 一个易读、快速的 PHP 最佳参考实践、公认的编码标准以及指向 Web 上权威教程的链接

[repo-php-right-way]: https://github.com/codeguy/php-the-right-way
[网站-php-right-way]：http://www.phptherightway.com/

<a name='python'></a>
### Python

* [Python 增强建议][repo-peps]（[站点][站点-peps]，开放出版许可证）
* [Python 漫游指南！][repo-python-hguide]（[站点][site-python-hguide]，cc-nc-sa）- Python 最佳实践指南，为人类编写.
* [Django Documentation][repo-django-document] ([Site][site-django-document], bsd) - Django 的文档，它是 python web 框架
* Dive Into Python 3 ([Site][site-diveintopython3], cc-sa) - Dive Into Python 是一本面向经验丰富的程序员的免费 Python 书籍
* [Explore Flask][repo-explore-flask]（[站点][site-explore-flask]，公共领域）- Explore Flask 是一本关于使用 Flask 开发 Web 应用程序的最佳实践和模式的书
* [Full Stack Python][repo-full-python] ([Site][site-full-python], MIT) - 全栈 Python 源代码，包括 Pelican、Bootstrap 和 Markdown
 * [A Byte of Python][repo-byte-python] ([Site][site-byte-python], cc-sa) - “A Byte of Python”是一本关于使用 Python 语言进行编程的免费书籍. 它可以作为初学者使用 Python 语言的教程或指南
* 学习使用 Python 编程（[站点][site-lpupython]，cc-sa）
 * [A guide to Python&#39;s magic methods][repo-magic-methods] ([Site][site-magic-methods], cc-nc-sa) - 本指南是几个月博客文章的结晶. 主题是魔术方法
* [Think Python][repo-think-python] ([Site][site-think-python], cc-nc) - 如何像计算机科学家一样思考
* 使用 Python 自动化无聊的东西（[站点][site-automatetheboringstuff]，cc-nc-sa） - 学习如何使用 Python 编写程序，这些程序在几分钟内完成你需要几个小时才能手工完成的程序 - 没有先前的编程经验必需
* [Python 旋风之旅][repo-whirlwind-tour] ([Site][site-whirlwind-tour], cc0) - 为已经熟悉 Python 语言的研究人员和开发人员快速介绍 Python 语言的基本组件用另一种语言编程
* [实用 Python 编程][repo-practical-python]（[站点][site-practical-python]，cc-sa）——涵盖 Python 编程的基础方面，重点是脚本编写、数据操作和程序组织
* [Python Basics][repo-python-basics] ([Site][site-python-basics], cc-nc-sa) - Python 简介
* Google&#39;s Python Class ([Site][site-google-python], cc) - 这是一门免费课程，适合有一点编程经验并想学习 Python 的人（请注意，本课程是为 Python 2.6 或更高版本设计的, 不是 Python 3.x)
* [Think DSP][repo-think-dsp] ([Site][site-think-dsp], cc-nc) - Python 数字信号处理简介
* [Python re(gex)?][repo-python-regex] ([Site][site-python-regex], cc-nc-sa) - 学习 Python 正则表达式的分步指南

[回购旋风之旅]：https://github.com/jakevdp/WhirlwindTourOfPython
[现场旋风之旅]：https://nbviewer.jupyter.org/github/jakevdp/WhirlwindTourOfPython/blob/master/Index.ipynb
[repo-python-basics]：https://github.com/learnbyexample/Python_Basics
[站点-python-基础]：https://learnbyexample.gitbooks.io/python-basics/content/index.html
[站点-google-python]：https://developers.google.com/edu/python/
[网站思考蟒蛇]：https://greenteapress.com/wp/think-python-2e/
[repo-think-python]：https://github.com/AllenDowney/ThinkPython
[网站思考-dsp]：https://greenteapress.com/wp/think-dsp/
[repo-think-dsp]：https://github.com/AllenDowney/ThinkDSP
[repo-magic-methods]：https://github.com/RafeKettler/magicmethods
[站点魔术方法]：http://www.rafekettler.com/magicmethods.html
[站点 lpupython]：https://docs.google.com/file/d/0B8IUCMSuNpl7MnpaQ3hhN2R0Z1k/edit
[repo-byte-python]：https://github.com/swaroopch/byte-of-python
[网站字节蟒蛇]：http://www.swaroopch.com/notes/python/
[repo-full-python]：https://github.com/makaimc/fullstackpython.com
[网站全蟒蛇]：http://www.fullstackpython.com/
[repo-explore-flask]：https://github.com/rpicard/explore-flask
[站点探索烧瓶]：https://exploreflask.com/
[站点-diveintopython3]：http://www.diveintopython3.net/
[repo-django-文档]：https://github.com/django/django/tree/master/docs
[网站-django-文档]：https://docs.djangoproject.com/en/1.8/
[repo-peps]：https://github.com/python/peps
[网站-peps]：https://www.python.org/dev/peps/
[站点-python-hguide]：http://docs.python-guide.org/en/latest/
[repo-python-hguide]：https://github.com/kennethreitz/python-guide
[网站实用蟒蛇]：https://dabeaz-course.github.io/practical-python/
[repo-practical-python]：https://github.com/dabeaz-course/practical-python
[网站自动化]：https://automatetheboringstuff.com/
[repo-python-regex]：https://github.com/learnbyexample/py_regular_expressions
[站点-python-正则表达式]：https://github.com/learnbyexample/py_regular_expressions/blob/master/py_regex.md

<a name='rust'></a>
### Rust

* [The Rust Programming Language][repo-trpl] ([Site][site-trpl], MIT) - Rust 官方指南
* [Rust by Example][repo-rust-by-example]（[站点][site-rust-by-example]，麻省理工学院） - Rust by Example 是一组示例，说明了各种 Rust 概念和标准库
* [Rust For Rubyists][repo-rust-rubyist] ([Site][site-rust-rubyist], AGPL) - Rust for Rubyists 是 Rust 的第一个社区教程
* Rust for Python Programmers ([Site][site-rust-python], cc-nc-sa)

[站点-rust-python]：http://lucumr.pocoo.org/2015/5/27/rust-for-pythonistas/
[repo-rust-rubyist]：https://github.com/steveklabnik/rust_for_rubyists
[站点-rust-rubyist]：https://github.com/steveklabnik/rust_for_rubyists
[repo-rust-by-example]：https://github.com/rust-lang/rust-by-example
[site-rust-by-example]：http://rustbyexample.com/
[网站-trpl]：http://doc.rust-lang.org/book/README.html
[repo-trpl]: https://github.com/rust-lang/rust/tree/master/src/doc/trpl

<a name='r'></a>
### R

* [R 简介][repo-intro-r] ([Site][site-intro-r], cc-nc-sa &amp; apache 2.0) - 这些是我正在为 Python 程序员教授的介绍性 R 研讨会的笔记
* Cookbook for R ([Site][site-r-cookbook], cc-sa) - 本食谱的目标是为数据分析中的常见任务和问题提供解决方案

[site-r-cookbook]：http://www.cookbook-r.com/
[站点介绍-r]：https://ramnathv.github.io/pycon2014-r/
[repo-intro-r]：https://github.com/idocs/test1

<a name='racket'></a>
### Racket

* Racket 文档（[站点][site-racket-documentation]，LGPL）- Racket 文档

[站点球拍文档]：http://docs.racket-lang.org/index.html

<a name='scala'></a>
### Scala

* [Scala Best Practices][repo-scala-bp] (cc) - 最佳实践的集合，对想要贡献的人友好
* [twitter.github.com/effectivescala][repo-effective-scala] ([Site][site-effective-scala], cc-by) - Twitter 的有效 Scala 指南
* [Scala School!][repo-scala-school] ([Site][site-scala-school], Apache 2.0) - Scala 基础课程

[repo-effective-scala]：https://github.com/twitter/effectivescala
[站点有效-scala]：http://twitter.github.io/effectivescala/
[repo-scala-bp]：https://github.com/alexandru/scala-best-practices
[repo-scala-school]：https://github.com/twitter/scala_school
[站点-scala-学校]：https://twitter.github.io/scala_school/

<a name='smalltalk'></a>
### Smalltalk

* 深入 Pharo ([Site][site-deep-pharo], cc-sa) - 深入 Pharo 是涵盖 Pharo 的系列丛书的第二卷
* Pharo by example ([Site][site-pharo-example], cc-sa) - Pharo by Example 面向学生和开发人员，将通过一系列示例和练习
* 使用 Seaside 进行动态 Web 开发 ([Site][site-dwd-seaside], cc-nc-sa) - 使用 Seaside 进行动态 Web 开发，面向开发人员，将展示 Seaside 的核心以及 Web 2.0 等高级功能支持和部署
* Squeak by Example ([Site][site-squeak-example], cc-sa) - Squeak by Example 面向学生和开发人员，将通过一系列示例和练习

[site-squeak-example]：http://www.squeakbyexample.org/
[网站-dwd-海边]：http://book.seaside.st/book
[站点深度法罗]：http://deepintopharo.com/
[站点法罗示例]：http://pharobyexample.org/

<a name='tools'></a>
## Tools

<a name='server'></a>
### Server

* [Nginx 服务器配置][repo-nginx-configs] (MIT) - Nginx HTTP 服务器样板配置

[repo-nginx-configs]：https://github.com/h5bp/server-configs-nginx

<a name='editor'></a>
### Editor

 * GNU Emacs 手册（[站点][站点-emacs-手册]，GNU-FDL）- Emacs 是可扩展的、可定制的、自文档化的实时显示编辑器. 本手册描述了如何使用 Emacs 进行编辑以及自定义它的一些方法
* GNU Emacs Lisp 参考手册（[站点][site-elisp-manual]，GNU-FDL）- Emacs Lisp 文档
* [Emacs is sexy!][repo-emacs-sexy] ([Site][site-emacs-sexy], GNU) - 分享对 Emacs 的热爱的简单网站
* [Learn Vimscript the Hard Way][repo-vimscript-hard-way] ([Site][site-vimscript-hard-way], custom license) - Learn Vimscript the Hard Way 是一本面向 Vim 编辑器用户的书想学习如何自定义 Vim
* [Emacs Lisp 风格指南][repo-elisp-style-guide] (cc) - 本 Emacs Lisp 风格指南推荐最佳实践，以便现实世界的 Emacs Lisp 程序员可以编写可由其他现实世界的 Emacs 维护的代码Lisp 程序员
* A Byte of Vim ([Site][site-byte-vim], cc-sa) - “A Byte of Vim” 是一本旨在帮助您学习如何使用 Vim 编辑器（版本 7）的书，甚至如果你只知道如何使用电脑键盘
* [Vim Reference][repo-vim-reference] ([Site][site-vim-reference], cc-nc-sa) - 初学者到中级用户指南

[repo-vim-reference]: https://github.com/learnbyexample/vim_reference
[站点 vim 参考]：https://learnbyexample.gitbooks.io/vim-reference/content/index.html
[站点字节 vim]：http://www.swaroopch.com/notes/vim/
[repo-elisp-style-guide]：https://github.com/bbatsov/emacs-lisp-style-guide
[repo-vimscript-hard-way]: https://github.com/sjl/learnvimscriptthehardway
[site-vimscript-hard-way]：http://learnvimscriptthehardway.stevelosh.com/
[站点-emacs-手册]：https://www.gnu.org/software/emacs/manual/emacs.html
[站点 elisp 手册]：https://www.gnu.org/software/emacs/manual/elisp.html
[repo-emacs-sexy]：https://github.com/picandocodigo/emacs.sexy
[站点-emacs-性感]：http://emacs.sexy/

<a name='git'></a>
### Git

* [Pro Git][repo-progit] ([Site][site-progit], cc-nc-sa) - Scott Chacon 和 Ben Straub 编写的关于 Git 的开源书籍
* [A Git Style Guide][repo-git-style-guide] (cc) - 这是一份 Git 风格指南，灵感来自如何将你的更改引入 Linux 内核、git 手册页和社区中流行的各种实践.
* [Github Cheatsheet][repo-github-cheatsheet] (MIT) - Git 和 GitHub 的很酷的功能列表
* [Git Magic][repo-git-magic] ([Site][site-git-magic], GPL) - 使用 Git 的指南
* [Git it][repo-git-it] ([Site][site-git-it], BSD) - 学习 Git 和 GitHub 的讲习班.

[repo-git-style-guide]: https://github.com/agis-/git-style-guide
[repo-git-magic]：https://github.com/blynn/gitmagic
[网站-git-magic]：http://cs.stanford.edu/~blynn/gitmagic/
[repo-git-it]: https://github.com/jlord/git-it
[网站-git-it]：http://jlord.github.io/git-it
[repo-github-cheatsheet]：https://github.com/tiimgreen/github-cheat-sheet
[repo-progit]: https://github.com/progit/progit
[站点程序]：http://git-scm.com/book/

<a name='tool-etc'></a>
### etc.

 * Gibber 用户手册 ([Site][site-gibber-manual], cc) - Gibber 是一个在浏览器中运行的创意编码环境. 这本书解释了为什么创建 Gibber、它的功能是什么以及如何使用它
* Upstart 简介、食谱和最佳实践（[站点][site-upstart-cookbook]，cc-sa）

[网站新贵食谱]：http://upstart.ubuntu.com/cookbook/
[站点 gibber 手册]：https://www.gitbook.com/book/bigbadotis/gibber-user-manual/details

<a name='library-docs'></a>
## Library Documentation

* [riak docs][repo-riak] ([Site][site-riak], cc) - riak 文档
* [Vagrant][repo-vagrant] ([Site][site-vagrant], MIT) - Vagrant 文档
* [Docker][repo-docker] ([Site][site-docker], Apache 2.0) - Docker 文档
* [phpMyAdmin][repo-phpmyadmin] ([Site][site-phpmyadmin], GPL) - phpMyAdmin 文档
* [OmegaT][repo-omegat] ([Site][site-omegat], GPL) - OmegaT 文档
* [Sphinx 文档][repo-sphinx-doc]（[站点][site-sphinx-doc]，BSD）- Sphinx 文档
* [Ansible Documentation][repo-ansible-document] ([Site][site-ansible-document], GPL) - Ansible 文档

[回购流浪者]：https://github.com/mitchellh/vagrant/tree/master/website/docs
[网站流浪者]：https://docs.vagrantup.com/v2/
[回购泊坞窗]：https://github.com/docker/docker/tree/master/docs
[站点泊坞窗]：https://docs.docker.com/
[repo-phpmyadmin]：https://github.com/phpmyadmin/localized_docs
[站点 phpmyadmin]：https://phpmyadmin-english-united-kingdom.readthedocs.org/en/latest/
[repo-omegat]：http://sourceforge.net/p/omegat/code/ci/master/tree/doc_src/
[站点 omegat]：http://omegat.sourceforge.net/manual-standard/
[回购]：https://github.com/basho/basho_docs
[网站-riak]：http://docs.basho.com/riak/latest/
[站点-sqlalchemy]：http://docs.sqlalchemy.org/en/latest/index.html
[repo-ansible-document]：https://github.com/ansible/ansible/tree/devel/docsite
[站点-ansible-文档]：http://docs.ansible.com/
[repo-sphinx-doc]: https://github.com/sphinx-doc/sphinx/tree/master/doc
[站点狮身人面像文档]：http://www.sphinx-doc.org/en/stable/contents.html

<a name='other_languages'></a>
## Other Languages

<a name='korean'></a>
### Korean

* 점프 투 파이썬 ([Site][site-jump-to-python], cc-nc-nd) - 이 책은 파이썬이란 언어를 처음 접해보는 독자들과 프로그래밍을 한 번도 해 본적이 없는 사람들을 대상으로 한다. 프로그래밍을 할 때 사용되는 전문적인 용어들을 알기 쉽게 풀어서 쓰려고 노력하였으며, 파이썬이란 언어의 개별적인 특성만을 강조하지 않고 프로그래밍 전반에 관한 사항을 파이썬이란 언어를 통해 알 수 있도록 알기 쉽게 설명하였다.
* [emacsbook][repo-emacsbook] (cc-nc)
* 踏实、自由、快乐：韩国开源开发者的故事（[站点][site-osdi]，cc-nc-nd）

[网站-osdi]：http://osdi.insightbook.co.kr/
[repo-emacsbook]：https://github.com/tsgates/emacsbook
[站点跳转到 python]：https://wikidocs.net/book/1

<a name='chinese'></a>
### Chinese

* [JavaScript 标准参考教程][repo-jstutorial] ([Site][site-jstutorial], cc-nc) - A open JavaScript tutorial book, focusing on client devices, written in Chinese
* [使用 Golang 构建 Web 应用程序][repo-build-web-app-golang] (cc-sa) - 一本介绍如何使用 golang 构建 Web 的 golang 电子书
* [七天学会NodeJS][repo-7days-node] ([Site][site-7days-node], MIT) - 这是一本NodeJS新手入门教程，涵盖了使用NodeJS开发各种程序所必要的知识，请点击以下链接阅读
* [C++ 并发编程指南][repo-adcct] (MIT) - A Detailed Cplusplus Concurrency Tutorial
* [Backbone.js入门教程][repo-backbonejs-note] (MIT) - backbonejs学习笔记更新版，使用backbone1.1.0
* [ECMAScript 6入门][repo-es6tutorial-cn] ([Site][site-es6tutorial-cn], cc-nc) - 一本开源的JavaScript语言教程，全面介绍ECMAScript 6新增的语法特性
* [Nginx开发从入门到精通][repo-nginx-book-cn] ([Site][site-nginx-book-cn], cc-nc) - 一本开源的Nginx开发教程，全面介绍nginx模块的开发以及它的内部原理

[site-es6tutorial-cn]：http://es6.ruanyifeng.com/
[repo-es6tutorial-cn]：https://github.com/ruanyf/es6tutorial
[repo-backbonejs-note]：https://github.com/the5fire/backbonejs-learning-note
[repo-adcct]: https://github.com/forhappy/Cplusplus-Concurrency-In-Practice
[site-7days-node]：http://nqdeng.github.io/7-days-nodejs/
[repo-7days-node]：https://github.com/nqdeng/7-days-nodejs
[repo-build-web-app-golang]：https://github.com/astaxie/build-web-application-with-golang
[网站jstutorial]：http://javascript.ruanyifeng.com
[repo-jstutorial]：https://github.com/ruanyf/jstutorial/
[site-nginx-book-cn]：http://tengine.taobao.org/book/
[repo-nginx-book-cn]：https://github.com/taobao/nginx-book

<a name='japanese'></a>
## Japanese

* [Android 开发培训课程][repo-and-training]（[Site][site-and-training]，Apache 2.0）- android 应用程序开发培训课程库
* [Hatena 教材][repo-hatena-book] (cc-nc-sa) - Hatena 培训教材

[repo-hatena-book]：https://github.com/hatena/Hatena-Textbook
[回购和培训]：https://github.com/mixi-inc/AndroidTraining
[site-and-training]:http://mixi-inc.github.io/AndroidTraining/

<a name='another_documents_list'></a>
## Another Documents List / References

* [Beautiful Docs][repo-beautiful-docs] - 指向有用的、写得很好的以及其他方面漂亮的文档的指针
* [Papers We Love][repo-papers-we-love] - 来自计算机科学界的论文供阅读和讨论
* [Awesome Awesomeness][repo-awesome-awesomeness] - 令人惊叹的令人敬畏的精选列表
* [Awesome][repo-awesome] - 精选列表
* [Readings in Databases][repo-db-readings] - 理解数据库和构建新数据系统必不可少的论文列表
* [Python Reference][repo-python-reference] - Useful functions, tutorials, and other Python-related things
* [Guides][repo-narkoz-guides] - 设计和开发指南
* [免费学习资源列表][repo-free-programming-books] - 免费提供的编程书籍
 * [Gitbook][site-gitbook] - 现代出版工具链. 简单地把你从想法变成完成的、精美的书
 * [O&#39;Reilly Open Books][site-oreilly-openbook] - 多年来，O&#39;Reilly 出版了许多开放书籍——具有各种形式的“开放”版权的书籍.  “开放”版权的原因，以及开放它们所依据的具体许可协议，因我们的作者而异
* [OnlineProgrammingBooks.com][site-online-programming-books] - 该站点列出了与编程、计算机科学、软件工程、网页设计、移动应用程序开发、网络、数据库、信息技术、AI、出版商或作者在其网站上合法提供的图形和计算机硬件
* [自由软件基金会 - 书籍/文档][site-fsf-book]
* [Green Tea Press][site-greentea-press] - Allen Downey 的免费书籍
* [Wikipedia books(community books)][site-wikipedia-book]
* [Python Books][repo-python-books] - PythonBooks 展示了有关 Python 的最佳免费电子书
* [JSbooks][site-jsbooks] - 最好的免费 JavaScript 资源

[回购美丽文档]：https://github.com/PharkMillups/beautiful-docs
[repo-papers-we-love]：https://github.com/papers-we-love/papers-we-love
[repo-awesome-awesomeness]：https://github.com/bayandin/awesome-awesomeness
[回购真棒]：https://github.com/sindresorhus/awesome
[repo-db-readings]：https://github.com/rxin/db-readings
[repo-python-reference]：https://github.com/rasbt/python_reference
[repo-narkoz-guides]：https://github.com/NARKOZ/guides
[repo-free-programming-books]：https://github.com/vhf/free-programming-books
[网站-gitbook]：https://www.gitbook.io/
[网站-oreilly-openbook]：http://www.oreilly.com/openbook/
[网站在线编程书籍]：http://www.onlineprogrammingbooks.com/
[site-fsf-book]: http://shop.fsf.org/category/books/
[网站-greentea-press]：http://www.greenteapress.com/
[网站维基百科书籍]：https://en.wikipedia.org/wiki/Category:Wikipedia_books_%28community_books%29
[repo-python-books]：https://github.com/revolunet/PythonBooks
[网站-jsbooks]：http://jsbooks.revolunet.com/

<a name='license'></a>
## License
<p xmlns:dct="http://purl.org/dc/terms/" xmlns:vcard="http://www.w3.org/2001/vcard-rdf/3.0#">
  <a rel="license"
     href=&quot;http://creativecommons.org/publicdomain/zero/1.0/&quot;&gt;
    <img src="http://i.creativecommons.org/p/zero/1.0/88x31.png" style="border-style: none;" alt="CC0" />
  </a>
</p>
