<div class="github-widget" data-repo="zachflower/awesome-open-source-supporters"></div>
## Awesome Open Source Supporters [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A curated list of awesome companies that offer their tools and services for free to Open Source and public projects.

**Note: While there are many companies that have great free tiers (Slack, for example), this list focuses specifically on organizations that have made an overt commitment to the Open Source community through additional offerings.**



## Code Coverage

- [Codecov](https://codecov.io/) - Test coverage monitoring & alerting.
- [Coveralls](https://coveralls.io/) - Test coverage history & statistics.

## Code Quality

- [Better Code Hub](https://bettercodehub.com/) - Source code maintainability analysis.
- [Codacy](https://www.codacy.com/) - Automated code reviews & analytics.
- [Code Climate](https://codeclimate.com/) - Automated code review & health analysis.
- [codebeat](https://codebeat.co/) - Automated code review for mobile and web.
- [CodeFactor](https://www.codefactor.io/) - Automated static analysis for C#, Java, CSS, JS, Ruby, Go and Python source code.
- [Hound](https://houndci.com/) - Source code style review.
- [lgtm](https://lgtm.com/) - Automated code reviews for developers.
- [PullApprove](https://about.pullapprove.com/) - Approve GitHub pull request through code review.
- [Reviewable](https://reviewable.io/) - Automated GitHub code reviews.
- [Scrutinizer](https://scrutinizer-ci.com/) - Continuous code quality analysis.
- [SonarCloud](https://sonarcloud.io/) - Continuous code inspection.
- [StyleCI](https://styleci.io/) - PHP code style review.

## Continuous Integration

- [AppVeyor](https://www.appveyor.com/) - CI/CD for Windows developers.
- [Bitrise](https://www.bitrise.io/) - Hosted CI/CD for Android and iOS, free for Public Projects.
- [CircleCI](https://circleci.com/) - Docker-based building with support of customized workflows.
- [Codefresh](https://codefresh.io/) - Docker-native CI/CD.
- [Codeship](https://codeship.com/) - Continuous integration, delivery, and deployment.
- [DeployHQ](https://www.deployhq.com/) `requires-approval` - Deployment automation.
- [Sauce Labs](https://saucelabs.com/) - Cross-browser testing, Selenium testing, and mobile testing.
- [Semaphore](https://semaphoreci.com/) - Fast automated CI/CD.
- [Travis-CI](https://travis-ci.org/) - Automated CI/CD for Open Source.

## Dependency Management

- [Dependabot](https://dependabot.com/) - Automated dependency updates for Ruby, Python, JavaScript and PHP.
- [Greenkeeper](https://greenkeeper.io/) - Automated dependency management for NPM packages (on GitHub).
- [pyup.io](https://pyup.io/) - Python dependency management.
- [Snyk](https://snyk.io/) - Continuous dependency vulnerability assessment.
- [Tachikoma.io](http://tachikoma.io/) - Dependency update as a service.

## Documentation

- [GitBook](https://www.gitbook.com/) - Collaborative application documentation.
- [Read the Docs](https://readthedocs.com/) - Documentation hosting platform.

## Exception Reporting

- [BugSnag](https://www.bugsnag.com/) `requires-approval` - Exception tracking and reporting.
- [Honeybadger](https://www.honeybadger.io) `requires-approval` `non-commercial` - Exception and uptime monitoring for Ruby.

## Package Management

- [MyGet](https://myget.org/) `requires-approval` - NuGet, npm, Bower, Maven, and Vsix package hosting.
- [packagecloud](https://packagecloud.io/pricing) `requires-approval` - Maven, RPM, DEB, PyPi, and RubyGem hosting.

## Project Management

- [Taiga.io](https://taiga.io/) - Project management for agile developers.
- [ZenHub](https://www.zenhub.com/) - Agile GitHub project management.
- [Zube](https://zube.io/) - Project management for GitHub issues.

## Monitoring

- [Healthchecks.io](https://healthchecks.io/) `requires-approval` - Cron job monitoring.
- [WebGazer](https://www.webgazer.io) `requires-approval` - Uptime and cron job monitoring with hosted status pages.

## Localization

- [Crowdin](https://crowdin.com/) `requires-approval` - Localization management platform.
- [LingoHub](https://lingohub.com/) `requires-approval` - Translation management.
- [Locale](https://www.localeapp.com/) - Localization and Translation.
- [Lokalise](https://lokalise.com/) `requires-approval` - Localization and Translation Software Tool.
- [POEditor](https://poeditor.com/) `requires-approval` - Localization management platform.
- [Transifex](https://www.transifex.com/) `requires-approval` - Localization platform for translating digital content.
- [Weblate](https://weblate.org/) `requires-approval` - Web-based continuous localization.

## Version Control

- [BitBucket](https://bitbucket.org/) - Git and Mercurial repository hosting.
- [GitHub](https://github.com/) - Git project hosting.
- [GitLab](https://about.gitlab.com/) - Git project hosting.
- [Plastic SCM](https://www.plasticscm.com/) `requires-approval` - Distributed Git project hosting.

## Miscellaneous

- [Algolia](https://www.algolia.com/for-open-source/) - `requires-approval` Search as a service API.
- [Apiary](https://apiary.io/) `requires-approval` - API design, development, and documentation platform.
- [Atlassian](https://www.atlassian.com/software/views/open-source-license-request) `requires-approval` - Productivity tools for teams (Jira, Confluence, Bamboo, HipChat).
- [Auth0](https://auth0.com/) `requires-approval` - SSO & token-based authentication.
- [BackHub](https://backhub.co/) - Automated GitHub repository backups.
- [BrowserStack](https://www.browserstack.com/) `requires-approval` - Cross-browser testing tool.
- [Cloud9](https://c9.io/) - Cloud-based development environments.
- [Codota](https://www.codota.com/) - AI pair programming assistant.
- [Firezone](https://www.firezone.dev/) `requires-approval` - Self-hosted remote access built on WireGuard.
- [GlobalSign](https://www.globalsign.com/en/ssl/ssl-open-source/) `requires-approval` - SSL certificates for open source projects.
- [Helpmonks](https://helpmonks.com/) `requires-approval` - Collaborative team email inboxes.
- [JetBrains](https://www.jetbrains.com/buy/opensource/) `requires-approval` `non-commercial` - Software vendor specializing in the creation of intelligent development tools.
- [Libraries.io](https://libraries.io/) - Open source discovery service.
- [LoginRadius](https://www.loginradius.com/)  `requires-approval`  - Authentication and SSO Made Simple.
- [Mailman 3](https://mailman3.com/) `requires-approval` - Mailing lists for distributed teams.
- [Mailtrap](https://mailtrap.io/) `requires-approval` - Fake SMTP testing server.
- [Netlify](https://www.netlify.com) `requires-approval` - Hosting for static sites.
- [Sourcegraph](https://sourcegraph.com/) - Smart source code transparency.
- [Siteleaf](https://www.siteleaf.com/) - CMS for static sites.
- [testmail.app](https://testmail.app/) `requires-approval` - Automate end-to-end email tests with unlimited mailboxes and a GraphQL API.
- [Transloadit](https://transloadit.com/) `requires-approval` - API for file uploading & encoding.
- [Zulip](https://zulip.com) `requires-approval` - Chat for distributed teams.

## Contributing

Please see the [contributor guidelines](https://github.com/zachflower/awesome-open-source-supporters/blob/master/.github/CONTRIBUTING.md) and [code of conduct](https://github.com/zachflower/awesome-open-source-supporters/blob/master/.github/CODE-OF-CONDUCT.md) for details.

## Tags

### `requires-approval`

While many companies use the public repositories feature of GitHub, Bitbucket, and GitLab to determine the Open Source status of a project, there are others who require more verification. These companies have been marked with a `requires-approval` tag, indicating that an application process is required to take advantage of their Open Source benefits.

### `non-commercial`

Some companies make their products available for open source, but only for non-commercial projects. These companies have been marked with a `non-commercial` tag.
