<div class="github-widget" data-repo="delftopenhardware/awesome-open-hardware"></div>
## Awesome Open Hardware [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)<!-- omit in toc -->

🛠 Helpful items for making and learning about open source hardware projects.



  
## Projects

* [Arduino](https://www.arduino.cc/) - Arduino is an open-source electronics platform.
* [Prusa3D](https://www.prusa3d.com/) - 3D printer manufacturer who shares their work open online.
* [Precious Plastic](https://www.preciousplastic.com/) - Tools to make plastic recycling as simple as possible.
* [Open Source Ecology](https://www.opensourceecology.org/) - Industrial machines made open.
* [SafeCast](https://safecast.org/) - Environmental measurements for the public domain.
* [WikiHouse](https://www.wikihouse.cc/) - Digital designed open housing.
* [RepRap](https://reprap.org/wiki/RepRap) - Humanity's first general-purpose, self-replicating manufacturing machine.
* [OpenBCI](https://openbci.com/) - Brain computer interface.
* [OpenMV](https://github.com/openmv/openmv) - Open-source, low-cost machine vision platform.
* [OpenSPIM](https://openspim.org/) - Open Access platform for Three-dimensional (3D) microscopy.
* [mesoSPIM](http://mesospim.org/) - Open-source light-sheet microscopes for imaging in cleared tissue.
* [Mutable Instruments](https://mutable-instruments.net/) - Open-source eurorack classics.
* [openUC2](https://github.com/openUC2/UC2-GIT) - Open-source modular microscopy toolbox.
* [OpenFlexure](https://openflexure.org/) - Open-source, 3D-printed microscope, including a precise mechanical stage.
* [Open-Source-Rover](https://github.com/nasa-jpl/open-source-rover) - A six wheeled, build-it-yourself, open-source rover.
* [Biohack Academy](http://biohackacademy.github.io/) - Open-source biotechnological hardware such as Incubator, Thermocycler, Centrifuge, Microscope, etc.
* [GaudiLab](http://www.gaudi.ch/GaudiLabs/?page_id=19) - Open-source hardware projects for biology laboratories.
* [Winterbloom](https://winterbloom.com) - Open-source eurorack modules, Thea has some stellar design write-ups on her blog.
* [Open Gamma Detector](https://github.com/Open-Gamma-Project/Open-Gamma-Detector) - Hackable, low-cost gamma-ray spectrometer.
* [Opulo](https://docs.opulo.io/) - Project that develops a pick and place machine.
* [FarmBot](https://farm.bot/pages/open-source) - automated gardening machine to grow vegetables.
* [PiKVM](https://pikvm.org/) - Open and inexpensive DIY IP-KVM based on Raspberry Pi.
* [Mekanika](https://www.mekanika.io/) - Tools & Machines for Makers

## Talks

* [How Open Hardware will Take Over the World](https://www.youtube.com/watch?v=Rfu_MKgu2Ik) - TEDx talk by Nathan Seidle.
* [Revolution of the open hardware](https://www.youtube.com/watch?v=t56bojFAnUg) - TEDx talk by Bram Geenen.
* [Why do open hardware](https://www.youtube.com/watch?v=UYRhupdnUcY) - Talk by Limor Fried (ladyada).
* [Get your open hardware manufactured](https://www.youtube.com/watch?v=ifTaGRTPwLc) - Tips by Ian of Dangerous Prototypes.
* [Open Hardware Projects to Fight COVID-19](https://www.youtube.com/watch?v=c1pwbnDAub0) - Collection video from N-O-D-E.
* [Designing Open Hardware for 21st century science](https://www.youtube.com/watch?v=Od_9yJqc098) - Presentation by Andre Maia Chagas.
* [Why open source hardware is(n't) working](https://www.youtube.com/watch?v=7ifGu22bhd4) - Presentation by David Cuartielles.
* [Open source and the future of hardware](https://www.youtube.com/watch?v=_EZT57dtWHM) - Talk by Neil Gershenfeld.
* [On behalf of mankind: thank you for sharing!](https://www.youtube.com/watch?v=HBS8sS138GE) - TEDx talk by Jerry de Vos

## Papers

* [What is the “Source” of Open Source Hardware?](https://doi.org/10.5334/joh.7) - Paper by Jérémy Bonvoisin, Robert Mies, Jean-François Boujut, Rainer Stark.
* [Emerging Business Models for Open Source Hardware](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3331121) - Paper by Joshua M. Pearce.
* [Towards national policy for open source hardware research: The case of Finland](https://doi.org/10.1016/j.techfore.2020.119986) - Paper by I. T. S. Heikkinen, H. Savin, J. Partanen, J. SeppäläJ, M. Pearce.
* [Open-Source Hardware in Education: A Systematic Mapping Study](http://dx.doi.org/10.1109/ACCESS.2018.2881929) - Paper by Ruben Heradio, Jesus Chacon, Hector Vargas, Daniel Galan, Jacobo Saenz, Luis De La Torre, Sebastian Dormido.
* [Haves and have nots must find a better way: The case for open scientific hardware](https://doi.org/10.1371/journal.pbio.3000014) - Paper by Andre Maia Chagas
* [Open Labware: 3-D Printing Your Own Lab Equipment](https://doi.org/10.1371/journal.pbio.1002086) - Paper by Tom Baden, Andre Maia Chagas, Greg Gage, Timothy Marzullo, Lucia L. Prieto-Godino, Thomas Euler

## Conferences

* [Fosdem](https://fosdem.org/2022/) - Open Source event online on 5 & 6 February 2022.
* [Open Hardware Summit](https://2022.oshwa.org/) - Annual conference on open hardware on 22 April 2022.
* [Maker Faire](https://makerfaire.com/) - A celebration of the Maker Movement, locally organized.

## Platforms

* [Open Hardware Repository](https://ohwr.org/welcome) - For electronics designers at experimental physics facilities to collaborate on open hardware designs.
* [Open Hardware Observatory](https://en.oho.wiki/wiki/Home) - Free blueprints for sustainable open hardware.
* [Instructables](http://www.instructables.com/tag/type-id/category-technology/) - Instructables is a place that lets you explore, document, and share your creations.
* [Hackaday.io](https://hackaday.io/) - Hackaday.io is the world's largest collaborative hardware development community.
* [Hackster.io](https://www.hackster.io/about) - Connecting developers where exploring tomorrow starts today.
* [Openhardware.io](https://www.openhardware.io/about) - Tracking amazing open hardware projects.
* [Openhardware.science](https://openhardware.science/) - Make open science hardware ubiquitous by 2025.
* [Openlifescience](https://openlifesci.org/) - Program to make Open Science ambassadors in research.
* [Thingiverse](https://www.thingiverse.com/) - A platform for sharing and contributing to design hardware for 3D printing, laser cutting and CNC milling.
* [Kitspace.org](https://kitspace.org) - A place to build and share electronics projects. 

## Podcasts

* [Road to Open Science](https://open.spotify.com/episode/46WwrOofygFyGrp6X42NOe?si=_qxPzPXkQaGNBqB-bnKwyw) - Episode on open hardware in the Netherlands.
* [Physics Worlds](https://open.spotify.com/episode/4pjaUpl96YhjqBvjzV0K1H?si=ssJJH7ouSOW_ttGvF2Mtdg) - Episode on the global impact of open hardware.
* [Command Line Heroes](https://open.spotify.com/episode/1yGuG9TKvS2lkH7wgRO8YF?si=PwAZCT0qSxW87HQlCa7AeA) -  Episode Makers unite.
* [A-podcast](https://open.spotify.com/episode/2Zp3q6ePDCp0Yeyq9ADDny?si=8_CuBG2ESEeoxvcspVi3Xg) -  Open source hardware is the future.
* [Amp hour](https://podcasts.google.com/feed/aHR0cHM6Ly90aGVhbXBob3VyLmxpYnN5bi5jb20vcnNz/episode/aHR0cDovL3d3dy50aGVhbXBob3VyLmNvbS8_cD0xNTg?sa=X&ved=0CAIQuIEEahcKEwjgkZnWjPr0AhUAAAAAHQAAAAAQCA) - Open Hardware and The Creative Economy.
* [Semiconductor Insiders](https://semiwiki.com/podcast/podcast-ep44-open-hardware-diversity-alliance/) - Open Hardware Diversity Alliance.
* [Open source hardware podcast](https://podcasts.google.com/feed/aHR0cHM6Ly9wcm9ncmFtbWluZ2VsZWN0cm9uaWNzLmNvbS9jYXRlZ29yeS9yYWRpby1zaG93L2ZlZWQv) - By the Programming Electronics Academy.

## Books

* [Building open source hardware](https://books.google.nl/books?id=wg27BQAAQBAJ&lpg=PP1&dq=open%20source%20hardware&pg=PP1##v=onepage&q=open%20source%20hardware&f=false) - Book by Alicia Gibb, on building open source hardware from 2014.
* [Open-source Lab](https://books.google.nl/books?id=0bOKAAAAQBAJ&lpg=PP1&dq=open%20source%20hardware&pg=PP1##v=onepage&q=open%20source%20hardware&f=false) - Book by Josua m. Pearce, how to build your own hardware and reduce costs.
* [Free to Make](https://books.google.nl/books?id=jz1bCwAAQBAJ&lpg=PA93&dq=open%20source%20hardware&pg=PP1##v=onepage&q=open%20source%20hardware&f=false) -  Book by Dale Dougherty, how the maker movement is changing our schools, our jobs, and our minds.
* [The bridge](https://www.nae.edu/174695/Fall-Bridge-on-Open-Source-Hardware) - Issue of the national academy of engineering on open source hardware.


## Training programs

* [Open Hardware Makers](https://openhardware.space)
* [Open Hardware Academy](https://openhardware.academy/)

## Further Readings

* [Open Source Guide](https://opensource.guide/) - A website created by GitHub to help people work on open source projects.
* [Wikipedia](https://en.wikipedia.org/wiki/Open-source_hardware) - General information about Open Source Hardware.
* [Open Collective](https://opencollective.com/) - Enables groups to quickly set up a collective, raise funds and manage them transparently.
* [The Journal of Open Hardware](https://openhardware.metajnl.com/) - (JOH) is a peer reviewed open access publication for open hardware research and development.
* [OSHWA Certification](https://certification.oshwa.org/) -  Provides an easy and straightforward way for producers to indicate that their products meet a uniform and well-defined standard for open-source compliance.
* [HardwareX Journal](https://www.journals.elsevier.com/hardwarex) - An open access scientific hardware journal.

## Related awesome

* [Awesome Open Electronics](https://github.com/ajaymnk/open-electronics) - List with resources for Electronics Enthusiasts.
* [Awesome Open](https://github.com/paulhendricks/awesome-open) - A list of open companies and communities.
* [Awesome Electronics](https://github.com/kitspace/awesome-electronics) - A curated list of awesome resources for electronic engineers and hobbyists.

## Contributing

Additional suggestions are welcomed! Check out contributing.md for guidelines.
If you ever want to reference us, find us at [delftopenhardware.nl](https://delftopenhardware.nl). But you are in no way required to do so.
(NOTE: If you're a maintainer listed on here who would like to be removed, just open an issue.)
