<div class="github-widget" data-repo="opencompany/awesome-open-company"></div>
## Awesome Open Company [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
A community-curated list of awesome [open companies](#what-is-an-open-company),
inspired by the many [awesome-x lists](https://github.com/sindresorhus/awesome) out there.

(**[click here](#companies)** to jump straight to the list below.)

*Contributions to this list are welcome! Just [edit the README.md](https://github.com/opencompany/awesome-open-company/blob/master/../../edit/master/README.md) (this document) and send the changes as a pull request. [Guidelines](https://github.com/opencompany/awesome-open-company/blob/master/../../wiki/Inclusion+guidelines) are available.*

2. **[Companies](#companies)**

## What is an open company?

An **open company** is defined, for the purposes of this list, as a for-profit organization whose core practices are guided by principles of openness, transparency and interoperability. This philosophy can be summarized by the maxim:

> **Share as much as possible, charge as little as possible.**

derived from the [original formulation](http://blog.gittip.com/post/26350459746/the-first-open-company/) by Gittip (now [Gratipay](http://gratipay.com)).

In practice, this often means:
- releasing its products as
  [free and open source software](https://en.wikipedia.org/wiki/Free_and_open-source_software),
  [open content](https://en.wikipedia.org/wiki/Free_content),
  or [open source hardware](https://en.wikipedia.org/wiki/Open-source_hardware)
- using [open standards](https://en.wikipedia.org/wiki/Open_standard)
  and [inter-operable formats](https://en.wikipedia.org/wiki/Interoperability)
- developing its products openly, using public communication channels
- publishing as much financial and operational data as possible, without compromising customer privacy.
- etc.

The following pages provide a more detailed overview of this concept:
- [Open business](https://en.wikipedia.org/wiki/Open_business): Wikipedia article
- [Open business](http://p2pfoundation.net/Open_Business): from the P2P Foundation wiki

## Companies

Company      | Openness Pledge | Open Product  | Statement     | Open Finance
------------ | --------------- | ------------- | ------------- | ------------
![Arduino LLC favicon](http://www.google.com/s2/favicons?domain=arduino.cc) [**Arduino LLC**](https://www.arduino.cc) | [Arduino - Introduction](https://www.arduino.cc/en/Guide/Introduction) | :octocat:[Arduino](https://github.com/arduino/Arduino/) |  |
![Atlassian favicon](http://www.google.com/s2/favicons?domain=atlassian.com) [**Atlassian**](https://www.atlassian.com/) | [Company values — Atlassian](https://www.atlassian.com/company/about/values) | N/A |  |
![Axem favicon](https://s2.googleusercontent.com/s2/favicons?domain_url=https://axemsolutions.io/) [**Axem**](https://axemsolutions.io) | [DEM](https://axemsolutions.io/dem_doc/index.html) | :octocat:[DEM](https://github.com/axem-solutions/dem) |  |
![Balsamiq favicon](http://www.google.com/s2/favicons?domain=balsamiq.com) [**Balsamiq**](https://balsamiq.com/) | [Company — Balsamiq](https://balsamiq.com/company/#goodcitizen) | N/A |  |
![Bevry favicon](http://www.google.com/s2/favicons?domain=bevry.me) [**Bevry**](https://bevry.me) | [Bevry](https://bevry.me) | [DocPad](https://github.com/docpad/docpad) |  |
![Buffer favicon](http://www.google.com/s2/favicons?domain=buffer.com) [**Buffer**](https://buffer.com/) | [Buffer's transparency dashboard: Public salaries, equity and more](https://buffer.com/transparency) | :octocat:[Misc](https://github.com/bufferapp/) |*[Why we have a core value of transparency at our startup](http://joel.is/why-we-have-a-core-value-of-transparency-at-our-startup/)*| [Revenue](https://open.buffer.com/buffer-public-revenue-dashboard/)
![CodeCombat favicon](http://www.google.com/s2/favicons?domain=codecombat.com/) [**CodeCombat**](http://codecombat.com/) | [CodeCombat - Learn how to code by playing a game](http://codecombat.com/legal) | :octocat:[CodeCombat](https://github.com/codecombat/codecombat) |*[Why you should open-source your startup](http://blog.codecombat.com/why-you-should-open-source-your-startup)*|
![Couchbase favicon](http://www.google.com/s2/favicons?domain=couchbase.com) [**Couchbase**](http://www.couchbase.com/) | [Open Source Projects](http://www.couchbase.com/open-source) | :octocat:[All Products](https://github.com/couchbase) |  |
![Dangerous Prototypes favicon](http://www.google.com/s2/favicons?domain=dangerousprototypes.com) [**Dangerous Prototypes**](http://dangerousprototypes.com/) | [About - DP](http://dangerousprototypes.com/docs/About) | [Projects](https://code.google.com/archive/p/dangerous-prototypes-open-hardware/) |  |
![Daytona favicon](http://www.google.com/s2/favicons?domain=daytona.io) [**Daytona**](https://www.daytona.io/) | [Open Source](https://github.com/daytonaio/daytona/blob/main/README.md) | [Daytona](https://github.com/daytonaio/daytona) |  |
![Documenso favicon](http://www.google.com/s2/favicons?domain=documenso.com) [**Documenso**](https://documenso.com/) | [The Documenso Manifest](https://documenso.com/blog/manifest) | :octocat:[Documenso](https://github.com/documenso/documenso) | [Announcing Open Metrics](https://documenso.com/blog/pre-seed) | [Open Metrics](https://documenso.com/open/)
![Dreamwidth favicon](http://www.google.com/s2/favicons?domain=dreamwidth.org) [**Dreamwidth**](http://www.dreamwidth.org/) | [About Dreamwidth Studios](http://www.dreamwidth.org/about) | :octocat:[Dreamwidth](https://github.com/dreamwidth/) |  |
![Elastic favicon](http://www.google.com/s2/favicons?domain=elastic.co) [**Elastic**](https://elastic.co) | [Openness, transparency, and collaboration are at the heart of all that we do.](https://www.elastic.co/about/free-and-open) | :octocat:[Misc](https://github.com/elastic/) |  |
![Gitlab favicon](http://www.google.com/s2/favicons?domain=gitlab.com) [**GitLab**](https://about.gitlab.com/) | [About Us — GitLab](https://about.gitlab.com/about/) | [GitLab](https://gitlab.com/groups/gitlab-org) |  |
![Gratipay favicon](http://www.google.com/s2/favicons?domain=gratipay.com) [**Gratipay**](https://gratipay.com/) | [Welcome to Gratipay](https://web.archive.org/web/20171023221922/http://inside.gratipay.com/big-picture/welcome) | :octocat:[All Products](https://github.com/gratipay) |*[The first open company](http://blog.gittip.com/post/26350459746/the-first-open-company/)*| [Finance](https://github.com/gratipay/finances#readme)
![Growstuff favicon](http://growstuff.org/assets/favicon-2f083c214b9adaf9e2ce78bcd532e4c9.ico) [**Growstuff**](http://www.growstuff.org/) | [(archive) Values - Growstuff Wiki](http://web.archive.org/web/20150906064358/http://wiki.growstuff.org/index.php/Values) | :octocat:[Growstuff](https://github.com/Growstuff/growstuff) |*[Why Growstuff is open source](https://web.archive.org/web/20151015172213/http://blog.growstuff.org/2013/02/20/why-growstuff-is-open-source/)*|
![Lichess favicon](http://www.google.com/s2/favicons?domain=lichess.org) [**Lichess**](https://lichess.org/) | [Lichess terms of service](https://lichess.org/terms-of-service) | [Lichess source code](https://lichess.org/source) | [Why Lichess will always be free](https://lichess.org/@/lichess/blog/why-lichess-will-always-be-free/YF-ZORQA) | [Costs](https://docs.google.com/spreadsheets/d/1Si3PMUJGR9KrpE5lngSkHLJKJkb0ZuI4/preview)
![LulzBot favicon](http://www.google.com/s2/favicons?domain=lulzbot.com) [**LulzBot**](https://lulzbot.com/) (formerly [Aleph Objects](https://en.wikipedia.org/wiki/Aleph_Objects))| [Choosing a Free License for Your 3D Project](https://lulzbot.com/learn/choosing-a-free-license-for-your-3d-project) | [LulzBot 3D](https://gitlab.com/lulzbot3d) |  |
![MapBox favicon](http://www.google.com/s2/favicons?domain=mapbox.com) [**MapBox**](http://mapbox.com/) | [Open Source - MapBox](http://mapbox.com/about/open) | :octocat:[Misc](https://github.com/mapbox) |  |
![Neocities favicon](http://www.google.com/s2/favicons?domain=neocities.org) [**Neocities**](https://neocities.org/) | [(archive) Neocities - stats](http://wayback.archive.org/web/20150907143713id_/https://neocities.org/stats) | :octocat:[Neocities.org](https://github.com/neocities/neocities) |*[The first Neocities Open Company report](https://neocities.org/blog/open-company-progress-report-2014)*|
![New Vector favicon](https://www.google.com/s2/favicons?domain=vector.im) [**New Vector**](https://vector.im/) | [Work in the open](https://vector.im/) | :octocat:[Misc](https://github.com/vector-im/) |  |
![Niteo favicon](https://www.google.com/s2/favicons?domain=niteo.co) [**Niteo**](https://niteo.co/) | [Niteo Handbook](https://github.com/niteoweb/handbook) | :octocat:[Pareto Security](https://github.com/paretoSecurity/) |  |
![OpenCraft favicon](http://www.google.com/s2/favicons?domain=opencraft.com) [**OpenCraft**](http://opencraft.com/) | [OpenCraft — Open edX Development &amp; Hosting Services](http://opencraft.com/) | N/A |  |
![ProtonMail favicon](https://www.google.com/s2/favicons?domain=protonmail.ch) [**ProtonMail**](https://protonmail.ch) | [ProtonMail is Open Source!](https://protonmail.com/blog/protonmail-open-source/) | [Web Client](https://github.com/ProtonMail/WebClient); [OpenPGPjs](https://github.com/openpgpjs/openpgpjs) | [ProtonMail Open Source Cryptography](https://protonmail.com/blog/protonmail-open-source-crytography/) | |
![Read the Docs favicon](http://www.google.com/s2/favicons?domain=readthedocs.org) [**Read the Docs**](https://readthedocs.org/) | [Read the Docs Open Source Philosophy](https://docs.readthedocs.io/en/latest/open-source-philosophy.html) | :octocat:[readthedocs.org](https://github.com/rtfd/readthedocs.org) |  | [Funding](http://blog.readthedocs.com/read-the-docs-2017-stats/#funding) |
![Red Hat favicon](http://www.google.com/s2/favicons?domain=redhat.com) [**Red Hat**](https://www.redhat.com/) | [Red Hat Jobs - Our culture](https://www.redhat.com/en/jobs/life/culture) | [Misc](https://www.redhat.com/en/open-source/communities) |  |
![RStudio](http://www.google.com/s2/favicons?domain=rstudio.com) [**RStudio**](https://www.rstudio.com) | [What makes RStudio different?](https://www.rstudio.com/about/what-makes-rstudio-different/) | [RStudio - About](https://www.rstudio.com/about)
![Sentry favicon](https://www.google.com/s2/favicons?domain=sentry.io) [**Sentry**](https://sentry.io/) | [About Sentry](https://sentry.io/about/) | [Sentry](https://github.com/getsentry/sentry) | [Driven by Open Source](https://blog.sentry.io/2015/06/30/driven-by-open-source) | |
![SoftwareMill favicon](https://www.google.com/s2/favicons?domain=softwaremill.com) [**SoftwareMill**](https://softwaremill.com/) | [40 CEOs in 1 company](https://blog.softwaremill.com/40-ceos-in-one-company-teal-organisation-interview-21124c34c16) | :octocat:[Misc](https://github.com/softwaremill) | | [Open finances](https://softwaremill.com/finances-in-company/?utm_source=GitHub&utm_medium=teal) |
![Tessel favicon](http://i.imgur.com/Xe9AYlw.png) [**Tessel**](https://tessel.io/) | [Open Source - Tessel](https://tessel.io/opensource) | :octocat:[Tessel](https://github.com/tessel/project) |  |
![Transloadit favicon](https://www.google.com/s2/favicons?domain=transloadit.com) [**Transloadit**](https://transloadit.com/) | [Open Source](https://transloadit.com/open-source/) | :octocat:[Uppy](https://uppy.io) | [Jobs & Culture](https://transloadit.com/jobs/) |
![wemake.services favicon](https://www.google.com/s2/favicons?domain=wemake.services) [**wemake.services**](https://wemake.services/) | [wemake-services/meta § Purpose](https://github.com/wemake-services/meta/blob/master/README.md#purpose) | :octocat:[wemake.services](https://github.com/wemake-services) |
![watermelon favicon](https://www.google.com/s2/favicons?domain=watermelontools.com) [**Watermelon**](https://www.watermelontools.com/) | [Promoting Openness, Starting With the Codebase](https://www.watermelontools.com/post/promoting-openness-starting-with-the-codebase) | :octocat:[Watermelon](https://github.com/watermelontools/watermelon) |

### Pioneers

Company      | Openness Pledge | Open Product  | Statement     | Open Finance
------------ | --------------- | ------------- | ------------- | ------------
[**Clarify**](https://web.archive.org/web/20201130045805/https://www.clarify.so/) | Clarify - Launch and manage your career | N/A |  |

## Resources

### Books
- Don Tapscott, Anthony D. Williams: [Wikinomics](https://en.wikipedia.org/wiki/Wikinomics)
- James M. Whitehurst: [The Open Organization: Igniting Passion and Performance](https://www.redhat.com/en/explore/the-open-organization-book)
- [The Open Organization Field Guide](https://opensource.com/open-organization/resources/field-guide)

### Articles
- Paul Graham: [What business can learn from open source](http://www.paulgraham.com/opensource.html)
- Massimo Menichinelli: [Business models for open hardware](http://www.openp2pdesign.org/2011/open-design/business-models-for-open-hardware/)
- Roger Clarke: [Open source software and open content as models for eBusiness](http://www.rogerclarke.com/EC/Bled04.html)
- Chris Anderson: [A business model for open source hardware](http://www.longtail.com/the_long_tail/2009/01/a-business-mode.html)
- *The Economist*: [Open-source business: Open, but not as usual](http://www.economist.com/node/5624944)
- Chad Whitacre: [The second open company](https://medium.com/gratipay-blog/the-second-open-company-4cbab7ca1a47)
- Timothy Cook: [Why open companies? A new culture of business](https://medium.com/open-companies/why-open-companies-fdb74d1b4f0f)
- Shereef Bishay: [The open enterprise manifesto](http://www.opencompany.org/resources/whitepaper.pdf)

### Videos
- [BetterMeans introduction](https://www.youtube.com/watch?v=MAlnMWlvw9g)

## Similar lists
- [The Open Company Initiative directory](http://www.opencompany.org/directory/) (OCI):
  A group of companies which explicitly adopted OCI's openness pledge
  - *(dormant)*
- [The Open 100](http://wayback.archive.org/web/20110824041839/http://www.openbusiness.cc/category/directory/openbusiness/): a [competition held in 2009-2010](http://wayback.archive.org/web/20120727175118/http://www.openbusiness.cc/open100/about/) to find the top 100 open innovation companies
  - *(defunct — these links are from the Web Archive)*
- The VAR Guy's [The Open Source 50](https://web.archive.org/web/20171002071840/http://thevarguy.com/var-guy/var-guys-open-source-50) ([2009 list](http://wayback.archive.org/web/20121118155240/http://www.thevarguy.com/the-open-source-50/the-open-source-50-listed-a-to-z/), [2010 list](http://wayback.archive.org/web/20120509194329/http://www.thevarguy.com/the-open-source-50/the-open-source-50-a-to-z-2010-edition/), [2012 update](https://web.archive.org/web/20171027055302/http://thevarguy.com/open-source-application-software-companies/top-50-open-source-companies-where-are-they-now))
  - *(unmaintained)*
- [Awesome Open](https://github.com/paulhendricks/awesome-open):
  A curated list of organizations, projects and initiatives that maintain open codebases and datasets

## License
*This work and all contributions to it are released into the public domain under the terms of the [CC0 1.0](https://creativecommons.org/publicdomain/zero/1.0/).*
