<div class="github-widget" data-repo="domenicosolazzo/awesome-okr"></div>
## Awesome OKR [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
关于 OKR 的精选资源列表

OKR 是设定和传达公司、团队和员工目标并根据取得的结果衡量他们的进展的最佳实践.
它被谷歌、Netflix、Zynga、LinkedIn、Twitter 等多家公司使用，它使所有员工更容易围绕公司使命和愿景进行调整.


## Basics

- [Basic of OKR](https://github.com/domenicosolazzo/practice-okr/blob/master/Basic.md): 关于 OKR 的基本概念.
- [Worksheet OKR template](https://github.com/domenicosolazzo/practice-okr/blob/master/Worksheet.md): 用于开始 OKR 规划的工作表
- [Use a weekly status email](https://github.com/domenicosolazzo/practice-okr/blob/master/Weekly_Status_Email)：如何针对您的 OKR 设置每周状态电子邮件.
- [How to set OKRs](https://github.com/domenicosolazzo/practice-okr/blob/master/How_to_set_OKRs.md)：有关如何在公司中设置 OKR 的快速列表.
- [Monday's and Friday's: The commitment square](https://github.com/domenicosolazzo/practice-okr/blob/master/Commitment-Square.md)：用于分析 OKR 的进展和障碍的承诺方块.
- [Fundamentals of OKR](https://medium.com/startup-tools/okrs-5afdc298bc28)：很棒的文章，通过 Uber 和 Youtube 的真实示例描述了 OKR 的基础知识.

## Slides

- [OKR: A guide](http://www.slideshare.net/mustansir78/guide-to-okr-objectives-key-results)：什么是 OKR，它对我有什么好处？
- [The Basics of OKR](http://www.slideshare.net/HenrikJanVanderPol/how-to-outperform-anyone-else-introduction-to-okr)：介绍 OKR 基本概念的精彩演示.
- [Organizing and engineering Team on Asana](http://www.slideshare.net/asana/organizing-an-engineering-team-using-asana)：Asana 如何在其工程团队中使用关键结果
- [Executioner's tale](http://www.slideshare.net/cwodtke/the-executioners-tale-34241002)：克里斯蒂娜·沃特克 (Christina Wodtke) 的演讲“刽子手的故事”中的幻灯片.
- [How to implement OKRs to drive company performance](http://www.slideshare.net/7Geese/learn-how-to-implement-okrs-to-drive-company-performance): Learn how to implement the OKRs goal-setting process to drive company performance
- [The 6 major benefits of OKR](http://www.slideshare.net/HenrikJanVanderPol/okrs-6-most-important-benefits-of-objectives-key-results/9-About_the_authorHenrikJan_is_an)：描述在贵公司使用 OKR 的主要好处
- [OKR - Objectives and Key Results](http://www.slideshare.net/weekdone/okr-objectives-and-keyresults): WeekDone 对 OKRs 的一个很好的概述
- [Power your business with OKR](http://www.slideshare.net/wrike/power-your-business-with-okrs/17-Awardwinning_Collaboration_Project_Management_SoftwareBrought)：关于 OKR 的概述以及如何通过 Wrike 为您的业务提供动力
- [OKR - a guide to objectives and key results](http://www.slideshare.net/DanKeegan/okr-a-guide-to-objectives-and-key-results-36471600)
- [The Guide to Objectives and Key Results](http://www.slideshare.net/BetterWorks/the-guide-to-okrs)：Benchify 对 OKR 的轻量级和信息性概述
- [How to define good OKRs](http://www.slideshare.net/HenrikJanVanderPol/how-to-set-good-ok-rs): 很棒的幻灯片，描述了如何设置好的 OKR
- [From Intel to Google](http://www.slideshare.net/andrefaria/ok-rs)：如何使用英特尔发明并被谷歌使用的方法实现您的目标

## Videos

- [How google sets goals objectives and Key results](https://www.gv.com/lib/how-google-sets-goals-objectives-and-key-results-okrs): Rick Klau@Google 最著名的 OKR 视频
- [The Executioner's Tale](https://vimeo.com/86392023): 刽子手的故事，克里斯蒂娜·沃特克 (Christina Wodtke)
- [Warm Gun Talk](http://eleganthack.com/my-warm-gun-talk-on-okrs/): 克里斯蒂娜·沃特克 (Christina Wodtke) 的另一篇关于 OKR 的演讲

## Books

- [Measure What Matters](https://www.whatmatters.com/book)：John Doerr 制定和实现大胆目标的手册.
- [目标和关键结果：通过 OKR 推动焦点、协调和参与] (https://www.wiley.com/en-gb/Objectives+and+Key+Results:+Driving+Focus,+Alignment,+and +Engagement+with+OKRs-p-9781119252399) ：关于实施与大型企业环境以及数字初创企业相关的 OKR 的详尽可读指南.

## Articles

- [John Doerr on success using OKR](http://blog.betterworks.com/keys-okr-success-qa-john-doerr/): OKR 成功的关键：与将 OKR 引入 Google 的人 John Doerr 的问答
- [How Google Grew from 40 to 40,000 Employees](https://blog.betterworks.com/how-google-grew/): OKR 如何帮助像谷歌这样的公司从 40 名员工发展到 40,000 名员工
- [Implementation and challanges at Pusher](https://blog.pusher.com/okrs-implementation-challenges/): Pusher 的实施、挑战和结果
- [How we make OKRs work at Pusher](https://blog.pusher.com/make-okrs-work/)：一篇关于 OKR 的一致性和透明度以及它如何帮助 Pusher 的好文章
- [How to Easily Set Quarterly Team Objectives with OKRs at Pusher](https://blog.pusher.com/how-to-set-quartely-okrs-for-your-teams/)：Pusher 的另一篇关于他们如何设定季度团队目标的文章
- [How we set goals at Upstart](http://blog.upstart.com/okrs-and-projects-how-we-set-goals-at-upstart/): Upstart 如何为整个公司设定 OKR 和目标
- [Manager OKRs, Maker OKRs: How I’d Change Google’s Goal Setting Process](http://hunterwalk.com/2013/03/01/manager-okrs-maker-okrs-how-id-change-googles-goal-setting-process/): Sasha Lubomirsky 如何展望 OKR 的未来
- [Are You a C.E.O. of Something?](http://www.nytimes.com/2010/01/31/business/31corner.html?pagewanted=2&_r=4&): 采访马克·平卡斯 (Mark Pincus) 以及 OKR 如何帮助 Zynga
- [How to set & achieve meaningful OKRs](http://blog.kentonkivestu.com/goals-how-to-get-things-done)：本文介绍了如何设置和实现有意义的 OKR
- [How to Make OKRs Actually Work at Your Startup](http://firstround.com/review/How-to-Make-OKRs-Actually-Work-at-Your-Startup/)：关于 OKR 如何帮助 Swipely 的故事
- [OKR Mistakes](http://eleganthack.com/okr-mistakes-and-how-to-fix-them/)：这是一篇重要的文章，描述了编写 OKR 时最常见的错误以及如何解决这些错误.
- [ORK Worksheet](http://eleganthack.com/an-okr-worksheet/): 一个很好的 OKR 入门工作表
- [List of companies that use OKRs](https://www.atiim.com/blog/top-companies-that-use-okrs/)：使用 OKR 的顶级公司列表
- [How Google grades employees, and how you can use the same system at your company](http://www.businessinsider.my/google-okr-employee-grading-system-2015-10/)：Google 如何对员工进行评分，以及您如何在您的公司使用相同的系统.
- [What are OKRs?](https://www.atiim.com/okr/)：关于什么是 OKR 的基础知识.
- [15 great insights from the Google OKR video](https://www.atiim.com/blog/15-great-insights-from-the-google-okr-video/): 来自最著名的 OKR 视频的深刻见解
- [Full Transcription of Google OKR Video – How Google Sets Goals Using OKRs](https://www.atiim.com/google-okr-objectives-key-results-video-transcript/): 最著名的 OKR 视频的完整记录
- [How to Use KPIs with OKRs](https://www.atiim.com/blog/how-to-use-kpis-with-okrs/): 如何将 KPI 和 OKR 连接在一起.
- [What Twitter’s CEO Learned from Google](https://www.atiim.com/blog/what-twitters-ceo-learned-from-google/): 在 Twitter 上接受 Dick Costolo 关于 OKR 的采访
- [OKRs: The New Solution to Managing Your Freelancers](https://www.atiim.com/blog/okrs-new-solution-managing-freelancers/): 如何使用 OKR 雇佣和调整自由职业者
- [Google Releases a New Guide to Setting Goals with OKRs](https://www.atiim.com/blog/google-releases-a-new-guide-to-setting-goals-with-okrs/): 来自新的谷歌 OKR 指南的深刻见解
- [The biggest pitfalls of OKRs and how to avoid them](https://www.atiim.com/blog/the-biggest-pitfalls-of-okrs-and-how-to-avoid-them/): 采用 OKR 时的一些常见问题
- [This Is The Internal Grading System Google Uses For Its Employees — And You Should Use It Too](http://www.businessinsider.com/googles-ranking-system-okr-2014-1?IR=T)：来自 Business Insider 的另一篇关于 OKR 的文章和 Kris Klau 在谷歌的演讲中的深刻见解
- [We are starting to implement OKRs in our company for the first time. Do any of you have experience in terms of problems or issues encountered?](http://www.quora.com/We-are-starting-to-implement-OKRs-in-our-company-for-the-first-time-Do-any-of-you-have-experience-in-terms-of-problems-or-issues-encountered)：Quora 中关于人们如何实施 OKR 的有趣讨论.
- [What's a use case where a company uses both OKR and KPI?](http://www.quora.com/Whats-a-use-case-where-a-company-uses-both-OKR-and-KPI): 如何连接 OKR 和 KPI.
- [How does the process of developing and prioritizing OKRs (objectives and key results) work at companies like Google and Zynga?](https://www.quora.com/How-does-the-process-of-developing-and-prioritizing-OKRs-objectives-and-key-results-work-at-companies-like-Google-and-Zynga)：关于像谷歌这样的公司如何优先考虑他们的 OKRs 的一些有趣的答案.
- [OKRs do not cascade](http://felipecastro.com/en/okr/okrs-not-cascade/)
- [OKR 之旅] (https://www.hotpmo.com/blog/a-journey-through-okr)：介绍 OKR 及其在项目组合管理中的应用.
- [Being helpful isn’t the same as being clear](https://medium.com/product-narrative/sharing-lessons-learned-in-okr-f802aff4c251)：实施 OKR 时了解当地文化的有用说明.
- [Learnings from implementing OKRs](https://rnjn.in/articles/learnings-about-okrs/)：关于实施 OKR 的出色指南.

## Guides

这些是关于 OKR 的免费电子书和指南.

- [Set goals with OKRs by Google](https://rework.withgoogle.com/guides/set-goals-with-okrs/steps/introduction/): Google 关于 OKR 的官方指南
- [Definitive guide to OKRs (Ebook) by Atiim](https://www.atiim.com/resources/definitive-guide-to-okrs/): 描述如何设置 OKR 的电子书
- [How to Set OKR Goals like Google: Top 10 Tips by Atiim](https://www.atiim.com/resources/okr-top-10-tips/): 关于如何像谷歌一样设置 OKR 的 10 个技巧
- [The Smart Way to Set OKR](https://www.atiim.com/download-okr-checklist/): 关于如何设置 OKR 的简单清单

## Research

这些是与 OKR 相关的有趣研究论文

- [The Determinants of Goal Commitment](http://amr.aom.org/content/13/1/23.abstract) ：讨论了目标设定理论的一个关键方面——目标承诺的概念和衡量标准. 承诺与绩效之间关系的强度被断言取决于承诺的差异量.
- [Goal Setting and Task Performance: 1969-1980](http://datause.cse.ucla.edu/docs/eal_goa_1981.pdf)：当目标明确且具有足够的挑战性、受试者有足够的能力（并且能力差异得到控制）、提供反馈以显示与目标相关的进展、给予金钱等奖励时，目标设定最有可能提高任务绩效对于目标的实现，实验者或管理者是支持的，分配的目标被个人接受.

## Templates

用于设置 OKR 的单词模板列表.
- [OKR report document example by WeekDone](https://weekdone.com/resources/templates/okr-report-document-example)：用于设置 OKR 的 word 模板.
- [OKR report document template by WeekDone](https://weekdone.com/resources/templates/okr-report-document-template)：使用上述单词模板的 OKR 示例.
- [Startup OKRs Template](https://docs.google.com/document/d/1OHpQOvZz76_10ebJP2AKvvXUF3H9yd6FC89F5jS4mks/edit?pli=1): 描述如何设置 OKR 的单词模板
- [OKR Scorecard by Google](https://docs.google.com/document/d/1iK7oQ7d96isVEzUfvQYLIUZ8WU4vkSGgtOM-J7nFd7k/edit)：来自 re:Work 网站的 OKR 记分卡来自谷歌.


用于设置 OKR 的 Excel 模板列表.
- [OKR report word template by WeekDone](https://weekdone.com/resources/templates/okr-report-spreadsheet-template): 用于设置 OKR 的 Excel 模板.
- [OKR report spreadsheet example by WeekDone](https://weekdone.com/resources/templates/okr-report-spreadsheet-example)：使用上述 excel 模板的 OKR 示例.
- [OKR Template for your startup](https://docs.google.com/spreadsheets/d/1gsb2UNLeHkFAiEso4BPV10r5AudIJOx0PYhEsjAfd88/edit#gid=14): 用于设置 OKR 的公共 Excel 模板.
- [OKR Scorecard by Google](https://docs.google.com/spreadsheets/d/1KyKt6yAwu0NCM1f55JSjpOBpr5YjhIL4E_vYN0VWuEg/edit#gid=761446612) : 用于设置 OKR 的 excel 模板. 它与您在 Google 的 re:Work 站点中找到的相同

## Examples

有关如何实施 OKR 的示例列表. 当您想开始使用 OKR 时很有用.
这些不是真实的例子，我与以下公司无关.
- [Uber](https://github.com/domenicosolazzo/awesome-okr/blob/master/examples/Uber.md)：Uber 的 OKR 案例研究.
- [Youtube](https://github.com/domenicosolazzo/awesome-okr/blob/master/examples/Youtube.md)：Youtube 的 OKR 案例研究.
- [Sample Company](https://github.com/domenicosolazzo/awesome-okr/blob/master/examples/SampleCompany.md)：虚构公司的 OKR 示例.
- [Photo Editing App](https://github.com/domenicosolazzo/awesome-okr/blob/master/examples/PhotoEditingApp.md)：一家创建照片编辑移动应用程序并使用 OKR 实现其目标的虚假公司的 OKR 案例研究.
- [OKR Goals Examples](https://www.atiim.com/okr-goals-examples/)：各种团队和级别的 OKR 目标示例的完整列表.
- [25+ Site Reliability Engineering OKR examples](https://www.cruform.com/site-reliability-engineering-okrs/)：站点可靠性工程团队的 OKR 综合列表.
- [GitLab: Objectives and Key Results (OKRs)](https://about.gitlab.com/company/okrs/)：GitLab 的综合指南和真正的 OKR.
- [Measure What Matters: Examples & Resources](https://www.whatmatters.com/get-examples/)：OKR 示例列表.

## Software

用于管理 OKR 的软件列表. 此列表是使用此 Product Hunt 集合制作的： [PH Colletion](http://www.producthunt.com/@domenicosolazzo/collections/okr)

- [BetterWorks](http://www.producthunt.com/tech/betterworks)
- [Weekdone](http://www.producthunt.com/tech/weekdone)
- [Gtmhub](https://gtmhub.com)
- [7Geese](http://www.producthunt.com/tech/7geese)
- [StatusPath](http://www.producthunt.com/tech/statuspath)
- [Kapta](http://www.producthunt.com/tech/kapta)
- [Koan](https://www.koan.co/)
- [SmartProgress](http://www.producthunt.com/tech/smart-progress)
- [Strides](http://www.producthunt.com/tech/strides)
- [Workboard](http://www.producthunt.com/tech/workboard)
- [15five](http://www.15five.com/)
- [Zugata](http://www.zugata.com/)
- [Taskade](http://www.taskade.com/)
- [ZOKRI](https://zokri.com/)
- [Ally.io](https://ally.io/)

## Open Source Projects
- [BurningOkr](https://github.com/BurningOKR/BurningOKR)
- [okr2go](https://github.com/oxisto/okr2go)

## Contributing

Read [this](https://github.com/domenicosolazzo/awesome-okr/blob/master/CONTRIBUTING.md) 如果您想为此列表做出贡献.

## Code of conduct

Read [this](https://github.com/domenicosolazzo/awesome-okr/blob/master/CODE_OF_CONDUCT.md) 关于行为准则.

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Domenico Solazzo](https://github.com/domenicosolazzo) 已放弃该作品的所有版权和相关或邻接权.
