<div class="github-widget" data-repo="sindresorhus/awesome-observables"></div>
## Awesome Observables [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

&gt; 一个 [Observable](https://github.com/zenparsing/es-observable) 是一个随时间到达的集合.  Observable 可用于对基于推送的数据源建模，例如事件、计时器间隔、异步请求和动画.  Observable 可以使用类似数组的方法进行转换、组合和使用.

*请阅读 [contribution guidelines](https://github.com/sindresorhus/awesome-observables/blob/master/contributing.md) 在贡献之前.*



## Documentation

- [Overview](https://github.com/tc39/proposal-observable)
- [Specification](https://tc39.github.io/proposal-observable/)

## Implementations

- [zen-observable](https://github.com/zenparsing/zen-observable)
- [RxJS](https://github.com/ReactiveX/RxJS)

## Packages

- [ObservableLike](https://github.com/sindresorhus/type-fest/blob/main/source/observable-like.d.ts) - 打字稿类型.
- [any-observable](https://github.com/sindresorhus/any-observable) - 支持任何 Observable 库和 polyfill.
- [is-observable](https://github.com/sindresorhus/is-observable) - 检查一个值是否是一个 Observable.
- [observable-to-promise](https://github.com/sindresorhus/observable-to-promise) - 将 Observable 转换为 Promise.
- [stream-to-observable](https://github.com/jamestalmage/stream-to-observable) - 将 Node.js 流转换为 Observable.
- [symbol-observable](https://github.com/blesh/symbol-observable) - `Symbol.observable` ponyfill.
- [obsify](https://github.com/samverschueren/obsify) - 可观察化回调函数.
- [localForage-observable](https://github.com/thgreasi/localForage-observable) - localForage 的 Observables.

## Libraries

*这些是利用 Observable 强大功能的库，不一定是规范兼容的 Observable 实现.*

- [Cycle.js](http://cycle.js.org) - 一个功能性和响应式 JavaScript 框架，用于更清晰的代码.

## Articles

- [The introduction to Reactive programming you've been missing](https://gist.github.com/staltz/868e7e9bc2a7b8c1f754) - 使用 Observables 的反应式编程.
- [Everywhereness as a foundation](http://staltz.com/everywhereness-as-a-foundation.html) - 在任何地方使用 Observables 的好处.
- [Learning Observable By Building Observable](https://benlesh.com/posts/learning-observable-by-building-observable/) *（更新于 2021-07-08）*

## Videos

- [Introducing the Observable](https://egghead.io/lessons/javascript-introducing-the-observable) - Egghead.io 课程.

## Related

- [awesome-nodejs](https://github.com/sindresorhus/awesome-nodejs)
