<div class="github-widget" data-repo="machinomy/awesome-non-financial-blockchain"></div>
## Awesome Non-Financial Blockchain [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 构建区块链非金融应用程序的精选项目列表.

区块链是一种廉洁的经济交易数字分类账，可以对其进行编程，不仅可以记录金融交易，还可以记录几乎所有有价值的东西（通过 [Don Tapscott](https://www.linkedin.com/pulse/whats-next-generation-internet-surprise-its-all-don-tapscott)).

区块链的大部分应用都在金融领域. 这使得非金融应用程序更加有趣.

区块链应用的行业由变化最大的行业定义. 例如，停产的物联网比特币小额支付初创公司 [21](https://21.co) （现在 [Earn.com](https://earn.com) ) 可能会显着改变物联网和金融部门. 金融业会将其_current_ 实践扩展到一个新领域. 然而，对于物联网，_商业模式_ 将发生重大变化. 这种直觉支配着当前的分类.



## Identity Applications

### Public Blockchain Identity

- [Blockstack](https://blockstack.org)  - 分散的、无服务器的应用程序平台，用户可以在其中控制他们的数据. 包括身份.
- [Evernym](http://www.evernym.com) - 建立在开源许可区块链之上的自我主权身份.
- [Jolocom](https://jolocom.com) - 自主身份钱包.
- [SIN](https://en.bitcoin.it/wiki/Identity_protocol_v1) - 拟议的比特币身份协议.
- [uPort](https://www.uport.me) - 自我主权身份 [Ethereum](https://ethereum.org) 经过 [ConsenSys](https://consensys.net).

### Blockchain as a collateral

- [ShoCard](https://shocard.com) - 专有数字身份服务，使用区块链进行时间戳和安全文件交换.
- [Tradle](https://tradle.io/) - 在区块链上建立银行，身份作为抵押品.

### Unclear

- [KYC Chain](http://kyc-chain.com) - 用于在金融机构之间共享可验证的身份声明、数据或文件的安全平台.
- [ObjectChain Collab](http://www.objectchain-collab.com) - 基于分布式身份的跨行业协作.
- [UniquID](http://uniquid.com) - 人和设备的身份.
- [Vida Identity](https://vidaidentity.com) - 企业级区块链身份软件.

### Guidance

- [ID3](https://idcubed.org) - 数据驱动设计研究所，探索围绕自主权身份和分布式组织的问题.
- [OpenCreds](http://opencreds.org) - W3C 凭证社区组.
- [TAO Network Identity](http://tao.network/portfolio-item/the-identity-system/) - Tao.Network对区块链身份的描述.


## Internet of Things Applications

- [Chronicled](http://www.chronicled.com) - 区块链上的物联网设备注册.
- [Filament](http://filament.com) - 用于去中心化物联网系统的软件和硬件
- [IOTA](http://www.iotatoken.com) - 无块区块链上的去中心化物联网代币.
- [Machinomy](http://machinomy.com) - 物联网小额支付的分布式平台.
- [Project Oaken](https://www.projectoaken.com) - 物联网区块链平台.
- [Slock.it](https://slock.it) - 用于构建共享事物的基于以太坊的平台.


## Energy Applications

- [bankymoon](http://bankymoon.co.za/) - 区块链咨询. [Presented](http://goo.gl/L6vJBx) 比特币领先的智能电表. 一旦加满，它就会选择一个计划，并开始移动能量.
- [Co-Tricity](https://co-tricity.com/) - 分散的能源市场 [Innogy](https://innovationhub.innogy.com/) 和 [ConsenSys](https://consensys.net).
- [Electron](http://www.electron.org.uk/) - 在区块链上重塑能源.
- [GridSingularity](http://gridsingularity.com)  - 智能电网区块链. 宣布三年的技术工作.
- [lo3 energy](http://lo3energy.com)  - 能源服务、产品研发. 制造商 [Brooklyn Microgrid](http://brooklynmicrogrid.com) 随着 [ConsenSys](https://consensys.net).
- [lumo](https://lumoenergy.com.au)  - 能源供应商. 试验区块链.
- [PowerLedger](https://powerledger.io) - 分散的能源市场.
- [PowerPeers](https://www.powerpeers.nl/) - 荷兰的点对点能源市场.
- [Solar Change](http://www.solarchange.co/) - 制造商 [Solar Coin](http://solarcoin.org/) . 用于 MW 太阳能的山寨币.
- [Terraledger](https://terraledger.com) - 可再生能源证书的提供者.
- [ImpactPPA](https://impactppa.com) - 将购电协议下产生的电力再投资于更多购电协议.

## Media and Journalism

- [Steem](https://steem.io) - 激励内容创建和管理的去中心化社交网络.
- [PopChest](https://popchest.com) - 激励分布式视频平台.
- [Civil](https://joincivil.com) - 去中心化的新闻制作平台. 


## Talks and Books

- [19 Industries The Blockchain Will Disrupt](https://www.youtube.com/watch?v=G3psxs3gyf8) - 区块链改变的行业列表.
- [Blockchain Revolution](http://blockchain-revolution.com) - 可能是关于区块链应用的最好的书.
- [EventHorizon](http://eventhorizon2017.com) - 首届能源领域区块链技术全球峰会.
- [How the blockchain is changing money and business](https://www.youtube.com/watch?v=Pl8OlkkwRpc) - 来自《区块链革命》一书作者关于什么是区块链及其应用的 TED 演讲.
- [Non Financial Uses of Blockchain Technology](https://www.youtube.com/watch?v=GGCHaphRjoM) - 在 2016 年金融科技周上介绍区块链的非金融用途.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Sergey Ukustov](https://github.com/ukstv) 和 [Machinomy](https://github.com/machinomy) have waived all copyright 和 related or neighboring rights to this work.
