<div class="github-widget" data-repo="aviaryan/awesome-no-login-web-apps"></div>
## Awesome Web Apps (that work without login)

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Mentioned in Awesome](https://awesome.re/mentioned-badge.svg)](https://awesome.re)
[![Contributors needed](https://img.shields.io/badge/contributors-needed-yellow.svg)](https://github.com/aviaryan/awesome-no-login-web-apps/blob/master/CONTRIBUTING.md)
[![Join the chat at https://gitter.im/aviaryan/awesome-no-login-web-apps](https://badges.gitter.im/aviaryan/awesome-no-login-web-apps.svg)](https://gitter.im/aviaryan/awesome-no-login-web-apps?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![Open Source Helpers](https://www.codetriage.com/aviaryan/awesome-no-login-web-apps/badges/users.svg)](https://www.codetriage.com/aviaryan/awesome-no-login-web-apps)

精选的优秀 Web 应用程序列表，无需您创建帐户即可运行.

#### Inspiration

拯救世界免于为每件该死的东西创建用户帐户和安装软件应用程序.

#### Some pointers

 * 此列表中链接的网络应用程序无需登录即可提供大部分核心功能. 由于缺乏合适的替代方案，一些需要注册的网站也已包含在此列表中. 他们在列表中被标记为“[Account]”.
 * 这里提到的大多数应用程序都提供某种用户帐户功能来保存历史记录和进度. 但如前所述，使用这些应用程序的主要功能不需要用户帐户.





### Audio and Video

* [bfxr](http://www.bfxr.net/) - 为您的游戏制作音效.
* [MP3 Cut](http://mp3cut.net/) - 在线音频切割器.
* [TwistedWeb Online](https://twistedwave.com/online/)  - 强大的音频编辑器. 文件未在线保存.
* [Filelab Audio Editor](http://www.avs4you.com) - 具有修剪、合并、剪切音频等基本功能的音频编辑器.
* [Until AM](http://mix.until.am/) - 在线音乐混音器、DJ 软件.
* [YOU.DJ](https://you.dj/) - 在线音乐混音器，DJ 软件从 SoundCloud 采购音乐.
* [VideoToolbox](http://videotoolbox.com)  `[Account]` - 具有所有常见编辑功能的视频编辑器. 大小限制为 600mb.
* [AI Vocal Remover](https://vocalremover.org) - 通过人工智能将声音与音乐分开.
* [Ambient Mixer](https://www.ambient-mixer.com/) - 聆听免费的音频氛围（例如苏格兰雨/斯莱特林公共休息室）或在线混合您自己的环境声音.
* [Vileo](https://lukasbach.github.io/vileo/) - 录制您的屏幕或网络摄像头并从您的浏览器中下载视频.
* [Youtube Dynamic Playlists](https://youtube.ndo.dev) - 创建 YouTube 视频的即时播放列表.


### Business and Finance

* [ShapeShift.io](https://shapeshift.io) - 即时加密货币转换.
* [Cryptrader.com](https://cryptrader.com)  - 加密货币价格图表和指标. 保存您的设置需要一个帐户.
* [TradingView.com](https://www.tradingview.com/)  - 来自各个交易所的实时信息和市场见解. 需要一个帐户来保存设置.
* [ICOStats.com](https://icostats.com/)  - 跟踪和比较 ICO 的性能. 显示详细的统计数据，如自 ICO 以来的投资回报率、自 ICO 以来的投资回报率与 ETH，以及用于比较 ICO 历史表现的图表.
* [InvoiceToMe](https://invoiceto.me/) - 使用您公司的详细信息从各种模板生成专业发票.


### Communication

* [Tlk.io](https://tlk.io/) - 使用您想要的任何 URL（例如 `tlk.io/some-room`）创建一个房间并分组聊天.
* [Discord](https://discordapp.com/)  - 在线语音和文本会议. 开始时会询问用户名以创建临时头像.
* [Gruveo](https://www.gruveo.com/)  - 在线视频会议. 就像 Tlk.io，易于记忆的自定义 URL.
* [Whereby](https://whereby.com/)  - 在线视频会议. 创建任何房间，例如 `whereby.com/some-room` 并开始聊天.
* [Videolink2](https://videolink2.me/start)  - 在线视频会议. 链接已生成，分享链接以邀请其他参与者.
* [GetARoom.io](https://getaroom.io/)  - 在线视频会议. 具有移动浏览器支持，只需单击开始新呼叫并共享链接.
* [FaxZero](https://faxzero.com/) - 免费发送在线传真.
* [A2fax](https://www.a2fax.com/)  - 在线发送免费传真. 封面上没有广告. 将您自己的徽标添加到封面.
* [GoTeam](https://goteam.video/)  - 视频会议室. 创建任何房间，如 `goteam.video/some-room` . 创建房间后询问用户名.


### Document Editors

#### Latex

* [Papeeria](https://papeeria.com/) - Latex 预览，带有无需注册即可下载为 PDF 的选项.
* [Overleaf](https://www.overleaf.com/) `[Account]` - 无限的协作者和项目，免费帐户中的 git 访问权限.
* [Sharelatex](https://www.sharelatex.com)  `[Account]` - 具有无限私人项目的 Latex 编辑器. 免费帐户中有 1 位合作者.

#### Markdown

* [Dillinger](http://dillinger.io/)  - 强大的 Markdown 所见即所得，可导出为 HTML 和 PDF. 用于保存文档的用户帐户.
* [Github.md](http://aviaryan.in/javascripts/github.md/) - 具有打印功能的简单 GitHub 风格的 Markdown (GFM) 预览.
* [HackMD](https://hackmd.io) - 具有预览功能的协作、强大、实时在线降价编辑器.
* [Markdown Live Preview](http://markdownlivepreview.com/) - 即时降价预览.
* [Markdownify](http://www.amitmerchant.com/markdownify-web/) - 最小的 Markdown 编辑器.
* [StackEdit.io](https://stackedit.io/) - 丰富的浏览器内降价编辑器，可离线工作.

#### <a name="doc-eds-others"></a> Others

* [EtherCalc](https://ethercalc.net/) - 在线电子表格编辑器，导出到 Excel.
* [PdfEscape](https://www.pdfescape.com/) - Edit or create PDFs in browser itself.
* [Browserpad](http://browserpad.org/)  - 浏览器中的无服务器纯文本编辑器. 允许您打开和保存纯文本文件.
* [WriteURL](http://www.writeurl.com/) - 协作式实时在线文本编辑器.


<a name="drawing"></a>
### Drawing

* [SVG-Edit](https://svg-edit.github.io/svgedit/releases/svg-edit-2.8.1/svg-editor.html)  - 具有许多功能的强大 SVG 编辑器. 开源.
* [Method Draw](http://editor.method.ac/)  - 简洁且功能丰富的 SVG 编辑器. 出口到 PNG.
* [A Web Whiteboard](https://awwapp.com/) - 触摸友好的在线协作白板应用程序.
* [Witeboard](https://witeboard.com/)  - 为您的团队准备的实时白板. 无需注册.
* [Draw.io](https://www.draw.io/)  - 流程图和 UML 绘图工具. 有很多绘图样式可供选择. 导出为 PNG 并与 Google 云端硬盘集成.
* [AutoDraw](https://www.autodraw.com/)  - 借助 Google 的机器学习，绘制精美的草图. 图纸可以下载为 PNG.
* [kleki](http://kleki.com/) - 浏览器中类似 MS Paint 的界面.
* [JSPaint](https://jspaint.app)  - 浏览器中 1990 年代 MS Paint 的复制品. 开源.
* [bubbl](https://bubbl.us/) - 创建思维导图，在浏览器中集思广益.
* [ScribbleMaps](http://www.scribblemaps.com/) - 创建自定义谷歌地图.
* [Sketchpad](https://sketch.io/sketchpad/) - 创建数字艺术作品并导出为流行的图像格式 JPEG、PNG、SVG 和 PDF.
* [Piskel](https://www.piskelapp.com/) - Free online editor for animated sprites & pixel art
* [PixelCraft](https://pixelcraft.web.app) - 像素艺术编辑器和动画创作工具


### File Converters

* [Cloud Convert](https://cloudconvert.com/)  - 从任何东西转换成任何东西，包括音频、视频、字体、文档等等. 与 Google Drive 和 Dropbox 等云存储服务完美集成. 直接链接.
* [Online Convert](http://www.online-convert.com/)  - 音频、视频、图像、文档、电子书和存档转换器的集合. 转换后没有文件大小限制和直接下载链接.
* [PDF <=> EPUB](http://pdfepub.com/) - PDF 到 EPUB 转换器，反之亦然.
* [Pandoc Try](https://pandoc.org/try/)  - 使用 Pandoc 的内部标记转换. 支持 - Latex、Markdown、HTML、RST 等等.
* [Print Friendly](https://www.printfriendly.com/)  - 将任何网页转换为简单格式. 然后下载或打印为 PDF.
* [OnlineOCR](https://www.onlineocr.net/) - 将扫描的 PDF 转换为 DOC、XLS 或 TXT.
* [GifDeck](http://gifdeck.in/) - 将幻灯片从 slideshare 转换为 GIF.
* [favicon-generator](http://www.favicon-generator.org/) - 通过上传您想要的图像，为您的网络应用程序生成图标或为您的 Android 或 iOS 应用程序生成图标.
* [freetools.site](https://freetools.site/)  - 免费在线工具. 转换或编辑文档、图像、音频、视频等.


### File Hosting/Sharing

* [EFShare](http://efshare.com/) - 点对点安全文件共享.
* [RGhost](http://rgho.st/) - 文件托管服务，最大限制 100mb 无需登录.
* [ImgSafe](https://imgsafe.org/) - 带有小型直接链接的图像托管服务.
* [Clyp](https://clyp.it/) - 无限制的音频共享，丰富的API.
* [SendVid](https://sendvid.com/) - 视频托管服务.
* [Archive.org](https://archive.org/) `[Account]` - 任何类型的无限文件托管，对带宽和上传大小没有限制.
* [MultCloud](https://www.multcloud.com/home)  - 在多个云服务之间管理、移动、复制和迁移数据的云服务. 支持所有主要的云服务. 无需注册，2TB云存储，大文件直接下载到云端，无大小限制.
* [Firefox Send](https://send.firefox.com)  - Mozilla 的免费文件共享程序. 最多 1gb 没有帐户，2.5gb 有帐户.


<a name="games"></a>
### Games

* [Typeracer](http://play.typeracer.com/) - 在与他人比赛时评估您的打字速度.
* [Spark Chess](https://www.sparkchess.com/) - 根据您的技能水平，学习下棋、与全球用户一起玩或与 AI 一起玩.
* [Miniclip](https://www.miniclip.com)  - 收集各种免费游戏，无需提供您的电子邮件即可玩. 需要闪光灯.
* [CrossCode](http://www.cross-code.com/en/start)  - 一款以遥远的未来为背景的复古风格 2D 游戏. 带有出色的游戏机制，例如连击、拼图、技能树、任务、物品等.
* [agar.io](https://agar.io/) - 目标是通过吃比玩家细胞小的琼脂和细胞来获得尽可能多的质量，同时避免吃比玩家细胞大的琼脂和细胞.
* [paper-io](http://paper-io.com)  - 游戏的目标是控制 100% 的竞技场. 您将扮演一个不断移动的小方块，并有一个与您的方块颜色相对应的小起始区域.
* [diep.io](https://diep.io/)  - Diepio 是一款你扮演坦克并射击东西的游戏. 射击形状以升级您的坦克，然后射击玩家以获得大量积分.
* [skribbl.io](https://skribbl.io/) - 几个玩家连接到一个大厅，其中一个玩家得到一个词，他们需要画一个词，但不说是什么，而其他玩家必须识别它.
* [surviv.io](https://surviv.io/)  - Surviv.io 是一款 2D 大逃杀游戏. 每场比赛你只有一个活人，没有重生.
* [nitrome](https://www.nitrome.com/)  - 收集免费的像素艺术游戏. 新游戏不需要 Flash.
* [Orion](https://orion.lukasbach.com/)  - 棋盘/益智游戏. 巧妙地组合袋中的方块以填满棋盘.
* [Gidd.io](https://gidd.io/) - 经典游戏合集，如 UNO、Yatzy、Scattergories 和 GeoGuess.

### Graphics, Image and Design

* [PhotoPea](https://www.photopea.com/) - 看起来像 Photoshop 的图像编辑器，具有它的大部分功能.
* [Pixlr Editor](https://pixlr.com/editor/)  - Pixlr 的图像编辑器. 很多功能.
* [Photo Editor | Befunky](https://www.befunky.com/features/photo-editor/) - 具有大量过滤器和效果的图像编辑器.
* [Logo Makr](https://logomakr.com/)  - 带有精美 SVG 集合的徽标制作工具. 需要付费才能将徽标导出为 SVG（PNG 是免费的）.
* [Online Logo Maker](https://www.onlinelogomaker.com/)  - 在线制作标志. 额外的用户帐户功能来保存创作.
* [Coolors](https://coolors.co/) - 调色板生成器.
* [Tiny PNG](https://tinypng.com/) - 智能 PNG 和 JPEG 压缩.
* [Realtime Board](https://realtimeboard.com/) `[Account]` - 大面积、屏幕共享、视频和语音通信的协作黑板.
* [ezGIF](https://ezgif.com/) - GIF 图像编辑器（裁剪、缩放、优化等）.
* [Adobe Color CC](https://color.adobe.com/) - 配色方案设计师.
* [Burner Bonanza](https://burner.bonanza.com/) `[Account]` - 删除图像背景并立即在 Facebook 或 Twitter 上分享的工具，登录后可将编辑后的图像下载为 PNG 或 JPEG.
* [IcoMoon](https://icomoon.io/app/) - 一个平台，可帮助您查找矢量图标包，将图标托管为 SVG 或字体，并生成所选图标的 SVG + PNG + 图标字体.
* [Flaming Text](http://flamingtext.com/) - 在线徽标或名称生成器/创建器，根据您的意愿修改您的徽标，并获得多种格式，包括 PNG 和 JPEG.
* [LeanLogoMaker](https://leanlogomaker.com)  - 生成 100 多个徽标，选择您最喜欢的并下载. 包括您的社交媒体网站的封面和个人资料图片.
* [doka.photo](https://doka.photo/)  - 易于使用的照片编辑器. 您可以裁剪、旋转、翻转、添加滤镜、调整大小和注释.
* [CleanIcons](https://cleanicons.xyz) - 下载 Font Awesome 图标字体为 PNG.
* [Mancer](https://mancer.app)  - 从浏览器设计、分享和订购 T 恤. 设计可以导出为 PNG.
* [Branition Colors](https://branition.com/colors) - 手工精选的最适合品牌化的彩色托盘系列.


### Internet Downloaders

* [savefrom.net](http://en.savefrom.net/) - 从 YouTube、Dailymotion、Vimeo 等下载.
* [Youtube Converter & Downloader](https://www.onlinevideoconverter.com/video-converter) - 下载任何音频/视频格式的 YouTube 视频.
* [keepvid](http://keepvid.com/) - YouTube、SoundCloud、Facebook 下载器.
* [dOnline](http://https://doonline.cc/video-downloader-converter.html/) - 从 YouTube、Instagram、Vimeo、SoundCloud、Facebook 下载器下载.
* [Bitport](https://bitport.io/welcome)  `[Account]` - Torrent 下载器. 免费帐户每天限制为 1 个 1gb 的 torrent.
* [Seedr](https://www.seedr.cc/)  `[Account]` - 基于云的 torrent 下载器. 限于免费帐户中总大小为 2gb 的多个种子. 无限带宽. 贡献一个新用户增加 500mb.
* [ZbigZ](https://zbigz.com/)  - Torrent 下载器，可让您选择要从 Torrent 下载的文件. 文件大小限制为 2gb，免费版本的下载速度上限为 50kbps.


### Music, Radio and Podcasts

* [Podbay](http://podbay.fm/) - 在线收听任何播客，可以下载个别剧集.
* [Internet Radio](https://www.internet-radio.com/) - 收听超过 40k 个广播电台.
* [Stitcher](http://www.stitcher.com/) - 在线收听播客.
* [AnyAudio](http://anyaudio.in/) - 流式传输和下载音乐.
* [Muki](https://muki.io) - 基于 WebAudio 的芯片音乐和 MIDI 播放器，带有大量视频游戏音乐.
* [MusixHub](http://www.musixhub.com) - 在线播放艺术家和专辑视频歌曲，由 YouTube 提供支持.
* [plug.dj](https://plug.dj/) - 聆听由 YouTube 提供支持的数千位 DJ，需要登录才能成为 DJ.
* [Jango Radio](http://www.jango.com/) - 免费网络电台，收听数百个流派电台或用您最喜爱的音乐创建您自己的电台.
* [Anime Openings](http://openings.moe/) - 免费动漫广播，收听或下载动漫片头和片尾视频.
* [NoteFlight](https://www.noteflight.com/login) `[Account]` - 打印乐谱，在线编写您自己的音乐（评论）.
* [ongaku](https://ongaku.js.org/) - 在线动漫音乐电台，与 [desktop port](https://github.com/Anshuman-Verma/ongaku-desktop).
* [Radio Garden](http://radio.garden/) - 通过选择地球上的一个城市来收听全球数以千计的广播电台.


### Notepads and Notebooks

* [aNotepad](https://anotepad.com/) - 使用 cookie 无需用户帐户即可保存您的笔记.
* [shrib](https://shrib.com/) - 将注释保存到自定义 URL 并稍后进行编辑.
* [Notepad](http://notepad.js.org/) - 支持离线的记事本 PWA.
* [ProtectedText](https://www.protectedtext.com/) - 没有广告、会话或 cookie 的加密笔记.
* [Taskade](https://taskade.com/)  - 协作笔记、任务列表和大纲. 注册是可选的.
* [WriteXO](https://writexo.com/) - 具有富文本支持、密码保护和自定义 URL 的在线记事本.


### Privacy, Security and Cryptography

* [Cryptii](https://cryptii.com) - 使用各种密码和方法提供模块化转换、编码和加密.
* [Encipher.it](https://encipher.it/) - AES-256 文本加密和解密.
* [Encrypted Pastebin - Defuse.ca](https://defuse.ca/pastebin.htm) - 在您的公共粘贴上设置密码.
* [jotti](https://virusscan.jotti.org) - 扫描任何可疑文件或电子邮件附件是否有病毒.
* [scr.im](http://scr.im/) - 自由分享电子邮件地址，无需担心垃圾邮件.
* [10 Minute Mail](https://10minutemail.com/10MinuteMail/index.html) - 10 分钟（可扩展）的临时全功能电子邮件地址.
* [BugMeNot](http://bugmenot.com/)  - 一个用于查找和共享不同网站登录信息的平台. 它可以帮助您找到用于登录不同网站的凭据.
* [Cloverleaf](https://cloverleaf.app) - 一个开源应用程序，无需在任何地方存储您的密码即可替换您的密码管理器.

### Programming Editors and IDEs

* [TutorialsPoint Online Tools](https://www.tutorialspoint.com/codingground.htm)  - Ipython、Octave、Powershell、Redis 和许多其他在线终端. 还有一个很好的编程语言 IDE 集合.
* [Ideone](http://ideone.com/) - 支持最流行语言的在线 IDE.
* [codepad](http://codepad.org/)  - 在线编译器，它还允许您创建项目（您会为您的项目分配一个子域）. 请注意，不支持从标准输入读取.
* [Repl.it](https://repl.it/) - 所有流行编程语言的在线终端.
* [Codechef IDE](https://www.codechef.com/ide) - 支持主要语言的简单单文件代码编译器.
* [Cloud9](https://c9.io/) `[Account]` - 非常强大的在线开发环境，就像您的本地 PC 一样.
* [Codepen.io](https://codepen.io/) - 前端 Web 开发游乐场.
* [JS Bin](https://jsbin.com) - 协同网络开发和调试工具.
* [Codenvy](https://codenvy.com) `[Account]` - 开发人员的云工作区，支持最流行的堆栈，包括 Android、Hadoop、Selenium、NodeJS 等等.
* [SQLFiddle](http://sqlfiddle.com/) - 用于轻松在线测试和共享数据库问题及其解决方案的工具.
* [Brainfuck Visualizer](http://fatiherikli.github.io/brainfuck-visualizer/)  - Javascript Brainfuck 解释器 + 可视化工具. 帮助您了解代码的工作原理.
* [PythonTutor](http://pythontutor.com/visualize.html#mode=edit) - 在 Web 浏览器中可视化 Python、Java、JavaScript、TypeScript、Ruby、C 和 C++ 代码执行.
* [DartPad](https://dartpad.dartlang.org/) -DartPad 是一种开源工具，可让您在任何现代浏览器中使用 Dart 语言.


### Programming Tools

* [CSS Minifier](https://cssminifier.com/) - 通过删除空格和注释来缩小 CSS.
* [UglifyJS JavaScript minifier](https://skalman.github.io/UglifyJS-online/) - 缩小和混淆 JavaScript.
* [HTML minifier by @kangax](https://kangax.github.io/html-minifier/)  - HTML 压缩器. 也缩小了内联 CSS 和 JavaScript.
* [JavaScript compressor](http://javascriptcompressor.com/) - JavaScript 压缩器和混淆器.
* [Android Asset Studio](https://romannurik.github.io/AndroidAssetStudio/) - 来自现有图像的 Android 启动器图标、通知图标等生成器.
* [Website Speed Test | Pingdom](https://tools.pingdom.com/) - 功能丰富的网站测试器.
* [Google Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool) - 测试网页的结构化数据和 SEO.
* [Regulex](https://jex.im/regulex/) - JavaScript 正则表达式可视化工具.
* [GTmetrix](https://gtmetrix.com/) - 分析您网站的速度并使其更快.
* [BuildWith](https://builtwith.com/) - 查找技术堆栈以了解有关网站的一切.
* [WooRank](https://www.woorank.com/) - 搜索引擎优化审计工具，根据产生的流量提供全球和本地排名的网站审查.
* [CSS Typeset](http://csstypeset.com/)  - 视觉排版编辑器. 尝试使用 font-face、word-spacing 和其他文本属性并下载相应的 CSS.
* [pForm](http://www.phpform.org/) - 通过简单的所见即所得 GUI 创建 HTML 表单并下载相应的代码.
* [CSS Autoprefixer](https://autoprefixer.github.io/)  - 用于处理 CSS 中供应商前缀的后处理器. 只需粘贴常规 CSS 即可立即获得供应商前缀处理的 CSS.
* [CSS Matic](https://www.cssmatic.com/) - CSS 工具，快速生成渐变、边框半径、噪声纹理和框阴影，并获得相应的 CSS 或 SASS.
* [Carbon](https://carbon.now.sh) - 创建和分享源代码的精美图片.
* [jsonstore.io](https://www.jsonstore.io/)  - jsonstore.io 为小型项目提供免费、安全的基于 JSON 的 API 端点. 它支持常见类型的 HTTP 操作，如 POST、GET、PUT、DELETE 等.
* [ObjGen](http://www.objgen.com/) - 当您使用基于文本的语法仅键入关键词、类型和属性时，此应用程序可帮助您实时生成代码（JSON、HTML 等）.
* [JsonFormatter](https://jsonformatter.curiousconcept.com) - 以人类可读的形式查看 json.
* [DebugBear Speed Test](https://www.debugbear.com/test/website-speed) - 测试站点速度和 Core Web Vitals.


### Search Engines

* [Iconfinder](https://www.iconfinder.com/) - 在一个地方下载所有您喜欢的图标.
* [Emoji Search Online](https://www.webpagefx.com/tools/emoji-cheat-sheet/) - 智能表情符号搜索引擎.
* [RSS Feed Search](http://ctrlq.org/rss/) - 从搜索词中查找 RSS 提要.
* [IWantMyName](https://iwantmyname.com/) - 帮助您搜索所有 TLD 中的域.
* [Similar Sites](http://www.similarsites.com/) - 查找与您输入的网站相似的网站.
* [Google Fonts](https://www.google.com/webfonts) - 由谷歌收集的开源字体.
* [ChooseMyPC](https://choosemypc.net/) - Search for the best combination of parts considering your requirements for your PC under a given budget.
* [Flaticon](https://www.flaticon.com/) - 最大的免费图标搜索引擎.
* [icon8](https://icons8.com/) - 设计师，免费下载设计素材——图标、照片、用户体验插图和视频音乐.


### Study and Education

* [Calculatoria Calculator](http://www.calculatoria.com/) - 在线科学计算器，进度存储在您的系统中.
* [WolframAlpha](https://www.wolframalpha.com)  - 强大的计算知识引擎. 看 [plotting graphs examples](https://www.wolframalpha.com/examples/PlottingAndGraphics.html) 有关如何绘制图表的帮助.
* [Desmos Graphing Calculator](https://www.desmos.com/calculator) - 在同一张纸上绘制多个 2D 图，查看图形交叉点.
* [Geometry sheet by MathIsFun](https://www.mathsisfun.com/geometry/drawing.html) - 如果您想玩数字，可以在线使用简单的几何表.
* [Directed Graph Editor](http://bl.ocks.org/rkirsling/5001347) - 玩有向图.
* [Calcul](http://www.calcul.com) - 不同计算器的集合，包括矩阵、单位转换器、数学分布等.
* [Word Safety](http://wordsafety.com/) - 检查单词是否在任何语言中都是辱骂性的.
* [OEIS®](http://oeis.org/) - Integer Sequences® 在线百科全书，有助于密码学以及制定奇怪的序列.
* [Directed Grap Editor (CS Academy)](https://csacademy.com/app/graph_editor/) - 绘制带或不带边值和物理的有向图系统.
* [Abc-Map](https://abc-map.fr) - 创建地理地图、从数据存储中挑选数据、处理数据以创建可视化效果、导出或在线共享您的地图. 
* [KeepFormula](https://keepformula.github.io/) - Keep Formula 是一款简单的应用程序，可让您的计算更轻松.


<a name="text-tools"></a>
### Text based tools

* [Diff Checker](https://www.diffchecker.com/) - 比较两个文本段落并查看差异.
* [CopyPasteCharacter](http://www.copypastecharacter.com/) - 复制键盘中通常不可用的特殊字符.
* [PolishMyWriting](http://www.polishmywriting.com/) - 粘贴文本并获得有关您的写作的反馈.
* [Wordle](http://www.wordle.net/) - 从给定的文本片段中生成“词云”的玩具.
* [tYp3r](http://typ3r.aavi.me) - dA aNn0Y1Ng t3Xt g3NeRa7or（烦人的文本生成器 :-P）.
* [Telegraph](http://telegra.ph/) - 支持丰富格式文本的极简发布工具.
* [DiffNow](https://www.diffnow.com/) - 高级、在线和免费的文件差异检查，带有上传文件、通过链接或文本输入比较文件等选项.
* [Write.as](https://write.as/) - 跨平台写作和发布工具，支持 Markdown 和编辑/删除过去的帖子.
* [Emojify](https://madelinemiller.dev/apps/emojify/) - 通过添加表情符号为文本、歌词或诗歌增添趣味的工具.


<a name="utilities"></a>
### Utilities (uncategorized)

* [Dataflow kit](https://dataflowkit.com/dfk) - 从网页中提取结构化数据.
* [E.gg Timer](http://e.ggtimer.com/) - 简单的倒数计时器应用程序.
* [QR Code Generator](http://zxing.appspot.com/generator/) - 支持不同类型的二维码，如联系信息、WiFi、日历等.
* [QR Code Scanner and Generator](https://sharesnip.rosano.ca) - 通过相机和文件扫描，下载为 SVG 或 PNG，离线工作.
* [RANDOM.ORG](https://www.random.org/) - 随机数生成器、掷骰子、密码生成器、随机位图和更多基于随机性概念的东西.
* [Web-Capture](https://web-capture.net/) - 只需提交链接即可将网页转换为流行格式（PDF、JPEG、ZIP）的网络应用程序.
* [PrintWhatYouLike](http://www.printwhatyoulike.com/) - 打印任何网页或将其保存为 HTML 或 PDF.
* [WhatTheFont](http://www.myfonts.com/WhatTheFont/) - 从图像中确定字体名称.
* [Image Metadata Viewer](http://exif.regex.info/exif.cgi) - 查看任何图像的隐藏数据（元数据）.
* [WhoIsHostingThis](http://www.whoishostingthis.com/) - 查找任何网站的虚拟主机.
* [TypingWeb](https://www.typing.com/student/start) - 轻松掌握盲打.
* [Acronym Creator](http://acronymcreator.net/) - 为组织、算法或至少有两个词的任何事物创建首字母缩写词.
* [TallTweets](http://talltweets.com/) - 发送超过 140 个字符的推文.
* [Postify](http://postfity.com/) `[Account]` - 在 Facebook、Twitter 和 LinkedIn 上安排帖子.
* [Krutidev <--> Unicode](http://wrd.bih.nic.in/font_KtoU.htm) - 一键将 Krutidev 转换为 Unicode (Mangal)，反之亦然.
* [Resume Nation](https://resume-nation.github.io)  - 一个可以离线工作的开源简历生成器渐进式网络应用程序. 它有几个主题可供选择，并且可以导出 PDF 格式的简历.
* [Daily Todo](https://dailytodo.org/) - 简单的待办事项列表制作器.
* [Mailinator](https://www.mailinator.com/) - 一次性电子邮件服务.
* [Randommer](https://randommer.io/) - 随机数据生成器和验证器.
* [Meditation Timer](https://meditation.koti.cloud/) - 一个冥想计时器来跟踪你的会话.
* [Bucket Listy](https://bucketlisty.com/) - 具有独特想法的遗愿清单管理器，您可以在其中添加自己的想法.


### Miscellaneous

* [rollApp](https://www.rollapp.com/) `[Account]` - 在任何设备上运行桌面应用程序.
* [is.gd](https://is.gd/) - 带有自定义 URL 和开放 API（无令牌）的链接缩短器.
* [Bitly](https://bitly.com/) - 带有 REST API 的强大 URL 缩短器.
* [Superbetize](http://superbetize.com/) - 分类您的购物清单.
* [isup.me](http://isup.me/) - 检查网站是否只对您或其他人不可用.
* [Dictation.io](https://dictation.io/) - 支持多种语言的在线语音听写软件.
* [followupthen](https://www.followupthen.com/) - 设置电子邮件提醒的最简单方法.
* [lmgtfy](http://lmgtfy.com/) - 当您的朋友懒得自己使用 Google 时.
* [IFTTT](https://ifttt.com/)  `[Account]` - 在您最喜欢的在线服务之间创建连接. 例如，如果需要在推特上将他们的 instagram 作为原生照片发布，那么 IFTTT 就可以派上用场.
* [AlarmDJ](https://alarmdj.com) - 在线闹钟，使用 MP3 文件和 YouTube 视频作为闹钟.
* [Morsify](https://morsify.net) - 在线摩尔斯电码翻译器.
* [Dub](https://dub.sh/) - 开源链接缩短器.
* [3dHousePlanner](https://www.3dhouseplanner.com/) - 网络上的 3D 家居设计应用程序.
-----

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Avi Aryan](http://aviaryan.in) 已放弃该作品的所有版权和相关或邻接权.
