<div class="github-widget" data-repo="analyticalmonk/awesome-neuroscience"></div>
<!-- ![Awesome Neuroscience](https://raw.githubusercontent.com/analyticalmonk/awesome-neuroscience/master/./AWESOME2.png) -->
<img src="https://raw.githubusercontent.com/analyticalmonk/awesome-neuroscience/master/./AWESOME2.png" width="50%">

&gt; 令人敬畏的神经科学图书馆、软件和与该领域相关的任何内容的精选列表.

[Neuroscience](https://en.wikipedia.org/wiki/Neuroscience) 是对神经系统如何发育、结构及其作用的研究. 神经科学家专注于大脑及其对行为和认知功能的影响. 传统上，神经科学一直被视为生物学的一个分支，但它已经发展成为涵盖范围广泛的跨学科领域，这些领域共同致力于在多个研究层面阐明大脑功能.

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)





## Programming
用于开发目的的软件、库和框架.

### Python

- [Nengo](https://github.com/nengo/nengo) - 用于创建和模拟大规模大脑模型的库.
- [Nitime](https://github.com/nipy/nitime) - 神经科学数据的时间序列分析.
- [Nilearn](https://github.com/nilearn/nilearn) - 用于对 NeuroImaging 数据执行统计学习/机器学习的模块.
- [DIPY](https://github.com/nipy/dipy) - 用于分析 MR 扩散成像的工具箱.
- [MNE-Python](https://github.com/mne-tools/mne-python) - 用于处理时间分辨神经信号的社区驱动软件，包括脑电图 (EEG) 和脑磁图 (MEG).
- [NiBabel](https://github.com/nipy/nibabel) - 提供对一些常见医学和神经影像文件格式的读写访问.
- [PsychoPy](https://github.com/psychopy/psychopy)  - 用于运行心理学和神经科学实验的软件包. 它允许在 Python 中创建心理刺激.
- [NuPic](https://github.com/numenta/nupic) - Numenta 智能计算平台是分层时间记忆 (HTM) 的实现，这是一种严格基于新皮质神经科学的智能理论.
- [Brian2](https://github.com/brian-team/brian2) - 用于尖峰神经网络的免费开源模拟器.
- [expyriment](https://github.com/expyriment/expyriment) - 独立于平台的轻量级 Python 库，用于设计和进行时间关键行为和神经影像学实验.
 - [BindsNET](https://github.com/Hananel-Hazan/bindsnet) - 用于模拟用于强化和机器学习的尖峰神经网络的包.
 - [SpikeInterface](https://github.com/SpikeInterface/spikeinterface) - 旨在统一尖峰分类技术的框架
 - [NiMARE](https://nimare.readthedocs.io/en/latest/) - NiMARE 是一个用于神经影像元分析的 Python 包
 
### Matlab

- [Brain Dynamics Toolbox](https://bdtoolbox.org/) - 用于模拟神经科学中的动力系统的开放软件.
- [BrainStorm](https://neuroimage.usc.edu/brainstorm/) - 专门用于分析大脑记录（MEG、EEG、fNIRS、ECoG、深度电极和多单元电生理学）的开源应用程序. 
- [EEGLAB](https://sccn.ucsd.edu/eeglab/) - 交互式 Matlab 工具箱，用于处理连续和事件相关的 EEG、MEG 和其他电生理数据.
- [FieldTrip](https://github.com/fieldtrip/fieldtrip) - MEG 和 EEG 分析工具箱.
- [Psychtoolbox-3](http://psychtoolbox.org/) - 用于视觉和神经科学研究的免费 Matlab 和 GNU Octave 函数集.
- [SPM](https://www.fil.ion.ucl.ac.uk/spm/) - 用于分析脑成像数据序列（fMRI、PET、SPECT、EEG、MEG）的免费开源软件.

### C++

- [Brayns](https://github.com/BlueBrain/Brayns)  - 可以执行神经元光线追踪渲染的简约可视化工具. 光线追踪有助于突出神经回路的区域，细胞在这些区域相互接触，以及正在形成突触的区域，从而更好地了解单个细胞以及随后的大脑功能.

### JavaScript
- [Brainbrowser](https://github.com/aces/brainbrowser) - 库公开了一组基于网络的 3D 可视化工具，主要针对神经影像学.
- [jsPsych](https://www.jspsych.org/) - 用于在网络浏览器中创建和运行行为实验的库.

### R
- [nat: NeuroAnatomy Toolbox](https://github.com/jefferis/nat) - 生物图像数据的（3D）可视化和分析包，尤其是单个神经元的追踪.
- [brainGraph](https://github.com/cwatson/brainGraph) - 用于对大脑 MRI 数据进行图论分析的软件包.

## Resources
与神经科学相关的有趣资源.

### Ebooks
- [Neuroscience Online](http://nba.uth.tmc.edu/neuroscience/m/index.htm)  - 深入涵盖神经科学的开放获取电子教科书和交互式课件. 由休斯顿德克萨斯大学医学院神经生物学和解剖学系提供.
- [Computational Cognitive Neuroscience](https://grey.colorado.edu/CompCogNeuro/index.php/CCNBook/Main) - 文本深入介绍了计算认知神经科学的主要思想，该领域旨在通过使用基于生物学的计算模型来理解大脑.
- [Neuronal Dynamics](https://neuronaldynamics.epfl.ch)  - 涵盖计算和理论神经科学的开放式电子教科书. 由洛桑联邦理工学院 (EPFL) 提供.
- [Andy's Brain Book](https://andysbrainbook.readthedocs.io/en/latest/) - 预订伴侣 [Andy's Brain Blog](https://www.andysbrainblog.com/) . 介绍了在 Unix 环境中工作、fMRI 分析以及常见的神经成像工具和主题. 
- [NiPraxis](https://textbook.nipraxis.org/intro.html) - 教科书 [NiPraxis course](https://nipraxis.org/) ，涵盖了神经影像分析的基本概念，以及它们如何与更广阔的统计、工程和计算机科学领域相关联. 了解如何处理数据和代码，以更深入地了解 fMRI 方法的工作原理、它们如何失败、如何修复它们以及如何开发新方法.

### Blogs

- [Neuroskeptic](https://www.discovermagazine.com/author/neuroskeptic) - [Discover magazine](http://discovermagazine.com/)的神经科学博客，通过批判的视角审视神经科学、精神病学和心理学的最新发展.
- [The Neurocritic](http://neurocritic.blogspot.in/) - 通常对人脑成像、认知神经科学和精神药理学中最耸人听闻的最新发现持批评态度.
- [The scicurious brain](https://blogs.scientificamerican.com/scicurious-brain/) - 由维护 [Scientific American](https://blogs.scientificamerican.com/), 此博客通常在单个条目中涵盖一篇研究论文.
- [Action Potential](http://blogs.nature.com/actionpotential) - 由《自然》杂志的神经科学编辑运营的论坛.
- [Andy's Brain Blog](https://www.andysbrainblog.com/) - 大量文章、教程和视频，涵盖许多流行的神经成像工具和方法. 

### MOOCs

[Massive Open Online Courses (MOOCs)](https://en.wikipedia.org/wiki/Massive_open_online_course) 是基于 Web 的免费远程学习计划，专为分散在各地的大量学生的参与而设计.
MOOCs 可能以学院或大学课程为模式，也可能结构化程度较低.

- [The Fundamentals of Neuroscience | Harvard & edX](https://www.mcb80x.org/) - 提供神经科学主题的介绍性调查，没有特定的先决条件，但事先接触过生物学和/或化学可能会有所帮助.
- [Introduction to Neuroscience | MIT OCW](https://ocw.mit.edu/courses/brain-and-cognitive-sciences/9-01-introduction-to-neuroscience-fall-2007/) - 介绍哺乳动物神经系统，重点是人脑的结构和功能.
- [Computational Neuroscience | Coursera](https://www.coursera.org/learn/computational-neuroscience) - 介绍基本的计算方法，以了解神经系统的作用和确定它们的功能.
- [Medical Neuroscience](https://www.coursera.org/learn/medical-neuroscience) - 探索人类中枢神经系统的功能组织和神经生理学，同时为理解人类行为提供神经生物学框架.
- [Neuromatch Academy](https://github.com/NeuromatchAcademy/course-content) - 用于计算神经科学为期三周的强化暑期学校的 Jupyter 笔记本. 

### Communities
- [Quora](https://www.quora.com/topic/Neuroscience-1) - Quora 上的神经科学主题包含专家对从基础到高级问题的答案.
- [Reddit](https://www.reddit.com/r/ScienceNetwork/comments/ptye0/link_tables/) - 神经科学、心理学和认知科学 subreddits 列表.
- [StackExchange](https://psychology.stackexchange.com) - 心理学和神经科学 StackExchange 网站.
- [neuroimaging@python.org](https://mail.python.org/mailman/listinfo/neuroimaging)  - Python 神经影像分析讨论列表. 除其他事项外，此列表是讨论有关 [NiPy](https://nipy.org/) 项目（包括 NiBabel、Nilearn、dipy、MNE-Python 等）.

### Newsletters
- [On The Brain](http://neuro.hms.harvard.edu/harvard-mahoney-neuroscience-institute/hmni-newsletter) - 哈佛马奥尼神经科学研究所的季度电子通讯.
- [Comp-neuro](http://www.tnb.ua.ac.be/mailman/listinfo/comp-neuro) - A mailing list that is is intended to address the broad range of research approaches and issues involved in the general field of computational neuroscience. 
- [BrainPost](https://www.brainpost.co/) - 一个邮件列表，每周提供最新神经科学出版物的易于阅读的摘要.

### Miscellaneous
- [Awesome Public Datasets - Neuroscience](https://github.com/awesomedata/awesome-public-datasets#neuroscience) - 高质量的开放神经科学数据集.
- [McCulloch & Pitts Neural Net Simulator](https://justinmeiners.github.io/neural-nets-sim/) - 基于神经元的历史计算模型模拟器.
- [ModelDB](https://senselab.med.yale.edu/ModelDB/default.cshtml) - 计算神经科学模型的可搜索数据库.
- [NeuronDB](https://senselab.med.yale.edu/NeuronDB) - 三种神经元特性的可搜索数据库：电压门控电导、神经递质受体和神经递质物质.
- [NeuroElectro](https://neuroelectro.org/) - 神经元及其电生理特性的可搜索数据库（摘自文献）
- [Neuroscience Mindmap](https://learn-anything.xyz/neuroscience) - 交互式思维导图，包含为对学习神经科学感兴趣的任何人提供的精选资源.
- [neuroSummerSchools](https://github.com/PhABC/neuroSummerSchools) - 神经科学及相关领域的暑期（和季节性）暑期学校名单.
- [Brain Matters](https://brainpodcast.com/) - 真正的神经科学家坐下来谈论大脑的神经科学播客.
- [NeuroHackademy](https://neurohackademy.org/course_type/lectures/)  - 神经影像学和数据科学暑期学校，在华盛顿大学电子科学研究所举办. 讲座可通过研究所 [YouTube channel](https://www.youtube.com/@UWeScienceInstitute).
- [SORTED](https://github.com/PTDZ/SORTED) - 排序：有趣的科学思想和链接列表（认知/神经和数据科学）

## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/analyticalmonk/awesome-neuroscience/blob/master/contributing.md) 第一的.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

在法律允许的范围内， [Akash Tandon](https://github.com/analyticalmonk) 已放弃所有版权和
本作品的相关或邻接权利.
