<div class="github-widget" data-repo="tyaga001/awesome-neon"></div>
## Awesome Neon [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

[Neon](https://neon.tech) is an awesome serverless Postgres database, open-source alternative to AWS Aurora you love. It's a serverless platform designed to help you build reliable and scalable applications faster.

This list tries to cover what is awesome about the product and its community! 👁⚡️👁

To **enhance** this list, please refer to [https://github.com/tyaga001/awesome-neon/blob/master/CONTRIBUTING.md](https://github.com/tyaga001/awesome-neon/blob/master/CONTRIBUTING.md).



## Official Resources

- [Official Documentation](https://neon.tech/docs) - Access comprehensive docs for Neon, including guides, tutorials, and API references.
- [GitHub Repository](https://github.com/neondatabase/neon) - Explore the source code, contribute, and stay updated with the latest developments in Neon GitHub repository.
- [Demos](https://neon.tech/demos) - Watch demos showcasing Neon features and capabilities to understand its practical applications.
- [Blog](https://neon.tech/blog) - Read articles on Neon latest updates, case studies, and best practices for using Neon in various scenarios.
- [YouTube Channel](https://www.youtube.com/@neondatabase) - Watch Neon YouTube channel for video tutorials, demos, and feature highlights.

## Getting Started

- [Quickstart Guide](https://neon.tech/docs/get-started-with-neon/signing-up) - Follow this quickstart guide to get started with Neon and set up your account.
- [CLI](https://neon.tech/docs/reference/neon-cli) - Learn how to use the Neon CLI for managing your databases and automating workflows.
- [API](https://api-docs.neon.tech/reference/getting-started-with-neon-api) - Explore the Neon API docs to integrate Neon with your applications seamlessly.
- [Serverless Driver](https://neon.tech/docs/serverless/serverless-driver) - Learn how to use the Neon Serverless Driver for efficient, serverless database interactions.
- [Data Import Guides](https://neon.tech/docs/import/import-intro) - Access guides on importing data into Neon quickly and efficiently.
- [Database Branching Workflows](https://neon.tech/flow) - Learn about database branching workflows to improve your development and deployment processes.

## Examples

- [Integration Examples and Code Snippets](https://github.com/neondatabase/examples) - Browse examples and code snippets to see how Neon can be used in different projects.


## Community Guides

- [Build a RAG Chatbot with Astro, Neon, and LlamaIndex](https://neon.tech/guides/chatbot-astro-postgres-llamaindex) - Learn how to build a RAG chatbot using Astro, Neon, and LlamaIndex with this comprehensive guide.
- [Create a Reverse Image Search Engine Using LlamaIndex and Postgres](https://neon.tech/guides/llamaindex-postgres-search-images) - Learn to develop a reverse image search engine with LlamaIndex and Postgres by following this guide.
- [Develop an E-commerce Store with Payload CMS, Neon, and Next.js](https://neon.tech/guides/payload) - Learn to build a full-featured e-commerce store using Payload CMS, Neon, and Next.js.
- [Build a Blog with Strapi CMS, Neon, and Astro](https://neon.tech/guides/strapi-cms) - Learn how to create a blog with Strapi CMS, Neon, and Astro.
- [Run Analytics with Umami, Fly.io, and Neon](https://neon.tech/guides/self-hosting-umami-neon) - Learn how to set up an analytics platform using Umami, Fly.io, and Neon.
- [Revert Failed Deployment and Schema Migration in Laravel](https://neon.tech/guides/laravel-migration-rollbacks) - Learn how to handle deployment and schema migration rollbacks in Laravel with Neon.
- [Overview of Laravel and Neon](https://neon.tech/guides/laravel-overview) - Get an overview of using Laravel with Neon.
- [Add Feature Flags in SvelteKit Apps with Neon](https://neon.tech/guides/feature-flags-sveltekit) - Learn how to implement feature flags in SvelteKit applications using Neon.
- [Upload to S3 in Next.js and Save References in Postgres](https://neon.tech/guides/next-upload-aws-s3) - Learn how to upload files to S3 in a Next.js app and save references in Postgres.
- [Query Postgres in Next.js Server Actions](https://neon.tech/guides/next-server-actions) - Learn how to query Postgres in Next.js server actions with this guide.

## Community Video Tutorials

- [Tech Demo - Getting Started](https://www.youtube.com/watch?v=JtgwiJggOU0) - Watch this demo to get started with Neon.
- [Database Branching Explained](https://www.youtube.com/watch?v=hFULG1Dx8wo) - Learn about database branching in Neon and how it can benefit your development process.
- [Using Neon with Serverless Applications](https://www.youtube.com/watch?v=9pCsyBlpmrc&t=2s) - Learn how to integrate Neon with serverless apps in this detailed tutorial.
- [Introduction to Serverless Driver](https://www.youtube.com/watch?v=_LF-IvJsr5Y) - Get an introduction to the Neon Serverless Driver.
- [Setting Up Neon in Your Development Environment](https://www.youtube.com/watch?v=cxgAN7T3rq8) - Learn how to set up Neon in your development environment.
- [Scaling Databases for Large Applications](https://www.youtube.com/watch?v=jXyTIQOfTTk&t=7838s) - Learn how to scale Neon to support large applications.
- [Best Practices for Database Security](https://www.youtube.com/watch?v=W-Bd7nzzz3o&t=426s) - Learn how to ensure security in your Neon.
- [Optimizing Performance with Database](https://www.youtube.com/watch?v=N_uNKAus0II&t=6387s) - Learn how to optimize performance with Neon.
- [Migrating Data to Database](https://www.youtube.com/watch?v=duMr6MTViUY) - Learn how to migrate data to Neon.
- [Python Tutorial: Build a SaaS App with Django, Stripe, Neon, TailwindCSS, GitHub Actions](https://youtu.be/WbNNESIxJnY?si=Bv69eeyRvfKnuS45) - Learn how to build a SaaS application using Django, integrating Stripe for payments, Neon, TailwindCSS for styling, and GitHub Actions for CI/CD.
- [Build & Deploy AI SaaS with Reoccurring Revenue (Next.js, OpenAI, Stripe, Tailwind, Vercel)](https://youtu.be/r895rFUbGtE?si=M_K9YSN36LV7Ft0a) - Tutorial on creating an AI-powered SaaS with recurring revenue, using Next.js, OpenAI, Stripe for payments, TailwindCSS, and deploying on Vercel.
- [Build a Finance SaaS Platform With Nextjs, React, Honojs with CSV Upload (2024)](https://youtu.be/N_uNKAus0II?si=F1fZTyomXU4c9YMD) - Guide to building a finance SaaS platform using Next.js, React.js, and Hono.js, featuring CSV upload functionality.

## Blog Posts

- [The Problem with Postgres Replicas](https://neon.tech/blog/the-problem-with-postgres-replicas) - Blog post by Bryan Clark on the challenges associated with using Postgres replicas and explore potential solutions to overcome these issues.
- [Edit Records Directly from the Neon Console: Meet the New Tables Page](https://neon.tech/blog/edit-records-directly-from-the-neon-console-meet-the-new-tables-page) - Learn about Neon new Tables page feature that allows you to edit records directly from the console, simplifying database management.
- [Database Recovery Strategies to Help You Sleep at Night](https://neon.tech/blog/database-recovery-strategies-to-help-you-sleep-at-night) - Learn about essential database recovery strategies that ensure data safety and provide peace of mind.
- [A Database for Every Preview Environment Using Neon, GitHub Actions, and Vercel](https://neon.tech/blog/branching-with-preview-environments) - Blog post on how to set up a database for every preview environment using Neon, GitHub Actions, and Vercel to streamline your development process.
- [How to Create Previews with Anonymized Production-Like Data in Seconds](https://neon.tech/blog/how-to-create-previews-with-anonymized-production-like-data-in-seconds) - Learn to create previews with anonymized, production-like data quickly, enhancing testing and development workflows.
- [Build a Dynamic E-Commerce Store UI with Astro, Neon, and AWS Amplify](https://neon.tech/blog/build-a-dynamic-e-commerce-store-ui-with-astro-neon-postgres-and-aws-amplify) - Blog post on How to build a dynamic e-commerce store UI using Astro, Neon, and AWS Amplify for a seamless user experience.
- [Remember to Use Primary Keys vs Unique Constraints in Postgres](https://neon.tech/blog/remember-to-use-primary-keys-vs-unique-constraints-in-postgres) - Understand the differences between primary keys and unique constraints in Postgres and when to use each.
- [Database Branching Workflows: A Guide for Developers](https://neon.tech/blog/database-branching-workflows-a-guide-for-developers) - Blog post on database branching workflows for developers, enhancing collaboration and version control.
- [Full Stack Development with Next.js, Clerk, and Neon](https://www.freecodecamp.org/news/nextjs-clerk-neon-fullstack-development/) - Tutorial on building a full-stack application using Next.js, Clerk for authentication, and Neon.
- [How to Develop a CRUD App with Spring Boot, Neon, and Azure App Service](https://www.freecodecamp.org/news/nextjs-clerk-neon-fullstack-development/) - Tutorial on building a CRUD App with Spring Boot, Neon, and Azure App Service.

## YouTube Channel

- [Introduction](https://www.youtube.com/watch?v=EB0Nu_e9wCs) - Get introduced to Neon and learn about its key features and benefits in this comprehensive overview.
- [Features Overview](https://www.youtube.com/watch?v=I6DCo5RwHBE&t=474s) - Explore the various features of Neon in detail and see how they can enhance your database management experience.
- [Serverless Demo](https://www.youtube.com/watch?v=kvIK2NpuF2I) - Watch a live demo of Neon serverless capabilities and see how it can simplify your database infrastructure.
- [CLI Tutorial](https://www.youtube.com/watch?v=i_mAHOhpBSA) - Learn how to use the Neon CLI with this step-by-step tutorial, designed to help you get the most out of Neon's command-line tools.
- [Scaling](https://www.youtube.com/watch?v=atuu5XWkHBI) - Learn how Neon handles scaling to meet your application's growing demands in this informative video.
- [Branching Demo](https://www.youtube.com/watch?v=MSdHFUCeQ8g) - Watch a practical demonstration of Neon branching feature and learn how it can streamline your development workflow.

## Other Interesting Articles

- [SELECT 'Hello, World'](https://neon.tech/blog/hello-world/) - Blog post by Nikita Shamgunov on the high level architecture.
- [Architecture decisions in Neon](https://neon.tech/blog/architecture-decisions-in-neon/) - Blog post by Heikki Linnakangas.
- [Neon](https://www.youtube.com/watch?v=rES0yzeERns) - Presentation on storage system by Heikki Linnakangas in the CMU Database Group seminar series.
- [How 222 Uses Neon to Handle Their Frequent Spikes in Demand](https://neon.tech/blog/how-222-uses-neon-to-handle-their-frequent-spikes-in-demand) - Learn how 222 leverages Neon scalable database solutions to manage frequent demand spikes, ensuring stability and performance during high-traffic periods.
- [From Days to Minutes: How Neo Tax Accelerated Their Development Lifecycle](https://neon.tech/blog/from-days-to-minutes-how-neo-tax-accelerated-their-development-lifecycle) - Learn how Neo.Tax reduced their development time from days to minutes using Neon advanced features, boosting efficiency and productivity.
- [How Retool Uses Retool and the Neon API to Manage 300k Postgres Databases](https://neon.tech/blog/how-retool-uses-retool-and-the-neon-api-to-manage-300k-postgres-databases) - Learn how Retool integrates with the Neon API to manage over 300,000 Postgres databases, streamlining operations and enhancing performance.
- [Using btree_gist for Multicolumn Indexes in Postgres](https://neon.tech/blog/btree_gist) - Explore the benefits and applications of using the btree_gist extension for efficient multicolumn indexing in Postgres.
- [Adopting Neon Branching in CI/CD Pipelines: A Practical Story by Shepherd](https://neon.tech/blog/adopting-neon-branching-in-ci-cd-pipelines-a-practical-story-by-shepherd) - Discover how Shepherd implemented Neon branching in their CI/CD pipelines to improve development workflows and deployment processes.
- [Postgres Roles: What to Know Before You Begin](https://neon.tech/blog/the-non-obviousness-of-postgres-roles) - Practical tips for developers and gotchas to avoid when using Postgres roles.
