<div class="github-widget" data-repo="ciconia/awesome-music"></div>
## Awesome Music [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A categorized collection of awesome music libraries, tools, frameworks and software.

Contributions and suggestions are always welcome! Please take a look at the [contribution guidelines and quality standard](https://github.com/ciconia/awesome-music/blob/master/CONTRIBUTING.md) first.

Thanks to all [contributors](https://github.com/ciconia/awesome-music/graphs/contributors), you're awesome and this project wouldn't be possible without you!


## Audio Editing

* [Audacity](https://github.com/audacity/audacity) - a free, cross-platform digital audio editor.
* [Ardour](http://ardour.org/) - a cross-platform digital audio workstation emphasizing audio recording.
* [LMMS](https://lmms.io/) - another cross-platform digital audio workstation, more oriented towards making beats.
* [OpenUtau](https://github.com/stakira/openutau/) - A free, cross-platform singing voice synthesis framework.
* [snd](https://sourceforge.net/projects/snd/) - Snd is a sound editor modelled loosely after Emacs.
* [Stargate DAW](https://github.com/stargatedaw/stargate/) - A cross-platform, all-in-one digital audio workstation and plugin suite, optimized for EDM production.
* [TuneFlow](https://tuneflow.com/) - a next-gen DAW that helps you generate melody, beats, or a whole song, while still being able to edit them.

## Audio Libraries

* [audio.js](https://github.com/kolber/audiojs) - audio.js is a drop-in javascript library that allows HTML5's &lt;audio&gt; tag to be used anywhere.
* [audioFlux](https://github.com/libAudioFlux/audioFlux) - A library for audio and music analysis, feature extraction.
* [chord-mark](https://github.com/no-chris/chord-mark) - reference implementation of ChordMark, a text notation format for lyrics, chords and rhythm.
* [howler.js](https://github.com/goldfire/howler.js) - a Javascript audio library for the modern web.
* [JSyn](http://www.softsynth.com/jsyn/) - an audio synthesis software API for Java.
* [Librosa](https://github.com/librosa/librosa) - a python package for music and audio analysis, providing the building blocks necessary to create music information retrieval systems.
* [midi.js](https://github.com/mudcube/MIDI.js) - a framework for creating web-based MIDI apps.
* [mxml](https://github.com/venturemedia/mxml) - MusicXML parsing and layout library.
* [PortAudio](http://www.portaudio.com/) - a free, cross-platform, open-source, audio I/O library.
* [RustAudio](https://github.com/RustAudio) - an aggregate of free and useful Audio, DSP and music libraries written in Rust.
* [Soundpipe](https://pbat.ch/proj/soundpipe.html) - a lightweight DSP library written in C.

## Audio Tools

* [Beets](http://beets.io/) - a powerful command-line music organizer and manipulator.
* [Cecilia](https://github.com/belangeo/cecilia5) - a Pyo-based graphical environment for music and signal processing.
* [cyanrip](https://github.com/atomnuker/cyanrip) - rips and encodes standard audio CDs with the least effort required from user. Cross platform.
* [fre:ac](https://github.com/enzo1982/freac) - free audio converter. It supports audio CD ripping and tag editing.
* [Jack](https://github.com/jack-cli-cd-ripper/jack) - command-line CD ripper.
* [K3b](https://github.com/KDE/k3b) - is a full-featured CD/DVD/Blu-ray burning and ripping application.
* [Koel](https://github.com/phanan/koel) - an open-source personal audio streaming server.
* [Lame](http://lame.sourceforge.net/) - a high quality, free and open-source MP3 encoder.
* [lltag](https://github.com/bgoglin/lltag) - automatic command-line mp3/ogg/flac file tagger and renamer.
* [matchering](https://github.com/sergree/matchering) - сontainerized web application and library for automated reference audio mastering.
* [MusicBrainz](https://musicbrainz.org) - Open Encyclopedia for Music information and Metadata, providing a unique ID for everything
* [Musikernel](https://github.com/j3ffhubb/musikernel) - a futuristic audio production platform (hardware support, APIs, hosts, plugins and more)
* [Rubyripper](https://github.com/bleskodev/rubyripper) - is a secure digital audio extraction application ("cd ripper") for Unix-like operating systems.
* [SoX](http://sox.sourceforge.net/) - a free open-source command line utility for playing, converting and manipulating audio files.
* [split2flac](https://github.com/ftrvxmtrx/split2flac) - split flac/ape/wv/wav + cue sheet into separate tracks
* [Whipper](https://github.com/JoeLametta/whipper) - Python CD-DA ripper preferring accuracy over speed.
* [X Audio Copy](https://github.com/giorgiofranceschi/xaudiocopy) - GTK and GNOME application for ripping CD-Audio and encoding in lossy and lossless audio formats.

## Free Music Scores

* [bayanguru](https://bayanguru.org/) - engraving and publishing system that produces high quality sheet music for bayan in PDF.
* [cellist/Lilypond-Sheet-Music](https://github.com/cellist/Lilypond-Sheet-Music) - a collection of music typeset with lilypond (mostly chamber music and music for cello).
* [ciconia/music](https://github.com/ciconia/music) - a collection of mostly baroque music, lots of sacred works by J. S. Bach, coded in lilypond/ripple.
* [CPDL](http://www.cpdl.org/) - the choral public domain library contains more than 20K free scores of vocal music.
* [Éditions Nicolas Sceaux](https://github.com/nsceaux/nenuvar) - baroque music scores (mainly French music), typeset using lilypond.
* [IMSLP](http://imslp.org/) - the International Music Score Library Project is the largest collection of public domain scores and parts on the web.
* [Lavender Blue Open-Scores](https://github.com/madrisan/open-scores) - open scores for piano encoded using lilypond.
* [Mutopia](https://github.com/MutopiaProject/MutopiaProject) - sheet music based on editions in the public domain.
* [wbsoft/lilymusic](https://github.com/wbsoft/lilymusic) - beautiful LilyPond scores under free licenses.

## MIDI Tools & Libraries

* [JJazzLab-X](https://github.com/jjazzboss/JJazzLab-X) - a complete Midi-based framework for automatic backing tracks generation.
* [Midifile](http://midifile.sapp.org/) - C++ library for parsing Standard MIDI Files.
* [mido](https://github.com/mido/mido) - Python library for working with MIDI messages and ports.
* [Polyrhythmix](http://github.com/dredozubov/polyrhythmix) - MIDI drums
  generator, designed for polyrhythmic parts
* [Timidity](http://timidity.sourceforge.net/) - an open-source command line synthesizer that plays MIDI files.

## Music Notation

* [Abjad](http://abjad.mbrsi.org/) - a Python API for Formalized Score Control, based on Lilypond.
* [ChordMark](https://chordmark.netlify.app/) - a text-based notation format for lyrics, chords and rhythm.
* [Denemo](http://www.denemo.org/) - a free music notation editor based on Lilypond.
* [Digital Music Stand](https://github.com/PatWie/digitalmusicstand) - a free web app for displaying sheet music.
* [Jan Angermüller's music fonts page](http://elbsound.studio/music_fonts.php) - A listing and visual comparison of different music fonts.
* [Frescobaldi](https://github.com/wbsoft/frescobaldi) - a free Lilypond sheet music editor.
* [Guido](http://guidolib.sourceforge.net/) - a generic, portable library and API for the graphical rendering of musical scores.
* [Hacklily](https://www.hacklily.org) - online LilyPond-based sheet music editor (with optional GitHub integration).
* [Inknote](https://github.com/MichalPaszkiewicz/inknote) - free, open source, browser based music notation and composition software.
* [LibMEI](https://github.com/DDMAL/libmei) - a C++ library for reading and writing MEI files.
* [Lilybin](http://lilybin.com/) - an open source web-based LilyPond editor.
* [Lilypond](http://lilypond.org/) - free, open-source music engraving program, devoted to producing the highest-quality sheet music possible.
* [Lilypond cook book](https://github.com/noteflakes/lilypond-cookbook/wiki/) - tips & tricks for getting the most out of lilypond.
* [Lilypond Snippet Repository](http://lsr.di.unimi.it/) - an online database of Lilypond snippets ideas, features and hacks.
* [Lilyvm](https://github.com/olsonpm/lilyvm) - Lilypond version manager.
* [Lyp](https://github.com/noteflakes/lyp) - the Lilypond swiss army knife - easily install packages, manage multiple versions of Lilypond, and other tools for power users.
* [mei-friend](https://mei-friend.mdw.ac.at) - a friendly, browser-based editor for music encodings.
* [MuseScore](https://github.com/musescore/MuseScore) - free open-source music notation and composition software.
* [MusicKit](https://github.com/venturemedia/musickit) - Music sheet rendering for iOS and OSX.
* [neoscore](https://neoscore.org/) - python library for notating music in a graphics-first paradigm.
* [NOTATIO](http://notat.io/) - a forum devoted to the practice of music notation.
* [OpenLilyLib](https://github.com/openlilylib/snippets/) - LilyPond tools - snippets, templates, and extensions.
* [OpenSheetMusicDisplay](https://github.com/opensheetmusicdisplay/opensheetmusicdisplay) - Typescript library for rendering MusicXML in the browser.
* [Python-ly](https://pypi.python.org/pypi/python-ly) - a tool and library for manipulating LilyPond files.
* [Ripple](https://github.com/ciconia/ripple/) - DRY for Lilypond - generate scores and parts with minimal fuss.
* [Scorelib](http://scorelib.sapp.org/) - a C++ library for parsing SCORE data files.
* [Tbon](https://github.com/Michael-F-Ellis/tbon) - Typographic Beat-Oriented Notation for music.
* [Unison](https://unisonofficial.com/html/user-documentation.html?title=unison-editor) - Proprietary software for creating music score with words.
* [Verovio](https://github.com/rism-ch/verovio) - a library and a toolkit for engraving MEI music notation into SVG.
* [Vexflow](https://github.com/0xfe/vexflow) - a JavaScript library for rendering music notation and guitar tablature.

## Music Programming

* [Alda](https://github.com/alda-lang/alda) - a music programming language for musicians.
* [Bach: Automated Composer's Helper](http://www.bachproject.net/) - a cross-platform set of patches and externals for Max, aimed to bring the richness of computer-aided composition into the real-time world.
* [Cane](https://github.com/Jackojc/cane) - A small MIDI sequencer DSL designed around vectors and euclidean rhythms.
* [Chuck](https://github.com/ccrma/chuck) - strongly-timed, concurrent, and on-the-fly music programming language.
* [CoffeeCollider](https://github.com/mohayonao/CoffeeCollider) - a language for real time audio synthesis and algorithmic composition in HTML5. "Write CoffeeScript, and be processed as SuperCollider."
* [Common Music](http://commonmusic.sourceforge.net/) - an open source music composition system.
* [Csound](http://csound.github.io/) - a user-programmable and user-extensible sound processing language and software synthesizer.
* [Faust](http://faust.grame.fr/) - a functional programming language specifically designed for real-time signal processing and synthesis.
* [Gwion](https://github.com/Gwion/Gwion) - A strongly-timed programming language aimed at music creation. Heavily inspired by ChucK.
* [IanniX](https://github.com/iannix/IanniX) - a graphical open-source sequencer, based on Iannis Xenakis works, for digital art.
* [Inscore](http://inscore.sourceforge.net/) - an environmnent for the design of interactive, augmented music scores.
* [Leipzig](https://github.com/ctford/leipzig) - a composition library for Overtone.
* [Midica](https://github.com/truj/midica) - MIDI programming language with decompiler and player, supports karaoke.
* [music21](http://web.mit.edu/music21/) - A Toolkit for Computational Musicology.
* [Music Suite](http://music-suite.github.io/docs/ref/) - a language for generalized music notation and theory, based on Haskell.
* [mutwo](https://mutwo-org.github.io/) - a Python library for composition that outputs notation, MIDI or audio files and that provides a generalized model to describe time-based structures.
* [Nyquist](https://www.cs.cmu.edu/~music/nyquist/) - a sound synthesis and composition language.
* [OpenMusic](http://repmus.ircam.fr/openmusic/home) - a visual programming language based on Lisp.
* [Orca](https://github.com/hundredrabbits/Orca) - live programming environment for music.
* [Overtone](https://github.com/overtone/overtone/) - an Open Source toolkit for designing synthesizers and collaborating with music.
* [Platonic Music Engine](http://www.platonicmusicengine.com/) - an open-source music generation framework written in Lua.
* [Pure Data](http://puredata.info/) - a visual programming language for audio and other multimedia.
* [pyo](https://belangeo.github.io/pyo/) - a Python module to help digital signal processing script creation.
* [py-modular](http://py-modular.readthedocs.io/) - a modular and experimental programming environment with basic DSP routines in python.
* [Sardine](https://github.com/Bubobubobubobubo/sardine) - a music live coding library for Python 3.10+ (MIDI/OSC/SuperCollider).
* [slippery chicken](https://github.com/mdedwards/slippery-chicken) - a Common Lisp environment for composition building on CLM, CMN, CM, MusicXML and Lilypond for score, sound file, and/or MIDI file outputs.
* [Sonic Pi](http://sonic-pi.net/) - a live coding synth with an emphasis on educational use.
* [Sporth](https://pbat.ch/proj/sporth.html) - a small stack based audio language.
* [Strudel](https://strudel.tidalcycles.org/) - an experiment in making a language built on javascript for live coding patterns using web technologies.
* [SuperCollider](http://supercollider.github.io/) - a programming language for real time audio synthesis and algorithmic composition.
* [Tidal](https://tidalcycles.org/) - a language built on Haskell for live coding patterns.
* [Topos](https://topos.live) - a web based live coding environment (WebAudio / MIDI)
* [tuneflow-py](https://github.com/tuneflow/tuneflow-py/) - python plugin SDK for the next-gen DAW, that allows you to program your music algorithms & AI models into all stages of music production
* [Unilang](https://unisonofficial.com/html/user-documentation.html?title=unison-editor) - Domain specific language used in Unison.

## Music Theory Teaching

* [Artusi](https://www.artusi.xyz) - Interactive music theory exercises.
* [Four Score and More](https://fourscoreandmore.org/) - Tailored music theory exercises based on scores.
* [musictheory.net](https://www.musictheory.net) - Lessons and exercises
* [OpenMusicTheory](http://openmusictheory.com/) - a growing, online "textbook" for music theory and aural skills.
* [Theorytab](https://www.hooktheory.com/theorytab) - a database of songs with their chord functions.

## Standards

* [MEI (Music Encoding Initiative)](http://music-encoding.org/) - an open-source effort to define a system for encoding musical documents in a machine-readable structure.
* [MusicXML](http://www.musicxml.com/) - the standard open format for exchanging digital sheet music.
* [SMuFL (Standard Music Font Layout)](http://www.smufl.org/) - a specification for mapping music symbols to Unicode for use in music fonts.

## Other Awesomeness

## Related lists

* [Awesome Audio DSP](https://github.com/BillyDM/awesome-audio-dsp) - A curated list of audio DSP and plugin development resources.
* [Awesome Audio Visualization](https://github.com/willianjusten/awesome-audio-visualization) - A curated list about Audio Visualization.
* [Awesome Music Listening](https://github.com/ybayle/awesome-music-listening) - Awesome list of websites dedicated to listening to music.
* [Awesome Music Production](https://github.com/adius/awesome-music-production) - A curated list of software and resources to create music.
* [Awesome Python for Scientific Audio](https://github.com/faroit/awesome-python-scientific-audio) - A curated list of python software and packages related to scientific research in audio.
* [Awesome sheet music](https://github.com/adius/awesome-sheet-music) - A curated list of awesome sheet music software, libraries and resources.
* [Awesome WebAudio](https://github.com/notthetup/awesome-webaudio) - A curated list of awesome WebAudio packages and resources.

Other amazingly awesome lists can be found in the [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) list.

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Sharon Rosner](http://github.com/ciconia) has waived all copyright and related or neighboring rights to this work.
