<div class="github-widget" data-repo="dspinellis/awesome-msr"></div>
## Awesome Empirical Software Engineering [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
一个精选的数据集和工具存储库，可用于对软件系统进行基于证据的数据驱动研究.
这种研究方法通常被称为 [experimental, or empirical software engineering](https://en.wikipedia.org/wiki/Experimental_software_engineering).
许多数据集也可用于研究 [search-based software engineering](https://en.wikipedia.org/wiki/Search-based_software_engineering) 方法.
该存储库以 [Mining Software Repositories (MSR)](https://www.msrconf.org/) 会议系列.
有关此类工作的示例，请参阅 MSR 会议 [Hall of Fame](http://2016.msrconf.org/#/hall-of-fame).


- 此列表需要您的输入才能不断改进.
  阅读 [contribution guide](https://github.com/dspinellis/awesome-msr/blob/master/contributing.md) 有关如何操作的说明
  你可以贡献.
  或者，你可以给我发一个 [email](https://github.com/dspinellis/awesome-msr/blob/master/mailto:dds@aueb.gr)
  如果您发现该过程过于繁琐或令人困惑.
- 有关更多精彩列表，请参阅 [awesome](https://github.com/sindresorhus/awesome).


## Repositories

- [SIR](http://sir.unl.edu/portal/index.php) - Software-artifact infrastructure repository; Java, C, C++, and C# software together with test suites and fault data.
- [PROMISE](http://promise.site.uottawa.ca/SERepository/datasets-page.html) - 大约 20 个与软件工程研究相关的数据集.
- [FLOSSmole](https://flossmole.org/collection_details) - 协作收集和分析免费/自由/开源项目数据.
- [Zenodo](http://zenodo.org/) - CERN 开放访问存储库中的软件数据集合.
  - [Software Engineering Artifacts Can Really Assist Future Tasks](http://zenodo.org/communities/seacraft)
  - [Empirical Software Engineering](https://zenodo.org/communities/empirical-software-engineering/)
  - [Mining Software Repositories](https://zenodo.org/communities/msr/)

## Data Sets

- [AndroidTimeMachine](https://androidtimemachine.github.io) - 基于图形的 8,431 个真实世界 Android 应用程序提交历史数据集.
- [AndroZoo](https://androzoo.uni.lu/) - Android 应用程序的集合.
- [Bug Prediction Dataset](http://bug.inf.usi.ch/index.php) - 从 Eclipse JDT Core、PDE UI、Equinox Framework、Lucene、Mylyn 及其历史中收集模型和指标.
- [Code Reviews](http://kin-y.github.io/miningReviewRepo/) - OpenStack、LibreOffice、AOSP、Qt、Eclipse 的代码审查.
- [CoREBench](http://www.comp.nus.edu.sg/%7Erelease/corebench/) - 从四个开源软件项目的存储库和错误报告中系统地提取了 70 个实际复杂的回归错误的集合：Make、Grep、Findutils 和 Coreutils.
- [Cryptocurrency GitHub Activity and Market Cap Dataset](https://rvantonder.github.io/CryptOSS/)  - 随着时间的推移，GitHub 上 200 多个加密货币项目的提交、星级、价格和市值等活动. 原始的历史数据也是 [available](https://zenodo.org/record/2595588#.XRuzuBNKhSM).
- [Defects4J](https://github.com/rjust/defects4j) - 收集了 395 个可重现的错误，目的是推进软件测试研究.
- [Eclipse AERI stacktraces](http://download.eclipse.org/scava/datasets/aeri_stacktraces/aeri_stacktraces.html) - Eclipse IDE 用户遇到的异常堆栈跟踪集合，由 AERI 报告系统检索.
- [Enron Spreadsheets and Emails](https://figshare.com/articles/Enron_Spreadsheets_and_Emails/1221767) - 论文“安然的电子表格和相关电子邮件：数据集和分析”中使用的所有电子表格和电子邮件.
- [Findbugs-maven](https://github.com/istlab/maven_bug_catalog) - Java 项目的 FindBugs 报告集 [Maven repository](https://maven.apache.org).
- [GHTorrent](http://ghtorrent.org/) - 通过 GitHub REST API 提供的可扩展、可查询、离线的数据镜像.
- [GitHub Bug Dataset](http://www.inf.u-szeged.hu/~ferenc/papers/GitHubBugDataSet/) - 15 个以静态源代码指标为特征的 Java 开源项目的错误数据集.
- [GitHub on Google BigQuery](https://cloud.google.com/bigquery/public-data/github) - 可通过 Google 的 BigQuery 平台访问 GitHub 数据.
- [Grammar Zoo](http://slebok.github.io/zoo/) - DSL 和 GPL 的语法集合，一些是从元模型和文档模式中提取的.
- [KaVE](http://www.kave.cc/datasets) - 开发者工具交互数据.
- [Linux Kernel 4.21 Call Graphs](https://zenodo.org/record/2652487#.XRnvomUzb0o) - 使用生成的 Linux 内核 4.21 调用图 [CScout](https://github.com/dspinellis/cscout/). 
- [Maven metrics](https://github.com/bkarak/data_msr2015) - 收集软件复杂性和规模指标 [Maven Repository](https://maven.apache.org).
- [Maven Dependency Graph](https://zenodo.org/record/1489120) - 2018 年 9 月 6 日拍摄的整个 Maven Central 的快照，存储在图形数据库中.
- [mzdata](https://github.com/jxshin/mzdata) - Mozilla 问题跟踪历史的多提取和多层次数据集.
- [npm-miner](https://github.com/AuthEceSoftEng/msr-2018-npm-miner) - 数据集包含了 5 个开源软件质量工具 eslint、escomplex、nsp、jsinspect 和 sonarjs 对 2000 个流行（按星级和下载量）npm 包的分析结果.
- [OCL Expressions on GitHub](https://github.com/tue-mdse/ocl-dataset) - 来自 245 个系统选择的 GitHub 存储库中的 504 个 EMF 元模型的 9188 个 OCL 表达式的数据集.
- [RepoReapers Data Set](https://reporeapers.github.io) - 包含来自 GHTorrent 的_工程软件项目_集合的数据集.
- [Software Heritage Graph Dataset](https://doi.org/10.5281/zenodo.2583978) - 来自各种伪造（GitHub、Gitlab、Debian、PyPI、Google Code 等）的超过 8000 万个软件项目的开发历史和文件元数据图表，以去重和统一的表示形式（[paper here](https://dl.acm.org/citation.cfm?id=3341907)).
- [STAMINA](http://stamina.chefbe.net/download) -（状态机推理方法）数据用于对学习确定性有限状态机 (FSM) 的技术进行基准测试.
- [Stack Exchange](https://archive.org/details/stackexchange) - Stack Exchange 网络上所有用户贡献内容的匿名转储.
- [TravisTorrent](http://travistorrent.testroots.org) - 提供免费且易于使用的 Traivs CI 构建分析.
- [Ultimate Debian Database (UDD)](https://wiki.debian.org/UltimateDebianDatabase) - 在同一 SQL 数据库中有关 Debian 各个方面的数据（例如软件包、错误、维护者）.
- [Unified Bug Dataset](http://www.inf.u-szeged.hu/~ferenc/papers/UnifiedBugDataSet/) - 基于静态源代码的数据集，包括 Bugcatchers Bug 数据集， [Bug Prediction Dataset](http://bug.inf.usi.ch/index.php)， 这 [Eclipse Bug Dataset](https://www.st.cs.uni-saarland.de/softevo/bug-data/eclipse/)， 这 [GitHub Bug Dataset](http://www.inf.u-szeged.hu/~ferenc/papers/GitHubBugDataSet/), 一些数据集来自 [PROMISE](http://promise.site.uottawa.ca/SERepository/datasets-page.html) 存储库.
- [Unix history](https://github.com/dspinellis/unix-history-repo) - 具有 46 年 Unix 历史演变的 Git 存储库.

## Tools
- [astminer](https://github.com/JetBrains-Research/astminer) - 用于挖掘基于路径的代码表示和从 AST 派生的其他数据的库和工具.
- [Boa](http://boa.cs.iastate.edu/) - 简化挖掘软件存储库的特定领域语言和基础设施.
- [buckwheat](https://github.com/JetBrains-Research/buckwheat) - 用于从源代码中提取标识符的多语言分词器.
- [ckjm](http://www.spinellis.gr/sw/ckjm/) - Chidamber 和 Kemerer Java 指标.
- [Coming](https://github.com/SpoonLabs/coming/) - 用于分析代码更改和从 Git 存储库中挖掘更改模式实例的 Java 框架.
- [CryptOSS](https://github.com/rvantonder/CryptOSS) - 挖掘加密货币项目的 GitHub 活动和市值数据.
- [DbDeo](https://github.com/tushartushar/DbDeo) - 提取嵌入式 SQL 语句并检测数据库模式气味.
- [Designite](http://www.designite-tools.com) - Compute source code metrics and detect a variety of implementation, design, and architecture smells for C#.
- [DesigniteJava](https://github.com/tushartushar/DesigniteJava) - 计算源代码指标并检测 Java 的各种实现和设计味道.
- [Diggit](https://github.com/jrfaller/diggit) - Agile Ruby Tool to analyze Git repositories.
- [GrimoireLab](http://grimoirelab.github.io/) - 用于软件开发分析的免费/自由/开源工具.
- [MetricMiner](http://www.github.com/mauricioaniche/metricminer2) - 精益 Java DSL 从 Git 和 SVN 存储库中挖掘和提取数据（例如提交、开发人员、修改、差异）.
- [Maven-miner](https://github.com/diverse-project/maven-miner) - 用于解析整个 Maven 依赖关系图的 Java 工具和基础设施，托管在 Maven Central 中，形式为 [Neo4j](https://neo4j.com/) 图形.
- [Perceval](https://github.com/chaoss/grimoirelab-perceval) - 从数十个后端获取存储库数据.
- [Puppeteer](https://github.com/tushartushar/Puppeteer) - 检测 Puppet 代码中的配置异味.
- [PyDriller](https://github.com/ishepard/pydriller) - 用于分析 Git 存储库的 Python 框架.
- [qmcalc](https://github.com/dspinellis/cqmetrics) - 从 C 源代码计算质量指标.
- [reaper](https://github.com/RepoReapers/reaper)  - 用于计算 GHTorrent 存储库分数的 Python 工具. 该分数量化了存储库中包含的项目_工程化_的程度.
- [RefactoringMiner](https://github.com/tsantalis/RefactoringMiner) - 用于检测 Java 代码更改中的重构的库/API.
- [VulData7](https://github.com/electricalwind/data7) - Java 框架支持自动收集提交修复 NVD 中报告的漏洞（将 NVD 与 Git 链接）.

## Research Outlets
- 专门致力于经验软件工程研究的网点
  - [Empirical Software Engineering journal](https://link.springer.com/journal/10664)
  - [MSR: Mining Software Repositories conference](https://www.msrconf.org/)
  - [PROMISE: Predictive Models and Data Analytics in Software Engineering conference](http://promise.site.uottawa.ca/SERepository/)
- 发布实证软件工程研究的网点
  - [ACM Transactions on Software Engineering and Methodology (TOSEM)](https://dl.acm.org/citation.cfm?id=J790)
  - [ESEC/FSE: ACM Joint European Software Engineering Conference and Symposium on the Foundations of Software Engineering](https://www.esec-fse.org/)
  - [ICSE: International Conference on Software Engineering](http://www.icse-conferences.org/)
  - [IEEE Software magazine](https://publications.computer.org/software-magazine/)
  - [IEEE Transactions on Software Engineering](https://www.computer.org/csdl/journal/ts)
  - [Journal of Systems and Software](https://www.journals.elsevier.com/journal-of-systems-and-software)
  - [SANER: IEEE International Conference on Software Analysis, Evolution and Reengineering](https://ieeexplore.ieee.org/xpl/conhome.jsp?punumber=1000695)


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Diomidis Spinellis](http://www.spinellis.gr) 已放弃该作品的所有版权和相关或邻接权.
