<div class="github-widget" data-repo="hobbyquaker/awesome-mqtt"></div>
## Awesome MQTT

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; MQTT 相关内容的精选列表.

 MQTT 是一种轻量级客户端-服务器发布/订阅消息传递协议，针对高延迟或不可靠的网络进行了优化. 该协议是物联网应用、遥测、传感器网络、智能计量、家庭自动化、消息传递和通知服务的不错选择.




### Community Resources

* [mqtt.org](https://mqtt.org/).
* [MQTT community wiki](https://github.com/mqtt/mqtt.org/wiki).
* [Google Groups: MQTT](https://groups.google.com/forum/#!forum/mqtt).
* [IRC channel #mqtt on the freenode network](https://github.com/hobbyquaker/awesome-mqtt/blob/master/irc://irc.freenode.net/mqtt).
* [A list of public brokers](http://moxd.io/2015/10/17/public-mqtt-brokers/).

#### Blogs

* [Ben Hardill](https://www.hardill.me.uk/wordpress/tag/mqtt/)
* [Dominik Obermaier](http://forkbomb-blog.de/category/mqtt)
* [Jan-Piet Mens](https://jpmens.net/)
* [Nick O'Leary](https://knolleary.net/)

#### Talks

* [An Introduction to MQTT: Why HTTP isn't the King of the Internet of Things](https://www.youtube.com/watch?v=LKz1jYngpcU) - Shinji Kim，Robert Bird - Akamai，2017 年三星开发者大会.
* [Einführung in MQTT](https://www.youtube.com/watch?v=INYG4-xsa9c) - Dominik Obermaier &amp; Jens Deters， [Building IoT](https://www.buildingiot.de/index.php) 2016 年会议（德语）.

### Broker

* [Ably](https://www.ably.io/documentation/mqtt) - MQTT 代理服务和协议适配器
* [ActiveMQ](http://activemq.apache.org/) - 快速的 Java 多协议消息传递和集成模式服务器.
* [Aedes](https://github.com/moscajs/aedes) - 可以在任何流服务器上运行的准系统 MQTT 代理，节点方式.
* [Emitter](https://github.com/emitter-io/emitter) - 基于MQTT协议的分布式、可扩展、容错的发布-订阅消息传递平台，具有消息存储功能.
* [EMQ X](https://github.com/emqx/emqx) - 用于 5G 时代物联网的可扩展且可靠的实时 MQTT 消息传递引擎.
* [esp_uMQTT_broker](https://github.com/martin-ger/esp_mqtt) - ESP8266 上的基本 MQTT 代理.
* [hbmqtt](https://github.com/beerfactory/hbmqtt) - 使用 asyncio 的 Python MQTT 代理.
* [HiveMQ](https://www.hivemq.com/)  - 支持 MQTT 3.1、3.1.1 和 5.0 的 Java MQTT Broker. 提供商业和开源版本.
* [hrotti](https://github.com/alsm/hrotti) - 用 Go 编写的 MQTT 代理.
* [KMQTT](https://github.com/davidepianca98/KMQTT) - Kotlin 多平台 MQTT 代理，可嵌入和独立.
* [Moquette](https://github.com/moquette-io/moquette) - Java MQTT 轻量级代理.
* [Mosca](http://www.mosca.io/) - Mosca 是一个 node.js MQTT 代理，可以独立使用或嵌入到另一个 Node.js 应用程序中.
* [Mosquitto](http://mosquitto.org/) - *“*The”** 开源 MQTT 代理. 
     * [Free test server](https://mqtt.eclipseprojects.io) 由 Eclipse 基金会主办.
     * [Authorization Plugin in Go](https://github.com/iegomez/mosquitto-go-auth) 支持多种登录方式.
     * [Let's Encrypt Mosquitto Docker Container](https://hub.docker.com/r/pythonlinks/letsencrypt-mosquitto) 使加密变得容易. 
* [MyQttHub](https://myqtthub.com) - 云 MQTT 经纪人.
* [Mystique](https://github.com/TheThingsIndustries/mystique) - An extendable MQTT broker written in Go, with HTTP capabilities for observability. Implements MQTT v3.1.1.
* [RabbitMQ](https://www.rabbitmq.com/mqtt.html) - RabbitMQ 提供了一个 MQTT 适配器.
* [SurgeMQ](https://zhen.org/categories/surgemq/) - Go 中的高性能 MQTT 服务器和客户端库.
* [VerneMQ](https://vernemq.com/) - 一个 Apache2 许可的分布式 MQTT 代理，在 Erlang 中开发.
* [Vert.x MQTT](https://github.com/vert-x3/vertx-mqtt) - 用于处理与远程 MQTT 客户端的连接、通信和消息交换的 Vert.x 组件.
* [Waterstream](https://waterstream.io/) - MQTT 代理利用 Apache Kafka 作为自己的存储和分发引擎.
* [NanoMQ](https://github.com/nanomq/nanomq) - 用于 IoT Edge 平台的轻量级且速度极快的 MQTT 代理.

### Cloud

* [Adafruit IO](https://io.adafruit.com)  - Adafruit IO 是将您的项目连接到互联网的最简单方法. 您可以使用您选择的编程语言（我们有很多库）使用您选择的设备轻松地将您的项目连接到 Adafruit IO，并通过互联网进行控制或监控. 使用 Adafruit IO 存储的数据由您管理和控制.
- [Alibaba Cloud IoT Platform](https://www.alibabacloud.com/product/iot) - 在设备和物联网平台之间提供安全可靠的通信，使您可以在单个物联网平台上管理大量设备.
- [AWS IoT Core](https://aws.amazon.com/iot-core/?nc1=h_ls)  - AWS IoT Core 是一种托管云服务，可让连接的设备轻松安全地与云应用程序和其他设备进行交互.  AWS IoT Core 可以支持数十亿台设备和数万亿条消息，并且可以可靠、安全地处理这些消息并将其路由到 AWS 终端节点和其他设备. 借助 AWS IoT Core，您的应用程序可以始终跟踪所有设备并与之通信，即使它们未连接也是如此.
- [Azure IoT Hub](https://azure.microsoft.com/en-us/services/iot-hub/)  - 在您的 IoT 应用程序和它管理的设备之间实现高度安全和可靠的通信.  Azure IoT 中心提供了一个云托管的解决方案后端，几乎可以连接任何设备. 通过按设备身份验证、内置设备管理和扩展配置，将您的解决方案从云端扩展到边缘.
- [CloudMQTT](https://www.cloudmqtt.com/)  - 用于物联网的托管消息代理. 为物联网完美配置和优化的消息队列，几秒钟内准备就绪.
- [EMQ X MQTT Cloud](https://cloud.emqx.io/) - 安全、可靠的 MQTT 云服务，采用 EMQ 团队的最佳实践.
- [flespi](https://flespi.com/mqtt-broker) - 免费且安全的云 MQTT 代理，具有私有名称空间、MQTT 3.1.1 和 MQTT 5.0 支持以及华丽的限制.
- [Google Cloud IoT](https://cloud.google.com/solutions/iot/)  - Google Cloud IoT 是一套完整的工具，用于连接、处理、存储和分析边缘和云端的数据. 该平台由可扩展、完全托管的云服务组成； 用于边缘/本地计算的集成软件堆栈，具有机器学习功能，可满足您的所有物联网需求.
- [HiveMQ Cloud](https://www.hivemq.com/cloud/)  - HiveMQ Cloud 是一个完全托管的 MQTT 平台，可将物联网设备连接到任何物联网云平台. 一种云原生 IoT 消息传递平台，可简化可靠且可扩展的 IoT 设备连接.
- [IBM WATSON](https://www.ibm.com/watson) - 借助 Watson，您可以将 AI 工具和应用程序带到您的数据中，无论数据位于何处——无论是在 IBM Cloud、AWS、Azure、Google 还是您自己的私有云平台上.

### Platforms

* [mainflux](https://www.mainflux.com/)  - 设备管理、数据聚合、数据管理、数据分析、连接和消息路由以及事件管理. 由 Linux 软件基金会支持.
核心分析
* [thingsboard](https://thingsboard.io/) - 物联网项目的设备管理、数据收集、处理、事件管理和可视化.


### Tools
* [hivemq-mqtt-web-client](https://github.com/hivemq/hivemq-mqtt-web-client) - 基于浏览器的 MQTT 客户端，利用 MQTT over websockets. [Direct Link](http://www.hivemq.com/demos/websocket-client/)
* [imqtt](https://github.com/shafreeck/imqtt) - 基于 IPython 的交互式 MQTT 数据包操作 shell.
* [IoT-Testware](https://projects.eclipse.org/projects/technology.iottestware) - Eclipse IoT-Testware 是用于 IoT 协议的一致性测试套件的集合，其中包含用于模糊测试和性能测试的附加工具.
* [moxy](https://github.com/jvermillard/moxy) - Golang MQTT 代理提供有用的输出跟踪以监控 MQTT 通信并排除故障.
* [MQTT Board](https://github.com/flespi-software/MQTT-Board) - 面向诊断的开源 MQTT 客户端工具.
* [mqtt-admin](https://github.com/hobbyquaker/mqtt-admin/) - 基于 Web 的 MQTT 前端. [Direct Link](https://hobbyquaker.github.io/mqtt-admin/).
* [mqtt-benchmark](https://github.com/chirino/mqtt-benchmark) - MQTT 服务器的基准测试工具.
* [MQTT CLI](https://github.com/hivemq/mqtt-cli) - 用于连接支持 MQTT 5.0 和 3.1.1 的各种 MQTT 客户端的命令行界面.
* [mqtt-client](https://github.com/sdeancos/mqtt-client) - 一个简单的 MQTT 客户端命令行 (Python)（使用 paho lib）
* [mqtt-forget](https://github.com/hobbyquaker/mqtt-forget) - 用于通过通配符删除保留的 MQTT 主题的命令行工具.
* [mqtt-fuzz](https://github.com/F-Secure/mqtt_fuzz) - MQTT 协议的简单模糊器.
* [mqtt-malaria](https://github.com/etactica/mqtt-malaria) - 用于 MQTT 环境的可扩展性和负载测试实用程序.
* [mqtt-mirror](https://github.com/4nte/mqtt-mirror)  - 将 MQTT 流量从一个代理镜像到另一个代理. 可用作 CLI 工具、helm chart 或 docker 镜像.
* [MQTT-PWN](https://github.com/akamai-threat-research/mqtt-pwn) - MQTT-PWN 旨在成为 IoT Broker 渗透测试和安全评估操作的一站式商店.
* [mqtt_recorder](https://github.com/rpdswtk/mqtt_recorder) - 用于记录和重放 MQTT 消息的简单 cli 工具.
* [mqtt-shell](https://github.com/pidster-dot-org/mqtt-shell) - 用于 MQTT 的简单交互式 shell.
* [mqtt-spy](http://kamilfb.github.io/mqtt-spy/)  - 基于 Java 的 MQTT 前端. 支持脚本.
* [mqtt_tree](https://github.com/poggenpower/mqtt_tree)  - 在可扩展树中显示所有主题，如果您有很多客户发布，有助于获得概览.  （蟒蛇，tkinter）
* [mqtt-utils](https://github.com/dsell/mqtt-utils) - MQTT 实用程序的集合.
* [mqtt-wall](https://github.com/bastlirna/mqtt-wall) - 仅订阅基于 Web 的客户端——例如 MQTT 的 Twitter 墙.
* [mqtt-wildcard](https://github.com/hobbyquaker/mqtt-wildcard) - 用于将 MQTT 主题与通配符匹配的 Node.js 模块.
* [MQTT.fx](https://mqttfx.jensd.de/)  - MQTT.fx 是一个基于 Eclipse Paho 用 Ja​​va 编写的 MQTT 客户端. 支持脚本.
* [mqttcli](https://github.com/shirou/mqttcli) - 用于 shell 脚本的 MQTT 客户端.
* [MQTTInspector](https://github.com/ckrey/MQTTInspector) - 适用于 iOS（iPhone 和 iPad）的通用 MQTT 测试应用程序.
* [MQTTLens](https://chrome.google.com/webstore/detail/mqttlens/hemojaaeigabkbcookmlgmdigohjobjm) - 连接到 MQTT 代理并能够订阅和发布 MQTT 主题的 Google Chrome 应用程序.
* [MQTT Explorer](https://mqtt-explorer.com/) - 在主题层次结构中可视化您的 MQTT 主题的工具，一把 MQTT 瑞士军刀.
* [MQTT TUI](https://github.com/EdJoPaTo/mqttui) - 基于简单轻量级终端的 MQTT 监控器和发布器.
* [Python MQTT Client Shell](https://github.com/bapowell/python-mqtt-client-shell) - 基于文本控制台的交互式 shell，用于执行与 MQTT 客户端通信相关的各种任务.
* [SimpleMQTT](https://simplemqtt.theoi.de/) - 一个 Slack 应用程序，用于使用斜线命令将消息从 Slack 发送到 MQTT 代理.
* [Wireshark-MQTT](https://github.com/menudoproblema/Wireshark-MQTT) - 用于 Wireshark 的 MQTT 解析器.
* [VSMQTT](hhttps://github.com/rpdswtk/vsmqtt) - 集成在 Visual Studio Code 中的简单 MQTT 客户端.
* [MQTTX](https://github.com/emqx/MQTTX) - MQTTX 是 EMQ 开源的跨平台 MQTT 桌面客户端，支持 macOS、Linux 和 Windows.
* [MQTT-Tiles](https://github.com/flespi-software/MQTT-Tiles)  - 基于 MQTT 的 IoT 仪表板可视化工具. 允许轻松共享仪表板. 与任何支持 WSS 协议的 MQTT 代理一起工作.

### Clients

* [aiomqtt](https://github.com/mossblaser/aiomqtt) - 基于 paho-mqtt 的异步 Python MQTT 客户端.
* [CocoaMQTT](https://github.com/emqx/CocoaMQTT) - 用 Swift 编写的适用于 iOS 和 OS X 的 MQTT.
* [emqttc](https://github.com/emqx/emqtt) - 异步 Erlang MQTT 客户端.
* [gmqtt](https://github.com/wialon/gmqtt) - Python MQTT v5.0 客户端（基于异步）.
* [hbmqtt](https://github.com/beerfactory/hbmqtt) - 使用 asyncio 的 Python MQTT 客户端.
* [hivemq-mqtt-client](https://github.com/hivemq/hivemq-mqtt-client) - 高性能 Java MQTT 客户端库，具有适用于 MQTT 5.0 和 3.1.1 的不同 API 风格.
* [Hulaaki](https://github.com/suvash/hulaaki) - 用于与 MQTT 代理通信的客户端的 Elixir 库.
* [luamqtt](https://github.com/xHasKx/luamqtt/) - 纯 lua MQTT v3.1.1 和 v5.0 客户端.
* [Machine Head](https://github.com/clojurewerkz/machine_head) - Clojure MQTT 客户端.
* [MiniMQTT](https://github.com/adafruit/Adafruit_CircuitPython_MiniMQTT) - CircuitPython 的 MQTT 客户端库
* [MIMIC MQTT Simulator](https://www.gambitcomm.com/site/mqttsimulator.php) - 每台服务器模拟多达 100,000 个 MQTT 客户端，用于开发/测试/部署 IoT 应用程序.
* [Moscapsule](https://github.com/flightonary/Moscapsule) - 用 Swift 编写的适用于 iOS 的 MQTT 客户端.
* [Mosquitto-PHP](https://github.com/mgdm/Mosquitto-PHP) - 用于 PHP 的 Mosquitto MQTT 客户端库的包装器.
* [mqtt_cpp](https://github.com/redboltz/mqtt_cpp) - 基于 Boost.Asio 的 C++14 的 MQTT 客户端.
* [mqtt_lua](http://geekscape.github.io/mqtt_lua/) - Lua 语言的 MQTT 客户端库.
* [MQTT-C](https://github.com/LiamBindle/MQTT-C) - 适用于嵌入式系统和 PC 的便携式 MQTT C 客户端.
* [MQTT-Client-Framework](https://github.com/novastone-media/MQTT-Client-Framework) - iOS、OSX、tvOS 原生 ObjectiveC MQTT 客户端框架.
* [mqtt-client](https://github.com/centamiv/mqtt-client) - 实现 MQTT 客户端的 Polymer Web 组件（使用 Paho mqttws31.js）.
* [mqtt-elements](https://github.com/mqttjs/mqtt-elements) - MQTT 的聚合物元素.
* [mqtt-rs](https://github.com/zonyitoo/mqtt-rs) - Rust 的 MQTT 协议库.
* [mqtt-stats](https://github.com/gambitcomminc/mqtt-stats) - 订阅者客户端监控 MQTT 主题统计
* [mqtt-wrapper](https://www.webcomponents.org/element/hobbyquaker/mqtt-wrapper/elements/mqtt-wrapper) - 包装其他元素并将它们链接到 MQTT 主题的聚合物元素.
* [mqtt.dart](https://github.com/jnguillerme/mqtt.dart) - 飞镖 MQTT 客户端.
* [MQTT.js](https://github.com/mqttjs) - Node.js 的 MQTT 客户端.
* [mqtt](https://github.com/jeffallen/mqtt) - Go 中的 MQTT 客户端、服务器和负载测试器.
* [mqttex](https://github.com/alfert/mqttex) - Elixir 中的 MQTT 实现.
* [MQTTKit](https://github.com/mobile-web-messaging/MQTTKit) - 适用于 iOS 的 MQTT Objective-C 客户端.
* [mqtt_monitor](https://github.com/filipsPL/mqtt-monitor) - 用于 mqtt 主题的简单轻量级控制台监视器，带有 python 3 中的眼睛糖果.
* [Paho](http://www.eclipse.org/paho/) - Open source client implementations (C/C++, Java, Python, Javascript, Go, C#).
* [pubsubclient](https://github.com/knolleary/pubsubclient) - 为 MQTT 提供支持的 Arduino Ethernet Shield 的客户端库.
* [ruby-mqtt](https://github.com/njh/ruby-mqtt) - 实现 MQTT 协议的纯 Ruby gem.
* [rumqtt](https://github.com/AtherEnergy/rumqtt) - 一个快速、无锁的纯 Rust MQTT 客户端.
* [tcl-mqtt](https://github.com/Tingenek/tcl-mqtt)  - 用于连接到 MQTT 代理的小型库. 非常非常基本.
* [TMQTTClient](https://github.com/jamiei/Delphi-TMQTT2) - Delphi 的 MQTT 客户端库.
* [Vert.x MQTT](https://github.com/vert-x3/vertx-mqtt) - Vert.x 组件，提供连接/断开代理、发布消息和订阅主题的方法.
* [wolfMQTT](https://www.wolfssl.com/products/wolfmqtt/)  - 用 C 语言编写的 MQTT 客户端实现，供嵌入式使用. 它通过 wolfSSL 库支持 SSL/TLS.
* [MQTTnet](https://github.com/chkr1011/MQTTnet) - .NET 中的 MQTT 客户端和代理实现.

### Scripting

* [logic4mqtt](https://github.com/owagner/logic4mqtt)  - 基于 Java 的逻辑和脚本引擎，用于 MQTT. 使用 Java 的通用脚本接口，因此可以使用多种语言（如 Javascript、Groovy 等）编写脚本.
* [mqtt-scripts](https://github.com/hobbyquaker/mqtt-scripts/) - Node.js based script runner.
* [Node-RED](https://nodered.org/) - 连接物联网的可视化工具.


### Interfaces


#### Makers

* [arduinoTemps2mqtt](https://github.com/matbor/arduinoTemps2mqtt) - Arduino 草图，获取单线温度并发布到 MQTT 代理.
* [Basecamp](https://github.com/ct-Open-Source/Basecamp)  - 一个 Arduino 库，用于简化 ESP32 在物联网项目中的使用. 看 [c't Magazin 2'2018 (German)](https://www.heise.de/select/ct/2018/2/1515452111258448).
* [deskmate](https://github.com/rbaron/deskmate) - 可破解和便携式 MQTT 驱动的迷你仪表板和控制中心.
* [MySensors](https://www.mysensors.org/) - 基于 Arduino NRF24L01 的传感器网络，支持 MQTT 网关
* [pubsubclient](https://github.com/knolleary/pubsubclient) - 为 MQTT 提供支持的 Arduino Ethernet Shield 的客户端库.
* [RFM69-MQTT-client](https://github.com/computourist/RFM69-MQTT-client) - 基于 Arduino RFM69 的传感器和 MQTT 网关.
* [rpi2mqtt](https://github.com/hobbyquaker/rpi2mqtt) - 将 RaspberryPis GPIO 和 1-Wire 温度传感器连接到 MQTT.
* [xbee2mqtt](https://github.com/xoseperez/xbee2mqtt) - XBee 到 MQTT 网关.

##### ESP

* [ESP32-BLE2MQTT](https://github.com/shmuelzon/esp32-ble2mqtt) - BLE 到 MQTT 桥，将 BLE GATT 特性公开为双向通信的 MQTT 主题.
* [ESP8266MQTTMesh](https://github.com/PhracturedBlue/ESP8266MQTTMesh) - 用于 ESP8266 的 MQTT over mesh WiFi 集成库
* [esp_mqtt](https://github.com/tuanpmt/esp_mqtt) - ESP8266 的 MQTT 客户端库.
* [mqtt-ir-transceiver](https://github.com/piotrC4/mqtt-ir-transceiver)  - MQTT 和 IR 之间基于 ESP8266 的双向网关. 与 PlatformIO 一起使用.
* [mqtt-with-micropython](https://docs.pycom.io/tutorials/networkprotocols/mqtt/) - 使用 micropython 和 wipy/others（内置 ESP32）连接到 MQTT
* [nodemcu-gpiomqtt](https://github.com/hobbyquaker/nodemcu-gpiomqtt) - 将 ESP8266 GPIO 连接到 MQTT 的 Lua 脚本.


##### Firmwares for ESP based Devices 

有许多基于廉价 ESP8266 芯片的廉价智能家居 Wi-Fi 设备 _（参见： [1](https://templates.blakadder.com/index.html), [2](https://github.com/xoseperez/espurna#supported-hardware), [3](https://www.letscontrolit.com/wiki/index.php?title=ESP_Hardware) )_. 它们中的大多数都可以使用自定义固件进行刷新.
以下是将它们变成 MQTT 控制的智能家居节点的完整固件：

* [ESPEasy](https://www.letscontrolit.com/wiki/index.php?title=ESPEasy)  - 将 ESP 转变为具有基于 Web 配置的<abbr title="家庭自动化">HA</abbr>解决方案的多功能传感器设备.
* [ESPHome](https://esphome.io/) - 从简明的 YAML 描述构建 ESP8266/ESP32 固件，上传和管理闪存设备.
* [Espurna](https://github.com/xoseperez/espurna)  - 用于基于 ESP8266 的设备的<abbr title="家庭自动化">HA</abbr>固件，具有丰富的 Web UI 和 ≈120 个开箱即用的设备支持
* [OpenMQTTGateway](https://github.com/1technophile/OpenMQTTGateway) - 用于 ESP8266、ESP32、Sonoff RF Bridge 或 Arduino 的 MQTT 网关，具有双向 433mhz/315mhz/868mhz、红外通信、BLE、信标检测、mi flora、mi jia、LYWSD02、LYWSD03MMC、Mi Scale 兼容性、SMS 和 LORA.
* [Sonoff-Tasmota](https://github.com/arendst/Tasmota)  - 具有基于网络配置的 ESP8266 设备的固件. 支持≈500 个设备（不仅是 Sonoffs）.
* [WiFi-IoT](https://wifi-iot.com/p/wiki/)  - ESP8266/ESP32 固件生成器. 部分俄语. 免费功能有限.


#### Industry

* [CODESYS-MQTT](https://github.com/stefandreyer/CODESYS-MQTT) - CODESYS PLC 的 MQTT 客户端
* [spicierModbus2mqtt](https://github.com/mbs38/spicierModbus2mqtt) - 通过 MQTT 发布寄存器值的 Modbus 主站.
* [mqtt2opcua](https://github.com/nzfarmer1/mqtt2opcua) - 双向 MQTT 到 OPCUA 桥.
* [OPC Router](https://www.opc-router.com/4_1-mqtt-client-opc-router-plug-in-en/) - 具有各种插件（OPC UA Bridge、SQL Bridge、REST Bridge、SAP Bridge）的 MQTT 网关（发布者/订阅者）

#### Telephony, PBX

* [agi-mqtt](https://github.com/zeha/agi-mqtt) - 星号和 MQTT 之间的接口.
* [fritz2mqtt](https://github.com/akentner/fritz2mqtt) - 将 FRITZ!Box 连接到 MQTT.
* [sip2mqtt](https://github.com/MartyTremblay/sip2mqtt) - 一个 SIP 监控脚本，用于将带有 CallerID 的来电发布到 MQTT.
* [sms2mqtt](https://github.com/Domochip/sms2mqtt) - Docker Gateway 使用 USB GSM dongle (gammu) 通过 MQTT 发送/接收 SMS.


#### Operating System

* [mqtt-os-status](https://github.com/oskarhagberg/mqtt-os-status) - 操作系统相关数据，以固定时间间隔发布到 MQTT 代理.
* [mqttlauncher](https://github.com/jpmens/mqtt-launcher) - 执行由已发布的 MQTT 消息触发的 shell 命令.
* [mqttpc](https://github.com/hobbyquaker/mqttpc)  - 通过 MQTT 控制流程. 能够通过 MQTT 发送信号并发布 stdout/stderr 或将 MQTT 有效负载通过管道传输到 stdin.
* [psmqtt](https://github.com/eschava/psmqtt) - 通过 MQTT 实用程序报告系统运行状况和状态.
* [WinThing](https://github.com/msiedlarek/winthing) - 通过 MQTT 远程控制 Windows.


#### Monitoring

* [check-mqtt](https://github.com/jpmens/check-mqtt) - 用于检查与 MQTT 代理的连接的 Nagios/Icinga 插件.
* [nag2mqtt](https://github.com/DE-IBH/nag2mqtt) - Nagios 事件代理到 MQTT 网关.
* [notify-by-mqtt](https://github.com/jpmens/notify-by-mqtt) - 一个 Nagios/Icinga 通知模块，它将数据包装到 JSON 中并将其发送到 MQTT 代理.
* [mqtt2notifysend](https://github.com/David-Lor/MQTT2NotifySend) - 订阅主题并在 Ubuntu 和其他通知发送兼容的 Linux 发行版上显示来自 MQTT 消息的通知.


#### Location tracking

* [OwnTracks](https://owntracks.org/) - MQTT 的位置跟踪和地理围栏.


#### Logging

* [graylog-plugin-mqtt](https://github.com/graylog-labs/graylog-plugin-mqtt) - Graylog 的 MQTT 输入插件.
* [influx4mqtt](https://github.com/hobbyquaker/influx4mqtt) - 订阅 MQTT 主题并插入 InfluxDB.
* [mqtt2elasticsearch](https://github.com/hobbyquaker/mqtt2elasticsearch) - 将 MQTT 消息发送到 Elasticsearch.
* [mqtt2graphite](https://github.com/jpmens/mqtt2graphite)  - 存档！ 而是使用 [mqttwarn](https://github.com/jpmens/mqttwarn) 和 [carbon](https://github.com/jpmens/mqttwarn/blob/master/HANDBOOK.md#carbon) 插入.
* [mqttcollect](https://github.com/jpmens/mqttcollect) - 为 MQTT 收集的“Exec”插件.
* [mqtthandler](https://github.com/changyuheng/MQTTHandler) - 用于 MQTT 的 Python 日志记录处理程序模块.
* [mqtt2mongodb](https://github.com/David-Lor/MQTT2MongoDB) - 订阅 MQTT 主题并插入 MongoDB.
* [mqtt-firebase](https://www.npmjs.com/package/mqtt-firebase) - 用于订阅 MQTT 主题并将它们转储到 firebase firestore 数据库的 CLI 工具.


#### Smart Home Hardware Interfaces

* [aqara-mqtt](https://github.com/monster1025/aqara-mqtt) - Aqara（小米）网关到 MQTT 桥.
* [aqara2mqtt](https://github.com/hobbyquaker/aqara2mqtt) - 附 [Aqara](http://www.aqara.com.cn/us/index.html) 智能集线器到 MQTT.
* [can2mqtt](https://github.com/c3re/can2mqtt) - CAN 总线 - MQTT 桥（反之亦然）.
* [cul2mqtt](https://github.com/hobbyquaker/cul2mqtt) - 之间的接口 [Busware CUL](http://shop.busware.de/product_info.php/cPath/1/products_id/29) （868MHz 射频设备，如 ELV FS20、HMS、EM 等）和 MQTT.
* [domiqtt](https://github.com/etobi/domiqtt) - 连接到 Domiq Base (LCN) 并与 MQTT 相互转换.
* [eno2mqtt](https://github.com/owagner/eno2mqtt) - Enocean USB300 (TCM310) 适配器和 MQTT 之间的接口.
* [Evohome2mqtt](https://github.com/svrooij/evohome2mqtt) - 霍尼韦尔 Evohome 系统的 MQTT 接口.
* [gardena2mqtt](https://github.com/Domochip/gardena2mqtt) - Docker Gateway 通过 MQTT 控制 GARDENA Smart 系统设备（Sileno 割草机、灌溉控制等）.
* [helios2mqtt](https://github.com/mreschka/helios2mqtt) - 用于将像我的 KWL EC 220D 这样的 helios easy controls 系统同步到 MQTT 的守护进程.
* [hm2mqtt.js](https://github.com/hobbyquaker/hm2mqtt.js)  - EQ-3 的 Homematic 系列智能家居设备与 MQTT 之间的接口. 支持Homematic IP.
* [homeeToMqtt](https://github.com/odig/homeeToMqtt) - homee 和 MQTT 之间的双向接口.
* [HS100toMQTT](https://github.com/dersimn/HS100toMQTT) - TPLink HS100/HS110 和 MQTT 之间的网关.
* [ipcam2mqtt](https://github.com/svrooij/ipcam2mqtt) - 一个小型 FTP 服务器，用于从 ipcameras 接收运动图像并将其转换为 MQTT 警报.
* [knx-mqtt-bridge](https://github.com/pakerfeldt/knx-mqtt-bridge) - 使用 knx.js 库加强 KNX 和 MQTT.
* [knx2mqtt](https://github.com/owagner/knx2mqtt) - KNX 家庭自动化标准和 MQTT 之间的接口.
* [mcsMQTT](https://shop.homeseer.com/products/mcsmqtt-software-plug-in-for-hs3) - HS3 (HomeSeer) 插件.
* [mqtt-dss-bridge](https://github.com/cgHome/mqtt-dss-bridge) - MQTT digitalSTROM-服务器桥.
* [mqtt-unifi-protect-bridge](https://github.com/terafin/mqtt-unifi-protect-bridge) - 将来自 UniFi Protect 相机的运动状态添加到 MQTT.
* [mqtt2homekit](https://github.com/forty2/mqtt2homekit) - 大致相反 [homekit2mqtt](https://github.com/hobbyquaker/homekit2mqtt)：使用 MQTT 控制支持 HomeKit 的设备，无需 Siri 或 iPhone.
* [node-lox-mqtt-gateway](https://github.com/alladdin/node-lox-mqtt-gateway) - Loxone™ 迷你服务器与 MQTT 代理通信的网关.
* [smartthings-mqtt-bridge](https://github.com/stjohnjohnson/smartthings-mqtt-bridge) - 之间的桥梁 [SmartThings](https://www.smartthings.com/) 和 MQTT.
* [xiaomi2mqtt](https://github.com/svrooij/node-xiaomi2mqtt) - 小米智能家居网关 Aquara 和 MQTT 服务器之间的桥梁.
* [zigbee2mqtt](https://github.com/Koenkk/zigbee2mqtt) - 允许您在没有供应商（小米/TRADFRI/Hue）网桥/网关的情况下使用您的 Zigbee 设备.
* [zwavejs2mqtt](https://github.com/zwave-js/zwavejs2mqtt) - Zwave 到 Mqtt 网关和控制面板 Web UI.


#### Smart Home Integration Software

* [control-freak](https://github.com/catx23/control-freak)  - 用于物联网和朋友的 IDE. 内置 MQTT 支持.
* [Domoticz](https://www.domoticz.com/) - Domoticz 测试版支持 MQTT.
* [FHEM](http://fhem.de/fhem.html) 有一个 [MQTT module](http://fhem.de/commandref.html#MQTT) 从 V5.6 开始.
* [Home Assistant](https://www.home-assistant.io/) 有一个 MQTT 组件.
* [Home.Pi](https://github.com/denschu/home.pi) 基于 MQTT.
* [Homegear](https://homegear.eu/index.php/Main_Page) 内置 MQTT 支持.
* [homekit2mqtt](https://github.com/hobbyquaker/homekit2mqtt) - 之间的接口 [HAP-NodeJS](https://github.com/homebridge/HAP-NodeJS) 和 MQTT. 使用 Siri 或 HomeKit 应用程序控制 MQTT 连接的设备.
* [ioBroker](https://github.com/ioBroker) 有一个 [MQTT adapter](https://github.com/ioBroker/ioBroker.mqtt).
* [Node-RED](https://nodered.org/) - 连接物联网的可视化工具，具有原生 MQTT 支持.
* [openHAB](https://github.com/openhab) 有一个 [MQTT binding](https://github.com/openhab/openhab1-addons/wiki/MQTT-Binding).
* [pimatic](https://pimatic.org/) 有一个 MQTT 插件.


#### Lighting

* [Arilux_AL-LC0X](https://github.com/mertenats/Arilux_AL-LC0X) - 这是使用 MQTT 的 Arilux LED 控制器的替代固件.
* [chromoflex2mqtt](https://github.com/owagner/chromoflex2mqtt) - 通过 MQTT 控制 Chromoflex USP3 RGB LED 模块.
* [h801/mqtt](https://github.com/open-homeautomation/h801/tree/master/mqtt) - 使用 MQTT 作为控制通道的 H801 LED 调光器的替代固件.
* [hue2mqtt.js](https://github.com/hobbyquaker/hue2mqtt.js) - Philips Hue 桥和 MQTT 之间的接口.
* [MQTT DMX Controller](https://github.com/hobbyquaker/mqtt-dmx-controller) - 支持 MQTT 的 DMX 控制器.
* [mqtt-dmx-sequencer](https://github.com/hobbyquaker/mqtt-dmx-sequencer) - 无头对应 [MQTT DMX Controller](https://github.com/hobbyquaker/mqtt-dmx-sequencer) - 使用从 MQTT DMX 控制器导出的场景和序列，并通过 MQTT 控制它们.
* [sunricher-wifi-mqtt](https://github.com/magcode/sunricher-wifi-mqtt) - 使用 MQTT 控制 Sunricher LED 设备.
* [TRADFRI2MQTT](https://github.com/hardillb/TRADFRI2MQTT) - 适用于 IKEA TRÅDFRI Light Gateway 的 MQTT Bridge.


#### Home Entertainment

* [airtunes2mqtt](https://github.com/hobbyquaker/airtunes2mqtt) - MQTT 通过 Airplay/Airtunes 设备控制多房间音频.
* [bravia2mqtt](https://github.com/forty2/bravia2mqtt) - 使用 MQTT 控制您的 Sony Bravia 电视.
* [broadlink-mqtt](https://github.com/eschava/broadlink-mqtt) - 用于控制 BroadLink RM 设备的 MQTT 客户端.
* [chromecast-mqtt-connector](https://github.com/nohum/chromecast-mqtt-connector) - 使用 MQTT 控制您的 Google Chromecast 设备.
* [harmony-api](https://github.com/maddox/harmony-api) - 一个简单的服务器，允许您通过 HTTP 或 MQTT 查询/控制多个本地 Harmony Home Hub.
* [htd2mqtt](https://github.com/TheOriginalAndrobot/htd2mqtt) - HTD Lync 音频系统和 MQTT 之间的桥梁.
* [kodi2mqtt](https://github.com/owagner/kodi2mqtt) - Kodi 媒体中心实例和 MQTT 之间的接口.
* [lgtv2mqtt](https://github.com/hobbyquaker/lgtv2mqtt) - LG WebOS 智能电视和 MQTT 之间的接口.
* [lirc2mqtt](https://github.com/hobbyquaker/lirc2mqtt) - 通过红外发送和接收 [LIRC](https://github.com/hobbyquaker/awesome-mqtt/blob/master/www.lirc.org).
* [mopidy-mqtt](https://github.com/magcode/mopidy-mqtt) - Mopidy 的 MQTT 功能.
* [MQTT-DashCast-Docker](https://github.com/mukowman/MQTT-DashCast-Docker) - MQTT Docker 在 Chromecast 上启动 DashCast 会话.
* [mqtt2atlonamatrix](https://github.com/forty2/mqtt2atlonamatrix) - 使用 MQTT 控制 Atlona HDMI 矩阵开关.
* [mqtt2tivoremote](https://github.com/forty2/mqtt2tivoremote) - 通过 MQTT smarthome 风格的界面使 TiVo DVR 远程控制可用.
* [onkyo2mqtt](https://github.com/owagner/onkyo2mqtt) - Interface between Onkyo AVR's EISCP network remote protocol and MQTT. Uses the onkyo-eiscp library.
* [sonos2mqtt](https://github.com/svrooij/sonos2mqtt) - Sonos 和 MQTT 之间的桥梁.
* [VLC MQTT Module](https://wiki.videolan.org/Documentation:Modules/mqtt/) - 通过 MQTT 控制 VLC.
* [xbmc2mqtt](https://github.com/gordonjcp/xbmc-mqtt) - XBMC 的一个简单插件，用于侦听 MQTT 代理上的特定主题，并显示弹出消息.
* [yamaha-avr2mqtt](https://github.com/akentner/yamaha-avr2mqtt) - 用于将 Yamaha AVR 连接到 MQTT 的简单适配器.


#### Smart Metering

* [bcontrol2mqtt](https://github.com/hobbyquaker/bcontrol2mqtt) - 从 TQ Energy Manager 发布测量值 / [Busch-Jäger Energy Monitor](https://www.busch-jaeger.de/files/files_ONLINE/Brosch%c3%bcre_EnergyMonitor_druck.pdf) 到 MQTT.


#### Messaging

* [mqtt-irc-bot](https://github.com/dobermai/mqtt-irc-bot) - MQTT 到 IRC / IRC 到 MQTT 桥接器或机器人.
* [mqttwarn](https://github.com/jpmens/mqttwarn) - 订阅 MQTT 主题（带通配符）并通知可插入服务.
* [twitter-to-mqtt](https://github.com/knolleary/twitter-to-mqtt) - 使用 Twitter Streaming API 访问推文并将其重新发布到 MQTT 主题的 python 守护程序.


#### Misc

* [AlexaMqttBridge](https://github.com/mhdawson/AlexaMqttBridge) - Amazon Alexa 和 MQTT 之间的桥梁.
* [bt-mqtt-gateway](https://github.com/zewelor/bt-mqtt-gateway) - 易于扩展的蓝牙到 MQTT 网关，目前支持：EQ3 智能恒温器、小米体重秤、Linak Desk、MySensors 和小米 Flora 植物传感器.
* [buderus2mqtt](https://github.com/krambox/buderus2mqtt) - Buderus KM200 互联网网关和 MQTT 之间的桥梁.
* [chrome2mqtt](https://github.com/tbowmo/chrome2mqtt) - 为 chromecast（音频和视频）启用 MQTT 控制端点的 Python 程序.
* [dashbutton2mqtt](https://github.com/hobbyquaker/dashbutton2mqtt) - 将 Amazon Dash 按钮按下发布到 MQTT.
* [flowerpower2mqtt](https://github.com/hobbyquaker/flowerpower2mqtt) - 将 Parrot Flower 发电厂传感器的测量结果发布到 MQTT.
* [gBridge](https://github.com/kservices/gBridge)  - gBridge 允许您使用 Google Assistant 控制（几乎）任何智能家居设备、任何智能家居软件. 因此，它将通过语音命令从 Google 接收到的操作转换为 MQTT 消息.
* [haiku2mqtt](https://github.com/forty2/haiku2mqtt) - Haiku 智能粉丝与 MQTT 之间的桥梁.
* [homely](https://github.com/baol/homely) - 用于连接 Domoticz 和其他东西的 Go 守护程序集合.
* [kobold2mqtt](https://github.com/krambox/kobold2mqtt) - Vorwerk Kobold Vr200 互联网网关和 MQTT 之间的桥梁.
* [leaf-python-mqtt](https://github.com/glynhudson/leaf-python-mqtt) - 从 Nissan Leaf API 提取数据并发布到 MQTT.
* [miflora-mqtt-daemon](https://github.com/ThomDietrich/miflora-mqtt-daemon) - 将小米 Mi Flora 植物传感器数据发送到 MQTT 代理的 Linux 服务.
* [MQTT.Cool](https://mqtt.cool) - 一个 Web 网关，可在将实时数据发送到具有自动节流功能的 Web 客户端时优化任何 MQTT 代理.
* [mqtt2ble](https://github.com/hardillb/mqtt2ble) - 一种将 MQTT 主题与 BLE Gatt 特性联系起来的方法.
* [mqttclpro](https://github.com/dc297/mqttclpro) - 带有 Tasker 集成 Android 应用程序的 MQTT 客户端.
* [mqttDB](https://github.com/hobbyquaker/mqttDB) - 带有 MQTT 接口的 JSON 存储.
* [mqtt-camera-streamer](https://github.com/robmarkcole/mqtt-camera-streamer) - 通过 MQTT 从连接的相机流式传输图像并使用 Streamlit 查看
* [MQTT Joystick Controller](https://github.com/Vincenzo-Petrolo/MQTT-Joystick-Controller)  - 开源 Android 应用程序，可让您使用智能手机控制一切. 从谷歌播放下载它.
* [mqtt-transformer](https://github.com/tg44/mqtt-transformer) - 在 MQTT 上消费、转换和定期重新发布 json 消息的简单服务.
* [node-mqtt-for-anki-overdrive](https://github.com/IBM-Cloud/node-mqtt-for-anki-overdrive) - 用于 Anki Overdrive 的 Node.js 控制器和 MQTT API.
* [parrot-sample](https://github.com/IBM-Cloud/parrot-sample) - 使用 MQTT 控制 Parrot AR 无人机的示例代码.
* [serial2mqtt](https://github.com/vortex314/serial2mqtt) - 一个 Linux 网关，用于将仅具有串行端口的低成本微控制器连接到 MQTT.
* [snowboy2mqtt](https://github.com/hobbyquaker/snowboy2mqtt) - 在 Snowboy 热词检测上发布 MQTT 消息.
* [speedtest2mqtt](https://github.com/hobbyquaker/speedtest2mqtt) - 运行 speedtest-cli 并通过 MQTT 发布结果.
* [unifi2mqtt](https://github.com/hobbyquaker/unifi2mqtt) - 将连接的客户端从 Ubiquiti Unifi 发布到 MQTT.
* [Valetudo](https://github.com/Hypfer/Valetudo) - 带有 MQTT 和 Web 界面的小米 (Roborock) 真空机器人固件.
* [wlan-thermo-mqtt-addon](https://bitbucket.org/IOcastor/wlan-thermo-mqtt-addon/) - 流行的 DIY 烧烤温度计插件.
* Tasker（安卓自动化） [MQTT Publisher Plugin](https://play.google.com/store/apps/details?id=net.nosybore.mqttpublishplugin).
* [MQTT2ETCD](https://github.com/David-Lor/MQTT2ETCD) - MQTT-ETCD 网关：通过 MQTT 在 ETCD 上放置密钥，并在 MQTT 主题上观看 ETCD 密钥变化


### Visualization, Dashboards

* [Crouton](https://github.com/edfungus/Crouton) - 仅使用 MQTT 和 JSON 接入物联网网络的仪表板.
* [d3-MQTT-Topic-Tree](https://github.com/hardillb/d3-MQTT-Topic-Tree) - 使用 d3 可折叠树和 MQTT over websockets 的 MQTT 主题树查看器.
* [HelloIoT](https://github.com/adrianromero/helloiot) - HelloIoT 是一个 MQTT 客户端和仪表板应用程序.
* [HOMR-REACT](https://github.com/klauserber/homr-react) - 可配置的 MQTT 可视化.
* [IoT OnOff](https://www.iot-onoff.com/) - 可配置的 iOS/Android 应用程序.
* [Linear MQTT Dashboard](https://github.com/ravendmaster/linear-mqtt-dashboard) - 简单、可定制的控制面板 - MQTT 客户端.
* [MMM-mqtt](https://github.com/javiergayala/MMM-mqtt)  - 这是 MagicMirror² 的扩展. 它提供订阅 MQTT 主题并显示它们的能力.
* [MQTT Dash](https://play.google.com/store/apps/details?id=net.routix.mqttdash&hl=de) - Android 应用程序：使用该应用程序，您可以为支持 MQTT 的物联网智能家居设备和应用程序创建仪表板.
* [MQTT-Hyperdash](https://github.com/kollokollo/MQTT-Hyperdash) - 用于 linux/Raspberry Pi 的通用独立 MQTT 仪表板.
* [MQTT.Cool Test Client](https://testclient-cloud.mqtt.cool) - 用于测试 MQTT.Cool 与任何 MQTT 代理之间交互的 Web 界面.
* [mqtt-panel](https://github.com/fabaff/mqtt-panel) - MQTT 的 Web 界面.
* [mqtt-prometheus-message-exporter](https://github.com/tg44/mqtt-prometheus-message-exporter) - 将 mqtt 消息转换为普罗米修斯指标的小型服务.
* [mqtt-svg-dash](https://github.com/jpmens/mqtt-svg-dash) - 订阅 MQTT，从消息中提取 JSON 并使 SVG 页面上的灯闪烁.
* [mqtt2highcharts](https://github.com/matbor/mqtt2highcharts) - 使用 Highcharts 从订阅的 MQTT 主题绘制实时编号数据.
* [MYHELLOIOT](https://adrianromero.github.io/myhelloiot/) - MYHELLOIOT 是一个 MQTT 仪表板应用程序，灵感来自我的另一个 MQTT 项目 HelloIoT.
* [node-red-dashboard](https://github.com/node-red/node-red-dashboard) - Node-RED 的仪表板 UI.
* [PlotJuggler](https://github.com/facontidavide/PlotJuggler)  - PlotJuggler是一个可视化时间序列的工具（来源如：MQTT、Websockets、ZeroMQ、UDP等，支持JSON、CBOR、BSON、Message Pack等数据格式）. 它是一种快速、强大且直观的跨平台工具.



可用于创建可视化/仪表板的其他工具可以在下面找到 [Platforms](#platforms) 和 [Smart Home Integration Software](#smart-home-integration-software).


### Architecture, Convention

* [mqtt-smarthome](https://github.com/mqtt-smarthome/mqtt-smarthome) - 以 MQTT 作为中央消息总线的智能家居自动化 - 架构方案.
* [The Homie Convention](https://github.com/homieiot/convention) - 用于物联网的轻量级 MQTT 约定.

### Security, Encryption

* [Teserakt E4](https://teserakt.io/) - MQTT 和其他 M2M 协议的端到端加密和密钥管理 – 开源和付费计划.


## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/hobbyquaker/awesome-mqtt/blob/master/contributing.md) 第一的.


## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)
