<div class="github-widget" data-repo="ramnes/awesome-mongodb"></div>
![Awesome MongoDB](https://raw.githubusercontent.com/ramnes/awesome-mongodb/master/logo.png)

## Awesome MongoDB [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[![Links check](https://github.com/ramnes/awesome-mongodb/actions/workflows/links.yml/badge.svg)](https://github.com/ramnes/awesome-mongodb/actions/workflows/links.yml)

> A curated list of awesome MongoDB resources, libraries, tools and applications

Inspired by the [awesome](https://github.com/sindresorhus/awesome) list thing. Feel free to improve this list by [contributing](https://github.com/ramnes/awesome-mongodb/blob/master/CONTRIBUTING.md)!


## Resources
### Documentation
 - [MongoDB Server Introduction](https://www.mongodb.com/docs/manual/introduction/)
 - [MongoDB Server Documentation](https://www.mongodb.com/docs/manual/)
 - [MongoDB Tutorials](https://www.mongodb.com/docs/manual/tutorial/)
 - [MongoDB Guides](https://www.mongodb.com/docs/guides/)
 - [MongoDB Developer Center](https://www.mongodb.com/developer/)
 - [MongoDB Driver Documentation](https://www.mongodb.com/docs/drivers/)
 - [MongoDB Connectors](https://www.mongodb.com/connectors/)

### Articles

 - [14 Things I Wish I'd Known When Starting with MongoDB (Phil Factor)](https://www.infoq.com/articles/Starting-With-MongoDB/)
 - [A Custom WordPress Dashboard with MongoDB Atlas, Microsoft Azure, & Serverless Functions (Ahmad Awais)](https://ahmadawais.com/wordpress-mongodb-atlas-microsoft-azure-serverless-functions/)
 - [Building with Patterns](https://www.mongodb.com/blog/post/building-with-patterns-a-summary) - Series of articles regarding MongoDB Design Patterns and common use case of each Design Pattern with real world examples.
 - [Five Things About Scaling MongoDB (A. Jesse Jiryu Davis, MongoDB Inc.)](https://emptysqua.re/blog/five-things/) - Scale 101
 - [Optimizing MongoDB Compound Indexes (A. Jesse Jiryu Davis, MongoDB Inc.)](https://emptysqua.re/blog/optimizing-mongodb-compound-indexes/) - Everything you need/have to know about indexes
 - [Server Discovery And Monitoring In PyMongo, Perl, And C (A. Jesse Jiryu Davis, MongoDB Inc.) ](https://emptysqua.re/blog/server-discovery-and-monitoring-in-pymongo-perl-and-c/)
 - [Monitoring MongoDB performance metrics (Jean-Mathieu Saponaro, Datadog)](https://www.datadoghq.com/blog/monitoring-mongodb-performance-metrics-wiredtiger/)
 - [Tuning MongoDB performance for production systems (Marek Trunkat, Apify)](https://blog.apify.com/tuning-mongodb-performance/) - The techniques and MongoDB Cloud features to debug performance issues and expose sub-optimal queries

### Books
 - [50 Tips and Tricks for MongoDB Developers](https://www.oreilly.com/library/view/50-tips-and/9781449306779/) - Advanced MongoDB tips and tricks, given by a MongoDB inc. engineer
 - [Builder Book](https://builderbook.org) - Learn how to build a full stack JavaScript web app from scratch
 - [MongoDB Applied Design Patterns (Rick Copeland)](https://www.oreilly.com/library/view/mongodb-applied-design/9781449340056/)
 - [Practical MongoDB Aggregations E-Book](https://www.practical-mongodb-aggregations.com/) - Free e-book: How to develop effective and optimal data manipulation and analytics pipelines
 - [The Little MongoDB Book](https://github.com/mongodb-developer/the-little-mongodb-book) - Basic introduction
 - [SaaS Boilerplate Book](https://builderbook.org/book) - Learn how to build a production-ready SaaS web app from scratch

### Talks
 - [MongoDB Schema Design (Tugdual Grall, MongoDB Inc.)](https://www.youtube.com/watch?v=csKBT8zkRf0) [47']
 - [Partial and Fuzzy Matching with MongoDB (John Page, MongoDB Inc.)](https://www.youtube.com/watch?v=hXbLHInH5qU) [35']
 - [Scaling MongoDB on Amazon Web Services (Michael Saffitz, Apptentive)](https://www.youtube.com/watch?v=bkjVhEQocFI) [50']

### Tutorials
 - [Kubernetes examples](https://github.com/kubernetes/examples/tree/master/staging/nodesjs-mongodb) - Deployment tutorial of a basic Node.js and MongoDB web stack on Kubernetes
 - [Deploy a Highly-Available MongoDB Replica Set on AWS](https://eladnava.com/deploy-a-highly-available-mongodb-replica-set-on-aws/)
 - [Sharded Cluster with Docker Compose](https://github.com/minhhungit/mongodb-cluster-docker-compose)

### More
 - [MongoDB source code](https://github.com/mongodb/mongo)
 - [MongoDB University](https://learn.mongodb.com/) - Certifications and free online courses
 - [MongoDB 101 by Academy 3T](https://studio3t.com/academy/) - Free and self-paced MongoDB courses for beginners

## Libraries

### Ballerina
 - [ballerina-mongodb](https://github.com/ballerina-platform/module-ballerinax-mongodb) - Official Ballerina driver

### C
 - [mongo-c-driver](https://github.com/mongodb/mongo-c-driver) - Official C driver

### C++
 - [mongo-cxx-driver](https://github.com/mongodb/mongo-cxx-driver) - Official C++ driver

### C#/.NET ###
 - [mongo-csharp-driver](https://github.com/mongodb/mongo-csharp-driver) - Official C# driver
 - [mongo-efcore-provider](https://github.com/mongodb/mongo-efcore-provider) - Official Entity Framework (EF) Core provider for MongoDB
 - [mongo-queue-csharp](https://github.com/dominionenterprises/mongo-queue-csharp) - C# message queue on top of MongoDB
 - [MongoDB Messaging](https://github.com/loresoft/MongoDB.Messaging) - Lightweight queue pub/sub processing library
 - [MongoRepository](https://github.com/RobThree/MongoRepository) - Repository abstraction layer on top of the C# driver

### D
 - [vibe.d](https://vibed.org/docs#mongo) - D web framework shipping with a MongoDB driver

### Dart
 - [mongo_dart](https://github.com/mongo-dart/mongo_dart) - Community Dart driver

### Delphi
 - [Alcinoe](https://github.com/MagicFoundation/Alcinoe) - Library for Delphi that includes a MongoDB client
 - [TMongoWire](https://github.com/stijnsanders/TMongoWire) - Minimal community Delphi driver

### Elixir
 - [elixir-mongodb-driver](https://github.com/zookzook/elixir-mongodb-driver) - Community Elixir driver
 - [mongodb](https://github.com/kobil-systems/mongodb) - Community Elixir driver
 - [mongodb_ecto](https://github.com/kobil-systems/mongodb_ecto) - Adapter for the Ecto database wrapper

### Erlang
 - [mongodb-erlang](https://github.com/comtihon/mongodb-erlang) - Community Erlang driver

### Fantom
 - [afMongo](https://github.com/Fantom-Factory/afMongo) - Community Fantom driver

### Go
 - [Bongo](https://github.com/go-bongo/bongo) - ODM based on mgo
 - [mgo](https://github.com/globalsign/mgo) - Community Go driver
 - [minquery](https://github.com/icza/minquery) - MongoDB cursor that paginates
 - [mongo-go-driver](https://github.com/mongodb/mongo-go-driver) - Official Go driver

### Haskell
 - [mongodb](https://github.com/mongodb-haskell/mongodb/) - Community Haskell driver

### Java
 - [Jongo](https://github.com/bguerout/jongo) - Query in Java as in Mongo shell
 - [Hibernate OGM](https://github.com/hibernate/hibernate-ogm) - The power and simplicity of JPA for NoSQL datastores
 - [mongo-java-driver](https://github.com/mongodb/mongo-java-driver) - Official Java driver
 - [mongo-queue-java](https://github.com/yonderblue/mongo-queue-java) - Java message queue on top of MongoDB
 - [mongoFS](https://github.com/dbuschman7/mongoFS) - An enhancement of GridFS to allow for more features and capabilities
 - [Mongojack](https://github.com/mongojack/mongojack) - Based on Jackson, allows you to easily handle your mongo objects as POJOs
 - [Morphia](https://github.com/MorphiaOrg/morphia) - Java ODM
 - [Morphium](https://github.com/sboesebeck/morphium) - Java ODM and caching layer
 - [Mungbean](https://github.com/jannehietamaki/mungbean) - Community driver for languages running on the JVM
 - [Spring Data MongoDB](https://github.com/spring-projects/spring-data-mongodb) - Spring based, object-document support and repositories

### JavaScript
 - [Camo](https://github.com/scottwrobinson/camo) - Class-based ES6 ODM for Mongo-like databases
 - [deno_mongo](https://github.com/denodrivers/mongo) - Community Deno driver
 - [DeriveJS](https://github.com/yuval-a/derivejs) - Reactive ODM that uses Javascript Proxies to enable transparent DB persistence
 - [MEAN.JS](https://github.com/meanjs/mean) - Full stack based on MongoDB, Express, AngularJS, and Node.js
 - [MERN (mern-starter)](https://github.com/Hashnode/mern-starter) - Full stack based on MongoDB, Express, React and Node.js
 - [Meteor](https://github.com/meteor/meteor) - Real-time/reactive client-server framework based on MongoDB, with lots of features
 - [Mongoose](https://github.com/Automattic/mongoose) - Node.js asynchronous ODM
 - [CASL Mongoose](https://github.com/stalniy/casl/tree/master/packages/casl-mongoose) - Permissions management library integrated with Mongoose
 - [mongration](https://github.com/awapps/mongration) - Node.js migration framework
 - [Moonridge](https://github.com/capaj/Moonridge) - Framework with live querying on top of Mongoose and socket.io
 - [Neuledge](https://github.com/neuledge/engine-js) - Universal schema-based ORM with multi-state representation for entities
 - [node-mongodb-native](https://github.com/mongodb/node-mongodb-native) - Official Node.js driver

### Julia
 - [Mongo.jl](https://github.com/Lytol/Mongo.jl) - C driver bindings

### Kotlin
- [driver-kotlin-coroutine](https://github.com/mongodb/mongo-java-driver/tree/master/driver-kotlin-coroutine) - Official Kotlin driver
- [kmongo](https://github.com/Litote/kmongo) - Kotlin toolkit based on the Java driver

### Lisp
 - [cl-mongo](https://github.com/fons/cl-mongo) - Community Common Lisp interface
 - [mongo-cl-driver](https://github.com/archimag/mongo-cl-driver) Community Common Lisp driver
 - [mongo-el](https://github.com/emacsorphanage/mongo) - Community Emacs Lisp driver

### Mathematica
 - [MongoDBLink](https://github.com/zbjornson/MongoDBLink) - Community Mathematica driver

### OCaml
 - [Mongo.ml](http://massd.github.io/mongo/) - Community OCaml driver

### PHP
 - [laravel-mongodb](https://github.com/mongodb/laravel-mongodb) - Official Eloquent model and query builder for Laravel
 - [PHP Driver](https://github.com/mongodb/mongo-php-driver) - Official PHP driver
 - [Doctrine MongoDB ODM](https://github.com/doctrine/mongodb-odm) and [MongoDB ODM Bundle for Symfony](https://github.com/doctrine/DoctrineMongoDBBundle) - Fully featured ORM with Symfony integration
 - [MongoDB Bundle](https://github.com/facile-it/mongodb-bundle) - Integration of the official library with Symfony, without ORM
 - [yii-mongodb](https://github.com/yiisoft/yii2-mongodb) - Yii 2 MongoDB extension
 - [opentelemetry php auto-mongodb](https://github.com/opentelemetry-php/contrib-auto-mongodb) - Automatic monitoring of MongoDB commands with OpenTelemetry
 - [mongo-php-adapter](https://github.com/alcaeus/mongo-php-adapter) - Adapter for applications using `ext-mongo`

### PowerShell
 - [Mdbc](https://github.com/nightroman/Mdbc) - MongoDB cmdlets for PowerShell

### Python
 - [AtlasQ](https://github.com/certego/AtlasQ) - MongoDB Atlas Search wrapper with MongoEngine syntax
 - [Beanie](https://github.com/roman-right/beanie) - Asynchronous ODM based on [Motor](https://motor.readthedocs.io/en/stable/) and [Pydantic](https://pydantic-docs.helpmanual.io/), which supports migrations out of the box
 - [Djongo](https://github.com/nesdis/djongo) - MongoDB connector for Django compatible with Django ORM
 - [Flask-MongoEngine](https://github.com/MongoEngine/flask-mongoengine) - Flask extension that integrates MongoEngine, WTForms and FlaskDebugToolbar
 - [Flask-Stupe](https://github.com/numberly/flask-stupe) - Flask extension that adds PyMongo support to Flask
 - [Mongo-Thingy](https://github.com/numberly/mongo-thingy) - Powerful schema-less ODM for MongoDB and Python (sync + async)
 - [MongoEngine](https://github.com/MongoEngine/mongoengine) - ODM on top of PyMongo
 - [MongoLog](https://github.com/puentesarrin/mongodb-log) - MongoDB logging handler
 - [Motor](https://github.com/mongodb/motor) - Official non-blocking Python driver for Tornado or asyncio
 - [PyMongo](https://github.com/mongodb/mongo-python-driver) - Official Python driver
 - [PyMongoExplain](https://github.com/mongodb-labs/pymongoexplain/) - A wrapper for PyMongo's Collection object that makes it easy to run `explain` on your queries.
 - [minimongo](https://github.com/slacy/minimongo) - A lightweight, schemaless, Pythonic Object-Oriented interface
 - [ODMantic](https://github.com/art049/odmantic) - Asynchronous ODM on top of pydantic
 - [scrapy-mongodb](https://github.com/sebdah/scrapy-mongodb) - MongoDB pipeline for Scrapy
 - [TxMongo](https://github.com/twisted/txmongo) - Twisted's MongoDB driver
 - [μMongo](https://github.com/Scille/umongo) - Driver-independent (async/sync) ODM based on marshmallow

### R
 - [mongolite](https://github.com/jeroen/mongolite) - Fast and simple client for R

### Ruby
 - [awesome_explain](https://github.com/sandboxws/awesome_explain) - A simple global method to explain Mongoid queries
 - [mongo-ruby-driver](https://github.com/mongodb/mongo-ruby-driver) - Official Ruby driver
 - [Mongoid](https://github.com/mongodb/mongoid) - ODM framework

### Rust
 - [mongodb-rust-driver](https://github.com/mongodb/mongo-rust-driver) - Official Rust driver

### Scala
 - [driver-scala](https://github.com/mongodb/mongo-java-driver/tree/master/driver-scala) - Official Scala driver
 - [ReactiveMongo](https://github.com/ReactiveMongo/ReactiveMongo) - Non-blocking Scala driver
 - [Spark-MongoDB](https://github.com/Stratio/Spark-MongoDB) - Read/write data with Spark SQL

### Smalltalk
 - [MongoTalk](https://github.com/pharo-nosql/mongotalk) - Community Smalltalk driver

### Swift
 - [MongoKitten](https://github.com/orlandos-nl/MongoKitten) - Community asynchronous Swift driver

## Tools
### Administration
 - [k8s-backup-mongodb](https://github.com/tuladhar/k8s-backup-mongodb) - Schedule MongoDB backups to S3 with a Kubernetes CronJob.
 - [mgob](https://github.com/stefanprodan/mgob) - Full-featured MongoDB dockerized backup agent
 - [mongoctl](https://github.com/mongolab/mongoctl) - Manage MongoDB servers and replica sets using JSON configurations
 - [MongoDB Smasher](https://github.com/duckie/mongo_smasher) - Generate randomized datasets and benchmark your setup
 - [mongodb-tools](https://github.com/jwilder/mongodb-tools) - Three neat Python scripts to work with collections and indexes
 - [mtools](https://github.com/rueckstiess/mtools) - Collection of scripts to set up test environments and visualize log files
 - [nginx-gridfs](https://github.com/mdirolf/nginx-gridfs) - Nginx module for serving files from GridFS
 - [nginx-mongodb-rest](https://github.com/minhajuddin/nginx-mongodb-rest) - REST client written as an Nginx module
 - [pt-mongodb-query-digest](https://www.percona.com/doc/percona-toolkit/LATEST/pt-mongodb-query-digest.html) - Aggregates queries from query profiler and reports query usage statistics
 - [pt-mongodb-summary](https://www.percona.com/doc/percona-toolkit/LATEST/pt-mongodb-summary.html) - MongoDB cluster status overview command line tool

Services:
 - [MongoDB Atlas](https://www.mongodb.com/cloud/atlas) - MongoDB Inc. DBaaS offer (works with AWS, Azure, or GCP)
 - [MongoDB Cloud Manager](https://www.mongodb.com/cloud/cloud-manager) - MongoDB Inc. databases management offer
 - [ObjectRocket](https://www.objectrocket.com/) - Rackspace DBaaS offer (has other database types too)
 - [Scalegrid](https://scalegrid.io) - Fully managed DBaaS (with option to bring your own Azure/AWS account)

### Data
 - [mongo-connector](https://github.com/yougov/mongo-connector) - Streaming replication to Elasticsearch, Solr, or MongoDB
 - [mongo_fdw](https://github.com/EnterpriseDB/mongo_fdw) - PostgreSQL foreign data wrapper
 - [mongo-hadoop](https://github.com/mongodb/mongo-hadoop) - Hadoop connector
 - [Mongolastic](https://github.com/ozlerhakan/mongolastic) - MongoDB to Elasticsearch (and vice-versa) migration tool
 - [MongoMultiMaster](https://github.com/rick446/mmm) - Multi-master replication

### Deployment
 - [ansible-role-mongodb](https://github.com/UnderGreen/ansible-role-mongodb) - Ansible role
 - [chef-mongodb](https://github.com/edelight/chef-mongodb) - Chef cookbook
 - [DockerHub Official Docker Image](https://hub.docker.com/_/mongo/)
 - [Helm Chart](https://github.com/helm/charts/tree/master/stable/mongodb)
 - [puppet-mongodb](https://github.com/voxpupuli/puppet-mongodb) - Puppet module (formerly puppetlabs-mongodb)

Services:
 - [Cluster to cluster sync](https://www.mongodb.com/products/cluster-to-cluster-sync) - MongoDB Inc. solution for continuous data sync between separate clusters

### Desktop
 - [Compass](https://github.com/mongodb-js/compass) - Free Cross-platform GUI from MongoDB
 - [MongoDB for VS Code](https://marketplace.visualstudio.com/items?itemName=mongodb.mongodb-vscode) - Connect to MongoDB and prototype queries from VS Code
 - [MongoHub](https://github.com/jeromelebel/MongoHub-Mac) - Mac native client
 - [WebDB](https://github.com/WebDB-App/app) – Web-based and open-source "efficient database IDE". Provides ERDs, data generators, an AI assistant, a NoSQL structure manager, a time machine, auto-completion and more

Services:
 - [DataGrip](https://www.jetbrains.com/datagrip/) - Cross-platform JetBrains' IDE
 - [Mingo](https://mingo.io/) - MongoDB Admin. Intuitive UI. Fast. Reliable
 - [Moon Modeler](http://www.datensen.com/) - Data modeling tool for MongoDB and relational databases
 - [NoSQLBooster](https://nosqlbooster.com) - Feature-rich but easy-to-use cross-platform IDE (formerly MongoBooster)
 - [Studio 3T](https://studio3t.com/) - Cross-platform GUI, stable and powerful (formerly MongoChef and Robo 3T)
 - [TablePlus](https://tableplus.com/) - Native, lightweight GUI on macOS

### Development
 - [C# Analyzer](https://github.com/mongodb/mongo-csharp-analyzer) - View the MongoDB Query API equivalents of your builder expressions in Visual Studio
 - [mgodatagen](https://github.com/feliixx/mgodatagen) - Random data generator
 - [migrate-mongo](https://github.com/seppevs/migrate-mongo) - Database migration tool
 - [Mongo Playground](https://github.com/feliixx/mongoplayground) - Online query playground
 - [Mongo Seeding](https://github.com/pkosiec/mongo-seeding) - Node.js library, CLI and Docker image for populating databases using JS and JSON files
 - [Mongoeye](https://github.com/mongoeye/mongoeye) - Schema and data analyzer: explore data in your collections
 - [Variety](https://github.com/variety/variety) - Schema analyzer: see what fields are in your collection and what's their content
 - [VS Code Extension](https://github.com/mongodb-js/vscode)

Services:
 - [MongoDB Atlas App Services](https://www.mongodb.com/atlas/app-services) - MongoDB Inc. solution to run code without the operational overhead
 - [MongoDB Realm](https://www.mongodb.com/realm) - MongoDB Inc. solution for mobile data sync

### Monitoring
 - [check_mongodb](https://github.com/dalenys/check_mongodb) - Nagios plugin (in Bash)
 - [mongo-monitor](https://github.com/dwmkerr/mongo-monitor) - Simple monitoring CLI
 - [mongo-munin](https://github.com/erh/mongo-munin) - Collection of Munin plugins
 - [Mongoop](https://github.com/Lujeni/mongoop) - Long operations monitoring and alerting
 - [mongomon](https://github.com/pcdummy/mongomon) - More Munin plugins
 - [Motop](https://github.com/tart/motop) - MongoDB top clone
 - [mtop](https://github.com/beaufour/mtop) - Another top clone
 - [nagios-plugin-mongodb](https://github.com/mzupan/nagios-plugin-mongodb) - Nagios plugin (in Python)
 - [Percona Monitoring and Management](https://www.percona.com/software/database-tools/percona-monitoring-and-management) - Free and open-source platform for managing and monitoring databases performances
 - [mongotail](https://github.com/mrsarm/mongotail) - Log all MongoDB queries in a "tail"able way

Services:

 - [Datadog](https://www.datadoghq.com/blog/monitor-mongodb-performance-with-datadog/) - SaaS-based monitoring
 - [Solarwindws Database Performance Monitor](https://www.solarwinds.com/database-performance-monitor) - SaaS-based query performance analytics and monitoring

### Low-Code

> 💡 These tools are not necessarily made for MongoDB in particular, but support it.

 - [Appsmith](https://github.com/appsmithorg/appsmith) - Open-source Retool alternative
 - [Appwrite](https://github.com/appwrite/appwrite) - Open-source Firebase alternative
 - [Budibase](https://github.com/Budibase/budibase) - Open-source Retool alternative
 - [ILLA Builder](https://github.com/illacloud/illa-builder) - Open-source Retool alternative
 - [Tooljet](https://github.com/ToolJet/ToolJet) - Open-source Retool alternative

Services:
- [DronaHQ](https://www.dronahq.com/) - Retool alternative
- [Retool](https://retool.com/) - Drag-and-drop editor with pre-built components to build internal tools

### Shell
 - [MongoDB Atlas CLI](https://github.com/mongodb/mongodb-atlas-cli) - Official Atlas API command-line client
 - [mongosh](https://github.com/mongodb-js/mongosh) - Official command-line client

### Web
 - [adminMongo](https://github.com/mrvautin/adminMongo) - Web-based user interface to handle connections and databases needs
 - [mongo-express](https://github.com/mongo-express/mongo-express) - Web-based admin interface built with Express
 - [mongoadmin](https://github.com/thomasst/mongoadmin) - Admin interface built with Django
 - [Mongoku](https://github.com/huggingface/Mongoku) - MongoDB client for the web
 - [mongri](https://github.com/dongri/mongri) - Web-based user interface written in JavaScript
 - [Rockmongo](https://github.com/iwind/rockmongo) - PHPMyAdmin for MongoDB, sort of

Services:

 - [HumongouS.io](https://www.humongous.io) - Easy online GUI and data-visualization dashboards

## Applications

Those open-source applications have MongoDB somewhere in their stack:

 - [Builder Book App](https://github.com/async-labs/builderbook) - Web app to publish books or documentation built with React and Express
 - [CodeCombat](https://github.com/codecombat/codecombat) - Multiplayer programming game for learning how to code
 - [Countly](https://github.com/countly/countly-server) - Mobile & web analytics and marketing platform built with Node.js
 - [FactorJS](https://github.com/fiction-com/factor) - JavaScript CMS built with Mongoose
 - [GrandNode](https://github.com/grandnode/grandnode) - Multi-platform e-commerce shopping cart built with ASP.NET
 - [Leanote](https://github.com/leanote/leanote) - Evernote clone built with Go
 - [NodeBB](https://github.com/NodeBB/NodeBB) - Node.js based forum software ("built for the modern web")
 - [Reaction](https://github.com/reactioncommerce/reaction) - Event-driven, real-time commerce platform built with ES6
 - [SaaS Boilerplate](https://github.com/async-labs/saas) - Boilerplate for SaaS products, built with TypeScript, React and Express
 - [uptime](https://github.com/fzaninotto/uptime) - Remote monitoring application built with Node.js and Bootstrap
 - [WildDuck Mail Server](https://github.com/nodemailer/wildduck) - Scalable high availability email server that uses MongoDB for email storage

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Guillaume Gelin](https://github.com/ramnes) has waived all copyright and related or neighboring rights to this work.
