<div class="github-widget" data-repo="myshov/awesome-mobile-web-development"></div>
## Awesome Mobile Web Development [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

创建出色的移动网络体验所需的一切.

<a href="https://github.com/myshov/awesome-mobile-web-development/blob/master/CONTRIBUTING.md">贡献指南</a>





## Articles and Documentation

- [300ms Tap Delay, Gone Away](https://developers.google.com/web/updates/2013/12/300ms-tap-delay-gone-away) - How to prevent 300 ms delay on tap.
- [60 FPS on Mobile Web](http://engineering.flipboard.com/2015/02/mobile-web) - 如何制作一个真正快速的移动网站（通过 Flipboard）.
- [Adaptive loading: improving web performance on slow devices](https://web.dev/adaptive-loading-cds-2019/) - 如何针对特定硬件和网络限制优化站点.
- [Animating the Mobile Web](https://engineeringblog.yelp.com/2015/01/animating-the-mobile-web.html) - 在移动网络上实现快速动画的案例研究（来自 Yelp）.
- [Autofill: What web devs should know, but don’t](https://cloudfour.com/thinks/autofill-what-web-devs-should-know-but-dont/) - 您需要了解的有关表单自动填充的所有信息.
- [Back/forward cache](https://web.dev/bfcache/) - 如何优化历史导航站点.
- [Benchmarking the global 5G experience](https://www.opensignal.com/2021/02/03/benchmarking-the-global-5g-experience) - 关于 5G 网络激增的案例研究.
- [Cache-Control for Civilians](https://csswizardry.com/2019/03/cache-control-for-civilians/) - 如何设置缓存控制以获得最佳响应时间.
- [CSS fix for 100vh in mobile WebKit](https://allthingssmitty.com/2020/05/11/css-fix-for-100vh-in-mobile-webkit/) - 如何解决移动 WebKit 中 100vh 的问题.
- [Current Web on Galaxy Fold](https://medium.com/samsung-internet-dev/current-web-on-galaxy-fold-ad12d7f57c26) - 关于 Galaxy Fold 网络开发的建议.
- [Designing a Dark Theme for OLED iPhones](https://medium.com/lookup-design/designing-a-dark-theme-for-oled-iphones-e13cdfea7ffe) - 关于 OLED 显示器上的深色主题问题以及如何处理它们.
- [Designing Websites for iPhone X](https://webkit.org/blog/7929/designing-websites-for-iphone-x/) - 如何处理 iPhone X 上的“刘海”.
- [Developing Mobile Web Applications: When, Why, and How](https://www.toptal.com/android/developing-mobile-web-apps-when-why-and-how) - 移动网络开发的良好高级概述.
- [Enhance SMS-delivered code security with domain-bound codes](https://developer.apple.com/news/?id=z0i801mg) - 关于 2FA 的额外安全措施.
- [Everyone has JavaScript, right?](https://kryogenix.org/code/browser/everyonehasjs.html) - 显示在哪些情况下 JavaScript 可能不可用的图表.
- [Faster Web App Delivery with PRPL](https://addyosmani.com/blog/the-prpl-pattern/) - 关于高性能 Web 应用程序的模式.
- [Get Started with Remote Debugging Android Devices](https://github.com/myshov/awesome-mobile-web-development/blob/master/ https://developers.google.com/web/tools/chrome-devtools/remote-debugging/) - 使用 Chrome DevTools 在 Adroid 上调试您的网络应用程序.
- [Guidelines For Mobile Web Development](https://www.smashingmagazine.com/guidelines-for-mobile-web-development/) - 关于移动网络开发的好文章的汇编.
- [Hiding Videos on the Mobile Web](https://dougsillars.com/2020/01/06/hiding-videos-on-the-mbile-web/) - 如何在不影响移动流量的情况下隐藏视频.
- [How To Poison The Mobile User](https://www.smashingmagazine.com/2016/10/how-to-poison-the-mobile-user/) - 移动网站上负面做法的概述.
- [How Web Content Can Affect Power Usage](https://webkit.org/blog/8970/how-web-content-can-affect-power-usage/) - 您可以使用网络应用程序做什么来延长电池寿命.
- [HTML attributes to improve your users' two factor authentication experience](https://www.twilio.com/blog/html-attributes-two-factor-authentication-autocomplete) - 关于 2fa 的自动完成属性.
- [Interaction Media Features and Their Potential (for Incorrect Assumptions](https://css-tricks.com/interaction-media-features-and-their-potential-for-incorrect-assumptions/) - 检测各种输入设备.
- [Learn AMP by Example](https://ampbyexample.com) - 以代码和实时示例为重点的 Accelerated Mobile Pages 实践介绍.
- [Loading web pages fast on a $20 feature phone](https://dev.to/addyosmani/loading-web-pages-fast-on-a-20-feature-phone-8h6) - 为功能手机构建网页的最佳实践.
- [Measuring Network Performance in Mobile Safari](https://csswizardry.com/2021/02/measuring-network-performance-in-mobile-safari/) - 关于使用 Mobile Safari 测量网络性能的建议.
- [Microbrowsers are Everywhere](https://24ways.org/2019/microbrowsers-are-everywhere/) - 关于为信使优化站点.
- [Mobile Performance Inequality Gap](https://infrequently.org/2021/03/the-performance-inequality-gap/) - 为什么您需要关注廉价智能手机的性能.
- [Mobile Search UX 8 Obstacles](https://blog.algolia.com/mobile-search-ux-8-obstacles/) - 关于移动搜索用户体验的系列文章.
- [Mobile Web Best Practices](https://www.w3.org/TR/mobile-bp/) - 有点过时但仍然有用的 W3C 移动网站最佳实践列表.
- [Mobile Web Application Best Practices](https://www.w3.org/TR/mwabp/) - 来自 W3C 的移动 Web 应用程序最佳实践列表.
- [Mobile Web Development](https://developer.mozilla.org/en-US/docs/Web/Guide/Mobile) - Mozilla 关于设计移动网站的指南（必读）.
- [Mobile Web Performance Checklist](https://www.oreilly.com/ideas/mobile-web-performance-checklist) - 优化移动网络应用程序的最佳实践.
- [Observing Intersection Observers](https://davidwalsh.name/intersection-observers) - 介绍路口观察员.
- [Offline First (Awesome List)](https://github.com/pazguille/offline-first) - 很棒的离线优先内容列表（渐进式 Web 应用程序、Service Worker 等）
- [Prevent Mobile Browser From Sleeping](https://davidwalsh.name/wake-lock-shim) - 如何防止手机休眠.
- [Responsive Web Design – What It Is And How To Use It](https://www.smashingmagazine.com/2011/01/guidelines-for-responsive-web-design/) - 响应式设计技术概述.
- [Rules for Mobile Performance Optimization](https://queue.acm.org/detail.cfm?id=2510122) - 加快页面加载的技术概述.
- [Self-Host Your Static Assets](https://csswizardry.com/2019/05/self-host-your-static-assets/) - 您需要自行托管静态资产的原因.
- [The Impact of Web Performance](https://simplified.dev/performance/impact-of-web-performance) - 将绩效作为业务的关键因素.
- [The joy and challenge of developing for KaiOS](https://nolanlawson.com/2019/09/22/the-joy-and-challenge-of-developing-for-kaios/) - 如何开始为 KaiOS 开发.
- [Timing Out](https://adactio.com/journal/15122) - 用于处理 lie-fi（不良网络连接）的服务工作者策略.
- [Tips for making interactive elements accessible on mobile devices](https://bitsofco.de/tips-for-making-interactive-elements-accessible-on-mobile-devices/) - 关于创建可访问的移动用户界面的建议列表.
- [Touch Devices Should Not Be Judged By Their Size](https://css-tricks.com/touch-devices-not-judged-size/) - 交互媒体功能概述.
- [Web Content Accessibility Guidelines (WCAG)](https://www.w3.org/TR/WCAG21/) - 使 Web 内容更易于访问的广泛建议.
- [Web Fundamentals](https://developers.google.com/web/fundamentals/) - Google 关于创建良好移动网络体验的指南.
- [What Does A Foldable Web Actually Mean?](https://www.smashingmagazine.com/2020/02/foldable-web-meaning/) - 关于可折叠手机对网络的影响的思考.
- [Who Killed My Battery](https://mobisocial.stanford.edu/papers/boneh-www2012.pdf) - 一篇关于网站功耗的有趣论文.


## Books

- [Brain Food Mobile Performance](http://www.awwwards.org/brainfood-mobile-performance-vol3.pdf) - 来自 Awwwards 的关于移动性能的免费小型电子书.
- [Going Offline](https://abookapart.com/products/going-offline) - 与服务人员建立离线体验的指南.
- [High-Performance Mobile Web: Best Practices for Optimizing Mobile Web Apps](https://www.amazon.com/High-Performance-Mobile-Web-Optimizing/dp/1491912553) - 关于移动设备上网络性能的书籍.
- [Mobile Design Pattern Gallery: UI Patterns for Smartphone Apps](https://www.amazon.com/Mobile-Design-Pattern-Gallery-Smartphone/dp/1449363636) - 可用于移动网络应用程序的 UI 模式.
- [Mobile First](http://mobile-first.abookapart.com/) - 如何为移动设备设计网站（免费在线版）.
- [Responsive Web Design](https://abookapart.com/products/responsive-web-design) - 有关响应式网页设计的书籍.


## Specifications from W3C for Enhancing Mobile Web Experience

- [Battery API](https://www.w3.org/TR/battery-status/) - 关于获取有关电池的信息.
- [Connection API](http://wicg.github.io/netinfo/) - 关于访问有关连接的信息.
- [Generic Sensor API](https://www.w3.org/TR/generic-sensor/) - 暴露传感器数据的规范.
- [Geolocation API](https://www.w3.org/TR/geolocation-API/) - 关于访问地理定位.
- [HTML Media Capture](https://www.w3.org/TR/html-media-capture/) - 用户访问相机或麦克风.
- [Payment Request API](https://www.w3.org/TR/payment-request/) - 关于集成最少的付款方式.
- [Presentation API](https://www.w3.org/TR/presentation-api/) - 访问演示显示.
- [Remote Playback API](https://www.w3.org/TR/remote-playback/) - 从网页控制媒体的远程播放.
- [Vibration API](https://www.w3.org/TR/vibration/) - 关于访问主机设备的振动机制.
- [Visual Viewport API](https://wicg.github.io/visual-viewport/) - 访问屏幕的可视部分，不包括屏幕键盘、双指缩放区域以外的区域等.
- [Wake Lock Api](https://www.w3.org/TR/wake-lock/) - 访问唤醒锁定请求（防止设备的某些方面进入省电状态）.
- [Web Bluetooth](https://webbluetoothcg.github.io/web-bluetooth/) - 在 API 上通过蓝牙 4 发现设备并与之通信.
- [Web NFC API](https://w3c.github.io/web-nfc/) - 访问设备的近场通信功能.
- [Web Notifications](https://www.w3.org/TR/notifications/) - 在用于最终用户通知的 API 上.


## Talks

- [Adaptive Loading - Improving web performance on slow devices](https://www.youtube.com/watch?v=puUPpVrIRkc&feature=emb_title) - 使站点适应硬件和网络限制的实践概述，作者：Addy Osmani、Nate Schloss.
- [Fundamentals of Mobile Web Development](https://www.youtube.com/watch?v=z6dg_V22wV0) - 移动 Web 开发最佳实践概述，作者 Matt Gaunt.
- [Future App Model: Advanced Service Worker](https://www.youtube.com/watch?v=J2dOTKBoTL4) - Jake Archibald 关于如何使用流和服务工作者以及其他新 API 优化 Web 应用程序和网站的一瞥.
- [Instant Loading: Building offline-first Progressive Web Apps](https://www.youtube.com/watch?v=cmGr0RszHc8) - Jake Archibald 对服务人员的介绍.
- [Mobile Web Performance](https://www.youtube.com/watch?v=_y5IzI_tpTw) - 如何在您的网站上实现最佳移动体验，作者：Estelle Weyl.
- [Mobile Web Performance Auditing](https://www.youtube.com/watch?v=WrA85a4ZIaM) - 如何审核网站上的性能问题，作者 Paul Lewis.


## Auditing Tools

- [Lighthouse](https://github.com/GoogleChrome/lighthouse) - 网络应用程序和网页的分析工具.
- [Mobile-Friendly Test](https://search.google.com/test/mobile-friendly) - 用于测试您的网站是否适合移动设备的工具.
- [PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights) - 分析您的页面并提供提高下载速度建议的工具.
- [PageSpeed](https://www.modpagespeed.com) - 自动优化网站的网络服务器模块.
- [Site Speed Checker](https://www.thinkwithgoogle.com/feature/mobile) - 将您的移动网站的速度与其他网站进行比较.
- [Test Your Mobile Speed](https://testmysite.withgoogle.com/intl/en-gb) - 来自 Google 的工具，可对移动网站执行全面的速度检查.
- [Webpagetest](https://webpagetest.org) - 使用真实浏览器和真实消费者连接速度从多个位置进行网站速度测试.


## Platform Monitoring

- [Can I Use](https://caniuse.com) - 浏览器中各种网络功能的支持状态.
- [Mobile Browser Market Share](http://gs.statcounter.com/browser-market-share/mobile) - 各种平台和国家之间的市场份额.
- [Standards for Web Applications on Mobile](https://www.w3.org/Mobile/mobile-web-app-state) - 与移动相关的 W3C 规范的当前状态.
- [What Web Can Do Today](https://whatwebcando.today) - 您的浏览器的功能.


## Other Useful Tools and Libraries

- [Browsersync](https://browsersync.io) - 省时的同步浏览器测试.
- [Eruda](https://github.com/liriliri/eruda) - 移动网络浏览器的控制台.
- [Interact.js](https://github.com/taye/interact.js) - 拖放、调整大小和多点触摸手势，具有惯性和捕捉功能，适用于现代浏览器.
- [Fastclick](https://github.com/ftlabs/fastclick) - 删除旧浏览器中的 300 毫秒延迟.
- [Lozad.js](https://github.com/ApoorvSaxena/lozad.js) - 使用 IntersectionObserver API 的高性能、轻型和可配置的延迟加载器
- [React Dates](https://github.com/airbnb/react-dates) - 一个易于国际化、适合移动设备的日期选择器 React 库，适用于网络.
- [Screen Sizes](http://screensiz.es/phone) - 所有流行智能手机的屏幕尺寸列表.
- [Shiny](https://github.com/rikschennink/shiny) - 移动网站的闪亮反射.
- [Slideout](https://github.com/Mango/slideout) - 适用于您的移动网络应用程序的独立轻量级导航菜单.
- [Swiper](https://github.com/nolimits4web/swiper) - 具有硬件加速转换功能的最现代的移动触摸滑块.
- [Web Inspector Remote (Weinre)](https://www.npmjs.com/package/weinre) - 用于在非主流浏览器中调试站点的 Web 检查器.
- [Web Starter Kit](https://github.com/google/web-starter-kit) - 多设备网站的工作流程.
- [Workbox](https://developers.google.com/web/tools/workbox/) - 用于向 Web 应用程序添加离线支持的 JavaScript 库.
- [WorkerDOM](https://amphtml.wordpress.com/2018/08/21/workerdom/) - 提供 Web Workers 内部 DOM 完整表示的库.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [@myshov](https://github.com/myshov) 已放弃该作品的所有版权和相关或邻接权.
