<div class="github-widget" data-repo="Urigo/awesome-meteor"></div>
## Awesome Meteor [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

很棒的 Meteor 包、库和软件的精选列表.

可以找到官方的 Meteor 资源页面 [here](https://www.meteor.com/tools/resources)

  - [Community Newsletters](#community-newsletters)	

---

## Getting Started

_从哪儿开始_

- [Official Meteor tutorial](https://www.meteor.com/tutorials/react/creating-an-app)
- [Official Guide](http://guide.meteor.com/)

## Collections

_收藏的助手和费用_

- [simple-schema](https://github.com/aldeed/simple-schema-js) - 支持直接验证 MongoDB 更新修饰符对象的 JavaScript 模式验证包.
- [aldeed:collection2](https://github.com/aldeed/meteor-collection2/) - 自动验证客户端和服务器上的插入和更新操作.
- [dburles:collection-helpers](https://github.com/dburles/meteor-collection-helpers/) – 使用您定义的助手转换您的收藏.
- [matb33:collection-hooks](https://github.com/Meteor-Community-Packages/meteor-collection-hooks) - 使用用于插入/更新/删除/查找/findOne 的前/后挂钩扩展 Mongo.Collection.
- [reywood:publish-composite](https://github.com/Meteor-Community-Packages/meteor-publish-composite) - 使用反应式连接从各种集合中发布一组相关文档.
- [jagi:astronomy](https://github.com/jagi/meteor-astronomy/) - Meteor 的模型层.
- [cultofcoders:grapher](https://github.com/cult-of-coders/grapher) - Grapher：Meteor Collection Joins + Reactive GraphQL like queries.
- [sakulstra:aggregate](https://github.com/sakulstra/meteor-aggregate) - 为 Meteor 添加适当的聚合支持.
- [quave:collections](https://github.com/quavedev/collections) - 以标准方式创建集合.

## REST

_对 Meteor 的 REST 支持_

- [maka:rest](https://atmospherejs.com/maka/rest) - 自动使您的 Meteor 应用程序可通过 HTTP 和 DDP 等方式访问.
- [vatfree:restivus](https://github.com/vatfree/meteor-restivus) - 轻松为您的 Meteor 应用程序创建 REST 端点.

## Forms and Templates

_模板助手_

- [uniforms](https://github.com/vazco/uniforms) - 一堆 React 组件和助手，可以轻松生成和验证表单. [Seamlessly integrate with `simpl-schema`](https://uniforms.tools/docs/installation).
- [aldeed:autoform](https://github.com/aldeed/meteor-autoform) - UI 组件和助手，可轻松创建具有自动插入和更新事件以及自动反应验证的基本表单.
- [ostrio:templatehelpers](https://github.com/VeliovGroup/Meteor-Template-helpers) - Blaze 模板的实用助手.
- [aldeed:template-extension](https://github.com/aldeed/meteor-template-extension) - 一个 Meteor 包：替换已经定义的模板，从其他模板继承助手和事件.
- [kadira:blaze-layout](https://github.com/TeamGrid/blaze-layout) - Blaze 布局管理器（适用于 Meteor FlowRouter）

## Users and Authentication

_处理用户和身份验证的工具_

- [accounts-js](https://github.com/accounts-js/accounts) - 一套软件包旨在提供为您的应用程序构建灵活的身份验证和帐户管理解决方案所需的所有工具.
- [alanning:roles](https://github.com/Meteor-Community-Packages/meteor-roles) - 对内置帐户包的角色支持.
- [meteor-user-status](https://github.com/Meteor-Community-Packages/meteor-user-status) - 跟踪用户及其元数据.
- [accounts-ui](https://github.com/e-Potek/accounts-ui/) - 在 Meteor 1.3+ 中用于 React 的帐户 UI.

## Administration

_用于管理 Meteor 应用程序的工具_

- [Meteor Candy](https://www.meteorcandy.com/) - 将管理面板添加到您的应用程序的最快、更简单的方法.
- [yogiben:admin](https://github.com/yogiben/meteor-admin) - 完整的管理仪表板解决方案.
- [houston:admin](https://github.com/gterrono/houston) - 零配置，类似 Django Admin 的 Meteor 管理员.
- [zodern:pure-admin](https://github.com/zodern/meteor-pure-admin) - 一个独立的、可定制的 Meteor 管理面板.

## Monitoring

_用于监控 Meteor 应用程序的工具_

- [kschingiz:meteor-elastic-apm](https://github.com/kschingiz/meteor-elastic-apm) - 基于 Elastic APM 的 Meteor 性能监控
- [monti-apm-agent](https://github.com/monti-apm/monti-apm-agent) - Meteor 的性能监控
- [lmachens:kadira](https://github.com/lmachens/kadira) - Meteor 的性能监控

## Performance

_加速您的 Meteor 应用程序的工具_

- [cultofcoders:redis-oplog](https://github.com/cult-of-coders/redis-oplog) - Redis Oplog 实现完全取代 Meteor 中的 MongoDB Oplog
- [staringatlights:fast-render](https://github.com/abecks/meteor-fast-render) - 快速渲染的活跃分支
- [epotek:method-cache](https://github.com/e-Potek/method-cache) - 使用 DataLoader 的 Meteor 方法缓存
- [maestroqadev:pub-sub-lite](https://github.com/adtribute/pub-sub-lite) - 将出版物转变为非反应性的.
- [artillery-engine-meteor](https://github.com/kschingiz/artillery-engine-meteor) - MeteorJS 应用程序的火炮负载测试.

## Deployment

_用于部署和维护 Meteor 应用程序的工具_

- [meteor-up](https://github.com/zodern/meteor-up) – 流星部署.
- [meteor-google-cloud](https://github.com/EducationLink/meteor-google-cloud) - 在 Google Cloud App Engine Flexible 上自动化 Meteor 部署
- [mup-aws-beanstalk](https://github.com/zodern/mup-aws-beanstalk) - 使用 Meteor Up 将 Meteor 应用程序部署到 AWS Elastic Beanstalk
- [meteor-azure](https://github.com/fractal-code/meteor-azure) - 在 Azure App Service 上自动化 Meteor 部署
- [pm2-meteor](https://github.com/andruschka/pm2-meteor) - 使用 PM2 部署、扩展和运行 Meteor 应用程序的最简单方法.
- [meteor-hero](https://github.com/jkrup/meteor-hero) - 使用 Heroku 的服务，通过一条命令免费部署 MeteorJS 应用程序.
- [meteor-kubernetes-guide](https://github.com/Gregivy/meteor-kubernetes-guide) - 使用 Kubernetes 部署 Meteor 应用程序.
- [meteorhacks:cluster](https://github.com/lmachens/cluster) - 具有负载平衡和服务发现功能的 Meteor 集群解决方案
- [demeteorizer](https://github.com/onmodulus/demeteorizer) - 将 Meteor 应用程序转换为“标准”Node.js 应用程序
- [percolate:migrations](https://github.com/percolatestudio/meteor-migrations) - Meteor 的简单迁移系统
- [yamup](https://github.com/bordalix/yamup) - 在没有码头工人的情况下将 Meteor 应用程序部署到您自己的 Ubuntu 服务器（EC2，...）
- [waveshosting](https://github.com/nicolaslopezj/waveshosting) - 用于管理流星部署的 Web 应用程序.

## Docker Images

- [meteor-docker](https://github.com/zodern/meteor-docker)
- [meteor-base](https://github.com/disney/meteor-base)
- [docker-meteor](https://github.com/tozd/docker-meteor)

## Routers

_Blaze 路由器_

- [ostrio:flow-router-extra](https://github.com/VeliovGroup/flow-router)  - 精心扩展的 `flow-router` 包. 最新版本，支持最新的 Meteor 版本.
- [msavin:parrot](https://github.com/msavin/Parrot) - 专为使用 Meteor 构建 SPA 而设计的 Web 路由器
- [meteorhacks:picker](https://github.com/meteorhacks/picker) - 用于 Meteor 的服务器端路由器.
- [iron:router](https://github.com/iron-meteor/iron-router) - 在服务器和浏览器上工作的路由器，专为 Meteor 设计. 

## Offline

_Meteor 离线支持工具_

- [ground:db](https://github.com/GroundMeteor/db) - GroundDB 是一个薄层，提供 Meteor 离线数据库和方法.
- [npdev:collections](https://github.com/CaptainN/npdev-collections) - 使用 SSR for Meteor 创建离线收藏的简单方法
- [meteor-service-worker](https://github.com/NitroBAY/meteor-service-worker) - Meteor 特定的服务工作者实现.
- [quave:pwa](https://github.com/quavedev/pwa) - 允许您配置 PWA 的 Meteor 包.

## Testing

_测试工具_

- [meteortesting:mocha](https://github.com/meteortesting/meteor-mocha) - 用于 Meteor 的 Mocha 测试驱动程序包.
- [lmieulet:meteor-coverage](https://github.com/serut/meteor-coverage) - Meteor 的测试范围.
- [hubroedu:mocha](https://github.com/hubroedu/meteor-mocha/) - Decaffed cultofcoders：摩卡叉.
- [antwaremx:meteorman](https://github.com/antwaremx/meteorman) - Meteorman：带有 GUI 的 DDP 客户端，用于测试 Meteor 方法和发布（如 Postman）.

## SEO

_搜索引擎优化工具_

- [ostrio:spiderable-middleware](https://github.com/VeliovGroup/spiderable-middleware/) - 支持 ES6 (ECMAScript2015) 的预呈现 (_a.ka Spiderable_) - Meteor 应用程序可被搜索引擎完美抓取.

## Files

_在 Meteor 中处理文件_

- [ostrio:files](https://github.com/VeliovGroup/Meteor-Files)  - 通过 DDP、HTTP 和 WebRTC/DC 上传文件. 到 Meteor 服务器 FS、AWS、GridFS、DropBox 或 Google Drive. 快速、安全且稳健.
- [@reactioncommerce/file-collections](https://github.com/reactioncommerce/reaction-file-collections) - Reaction FileCollections 是一组 NPM 包，提供了在 Node 和 Meteor 应用程序以及浏览器 JavaScript 中支持文件上传、存储和下载的能力.
- [netanelgilad:excel](https://github.com/netanelgilad/meteor-excel) - 解析和生成 excel 文件（xlsx、xls）.
- [mikkelking:slingshot](https://github.com/Back2bikes/meteor-slingshot) - 将文件直接上传到 AWS S3、谷歌云存储和其他流星.

## Search, sort and paginate

_搜索、排序和分页相关工具_

- [percolate:find-from-publication](https://github.com/versolearning/find-from-publication) - 启用查找已由给定出版物发布的所有文档.
- [meteor-publish-join](https://github.com/nlhuykhang/meteor-publish-join#readme) - 用于发布非反应性或聚合值的高性能 NPM 包.
- [tmeasday:publish-counts](https://github.com/percolatestudio/publish-counts) - 实时发布游标计数.
- [meteorhacks:search-source](https://github.com/meteorhacks/search-source) - 用于搜索的反应式数据源.
- [matteodem:easy-search](https://github.com/matteodem/meteor-easy-search) - 使用 Blaze 组件进行易于使用的搜索（+ 弹性搜索支持）
- [alethes:pages](https://github.com/alethes/meteor-pages) - 开箱即用的 Meteor 分页.

## Mobile

_移动开发_

- [meteor-react-native](https://github.com/TheRealNate/meteor-react-native) - 用于 React Native 匹配 Meteor 规范的 Meteor 客户端.
- [meteor-push](https://github.com/activitree/meteor-push) - 为 cordova（ios、android）浏览器（Chrome、Safari、Firefox）推送通知.
- [quave:universal-links](https://github.com/quavedev/universal-links) - 一个 Meteor 包，允许您公开本机 iOS 设置以启用通用链接. 
- [meteoric:ionic](https://github.com/meteoric/meteor-ionic) - Meteor 的离子组件.
- [driftyco:ionic](https://github.com/driftyco/ionic) - 对 Meteor 的官方 Ionic 支持.
- [martijnwalraven:meteor-ios](https://github.com/martijnwalraven/meteor-ios) - 通过 DDP 将原生 iOS 应用程序与 Meteor 平台集成.
- [delight-im/Android-DDP](https://github.com/delight-im/Android-DDP) - 适用于 Android 客户端的 DDP.
- [okland:accounts-phone](https://github.com/okland/accounts-phone) - Meteor 基于手机号的登录服务.
- [okland:camera-ui](https://github.com/okland/camera-ui)  - Meteor package for taking photos with user interface，桌面和移动端的一个函数调用. 允许在手机上的相机和照片库之间进行选择.
- [percolatestudio/cordova-plugin-safe-reload](https://github.com/percolatestudio/cordova-plugin-safe-reload) - Cordova 插件，用于在流星热代码推送损坏后进行观察和恢复.

## Data Visualization

_Meteor 中的数据可视化：图表、地图、表格等_

- [aldeed:tabular](https://github.com/aldeed/meteor-tabular) - 大型或小型数据集的反应式数据表.
- [aslagle:reactive-table](https://github.com/aslagle/reactive-table/) - 用于 Meteor 的反应表，使用 Blaze.
- [luixal:blaze-paginated-custom-list](https://github.com/luixal/meteor-blaze-paginated-custom-list) - 反应和分页的项目列表.
- [luixal:meteor-apexcharts](https://github.com/luixal/meteor-apexcharts) - 为 Meteor 打包的反应式 ApexCharts 库.

## Analytics

_Analytics_

- [okgrow:analytics](https://github.com/okgrow/analytics/) - 流星的 Google Analytics、Mixpanel、KISSmetrics（以及更多）集成.
- [quave:analytics](https://github.com/quavedev/analytics) - 一个 Meteor 包，允许您将页面浏览量和更多信息发送到 Google Analytics.

## Cron Jobs

_Meteor 中的 Cron 作业_

- [msavin:sjobs](https://github.com/msavin/stevejobs/) - 流星优先作业队列/任务调度程序.
- [percolate:synced-cron](https://github.com/percolatestudio/meteor-synced-cron)  - Meteor 的 Cron 系统. 它支持在多个进程之间同步作业.
- [ostrio:cron-jobs](https://github.com/VeliovGroup/Meteor-CRON-jobs) - 使用与本机“setTimeout”和“setInterval”方法类似的 API 进行打包，但在所有正在运行的 Meteor (NodeJS) 实例之间同步.

## Debugging Tools

_调试工具_

- [meteor-devtools-evolved](https://github.com/leonardoventurini/meteor-devtools-evolved) - 铬扩展.
- [msavin:mongol](https://github.com/msavin/Mongol/) - 用于 MongoDB 集合的 Meteor 可视化编辑工具.
- [msavin:jetsetter](https://github.com/msavin/JetSetter) - Visual Get/Set Tool for Meteor Session Variables.
- [babrahams:constellation](https://github.com/JackAdams/constellation-distro/) - 一个可扩展的 Meteor 开发控制台.

## Editor Plugins

- [meteor-api](https://atom.io/packages/meteor-api) - Atom 的流星插件.
- [meteor-zsh](https://github.com/robbyrussell/oh-my-zsh/wiki/Plugins#meteor) - 完成流星命令.

## Scaffolding

_Scaffolding_

- [Meteor Kitchen](http://www.meteorkitchen.com/) - Meteor 的代码生成器.
- [iron-cli](https://github.com/iron-meteor/iron-cli) - 用于 Meteor 应用程序的脚手架命令行工具.
- [maka-cli](https://github.com/maka-io/maka-cli) - Maka-CLI 是一个命令行工具，它组织 Web 应用程序的文件结构并自动执行各种应用程序框架的日常包安装任务.

## Tooling

- [ESLint-plugin-Meteor](https://github.com/dferber90/eslint-plugin-meteor/) - 用于 Meteor 的 ESLint 插件.

## Boilerplate

- [CaptainN - meteor-react-starter](https://github.com/CaptainN/meteor-react-starter) - 带有 React 的 Meteor 入门项目.
- [Pup](https://github.com/cleverbeagle/pup)
- [matteodem - meteor-boilerplate](https://github.com/matteodem/meteor-boilerplate)
- [React with Webpack + Meteor as a backend](http://julian.io/react-with-webpack-meteor-as-a-backend/)

## Open source apps

- [Rocket.Chat](https://rocket.chat/) - 使用 Meteor 构建的实时聊天应用程序.
- [Wekan](https://github.com/wekan/wekan) - 类似 Trello 的开源看板.
- [Unchained Shop](https://github.com/unchainedshop/unchained) - 使用 Meteor 开发的开源商务平台.
- [VulcanJS](https://github.com/VulcanJS/Vulcan) - 一个使用 React、GraphQL 和 Meteor 快速构建应用程序的工具包.
- [Nosqlclient](https://github.com/nosqlclient/nosqlclient) - MongoDB 管理工具.
- [radgrad2](https://github.com/radgrad/radgrad2) - 基于流星的教育管理系统.
- [coauthor](https://github.com/edemaine/coauthor) - 合著者超级协作/讨论论坛.

## Internationalization

- [Meteor-Internationalization](https://github.com/veliovgroup/Meteor-Internationalization) - 用于 Meteor 的超轻量级快速 i18n 同构驱动程序，支持占位符.
- [meteor-accounts-t9n](https://github.com/softwarerero/meteor-accounts-t9n/) - 流星帐户错误信息的翻译.
- [meteor-universe-i18n](https://github.com/vazco/meteor-universe-i18n) - React 和 Meteor 的国际化包.

## Front End Frameworks

_Blaze 的替代前端框架_

- [React](http://react-in-meteor.readthedocs.org/en/latest/) - 使用 React 和 Meteor.
- [Vue](https://github.com/meteor-vue) - 使用 Vue 和 Meteor（加上单文件组件和 apollo 支持）.
- [Svelte](https://github.com/zodern/melte) - 使用 Meteor 和 Svelte 构建控制论增强的网络应用程序.
- [Angular 2](https://github.com/Urigo/angular2-meteor) - 使用 Angular 2 和 Meteor.
- [Angular](https://github.com/Urigo/angular-meteor) - 使用 Angular 和 Meteor.
- [Famo.us](https://github.com/gadicc/meteor-famous-views/) - Famo.us 和流星.
- [frozeman:build-client](https://github.com/frozeman/meteor-build-client) - 用于捆绑 Meteor 应用程序客户端部分的工具.
- [Asteroid](https://github.com/mondora/asteroid) - Meteor 后端的替代客户端.
- [ddp.js](https://github.com/mondora/ddp.js) - 同构 JavaScript DDP 客户端.
- [elm](https://github.com/ni-ko-o-kin/meteor-elm-example) - 榆树作为基于流星的项目的视图层.

## Alternative Databases

_MongoDB 的替代数据库_

- [vlasky:mysql](https://github.com/vlasky/meteor-mysql) - 用于 Meteor 的反应式 MySQL
- [meteor-pg](https://github.com/Richie765/meteor-pg) - 新的和改进的 PostgreSQL 对 Meteor 的支持
- [ostrio:neo4jdriver](https://github.com/VeliovGroup/ostrio-neo4jdriver/) - 用于 Meteor 的 Neo4j 驱动程序，支持 GrapheneDB
- [numtel:pg](https://github.com/numtel/meteor-pg) - 用于 Meteor 的反应式 PostgreSQL
- [simple:rethink](https://github.com/Slava/meteor-rethinkdb) - 用于 Meteor 的 RethinkDB 集成

## Resources

_在哪里可以发现新的 Meteor 事物_

## Books

- [Meteor Explained](https://gumroad.com/l/meteor-explained)
- [Secure Meteor](https://www.securemeteor.com/)
- [meteor-tuts](https://www.meteor-tuts.com/) - 自由
- [Meteor Tips](http://meteortips.com/) - 自由
- [Pro Meteor](https://pdfslide.net/documents/pro-meteor-book.html) - 自由
- [Meteor Cookbook](https://github.com/awatson1978/meteor-cookbook)

## Courses

- #### Free

  - [How to Create an App](https://www.youtube.com/c/Howtocreateanappdev/videos) - 最新.
  - [EventedMind](https://learn-meteor.netlify.app/) - 它很旧，但详细介绍了 Meteor 的内部结构.

- #### Paid
  - [Udemy - Learn React and Meteor in 2021: Build a multiplayer game](https://www.udemy.com/course/modern-web-development-with-react-and-meteor-2021/)
  - [Udemy - Realtime Applications with Meteor and Vue](https://www.udemy.com/course/meteor-vue) - 西班牙语课程.
  - [leveluptutorials](https://www.leveluptutorials.com/) - 包含一些免费教程，但主要针对 1.x.

## Tutorials


- [Phusion Passenger: Meteor tutorial](https://github.com/phusion/passenger/wiki/Phusion-Passenger:-Meteor-tutorial)
- [When a Meteor finally hits production](https://medium.com/@davidyahalomi/when-a-meteor-finally-hits-production-6c37b81f795b) - 关于部署 Meteor 应用程序的博客文章
- [Transform any Meteor App into a PWA](https://dev.to/jankapunkt/transform-any-meteor-app-into-a-pwa-4k44)

## Blogs

- [Official Meteor blog](http://blog.meteor.com)
- [The Meteor podcast](http://podcast.crater.io)

## Websites

- [Official website](https://www.meteor.com/)
- [Official Documentation](http://docs.meteor.com/)
- [Official Guide](http://guide.meteor.com/)
- [Atmosphere](https://atmospherejs.com/) - Meteor 包、资源和工具的目录.
- [Packosphere](https://packosphere.com/) - Meteor 包系统的替代前端，由 [Kelly Copley 构建
](https://github.com/copleykj)
- [Discover Meteor](https://book.discovermeteor.com/)
- [Meteorpedia](http://www.meteorpedia.com) ([infrequently](http://www.meteorpedia.com/special/RecentChanges/) 更新）
- [Meetups](http://meteor.meetup.com/)
- [Reddit](https://www.reddit.com/r/meteor)
- [YouTube](https://www.youtube.com/channel/UC3fBiJrFFMhKlsWM46AsAYw) 来自世界各地聚会的视频
- [Unofficial Meteor FAQ](https://github.com/oortcloud/unofficial-meteor-faq)
- [The Meteor Chef](https://themeteorchef.com)

### Q&A

- [Stack Overflow](http://stackoverflow.com/questions/tagged/meteor?sort=newest&pagesize=15)
- [Meteor forums](https://forums.meteor.com/)

### Community Newsletters

- [zodern](https://zodern.me/newsletter.html)
- [StorytellerCZ](https://forums.meteor.com/t/meteor-community-newsletter/50598)

## Social

- [Official Twitter Account](https://twitter.com/meteorjs)
- [Meteor Community Organization Slack Channel](https://github.com/Meteor-Community-Packages/organization#slack)


## Work Opportunities

- [Awesome Meteor Jobs](https://github.com/harryadel/awesome-meteor-jobs)
- [We work Meteor](https://www.weworkmeteor.com/)
- [Official Job Board](https://jobs.meteor.com/)

## Related

- [Awesome Meteor Developers](https://github.com/harryadelb/awesome-meteor-developers)
- [Awesome Blaze](https://github.com/arggh/awesome-blaze)

## Built With Meteor

_使用 Meteor 构建的商业级应用程序_

- [Qualia](https://www.qualia.com/) - 房地产初创公司
- [Code Signal](https://codesignal.com/) - 基于技能的评估平台
- [https://github.com/Urigo/awesome-meteor/blob/master/Pathable](https://github.com/Urigo/awesome-meteor/blob/master/Pathable) - 活动管理套件
- [MaestroQA](https://www.maestroqa.com/) - 质量保证软件

## Deprecated

_本节专为不再与当前版本的 Meteor 兼容的资源而设计_

- [Meteor 1.4 + React For Everyone Tutorials](https://www.leveluptutorials.com/tutorials/meteor-1-4-react-for-everyone-tutorials)
- [Meteor 1.4 For Everyone](https://www.leveluptutorials.com/tutorials/meteor-1-4-for-everyone)
- [Intermediate Meteor](https://www.leveluptutorials.com/tutorials/intermediate-meteor)
- [Meteor For Everyone Tutorials](https://www.leveluptutorials.com/tutorials/meteor-for-everyone-tutorials)
- [tuts+ - Single Page Web Apps with Meteor](http://code.tutsplus.com/courses/single-page-web-apps-with-meteor)
- [Building a CMS-powered blog in Meteor](https://buttercms.com/blog/meteor-cms-blog-tutorial)
- [scotch.io - Building a Slack Clone in Meteor](https://scotch.io/tutorials/building-a-slack-clone-in-meteor-js-getting-started)

## [Contributing](https://github.com/urigo/awesome-meteor/blob/master/CONTRIBUTING.md)

随时欢迎您的贡献！

感谢@gillesfabio 创建这个 repo！
