<div class="github-widget" data-repo="dreamingechoes/awesome-mental-health"></div>

<p align="center"><img src="https://raw.githubusercontent.com/dreamingechoes/awesome-mental-health/master/./media/logo.png"></p>

<p align="center">
  <a href="https://raw.githubusercontent.com/sindresorhus/awesome"><img alt="awesome" src="https://awesome.re/badge.svg"/></a>
  <img alt="PRs Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg"/>
</p>

## About

 :sparkles：关于软件行业心理健康的精彩文章、网站和资源的精选列表.  ：火花：

 **心理健康**是**心理健康**或**没有精神疾病**的水平. 这是一个人在情绪和行为调整方面处于令人满意的水平的心理状态.

它包括主观幸福感、自我效能感、自主性、能力、代际依赖性以及一个人的智力和情感潜力的自我实现等.

 &gt; 这份清单汇集了我们个人认为对一系列心理健康问题有用的几种自助资源，但它们绝不能替代专业帮助、心理治疗或药物治疗.  **我们不是专家**，即使我们是，这些工具中的大多数也只是作为治疗的辅助手段，而不是替代品.
>
&gt;**如果你正处于危机之中，请看 [here](https://twloha.com/find-help/international-resources/)， 或者 [here](https://www.iasp.info/resources/Crisis_Centres/) 获取您所在国家/地区的资源.**



## Applications

帮助处理焦虑、抑郁或其他心理健康问题的应用程序.

* [Moodpath](https://mymoodpath.com/en/) - 基于应用程序的交互式筛查，旨在识别抑郁症的症状.
* [Nyxo](https://nyxo.app) – 适用于 iOS 和 Android 的开源睡眠跟踪和睡眠指导应用程序.
* [Sanvello](https://sanvello.com)  - 与支持社区一起应对压力、焦虑和抑郁的日常工具. 基于认知行为疗法和正念冥想.
* [Quirk](https://www.quirk.fyi/) - 适用于 iOS 和 Android 的 GPL 许可认知行为疗法 (CBT) 应用程序.
* [Three Good Things](https://three-good-things.glitch.me/) - 每天早上写下你生活中的三件好事.
* [Wake Up Time](http://wakeupti.me/) - 根据您身体的睡眠周期计算最佳起床时间.
* [we are ANXIO.us](http://weareanxio.us) - 一系列心理健康和健康应用程序，以及资源.
* [Wrabit](https://writewithwrabit.com) - 养成日常写作习惯，同时为心理健康研究做出贡献.

## Articles

关于技术心理健康的文章、帖子和论文.

* [A Programmers Guide To Stress](http://codingmindfully.com/a-programmers-guide-to-stress/) - 达拉格·伯恩 (Daragh Byrne).
* [Are You More Than Okay: The State Of Mental Health In Tech In 2016](https://modelviewculture.com/pieces/are-you-more-than-okay-the-state-of-mental-health-in-tech-in-2016) - 朱莉娅·阮.
* [Beating Burnout: A Guide For Supporting Mental Health At Work](https://almanac.io/docs/beating-burnout-a-guide-for-supporting-mental-health-at-work-yDLKVF3uJtMdshcZG37HP7OHpAczogYX) - 年鉴核心.
* [Coding, Fast And Slow: Developers And The Psychology Of Overconfidence](https://medium.com/better-programming/coding-fast-and-slow-developers-and-the-psychology-of-overconfidence-433388e7aec0) ——丹·米尔斯坦.
* [Depression At Work Is Skyrocketing, But It Doesn't Have To Be Your New Normal](https://www.fingerprintforsuccess.com/blog/depression-at-work) - 由 Bev Campling 撰写.
* [Developer Depression: Isolation Is The Biggest Problem](https://thenextweb.com/insider/2012/10/20/are-developers-depressed/#gref) - 劳伦·马菲奥.
* [Developers: How to Overcome Imposter Syndrome](https://medium.com/learn-love-code/developers-how-to-overcome-imposter-syndrome-48edee803cf4) - 作者：阿比舍克·皮莱.
* [Do Not Disturb](https://joebell.co.uk/blog/do-not-disturb/) - 乔贝尔.
* [Encouraging Wellness in a Remote Workpalce](https://dev.to/desi/encouraging-wellness-in-a-remote-workplace-17m5) - 德西罗特曼.
* [For The Developers With Anxiety, And Everyone Else](https://medium.com/envato/for-the-developers-with-anxiety-and-everyone-else-834cc2517eba) - 戴恩·莫尔 (Daine Mawer).
* [How I Beat Impostor Syndrome And Stopped Feeling Like A Fake](http://codingmindfully.com/how-i-beat-impostor-syndrome/) - 达拉格·伯恩 (Daragh Byrne).
* [How I Conquered Anxiety And Learned To LOVE Coding](https://skillcrush.com/2015/06/18/eliminate-your-coding-anxiety/) - 乔伊斯明子.
* [How I Fought Through Anxiety And Depression To Finish freeCodeCamp's Front End Dev Program](https://medium.freecodecamp.org/battling-depression-and-anxiety-to-finish-freecodecamps-front-end-dev-program-66a4c8cc0e13) - 艾米丽·阿莫特 (Emily Aamodt).
* [How To Keep Your Mental Health In Check When You Work From Home](https://weworkremotely.com/how-to-keep-your-mental-health-in-check-when-you-work-from-home) - 通过 WeWorkRemotely.
* [How To Move Your Organization From Fear To Fearlessness](https://liberationist.org/how-to-move-your-organization-from-fear-to-fearlessness/) - 古斯塔沃·拉泽蒂 (Gustavo Razzetti).
* [How To Prevent Or Recover From Developer Burnout](https://www.actitime.com/productivity/how-to-prevent-burnout) - 阿纳斯塔西娅.
* [Hunting For A Web Developer Job... With Crushing Anxiety And No Self-Esteem](https://medium.com/@jameslave/hunting-for-a-web-developer-job-with-crushing-anxiety-and-no-self-esteem-3aa64d67a0a4) - 詹姆斯·洛.
* [I Can't Do It All: My Burnout Story](https://dev.to/molly_struve/i-cant-do-it-all-my-burnout-story-1e54) ——莫莉·司徒卢威.
* [Intro To Meditation For Coders](https://dev.to/256hz/intro-to-meditation-for-coders-1p6f) - 安倍·多林格 (Abe Dolinger).
* [It's Okay To Not Be Okay](https://dev.to/andrew/its-okay-to-not-be-okay) - 安德鲁·蒙塔尼 (Andrew Montagne).
* [It's Time To Talk About Mental Health In The Games Industry](https://www.gamesindustry.biz/articles/2017-05-09-its-time-to-talk-about-mental-health-in-the-games-industry) - 里奇艾迪.
* [It's Time To Talk About Mental Illness In Indie Development](https://www.engadget.com/2018/04/04/mental-illness-indie-take-this-kate-edwards-mike-wilson) - 杰西卡康迪特.
* [Mental Self Care For Software Developers And Web Designers](https://www.elegantthemes.com/blog/editorial/mental-self-care-for-software-developers-and-web-designers) - BJ 基顿.
* [Mental Illness In The Web Industry](https://alistapart.com/article/mental-illness-in-the-web-industry) - 布兰登格雷戈里.
* [My Mental Health Toolbelt](https://medium.com/@taylorotwell/my-mental-health-toolbelt-9b9fdd4ae149) ——泰勒·奥特威尔.
* [On Dealing With Anxiety And Depression As A Developer](https://dev.to/moimikey/on-dealing-with-anxiety-and-depression-as-a-developer-2ac4) - 迈克尔·斯科特·赫兹伯格 (Michael Scott Hertzberg).
* [Overcoming Public Speaking Anxiety Of Software Engineers Using Virtual Reality Exposure Therapy](https://www.researchgate.net/publication/319064487_Overcoming_Public_Speaking_Anxiety_of_Software_Engineers_Using_Virtual_Reality_Exposure_Therapy) - Merve Denizci Nazligul、Murat Yilmaz、Ulas Gulec、Mert Ali Gozcu、Rory V. O&#39;Connor 和 Paul Clarke.
* [Perfectionism, Anxiety And Learning To Be Kind To Yourself](https://medium.com/samsung-internet-dev/perfectionism-anxiety-and-learning-to-be-kind-to-yourself-e3c23710704) - 乔·弗兰切蒂 (Jo Franchetti).
* [Programmer Imposter Syndrome: 6 Ways To Get Over Yours](https://www.codingdojo.com/blog/programmer-imposter-syndrome) - 伊森·乌里 (Ethan Urie).
* [Recovering From Burnout](https://kierantie.com/burnout) - 基兰领带.
* [Software Developer Careers Considered Harmful](http://www.methodsandtools.com/archive/zenprogrammer.php) - 克里斯蒂安·格罗迈尔 (Christian Grobmeier).
* [Sorry, Not Sorry - How To Advocate For Your Mental Health At Work](https://www.thriveglobal.com/stories/38629-how-to-advocate-for-yourself-at-work) - 杰西卡·迪文托.
* [Taming Anxiety And Hacking Your Way Into Productivity](https://hackernoon.com/taming-anxiety-and-hacking-your-way-into-productivity-1c9258b8380a) - 安德烈佩纳.
* [The Programmer’s Great Clinical Depression](https://simpleprogrammer.com/programmers-great-clinical-depression) - 杰森·洛文塔尔.
* [Tips For Dealing With Developer Stress](https://www.airpair.com/javascript/posts/tips-for-dealing-with-developer-stress) - 里奇·麦克劳克林 (Rich McLaughlin).
* [Tips To Maintain Your Mental Health As A Software Developer](https://www.brightdevelopers.com/tips-maintain-mental-health-software-developer/) - 史蒂文·杜.
* [We Need To Talk About Developers And Depression](https://www.creativebloq.com/web-design/we-need-talk-about-developers-and-depression-101413045) - 格雷格·鲍格 (Greg Baugues).
* [What Happens When Software Developers Are (un)Happy](https://www.sciencedirect.com/science/article/pii/S0164121218300323) - By Daniel Graziotin, Fabian Fagerholm, Xiaofeng Wang & Pekka Abrahamssone.
* [What It's Like Being A Developer With Schizoaffective Disorder](https://dev.to/ogfris/what-its-like-being-a-developer-with-schizoaffective-disorder-1ei) - 星期五.
* [What Most Remote Companies Don't Tell You About Remote Work](https://blog.doist.com/mental-health-and-remote-work-1b77616f6945) - 阿米尔·萨利赫芬迪克 (Amir Salihefendic).
* [Why Burnout Is Dangerous And How You Can Recover From It (It's Possible)](https://blog.toggl.com/recover-from-burnout) - 西奥多拉·阿比盖尔 (Theodora S. Abigail).
* [Why Do Software Developers Suffer From Imposter Syndrome?](https://medium.com/@rajeefmk/why-does-software-developers-suffer-from-imposter-syndrome-ccf961d0c29a) - 穆罕默德·拉吉夫·M·K.

## Books

以心理健康和自我保健为主题的书籍.

* [Mental Health In Tech: Guidelines For Employees](https://leanpub.com/osmi-guidelines-for-employees) - 通过 OSMI.
* [Mental Health In Tech: Guidelines For Executives And HR Professionals](https://leanpub.com/osmi-guidelines-for-employers) - 通过 OSMI.
* [Mental Health In Tech: Guidelines For Mental Wellness In The Workplace](https://leanpub.com/osmi-mental-wellness-in-the-workplace) - 通过 OSMI.

## Conferences

会议宣传心理健康意识和自我保健在软件行业的重要性.

* [Computing And Mental Health](http://mentalhealth.media.mit.edu/) - 汇集社区.
* [Anxiety Tech](http://www.anxietytech.com) - 了解如何在工作中倡导心理健康，如何更好地设计技术来支持心理健康，哪些技术已经在帮助那些患有精神疾病的人，以及您或您的公司如何成为该领域的领导者.

## Meetups

世界各地的 Meetup 团体专注于软件行业的心理健康.

* [Mental Health In Tech Auckland](https://www.meetup.com/mental-health-in-tech-auckland/) - 由 Navs、Kai L. 和 Helen D. 组织

## Organizations

将心理健康意识带入软件行业的组织.

* [Black Minds Matter](http://blackmindsmatter.co.uk/) - 一个非营利组织，旨在为 13-25 岁的黑人社区赋权，并希望为所有人打造更加平等和公正的社会.
* [Black Therapists Rock](https://www.blacktherapistsrock.com/) - Black Therapists Rock (BTR) 是一个致力于提高人们对影响弱势社区的社会和心理挑战的认识的组织.
* [The Black, African, and Asian Therapy Network](https://www.baatn.org.uk/) - 英国最大的独立组织，专门从事心理工作，通过对交叉性的理解，与被认定为黑人、非洲人、南亚人和加勒比海地区的人交流.
* [Brown Sisters Speak](https://twitter.com/BrownSistersSpk) - Mental Health Peer Support & Advocacy for Women Of Color.
* [Compassionate Coding](https://compassionatecoding.com) - 富有同情心的编码将敏捷软件开发的有效实践与对同理心和积极组织心理学的最新关注相结合.
* [Everybody Has A Brain](http://everybodyhasabrain.com/) - 每个人都有大脑是关于创造围绕个人心理健康进行对话的机会.
* [Hack Mental Health](https://www.hackmentalhealth.care) - 心理健康与技术的交集.
* [IfMe](https://www.if-me.org) - 心理健康体验社区，鼓励人们与可信赖的盟友分享他们的个人故事.
* [Mental Health Hackers](https://mentalhealthhackers.org/) - 一个旨在为可能易患相关心理健康问题（例如焦虑、抑郁、社交孤立、饮食失调等）的人提供支持服务的组织.
* [Mental Health Knowledge Base](https://mentalhealth-kb.net/) - 基于 GitHub 的项目和网站，鼓励关于心理健康的多种观点.
* [MHPrompt](http://mhprompt.org) - 让我们开始讨论技术中的心理健康.
* [OSMI](https://osmihelp.org) - Open Sourcing Mental Illness 是一家非营利性公司，致力于提高认识、教育和提供资源以支持技术和开源社区的心理健康.
* [SelfCare.Tech](http://selfcare.tech/) - 开发人员和其他人的自助资源库.

## Podcasts

以“软件行业的心理健康意识”为主题的播客节目.

* [Emotional Intelligence And Ethics In Tech](http://happyporchradio.com/season-4-episode-3-april-wensel/) - 由 April Wensel 在 Happy Porch 播客中发表.
* [Jerk Programmer To Compassionate Coder](http://ardentdev.com/011-jerk-programmer-compassionate-coder-april-wensel) - 由 April Wensel 在 Ardent Development 播客中发表.

## Talks

关于软件行业的心理健康意识和其他证词和经验的演讲和演讲.

* [A Conversation About Mental Health In Tech - Distill 2014](https://vimeo.com/105802592) - Ed Finkler、Greg Baugues、John Dalton 和 Paddy Foran 着.
* [Advocating For Mental Health At Work - AnxietyTech 2018](https://www.youtube.com/watch?v=GfTSrtJgemQ) - 杰西卡·迪文托博士.
* [Anxiety & Calm Technology - AnxietyTech 2018](https://www.youtube.com/watch?v=hhliVWI4mCY) - 由 Amber Case 撰写.
* [Authentic Developer - Droidcon Berlin 2018](https://www.youtube.com/watch?v=k6tROMj_rIQ) - 阿纳斯塔西娅·洛佩斯·多纳克 (Anastasia López Dornak).
* [Beyond Burnout: Mental Health And Neurodiversity In Engineering - DevOpsDays Boston 2018](https://www.youtube.com/watch?v=NGiy02nEcG8) - 詹姆斯·梅克尔.
* [Burnout And Your Meat Computer - Electromagnetic Field 2018](https://www.youtube.com/watch?v=gcYRhATiyO4) - 杰西卡·罗斯.
* [Cultivating Compassionate Tech Communities - AnxietyTech 2018](https://www.youtube.com/watch?v=4COZk8IjbJs) - 由 April Wensel 撰写.
* [Debugging Our Feelings: Cognitive Behavioural Therapy For Developers - Peers Conference 2018](https://vimeo.com/253833709) - 杰米斯特拉坎.
* [Developers And Depression - Codeland NYC 2017](https://www.youtube.com/watch?v=us4w6lBV30Y) - 格雷格·鲍格 (Greg Baugues).
* [Developers, Entrepreneurs And Depression - Business Of Software 2015](https://www.youtube.com/watch?v=zUQjZZJjKsY) - 格雷格·鲍格 (Greg Baugues).
* [Emotional Intelligence For Engineers - ngAtlanta 2018](https://www.youtube.com/watch?v=SJnVhkEx8Cs) - 由 April Wensel 撰写.
* [Fight Tech With Tech - AnxietyTech 2018](https://www.youtube.com/watch?v=DDka7_Yaaw4) - 帕梅拉福克斯.
* [Getting Therapy To Those Who Need It Most - AnxietyTech 2018](https://www.youtube.com/watch?v=O4AWH5o1NVk) - 肖恩·克恩斯.
* [Hacking With My Anxiety - AnxietyTech 2018](https://www.youtube.com/watch?v=8tB6Eo8iJ70) - 布莱恩休斯.
* [Hitting The Wall And How To Get Up Again - Tackling Burnout And Strategies For Self Care - PyCon Australia 2016](https://www.youtube.com/watch?v=Rdc06jpjVIY) - 杰克逊费尔柴尔德.
* [Howto: Not Get A Burnout - PowerShell Conference EU 2018](https://www.youtube.com/watch?v=0MjqMlkA3gs) - 杰夫沃特斯.
* [Imposter Syndrome - PyCon Australia 2016](https://www.youtube.com/watch?v=hNlLM0OUXDc) - 比安卡吉布森.
* [It's Dangerous To Go Alone: Battling The Invisible Monsters In Tech - PyCon 2014](https://www.youtube.com/watch?v=1i8ylq4j_EY) - 朱莉·帕加诺 (Julie Pagano).
* [It's Darkest Before Dawn: Alcoholism And Addiction In Tech - DjangoCon US 2016](https://www.youtube.com/watch?v=lyVHKTGjivo) - 蒂莫西·艾伦.
* [Living With Bipolar Disorder As A Software Engineer - AnxietyTech 2018](https://www.youtube.com/watch?v=Jv9HdGwulE0) - 珍娜十五.
* [Looking After Your Mental Health, A Guide For Software Developers - PHP Yorkshire 2018](https://www.youtube.com/watch?v=ITY3RAg_PW0) - 马克·雷尔顿.
* [Mental Health In Development - PyCon Australia 2016](https://www.youtube.com/watch?v=P4wWbHvNAvY) - Eloise Macdonald-Meyer 着.
* [Modern Mindfulness - Hey! 2016](https://www.youtube.com/watch?v=Dc2JkIXfx8I) - 乔贝尔.
* [Programmers Don't Like People...Or Do They? - Node.js Interactive 2018](https://www.youtube.com/watch?v=HPFuHS6aPhw) - 由 April Wensel 撰写.
* [Self Care: Avoiding Burnout - AnxietyTech 2018](https://www.youtube.com/watch?v=P4eR419RgVc) - 谢米卡·拉马尔 (Shemika Lamare).
* [Stress & Depression, A Taboo In Our Time - GOTO 2017](https://www.youtube.com/watch?v=jGG6Wip_PGg) - Gitte Klitgaard 着.
* [Stronger Than Fear: Mental Health In The Developer Community - ElixirDaze 2017](https://www.youtube.com/watch?v=7CoEDFOXJQo) - 埃德芬克勒.
* [Successful, Accomplished, Depressed: A Talk About Performance, Perfectionism, And Burnout In IT - WeAreDevelopers 2018](https://www.youtube.com/watch?v=C84h5e9cOZY) - 丹尼斯·特劳布.
* [The Evolution Of VR Therapy - AnxietyTech 2018](https://www.youtube.com/watch?v=qdddeZfzrus) - 跳过里佐.
* [The Mental Impact of Tech Interviews - Abstractions II](https://www.youtube.com/watch?v=smS1PxK5qK4) ([Slides](https://docs.google.com/presentation/d/e/2PACX-1vRuuiXy4yk7B56kqCyYOxqKD1PRm5qVTEIg9FFlnTMLnNsrag6yzxnLgZFHjaFb6WbXLa60w4ci91xR/pub?start=false&loop=false&delayms=3000&slide=id.g44670d1eb8_0_13)) - 扎克·兹罗特尼克 (Zack Zlotnik).
* [The Never Ending Hack Mental Health In InfoSec Community - Circle City Con 5.0](https://www.youtube.com/watch?v=CWHfIdG0nOw) - 丹尼·阿卡基 (Danny Akacki).
* [UX Of Wearables In Clinical Treatment For PTSD - AnxietyTech 2018](https://www.youtube.com/watch?v=Ru58976R0Gw) - 吴艾达.
* [VR Mental Health Startup: Idea To Reality - AnxietyTech 2018](https://www.youtube.com/watch?v=6fmT_MBcoTY) - 乔纳森·索克尔 (Jonathan Sockell).
* [Why We Need Innovation In Mental Health Tech - AnxietyTech 2018](https://www.youtube.com/watch?v=whYGza42F5U) - 所罗门·提贝布 (Solomon Tibebu).

## Contributing

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg)](https://github.com/dreamingechoes/awesome-mental-health/blob/master/CODE_OF_CONDUCT.md)

请参见 [CONTRIBUTING](https://github.com/dreamingechoes/awesome-mental-health/blob/master/.github/CONTRIBUTING.md) 有关如何建议很棒的资源或对列表进行其他修改的更多详细信息. 您还可以找到按字母顺序排列的此存储库贡献者列表 [here](https://github.com/dreamingechoes/awesome-mental-health/blob/master/CONTRIBUTORS.md).

所有贡献者都应遵守 [Code of Conduct](https://github.com/dreamingechoes/awesome-mental-health/blob/master/CODE_OF_CONDUCT.md) 的项目.  （贡献者盟约）

----------------------------

这个项目是由 [dreamingechoes](https://github.com/dreamingechoes).
