<div class="github-widget" data-repo="mdbootstrap/awesome-mdbootstrap"></div>

> A curated list of the best resources in the MDBootstrap community.

[MDBootstrap](https://github.com/mdbootstrap/mdb-ui-kit) is a set of slick, responsive page templates, layouts, components, and widgets to rapidly build web pages.



## Resources

Official projects and resources of MDBootstrap.

Free

- [MDB Standard Free](https://mdbootstrap.com/docs/standard/) - Free to download, open-source Bootstrap 5 UI Kit.
- [MDB Angular Free](https://mdbootstrap.com/docs/angular/) - Bootstrap 5 & Angular 11 Free UI KIT with Material Design.
- [MDB React Free](https://mdbootstrap.com/docs/react/) - Bootstrap 5 & React 17 Free UI KIT with Material Design.
- [MDB Vue Free](https://mdbootstrap.com/docs/vue/) - Bootstrap 5 & Vue 3 Free UI KIT with Material Design.

Pro

- [MDB Standard Pro](https://mdbootstrap.com/docs/standard/pro/) - Premium UI Kit for the latest Bootstrap 5. Lifetime usage of 5000+ premium components, thousands of templates, plugins, design blocks.
- [MDB Angular Pro](https://mdbootstrap.com/docs/angular/pro/) - Material Design for Bootstrap 5 with Angular.
- [MDB React Pro](https://mdbootstrap.com/docs/react/pro/) - Material Design for Bootstrap 5 with React.
- [MDB Vue Pro](https://mdbootstrap.com/docs/vue/pro/) - Material Design for Bootstrap 5 with Vue.


## Community

- [Snippets](https://mdbootstrap.com/snippets/?tag=community) - Projects created with MDBootstrap.
- [Support](https://mdbootstrap.com/support/) - Place where you can solve your technical problems.

## Useful Links

Official projects and resources of MDBootstrap.

- [Snippets](https://mdbootstrap.com/snippets/) - Best source of Bootstrap code examples & plugins.
- [LAB](https://mdbootstrap.com/docs/standard/lab/) - Inspirational concepts & experiments created by the community of MDB.
- [UI/UX Tips](https://mdbootstrap.com/docs/standard/customization/ui-ux-tips/) - Quick and easy-to-implement tips to improve your design.
- [Services](https://mdbootstrap.com/services/) - We incorporate all of them in our own products, so our developers are uniquely experienced with these tools. We also use a variety of other solutions.
- [Visual Studio Code snippets](https://github.com/mdbootstrap/MDB-VSCode-snippets) - An extension that allows you to add useful snippets of the most popular MDB 5 components to Visual Studio Code.
- [Angular Visual Studio Code snippets](https://github.com/mdbootstrap/mdb-angular-vscode-snippets) - This extension adds snippets for MDB Angular - Angular Bootstrap UI KIT.
- [Webpack starter](https://github.com/mdbootstrap/mdb-webpack-starter) - This guide describes in detail the capabilities of Webpack Starter.
- [Reviews](https://www.g2.com/products/material-design-for-bootstrap/reviews) - User feedback on mdbootstrap.

## Articles

Contribute to the community and share your technical knowledge - or just read the articles written by others.

- [Technology comparision](https://mdbootstrap.com/docs/technology-comparison/) - What will be the best JavaScript framework in 2022?
- [Articles](https://mdbootstrap.com/articles/) - Contribute to the community and share your technical knowledge - or just read the articles written by others.

## Rankings

- [UI Kits & Themes](https://mdbootstrap.com/publications/ui-kits/) - Bootstrap, Angular, React, Vue UI Kits.
- [Free Bootstrap Templates & Themes](https://mdbootstrap.com/publications/free-templates/) - Stunning, Responsive Material Design Themes.
- [Premium Bootstrap Templates & Themes](https://mdbootstrap.com/publications/templates/) - Blog, Portfolio, eCommerce, Magazine, Admin Angular & React & Vue Templates.
- [Backend Bootstrap Templates & Themes](https://mdbootstrap.com/publications/backend/) - Jamstack, PHP, MySQL, Python, NodeJS, Tailwind, Laravel Backend Integrations UI Kits.

## Tools

Tools and utilities to help build apps using MDBootstrap.

- [Logo generator](https://mdbootstrap.com/docs/standard/tools/design/logo-generator/) - Create an elegant and stylish logo in 5 minutes.
- [CSS Masks & Glassmorphism Generator](https://mdbootstrap.com/docs/standard/tools/design/masks/) - Generate the perfect masks for your design.
- [Instagram filters CSS generator](https://mdbootstrap.com/docs/standard/tools/design/instagram-filters/) - Use famous Instagram filters via CSS and apply them to your project.
- [CSS gradients generator](https://mdbootstrap.com/docs/standard/tools/design/gradients/) - Generate the perfect gradient for your design.
- [Fancy border radius generator](https://mdbootstrap.com/docs/standard/tools/design/fancy-border-radius/) - Generate unusual shapes with our border-radius generator.
- [Meta tags generator](https://mdbootstrap.com/docs/standard/tools/builders/meta-tags/) - Take care of your SEO generate the most accurate meta data for Google and social media.
- [Cards generator](https://mdbootstrap.com/docs/standard/tools/builders/cards/) - Create bootstrap cards with custom shapes, buttons, colors, sizes.
- [Buttons generator](https://mdbootstrap.com/docs/standard/tools/builders/buttons/) - Create bootstrap buttons with custom icons, text, shapes, colors, sizes.
- [Charts creator](https://mdbootstrap.com/docs/standard/tools/builders/charts/) - Easy to use chart builder (pie charts, line charts, bar charts).
- [Shadows generator](https://mdbootstrap.com/docs/standard/tools/design/shadows/) - Generate the perfect shadow for your design.
- [SVG waves generator](https://mdbootstrap.com/docs/standard/tools/design/waves/) - Easily generate beautiful SVG shapes and apply them to your design.
- [Datatables builder](https://mdbootstrap.com/docs/standard/tools/builders/datatables/) - Create an elegant and stylish logo in 5 minutes.
- [Alerts generator](https://mdbootstrap.com/docs/standard/tools/builders/alerts/) - Create bootstrap alerts with custom shapes, buttons, colors, sizes.
- [Modals generator](https://mdbootstrap.com/docs/standard/tools/builders/modals/) - Create bootstrap modals with custom shapes, sizes, animations.
- [Icons generator](https://mdbootstrap.com/docs/standard/tools/builders/icons/) - 1600+ icons. Create bootstrap icons custom with sizes, colors, animations.
- [Table generator](https://mdbootstrap.com/docs/standard/tools/builders/table/) - Create bootstrap table custom with sizes, colors, animations.
- [Flexbox generator](https://mdbootstrap.com/docs/standard/tools/builders/flexbox/) - The easiest and fastest way to create and test flexbox in Bootstrap 5.
- [Footer generator](https://mdbootstrap.com/docs/standard/tools/builders/footer/) - Create bootstrap footer with custom coprytight, buttons, forms, links colors, sizes.
- [Navbar generator](https://mdbootstrap.com/docs/standard/tools/builders/navbar/) - Create bootstrap navbar with custom colors, brand, icons, forms, placement.

## Data Grid

Extend your projects functionality with a table component

- [GetDataDen](https://getdataden.com/) - The ultimate customizable Data Grid
- [Advanced data structure](https://getdataden.com/docs/grid/features/data-loader/#client-side-data-example) - The latest and most advanced data structure allows customizing each column (sort, width, resize, field) and matches values from each row to a column in which the `field` equals a given key value.
- [Draggable columns](https://getdataden.com/docs/grid/features/drag-and-drop/#basic-section) - Experience seamless interactivity with our draggable columns feature. Effortlessly rearrange your data grid to suit your workflow, ensuring optimal organization and efficiency. Just click, drag, and drop to customize your data display exactly as you need.
- [Pagination](https://getdataden.com/docs/grid/features/pagination/#basic-section) - Explore efficient data navigation with our pagination example. Learn to seamlessly handle large datasets by integrating simple, intuitive pagination controls.
- [Column search](https://getdataden.com/docs/grid/features/filtering/header-filters/#basic-section) - Discover the power of quick data retrieval with our search column feature. Easily locate the information you need within your DataDen grids for a more streamlined and productive data management experience.
- [Cell formatting](https://getdataden.com/docs/grid/layout/custom-css/#cell-formatting-section) - Enhance your data grid with our versatile cell formatting options. Tailor each cell's appearance for clarity and impact, using colors, fonts, and styles that make your data speak volumes. Perfect for highlighting critical insights and personalizing your data view
- [Compact version](https://getdataden.com/docs/grid/layout/custom-css/) - Unlock the full potential of your data grid with advanced CSS customization. Style every aspect to match your brand or personal preference, from colors and fonts to layouts. Create a visually cohesive and highly functional data interface with ease.


## CLI & hosting

Powerful tool which allows you to create different projects. No more difficult configuration and deployment.

- [MDB CLI](https://mdbgo.com/) - Create, deploy and host your project with a single command.
- [Quick Start](https://mdbgo.com/docs/getting-started/quick-start/) - Get started with MDB CLI easily and quickly and how to use its full potential.
- [Getting Started](https://mdbgo.com/docs/getting-started/installation/) - Step by step on how to create your project and deploy.
- [Overview](https://mdbgo.com/docs/getting-started/overview/) - Guide which will take you on how to perform different actions.

## TW Elements useful links (Tailwind CSS)

An open-source collection of components, templates and plugins for Tailwind CSS. Easily customizable & optimized for performance.

- [UI Kit](https://tw-elements.com/) - Bootstrap components recreated with Tailwind CSS, but with better design and more functionalities

[TW Elements integrations](https://tw-elements.com/docs/standard/integrations/) with popular technologies.

- [Django Integration](https://tw-elements.com/docs/standard/integrations/django-integration/)
- [Angular Integration](https://tw-elements.com/docs/standard/integrations/angular-integration/)
- [Express Integration](https://tw-elements.com/docs/standard/integrations/express-integration/)
- [Laravel Integration](https://tw-elements.com/docs/standard/integrations/laravel-integration/)
- [Next Integration](https://tw-elements.com/docs/standard/integrations/next-integration/)
- [Nuxt Integration](https://tw-elements.com/docs/standard/integrations/nuxt-integration/)
- [Django Integration](https://tw-elements.com/docs/standard/integrations/react-integration/)
- [Remix Integration](https://tw-elements.com/docs/standard/integrations/remix-integration/)
- [Solid Integration](https://tw-elements.com/docs/standard/integrations/solid-integration/)
- [Svelte Integration](https://tw-elements.com/docs/standard/integrations/svelte-integration/)
- [Sveltekit Integration](https://tw-elements.com/docs/standard/integrations/sveltekit-integration/)
- [Vue Integration](https://tw-elements.com/docs/standard/integrations/vue-integration/)


## Education

Well-organized, up-to-date series of tutorials for the latest Bootstrap, Material Design, HTML, CSS, JavaScript.

- [Video Tutorials](https://www.youtube.com/channel/UC5CF7mLQZhvx8O5GODZAhdA)
- [Written Tutorials](https://mdbootstrap.com/learn/mdb-foundations/basics/introduction/)
