<div class="github-widget" data-repo="nadunindunil/awesome-material-ui"></div>
[<p align="center"><img src="https://raw.githubusercontent.com/nadunindunil/awesome-material-ui/master/material-ui-logo.svg" height=300></p>](https://material-ui.com/)

<h1 align="center">Awesome Material-UI</h1>

[<p align="center"><img src="https://awesome.re/badge.svg" height=20></p>](https://raw.githubusercontent.com/sindresorhus/awesome)

[Material-UI](https://material-ui.com/) is a React components library for faster and easier web development. It follows [Material Design](https://material.io/design/introduction/) from Google.



## Resources

Official projects and resources of Material-UI Design.

- [Material-UI](https://material-ui.com/) - React components for faster and easier web development. Build your own design system, or start with Material Design.

## Articles

- [Getting started with Material-UI](https://medium.com/codingthesmartway-com-blog/getting-started-with-material-ui-for-react-material-design-for-react-364b2688b555) - How to setup and use Material-UI in your React web application.
- [How to autogenerate forms in React and Material-UI with MSON](https://medium.com/free-code-camp/how-to-autogenerate-forms-in-react-and-material-ui-with-mson-5771b1b7e739) - A guide to auto generate forms using JSON in Material-UI.
- [Let's Create a COVID-19 Tracker using React.js](https://towardsdatascience.com/lets-create-a-covid-19-tracker-using-react-js-5a3a0265a633) - A guide to develop covid 19 tracker application using Material-UI
- [Serverless Material UI contact form](https://medium.com/design-bootcamp/serverless-material-ui-contact-form-55296e107609) - A guide to develop Material-UI contact form
- [Embed Medium as a blog on your React Website — Part 2](https://medium.com/datadriveninvestor/embed-medium-as-a-blog-on-your-react-website-part-2-187db2b60a59) - A guide to embed medium as a blog on your react website using Material-UI

## Tools

These are tools and utilities to help build apps using Material-UI Design.

- [Material-UI Snippets](https://marketplace.visualstudio.com/items?itemName=vscodeshift.material-ui-snippets) - VSCode extension providing snippets.
- [Material-UI Codemorphs](https://marketplace.visualstudio.com/items?itemName=vscodeshift.material-ui-codemorphs) - VSCode extension providing codemods.

## Theming

Here are utilities that can help you customize your theme and ability to change it in browser.

- [Create Material-UI Theme](https://github.com/react-theming/create-mui-theme) - Online tool for creating Material-UI themes via Material Design Color Tool.
- [Material-UI Theme Generator](https://cimdalli.github.io/mui-theme-generator/) - Material-UI theme/palette generator.
- [Material-UI Theme Editor](https://in-your-saas.github.io/material-ui-theme-editor/) - A tool to generate themes for your Material-UI applications by just selecting the colors and having a live preview.

## Related Projects

Material-UI Design family of projects.

- [material-ui-theme-editor](https://in-your-saas.github.io/material-ui-theme-editor/) - A tool to generate themes for your Material UI applications that features live previewing.
- [Material palette generator](https://m2.material.io/inline-tools/color/) - The official Material Design palette generator can be used to generate a palette for any color you choose.
- [Components Extra](https://github.com/alexandre-lelain/components-extra) - Provides a set of "molecule" components built on top of Material-UI such as a Footer, a CookiesBanner, a BackToTop button and other complex elements highly customizable to help developers build the macro parts of their UI very quickly. Those components are often duplicated across sites - this library solves this exact problem.
- [React Admin](https://marmelab.com/react-admin/) - A frontend Framework for building admin applications running in the browser, on top of REST/GraphQL APIs, using ES6, React and Material Design.
- [Material UI Snippets](https://marketplace.visualstudio.com/items?itemName=vscodeshift.material-ui-snippets) - VSCode extension providing snippets.
- [Material UI Codemorphs](https://marketplace.visualstudio.com/items?itemName=vscodeshift.material-ui-codemorphs) - VSCode extension providing codemods.
- [Eslint: detect unused classes](https://github.com/jens-ox/eslint-plugin-material-ui-unused-classes) - ESLint plugin to detect unused styling classes with `@mui/styles`.

## Components

A list of UI components built with Material-UI Design.

- [Material-UI Chip Input](https://github.com/TeamWertarbyte/material-ui-chip-input) - Material-UI chip input inspired by Angular Material chip input.
- [Material-UI Password field](https://github.com/TeamWertarbyte/material-ui-password-field) - A password field using Material-UI.
- [Fullscreen Dialog](https://github.com/TeamWertarbyte/material-ui-fullscreen-dialog) - A fullscreen dialog for Material-UI.
- [Material-UI Upload](https://github.com/corpix/material-ui-upload) - Upload controls made in Material-UI using FileAPI.
- [Super Select Field](https://github.com/Sharlaan/material-ui-superselectfield) - Multi-selection autocomplete dropdown component for Material-UI.
- [Material JSON Schema Form](https://github.com/nadunindunil/material-jsonschema-form) - Material-UI form generated from json.
- [Notistack](https://github.com/iamhosseindhv/notistack) - Easy snackbars for Material-UI (so you don't have to deal with open/close state of them).
- [Material-UI Dropzone](https://github.com/Yuvaleros/material-ui-dropzone) - Material-UI component built on top of react-dropzone.
- [Formik-Material-UI](https://github.com/stackworx/formik-material-ui) - Bindings for using Material-UI with formik.
- [Redux-Form-Material-UI](https://github.com/erikras/redux-form-material-ui) - Wrapper components to facilitate using Material-UI with Redux Form.
- [Final-Form-Material-UI](https://github.com/Deadly0/final-form-material-ui) - Wrapper components to facilitate using Material-UI with Final Form.
- [Material-UI Auto Rotating Carousel](https://mui.wertarbyte.com/#material-auto-rotating-carousel) - Material style carousel.
- [Material-UI Image](https://mui.wertarbyte.com/#material-ui-image) - Material style image with loading animation.
- [Material-UI Flat Pagination](https://github.com/szmslab/material-ui-flat-pagination) - A flat design pagination component for Material-UI.
- [Dx-react-scheduler-Material-UI](https://devexpress.github.io/devextreme-reactive/react/scheduler/) - A scheduler/calendar component for Material-UI.
- [Dx-react-chart-Material-UI](https://devexpress.github.io/devextreme-reactive/react/chart/) - Charts for Material-UI that visualizes data using a variety of series types, including bar, line, area, scatter, pie, and more.
- [Material-UI Medium Blog](https://github.com/sabesansathananthan/material-ui-medium-blog) - Extended Material-UI Card component to show the Medium blogs.
- [React Github Repo Cards](https://github.com/sabesansathananthan/react-github-repo-cards) - Extended Material-UI Card component to show the GitHub repositories.
- [React molecule-components](https://github.com/alexandre-lelain/components-extra) - React molecule-components based on Material-UI.
- [Material-UI NestedMenuItem](https://github.com/azmenak/material-ui-nested-menu-item) - Drop-in replacement for MUI's MenuItem with infinitely nested menus, and open on hover.
- [React-planet](https://github.com/innFactory/react-planet) - Create circular menus which looks like planets.
- [MUI Phone Input](https://github.com/typesnippet/mui-phone-input) - Advanced, highly customizable phone input component for Material UI.
- [mui-treasury](https://github.com/siriwatknp/mui-treasury) - A collection of ready-to-use components based on Material-UI.

## Applications

A list of mature apps built with Material-UI Design.

- [Bethesda.net](https://bethesda.net/) - The official site for Bethesda, publisher of Fallout, DOOM, Dishonored, Skyrim, Wolfenstein, The Elder Scrolls, more.
- [TagSpaces](https://www.tagspaces.org/) - An offline, open source, file manager.
- [Builder Book](https://builderbook.org/) - Books that teach you how to build full stack, production-ready web apps.
- [NPM registry browser](https://topheman.github.io/npm-registry-browser/) - An open source web app that lets you search the npm registry and browse packages details.
- [Serverless Permission Policy Generator](https://github.com/Open-SL/serverless-permission-generator) - An Online Application to generate AWS IAM permissions required for deploying a Serverless stack.

## Boilerplates

A list of starter projects and boilerplates built with Material-UI Design.

- [Create React App example (mui-org/material-ui)](https://github.com/mui-org/material-ui/tree/master/examples/create-react-app) - Create React App example from official Material-UI repo.
- [Create-react-app-material-ui](https://github.com/katopz/create-react-app-material-ui) - Simple Create React App with Material-UI form submit example.
- [React-materialui-boilerplate](https://github.com/syedabuthahirm/react-materialui-boilerplate) - A starter kit for react and Material-UI.
- [Gatsby-starter-material-ui](https://github.com/nareshbhatia/gatsby-starter-material-ui) - A starter template for Gatsby using Material-UI.
- [Saas](https://github.com/async-labs/saas) - Boilerplate for building your own SaaS product; built with TypeScript, React, Express, Material-UI.
- [Create-react-app-material-typescript-redux](https://github.com/innFactory/create-react-app-material-typescript-redux) - A ready to use boilerplate for starting big react projects.

## Contributing

Your contributions are always welcome! [Click Here to read the guidelines](https://github.com/nadunindunil/awesome-material-ui/blob/master/contributing.md).
