<div class="github-widget" data-repo="hyperupcall/awesome-mastodon"></div>
## Awesome Mastodon [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) <!-- omit from toc -->

[<img src="https://raw.githubusercontent.com/hyperupcall/awesome-mastodon/master/./assets/mastodon-logo.svg?sanitize=true" align="right" width="150">](https://joinmastodon.org/)

Mastodon is the world's largest free, open-source, decentralized microblogging network.

This list is a collection of the best Mastodon resources.



## Official

- [GitHub Repository](https://github.com/tootsuite/mastodon/)
- [Documentation & Help Center](https://docs.joinmastodon.org/)
- [API Documentation](https://docs.joinmastodon.org/client/intro/)

## Instances

- [Official Instance List](https://joinmastodon.org/servers) - Official List of Mastodon instances.
- [mastodonservers.net Instance List](https://mastodonservers.net/) - Larger list of Mastodon instances.
- [instances.social Instance List](https://instances.social/list/) - Autogenerated list of Mastodon instances.
- [mastodon.social](https://mastodon.social/about/) - The largest Mastodon server with over 333k active users and 1.5m registered users.
- [EU Server](https://social.network.europa.eu/about/) - The official server for EU institutions.
- [Vivaldi Social](https://social.vivaldi.net/about/) - Mastodon social hosted by Vivaldi.
- [Mozilla Social](https://mozilla.social/about/) - Mastodon social hosted by Mozilla.
- [Journa.host](https://journa.host/about/) - Mastodon server for journalists.
- [Newsie](https://newsie.social/about/) - Another Mastodon server for journalists.
- [Bots in Space](https://botsin.space/about/) - Mastodon server for bot accounts.

## Statistics

- [The Federation](https://the-federation.info/) - Statistics on protocols, users, and nodes of the Fediverse.
- [FediDB](https://fedidb.org/network/) - Fediverse network statistics.
- [FediBuzz](https://fedi.buzz/) - Observe trends across the Fediverse.
- [Fediverse Graph Visualization](https://www.comeetie.fr/galerie/mapstodon/) - Graph visualization of all complete Fediverse.
- [MastoInstance.Info](https://mastoinstance.info/) - View instance metadata and explore the federation graph.
- [fediverse.party](https://fediverse.party/) - Detailed information about the most popular Fediverse projects and protocols.

## People

- [Academics On Mastodon](https://github.com/nathanlesage/academics-on-mastodon/) - Markdown list of academics on Mastodon, by discipline/group/area.
- [Spreadsheet of Popular accounts](https://docs.google.com/spreadsheets/d/1cpUKkoT1MUn8_xM4usiERn-IdEuh0hXfBrwbbThwGiI/edit#gid=1111869705/) - Google spreadsheet of the most popular Mastodon accounts of the Fediverse.
- [Spreadsheet of Journalist accounts](https://docs.google.com/spreadsheets/d/13No4yxY-oFrN8PigC2jBWXreFCHWwVRTftwP6HcREtA/edit#gid=1320898902/) - Google spreadsheet of various journalists of the Fediverse.

## Tools

- [Toot Scheduler](https://scheduler.mastodon.tools/) - Schedule toots to "toot" later.
- [Mastodon List Manager](https://www.mastodonlistmanager.org/main/) - Create, manager, filter, and search lists of your selected Mastodon users.
- [Mastodon Toot Bookmarklet](https://rknightuk.github.io/mastodon-toot-bookmarklet/) - Bookmarklet to toot the current page.
- [Mastodon - Simplified Federation!](https://addons.mozilla.org/firefox/addon/mastodon-simplified-federation/) - Redirect clicks on remote follow/interaction buttons to your own instance.
- [Mastodon Link](https://github.com/masrly/mastodon-link/) - Adds Mastodon icon links by profile to make following people on other instances easier.
- [Mastodon Redirector](https://github.com/bramus/mastodon-redirector/) - Adds a button to view profiles from other instances on your profile page.
- [mastotool](https://github.com/muesli/mastotool/) - Collection of command-line tools for working with Mastodon accounts.
- [Mastodon Widgets](https://github.com/splitbrain/mastodon-widget) - JavaScript Web Components to embed a Mastodon profile, timeline, follow and share button into any website. Provides an auto-completing instance selector.

## Desktop Clients

- [Official Client List](https://joinmastodon.org/apps/) - Official list of Mastodon clients.
- [Elk](https://github.com/elk-zone/elk/) - Nimble Mastodon web client.
- [Brutaldon](https://gitlab.com/brutaldon/brutaldon/) - A brutalist, web 1.0 client Mastodon/Pleroma.
- [phanpy](https://github.com/cheeaun/phanpy) - A minimalistic, but opinionated, Mastodon web client.
- [Planiverse](https://git.mulligrubs.me/planiverse/) - Minimalist, no-JS Web client for Mastodon.
- [Official Client](https://github.com/mastodon/mastodon-android/) - Official Android client.
- [Whalebird](https://whalebird.social/en/desktop/contents/) - Electron-based Mastodon client.
- [toot](https://github.com/ihabunek/toot/) - TUI/CLI Mastodon client using Python.
- [Tokodon](https://apps.kde.org/tokodon/) - Mastodon client made by KDE.

## Mobile Clients

- [Megalodon](https://sk22.github.io/megalodon/) - Fork of the official Android client.
- [Fedilab](https://codeberg.org/tom79/Fedilab/) - Fully-featured Android client.
- [Tusky](https://github.com/tuskyapp/Tusky/) - Intuitive Android client.
- [Ivory](https://apps.apple.com/us/app/ivory-for-mastodon-by-tapbots/id6444602274) - Mastodon client for iOS, by the creators of Tweetbot.
- [Toot!](https://apps.apple.com/us/app/toot/id1229021451) - Mastodon client for iOS.
- [SwiftUI](https://github.com/Dimillian/IceCubesApp) - Mastodon client for iOS using SwiftUI.

## Libraries

- [Official Library List](https://docs.joinmastodon.org/client/libraries/) - Official list of Mastodon client libraries.
- [masto.js](https://github.com/neet/masto.js) - Mastodon client for JavaScript.
- [go-mastodon](https://github.com/mattn/go-mastodon) - Mastodon Client for golang.

## Servers

- [Glitch Edition](https://glitch-soc.github.io/docs/) - Mastodon Fork with local posting, toot formatting, improved settings, and more granulate controls.
- [Hometown](https://github.com/hometown-fork/hometown/) - Mastodon Fork with local posting, following lists, customizable max toos length.
- [ecko](https://github.com/magicstone-dev/ecko/) - Mastodon fork with local posting, toot formatting, and more granulate controls.

## Guides

- [What is Mastodon? (Official Video)](https://www.youtube.com/watch?v=IPSbNdBmWKE) - What is Mastodon? (Official Video).
- [A Beginner's Guide to Mastodon](https://buffer.com/resources/mastodon-social) - A Beginner's Guide to Mastodon.
- [Fedi.Tips](https://fedi.tips) - An unofficial guide to Mastodon and the Fediverse.

## Hosting

- [Official Hosting Documentation](https://docs.joinmastodon.org/user/run-your-own) - Official page with introduction and list of hosting providers.
- [Masto.host](https://masto.host) - Fully managed Mastodon hosting.
- [toot.io](https://toot.io/mastodon_hosting.html) - Managed Mastodon Hosting, used by ACM, Microsoft Dynamics, etc.
- [Cloudplane](https://cloudplane.org) - Fully manged hosting for open-source apps.
- [elestio](https://elest.io/open-source/mastodon) - Fully-managed Mastodon hosting.

## Similar Projects

- [aether](https://getaether.net) - Peer-to-peer ephemeral public communications.
- [Pleroma](https://pleroma.social/) - Lightweight microblogging platform.
- [GNU social](https://gnusocial.rocks/) - Oldest microblogging platform.
- [Microblog.pub](https://microblog.pub/) - Single-user lightweight microblogging platform.
- [Hubzilla](https://zotlabs.org/page/hubzilla/hubzilla-project/) - Blog/social networks platform with file, contacts and events sharing.
- [Friendica](https://friendi.ca/) - Social network platform.
- [Peertube](https://joinpeertube.org/) - Video sharing platform.
- [FunkWhale](https://funkwhale.audio/) - Audio sharing platform.
- [Plume](https://joinplu.me/) - Blogging platform.
- [WriteFreely](https://writefreely.org/) - Blogging platform.
- [PixelFed](https://pixelfed.org/) - Photograph sharing platform.
- [Misskey Hub](https://misskey-hub.net/en/) - Interplanetary microblogging platform.
- [Lemmy](https://join-lemmy.org/) - Link aggregation platform.
- [Kbin](https://kbin.social) - Link aggregation platform.

## Bots

- [feed2toot](https://gitlab.com/chaica/feed2toot) - Automatically parses RSS feeds, identifies new posts and posts them on Mastodon (Python).
- [aerialbot](https://github.com/doersino/aerialbot) - Respond with geotagged aerial imagery of a random location in the world.
- [rust-trending](https://github.com/pbzweihander/rust-trending) - Post trending Rust repositories on Mastodon (inspired by TrendingGithub).
- [@TrendingBot@mastodon.social](https://mastodon.social/@TrendingBot) - Shows you what's trending on Mastodon.
- [News Bot](https://botsin.space/@newsbot) - Mirrors Twitter accounts on Mastodon (ClojureScript), source available on [GitHub](https://github.com/yogthos/mastodon-bot).
- [@HackerNewsBot@mastodon.social](https://mastodon.social/@HackerNewsBot) - Post Hacker News posts with over 100 upvotes.
- [@launchradar@mastodon.cloud](https://mastodon.cloud/@launchradar) - News about space flight, astronomy and astrophysics.
