<div class="github-widget" data-repo="BubuAnabelas/awesome-markdown"></div>
## Awesome Markdown [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

<img src="https://upload.wikimedia.org/wikipedia/commons/4/48/Markdown-mark.svg" align="right" width="208">

&gt; 精选的令人愉快的 Markdown 内容列表.

 Markdown 是 John Gruber 与 Aaron Swartz 合作创建的一种标记语言. 它旨在轻松转换为 HTML，并已扩展为不同类型的实现.

<!--lint disable no-emphasis-as-heading-->

_请阅读 [contribution guidelines](https://github.com/BubuAnabelas/awesome-markdown/blob/master/.github/contributing.md) 在贡献之前._

<!--lint enable no-emphasis-as-heading-->

:gem: 表示 **真的_awesome/useful_**.<br />
![Globe][globe] 表示 **它是 _webapp/webservice_**.<br />
![Android OS][android-os] 表示**在 _Android_** 上运行.<br />
![iOS Logo][ios-logo] 表示**在 _iOS_** 上运行.<br />
![Mac OS X][macosx] 表示**在 _macOS_** 上运行.<br />
![Linux][linux] 表示**在 _Linux_** 上运行.<br />
![Windows][windows] 表示**在 _Windows_** 上运行.<br />

<!--lint disable no-paragraph-content-indent-->

<!--lint disable alphabetize-lists-->


- [Awesome Markdown ![Awesome](https://github.com/sindresorhus/awesome)](#awesome-markdown-awesomehttpsgithubcomsindresorhusawesome)

---

<!--lint enable alphabetize-lists-->

<!--lint enable no-paragraph-content-indent-->

## CMS / Blogs

&gt; 默认支持 Markdown 的 CMS 或博客.

- [Ghost](https://blog.ghost.org/markdown/) - 专业博主的发布平台.
- [Grav](https://getgrav.org/) - Modern Flat-File CMS.
- [Hexo](https://hexo.io/) - 一个快速、简单和强大的博客框架
- [Hugo](https://gohugo.io/) - 快速和现代的静态网站引擎.
- [Jekyll](https://jekyllrb.com/) - 将您的纯文本转换为静态网站和博客.
- [Pelican](https://blog.getpelican.com/) - 不需要数据库或服务器端逻辑的静态站点生成器.
- [Svbtle](https://svbtle.com/) - 旨在帮助您思考的博客平台.
- [Vuepress](https://vuepress.vuejs.org/) - 简约的 Vue 驱动的静态站点生成器.
- [Laravel CommonMark Blog](https://github.com/spekulatius/laravel-commonmark-blog)  - 与 Laravel 一起使用的静态生成器. 利用 CommonMark 和 FrontMatter 并直接发布到“公共”文件夹中.

## Libraries

&gt; 用于呈现 Markdown 文档的库.

### C

- [cmark](https://github.com/commonmark/cmark) - C语言的CommonMark解析和渲染库和程序.
- [Hoedown](https://github.com/hoedown/hoedown) - C 中符合标准、快速、安全的 Markdown 处理库（Sundown 分支）.
- [peg-markdown](https://github.com/jgm/peg-markdown) - 使用 PEG 语法在 C 中实现 Markdown.
- [Sundown](https://github.com/vmg/sundown) - C 中符合标准、快速、安全的 Markdown 处理库.

### Java

- [commonmark-java](https://github.com/atlassian/commonmark-java) - CommonMark 的 Java 实现，Markdown 格式的规范.
- [flexmark-java](https://github.com/vsch/flexmark-java) - 带有源代码级 AST 的 Markdown 解析器的 Java 实现.
- [pegdown](https://github.com/sirthias/pegdown) - 基于支持大量扩展的 parboiled PEG 解析器的纯 Java Markdown 处理器.

### JavaScript

- [markdown-it](https://github.com/markdown-it/markdown-it)  - Markdown 解析器，做对了.  100% CommonMark 支持、扩展、语法插件和高速.
- [markdown-js](https://github.com/evilstreak/markdown-js) - 另一个 Markdown 解析器，这次是针对 JavaScript 的.
- [marked](https://github.com/markedjs/marked)  - 全功能的 Markdown 解析器和编译器，用 JavaScript 编写. 专为速度而生.
- [mmarkdown](https://github.com/albinotonnina/mmarkdown) - 解释 markdown 文件中的 mmd 防护代码块并生成它的更酷版本.
- [Showdown](https://github.com/showdownjs/showdown) - Showdown 是一个 JavaScript Markdown 到 HTML 转换器，基于 John Gruber 的原创作品.
- [Snarkdown](https://github.com/developit/snarkdown) - Snarkdown 是一个非常简单的 1kb Markdown 解析器.

### Perl

- [Markdown.pl](https://daringfireball.net/projects/downloads/Markdown_1.0.1.zip) :gem: _John Gruber 的原始 Markdown 库._

### PHP

- [commonmark](https://github.com/thephpleague/commonmark) - 高度可扩展的 PHP Markdown 解析器，完全支持 CommonMark 和 GFM 规范.
- [parsedown](https://github.com/erusev/parsedown) - PHP 中更好的 Markdown 解析器.
- [php-markdown](https://github.com/michelf/php-markdown) - Markdown 和 Markdown Extra 的解析器源自 John Gruber 的原始 Markdown.pl.

### Python

- [markdown-it-py](https://github.com/executablebooks/markdown-it-py)  - Markdown 解析器，做对了.  100% CommonMark 支持、扩展、语法插件和高速. 现在在 Python 中！
- [markdown2](https://github.com/trentm/python-markdown2) - 在 Python 中快速完整地实现 Markdown.
- [Mistune](https://github.com/lepture/mistune) - 具有渲染器功能的纯 Python 中最快的 Markdown 解析器.
- [PyMdown Extensions](https://facelessuser.github.io/pymdown-extensions/) - Python Markdown 的扩展集合.
- [Python-Markdown](https://github.com/Python-Markdown/markdown) - John Gruber 的 Markdown 的 Python 实现.

### Ruby

- [kramdown](https://github.com/gettalong/kramdown) - kramdown 是一个快速、纯 Ruby Markdown 超集转换器，使用严格的语法定义并支持几个常见的扩展.
- [Redcarpet](https://github.com/vmg/redcarpet) - Redcarpet 是一个用于 Markdown 处理的 Ruby 库，闻起来像蝴蝶和爆米花.

## Tools

### Converters

&gt; 将 Markdown 转换为其他格式，反之亦然.

- [csvtomd](https://github.com/mplewis/csvtomd)  - 将您的 CSV 文件转换为 Markdown 表格.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Dimer Markdown](https://github.com/dimerapp/markdown) - 将 Markdown 转换为 HTML 或 JSON ![Globe][globe] ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [HTML To Markdown for PHP](https://github.com/thephpleague/html-to-markdown) - 使用 PHP 将 HTML 转换为 Markdown.
- [markdown-pdf](https://github.com/alanshaw/markdown-pdf) - 降价到 PDF 转换器.
- [Markdown to PDF](https://www.markdowntopdf.com/)  - 将 Markdown 转换为 PDF 的简单实用的网站.  ![地球仪][地球仪]
- [Pandoc](https://pandoc.org/)  - 通用文档转换器.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Torsimany](https://github.com/PolBaladas/torsimany)  - 将与格式无关的 JSON 转换为时尚的、人类可读的 Markdown.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [turndown](https://github.com/domchristie/turndown) - 用 Ja​​vaScript 编写的 HTML 到 Markdown 转换器.
- [yamp](https://github.com/angrykoala/yamp)  - 易于使用的 cli 工具箱，用于 markdown 相关任务.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [clipboard2markdown](https://euangoddard.github.io/clipboard2markdown/)  - 粘贴内容并获得降价版本的网站. 适用于任何带有 JavaScript 的现代浏览器.

### Editors

&gt; 编辑并保存您的 Markdown 文档.

- [Abricotine](https://abricotine.brrd.fr/)  - 使用 Electron 构建的轻量级降价编辑器，内置实时预览.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Caret](https://caret.io/)  - 适用于 Mac 和 PC 的 Markdown 编辑器.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [iA Writer](https://ia.net/writer)  - iA Writer 专为在 Mac OS、iOS 和 Android 上提供最佳写作体验而设计.  :gem: _真正简单的编辑器！_ ![Android OS][android-os] ![iOS Logo][ios-logo] ![Mac OS X][macosx]
- [Let's Markdown!](https://letsmarkdown.com)  - 基于 Rust 构建的在线实时协作降价编辑器.  ![地球仪][地球仪]
- [Markdownify](https://markdownify.js.org)  - 一个最小的 Markdown 编辑器桌面应用程序.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [MarkRight](https://github.com/dvcrn/markright)  - 简约的 github 风格的 Markdown 编辑器.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Mark Text](https://github.com/marktext/marktext/)  - 下一代 Markdown 编辑器（使用 Electron 构建）.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [PileMd](https://pilemd.com/)  - 降价笔记应用程序.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [StackEdit](https://stackedit.io/)  - 浏览器内降价编辑器.  ![地球仪][地球仪]
- [TOAST UI Editor](https://ui.toast.com/tui-editor/) - 可扩展的 GFM Markdown 所见即所得编辑器！[Globe][globe]
- [Typora](https://typora.io/)  - 一个最小的 Markdown 编辑器.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Notable](https://notable.md/)  - 基于 Markdown 的笔记应用程序，不吸.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Boostnote](https://boostnote.io/)  - 开发人员的降价编辑器.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Trilium Notes](https://github.com/zadam/trilium)  - 专注于建立大型个人知识库的分层笔记应用程序.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Joplin](https://joplinapp.org/)  - 具有同步功能的开源笔记和待办事项应用程序.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows] ![iOS Logo][ios-logo] ![Android OS][android-os]
- [Visual Studio Code](https://code.visualstudio.com/)  - 一个开源代码编辑器，内置 markdown 预览和许多 markdown 扩展.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Quiver](http://happenapps.com/)  - 专为程序员打造的笔记本.  ![Mac OS X][macosx] ![iOS 徽标][ios-徽标]
- [Bear](https://bear.app/)  - 一个漂亮、灵活的写作应用程序，用于制作笔记和散文.  ![Mac OS X][macosx] ![iOS 徽标][ios-徽标]
- [Obsidian](https://obsidian.md/) - 支持美人鱼的笔记本编辑器！[Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Bangle.io](https://bangle.io/)  - 一个像笔记 webapp 这样的概念，其中数据以 Markdown 格式保存在本地.  ![地球仪][地球仪]

### Linters

&gt; 标记并标准化您的 Markdown 文档.

- [Markdown Lint Tool](https://github.com/markdownlint/markdownlint) - 检查 Markdown 文件和标记样式问题的工具.
- [Markdownlint](https://github.com/igorshubovych/markdownlint-cli) - 用于 Markdown/CommonMark 文件的 Node.js 样式检查器和 lint 工具.
- [remark-lint](https://github.com/remarkjs/remark-lint) - Markdown 代码样式 linter.
- [textlint](https://textlint.github.io/) - 用于文本和降价的可插入 linting 工具.
- [markdownlint](https://github.com/DavidAnson/vscode-markdownlint) - Visual Studio Code 的 Markdown linting 和样式检查.

### Miscellaneous

&gt; 可让您编辑、转换、导出 _et al._ Markdown 文档的工具.

- [Dillinger](https://dillinger.io/)  - Dillinger 是一个支持云、移动就绪、离线存储、AngularJS 支持的 HTML5 Markdown 编辑器.  ![地球仪][地球仪]
- [GitDown](https://github.com/gajus/gitdown)  – GitHub 的 Markdown 预处理器.  ：章鱼：
- [HackMD](https://hackmd.io)  - HackMD 可让您在所有平台上创建实时协作 Markdown 笔记.  ![地球仪][地球仪]
- [Laverna](https://laverna.cc/)  - Laverna 是一个 JavaScript 笔记应用程序，具有 Markdown 编辑器和加密支持.  :gem: _带加密的 Markdown 笔记！_ ![Globe][globe] ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Markable.in](https://markable.in/)  - 卓越的 Markdown 编辑器.  ![地球仪][地球仪]
- [markcat](https://github.com/BubuAnabelas/markcat)  - Markdown 文件终端查看器.  :gem: _`cat` with Markdown highlight._ ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [Markdown Magic](https://github.com/DavidWells/markdown-magic) - 自动格式化 markdown 文件并同步外部文档/src 代码
- [Markdown Tables Generator](https://www.tablesgenerator.com/markdown_tables)  - 具有 CSV 导入支持的 Visual Markdown 表格生成器.  ![地球仪][地球仪]
- [mdformat](https://github.com/executablebooks/mdformat) - 兼容 CommonMark 的 Markdown 格式化程序 ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]
- [remark](https://remark.js.org/) - 由插件驱动的 Markdown 处理器
- [Socrates](https://socrates.io/)  - 无服务实时 Markdown 编辑器和查看器，类似 etherpad.  ![地球仪][地球仪]
- [termd](https://github.com/dephraiim/termd)  - 带有语法高亮显示的终端的 Markdown 渲染器.  ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]


### Presentations

&gt; 使用 Markdown 创建和编辑幻灯片演示文稿.

- [gitpitch](https://github.com/gitpitch/gitpitch/)  - GitHub、GitLab、Bitbucket、GitBucket、Gitea 和 Gogs 上面向所有人的 Markdown 演示.  ![地球仪][地球仪]
- [hacker-slides](https://github.com/msoedov/hacker-slides)  - 用于从降价构建演示幻灯片的最小 UI.  ![Mac OS X][macosx] ![Linux][linux]
- [Marp](https://marp.app/)  - Markdown 演示生态系统.  :gem: _CLI、Web、IDE 插件等，可将 Markdown 转换为各种格式_ ![Mac OS][macosx] ![Linux][linux] ![Windows][windows]
- [mdp](https://github.com/visit1985/mdp)  - 基于命令行的 Markdown 演示工具.  :gem: _像 PowerPoint 和 Vim 但带有 Markdown！_ ![Mac OS X][macosx] ![Linux][linux]
- [remark](https://remarkjs.com)  - 一个简单的、浏览器内、Markdown 驱动的幻灯片放映工具，针对了解 HTML 和 CSS 的人.  ![地球仪][地球仪]
- [reveal.js](https://revealjs.com) - 支持 Markdown 的开源 HTML 演示框架 ![Mac OS X][macosx] ![Linux][linux] ![Windows][windows]

## Services

&gt; 利用 Markdown 的不同服务.

- [Daux.io](https://daux.io) - Daux.io 是一个文档生成器，它使用简单的文件夹结构和 Markdown 文件来动态创建自定义文档.
- [Dimer](https://dimerapp.com/)  - Dimer 从 Markdown 生成一个干净漂亮的文档网站.  ![地球仪][地球仪]
- [GitBook](https://www.gitbook.com/?t=1)  - GitBook 是一个现代出版工具链. 使写作和协作变得容易.
- [GitPrint](https://gitprint.com/)  - 轻松打印 GitHub Markdown.  ![地球仪][地球仪]

## Resources

### Documentation

&gt; 有关 Markdown 的文档和有用信息.

- [CommonMark](https://commonmark.org/) - 强定义、高度兼容的 Markdown 规范.
- [GitHub Flavored Markdown Specifications](https://github.github.com/gfm/) - GitHub Markdown 的正式规范，基于 CommonMark.
- [Original Specifications](https://daringfireball.net/projects/markdown/) :gem: _开始使用 Markdown 的地方！_
- [Pandoc’s Markdown](https://pandoc.org/MANUAL.html#pandocs-markdown) - [Pandoc](https://pandoc.org/) has its own, powerful markdown implementation. It consists of several addional extensions.
- [ScholarlyMarkdown](http://scholarlymarkdown.com/) - ScholarlyMarkdown 是学术和学术交流的语法/标准/最佳实践，它首先是网络，其次是语义 XML，其次是 LaTeX/Word.
- [Stack Overflow Markdown Documentation (archived)](https://web.archive.org/web/20160724152503/https://stackoverflow.com/documentation/markdown/topics) - 组织良好的 Markdown 文档.
- [Stack Overflow Markdown Questions](https://stackoverflow.com/questions/tagged/markdown) - Stack Overflow 上投票最高的 Markdown 问题.
- [The text/markdown Media Type (RFC7763)](https://tools.ietf.org/html/rfc7763) - 本文档注册了 `text/markdown` 媒体类型以与 Markdown 一起使用，Markdown 是一系列纯文本格式语法.
- [Wikipedia Article](https://en.wikipedia.org/wiki/Markdown)

### Tutorials

&gt; 有用的链接和教程.

- [GitHub's Mastering Markdown](https://guides.github.com/features/mastering-markdown/)
- [how-to-markdown](https://github.com/workshopper/how-to-markdown) - 这位工作坊会教你如何使用 Markdown.
- [Interactive Markdown Tutorial](https://www.markdowntutorial.com/)
- [Markdown Cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet) :gem: _当你不记得语法时去哪里找！_
- [Markdown Guide](https://www.markdownguide.org) - 简明扼要的 Markdown 准系统指南.

---

_[Icon pack by Icons8](https://icons8.com)_

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Joaquín Serna](https://github.com/BubuAnabelas) 已放弃该作品的所有版权和相关或邻接权.

<!--Definitions-->

[地球仪]：https://img.icons8.com/color/24/globe.png &#39;地球仪&#39;
[android-os]: https://img.icons8.com/color/24/android-os.png &#39;安卓操作系统&#39;
[ios-logo]: https://img.icons8.com/color/24/ios-logo.png &#39;iOS 标志&#39;
[macosx]：https://img.icons8.com/color/24/mac-logo.png &#39;Mac OS X&#39;
[Linux]: https://img.icons8.com/color/24//linux--v1.png &#39;Linux&#39;
[窗户]：https://img.icons8.com/color/24/windows-11.png &#39;窗户&#39;
