<div class="github-widget" data-repo="sadcitizen/awesome-marionette"></div>
## Awesome Marionette.js [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; marionette.js 的资源列表

## General

- [Official site](http://marionettejs.com/)
- [Github repository](https://github.com/marionettejs/backbone.marionette)
- [Annotated source](http://marionettejs.com/annotated-src/backbone.marionette)
- [Marionette.js Blog](http://blog.marionettejs.com/)
- [StackOverflow](http://stackoverflow.com/questions/tagged/marionette) - 标记问题
- [Gitter chat](https://gitter.im/marionettejs/backbone.marionette)
- [Marionette Inspector](https://github.com/marionettejs/marionette.inspector)
- [Yeoman generator for Marionette.js](https://github.com/mrichard/generator-marionette)
- [Marionette CLI](https://github.com/denar90/marionette-cli)
- [MarionetteJS CLI package for atom](https://atom.io/packages/atom-marionettejs-cli)

## Tutorials and articles

- [A Thorough Introduction To Backbone.Marionette Part 1: Application](https://www.smashingmagazine.com/2013/02/introduction-backbone-marionette/)
- [A Thorough Introduction To Backbone.Marionette Part 2: Modules](https://www.smashingmagazine.com/2013/04/thorough-introduction-backbone-marionette-part-2-modules/)
- [A Thorough Introduction To Backbone.Marionette Part 3: Views](https://www.smashingmagazine.com/2014/06/thorough-introduction-backbone-marionette-part-3/)
- [A Simple Backbone.Marionette tutorial: Application. Simple List](http://davidsulc.com/blog/2012/05/06/tutorial-a-full-backbone-marionette-application-part-1/)
- [A Simple Backbone.Marionette tutorial: Application with Interactions](http://davidsulc.com/blog/2012/04/22/a-simple-backbone-marionette-tutorial-part-2/)
- [A Visual Guide To Marionette.js Views](http://www.artandlogic.com/blog/2013/03/a-visual-guide-to-marionette-js-views/) 通过马特贝乔
- [Representing Marionette.js Views With State](http://www.artandlogic.com/blog/2013/06/representing-marionette-js-views-with-state/) 通过马特贝乔
- [The Case for Marionette.js](http://benmccormick.org/2014/12/02/the-case-for-marionette-js/)
- [Connecting Data to Your Views](http://benmccormick.org/2014/12/10/marionette-explained-connecting-your-data-to-your-views/)
- [Building Complex Layouts with Marionette.js](http://benmccormick.org/2014/12/22/building-complex-layouts-with-marionette-js/)
- [The Life of a Marionette View](http://benmccormick.org/2015/01/05/marionette-view-life-cycles/)
- [Building Modular Web Apps with Backbone.Radio](http://benmccormick.org/2015/01/26/backbone-radio/)
- [From Backbone.js to Marionette.js (Russian)](http://habrahabr.ru/post/207730/) - 玛农奇克
- [Marionette.js Behaviors, Part 1: The Basics](https://spin.atomicobject.com/2014/09/11/marionette-behaviors-overview/)
- [Marionette.js Behaviors, Part 2: Testing Behaviors](https://spin.atomicobject.com/2014/09/12/testing-marionette-js-behaviors/)
- [Things I Learned from Building a Large Scale Backbone + Marionette Application](http://authenticff.com/journal/building-large-scale-backbone-marionette-applications) 通过伊恩·威廉姆斯
- [Design Rules in a Backbone-Marionette App](http://cloudandcode.tumblr.com/post/98671637921/design-rules-in-a-backbone-marionette-app)
- [A Short Primer on Marionette.js](http://cloudandcode.tumblr.com/post/98265035816/a-short-primer-on-marionette-js)
- [Pimping Backbone with Marionette](http://scm.io/blog/hack/2014/09/backbone-marionette/) 通过汤姆赫罗德
- [Handling Forms with Marionette.js](http://spin.atomicobject.com/2013/11/25/forms-marionette-js-backbone/) 阿尔·斯科特
- [Nested Views in Backbone.Marionette](http://blog.mojotech.com/nested-views-in-backbone-marionette/) 通过山姆·萨科内
- [DRY up Your Views in Backbone Marionette](http://blog.mojotech.com/dry-up-your-views-in-backbone-marionette/) 通过山姆·萨科内
- [Strengthening Our Backbone with Marionette (Part I)](http://tech.kinja.com/strengthening-our-backbone-with-marionette-part-i-1583630931)
- [Tutorial: Nested Views Using Backbone Marionette's CompositeView](http://davidsulc.com/blog/2013/02/03/tutorial-nested-views-using-backbone-marionettes-compositeview/) 这是大卫苏尔克
- [Components with Backbone.js and Marionette.js](http://blog.jeremyfairbank.com/javascript/components-with-backbone-js-and-marionette-js/) 杰里米·费尔班克
- [Managing Layouts and Nested Views with Backbone.Marionette](http://lostechies.com/derickbailey/2012/03/22/managing-layouts-and-nested-views-with-backbone-marionette/) 通过德里克贝利
- [Revisiting the Backbone Event Aggregator: Lessons Learned](http://lostechies.com/derickbailey/2012/04/03/revisiting-the-backbone-event-aggregator-lessons-learned/) 通过德里克贝利
- [Why Should I Use Backbone.Marionette Instead of … ?](http://lostechies.com/derickbailey/2012/06/13/why-should-i-use-backbone-marionette-instead-of-%E2%80%A6/) 通过德里克贝利
- [Polymer Web Components with Marionette.js](http://blog.jeremyfairbank.com/javascript/polymer-web-components-with-marionette-js/) 杰里米·费尔班克
- [Building a Marionette App with Flux Architecture](http://iamnotarealprogrammer.com/flux-architecture-in-a-backbone-and-marionette-app/) 通过柯蒂斯肯普尔
- [Marionette-Service: Service Objects for Marionette](http://benmccormick.org/2015/05/25/marionette-service-service-objects-for-marionette/) 通过本·麦考密克
- [Refactoring a JavaScript Application to Use Microservices: What We Learned with Backbone and Marionette](https://www.safaribooksonline.com/blog/2015/11/24/refactoring-javascript-microservice-backbone-marionette/) 通过帕夏克雷登 
- [SEO-Enabling Your Marionette App](https://docs.google.com/presentation/d/1jy9SXyr6ZjbY7lOSKN8QraH96-vR7mnAo0ePvzDb8uc/pub?start=false&loop=false&delayms=3000&slide=id.p)

## Books

- [Building Backbone Plugins](https://leanpub.com/building-backbone-plugins) 德里克·贝利和杰罗姆·格拉维尔-尼奎特
- [Backbone.Marionette.js: A Gentle Introduction](https://leanpub.com/marionette-gentle-introduction) 通过大卫苏尔克
- [Structuring Backbone Code with RequireJS and Marionette Modules](https://leanpub.com/structuring-backbone-with-requirejs-and-marionette) 通过大卫苏尔克
- [Marionette Exposé](https://leanpub.com/marionetteexpose) 通过杰克基利利亚
- [Backbone.Marionette.js: A Serious Progression](https://leanpub.com/marionette-serious-progression) 通过大卫苏尔克
- [Getting Started with Backbone Marionette](http://www.amazon.com/dp/1783284250/) 雷蒙德和亚瑟·索托
- [Marionette Guides](https://www.gitbook.com/book/marionette/marionette-guides/details)
- [Better Backbone Applications with MarionetteJS](https://shop.smashingmagazine.com/products/better-backbone-applications-with-marionettejs)

## Videos

- [Dancing with Marionette](https://www.youtube.com/channel/UC6dVRPnSACav2AYB5XG7BZw) - YouTube 频道
- [Backbone.js with Derick Bailey](https://www.youtube.com/watch?v=VERQEr-bVTs) 通过德里克贝利
- [The Tools and Patterns for Building Large-Scale Backbone Applications](https://www.youtube.com/watch?v=qWr7x9wk6_c) 通过布赖恩·曼
- [Episode 03 of BackboneRails Screencast](https://www.youtube.com/watch?v=KT31H3Ayliw) 通过布赖恩·曼
- [Backbone Marionette and Require.js](https://www.youtube.com/watch?v=4K4JKtAGPu4) 丹尼尔·库西诺
- [Backbone's Rarely Enough: An Introduction to Backbone Marionette](https://www.youtube.com/watch?v=fZJMF4SOKm4) 通过伦·史密斯
- [Unsuck Your Backbone](http://www.youtube.com/watch?v=0o2whtCJw8I) 通过艾米·帕拉芒廷
- [Building Modular and Component Driven Architecture in Backbone.js and Marionette.js](https://www.youtube.com/watch?v=PrQSpdWkN6Q) 杰里米·费尔班克 [Slides](http://presentboldly.com/jfairbank/modular-and-component-driven-architecture-in-marionettejs/)
- [Marionette: The Backbone Framework from BackboneConf 2014](https://www.youtube.com/watch?v=EvQnntaqVdE&index=13&list=PLlgxAbM67lYIGw8DnANC7VgREbzJRQged) 詹姆斯·史密斯
- [Building Beautiful Apps with Marionette](https://www.youtube.com/watch?v=7yZKsgKxziw)
- [Nesting Your Views in Marionette](https://www.youtube.com/watch?v=CTr-tTwRH3o)
- [Marionette Behaviors](https://www.youtube.com/watch?v=6wvAswHkarE)
- [Backbone.Wreqr](https://www.youtube.com/watch?v=2b1G3TdlQEU)
- [Jason Laster - Backbone Under the Magnifying Glass Tools for Exploring and Debugging Your Apps](https://www.youtube.com/watch?v=jbGm3mJXh_s)
- [Browserify + Marionette = Better Apps](https://www.youtube.com/watch?v=7bGWuyuLK_4)
- [Using DevTools for Marionette Debugging](https://www.youtube.com/watch?v=75d0odmbu38)
- [Routing Made Better](https://www.youtube.com/watch?v=F32QhaHFn1k)
- [View and Application State](https://www.youtube.com/watch?v=FCUS6RrhRtI)

## Examples and boilerplates

- [Marionette Require Boilerplate](https://github.com/BoilerplateMVC/Marionette-Require-Boilerplate)
- [Marionette Contact Manager](https://github.com/dmytroyarmak/marionette-contact-manager) - 继续开发“Backbone Contact Manager”，但使用 Marionette.js
- [Marionette, Require, and Gulp.js Boilerplate](https://github.com/jroeckle/Marionette-Require-Gulpjs-Boilerplate) - 一个最初基于“Marionette Require Boilerplate”的轻量级样板项目，使用 Gulp.js 集成而不是 Grunt.js
- [MarionetteJS + RequireJS + Twitter Bootstrap](https://github.com/ajaxray/marionette-boilerplate)  - 让我们开始跳舞吧！ 这个样板是一个准备好的设置，可以在几分钟内启动你的下一个很棒的 javascript 应用程序
- [Marionette Gentle Introduction](https://github.com/davidsulc/marionette-gentle-introduction)
- [Marionette Wires](https://github.com/thejameskyle/marionette-wires)
- [Marionette Cookbook](https://github.com/MarionetteLabs/marionette-cookbook)
- [MarionetteJS + Brunch + Babel/ES6](https://github.com/denar90/brunch-with-marionettejs)
- [A Place to Write About Technical Subjects on the Web](https://github.com/jmeas/gistbook)
- [The Front End App for edit.sx](https://github.com/samccone/edit.sx-frontend)
- [Streamus](https://github.com/MeoMix/StreamusChromeExtension)
- [Marionette-Integrations](https://github.com/marionettejs/marionette-integrations) - 使用多种不同资产管理工具的木偶应用程序示例
- [ES6 Marionette Project](https://github.com/abiee/es6-marionette)
- [Todo List](https://github.com/tastejs/todomvc/tree/master/examples/backbone_marionette) - TodoMVC 示例
- [Webpack-Marionette](https://github.com/alexpsi/webpack-marionette) 一个向 Marionette/Backbone 应用程序介绍 webpack 和 es6 功能的小样板，包含一个可编辑 Cookbook 的示例 CRUD 应用程序.


## Libraries

- [Marionette State](https://github.com/Squareknot/marionette.state)
- [Marionette Virtual Dom](https://github.com/tiagorg/marionette-vdom)
- [Marionette Form View](https://github.com/viverae/marionette.formview)
- [A Better Router for Backbone and Marionette Applications](https://github.com/Betterment/backbone.blazer)
- [Marionette.Toolkit](https://github.com/RoundingWellOS/marionette.toolkit) - 一系列自以为是的 Backbone.Marionette 扩展，适用于大规模应用程序架构.
- [Orchestra](https://github.com/BedeGaming/orchestra) - 客户端应用编排框架
