<div class="github-widget" data-repo="Karneades/awesome-malware-persistence"></div>
## Awesome Malware Persistence [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome)

> A curated list of awesome malware persistence tools and resources.

Malware persistence consists of techniques that adversaries use to keep access to systems across restarts, changed credentials, and other interruptions that could cut off their access. Techniques used for persistence include any access, action, or configuration changes that let them maintain their foothold on systems, such as replacing or hijacking legitimate code or adding startup code.

[Main article about malware persistence](https://github.com/Karneades/malware-persistence/blob/master/README.md) with more context and information.



## Techniques

_Persistence techniques and detection._

### Generic

* [MITRE ATT&CK tactic "TA0003 - Persistence"](https://attack.mitre.org/tactics/TA0003/) - MITRE ATT&CK tactic "TA0003 - Persistence".
* [forensic artifact repository](https://github.com/ForensicArtifacts/artifacts) - Forensic artifact repository covers persistence techniques in their artifacts.
* [Sigma rules](https://github.com/Neo23x0/sigma/tree/master/rules) - Sigma rules which covers persistence techniques. You can even use filters such as `--filter tag=attack.persistence` or specifically for one technique `tag=attack.t1084`.

### Linux

* [Linux Malware Persistence with Cron](https://www.sandflysecurity.com/blog/linux-malware-persistence-with-cron/) - Blog post about linux persistence using cron jobs.
* [Linux Persistence Techniques](https://research.splunk.com/stories/linux_persistence_techniques/) - List of persistence techniques.
* [Linux Red Team Persistence Techniques](https://www.linode.com/docs/guides/linux-red-team-persistence-techniques/) - List of persistence techniques.
* [PANIX - Persistence Against *NIX - Features](https://github.com/Aegrah/PANIX?tab=readme-ov-file#features) - List of persistence techniques.
* [Linux Detection Engineering -  A primer on persistence mechanisms](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms) - List of Linux persistence mechanisms.
* [ebpfkit](https://github.com/Gui774ume/ebpfkit) - Rootkit leveraging eBPF.
* [TripleCross](https://github.com/h3xduck/TripleCross) - Rootkit leveraging eBPF.
* [Linux LKM Persistence](https://righteousit.com/2024/11/18/linux-lkm-persistence/) - Rootkit leveraging Linux loadable kernel module (LKM).

### macOS

* [theevilbit's series "Beyond the good ol' LaunchAgents"](https://theevilbit.github.io/tags/beyond/) - List of macOS persistence beyond just the LaunchDaemons or LaunchAgents.
* [KnockKnock](https://github.com/objective-see/KnockKnock/blob/main/Plugins) - A persistence detection tool for macOS to scan for persistence mechanisms on macOS. Specific persistence locations are found in the [plugins](https://github.com/objective-see/KnockKnock/tree/main/Plugins) folder, e.g. [LaunchItems](https://github.com/objective-see/KnockKnock/blob/main/Plugins/LaunchItems.m#L21) or [StartupScripts](https://github.com/objective-see/KnockKnock/blob/main/Plugins/StartupScripts.m#L22).
* [PoisonApple](https://github.com/CyborgSecurity/PoisonApple/blob/master/poisonapple/techniques.py) - Learn about various macOS persistence techniques by looking at the source code of PoisonApple.
* [How malware persists on macOS](https://www.sentinelone.com/blog/how-malware-persists-on-macos/) - List of macOS persistence mechanisms.

### Windows

* [Hexacorn's blog](http://www.hexacorn.com/blog/category/autostart-persistence/) - Hexacorn's blog category for persistence category including the series "Beyond good ol' Run key".
* [Autoruns](https://docs.microsoft.com/en-us/sysinternals/downloads/autoruns) - You can learn which Windows persistence mechanisms are checked by looking at the output of Autoruns on your own client. Categories and the different locations where things were found are seen in the output. A disassembly of Autoruns lists a subset of the entries which are scanned.
* [PowerShell implementation of Autoruns](https://github.com/p0w3rsh3ll/AutoRuns/blob/master/AutoRuns.psm1) - Another way to find Windows persistence locations is to look at the source code of the PowerShell version of Autoruns. Bonus: A history of the covered persistence locations for each Autoruns version is found at the end of the module file too, which is so awesome!
* [Common malware persistence mechanisms](https://resources.infosecinstitute.com/common-malware-persistence-mechanisms/) - Different persistence mechanisms for different vectors are described.
* [Malware persistence techniques](https://www.andreafortuna.org/2017/07/06/malware-persistence-techniques/) - Good summary of multiple persistence mechanisms, ranging from multiple registry keys to more advanced one, like COM hijacking.
* [Detecting & Removing an Attacker's WMI Persistence](https://medium.com/threatpunter/detecting-removing-wmi-persistence-60ccbb7dff96) - Blog post about detecting and removing WMI persistence.
* [Windows Persistence using WinLogon](https://www.hackingarticles.in/windows-persistence-using-winlogon/) - Blog post about abusing WinLogon.
* [Untangling Kovter's persistence methods](https://blog.malwarebytes.com/threat-analysis/2016/07/untangling-kovter/) - Blog post about Kovter's persistens methos, among others, hiding in registry. Another one is [Threat Spotlight: Kovter Malware Fileless Persistence Mechanism](https://threatvector.cylance.com/en_us/home/threat-spotlight-kovter-malware-fileless-persistence-mechanism.html).
* [Persistence using GlobalFlags in Image File Execution Options – Hidden from Autoruns.exe](https://oddvar.moe/2018/04/10/persistence-using-globalflags-in-image-file-execution-options-hidden-from-autoruns-exe/) - Blog post about abusing GlobalFlag for process execution.
* [Uncovering a MyKings Variant With Bootloader Persistence via Managed Detection and Response](https://blog.trendmicro.com/trendlabs-security-intelligence/uncovering-a-mykings-variant-with-bootloader-persistence-via-managed-detection-and-response/) - Blog post about bootloader persistence.
* Various blog posts about COM/CLSID hijacking
  * [COM Object hijacking: the discreet way of persistence, 2014](https://www.gdatasoftware.com/blog/2014/10/23941-com-object-hijacking-the-discreet-way-of-persistence)
  * [Persistence – COM Hijacking, 2020](https://pentestlab.blog/2020/05/20/persistence-com-hijacking/)
  * [Abusing COM hijacking in combination with scheduled tasks, 2016](https://enigma0x3.net/2016/05/25/userland-persistence-with-scheduled-tasks-and-com-handler-hijacking/)
* [Hunting for persistence via Microsoft Exchange Server or Outlook](https://speakerdeck.com/heirhabarov/hunting-for-persistence-via-microsoft-exchange-server-or-outlook) - Blog post about Microsoft Exchange server persistence.

### Cloud

* [Shadow Linking: The Persistence Vector of SaaS Identity Threat](https://www.obsidiansecurity.com/blog/shadow-linking-the-persistence-vector-of-saas-identity-threat/) - Abuse of additional identity providers to persist in an environment.
* [Persisting on Entra ID applications and User Managed Identities with Federated Credentials](https://dirkjanm.io/persisting-with-federated-credentials-entra-apps-managed-identities/) - Persist on Entra ID applications and User Managed Identities with Federated Credentials.

### Firmware

* [MoonBounce: the dark side of UEFI firmware](https://securelist.com/moonbounce-the-dark-side-of-uefi-firmware/105468) - An in-depth write up about one particular UEFI bootkit.

## Persistence Removal

_Tools and commands for persistence mechanisms removal. Beside the tools mentioned below, use standard OS commands to remove the persistence._

### Generic
* [Awesome Incident Response](https://github.com/meirwah/awesome-incident-response) - Use the tools and resources for security incident response, aimed to help security analysts and DFIR teams.

### Windows

* [PowerSponse](https://github.com/swisscom/PowerSponse) - PowerSponse includes various commands for cleanup of persistence mechanisms.
* [Removing Backdoors – Powershell Empire Edition](https://www.n00py.io/2017/01/removing-backdoors-powershell-empire-edition/) - Various blog posts handle the removal of WMI implants.
* [RegDelNull](https://docs.microsoft.com/en-us/sysinternals/downloads/regdelnull) - Removal of registry keys with null bytes - used e.g. in run keys for evasion.

## Detection Testing

_Tools for testing detections. Use the techniques described in [Persistence Techniques](#persistence-techniques) to create these files or add the configuration changes by hand to test your detections._

### Generic

* [Atomic Red Team](https://github.com/redcanaryco/atomic-red-team) - Atomic Red Team supports also the MITRE ATT&CK persistence techniques, see e.g. [T1044 "File System Permissions Weakness"](https://github.com/redcanaryco/atomic-red-team/blob/master/atomics/T1044/T1044.yaml).

### Linux

* [PANIX](https://github.com/Aegrah/PANIX) - A highly customizable Linux persistence tool. Perform various persistence techniques against Linux systems, among others Debian and RHEL.
* [Diamorphine](https://github.com/m0nad/Diamorphine) -  A loadable kernel module (LKM) rootkit for Linux Kernels (x86/x86_64 and ARM64).

### macOS

* [PoisonApple](https://github.com/CyborgSecurity/PoisonApple) - Perform various persistence techniques on macOS.

### Windows

* [hasherezade persistence demos](https://github.com/hasherezade/persistence_demos) - Various (also non standard) persistence methods used by malware for testing own detection, among others COM hijacking demo is found in the repo.

## Prevention

_Tools for preventing malicious persistence._

### macOS

* [BlockBlock](https://github.com/objective-see/BlockBlock) - A tool which provides continual protection by monitoring persistence locations and protects them accordingly. Similar to KnockKnock but for blocking.

## Collection

_Tools for persistence collection._

### Generic

* [Awesome Forensics](https://github.com/Cugu/awesome-forensics) - Use the tools from this list which includes awesome free (mostly open source) forensic analysis tools and resources. They help collecting the persistence mechanisms at scale, e.g. by using remote forensics tools.
* [osquery](https://osquery.readthedocs.io) - Query persistence mechanisms on clients.
* [OSSEC](https://github.com/ossec/ossec-hids) - Use rules and logs from the HIDS to detection configuration changes.

### Linux

_There is no dedicated persistence collection tool for Linux I'm aware of. Use some of the tools from #General or standard OS commands for collection. Thanks for contributing links to Linux specific persistence collection tools._

* [Linux Security and Monitoring Scripts](https://github.com/sqall01/LSMS) - Security and monitoring scripts you can use to monitor your Linux installation for security-related events or for an investigation. Among other finding systemd unit files used for malware persistence.

### macOS

* [KnockKnock](https://www.objective-see.com/products/knockknock.html) - A tool to uncover persistently installed software in order to generically reveal such malware. See [GitHub repository too for the source code](https://github.com/objective-see/KnockKnock).
* [Dylib Hijack Scanner or DHS](https://www.objective-see.com/products/dhs.html) - A simple utility that will scan your computer for applications that are either susceptible to dylib hijacking or have been hijacked. See [GitHub repository too for the source code](https://github.com/objective-see/DylibHijackScanner).

### Windows

* [Autoruns](http://technet.microsoft.com/en-us/sysinternals/bb963902) - A powerful persistence collection tool on Windows is Autoruns. It collects different categories and persistence information from a live system and [in
  limited ways from offline images](https://www.sans.org/blog/offline-autoruns-revisited-auditing-malware-persistence/). There is a UI and a command line program and the output format can be set to CSV which can then be imported into your log collection system of choice.
* [AutorunsToWinEventLog.ps1](https://github.com/palantir/windows-event-forwarding/blob/master/AutorunsToWinEventLog/AutorunsToWinEventLog.ps1) - Instead of using CSV output and copy these file to the server, you can use the AutorunsToWinEventLog script to convert the Autoruns output to Windows event logs and rely on standard Windows event log forwarding.
* [PowerShell Autoruns](https://github.com/p0w3rsh3ll/AutoRuns) - A PowerShell version of Autoruns.
* [PersistenceSniper](https://github.com/last-byte/PersistenceSniper) - Powershell module to hunt for persistence implanted in Windows machines.
* [RegRipper](https://github.com/keydet89/RegRipper2.8) - Extracts various persistence mechanisms from the registry files directly.
* [RECmd](https://github.com/EricZimmerman/RECmd) - Extract various persistence mechanisms, e.g. by using the config file [UserClassesASEPs](https://github.com/EricZimmerman/RECmd/blob/master/BatchExamples/UserClassesASEPs.reb) to extract user's CLSID information.
* [KAPE](https://www.kroll.com/en/insights/publications/cyber/kroll-artifact-parser-extractor-kape) - The tool allows collecting various predefined artifactgs using targets and modules, see [KapeFiles](https://github.com/EricZimmerman/KapeFiles) which include persistence mechanisms, among others there's a collection of [LNK files](https://github.com/EricZimmerman/KapeFiles/blob/master/Targets/Windows/LNKFilesAndJumpLists.tkape), [scheduled task files](https://github.com/EricZimmerman/KapeFiles/blob/master/Targets/Windows/ScheduledTasks.tkape) and [scheduled task listing](https://github.com/EricZimmerman/KapeFiles/blob/master/Modules/LiveResponse/schtasks.mkape) or a [WMI repository auditing](https://github.com/EricZimmerman/KapeFiles/blob/master/Modules/LiveResponse/WMI-Repository-Auditing.mkape) module.

## Contributing

Contributions welcome! Read the [contribution guidelines](https://github.com/Karneades/awesome-malware-persistence/blob/master/CONTRIBUTING.md) first.
