<div class="github-widget" data-repo="unicodeveloper/awesome-lumen"></div>
## Awesome lumen [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) ![](https://img.shields.io/badge/unicodeveloper-approved-brightgreen.svg)

&gt; 精选资源列表：书籍、视频、关于使用 Lumen 的文章（Laravel 的 PHP 微框架）

*灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出事情. 你可能还喜欢 [awesome-tdd](https://github.com/unicodeveloper/awesome-tdd).*

*请阅读 [contribution guidelines](#guidelines) 在贡献之前.*

**看看我 [blog](https://goodheads.io) 或者说*嗨* [Twitter](https://twitter.com/unicodeveloper).**



## Essentials
* [Lumen Homepage](https://lumen.laravel.com/)
* [Documentation](https://lumen.laravel.com/docs/5.2) - 流明 5
* [GitHub Repository](https://github.com/laravel/lumen)

## Demos
 * [Lumen API demo](https://github.com/liyu001989/lumen-api-demo)

## Tutorials

### Written
* [Building a Micro Markdown API app with Lumen](http://www.sitepoint.com/building-micro-markdown-api-app-lumen/)
* [Lumen by Laravel - First tutorial](https://www.codetutorial.io/lumen-first-tutorial/)
* [Developing a web application with lumen and Mysql](http://loige.co/developing-a-web-application-with-lumen-and-mysql/)
* [Getting Started with Lumen](http://wern-ancheta.com/blog/2015/05/09/getting-started-with-lumen/)
* [Building a web app with Lumen Web Api and Oauth2 Authentication ](http://esbenp.github.io/2015/05/26/lumen-web-api-oauth-2-authentication/)
* [Build an API with Lumen and Fractal](http://laravelista.com/build-an-api-with-lumen-and-fractal/)
* [Developing a microservice with Lumen](http://goodheads.io/2015/06/19/developing-a-micro-service-with-lumen/)
* [Json Web token authentication for Lumen](https://laravelista.com/posts/json-web-token-authentication-for-lumen)
* [Creating Your First Artisan Command in Lumen 5.5](https://www.codementor.io/seyiadeleke42/creating-your-first-artisan-command-in-lumen-5-5-cvi59gmgl)

### Videos
* [Introducing Lumen by Taylor Otwell](https://laracasts.com/lessons/introducing-lumen)
* [Zero to API with Lumen](https://www.youtube.com/watch?v=ZetUes4lygA)
* [Building a Bookings API with Lumen](https://www.youtube.com/watch?v=oENnw5BxKvA)
* [Lumen 5.1 and Homestead of Laravel: Create a RESTful API](https://www.youtube.com/watch?v=BV7rmvPJZQk)
* [Building APIs with Lumen by Oz Brignoni](https://www.youtube.com/watch?v=br2O_WDXaKk)
* [Lumen Restful API and Homestead](https://www.udemy.com/lumen-restful-api-and-homestead-for-lumen-by-laravel-and-php/)


## Packages and Middleware
* [Lumen Cors](https://github.com/vluzrmos/lumen-cors) - 一个简单的流明 CORS
* [Alternative Lumen Cors](https://github.com/palanik/lumen-cors) - 用于 Lumen 微框架的 CORS 中间件
* [Phpspec Lumen](https://github.com/pmartelletti/phpspec-lumen) - 使用 phpspec 测试你的 Lumen 应用程序
* [Understand Lumen](https://github.com/understand/understand-lumen) - Understand.io 的 Laravel Lumen 服务提供商
* [Badge Poser](https://github.com/vluzrmos/laravel-badge-poser) - 流明徽章生成器
* [Cors Illuminate](https://github.com/neomerx/cors-illuminate) - 对 Laravel 和 Lumen 的 CORS（跨源资源共享）支持
* [Jwt Artisan](https://github.com/generationtux/jwt-artisan) - Laravel 和 Lumen 的 JWT 授权
* [Facebook SDK](https://github.com/SammyK/LaravelFacebookSdk) - Laravel 和 Lumen 的 Facebook SDK
* [Lumen Generators](https://github.com/webNeat/lumen-generators) - 用于 Lumen 和 Laravel 5 的生成器集合.
* [Dingo API](https://github.com/dingo/api) - 用于 Laravel 和 Lumen 框架的 RESTful API 包.
* [Lumen Tinker](https://github.com/vluzrmos/lumen-tinker) - Lumen 框架的交互式 shell
* [Lumen Maintenance Mode](https://github.com/rdehnhardt/lumen-maintenance-mode) - 定义流明应用程序维护模式
* [Lumen Vendor Publish](https://github.com/laravelista/lumen-vendor-publish) - 流明框架的供应商发布命令.
* [Lumen Make](https://github.com/michaelbonds/lumen-make) - 将大部分 make 命令从 Laravel 移植到 Lumen. 
* [Lumen File Manager](https://github.com/nordsoftware/lumen-file-manager) - 用于 Lumen PHP 框架的文件管理器模块.
* [Lumen 5.2 HTTP Basic Auth Guard](https://github.com/arubacao/http-basic-auth-guard) - 恢复 Lumen 5.2 的基本身份验证.
* [Larasupport](https://github.com/irazasyed/larasupport) - 为 Lumen 和其他助手添加 Laravel 包支持.
* [REST API With Lumen](https://github.com/hasib32/rest-api-with-lumen) - 用于 Lumen 微框架的 RESTful API 样板.
* [Lumen Passport](https://github.com/dusterio/lumen-passport) - 让 Laravel Passport 与 Lumen 一起工作.


## Made With Lumen
* [Slack Invitator](https://github.com/vluzrmos/lumen-slackin) - 使用 Lumen Framework 制作的 Slack Invitator
* [Email Microservice](https://github.com/rlacerda83/lumen-email-microservice) - 使用 Lumen 发送电子邮件的微服务
* [Lissandra](https://github.com/laravelista/Lissandra) - 使用 Lumen 构建的 Laracasts Feed API.
* [Lumen Solder](https://github.com/TechnicPack/LumenSolder) - 在 Laravel 的 Lumen 框架中实现 Solder.
* [Lumen Microservices Skeleton](https://github.com/FabrizioCafolla/microservice-lumen) - 带有 Docker 和 Lumen 的微服务的骨架结构

## Books
* [Writing APIs with Lumen](https://leanpub.com/lumen-apis)
* [Lumen Programming Guide: Writing PHP Microservices, REST and Web Service APIs](https://www.amazon.com/Lumen-Programming-Guide-Writing-Microservices/dp/1484221869/ref=sr_1_1?ie=UTF8&qid=1536504679&sr=8-1&keywords=lumen+programming)

## Community
* [StackOverflow](http://stackoverflow.com/questions/tagged/lumen)

## Tips
* 贡献一些 ;)


## Contributing
找到很棒的包、文章、博客、视频等？ 向我发送请求请求！ 只需遵循指南

#### Guidelines

* 确保您要添加的内容不在列表中
* 为每次添加单独提出拉取请求
* 使用格式：`* [Name](https://github.com/unicodeveloper/awesome-lumen/blob/master/Link) - 如果需要说明`
* 将其添加到该部分的底部，而不是顶部或中间
* 检查你的拼写和语法
* 随意创建或改进类别
* 确保没有尾随空格
* 最后，确保它很棒！


## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

本作品 (Awesome Lumen) 没有已知的版权限制.
