<div class="github-widget" data-repo="zenitysec/awesome-low-code"></div>
<div align="center">
	<img width="250" height="175" src="https://raw.githubusercontent.com/zenitysec/awesome-low-code/master/media/repo_logo.png" alt="Awesome Low Code">
	<br>
	<br>
	<hr>
	<p>
		<sup>Maintained by:</sup>
		<br>
		<br>
		<a href="https://www.zenity.io">
			<img src="https://raw.githubusercontent.com/zenitysec/awesome-low-code/master/media/zenity_logo.svg?sanitize=true"/>
		</a>
        <p>
        Secure and govern your Low Code No Code applications without disrupting the business
        </p>
	</p>
	<hr>
</div>

## Awesome Low Code [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of Awesome Low Code platforms, vendors, tools and resources.

> Low Code platforms provide a development and runtime environment used to create all kinds of software application through an intuitive experience, with minimal to no coding skills requires.

Contributions welcome! Please, read the [contribution guidelines](https://github.com/zenitysec/awesome-low-code/blob/master/contributing.md) first.



## Platforms

### Citizen Automation and Development Platform

A development platform for business users (citizen developer is a term for business users, not a role or a job title) that doesn't require coding skills and is based on intuitive drag & drop interfaces. Applications created in such platforms are usually made to automate or improve efficiency of business processes and of personal productivity, without going through IT. CADP are usually consumed as SaaS.

- [Power Automate (Microsoft)](https://flow.microsoft.com/) - An online workflow service that automates actions across the most common apps and services.
- [Zapier](https://zapier.com/) - Allows its users to easily connect and automate the apps they use.
- [Einstein Automate (Salesforce)](https://www.salesforce.com/products/platform/einstein-automate/) - Empower your employees to do more of what matters by automating business processes easily without needing specialized development skills.
- [Jira Automation (Atlassian)](https://www.atlassian.com/software/jira/features/automation) - Automation is a No Code rule builder that enables customers to build if-this-then-that-rules based on events in Jira.
- [Trello Power-Ups (Atlassian)](https://trello.com/power-ups/category/automation) - Helps teams meet their unique business needs through adaptable features and integrations.
- [Flow (Zoho)](https://www.zoho.com/flow/) - An integration platform that helps you connect your apps without any code.
- [FormNX](https://formnx.com) - A no-code platform that helps to create forms without coding for free. It also provides integration options with webhook, Mailchimp, and you can embed forms in your websites or web applications easily without any coding.

### Low Code Application Platform

An advanced development platform that enable organizations to create powerful enterprise grade applications with no to minimum extra coding requirements with easy to use drag & drop interfaces. Since such platforms simplify the application development process, more types of personas can contribute and accelerate the development process. Those platforms are PaaS development platforms, and can also reduce development cost and maintenance.
- [Tabidoo (https://tabidoo.cloud/) - Powerful Low Code platform, with mature workflows, rights management and integrations (REST API). Many predefined templates. No charge per user.
- [Power Apps (Microsoft)](https://powerapps.com/) - Build apps in hours—not months—that easily connect to data, use Excel-like expressions to add logic, and run on the web, iOS, and Android devices.
- [Power BI](https://powerbi.microsoft.com/) - Unify data from many sources to create interactive, immersive dashboards and reports that provide actionable insights and drive business results.
- [Appian](https://appian.com/) - Provides a Low Code software development platform that enables organizations to rapidly develop powerful applications.
- [Mendix](https://mendix.com/) - The fastest and easiest high-productivity platform to create and continuously improve multi-channel applications at scale.
- [OutSystems](https://www.outsystems.com/) - A Low Code platform that enables businesses to develop, deploy, and manage enterprise-grade apps.
- [Now Platform (ServiceNow)](https://www.servicenow.com/now-platform.html) - Build mission-critical apps quickly, with more creators and less complexity. Easily scale across the enterprise to deliver experiences users love.
- [Creator (Zoho)](https://www.zoho.com/creator/low-code-platform/) - Build applications from scratch without having to write endless lines of code.
- [BettyBlocks](https://www.bettyblocks.com/) - The #1 No Code platform for innovation, agility and empowerment. Used to create mobile, business and web applications at lightning speed.
- [APEX (Oracle)](https://apex.oracle.com/en/platform/low-code/) - A Low Code development platform that enables you to build scalable, secure enterprise apps, with world-class features, that can be deployed anywhere.
- [Salesforce Platform, prev. Force.com (Salesforce)](https://www.salesforce.com/products/platform) - Click, create, and ship from anywhere with Low Code.
- [n8n](https://n8n.io/) - Workflow automation tool with many integrations and with fair-code license.
- [Linx](https:/linx.software) - General-purpose low-code platform for building and hosting backends like APIs, automations and integrations.
- [DronaHQ](https://www.dronahq.com/?ref=github-gs) - Drag and drop low code platform to build internal apps for web as well as mobile.
- [ILLA Cloud](https://www.illacloud.com/) - A low-code platform for developers to build internal tools in minutes.
- [Loopple](https://www.loopple.com) - A low code drag and drop dashboard builder.
- [Appsheet (Google)](https://about.appsheet.com/home/) - Google AppSheet is a no-code development platform that enables users to create custom mobile and web applications without requiring extensive programming knowledge. It provides a drag-and-drop interface for building apps, and it can integrate with various data sources and APIs to automate workflows and improve productivity.
- [YepCode](https://yepcode.io) - All-in-one platform to connect APIs and services in a serverless environment working directly with JavaScript or Python. It allows the development, execution and monitoring of integration and automation processes.
- [DronaHQ](https://www.dronahq.com/) - DronaHQ - a low code platform helps engineering teams and product managers to build internal tools, custom user journeys, digital experiences, automations, custom admin panels, operational apps 10X faster.
- [REI3](https://rei3.de/en/home) - REI3 is an open low code application platform. It runs on almost any system, on-premise or in the cloud and is free to use for individuals and organizations.

### Business Process Management

A Low Code Application Platform dedicated to streamlining business processes. These platforms enable business users to automate complicated business workflows and actions with no coding background by providing an easy to use drag & drop interface. Automations that are built in such platforms are usually built in an event-driven mode (triggers) around critical business processes. BPA can be consumed via a SaaS or an on-premises appliance.

- [PegaSystems](https://www.pega.com/) - Provides business process and customer relationship management solutions for organizations.
- [AgilePoint](https://agilepoint.com/) - Deploy business-changing ideas in minutes, not months, with the AgilePoint digital process automation platform.
- [QuickBase](https://www.quickbase.com/) - Helps businesses quickly turn ideas about better ways to work into apps that make them more efficient, informed, and productive.
- [Creatio](https://www.creatio.com/) - A global software company providing a leading Low Code platform for process management and CRM.
- [AuraQuantic](https://www.auraquantic.com/) - A digital platform designed for business users to easily and rapidly build unlimited processes and applications.
- [Kintone](https://www.kintone.com/) - The best productivity software to business transformation Platform.
- [ProntoForms](https://www.prontoforms.com/) - Provides mobile business solutions to automate field sales, field service, and field data collection.
- [TrackVia](https://trackvia.com/) - The leading Low Code workflow platform for operations.
- [NewGen](https://newgensoft.com/) - Simplify your complex, content-driven business needs with one comprehensive Low Code platform.
- [Naologic](https://naologic.com/) - Productivity apps built by business users and process-driven professionals to simplify and automate complex processes.

### Robotic Process Automation

An automation platform that helps organizations remove human manual intensive processes and avoid errors, as well as making sure human required attention is efficiently maximized only on critical aspects of work. RPA technology introduced the concept of software robots, built by the end-user humans, to perform repetitive manual intensive processes in an automation fashion, and can understand and processes computer interactions with SaaS and on-premises applications just like a human-being. RPA technologies involve building, deploying, and managing those software robots.

- [Power Automate Desktop (Microsoft)](https://powerautomate.microsoft.com/en-us/robotic-process-automation/) - Automate everything from simple data transfers to complex business workflows—directly from your desktop—using RPA desktop flows in Power Automate Desktop.
- [Servicetrace RPA (Salesforce)](https://www.servicetrace.com/) - Develop innovation in robotic solutions.
- [Appian RPA](https://appian.com/platform/complete-automation/robotic-process-automation-rpa.html) - Orchestrate RPA bots with people, systems, and data in a single workflow, scaling automation across your entire organization.
- [Workato RPA](https://www.workato.com/modern-rpa) - Integration-powered RPA for Intelligent Automation.
- [UiPath](https://www.uipath.com/) - A leading provider of robotic process automation (RPA) software, which enables organizations to automate repetitive and time-consuming tasks, such as data entry and data processing. Its platform includes a visual designer for building automation workflows, a robot for executing the workflows, and analytics tools for monitoring and optimizing performance.
- [AutomationAnywhere](https://www.automationanywhere.com/) - A provider of robotic process automation (RPA) software that allows businesses to automate tasks using a combination of rules-based decision-making, machine learning, and artificial intelligence. Its platform includes a user-friendly interface for creating and deploying automation, and it can be used to automate tasks across various departments and industries.
- [BluePrism](https://www.blueprism.com/) - A provider of robotic process automation (RPA) software that allows organizations to automate repetitive and manual tasks, such as data entry, without requiring extensive coding knowledge. Its platform includes a digital workforce that can handle high-volume and complex tasks, and it can integrate with various systems and applications to streamline business operations.

### Intelligent Virtual Agent

A software application which is built and configured by its users to perform manual repetitive and error-prone tasks in an automated faster fashion. Bots are built and configured mostly in Low Code platforms via easy to use drag & drop interfaces. Examples to the use of bots could be seen in user conversation via messaging and voice platforms that help them take decisions and act through business processes.

- [Power Virtual Agents (Microsoft)](https://powervirtualagents.microsoft.com/) - Lets you create powerful chatbots that can answer questions posed by your customers, other employees, or visitors to your website or service.
- [Workato Workbot](https://docs.workato.com/workbot/overview.html) - A bot platform that allows you to build customizable workflows.

### Integration Platform as a Service

A platform that help organizations control, simplify and standardize the way that applications are integrated (internally developed or 3rd party SaaS). Such platforms help to share data between applications, automate business workflows and remove manual error prone ones, in an advanced controlled manner. iPaaS also enables more types of personas to integrate applications, removing the constant dependency on software developers. iPaaS can be deployed within an organization either as a SaaS or as on-premises appliance.

- [Azure Logic Apps (Microsoft)](https://azure.microsoft.com/en-us/services/logic-apps/) - A cloud-based platform for creating and running automated workflows that integrate your apps, data, services, and systems.
- [MuleSoft (Salesforce)](https://mulesoft.com/) - Provides an integration and API platform that makes it easy to connect data from any system to create connected experiences.
- [Workato](https://www.workato.com) - An enterprise automation platform that helps organizations work faster and smarter without compromising governance and security.

### Low Code API Management Platform

A Low Code platform which supports full lifecycle API management, including creation, management and monitoring of API endpoints.

- [MuleSoft](https://www.mulesoft.com/platform/api-management) - Manage your API lifecycle, quickly design, test, and publish APIs.
- [Workato API Management](https://docs.workato.com/api-management.html) - Turn callable recipes into endpoints and organize the endpoints into API collections, making it easier for users to find and consume the endpoints through other recipes or third-party apps, without requiring access to your Workato account.


## Tools, Extensions and Frameworks

### Power Platform (Microsoft)

- [XrmToolBox](https://github.com/MscrmTools/XrmToolBox) - An application that gather multiple tools to ease the customization and configuration of Microsoft Dynamics CRM/365/Dataverse/PowerApps.
- [Levelup for Dynamics CRM](https://github.com/rajyraman/Levelup-for-Dynamics-CRM) - Chrome, Edge Chromium and Firefox Extension for Dynamics CRM/365/Power Apps Power users.
- [Power Platform Adoption Framework](https://github.com/PowerPlatformAF/PowerPlatformAF) - The framework that enables people to create beautiful and useful things on Power Platform deployed in large, enterprise-grade organizations.
- [Flow & Power Apps Migrator](https://github.com/Zerg00s/FlowPowerAppsMigrator) - Converts SharePoint Data sources for the MS Flow and PowerApps to a new tenant of your choice.
- [SharePoint Workflow Converter](https://github.com/TracyGH/SharePointWorkflowConverter) - A proof-of-concept C# console application for retrieving legacy 2010 & 2013 custom SharePoint workflow definition files, and creating new Power Automate flows programmatically.

## Reference Resources

### Power Platform (Microsoft)

- [Power Platform Connectors](https://github.com/microsoft/PowerPlatformConnectors) - This is a repository for Microsoft Power Automate, Power Apps, and Azure Logic Apps connectors.
- [Microsoft Power Fx](https://github.com/microsoft/Power-Fx) - Power Fx Low Code programming language.

### Workato

- [Custom Connector Docs](https://github.com/workato/custom_connector_docs) - Source files for Workato custom connector documentation.

## Learning Resources

### Power Platform (Microsoft)

- [Power Fx Samples](https://github.com/pnp/powerfx-samples) - This repository contains samples for Power Fx Low Code programming language.
- [Power Apps & Azure Lab](https://github.com/microsoft/PowerApps-Azure-Lab) - Repository to host the PowerApps Azure Lab.
- [PL-900: Power Platform Fundamentals](https://github.com/MicrosoftLearning/PL-900-Microsoft-Power-Platform-Fundamentals) - Power Platform Fundamentals course materials.

### Workato

- [Embedding Guide](https://github.com/workato/full-embed-sample) - A guided example on how to use Workato embedded.

## Samples, Templates and Solutions

### Power Platform (Microsoft)

- [Power Apps Samples](https://github.com/pnp/powerapps-samples) - Contains curated community Microsoft Power App samples.
- [PowerApps Samples](https://github.com/Eickhel/PowerApps-samples) - Power Apps samples by Power Nimbus.
- [Power Apps Branding Template](https://github.com/iAmManCat/PowerApps-Branding-Template) - A template to empower developers and reduce time wasted on control changes.
- [SharePoint Power Platform Solutions](https://github.com/pnp/sp-power-platform-solutions) - Sample PowerApps solutions designed to be used in SharePoint context.
- [Power Automate Samples](https://github.com/pnp/powerautomate-samples) - Contains curated community samples for Microsoft Power Automate.
- [Automatic travel time](https://github.com/wortell/PowerAutomate-AutomatischeReistijd) - Automatic travel time in your Office 365 calendar.
- [Message Center in Teams](https://github.com/ericsche/MCinTeams) - Message Center in Teams is a simple PowerAutomate Solution to gather Message Center Announcement and post them in a Teams Channel.
- [Consume Power BI](https://github.com/ferrybouwman/Power-BI-Read-Only-REST-API) - Solution based on either Powershell or Power Automate (Flow) to consume the recently released Power BI Asynchronous Unified Scanning API.
- [Post List Item To Twitter](https://github.com/vaibhav21791/PostListItemToTwitter) - A Microsoft Power Automate Flow to Post a SharePoint List Item to Twitter along with media content.

### Workato

- [Solution Marketplace](https://www.workato.com/solutions) - A curated list of ready-to-use solutions built by Workato and vendors.
- [Support History](https://support.workato.com/en/support/solutions) - A public repository of resolved support tickets to help tackle issues.

## Community

### Power Platform (Microsoft)

- [Microsoft Power Apps Official Community](https://powerusers.microsoft.com/t5/Power-Apps-Community/ct-p/PowerApps1)
- [Microsoft Power Automate Official Community](https://powerusers.microsoft.com/t5/Microsoft-Power-Automate/ct-p/MPACommunity)
- [Microsoft Power Virtual Agents Official Community](https://powerusers.microsoft.com/t5/Power-Virtual-Agents-Community/ct-p/PVACommunity)
- [Microsoft Power BI Official Community](https://community.powerbi.com/)
- [PowP.Co Discord Community](https://powp.co/) - A Discord community of Power Platform enthusiasts.

### Workato

- [Workato Communities](https://community.workato.com/) - The official Workato communities website.
- [Systematic](https://systematic.workato.com/) - The only community for business systems.

## Blogs

### Power Platform (Microsoft)

- [Zenity](https://zenity.io/blog) - Low Code security and governance.
- [Addressing the Low Code Security Elephant in the Room](https://www.darkreading.com/edge-articles/addressing-the-low-code-security-elephant-in-the-room) - The shared responsibility model for Low Code applications.
- [PowPco](https://blog.powp.co/) - Single-stop community for everything Power Platform Community related.

### Workato

- [The Connector](https://www.workato.com/the-connector/) - Workato blog on Business Automation.

## Other Lists

### Power Platform (Microsoft)

- [Awesome Microsoft Power Platform](https://github.com/Power-Maverick/awesome-power-platform) - A collection of awesome things regarding the Power Platform ecosystem.
- [Awesome No Code Low Code](https://github.com/valentin-vogel/awesome-nocode-lowcode) - A collection of awesome No Code and Low Code resources.
