<div class="github-widget" data-repo="web-padawan/awesome-lit"></div>
## Awesome Lit [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of awesome Lit resources.

[Lit](https://github.com/lit/lit) — a simple library for building fast, lightweight web components.

At Lit's core is a boilerplate-killing component base class that provides reactive state, scoped styles, and a declarative template system that's tiny, fast and expressive.



## General resources

- [Documentation](https://lit.dev/docs/)
- [Tutorials](https://lit.dev/tutorials/)
- [Playground](https://lit.dev/playground/)
- [Blog](https://lit.dev/blog/)

## Community

- [Discord](https://discord.gg/yuKCWxEy)
- [GitHub](https://github.com/lit/lit)
- [GitHub Discussions](https://github.com/lit/lit/discussions)
- [Twitter](https://twitter.com/buildWithLit)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/lit+or+lit-html+or+lit-element)
- [YouTube](https://www.youtube.com/channel/UCok4ZKSzM3jY7JQRMlF-DPg/)

## Overview

- [Lightning-fast templates & Web Components: lit-html & LitElement](https://developers.google.com/web/updates/2019/02/lit-element-and-lit-html)
- [Lit 2.0: Meet Lit, all over again!](https://lit.dev/blog/2021-04-21-lit-2.0-meet-lit-all-over-again/)
- [Announcing Lit 2 stable release](https://lit.dev/blog/2021-09-21-announcing-lit-2/)

## Starter Templates

- [LitElement JavaScript starter](https://github.com/lit/lit-element-starter-js) - Sample component using LitElement with JavaScript.
- [LitElement TypeScript starter](https://github.com/lit/lit-element-starter-ts) - Sample component using LitElement with TypeScript.
- [hello-web-components](https://github.com/fernandopasik/hello-web-components) - Simple starter web component written in TypeScript using Lit.
- [Lit Sass JavaScript Starter](https://github.com/e111077/lit-sass-js-starter) - Project that has a simple setup for SASS + JS + Lit, using Rollup.
- [Lit Sass TypeScript Starter](https://github.com/e111077/lit-sass-ts-starter) - Project that has a simple setup for SASS + TS + Lit, using Rollup.
- [Lit Webpack Starter](https://github.com/andrewlevada/webpack-lit-template) - Starter for multipage apps with Lit and Typescript, using Webpack.
- [Open Web Components Generator](https://open-wc.org/docs/development/generator/) - Starter app based on Open Web Components Recommendations.
- [pwa-starter](https://github.com/pwa-builder/pwa-starter) - LitElement edition of the PWABuilder pwa-starter.
- [pwa-lit-template](https://github.com/IBM/pwa-lit-template) - Build Progressive Web Applications following the modern web standards.
- [Vite Lit Element TS SASS](https://github.com/e111077/vite-lit-element-ts-sass) - Example Vite project using Lit 2, Typescript, and SASS.
- [Vite Lit Starter](https://github.com/vitejs/vite/tree/main/packages/create-vite/template-lit) - Lit based template preset for Vite.
- [Vite Lit TS Starter](https://github.com/vitejs/vite/tree/main/packages/create-vite/template-lit-ts) - Lit and TypeScript based template preset for Vite.

## Codelabs

- [Build a Brick Viewer with lit-element](https://codelabs.developers.google.com/codelabs/lit-brick-viewer#0)
- [Build a Story Component with lit-element](https://codelabs.developers.google.com/codelabs/lit-story-viewer#0)
- [From Web Component to Lit Element](https://codelabs.developers.google.com/codelabs/the-lit-path#0)
- [lit-html & lit-element: basics](https://open-wc.org/codelabs/basics/lit-html.html#0)
- [lit-html & lit-element: intermediate](https://open-wc.org/codelabs/intermediate/lit-html.html#0)
- [Lit for React Developers](https://codelabs.developers.google.com/codelabs/lit-2-for-react-devs#0)

## Tutorials

- [Building A Retro Draggable Web Component Using Lit](https://www.smashingmagazine.com/2022/09/building-retro-draggable-web-component-using-lit/)
- [Building a Rich Text Editor with Lit](https://rodydavis.com/posts/lit-rich-text-editor/)
- [Draggable DOM with Lit](https://rodydavis.com/posts/lit-draggable-dom/)
- [Getting started with LitElement and TypeScript](https://labs.thisdot.co/blog/getting-started-with-litelement-and-typescript)
- [Here's a minimalist no-frills Redux Toolkit & LitElement example](https://dev.to/jdvivar/here-s-a-minimalist-no-frills-redux-toolkit-litelement-example-1j91)
- [JSON to HTML Table with Lit](https://rodydavis.com/posts/lit-html-table/)
- [lit-html Part 1 - A solution for DOM management in web components](https://terodox.tech/handling-web-component-markup-with-lit-html/)
- [lit-html Part 2 - Working with attributes and properties](https://terodox.tech/lit-html-part-2/)
- [Lit and Figma](https://rodydavis.com/posts/figma-and-lit/)
- [Lit and Flutter](https://rodydavis.com/posts/flutter-and-lit/)
- [Lit and Monaco Editor](https://rodydavis.com/posts/lit-monaco-editor/)
- [Lit and VSCode Extensions](https://rodydavis.com/posts/lit-vscode-extension/)
- [Lit Sheet Music](https://rodydavis.com/posts/lit-sheet-music/)
- [Navigation Lifecycle using Vaadin Router, LitElement and TypeScript](https://labs.thisdot.co/blog/navigation-lifecycle-using-vaadin-router-litelement-and-typescript)
- [Recreating The Arduino Pushbutton Using SVG And &lt;lit-element&gt;](https://www.smashingmagazine.com/2020/01/recreating-arduino-pushbutton-svg/)
- [Routing Management with LitElement and TypeScript](https://labs.thisdot.co/blog/routing-management-with-litelement)
- [Some things to know about Lit](https://dev.to/open-wc/some-things-to-know-about-litelement-282c)

## Examples

- [Lit Native](https://github.com/rodydavis/lit-native) - Reuse Lit web components on native platforms.
- [Lit Node Editor](https://github.com/rodydavis/lit-node-editor) - Node editor built with canvas API and simple graph data structure.
- [Lit 3D Piano](https://github.com/rodydavis/lit-3d-piano/) - 3D Piano built with Lit, Three.js and Tone.js.
- [Open Web Components Examples](https://open-wc.org/guides/developing-components/code-examples/#lit-html-and-lit-element) - Code examples of common patterns using Lit.
- [Polymer → Lit Migration Guide](https://kevinpschaaf.github.io/lit-migration-guide) - Code examples showing migration guidance from Polymer to Lit.
- [Vite + RxDB + Lit](https://github.com/rodydavis/vite-rxdb-lit) - Minimal example to get RxDB running with Vite.

## Lit Labs

- [`@lit/localize`](https://www.npmjs.com/package/@lit/localize) - Library and command-line tool for localizing web applications built using Lit.
- [`@lit-labs/ssr`](https://www.npmjs.com/package/@lit-labs/ssr) - Package for server-side rendering Lit templates and components.
- [`@lit-labs/motion`](https://www.npmjs.com/package/@lit-labs/motion) - Lit directives for making things move.
- [`@lit-labs/react`](https://www.npmjs.com/package/@lit-labs/react) - React integration for Web Components and reactive Lit controllers.
- [`@lit-labs/scoped-registry-mixin`](https://www.npmjs.com/package/@lit-labs/scoped-registry-mixin) - Mixin for LitElement that integrates with the speculative Scoped CustomElementRegistry polyfill to evaluate the proposal and facilitate feedback.
- [`@lit-labs/task`](https://www.npmjs.com/package/@lit-labs/task) - Controller for Lit that renders asynchronous tasks.
- [`@lit-labs/virtualizer`](https://www.npmjs.com/package/@lit-labs/virtualizer) - Package that provides virtual scrolling for Lit.

## Extensions

- [`@adobe/lit-mobx`](https://www.npmjs.com/package/@adobe/lit-mobx) - Mixin and base class for using mobx with Lit.
- [`@apollo-elements/lit-apollo`](https://www.npmjs.com/package/@apollo-elements/lit-apollo) - LitElement integrations with Apollo GraphQL.
- [`@lit-app/state`](https://www.npmjs.com/package/@lit-app/state) - Lean and simple global State management for Lit 2.
- [`@shoelace-style/localize`](https://github.com/shoelace-style/localize) - A micro library for localizing custom elements, providing directives for Lit.
- [`@stefanholzapfel/lit-state`](https://www.npmjs.com/package/@stefanholzapfel/lit-state) - Lightweight reactive state management for Lit 2.
- [`@vaadin/form`](https://www.npmjs.com/package/@vaadin/form) - Set of utilities for building forms with TypeScript and Lit.
- [`dark-theme-utils`](https://www.npmjs.com/package/dark-theme-utils) - Useful utilities for dark mode built with Web Components.
- [`exome`](https://www.npmjs.com/package/exome) - State manager for deeply nested states that supports Lit.
- [`pure-lit`](https://github.com/MatthiasKainer/pure-lit) - Register your Lit elements as pure functions.
- [`lit-element-effect`](https://www.npmjs.com/package/lit-element-effect) - Effect hooks for LitElement.
- [`lit-element-state-decoupler`](https://www.npmjs.com/package/lit-element-state-decoupler) - Utility for state handling outside of the component for LitElement.
- [`lit-redux-router`](https://www.npmjs.com/package/lit-redux-router) - Declarative way of routing for Lit powered by pwa-helpers and Redux.
- [`lit-svelte-stores`](https://www.npmjs.com/package/lit-svelte-stores) - Lit controller to use svelte stores as state management.
- [`lit-vaadin-helpers`](https://www.npmjs.com/package/lit-vaadin-helpers) - Helpers for using Vaadin web components with Lit 2.
- [`ullr`](https://github.com/aggre/ullr) - Build Web Components with functional programming using Lit.

## Design Systems

- [AXA Pattern Library](https://github.com/axa-ch-webhub-cloud/pattern-library) - AXA CH UI components library built with LitElement.
- [Brightspace UI core](https://github.com/BrightspaceUI/core) - Collection of web components for building Brightspace applications.
- [Carbon Web Components](https://github.com/carbon-design-system/carbon-web-components) - Carbon Design System variant on top of Web Components.
- [Clarity Core Web Components](https://github.com/vmware-clarity/core/tree/main/projects/core) - Suite of web components for Clarity Design System.
- [Kor](https://github.com/eduferfer/kor) - An open source Design System and lightweight UI Component Library.
- [Lion](https://github.com/ing-bank/lion) - Highly performant, accessible and flexible Web Components.
- [Material Web Components](https://github.com/material-components/material-web) - Material Design implemented as Web Components.
- [Momentum UI Web Components](https://github.com/momentum-design/momentum-ui/tree/master/web-components) - Set of UI components based on Momentum Design.
- [Outline Design System](https://github.com/phase2/outline) - Web component based design system starter kit.
- [Pharos Design System](https://github.com/ithaka/pharos) - JSTOR's design system to create cohesive, supportive, and beautiful experiences.
- [Red Hat Design System](https://github.com/RedHat-UX/red-hat-design-system) - Web components for building uniform experiences with the Red Hat brand.
- [Shoelace](https://github.com/shoelace-style/shoelace) - Collection of professionally designed UI components built on a framework-agnostic technology.
- [Spectrum Web Components](https://github.com/adobe/spectrum-web-components) - Adobe Spectrum design language implementation built with LitElement.
- [UI5 Web Components](https://github.com/SAP/ui5-webcomponents) - Enterprise-flavored sugar on top of native APIs!

## Component Libraries

- [Apollo Elements](https://github.com/apollo-elements/apollo-elements) - Custom elements meet Apollo GraphQL.
- [Blackstone UI](https://github.com/kjantzer/bui) - Web components for creating interfaces built with lit-html and LitElement.
- [Chartjs Web Components](https://github.com/fsx950223/chartjs-web-components) - Web components for chartjs.
- [Clever components](https://github.com/CleverCloud/clever-components) - Collection of Web Components made by Clever Cloud.
- [Curvenote](https://github.com/curvenote/article) - Web components for creating interactive scientific articles.
- [Dile Components](https://github.com/Polydile/dile-components) - General use Web Components for websites and applications.
- [ESP Web Tools](https://github.com/esphome/esp-web-tools) - Allow flashing ESPHome or other ESP-based firmwares via the browser.
- [Furo Webcomponents](https://github.com/eclipse/eclipsefuro-web) - Enterprise ready set of web components which work best with Eclipse Furo.
- [Fusion Web Components](https://github.com/equinor/fusion-web-components) - Ser of web components used by Equinor Fusion.
- [Ignite UI Web Components](https://github.com/IgniteUI/igniteui-webcomponents) - Complete library of UI components from Infragistics.
- [LRNWebComponents](https://github.com/elmsln/lrnwebcomponents) - ELMS:LN produced web components for any project.
- [Medblocks UI](https://github.com/medblocks/medblocks-ui) - Web Components for rapid development of openEHR and FHIR systems.
- [Microsoft Graph Toolkit](https://github.com/microsoftgraph/microsoft-graph-toolkit) - Collection of web components for the Microsoft Graph.
- [Mutation testing elements](https://github.com/stryker-mutator/mutation-testing-elements) - A schema for mutation testing results with the web components to visualize it.
- [One Platform Components](https://github.com/1-Platform/op-components) - Set of web components for Red Hat One Platform.
- [Playground Elements](https://github.com/PolymerLabs/playground-elements) - Serverless code experiences with web components.
- [Stripe Elements](https://github.com/bennypowers/stripe-elements) - Custom Element Wrapper for Stripe.js v3 Elements.
- [Titanium Elements](https://github.com/LeavittSoftware/titanium-elements) - Collection of lightweight web components used by Leavitt Group Enterprises.
- [TrendChart Elements](https://github.com/WebLogin/trendchart-elements) - Components to generate simple charts representing trends.
- [Umbraco UI Components](https://github.com/umbraco/Umbraco.UI) - Collection of user interface web components for Umbraco CMS.
- [Vidstack Elements](https://github.com/vidstack/vds-elements) - Spec-compliant customizable, extensible, accessible and universal media elements.
- [VSCode Webview Elements](https://github.com/bendera/vscode-webview-elements) - Components for creating VSCode extensions which use the Webview API.
- [Web Components for TEI Publisher](https://github.com/eeditiones/tei-publisher-components) - Web components used by TEI Publisher and apps generated by it.
- [Webmarkets web components](https://github.com/Webmarkets/wm-web-components) - Set of Webmarkets' public web components.
- [Wired Elements](https://github.com/rough-stuff/wired-elements) - Collection of elements that appear hand drawn.
- [Wokwi Elements](https://github.com/wokwi/wokwi-elements) - Web Components for Arduino and various electronic parts.

## Standalone Components

- [`<api-viewer>`](https://github.com/web-padawan/api-viewer-element) - API documentation and live playground for Web Components.
- [`<app-datepicker>`](https://github.com/motss/app-datepicker) - Datepicker element built with LitElement and Material Design 2.
- [`<burgton-button>`](https://github.com/boguz/burgton-button) - Simple to use, customizable and accessible burger-button element.
- [`<code-block>`](https://github.com/justinribeiro/code-block) - Web component that displays colorfully formatted code with Prism.js and LitElement.
- [`<codesandbox-button>`](https://github.com/bennypowers/codesandbox-button) - Custom Element that shows a CodeSandbox demo when you click on it.
- [`<editor-container>`](https://github.com/toeverything/blocksuite) - Block based editor, designed for general-purpose collaborative applications.
- [`<granite-qrcode-generator>`](https://github.com/LostInBrittany/granite-qrcode-generator) - Custom element to generate and render QR Codes, using qr.js library.
- [`<helium-animated-pages>`](https://github.com/alangdm/helium-animated-pages) - Web component for creating CSS animations built with Lit.
- [`<json-viewer>`](https://github.com/alenaksu/json-viewer) - Web Component to visualize JSON data in a tree view.
- [`<light-gallery>`](https://github.com/sachinchoolur/lightGallery/tree/master/lightgallery-lit) - Full featured JavaScript image and video gallery for Lit.
- [`<lit-datatable>`](https://github.com/DoubleTrade/lit-datatable) - Material Design implementation of a data table, powered by LitElement.
- [`<lit-image-cropper>`](https://github.com/andy-austin/lit-image-cropper) - Fast and lightweight image cropper component.
- [`<lottie-player>`](https://github.com/LottieFiles/lottie-player) - Web Component for easily embedding and playing Lottie animations.
- [`<model-viewer>`](https://github.com/GoogleWebComponents/model-viewer) - A web component for rendering interactive 3D models.
- [`<rapi-doc>`](https://github.com/mrin9/RapiDoc) - Web Component to view OpenAPI 3.0 & Swagger 2.0 Spec.
- [`<round-slider>`](https://github.com/thomasloven/round-slider) - Simple round slider web component built with Lit.
- [`<stl-part-viewer>`](https://github.com/justinribeiro/stl-part-viewer) - LitElement web component that utilizes Three.js to display an STL model file.

## Tools

### Building

- [babel-plugin-lit-property-types-from-ts](https://www.npmjs.com/package/babel-plugin-lit-property-types-from-ts) - Babel plugin for setting `type` for reactive properties declared in Lit components based on TypeScript type annotations.
- [babel-plugin-template-html-minifier](https://www.npmjs.com/package/babel-plugin-template-html-minifier) - Babel plugin for minifying HTML in tagged template strings.
- [esbuild-plugin-lit](https://www.npmjs.com/package/esbuild-plugin-lit) - ESBuild plugin to import CSS, SVG, HTML, XLIFF files as JavaScript tagged-template literal objects.
- [esbuild-plugin-lit-css](https://www.npmjs.com/package/esbuild-plugin-lit-css) - ESBuild plugin to import css files as JavaScript tagged-template literal objects.
- [lit-css-loader](https://www.npmjs.com/package/lit-css-loader) - Webpack loader to import css files as JavaScript tagged-template literal objects.
- [lit-scss-loader](https://www.npmjs.com/package/lit-scss-loader) - Webpack loader to import the CSS/SCSS into Lit components.
- [rollup-plugin-lit-css](https://www.npmjs.com/package/rollup-plugin-lit-css) - Rollup plugin to import css files as JavaScript tagged-template literal objects.
- [rollup-plugin-minify-html-literals](https://www.npmjs.com/package/rollup-plugin-minify-html-literals) - Rollup plugin to minify HTML in tagged template strings.
- [rollup-plugin-postcss-lit](https://www.npmjs.com/package/rollup-plugin-postcss-lit) - Rollup plugin to load PostCSS-processed stylesheets in Lit components.

### Linting

- [eslint-plugin-lit](https://www.npmjs.com/package/eslint-plugin-lit) - ESLint plugin for Lit template strings.
- [eslint-plugin-lit-a11y](https://www.npmjs.com/package/eslint-plugin-lit-a11y) - Accessibility linting plugin for Lit templates.
- [lit-analyzer](https://www.npmjs.com/package/lit-analyzer) - CLI that type checks bindings in Lit templates.

### IDE Plugins

- [vscode-lit-html](https://marketplace.visualstudio.com/items?itemName=bierner.lit-html) - Syntax highlighting and IntelliSense for lit-html template strings.
- [vscode-lit-plugin](https://marketplace.visualstudio.com/items?itemName=runem.lit-plugin) - Syntax highlighting, type checking and code completion for lit-html.
- [es6-string-html](https://marketplace.visualstudio.com/items?itemName=Tobermory.es6-string-html) - VSCode extension which provides syntax highlighting for HTML in ES6 multiline strings.
- [vim-html-template-literals](https://github.com/jonsmithers/vim-html-template-literals) - Syntax highlighting and indentation for HTML inside of tagged template literals.
- [@web-types/lit](https://www.npmjs.com/package/@web-types/lit) - Attribute completion for HTML inside of tagged template literals.

### TypeScript Plugins

- [ts-lit-plugin](https://www.npmjs.com/package/ts-lit-plugin) - Plugin that adds type checking and code completion for Lit templates.
- [typescript-lit-html-plugin](https://www.npmjs.com/package/typescript-lit-html-plugin) - TypeScript server plugin that adds IntelliSense for Lit templates.

### Other Tools

- [@custom-elements-manifest/analyzer](https://www.npmjs.com/package/@custom-elements-manifest/analyzer) - CLI tool to generate API documentation for web components.
- [Storybook for web-components](https://www.npmjs.com/package/@storybook/web-components) - UI development environment for plain web-component snippets.
- [web-components-codemods](https://www.npmjs.com/package/web-components-codemods) - Codemods for Web Components compatible with lit-html template literals.
- [Web Component DevTools](https://github.com/Matsuuu/web-component-devtools) - Browser extension for developers working with Web Components.
- [Web Component Factory](https://www.npmjs.com/package/@wcfactory/cli) - CLI tool for generating, building, testing and publishing web components.

## CDN

The following content delivery networks provide ES module versions of Lit:

- [cdn.esm.sh](https://cdn.esm.sh/lit)
- [jsDelivr CDN](https://cdn.jsdelivr.net/npm/lit/+esm)
- [JSPM CDN](https://jspm.dev/lit)
- [Skypack CDN](https://cdn.skypack.dev/lit)
- [unpkg.com](https://unpkg.com/lit?module)

See [lit.dev documentation](https://lit.dev/docs/getting-started/#use-bundles) for using bundles.

## Integrations

- [Bridgetown Lit Renderer](https://github.com/bridgetownrb/bridgetown-lit-renderer) - SSR + hydration of Lit components for Bridgetown.
- [Fable.Lit](https://github.com/fable-compiler/Fable.Lit) - Collection of tools to embed HTML code into F# code with the power of Lit.
- [Ruby2JS](https://github.com/ruby2js/ruby2js) - Minimal yet extensible Ruby to JavaScript conversion.

## Videos

- [Lit 3.0 Launch Event](https://www.youtube.com/watch?v=ri9FEl_hRTc)
- [Efficient, Expressive, and Extensible HTML Templates (Polymer Summit 2017)](https://www.youtube.com/watch?v=ruql541T7gc)
- [lit-HTML (Chrome Dev Summit 2017)](https://www.youtube.com/watch?v=Io6JjgckHbg)
- [Lit Beta Launch Event (2021)](https://www.youtube.com/watch?v=f1j7b696L-E)
- [Lit 2.0 Release Livestream](https://www.youtube.com/watch?v=nfb779XIhsU)
- [VDOM vs lit-html - HTTP203](https://www.youtube.com/watch?v=uCHZJy2n8Qs)
- [Declarative Reactive Web Components with Justin Fagnani](https://www.youtube.com/watch?v=9FB0GSOAESo)
- [Building a Complex Application with Web Components and LitElement](https://www.youtube.com/watch?v=x9YDQUJx2uw)

## Podcasts

- [The Web Platform Podcast 159: lit-html - HTML Templates via JavaScript Template Literals](https://thewebplatformpodcast.com/159-lithtml-html-templates-via-javascript-template-literals) -
An episode with the lit-html creator Justin Fagnani.
- [ShopTalk Show 348: Getting lit-html with Justin Fagnani](https://shoptalkshow.com/episodes/348/) - Another episode with Justin Fagnani as a guest.

## Archive

The following articles refer to older versions of lit-html and LitElement.

- [Render HTML with Vanilla JavaScript and lit-html](https://dev.to/azure/too-hard-too-soft-just-right-rendering-html-with-lit-html-1km8)
- [A gentle introduction to lit-html](https://dev.to/julcasans/a-gentle-introduction-to-lit-html-3d74)
- [lit-html templates from zero to hero](https://dev.to/julcasans/lit-html-templates-from-zero-to-hero-2afm)
- [Updating blog-pwa from Polymer to LitElement, Workbox, and Rollup](https://justinribeiro.com/chronicle/2019/04/11/updating-blog-pwa-from-polymer-to-litelement-workbox-and-rollup/)
- [Let's Build Web Components! Part 5: LitElement](https://dev.to/bennypowers/lets-build-web-components-part-5-litelement-906)
- [LitElement To Do App](https://medium.com/@westbrook/litelement-to-do-app-1e08a31707a4)
- [LitElement with Rollup, Babel & Karma](https://43081j.com/2018/09/polymer-lit-with-rollup)
- [A new, lean way of creating web apps](https://medium.com/@kennethrohde/a-new-lean-way-of-creating-web-apps-88a49c5b87ec)
- [The future of Polymer & lit-html](https://43081j.com/2018/08/future-of-polymer)
- [A night experimenting with Lit-HTML](https://lucamezzalira.com/2018/08/14/a-night-experimenting-with-lit-html/)
- [Making a fullstack CRUD app with LitHTML, Redux, Express, and Webpack](https://medium.com/@pascalschilp/making-a-fullstack-crud-app-with-lithtml-redux-express-and-webpack-fe7e5cf8b3ef)
- [Building a chat with Twilio, lit-html, Parcel and TypeScript](https://dev.to/dkundel/building-a-chat-with-twilio-lit-html-parcel-and-typescript-1jo1)

## Similar libraries

These libraries are not related to Lit, but are built using similar concepts. They use `html` tagged
template literal, and leverage the benefits of the same [IDE Plugins](#ide-plugins) for syntax highlighting.

- [haunted](https://www.npmjs.com/package/haunted) - React's Hooks API but for standard web components and hyperHTML or lit-html.
- [htm](https://github.com/developit/htm) - Hyperscript Tagged Markup: JSX alternative using standard tagged templates, with compiler support.
- [hybrids](https://github.com/hybridsjs/hybrids) - UI library for creating Web Components with simple and functional API.
- [lit-ntml](https://github.com/motss/lit-ntml) - Lightweight and modern templating for SSR in Node.js, inspired by lit-html.

## Other awesome resources

**If you want more awesome resources, check the [awesome](https://github.com/sindresorhus/awesome) list!**

---

## License

[![CC0](https://upload.wikimedia.org/wikipedia/commons/6/69/CC0_button.svg)](http://creativecommons.org/publicdomain/zero/1.0/)
