<div class="github-widget" data-repo="web-padawan/awesome-lit-html"></div>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script><ins class="adsbygoogle" style="display:block" data-ad-client="ca-pub-6890694312814945" data-ad-slot="5473692530" data-ad-format="auto"  data-full-width-responsive="true"></ins><script>(adsbygoogle = window.adsbygoogle || []).push({});</script>
## Awesome Lit [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

&gt; 精选的精彩 Lit 资源列表.

[Lit](https://github.com/lit/lit) — 一个用于构建快速、轻量级 Web 组件的简单库.

Lit 的核心是一个样板杀死组件基类，它提供反应状态、作用域样式和一个小巧、快速且富有表现力的声明性模板系统.



## General resources

- [Documentation](https://lit.dev/docs/)
- [Tutorial](https://lit.dev/tutorial/)
- [Playground](https://lit.dev/playground/)
- [Blog](https://lit.dev/blog/)

## Community

- [GitHub](https://github.com/lit/lit)
- [GitHub Discussions](https://github.com/lit/lit/discussions)
- [Twitter](https://twitter.com/buildWithLit)
- [Slack](https://lit.dev/slack-invite/)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/lit+or+lit-html+or+lit-element)
- [YouTube](https://www.youtube.com/channel/UCok4ZKSzM3jY7JQRMlF-DPg/)

## Overview

- [Lightning-fast templates & Web Components: lit-html & LitElement](https://developers.google.com/web/updates/2019/02/lit-element-and-lit-html)
- [Lit 2.0: Meet Lit, all over again!](https://lit.dev/blog/2021-04-21-lit-2.0-meet-lit-all-over-again/)
- [Announcing Lit 2 stable release](https://lit.dev/blog/2021-09-21-announcing-lit-2/)

## Starter Templates

- [LitElement JavaScript starter](https://github.com/lit/lit-element-starter-js) - 使用带有 JavaScript 的 LitElement 的示例组件.
- [LitElement TypeScript starter](https://github.com/lit/lit-element-starter-ts) - 使用 LitElement 和 TypeScript 的示例组件.
- [hello-web-components](https://github.com/fernandopasik/hello-web-components) - 使用 Lit 用 TypeScript 编写的简单入门 Web 组件.
- [Lit Sass JavaScript Starter](https://github.com/e111077/lit-sass-js-starter) - 使用 Rollup 对 SASS + JS + Lit 进行简单设置的项目.
- [Lit Sass TypeScript Starter](https://github.com/e111077/lit-sass-ts-starter) - 使用 Rollup 对 SASS + TS + Lit 进行简单设置的项目.
- [Lit Webpack Starter](https://github.com/andrewlevada/webpack-lit-template) - 使用 Webpack 的带有 Lit 和 Typescript 的多页应用程序的启动器.  
- [Open Web Components Generator](https://open-wc.org/docs/development/generator/) - 基于 Open Web Components Recommendations 的入门应用程序.
- [pwa-starter](https://github.com/pwa-builder/pwa-starter) - PWABuilder pwa-starter 的 LitElement 版本.
- [pwa-lit-template](https://github.com/IBM/pwa-lit-template) - 按照现代 Web 标准构建渐进式 Web 应用程序.
- [Vite Lit Element TS SASS](https://github.com/e111077/vite-lit-element-ts-sass) - 使用 Lit 2、Typescript 和 SASS 的示例 Vite 项目.
- [Vite Lit Starter](https://github.com/vitejs/vite/tree/main/packages/create-vite/template-lit) - Vite 的基于光照的模板预设.
- [Vite Lit TS Starter](https://github.com/vitejs/vite/tree/main/packages/create-vite/template-lit-ts) - Vite 的基于 Lit 和 TypeScript 的模板预设.

## Codelabs

- [Build a Brick Viewer with lit-element](https://codelabs.developers.google.com/codelabs/lit-brick-viewer#0)
- [Build a Story Component with lit-element](https://codelabs.developers.google.com/codelabs/lit-story-viewer#0)
- [From Web Component to Lit Element](https://codelabs.developers.google.com/codelabs/the-lit-path#0)
- [lit-html & lit-element: basics](https://open-wc.org/codelabs/basics/lit-html.html#0)
- [lit-html & lit-element: intermediate](https://open-wc.org/codelabs/intermediate/lit-html.html#0)
- [Lit for React Developers](https://codelabs.developers.google.com/codelabs/lit-2-for-react-devs#0)

## Tutorials

- [Building a Rich Text Editor with Lit](https://rodydavis.com/posts/lit-rich-text-editor/)
- [Draggable DOM with Lit](https://rodydavis.com/posts/lit-draggable-dom/)
- [Getting started with LitElement and TypeScript](https://labs.thisdot.co/blog/getting-started-with-litelement-and-typescript)
- [Here's a minimalist no-frills Redux Toolkit & LitElement example](https://dev.to/jdvivar/here-s-a-minimalist-no-frills-redux-toolkit-litelement-example-1j91)
- [JSON to HTML Table with Lit](https://rodydavis.com/posts/lit-html-table/)
- [lit-html Part 1 - A solution for DOM management in web components](https://terodox.tech/handling-web-component-markup-with-lit-html/)
- [lit-html Part 2 - Working with attributes and properties](https://terodox.tech/lit-html-part-2/)
- [Lit and Figma](https://rodydavis.com/posts/figma-and-lit/)
- [Lit and Flutter](https://rodydavis.com/posts/flutter-and-lit/)
- [Lit and Monaco Editor](https://rodydavis.com/posts/lit-monaco-editor/)
- [Lit and VSCode Extensions](https://rodydavis.com/posts/lit-vscode-extension/)
- [Lit Sheet Music](https://rodydavis.com/posts/lit-sheet-music/)
- [Navigation Lifecycle using Vaadin Router, LitElement and TypeScript](https://labs.thisdot.co/blog/navigation-lifecycle-using-vaadin-router-litelement-and-typescript)
- [Recreating The Arduino Pushbutton Using SVG And &lt;lit-element&gt;](https://www.smashingmagazine.com/2020/01/recreating-arduino-pushbutton-svg/)
- [Routing Management with LitElement and TypeScript](https://labs.thisdot.co/blog/routing-management-with-litelement)
- [Some things to know about Lit](https://dev.to/open-wc/some-things-to-know-about-litelement-282c)

## Examples

- [Lit Basics](https://vaadin.com/docs/latest/fusion/application/lit) - 一些例子概述了一般的 Lit 概念.
- [Lit Native](https://github.com/rodydavis/lit-native) - 在本机平台上重用 Lit Web 组件.
- [Lit Node Editor](https://github.com/rodydavis/lit-node-editor) - 使用画布 API 和简单的图形数据结构构建的节点编辑器.
- [Lit 3D Piano](https://github.com/rodydavis/lit-3d-piano/) - 使用 Lit、Three.js 和 Tone.js 构建的 3D 钢琴.
- [Open Web Components Examples](https://open-wc.org/guides/developing-components/code-examples/#lit-html-and-lit-element) - 使用 Lit 的常见模式的代码示例.
- [Polymer → Lit Migration Guide](https://kevinpschaaf.github.io/lit-migration-guide) - 代码示例显示从 Polymer 到 Lit 的迁移指南.
- [Vite + RxDB + Lit](https://github.com/rodydavis/vite-rxdb-lit) - 使用 Vite 运行 RxDB 的最小示例.

## Lit Labs

- [`@lit/localize`](https://www.npmjs.com/package/@lit/localize) - 用于本地化使用 Lit 构建的 Web 应用程序的库和命令行工具.
- [`@lit-labs/ssr`](https://www.npmjs.com/package/@lit-labs/ssr) - 用于服务器端渲染 Lit 模板和组件的包.
- [`@lit-labs/motion`](https://www.npmjs.com/package/@lit-labs/motion) - 点亮指令让事情动起来.
- [`@lit-labs/react`](https://www.npmjs.com/package/@lit-labs/react) - 针对 Web 组件和反应式 Lit 控制器的反应集成.
- [`@lit-labs/scoped-registry-mixin`](https://www.npmjs.com/package/@lit-labs/scoped-registry-mixin) - LitElement 的 Mixin，与推测性的 Scoped CustomElementRegistry polyfill 集成以评估提案并促进反馈.
- [`@lit-labs/task`](https://www.npmjs.com/package/@lit-labs/task) - 呈现异步任务的 Lit 控制器.
- [`@lit-labs/virtualizer`](https://www.npmjs.com/package/@lit-labs/virtualizer) - 为 Lit 提供虚拟滚动的包.

## Extensions

- [`@adobe/lit-mobx`](https://www.npmjs.com/package/@adobe/lit-mobx) - 使用带有 Lit 的 mobx 的 Mixin 和基类.
- [`@apollo-elements/lit-apollo`](https://www.npmjs.com/package/@apollo-elements/lit-apollo) - LitElement 与 Apollo GraphQL 的集成.
- [`@shoelace-style/localize`](https://github.com/shoelace-style/localize) - 用于本地化自定义元素的微型库，为 Lit 提供指令.
- [`@stefanholzapfel/lit-state`](https://www.npmjs.com/package/@stefanholzapfel/lit-state) - Lit 2 的轻量级反应状态管理.
- [`@vaadin/form`](https://www.npmjs.com/package/@vaadin/form) - 一组用于使用 TypeScript 和 Lit 构建表单的实用程序.
- [`dark-theme-utils`](https://www.npmjs.com/package/dark-theme-utils) - 使用 Web 组件构建的用于暗模式的有用实用程序.
- [`exome`](https://www.npmjs.com/package/exome) - 支持 Lit 的深层嵌套状态的状态管理器.
- [`pure-lit`](https://github.com/MatthiasKainer/pure-lit) - 将您的 Lit 元素注册为纯函数.
- [`lit-element-effect`](https://www.npmjs.com/package/lit-element-effect) - LitElement 的效果挂钩.
- [`lit-element-state-decoupler`](https://www.npmjs.com/package/lit-element-state-decoupler) - 用于 LitElement 组件外部状态处理的实用程序.
- [`lit-redux-router`](https://www.npmjs.com/package/lit-redux-router) - 由 pwa-helpers 和 Redux 提供支持的 Lit 的声明性路由方式.
- [`lit-svelte-stores`](https://www.npmjs.com/package/lit-svelte-stores) - 点亮控制器以使用苗条的存储作为状态管理.
- [`lit-vaadin-helpers`](https://www.npmjs.com/package/lit-vaadin-helpers) - 在 Lit 2 中使用 Vaadin Web 组件的助手.
- [`ullr`](https://github.com/aggre/ullr) - 使用 Lit 通过函数式编程构建 Web 组件.

## Design Systems

- [AXA Pattern Library](https://github.com/axa-ch/patterns-library) - 使用 LitElement 构建的 AXA CH UI 组件库.
- [Brightspace UI core](https://github.com/BrightspaceUI/core) - 用于构建 Brightspace 应用程序的 Web 组件集合.
- [Carbon Custom Elements](https://github.com/carbon-design-system/carbon-custom-elements) - 基于 Web 组件的碳设计系统变体.
- [Clarity Core Web Components](https://github.com/vmware/clarity/tree/next/packages/core) - Clarity Design System 的 Web 组件套件.
- [Kor](https://github.com/eduferfer/kor) - 一个开源设计系统和轻量级 UI 组件库.
- [Lion](https://github.com/ing-bank/lion) - 高性能、可访问且灵活的 Web 组件.
- [Material Web Components](https://github.com/material-components/material-web) - Material Design 实现为 Web 组件.
- [Momentum UI Web Components](https://github.com/momentum-design/momentum-ui/tree/master/web-components=) - 基于 Momentum Design 的 UI 组件集.
- [Outline Design System](https://github.com/phase2/outline) - 基于 Web 组件的设计系统入门套件.
- [Pharos Design System](https://github.com/ithaka/pharos) - JSTOR 的设计系统可创造具有凝聚力、支持性和美丽的体验.
- [Shoelace](https://github.com/shoelace-style/shoelace) - 基于与框架无关的技术构建的专业设计的 UI 组件的集合.
- [Spectrum Web Components](https://github.com/adobe/spectrum-web-components) - 使用 LitElement 构建的 Adob​​e Spectrum 设计语言实现.
- [UI5 Web Components](https://github.com/SAP/ui5-webcomponents) - 基于原生 API 的企业风味糖！

## Component Libraries

- [Apollo Elements](https://github.com/apollo-elements/apollo-elements) - 自定义元素符合 Apollo GraphQL.
- [Blackstone UI](https://github.com/kjantzer/bui) - 用于创建使用 lit-html 和 LitElement 构建的界面的 Web 组件.
- [Chartjs Web Components](https://github.com/fsx950223/chartjs-web-components) -chartjs 的 Web 组件.
- [Clever components](https://github.com/CleverCloud/clever-components) - 由 Clever Cloud 制作的 Web 组件集合.
- [Curvenote](https://github.com/curvenote/article) - 用于创建交互式科学文章的 Web 组件.
- [ESP Web Tools](https://github.com/esphome/esp-web-tools) - 允许通过浏览器刷入 ESPHome 或其他基于 ESP 的固件.
- [Furo Webcomponents](https://github.com/eclipse/eclipsefuro-web) - 企业级 Web 组件集，最适合与 Eclipse Furo 配合使用.
- [Fusion Web Components](https://github.com/equinor/fusion-web-components) - Equinor Fusion 使用的一系列 Web 组件.
- [Ignite UI Web Components](https://github.com/IgniteUI/igniteui-webcomponents) - 来自 Infragistics 的完整 UI 组件库.
- [LRNWebComponents](https://github.com/elmsln/lrnwebcomponents) - ELMS:LN 为任何项目生成 Web 组件.
- [Medblocks UI](https://github.com/medblocks/medblocks-ui) - 用于快速开发 openEHR 和 FHIR 系统的 Web 组件.
- [Microsoft Graph Toolkit](https://github.com/microsoftgraph/microsoft-graph-toolkit) - Microsoft Graph 的 Web 组件集合.
- [Mutation testing elements](https://github.com/stryker-mutator/mutation-testing-elements) - 使用 Web 组件进行突变测试结果的模式以对其进行可视化.
- [One Platform Components](https://github.com/1-Platform/op-components) - Red Hat One Platform 的一组 Web 组件.
- [Playground Elements](https://github.com/PolymerLabs/playground-elements) - 使用 Web 组件的无服务器代码体验.
- [Stripe Elements](https://github.com/bennypowers/stripe-elements) - Stripe.js v3 元素的自定义元素包装器.
- [Titanium Elements](https://github.com/LeavittSoftware/titanium-elements) - Leavitt Group Enterprises 使用的轻量级 Web 组件的集合.
- [Vidstack Elements](https://github.com/vidstack/vds-elements) - 符合规范的可定制、可扩展、可访问和通用的媒体元素.
- [VSCode Webview Elements](https://github.com/bendera/vscode-webview-elements) - 用于创建使用 Webview API 的 VSCode 扩展的组件.
- [Web Components for TEI Publisher](https://github.com/eeditiones/tei-publisher-components) - TEI Publisher 使用的 Web 组件及其生成的应用程序.
- [Webmarkets web components](https://github.com/Webmarkets/wm-web-components) - Webmarkets 的公共 Web 组件集.
- [Wired Elements](https://github.com/rough-stuff/wired-elements) - 出现手绘元素的集合.
- [Wokwi Elements](https://github.com/wokwi/wokwi-elements) - Arduino 和各种电子部件的 Web 组件.

## Standalone Components

- [`<api-viewer>`](https://github.com/web-padawan/api-viewer-element) - Web 组件的 API 文档和现场操场.
- [`<app-datepicker>`](https://github.com/motss/app-datepicker) - 使用 LitElement 和 Material Design 2 构建的 Datepicker 元素.
- [`<burgton-button>`](https://github.com/boguz/burgton-button) - 易于使用、可定制且易于访问的汉堡按钮元素.
- [`<code-block>`](https://github.com/justinribeiro/code-block) - 使用 Prism.js 和 LitElement 显示彩色格式代码的 Web 组件.
- [`<codesandbox-button>`](https://github.com/bennypowers/codesandbox-button) - 单击时显示 CodeSandbox 演示的自定义元素.
- [`<granite-qrcode-generator>`](https://github.com/LostInBrittany/granite-qrcode-generator) - 使用 qr.js 库生成和呈现 QR 码的自定义元素.
- [`<helium-animated-pages>`](https://github.com/alangdm/helium-animated-pages) - 用于创建使用 Lit 构建的 CSS 动画的 Web 组件.
- [`<json-viewer>`](https://github.com/alenaksu/json-viewer) - 用于在树视图中可视化 JSON 数据的 Web 组件.
- [`<light-gallery>`](https://github.com/sachinchoolur/lightGallery/tree/master/lightgallery-lit) - Lit 的全功能 JavaScript 图像和视频库.
- [`<lit-datatable>`](https://github.com/DoubleTrade/lit-datatable) - 数据表的 Material Design 实现，由 LitElement 提供支持.
- [`<lottie-player>`](https://github.com/LottieFiles/lottie-player) - 用于轻松嵌入和播放 Lottie 动画的 Web 组件.
- [`<model-viewer>`](https://github.com/GoogleWebComponents/model-viewer) - 用于渲染交互式 3D 模型的 Web 组件.
- [`<rapi-doc>`](https://github.com/mrin9/RapiDoc) - 用于查看 OpenAPI 3.0 和 Swagger 2.0 规范的 Web 组件.
- [`<round-slider>`](https://github.com/thomasloven/round-slider) - 使用 Lit 构建的简单圆形滑块 Web 组件.
- [`<stl-part-viewer>`](https://github.com/justinribeiro/stl-part-viewer) - LitElement Web 组件，利用 Three.js 显示 STL 模型文件.

## Tools

### Building

- [babel-plugin-lit-property-types-from-ts](https://www.npmjs.com/package/babel-plugin-lit-property-types-from-ts) - Babel 插件，用于根据 TypeScript 类型注释为 Lit 组件中声明的反应性属性设置 `type`.
- [babel-plugin-template-html-minifier](https://www.npmjs.com/package/babel-plugin-template-html-minifier) - Babel plugin for minifying HTML in tagged template strings.
- [esbuild-plugin-lit-css](https://www.npmjs.com/package/esbuild-plugin-lit-css) - ESBuild 插件将 css 文件导入为 JavaScript 标记模板文字对象.
- [lit-css-loader](https://www.npmjs.com/package/lit-css-loader) - Webpack 加载器将 css 文件作为 JavaScript 标记模板文字对象导入.
- [lit-scss-loader](https://www.npmjs.com/package/lit-scss-loader) - 用于将 CSS/SCSS 导入 Lit 组件的 Webpack 加载器.
- [rollup-plugin-lit-css](https://www.npmjs.com/package/rollup-plugin-lit-css) - 汇总插件将 css 文件导入为 JavaScript 标记模板文字对象.
- [rollup-plugin-minify-html-literals](https://www.npmjs.com/package/rollup-plugin-minify-html-literals) - Rollup 插件以缩小标记模板字符串中的 HTML.
- [rollup-plugin-postcss-lit](https://www.npmjs.com/package/rollup-plugin-postcss-lit) - 在 Lit 组件中加载 PostCSS 处理过的样式表的 Rollup 插件.

### Linting

- [eslint-plugin-lit](https://www.npmjs.com/package/eslint-plugin-lit) - 用于 Lit 模板字符串的 ESLint 插件.
- [eslint-plugin-lit-a11y](https://www.npmjs.com/package/eslint-plugin-lit-a11y) - Lit 模板的可访问性 linting 插件.
- [lit-analyzer](https://www.npmjs.com/package/lit-analyzer) - 类型检查 Lit 模板中的绑定的 CLI.

### IDE Plugins

- [vscode-lit-html](https://marketplace.visualstudio.com/items?itemName=bierner.lit-html) - lit-html 模板字符串的语法高亮和智能感知.
- [vscode-lit-plugin](https://marketplace.visualstudio.com/items?itemName=runem.lit-plugin) - lit-html 的语法高亮、类型检查和代码完成.
- [es6-string-html](https://marketplace.visualstudio.com/items?itemName=Tobermory.es6-string-html) - VSCode 扩展，它为 ES6 多行字符串中的 HTML 提供语法高亮显示.
- [vim-html-template-literals](https://github.com/jonsmithers/vim-html-template-literals) - 标记模板文字内 HTML 的语法突出显示和缩进.

### TypeScript Plugins

- [ts-lit-plugin](https://www.npmjs.com/package/ts-lit-plugin) - 为 Lit 模板添加类型检查和代码完成的插件.
- [typescript-lit-html-plugin](https://www.npmjs.com/package/typescript-lit-html-plugin) - 为 Lit 模板添加 IntelliSense 的 TypeScript 服务器插件.

### Other Tools

- [@custom-elements-manifest/analyzer](https://www.npmjs.com/package/@custom-elements-manifest/analyzer) - 用于为 Web 组件生成 API 文档的 CLI 工具.
- [Storybook for web-components](https://www.npmjs.com/package/@storybook/web-components) - 用于普通 Web 组件片段的 UI 开发环境.
- [web-components-codemods](https://www.npmjs.com/package/web-components-codemods) - 与 lit-html 模板文字兼容的 Web 组件的 Codemods.
- [Web Component DevTools](https://github.com/Matsuuu/web-component-devtools) - 用于使用 Web 组件的开发人员的浏览器扩展.
- [Web Component Factory](https://www.npmjs.com/package/@wcfactory/cli) - 用于生成、构建、测试和发布 Web 组件的 CLI 工具.

## CDN

以下内容交付网络提供了 Lit 的 ES 模块版本：

- [cdn.esm.sh](https://cdn.esm.sh/lit)
- [jsDelivr CDN](https://cdn.jsdelivr.net/npm/lit/+esm)
- [JSPM CDN](https://jspm.dev/lit)
- [Skypack CDN](https://cdn.skypack.dev/lit)
- [unpkg.com](https://unpkg.com/lit?module)

See [this issue](https://github.com/lit/lit/issues/1257) 其中讨论了 CDN 分发的静态构建.

## Integrations

- [Bridgetown Lit Renderer](https://github.com/bridgetownrb/bridgetown-lit-renderer) - SSR + 布里奇敦点燃组件的水合作用.
- [Fable.Lit](https://github.com/fable-compiler/Fable.Lit) - Collection of tools to embed HTML code into F# code with the power of Lit.
- [Ruby2JS](https://github.com/ruby2js/ruby2js) - 最小但可扩展的 Ruby 到 JavaScript 的转换.

## Videos

- [Efficient, Expressive, and Extensible HTML Templates (Polymer Summit 2017)](https://www.youtube.com/watch?v=ruql541T7gc)
- [lit-HTML (Chrome Dev Summit 2017)](https://www.youtube.com/watch?v=Io6JjgckHbg)
- [Lit Beta Launch Event (2021)](https://www.youtube.com/watch?v=f1j7b696L-E)
- [Lit 2.0 Release Livestream](https://www.youtube.com/watch?v=nfb779XIhsU)
- [VDOM vs lit-html - HTTP203](https://www.youtube.com/watch?v=uCHZJy2n8Qs)
- [Declarative Reactive Web Components with Justin Fagnani](https://www.youtube.com/watch?v=9FB0GSOAESo)
- [Building a Complex Application with Web Components and LitElement](https://www.youtube.com/watch?v=x9YDQUJx2uw)

## Podcasts

- [The Web Platform Podcast 159: lit-html - HTML Templates via JavaScript Template Literals](https://thewebplatformpodcast.com/159-lithtml-html-templates-via-javascript-template-literals) -
lit-html 创作者 Justin Fagnani 的一集.
- [ShopTalk Show 348: Getting lit-html with Justin Fagnani](https://shoptalkshow.com/episodes/348/) - 贾斯汀·法格纳尼 (Justin Fagnani) 作为嘉宾的另一集.

## Archive

以下文章参考了旧版本的 lit-html 和 LitElement.

- [Render HTML with Vanilla JavaScript and lit-html](https://dev.to/azure/too-hard-too-soft-just-right-rendering-html-with-lit-html-1km8)
- [A gentle introduction to lit-html](https://dev.to/julcasans/a-gentle-introduction-to-lit-html-3d74)
- [lit-html templates from zero to hero](https://dev.to/julcasans/lit-html-templates-from-zero-to-hero-2afm)
- [Updating blog-pwa from Polymer to LitElement, Workbox, and Rollup](https://justinribeiro.com/chronicle/2019/04/11/updating-blog-pwa-from-polymer-to-litelement-workbox-and-rollup/)
- [Let's Build Web Components! Part 5: LitElement](https://dev.to/bennypowers/lets-build-web-components-part-5-litelement-906)
- [LitElement To Do App](https://medium.com/@westbrook/litelement-to-do-app-1e08a31707a4)
- [LitElement with Rollup, Babel & Karma](https://43081j.com/2018/09/polymer-lit-with-rollup)
- [A new, lean way of creating web apps](https://medium.com/@kennethrohde/a-new-lean-way-of-creating-web-apps-88a49c5b87ec)
- [The future of Polymer & lit-html](https://43081j.com/2018/08/future-of-polymer)
- [A night experimenting with Lit-HTML](https://lucamezzalira.com/2018/08/14/a-night-experimenting-with-lit-html/)
- [Making a fullstack CRUD app with LitHTML, Redux, Express, and Webpack](https://medium.com/@pascalschilp/making-a-fullstack-crud-app-with-lithtml-redux-express-and-webpack-fe7e5cf8b3ef)
- [Building a chat with Twilio, lit-html, Parcel and TypeScript](https://dev.to/dkundel/building-a-chat-with-twilio-lit-html-parcel-and-typescript-1jo1)

## Similar libraries

这些库与 Lit 无关，但使用类似的概念构建. 他们使用`html`标记
模板文字，并利用相同的好处 [IDE Plugins](#ide-plugins) 用于语法高亮.

- [haunted](https://www.npmjs.com/package/haunted) - React 的 Hooks API，但适用于标准 Web 组件和 hyperHTML 或 lit-html.
- [htm](https://github.com/developit/htm) - Hyperscript Tagged Markup：使用标准标记模板的 JSX 替代方案，具有编译器支持.
- [hybrids](https://github.com/hybridsjs/hybrids) - UI 库，用于使用简单且功能强大的 API 创建 Web 组件.
- [lit-ntml](https://github.com/motss/lit-ntml) - Node.js 中 SSR 的轻量级和现代模板，灵感来自 lit-html.

## Other awesome resources

**如果您想要更多精彩资源，请查看 [awesome](https://github.com/sindresorhus/awesome) 列表！**

---

## License

[![CC0](https://upload.wikimedia.org/wikipedia/commons/6/69/CC0_button.svg)](http://creativecommons.org/publicdomain/zero/1.0/)
