<div class="github-widget" data-repo="inputsh/awesome-linux"></div>
<h1 align="center"> <a href="http://awesome.re"><img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" alt="awesome">Linux</h1>

<p align="center">我们都知道 Linux 很棒，但这里列出了与 Linux 生态系统相关的特别棒的东西.</p>

![linux graphic](http://i.imgur.com/3F0xXh8.jpg)

---

<p align="center">您可能还想检查<a href="https://github.com/aleksandar-todorovic/awesome-c">awesome-c</a> 、 <a href="https://github.com/alebcay/awesome-shell">awesome-shell</a> 、 <a href="https://github.com/n1trux/awesome-sysadmin">awesome-sysadmin</a>和<a href="https://github.com/sbilly/awesome-security">awesome-security</a> .</p>

---



## Distributions

发行版分为三个不同的类别：**初学者**、**中级**用户和**高级**用户. 在这些类别中，发行版按字母顺序排列.

### Beginners

#### [elementary OS](http://elementary.io/)

 &gt; elementary OS 是一个基于 Ubuntu 的桌面发行版. 它的一些更有趣的功能包括名为 Pantheon 的自定义桌面环境和许多自定义应用程序，包括照片、音乐、视频、日历、终端、文件等. 它还带有一些熟悉的应用程序，如 Epiphany 网络浏览器和 Geary 邮件的分支. 

**最新版本：** elementary OS Juno (5.0)

**默认桌面环境：**万神殿

![default look](https://elementary.io/images/screenshots/desktop.jpg)

#### [Fedora](https://getfedora.org/)

 &gt; Fedora（以前称为 Fedora Core）是由社区支持的 Fedora 项目开发并归 Red Hat 所有的 Linux 发行版.  Fedora 包含在免费和开源许可下分发的软件，旨在处于此类技术的前沿.  Fedora 以专注于创新、尽早集成新技术以及与上游 Linux 社区密切合作而著称.  Fedora 中的默认桌面是 GNOME 桌面环境，默认界面是 GNOME Shell. 还提供其他桌面环境，包括 KDE、Xfce、LXDE、MATE 和 Cinnamon.  Fedora 项目还分发 Fedora 的自定义变体，称为 Fedora spin. 这些是用特定的软件包集构建的，提供替代桌面环境或针对特定兴趣，如游戏、安全、设计、科学计算和机器人技术.

**最新版本：** Fedora 二十九（29）

**默认桌面环境：** GNOME

![default look](https://distrowatch.com/images/cgfjoewdlbc/fedora.png)

#### [Linux Mint](http://linuxmint.com/)

 &gt; Linux Mint 是一个基于 Ubuntu 的发行版，其目标是通过包含浏览器插件、对 DVD 播放的支持、Java 和其他组件来提供更完整的开箱即用体验. 它还添加了自定义桌面和菜单、几个独特的配置工具以及基于 Web 的软件包安装界面.  Linux Mint 与 Ubuntu 软件存储库兼容.

**最新版本：** Linux Mint Tessa (19.1)

**默认桌面环境：** Cinnamon 和 MATE

![default look](https://distrowatch.com/images/cgfjoewdlbc/mint.png)

#### [Ubuntu](http://www.ubuntu.com/)

 &gt; Ubuntu 是一个完整的桌面 Linux 操作系统，可免费获得社区和专业支持.  Ubuntu 社区建立在 Ubuntu 宣言中的理念之上：软件应该免费提供，软件工具应该以当地语言供人们使用，尽管有任何残疾，人们应该有定制和定制的自由以他们认为合适的任何方式修改他们的软件.  “Ubuntu”是一个古老的非洲词，意思是“对他人的仁慈”.  Ubuntu 发行版将 Ubuntu 的精神带入了软件世界. 

**最新版本：** Ubuntu 18.10

**默认桌面环境：** GNOME

![default look](https://distrowatch.com/images/cgfjoewdlbc/ubuntu.png)

### Intermediate

#### [CentOS](https://www.centos.org/)

 &gt; CentOS 作为一个团体是开源贡献者和用户的社区. 典型的 CentOS 用户是不需要强大的商业支持就可以成功运行的组织和个人.  CentOS 是 Red Hat Enterprise Linux 的 100% 兼容重建，完全符合 Red Hat 的重新分发要求.  CentOS 适用于需要企业级操作系统稳定性且无需认证和支持成本的人.

**最新版本：** CentOS 7.1810

**默认桌面环境：** GNOME

![default look](http://distrowatch.com/images/cgfjoewdlbc/centos.png)

#### [Debian GNU/Linux](https://www.debian.org/)

 &gt; Debian 项目是一个由共同致力于创建自由操作系统的个人组成的协会. 这个操作系统叫做 Debian.  Debian 系统目前使用 Linux 内核.  Linux 是一款完全免费的软件，由 Linus Torvalds 创立，受到全球数以千计程序员的支持. 当然，人们想要的是应用软件：帮助他们完成他们想做的事情的程序，从编辑文档到经营企业到玩游戏再到编写更多软件.  Debian 附带超过 50,000 个软件包（预编译的软件以一种很好的格式捆绑在一起，以便于在您的机器上安装）——全部免费. 它有点像一座塔. 底部是内核. 最重要的是所有基本工具. 接下来是您在计算机上运行的所有软件. 在塔顶的是 Debian —— 仔细组织和安装一切，以便它们一起工作. 

**最新版本：** Debian Stretch (9.6)

**默认桌面环境：** GNOME

![default look](http://distrowatch.com/images/cgfjoewdlbc/debian.png)

#### [Mageia](http://www.mageia.org/)

 &gt; Mageia 是 Mandriva Linux 的一个分支，由流行的法国 Linux 发行版的前雇员和贡献者于 2010 年 9 月成立. 与作为商业实体的 Mandriva 不同，Mageia 项目是一个社区项目和一个非营利组织，其目标是开发一个免费的基于 Linux 的操作系统.

**最新版本：** Mageia 6.1

**默认桌面环境：** KDE

![default look](http://distrowatch.com/images/cgfjoewdlbc/mageia.png)

#### [Manjaro](https://manjaro.org/)

 &gt; Manjaro Linux 是一个基于 Arch Linux 的快速、用户友好、面向桌面的操作系统. 主要功能包括直观的安装过程、自动硬件检测、稳定的滚动发布模型、安装多个内核的能力、用于管理图形驱动程序的特殊 Bash 脚本和广泛的桌面可配置性.  Manjaro Linux 提供 Xfce 作为核心桌面选项，以及为更高级用户提供的极简网络版本. 提供社区支持的 GNOME 3/Cinnamon 和 KDE 版本. 用户还可以从支持和充满活力的 Manjaro 社区论坛中受益.

**最新版本：** Manjaro 18.0.2

**默认桌面环境：** XFCE、KDE

![default look](http://distrowatch.com/images/cgfjoewdlbc/manjaro.png)

#### [openSUSE](http://www.opensuse.org/)

> The openSUSE project is a community program sponsored by SUSE Linux and other companies. Promoting the use of Linux everywhere, this program provides free, easy access to openSUSE, a complete Linux distribution. The openSUSE project has three main goals: make openSUSE the easiest Linux for anyone to obtain and the most widely used Linux distribution; leverage open source collaboration to make openSUSE the world's most usable Linux distribution and desktop environment for new and experienced Linux users; dramatically simplify and open the development and packaging processes to make openSUSE the platform of choice for Linux developers and software vendors. 

**最新版本：** openSUSE Leap 15.0 和 openSUSE Tumbleweed（滚动发布系统）

**默认桌面环境：** KDE、GNOME、XFCE、LXDE（安装时选择）

![default look](http://distrowatch.com/images/cgfjoewdlbc/opensuse.png)

### Advanced

#### [Arch Linux](https://www.archlinux.org/)

 &gt; Arch Linux 是一个独立开发的、针对 x86_64 优化的 Linux 发行版，面向有能力的 Linux 用户. 它使用自己开发的包管理器“pacman”来为最新的软件应用程序提供更新，并进行全面的依赖跟踪. 在滚动发布系统上运行，Arch 可以从 CD 映像或通过 FTP 服务器安装. 默认安装提供了一个坚实的基础，使用户能够创建自定义安装. 此外，Arch 构建系统 (ABS) 提供了一种轻松构建新包、修改库存包配置以及通过 Arch Linux 用户存储库与其他用户共享这些包的方法.

**最新版本：** 不适用（滚动发布系统）

**默认桌面环境：**不适用（没有默认桌面环境）

### Special Purpose

#### [CoreOS](https://coreos.com/)

**专长：**集群

 &gt; CoreOS 是一个基于 Linux 的服务器操作系统.  CoreOS 从头开始​​构建并主要为现代数据中心设计，它提供了使系统安全、可靠和最新的专业工具. 该发行版的一些更有趣的功能包括通过 FastPatch 进行的可靠更新和补丁、通过 CoreUpdate 管理滚动更新的仪表板、用于打包应用程序的 docker，以及对裸机和许多云提供商的支持.

#### [Kali Linux](http://www.kali.org/)

**专长：** 渗透测试

 &gt; Kali Linux（以前称为 BackTrack）是一个基于 Debian 的发行版，带有一系列安全和取证工具. 它具有及时的安全更新、对 ARM 架构的支持、四种流行桌面环境的选择以及到新版本的无缝升级.

#### [Puppy Linux](http://puppylinux.org/)

**专业：** 系统要求低

 &gt; Puppy Linux 是另一个 Linux 发行版. 这里的不同之处在于 Puppy 非常小，但功能非常齐全.  Puppy 启动到 ramdisk 中，与必须不断从 CD 中提取内容的 live CD 发行版不同，它加载到 RAM 中. 这意味着所有应用程序都在眨眼间启动并立即响应用户输入.  Puppy Linux 能够从闪存卡或任何 USB 存储设备、CDROM、Zip 磁盘或 LS/120/240 Superdisk、软盘、内部硬盘驱动器启动. 它甚至可以使用多区段格式化的 CD-RW/DVD-RW 将所有内容保存回 CD/DVD，而根本不需要硬盘驱动器.

#### [Ubuntu Studio](http://ubuntustudio.org/)

**专业：**多媒体创作

 &gt; Ubuntu Studio 是 Ubuntu 的变体，面向 GNU/Linux 音频、视频和图形爱好者以及专业人士. 该发行版提供了一组可用于多媒体创建的开源应用程序.

#### [Tails](https://tails.boum.org/index.en.html)

**专长：**隐身直播系统

 &gt; Tails 是一个实时系统，旨在保护您的隐私和匿名性. 它可以帮助您匿名使用 Internet 并几乎在任何地方和任何计算机上规避审查，但除非您明确要求，否则不会留下任何痕迹. 它是一个完整的操作系统，设计用于独立于计算机原始操作系统的 USB 记忆棒或 DVD. 它是自由软件，基于 Debian GNU/Linux.  Tails 带有几个内置的应用程序，这些应用程序预先配置了安全性：Web 浏览器、即时消息客户端、电子邮件客户端、办公套件、图像和声音编辑器等.

## Learning Resources

### Books

#### [The Linux Command Line](https://www.goodreads.com/book/show/11724436-the-linux-command-line) [4.36] [[FREE](http://linuxcommand.org/tlcl.php)]

这是对 Linux 命令行的一个很好的介绍.  - [@4iar](https://github.com/4iar/)

&gt; 您已经体验过 Linux 计算机闪亮的点击式表面 — 现在深入了解并借助命令行的强大功能探索其深度.

#### [The Debian Administrator's Handbook, Debian Wheezy from Discovery to Mastery](https://www.goodreads.com/book/show/20839133-the-debian-administrator-s-handbook-debian-wheezy-from-discovery-to-mas) [4.83] [[FREE](https://debian-handbook.info/get/now/)]

教您 Debian GNU/Linux 管理基础知识的好书.  - [@elninosi](https://github.com/elninosi)

 &gt; 它涵盖了一个称职的 Linux 管理员应该掌握的所有主题，从系统的安装、更新，到包的创建和内核的编译，还有监控、备份和迁移. 以及安全服务、自动化安装或虚拟化的高级主题.

#### Bash Shell Scripting [[FREE](https://en.wikibooks.org/wiki/Bash_Shell_Scripting)]

&gt; 目前本书提供了 Bash 的入门级知识.

### Courses

#### [Introduction to Linux (LFS101x-1)](https://www.edx.org/course/introduction-linux-linuxfoundationx-lfs101x-1) [Free]

它由 Linux 基金会组织，是学习 Linux 基础知识的绝佳免费课程.  - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

#### [Linux Alternatives to Windows Applications](https://www.udemy.com/linux-alternatives-for-windows-applications/?dtcode=nEiIHId38AHS) [Free]

如果您使用 Windows 并决定切换到 Linux，本课程应该可以帮助您找到他们的替代方案. 它很短，您可以在一天内完成.  - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

### Bash Learning Resources

* [Beautiful Bash: Let's make reading and writing bash scripts fun again!](https://www.slideshare.net/a_z_e_t/inpresentation)
* [Best Practices for Writing Bash Scripts](http://kvz.io/blog/2013/11/21/bash-best-practices/)
* [Shell Style Guide](https://google.github.io/styleguide/shell.xml)
* [Linux Fu: Better Bash Scripting](https://hackaday.com/2017/07/21/linux-fu-better-bash-scripting/)
* [Bash Guide for Beginners](https://linux.die.net/Bash-Beginners-Guide/)
* [Advanced Bash-Scripting Guide](https://linux.die.net/abs-guide/)


## X Desktop Environments

&gt; 你不能谈论统一的 Linux 外观，因为没有这样的东西.

![relevant XKCD](http://imgs.xkcd.com/comics/standards.png)

#### [GNOME](https://www.gnome.org)

 &gt; GNOME 3 是一种使用计算机的简单而优雅的方式. 它旨在让您掌控并为每个人带来自由.  GNOME 3 由 GNOME 社区开发，GNOME 社区是一个多元化的国际贡献者团体，由一个独立的非营利基金会提供支持.

![screenshot](https://www.gnome.org/wp-content/uploads/2015/03/activities-overview-3.16-940x529.png)

#### [KDE](https://www.kde.org)

 &gt; The KDE® Community 是一个国际技术团队，致力于创造免费且用户友好的计算体验，提供先进的图形桌面、各种用于通信、工作、教育和娱乐的应用程序以及一个可轻松构建新应用程序的平台. 我们非常注重为新旧问题寻找创新解决方案，营造充满活力的实验氛围.

![screenshot](https://www.kde.org/announcements/plasma5.0/screenshots/desktop.png)

#### [Xfce](http://www.xfce.org/)

 &gt; Xfce 是用于类 UNIX 操作系统的轻量级桌面环境. 它的目标是快速和低系统资源，同时仍然具有视觉吸引力和用户友好性.

![screenshot](https://upload.wikimedia.org/wikipedia/commons/7/71/Xfce-4.4.png)

#### [LXDE](http://lxde.org/)

 &gt; “轻量级 X11 桌面环境”是一个性能极快且节能的桌面环境. 它由国际开发人员社区维护，具有漂亮的界面、多语言支持、标准键盘快捷键和选项卡式文件浏览等附加功能. 与其他环境相比，LXDE 使用更少的 CPU 和更少的 RAM. 它专为硬件规格较低的云计算机而设计，例如上网本、移动设备（例如 MID）或旧计算机.  LXDE 可以安装在许多 Linux 发行版上，包括 Debian、Fedora、OpenSUSE 和 Ubuntu. 它是 Knoppix 和 lubuntu 的标准.  LXDE 也可以在 OpenSolaris 和 BSD 上运行.  LXDE 提供快速的桌面体验； 与云中的应用程序轻松连接.  LXDE 支持丰富的程序，可以随 Linux 系统本地安装.  LXDE 的源代码部分根据 GNU 通用公共许可证的条款获得许可，部分根据 LGPL 获得许可.

![screenshot](https://upload.wikimedia.org/wikipedia/commons/4/4c/LXDE_desktop_full.png)

#### Other Desktop Environments

* [Cinnamon](http://developer.linuxmint.com/projects/cinnamon-projects.html) - 努力提供传统的用户体验.
* [EDE](https://edeproject.org/) - 小型桌面环境，响应迅速，资源使用率低，并且具有熟悉的外观和感觉.
* [LXQt](http://lxqt.org/)  - Qt 端口和即将推出的轻量级桌面环境 LXDE 版本. 它是 LXDE-Qt 和 Razor-qt 项目合并的产物：一个轻量级、模块化、速度极快且用户友好的桌面环境.
* [MATE](http://www.mate-desktop.org/)  - 为使用传统隐喻的 Linux 用户提供直观且有吸引力的桌面.  GNOME 2 的分支.
* [Pantheon](https://elementary.io)  - Pantheon 是最初为 elementary OS 发行版创建的默认桌面环境. 桌面与 GNOME Shell 和 macOS 有一些相似之处.

## X Windows Managers

* [9wm](http://unauthorised.org/dhog/9wm.html) - 尝试在 X 强加的约束范围内尽可能模拟 Plan 9 窗口管理器 8-1/2 的窗口管理器.
* [awesome](https://awesomewm.org/) - 高度可配置的 X 窗口管理器.快速且可扩展.
* [Blackbox](https://github.com/bradleythughes/blackbox)  - X 窗口系统的轻量级窗口管理器，没有库依赖性. 使用 C++ 构建.
* [bspwm](https://github.com/baskerville/bspwm) - 将窗口表示为完整二叉树的叶子的平铺窗口管理器.
* [Compiz](https://launchpad.net/compiz)  - OpenGL 合成窗口管理器. 它有一个插件系统，可以在运行时更改.
* [dwm](http://dwm.suckless.org/)  - X 的动态窗口管理器.它管理平铺、单片和浮动布局中的窗口. 所有布局都可以动态应用，优化应用程序和执行任务的环境.
* [Enlightenment](http://www.enlightenment.org/) - 窗口管理器与一整套库捆绑在一起，可帮助您创建漂亮的用户界面.
* [Fluxbox](http://www.fluxbox.org/)  - X 的窗口管理器，轻巧且易于操作，但功能齐全，可提供轻松快速的桌面体验. 使用 C++ 构建.
* [FVWM](http://fvwm.org/) - 适用于 X 的 ICCCM 兼容多虚拟桌面窗口管理器.非常强大.
* [i3](http://i3wm.org/)  - 平铺窗口管理器.  BSD 许可. 主要针对高级用户和开发人员.
* [IceWM](https://ice-wm.org/) - 以快速、简单且不妨碍用户为目标的窗口管理器.
* [JWM](http://www.joewing.net/projects/jwm/)  - X11 的轻量级窗口管理器. 较旧和/或功能较弱的系统的不错选择，但完全能够在现代系统上运行. 使用 C 构建.
* [Matchbox](https://www.yoctoproject.org/software-item/matchbox/) - X 在非桌面嵌入式平台上运行的环境，例如手持设备、机顶盒、信息亭和任何其他屏幕空间、输入机制或系统资源有限的平台.
* [Mutter](https://download.gnome.org/sources/mutter/) - X 的窗口管理器.GNOME 3 中的默认窗口管理器.
* [Openbox](http://openbox.org/wiki/Main_Page) - 高度可配置的窗口管理器，具有广泛的标准支持.
* [ratpoison](http://www.nongnu.org/ratpoison/)  - 一个简单的窗口管理器，没有库依赖性，没有图形，也没有装饰. 以 GNU Screen 为蓝本.
* [Sawfish](http://sawfish.tuxfamily.org/)  - 可扩展的窗口管理器. 它的目标是尽可能以最灵活和最吸引人的方式管理窗口. 使用基于 Lisp 的脚本语言构建.
* [wmii](https://code.google.com/p/wmii/) - 小型、可编写脚本的窗口管理器，具有 9P 文件系统界面和类似 acme 的布局.
* [xmonad](http://xmonad.org/)  - 动态平铺 X11 窗口管理器. 通过自动对齐和搜索窗口使工作更轻松. 使用 Haskell 构建.


## Applications

您应该使用的优秀 Linux 应用程序列表.

如果您正在寻找您最喜欢的文本编辑器的一些专业提示，您可能会对 [awesome-atom](https://github.com/mehcode/awesome-atom), [sublime-bookmarks](https://github.com/dreikanter/sublime-bookmarks), [vim-galore](https://github.com/mhinz/vim-galore), [awesome-emacs](https://github.com/emacs-tw/awesome-emacs)， 或者 [awesome-vscode](https://github.com/viatsko/awesome-vscode).

### GUI-based Applications

#### GNOME-based

* [Builder](https://wiki.gnome.org/Apps/Builder) - GNOME 的 IDE，专注于将 GNOME 平台的强大功能带给更多的开发人员.
* [Evince](https://wiki.gnome.org/Apps/Evince) - GNOME 平台上最流行的文档查看器.
* [Gedit](https://wiki.gnome.org/Apps/Gedit) - 强大的通用文本编辑器.
* [Polari](https://wiki.gnome.org/Apps/Polari) - 易于使用的 IRC 客户端.
* [To Do](https://wiki.gnome.org/Apps/Todo) - 专为适合您的 GNOME 桌面而设计的简约个人任务管理器.

有关更多基于 GNOME 的应用程序，请访问：https://wiki.gnome.org/Apps

#### Pantheon-based

* [FeedReader](https://jangernert.github.io/FeedReader/) - RSS 桌面客户端能够与多种在线服务集成.
* [Go For It!](http://manuel-kehl.de/projects/go-for-it/) - 带有内置生产力计时器的待办事项列表.
* [NaSC](http://parnold-x.github.io/nasc/) - 智能计算器应用程序.
* [Spice-Up](https://github.com/Philip-Scott/Spice-up) - 桌面演示应用程序.
* [Vocal](http://vocalproject.net/) - 现代桌面的播客客户端.

For more Pantheon-based apps, visit [elementary-apps](https://quassy.github.io/elementary-apps/).

#### KDE-based

* [Dolphin](https://userbase.kde.org/Dolphin) - 专注于可用性的 KDE 文件管理器.
* [Krita](https://krita.org/en/) - 绘画程序.

有关更多基于 KDE 的应用程序，请访问：https://www.kde.org/applications/

#### Not based on any desktop environment

* [Atom](https://atom.io) - Hackable text editor for the 21st century.
* [ghostwriter](http://wereturtle.github.io/ghostwriter/) - 无干扰的 Markdown 编辑器.
* [GParted](https://gparted.sourceforge.io/) - 最流行的磁盘分区软件.
* [Kodi](https://kodi.tv/) - 最受欢迎的娱乐中心.
* [Zathura](https://pwmt.org/projects/zathura/)  - 高度可定制的文档查看器. 它提供了一个简约且节省空间的界面以及主要侧重于键盘交互的简单使用.
* [Etcher](https://www.balena.io/etcher/) - 安全轻松地将操作系统映像闪存到 SD 卡和 USB 驱动器. 

#### Third-party clients for online services

 &gt; **问：** 为什么要第三方应用程序？ 为什么不是官方客户端？
>
&gt; **A:** 因为，在 99% 的情况下，官方客户端是专有的.

* [Corebird](http://corebird.baedert.org/) - 推特客户端.
* [GNOME Twitch](http://gnome-twitch.vinszent.com/) - 抽搐播放器.
* [Caprine](https://github.com/sindresorhus/caprine/) - Facebook 的 Messenger 客户端，增加了一些隐私功能.
* [PB for Desktop](https://github.com/sidneys/pb-for-desktop) - Pushbullet 客户端.
* [ramme](https://github.com/terkelg/ramme) - Instagram 客户端.
* [Whatever](https://github.com/CellarD0-0r/whatever) - 基于网页版的印象笔记客户端.

#### Package management and creation tools

Distro-oriented:

* [Y PPA Manager](https://launchpad.net/y-ppa-manager) (Ubuntu) - 管理 PPA 和搜索包.
* [pirut](http://fedoraproject.org/wiki/Tools/pirut) (Fedora) - 提供一组用于管理软件的图形工具.
* [Synaptics](http://www.nongnu.org/synaptic/) （Debian 和 `.deb` 用户）- `apt` 的图形包管理程序.
* [YaST](https://en.opensuse.org/YaST_Software_Management) (openSUSE) - openSUSE 上的主要包管理工具.
* [dnfdragora](https://github.com/manatools/dnfdragora) (Fedora) - `dnf` 包管理器的 GUI.
* [Yay](https://github.com/Jguer/yay) (Arch) - Yay 是 `pacman` 的众多包装器之一，它自动从 AUR 下载和安装软件包，可以找到完整列表 [here](https://wiki.archlinux.org/index.php/AUR_helpers).
* [Aura](https://github.com/aurapm/aura) (Arch) - 安全的多语言包管理器.

Distro-independent:

* [AppImageKit](https://github.com/probonopd/AppImageKit) - 使用 AppImageKit，您可以将应用程序打包在 [AppImage](http://appimage.org/) 在常见的基于 Linux 的操作系统上运行的格式，例如 RHEL、CentOS、Ubuntu、Fedora、debian 和衍生产品； 一个应用程序 = 一个文件.

### Console-based Applications and Tools

您可能也有兴趣查看 [awesome-shell](https://github.com/alebcay/awesome-shell), [awesome-bash](https://github.com/awesome-lists/awesome-bash), [awesome-zsh-plugins](https://github.com/unix或者n/awesome-zsh-plugins) 或者 [awesome-fish](https://github.com/jbucaran/awesome-fish).

* [cmus](https://cmus.github.io/) - 小巧、快速且功能强大的控制台音乐播放器.
* [fuck](https://github.com/nvbn/thefuck) - 命令行工具，可纠正您之前输入错误的命令.
* [git](https://git-scm.com/) - 分布式版本控制系统，旨在快速高效地处理从小型项目到大型项目的所有内容.
* [glances](https://nicolargo.github.io/glances/) - 跨平台系统监控工具.
* [htop](http://hisham.hm/htop/) - 美观、可定制的任务管理器.
* [nano](http://www.nano-editor.org) - 简单易用的文本编辑器.
* [photorec](http://www.cgsecurity.org/wiki/PhotoRec) - 用于恢复已删除文件的有用工具.
* [ranger](https://github.com/ranger/ranger) - 受 Vim 启发的控制台文件管理器.
* [screenFetch](https://github.com/KittyKatt/screenFetch) - 在终端中获取系统/主题信息.
* [shellcheck](https://github.com/koalaman/shellcheck) - shell脚本的静态分析工具.
* [speed-test](https://github.com/sindresorhus/speed-test) - 测试您的互联网连接速度并使用 ping [speedtest.net](http://www.speedtest.net/).
* [testdisk](http://www.cgsecurity.org/wiki/TestDisk) - 磁盘分区恢复工具.
* [tig](https://github.com/jonas/tig)  - git 的文本模式界面. 它主要用作 Git 存储库浏览器.
* [vim](http://vim.org) - 高级文本编辑器，旨在提供事实上的 Unix 编辑器“Vi”的强大功能，并具有更完整的功能集.
* [vtop](https://github.com/MrRio/vtop) - 易于扩展的活动监视器.
* [wavemon](https://github.com/uoaerg/wavemon) - 无线网络设备的监控应用程序.
* [youtube-dl](https://github.com/rg3/youtube-dl) - 从 YouTube 和其他视频网站下载视频的工具.

## Useful Websites

#### [Compute Freely](http://computefreely.org/)

 &gt; 对于自由和开源软件以及对 Linux 感兴趣的人来说，这是一个友好的起点.

#### [AlternativeTo](http://alternativeto.net)

 &gt; 为您已经使用的软件寻找更好的替代品，或者为您不能或不想使用的软件寻找替代品.

#### [Linux Foundation](https://www.linuxfoundation.org/)

 &gt; Linux 基金会是一个致力于促进 Linux 发展的非营利性联盟.  Linux 基金会成立于 2000 年，赞助 Linux 创始人 Linus Torvalds 的工作，并得到来自世界各地领先的 Linux 和开源公司以及开发人员的支持.

#### [Linux.com](http://www.linux.com/)

&gt; 对于社区，Linux.com 努力成为跨服务器、桌面/上网本、移动和嵌入式领域的知情、合理和智能 Linux 信息、软件、文档和答案的中心来源.

#### [Linux.org](http://www.linux.org/)

虽然它的设计已经过时，但 Linux.org（可能）是最受欢迎的论坛，并且它充满了按难度分类的很棒的 Linux 教程.  - [@aleksandar-todorovic](https://github.com/aleksandar-todorovic)

#### [Kernel.org](https://www.kernel.org/)

&gt; Linux 内核组织是一家成立于 2002 年的加州公共利益公司，旨在向公众免费分发 Linux 内核和其他开源软件.

#### [Opensource.com](http://opensource.com)

&gt; Opensource.com 是一个在线出版物，重点介绍开源如何应用于不同领域，包括商业、教育、政府、卫生、法律和生活的其他学科.

 &gt; 我们的目标是通过分享开源运动来推进开源之路. 我们的读者社区由相信开放参与和分享可以解决我们当今面临的商业、社会、环境和技术挑战的人组成.

#### [Linux.die](https://linux.die.net/)

&gt; Linux.die 是一个包含 Linux 文档、教程、书籍等的资源.

## License

此存储库已获得许可 [Do What the Fuck You Want to Public License](http://www.wtfpl.net/) . 其完整内容位于 `LICENSE` 文件中.
