<div class="github-widget" data-repo="LucasBassetti/awesome-less"></div>
## Awesome Less [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://cdn.rawgit.com/LucasBassetti/awesome-less/14437854/less-logo.svg" align="right" height="80">](http://lesscss.org/)

 &gt; 精选的 Less 框架、库、风格指南、文章和资源列表. 主要思想是每个人都可以在这里做出贡献，因此我们可以集中所有关于 Less 的信息并保持最新.


## About

 Less 是一种开源的动态样式表语言，可以编译成层叠样式表（CSS）并在客户端或服务器端运行.  Less 由 Alexis Sellier 设计，受 Sass 的影响，并影响了 Sass 的新“SCSS”语法，它采用了类似 CSS 的块格式化语法.  Less 提供了以下机制：变量、嵌套、mixins、运算符和函数；  Less 和其他 CSS 预编译器之间的主要区别在于 Less 允许浏览器通过 Less 进行实时编译. 字体： [Wikipedia](https://en.wikipedia.org/wiki/Less_(stylesheet_language))


## Getting Started

- [Beginner's Guide](http://www.hongkiat.com/blog/less-basic/)
- [Getting Started with Less](https://scotch.io/tutorials/getting-started-with-less)
- [Learn in 10 Minutes](http://tutorialzine.com/2015/07/learn-less-in-10-minutes-or-less/)
- [Official Guide](http://lesscss.org/)
- [Official Repository](https://github.com/less/less.js)


## UI/Theme Frameworks and Components

- [1pxdeep](http://rriepe.github.io/1pxdeep/) - 将相对视觉权重设计或配色方案设计引入 Bootstrap.
- [Ant Design](https://github.com/ant-design/ant-design/) - 企业级 UI 设计语言和基于 React 的实现.
- [Bootstrap a11y theme](https://github.com/bassjobsen/bootstrap-a11y-theme) - 使 Bootstrap 开发人员更容易访问 Web.
- [Bootstrap 3](http://getbootstrap.com/) - Bootstrap 是最流行的 HTML、CSS 和 JS 框架，用于在 Web 上开发响应式、移动优先的项目.
- [Bootswatch](http://bootswatch.com/) - Bootstrap 的免费主题集合.
- [Cardinal](http://cardinalcss.com/) - 面向构建响应式 Web 应用程序的前端开发人员的小型“移动优先”CSS 框架.
- [CSSHórus](https://github.com/firminoweb/csshorus) - 用于开发响应式和移动网站的库.
- [Flat UI Free](http://designmodo.github.io/Flat-UI/) - Bootstrap 的主题和框架.
- [JBST](http://jbst.eu/) - 可用作独立网站构建器或创建 WordPress 主题的主题框架.
- [Less Rails](https://github.com/metaskills/less-rails) - 减少 Rails.
- [Material Design for Bootstrap](https://github.com/FezVrasta/bootstrap-material-design)  - Bootstrap 的 Material Design 是 Bootstrap V3 兼容主题； 这是在基于 Bootstrap 3 的应用程序中使用 Google 新的 Material Design 指南的一种简单方法.
- [Metro UI CSS](http://metroui.org.ua/) - 用于创建具有类似于 Windows 8 界面的站点的样式集.
- [Schema](http://danmalarkey.github.io/schema/) - 轻量级、反应灵敏且精简的前端 UI 框架.
- [Semantic UI](http://semantic-ui.com/) - 基于自然语言有用原则的 UI 组件框架.
- [UIkit](https://getuikit.com/) - 用于开发 Web 界面的轻量级和模块化前端框架.
- [Wee](https://www.weepower.com/) - 轻量级前端框架，用于逻辑构建复杂的响应式 Web 项目.


## Libraries and Mixins

### Grid

- [Bootstrap Grid Only](https://github.com/zirafa/bootstrap-grid-only)  - 只有 Bootstrap 的响应式网格和响应式实用程序类，没有任何额外功能. 轻巧但功能强大. 风格品味.
- [Framework](https://github.com/jonikorpi/Less-Framework)  - Less Framework 是一个用于设计自适应网站的 CSS 网格系统. 它包含 4 种布局和 3 组排版预设，全部基于单个网格.
- [Flexible Grid System](http://flexible.gs/) - 该框架将让您以前所未有的灵活方式创建您的网络应用程序.
- [Fluidable](http://fluidable.com/)  - Fluidable 是移动优先的响应式网格系统. 它是独立的、轻量级的，并且使用 Less 构建.
- [Grid System](https://github.com/goodpixels/less-grid-system) - 超级易用，独立于标记的网格系统.
- [Less Zen Grid](https://github.com/bassjobsen/LESS-Zen-Grid) - 实施 [Zen Grids](https://github.com/JohnAlbin/zen-grids) 不到.
- [Order.Less](https://github.com/chromice/order.less) - 基线对齐、柱状网格和模块化比例.


### Media Queries

- [CSS and Media Query Strategies](https://github.com/buymeasoda/less-media-queries) - 使用 Less CSS 为现代和传统浏览器开发媒体查询驱动的解决方案.
- [Media Queries Library](https://github.com/mrmlnc/less-mq) - Less 中非常简单的媒体查询.
- [Media Query to Type](https://github.com/himedlooff/media-query-to-type) - 一种创建 IE 特定样式表的方法，该样式表允许 Internet Explorer 8 及以下版本访问媒体查询的内容.


### Color

- [Brand Colors](http://brand-colors.com/) - Sass、Less、Stylus 和 CSS 中提供的 1100 多种流行品牌颜色.
- [More-Colors](http://jasonrobb.github.io/More-Colors.less/) - 在浏览器中设计时更容易进行颜色操作的变量.
- [Open Color](https://github.com/yeun/open-color)  - Open color是UI设计的配色方案. 提供 CSS、SCSS、Less、Stylus、Adobe 库、Photoshop/Illustrator 色板和 Sketch 调色板.


### Animation

- [Animate](https://github.com/joshuapekera/animate) - 使用 Less 创作的 CSS3 关键帧动画库.
- [Animate Less](https://github.com/machito/animate.less) - 丹伊登港 [Animate.css](https://daneden.github.io/animate.css/) 少.
- [Cube Less](https://github.com/sparanoid/cube.less) - 仅使用 CSS（较少）的 3D（动画）立方体，最初由 LeanCloud（又名 AVOS Cloud）使用.
- [Hover](http://ianlunn.github.io/Hover/) - CSS3 驱动的悬停动画效果集合，可应用于链接、按钮、徽标、SVG、特色图像等.
- [Less Burguer](https://github.com/MarkRabey/less-burger) - 港口 [Sass Burger](http://joren.co/sass-burger/) 少.


### Miscellaneous

- [3L](http://mateuszkocz.github.io/3l/) - 混合库.
- [Bidi](https://github.com/danielkatz/less-bidi) - 用于创建双向样式的混合集.
- [Clearless](http://clearleft.github.io/clearless/) - 混合集合.
- [Css3LessPlease](http://chrsr.com/css3lessplease/) - 将 css3please.com 转换为 Less mixins.
- [CssEffects](http://adodson.com/css-effects/) - CSS 样式效果集合.
- [Cssowl](http://cssowl.owl-stars.com/) - Mixin library.
- [Dynamic Stylesheet](https://github.com/mrkrupski/LESS-Dynamic-Stylesheet) - 一组有用的混合.
- [Est](https://github.com/ecomfe/est/) - 	Mixin library.
- [Hexagon](http://db0company.github.io/css-hexagon/) - 生成具有自定义大小和颜色的 CSS 六边形.
- [Homeless](https://github.com/pixelass/homeless) - 有用的功能.
- [Less Elements](http://lesselements.com/) - 一组基本的混合.
- [Lesshat](https://github.com/madebysource/lesshat) - 智能混合库.
- [Lessley](https://github.com/pixelass/lessley) - 用纯 Less 编写的像茉莉花一样的测试套件.
- [Lessmore](https://github.com/belyan/lessmore)  - 混合库. 跨浏览器支持 CSS3 功能等.
- [Normalize](https://github.com/segundofdez/normalize.less) - 模块化著名 [normalize.css](https://github.com/necolas/normalize.css/) 使用更少.
- [Oban](http://oban.io/) - 混合集合.
- [Preboot](https://github.com/mdo/preboot) - 用于编写更好的 CSS 的混合和变量集合.
- [Retina.js](https://github.com/imulus/retinajs) - 用于呈现高分辨率图像变体的 JavaScript、SCSS、Sass、Less 和 Stylus 助手.
- [Shape](https://github.com/fahad19/shape.less) - 各种形状的 mixins 集合.
- [TRRtoolbelt](https://github.com/therebelrobot/tRRtoolbelt.less) - 用于常见操作的混合和函数.


## Style Guides

- [Handshake Style Guide](https://github.com/handshake/less-style-guide) - 本指南介绍了一系列最佳实践和编码约定.
- [WebMD Health Services Style Guide](https://github.com/bitmap/less-styleguide) - 本文档概述了 WebMD 健康服务中的 CSS/Less 最佳实践.


## Ports of Less

### Java

- [JLessC](https://github.com/i-net-software/jlessc) - 更少的编译器完全用 Java 编写.
- [Less Engine](https://github.com/Asual/lesscss-engine) - 在基于 Rhino JVM 的 JavaScript 解释器中运行较少.
- [Less CSS Compiler for Java](https://github.com/marceloverdijk/lesscss-java) - 在基于 Rhino JVM 的 JavaScript 解释器中运行较少.
- [Less4j](https://github.com/SomMeri/less4j) - 本机 Java 实现.
- [Lesscss](https://github.com/houbie/lesscss)  - 使用 Rhino、Nasshorn 或 node.js 引擎运行更少；  1.7.0 兼容.
- [Lesscss Gradle Plugin](https://github.com/houbie/lesscss-gradle-plugin) - 基于 Less 的 Gradle 插件.


### .Net

- [BundleTransformer.Less](http://www.nuget.org/packages/BundleTransformer.Less/) - 用 .Net 编写的编译器.
- [Less CSS for .Net](http://www.dotlesscss.org/) - 用 .Net 编写的编译器.


### PHP

- [ILess](https://github.com/mishal/iless) - 用 Ja​​vascript 编写的 PHP 端口.
- [Lessphp](http://leafo.net/lessphp/) - 用 PHP 编写的编译器.
- [Less.php](http://lessphp.gpeasy.com/) - PHP 端口.


### Python

- [Pyhton Compiler](https://github.com/lesscpy/lesscpy) - 用 Python 编写的编译器.


### Ruby

- [Ruby Compiler](https://github.com/cowboyd/less.rb) - 减少了 Ruby 的 V8 引擎.


### Go

- [Go Compiler](https://github.com/kib357/less-go) - 在嵌入式 Javascript 引擎中运行较少.


## GUIs, Editors and Plugins

- [Atom Linter](https://github.com/josa42/atom-linter-less) - Atom 文本编辑器中的 Linter 插件.
- [CSS 2 Convert](http://css2less.co/) - 自动将 CSS 转换为 Less 的快速方法，就像复制和粘贴一样简单.
- [CSS Less(ish)](https://github.com/kizza/CSS-Less-ish) - Sublime Text 2 &amp; 3 插件，它实现了 css 预处理器（例如 Less）中功能的精简版本.
- [Crunch 2!](http://getcrunch.co/)  - Crunch 2 是一个集成编译的跨平台（Windows、Mac 和 Linux）编辑器. 如果您使用大型 Less 项目，您绝对应该尝试一下，因为您只需要 Less 文件的免费版本.
- [Diamond](https://diamond.js.org) - 为 Sass、Less 和 CSS 构建的依赖管理.
- [Eclipse Less Plugin](http://www.normalesup.org/~simonet/soft/ow/eclipse-less.html) - 此插件通过提供方便的功能来编辑和编译 Less 样式表来扩展 Eclipse IDE.
- [Eclipse Transpiler Plugin](https://github.com/gossi/eclipse-transpiler-plugin) - 自动转换文件的 Eclipse 插件（Less、SASS、CoffeeScript 等）.
- [Emacs](https://github.com/purcell/less-css-mode) - 支持保存时编译的 Emacs 模式.
- [Grunt Contrib](https://github.com/gruntjs/grunt-contrib-less) - Compile Less files to CSS using Grunt.
- [Grunt Lint](https://github.com/jgable/grunt-lesslint) - 使用来自 Grunt 的 CSS Lint 对你的 Less 文件进行 lint.
- [Gulp Less](https://github.com/plus3network/gulp-less) - Gulp 插件.
- [Hayaky](https://github.com/hayaku/hayaku) - Hayaku 是一组有用的脚本，旨在快速进行前端 Web 开发.
- [Hyra Helper](https://github.com/Hyra/less) - CakePHP 插件，仅使用 PHP 即可将 Less 文件转换为 CSS.
- [Koala](http://koala-app.com/) - Koala 是一个跨平台的 GUI 应用程序，用于编译 Less、sass 和 coffeescript.
- [Less for Notepad++](https://github.com/azrafe7/LESS-for-Notepad-plusplus) - Notepad++ 的语法突出显示.
- [Less Sublime](https://github.com/danro/Less-sublime) - Sublime Text 的语法高亮显示.
- [Lesshint](https://github.com/lesshint/lesshint) - 帮助您编写干净一致的 Less 的工具.
- [LiveReload](http://livereload.com/)  - CSS 编辑和图像更改实时应用.  CoffeeScript、SASS、Less 和其他的都可以.
- [SimpleLess](https://wearekiss.com/simpless)  - SimpleLess 是一个简约的 Less 编译器. 只需拖放和编译.
- [Sublime Less2CSS](https://github.com/timdouglas/sublime-less2css) - Sublime Text 2 插件，用于在保存时将 Less 文件编译为 css.
- [SublimeOnSaveBuild](https://github.com/alexnj/SublimeOnSaveBuild) - 在 Sublime Text 2 中保存文件时触发构建.最适合使用 Less、Compass 和任何其他预处理器或 makefile 的 Web 项目.
- [Vim Less](https://github.com/groenewege/vim-less) - 这个 vim 包增加了语法高亮、缩进和自动完成.
- [Visual Studio Web Essentials](http://vswebessentials.com/) - 如果您曾经编写过 CSS、HTML、JavaScript、TypeScript、CoffeeScript 或 Less，那么您会发现许多有用的功能，让您作为开发人员的生活更轻松.
- [Winless](http://lesscss.org/usage/#editors-and-plugins)  - WinLess 最初是 Less.app 的克隆版，它采用功能更完整的方法并具有多种设置. 它还支持从命令行参数开始.


## Online Less Compilers

- [BeautifyTools Less Compiler](http://beautifytools.com/less-compiler.php) - 具有可选格式和缩小功能的在线 Less 编译器 [BeautifyTools](http://beautifytools.com/).
- [EstFiddle](http://ecomfe.github.io/est/fiddle/) - 在线 Less 编译器为 Less 和 est 提供现场演示.允许用户在 1.4.0 之后的所有 Less 版本之间切换，并具有可选的 est/Autoprefixer 功能.
- [ILess](http://demo-iless.rhcloud.com/) - 现场演示 [ILess](https://github.com/mishal/iless) PHP编译器.
- [Leafo](http://leafo.net/lessphp/editor.html) - [Lessphp](http://leafo.net/lessphp/) 现场演示.
- [Less2CSS](http://less2css.org/) - 托管在浏览器中的在线集成开发环境 (IDE)，允许用户实时编辑 Less 并将其编译为 CSS.
- [LessPHP](http://lessphp.gpeasy.com/demo) - [Less.php](http://lessphp.gpeasy.com/) 现场演示.
- [Lesstester](http://lesstester.com/) - Less CSS 的在线编译器.
- [Precess](http://precess.co/) - 实时预处理器编译器.
- [Winless](http://winless.org/online-less-compiler)  - 这个在线 Less 编译器可以帮助你学习 Less. 您可以浏览下面的示例或尝试自己的 Less 代码.


## Online Web IDEs/Playgrounds with Less support

- [CodePen](http://codepen.io/) - CodePen 是网络前端的游乐场.
- [CSSDeck Labs](http://cssdeck.com/labs) - CSDeck Labs 是一个可以快速创建一些涉及 HTML、CSS、JS 代码的实验（或测试用例）的地方.
- [Fiddle Salad](http://fiddlesalad.com/less/) - 具有即时准备编码环境的在线游乐场.
- [JS Bin](http://jsbin.com/) - JS Bin 是专门设计用于帮助 JavaScript 和 CSS 民间测试代码片段的网络应用程序.
- [JsFiddle](http://jsfiddle.net/hb2rsm2x/) - 在线网页编辑器.


## Translations

- [Chinese (中文)](http://lesscss.cn/)
- [Danish](http://lesscss.dk/)
- [German](http://www.lesscss.de)
- [Indonesian](http://bertzzie.com/post/7/dokumentasi-less-bahasa-indonesia)
- [Iranian](http://less-css.ir)
- [Japanese](http://less-ja.studiomohawk.com/)
- [Polish](http://ciembor.github.com/lesscss.org/)
- [Spanish](http://amatellanes.github.io/lesscss.org/)
- [Vietnamese](http://less.eten.vn/)


## Articles

- [An Introduction To Less, And Comparison To Sass](https://www.smashingmagazine.com/2011/09/an-introduction-to-less-and-comparison-to-sass/)
- [Best Less Tutorials : A Comprehensive Guide to Less](http://www.cssauthor.com/less-tutorials/)
- [Doing MORE with Less](https://medium.com/social-tables-tech/doing-more-with-less-256054d19f7d#.a41deg3dx)
- [How to Make a Loops in Less CSS](https://medium.com/@omererkan/how-to-make-a-loops-in-less-css-d74062debef1#.snv6jqw5x)
- [Lets use Less to Create Less CSS not just CSS](https://medium.com/@zamamohammed/lets-use-lessjs-to-create-less-css-not-just-css-2d45d92a62e8#.jsocohrne)
- [Revisiting Less](https://medium.com/@ddprrt/revisiting-less-50b741bd884#.oyion811m)


### Books

- [Instant Less CSS Preprocessor How-to](https://www.packtpub.com/web-development/instant-less-css-preprocessor-how-instant)
- [Less Web Development Essentials](http://pdf.th7.cn/down/files/1508/Less%20Web%20Development%20Essentials,%202nd%20Edition.pdf)
- [Learning Less](https://www.packtpub.com/web-development/learning-lessjs)


## Videos

- [Learning Less](https://www.packtpub.com/web-development/learning-less-video)
- [Less (CSS pre-processor) Tutorials](https://www.youtube.com/watch?v=oh7_iZWvIyU&list=PLE42615v2IxlxVyGZd0rKnOzbqUtUiekE)
- [Less CSS Tutorials for Beginners](https://www.youtube.com/watch?v=YQYJUeokqOY&list=PL6gx4Cwl9DGCshbAx1JpBtNoKh8iKAAiy)
- [Less CSS - Tutorials for Beginners](https://www.youtube.com/watch?v=-D5mWO9_vLI&list=PLLa1ZAmCB2zjEZ4QNLDi4173_xIGeV6nC)


## Experiments

- [3D Buttons](https://codepen.io/MamayAlexander/pen/aAsiq)
- [Border Radiuses Mixin](https://codepen.io/eky/pen/dCmnp)
- [CSS3 Color Wheel](https://codepen.io/bitmap/pen/eBbHt)
- [DEMO: Variables](https://codepen.io/ericrasch/pen/uGlvA)
- [Easy Buttons](https://codepen.io/octavioamu/pen/zJexw)
- [Linear Gradient Mixin](https://codepen.io/eky/pen/eAnCI)
- [Navbar](https://codepen.io/lukasdietrich/pen/mkeAJ)
- [Responsive Grid](https://codepen.io/mecarter/pen/idKqg)
- [Sizable CSS-only Icons](https://codepen.io/ericrasch/pen/rndaF)
- [Triangle / Arrow Mixin](https://codepen.io/eky/pen/AaCwF)
- [More...](https://codepen.io/tag/less/)


## Community

- [Contributing to Less](https://github.com/less/less.js/blob/master/CONTRIBUTING.md)
- [Freenode](http://webchat.freenode.net/?randomnick=1&channels=%23%23lesscss)
- [Medium](https://medium.com/search?q=less%20css)
- [Quora](https://www.quora.com/topic/LESS-stylesheet-language)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/less)
- [Twitter](https://twitter.com/hashtag/lesscss)


## Contributing

随时欢迎您的贡献！ [Click Here to read the guidelines](https://github.com/LucasBassetti/awesome-less/blob/master/CONTRIBUTING.md).


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Lucas Bassetti](http://lucasbassetti.com.br) 已放弃该作品的所有版权和相关或邻接权.
