<div class="github-widget" data-repo="chiraggude/awesome-laravel"></div>
## Awesome Laravel [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Build Status](https://img.shields.io/travis/chiraggude/awesome-laravel/master.svg?style=flat)](https://travis-ci.org/chiraggude/awesome-laravel)

&gt; 来自 Laravel 生态系统的精选书签、包、教程、视频和其他很棒的资源的精选列表.

灵感来自 [ziadoz/awesome-php](https://github.com/ziadoz/awesome-php)



## Essentials

* [Laravel](https://laravel.com) ([Documentation](https://laravel.com/docs))
* [Laravel API Reference](https://laravel.com/api/master/)
* [Lumen](https://lumen.laravel.com) ([Documentation](https://lumen.laravel.com/docs))
* [Laracasts](https://laracasts.com)
* [Laravel News](https://laravel-news.com) ([Archive](https://laravel-news.com/archive/))

## Packages

* [Packagist](https://packagist.org/)
* [Laravel Collective](https://laravelcollective.com/)
* [Packalyst](http://packalyst.com/)
* [Spatie](https://spatie.be/en/opensource/laravel)

## Popular Packages

 &gt; 这是 Laravel 项目中经常使用的文档齐全、经过测试的软件包列表. 如果您正在寻找 PHP 包的详尽列表，请查看上面提到的包存储库.

##### Developer Tools

* [Scaffold Interface](https://github.com/amranidev/scaffold-interface) - Laravel 的智能 CRUD 生成器
* [IDE Helper](https://github.com/barryvdh/laravel-ide-helper) - 为 IDE 自动完成生成帮助文件
* [Laravel 5 Extended Generators](https://github.com/laracasts/Laravel-5-Generators-Extended) - 扩展内置文件生成器
* [Laravel API/Scaffold/CRUD Generator](https://github.com/InfyOmLabs/laravel-generator) - 用于 API、CRUD 脚手架等的生成器.
* [Laravel Tinx](https://github.com/furey/tinx) - 从 Tinker 内部重新加载你的 Laravel Tinker 会话
* [Laravel API Documentation Generator](https://github.com/mpociot/laravel-apidoc-generator) - 自动生成您的 API 文档
* [Laravel Packager](https://github.com/Jeroen-G/Laravel-Packager) - 用于创建 Laravel 包的 CLI 工具
* [Workbench Export to Migrations](https://github.com/beckenrode/mysql-workbench-export-laravel-5-migrations) - 用于将模型导出到 Laravel 迁移的工作台插件
* [Laravel Decomposer](https://github.com/lubusIN/laravel-decomposer) - 列出所有已安装的软件包、它们的依赖项、应用程序和服务器详细信息
* [LaRecipe](https://github.com/saleem-hadad/larecipe) - 在 Laravel 应用程序中使用 Markdown 为您的产品编写精美的文档.
* [Prequel](https://github.com/Protoqol/Prequel/) - 为 Laravel 调整的清晰简洁的数据库管理 GUI.

##### Testing & Debugging

* [Laravel TestTools](https://chrome.google.com/webstore/detail/laravel-testtools/ddieaepnbjhgcbddafciempnibnfnakl) - 在使用您的应用程序时生成 Laravel 集成测试的 Chrome 扩展
* [Laravel Test Factory Generator](https://github.com/mpociot/laravel-test-factory-helper) - 从现有模型生成 Laravel 测试工厂
* [Clockwork](https://github.com/itsgoingd/clockwork) - 集成了用于调试和分析应用程序的 Clockwork Chrome 扩展
* [Debug Bar](https://github.com/barryvdh/laravel-debugbar) - 将 PHP 调试栏与 Laravel 集成
* [Ignition](https://github.com/facade/ignition) - Laravel 应用程序的漂亮错误页面
* [Laravel 5 Log Viewer](https://github.com/rap2hpoutre/laravel-log-viewer) - 日志查看器
* [LogViewer](https://github.com/ARCANEDEV/LogViewer) - 提供日志查看器
* [LERN](https://github.com/tylercd100/lern#lern-laravel-exception-recorder-and-notifier) - 将异常记录到数据库中并向您发送通知
* [Mail Preview](https://github.com/themsaid/laravel-mail-preview) - 在网络浏览器或邮件客户端中预览发送的邮件
* [Laravel Tracy](https://github.com/recca0120/laravel-tracy) - 一个集成 Nette Tracy 调试器的 Laravel 包
* [Laravel Terminal](https://github.com/recca0120/laravel-terminal) - 在网络浏览器中运行工匠
* [Laravel API Tester](https://github.com/asvae/laravel-api-tester) - 具有 Laravel 路由的类似 Postman 的工具
* [Laravel Tail](https://github.com/spatie/laravel-tail) - 缺少的尾巴命令
* [Laravel Telescope](https://github.com/laravel/telescope) - Laravel Telescope 是 Laravel 框架的优雅调试助手

##### Authentication & Authorization

* [Bouncer](https://github.com/JosephSilber/bouncer) - 角色和权限
* [Laratrust](https://github.com/santigarcor/laratrust) - 角色、权限和团队
* [Entrust](https://github.com/Zizaco/entrust) - 基于角色的权限
* [JWT Auth](https://github.com/tymondesigns/jwt-auth) - 用于 API 的 JSON Web Token 身份验证
* [Laravel Permission](https://github.com/spatie/laravel-permission) - 将用户与角色和权限相关联
* [Defender](https://github.com/artesaos/defender) - 角色和权限
* [OAuth2 Server Laravel](https://github.com/lucadegasperi/oauth2-server-laravel) - OAuth 2.0授权服务器和资源服务器
* [Socialite](https://github.com/laravel/socialite) - OAuth authentication with Facebook, Google, Twitter etc.
* [Socialite Providers 2.0](http://socialiteproviders.github.io/) - 支持 Lumen 的 100 多个社会名流社交身份验证提供商
* [Google2FA](https://github.com/antonioribeiro/google2fa) - 谷歌双因素认证模块
* [Laravel User Verification](https://github.com/jrean/laravel-user-verification) - 处理用户验证流程并验证电子邮件
* [Adldap2 Laravel](https://github.com/Adldap2/Adldap2-Laravel) - LDAP 身份验证和 Active Directory 管理
* [Doorman](https://github.com/clarkeash/doorman) - 使用邀请码限制对 Laravel 应用程序的访问
* [Laravel Heyman](https://github.com/imanghafoori1/laravel-heyman) - Heyman 继续上述角色权限包停止的地方

##### Utilities

* [Awes.io](https://github.com/awes-io/awes-io) - 基于 Vue (Nuxt.js)、TailwindCSS 和 Laravel 作为后端的 CRM、SaaS、ERP 样板.
* [Artisan View](https://github.com/svenluijten/artisan-view) - 通过工匠管理 Laravel 项目中的视图
* [Bootstrapper](https://github.com/patricktalmadge/bootstrapper/) - 一组用于创建 Bootstrap 3 标记的类
* [Captcha](https://github.com/mewebstudio/captcha) - 一个反机器人图像验证码系统
* [Charts](https://github.com/ConsoleTVs/Charts) - 用于创建交互式图表的多库图表包
* [Lavacharts](https://github.com/kevinkhill/lavacharts) - 由 Google Chart API 提供支持的 PHP 图表和图形
* [Eloquent Filter](https://github.com/Tucker-Eric/EloquentFilter) - 过滤模型及其关系
* [Eloquent Sluggable](https://github.com/cviebrock/eloquent-sluggable) - 为 Eloquent 模型创建 slug
* [Eloquent Sortable](https://github.com/spatie/eloquent-sortable) - Eloquent 模型的可排序行为
* [HTML](https://github.com/LaravelCollective/html) - Laravel 的 HTML 和表单生成器
* [Multi-tenant](https://github.com/hyn/multi-tenant) - 灵活的多租户与路由、资产和数据库的安全分离
* [Laravel Form Builder](https://github.com/kristijanhusak/laravel-form-builder) - 受 Symfony 表单生成器启发的表单生成器
* [Laravel Activitylog](https://github.com/spatie/laravel-activitylog) - 在 Laravel 应用程序中记录活动
* [Laravel Auditing](https://github.com/owen-it/laravel-auditing) - 对 Eloquent 模型的审核
* [Laravel Breadcrumbs](https://github.com/davejamesmiller/laravel-breadcrumbs) - 创建和管理面包屑
* [Laravel Collection Macros](https://github.com/spatie/laravel-collection-macros) - 一组方便的集合宏
* [Laravel Cookie Consent](https://github.com/spatie/laravel-cookie-consent) - 让你的 Laravel 应用程序符合疯狂的欧盟 cookie 法
* [Laravel Datatables](https://github.com/yajra/laravel-datatables) - jQuery 数据表 API
* [Laravel GeoIP](https://github.com/Torann/laravel-geoip) - 根据网站访问者的 IP 地址确定网站访问者的位置
* [Laravel Hashids](https://github.com/vinkla/laravel-hashids) - 使用生成唯一的、非连续的 id [Hashids](http://hashids.org/php/)
* [Laravel Impersonate](https://github.com/404labfr/laravel-impersonate) - 作为您的用户之一进行身份验证的软件包
* [Laravel Mailbox](https://github.com/beyondcode/laravel-mailbox) - 处理传入电子邮件的包
* [Laravel Markdown](https://github.com/GrahamCampbell/Laravel-Markdown) - CommonMark 降价解析器
* [Laravel Menu](https://github.com/spatie/laravel-menu) - Laravel 的 HTML 菜单生成器
* [Laravel Talk](https://github.com/nahid/talk) - 实时用户消息系统
* [Laravel Messenger](https://github.com/cmgmyr/laravel-messenger) - 用户消息系统
* [Laravel Moderation](https://github.com/hootlex/laravel-moderation) - 批准或拒绝资源，如帖子、评论、用户等.
* [Laravel Tags](https://github.com/spatie/laravel-tags) - 添加标签和可标记行为
* [Laravel Stats Tracker](https://github.com/antonioribeiro/tracker) - 从请求中收集信息以识别和存储
* [Listify](https://github.com/lookitsatravis/listify) - 为任何 Eloquent 模型添加排序/排序功能
* [noCAPTCHA](https://github.com/ARCANEDEV/noCAPTCHA) - 谷歌新的 noCAPTCHA (reCAPTCHA) 助手
* [Purifier](https://github.com/mewebstudio/purifier) - HTML过滤器
* [Revisionable](https://github.com/VentureCraft/revisionable) - 为 Eloquent 模型创建修订历史
* [SEOTools](https://github.com/artesaos/seotools) - 一些常见的 SEO 技术的助手
* [Page Cache](https://github.com/JosephSilber/page-cache) - 将响应缓存为磁盘上的静态文件，以实现闪电般的快速页面加载
* [Laravel Setting](https://github.com/anlutro/laravel-settings) - 存储在 JSON 文件中的持久配置设置
* [Friendship](https://github.com/hootlex/laravel-friendships) - 友情管理系统
* [Teamwork](https://github.com/mpociot/teamwork) - 用户与邀请系统的团队联系
* [Validating](https://github.com/dwightwatson/validating) - 用于验证 Eloquent 模型的特征
* [VAT Calculator](https://github.com/mpociot/vat-calculator) - 处理与欧盟 MOSS 增值税法规相关的所有难题
* [Laravel UUID](https://github.com/webpatser/laravel-uuid) - 根据RFC 4122标准生成UUID
* [Laravel Installer](https://github.com/RachidLaasri/LaravelInstaller) - 允许用户按照安装向导安装您的应用程序，例如 WordPress
* [Laravel Modules](https://github.com/nWidart/laravel-modules) - 简单的模块管理
* [Laravel Phone](https://github.com/Propaganistas/Laravel-Phone) - 电话号码验证器和格式化器
* [Laravel Ban](https://github.com/cybercog/laravel-ban) - 简化阻止和禁止 Eloquent 模型
* [Laravel Proxy](https://github.com/fideloper/TrustedProxy) - 在负载均衡器或其他中介后面处理会话.
* [Laravel Video Chat](https://github.com/PHPJunior/laravel-video-chat) - 使用 Socket.IO 和 WebRTC 进行视频聊天
* [Widgets for Laravel](https://github.com/arrilot/laravel-widgets) - 查看作曲家的强大替代方案.
* [Secure Headers](https://github.com/BePsvPT/secure-headers) - 将安全相关的标头添加到 HTTP 响应
* [Laravel Nova](https://nova.laravel.com/) - Nova 是 Laravel 设计精美的管理面板
* [stancl/tenancy](https://github.com/stancl/tenancy)  - Laravel 应用程序的自动租赁. 无需更改代码.

##### Media & Document Management

* [Intervention Image](https://github.com/Intervention/image) - 用于创建、编辑和合成图像的图像处理库
* [Laravel ImageUp](https://github.com/qcod/laravel-imageup) - 另一个图像处理包，增加了大量的额外功能
* [Laravel Glide](https://github.com/spatie/laravel-glide) - 使用 Glide 轻松转换图像
* [Laravel MediaLibrary](https://github.com/spatie/laravel-medialibrary) - 将文件与 Eloquent 模型相关联
* [Laravel Snappy](https://github.com/barryvdh/laravel-snappy) - 使用 wkhtmltopdf 的 HTML 到 PDF 生成器
* [Laravel DOMPDF](https://github.com/barryvdh/laravel-dompdf) - 使用 HTML 到 PDF 生成器 [dompdf](https://github.com/dompdf/dompdf)
* [Laravel Stapler](https://github.com/CodeSleeve/laravel-stapler) - 基于 ORM 的文件上传管理器
* [Laravel Excel](https://github.com/Maatwebsite/Laravel-Excel) - 导入和导出 Excel 和 CSV 文件
* [Fast Excel](https://github.com/rap2hpoutre/fast-excel) - 为 Laravel 快速导入和导出 XLSX、CSV 和 ODT
* [Laravolt Avatar](https://github.com/laravolt/avatar) - 即插即用头像，将姓名、电子邮件和任何其他字符串变成漂亮的头像（或 gravatar），毫不费力.
* [Laravel FFmpeg](https://github.com/pascalbaljetmedia/laravel-ffmpeg) - 这个包为 Laravel 5.8 提供了与 FFmpeg 的集成.

##### Integration with Javascript

* [Laroute](https://github.com/aaronlord/laroute) - 从 JavaScript 生成 Laravel 路由 URL
* [PHP Vars to JavaScript Transformer](https://github.com/laracasts/PHP-Vars-To-Js-Transformer) - 将服务器端字符串/数组/集合/任何内容传递给 JavaScript
* [Javascript Validation](https://github.com/proengsoft/laravel-jsvalidation) - 使用验证规则、消息、FormRequest 和验证器在客户端验证表单
* [Laravel Pjax](https://github.com/spatie/laravel-pjax) - 一个 Pjax 中间件
* [Laravel Blade Javascript](https://github.com/spatie/laravel-blade-javascript) - 将变量导出到 JavaScript 的 Blade 指令
* [Ziggy](https://github.com/tightenco/ziggy) - 在 JavaScript 中使用你的 Laravel 命名路由
* [LiveWire](https://github.com/livewire/livewire) - 神奇的 Laravel 前端框架

##### Databases, ORMs, Migrations & Seeding

* [Backup Manager](https://github.com/backup-manager/laravel) - 从 S3、Dropbox、SFTP 等备份和恢复数据库.
* [Laravel Nestedset](https://github.com/lazychaser/laravel-nestedset) - 嵌套集模式实现
* [ClosureTable](https://github.com/franzose/ClosureTable) - 闭表模式实现
* [Eloquence](https://github.com/kirkbushell/eloquence) - Eloquent 模型的额外功能
* [iSeed](https://github.com/orangehill/iseed) - 从现有数据库表生成新的种子文件
* [Laravel OCI8](https://github.com/yajra/laravel-oci8) - 通过 OCI8 的 Oracle DB 驱动程序
* [Laravel Backup](https://github.com/spatie/laravel-backup) - 备份您的应用程序
* [Laravel Doctrine](https://github.com/laravel-doctrine/orm) - 学说 2 ORM 实施
* [Laravel MongoDB](https://github.com/jenssegers/laravel-mongodb) - 支持 MongoDB 的 Eloquent 模型和查询生成器
* [Migrations Generator](https://github.com/Xethron/migrations-generator) - 从现有数据库生成迁移
* [Sofa/Eloquence](https://github.com/jarektkaczyk/eloquence) - Eloquent ORM 的扩展
* [Tenanti](https://github.com/orchestral/tenanti) - 多租户数据库架构管理器
* [Laravel Repository](https://github.com/andersao/l5-repository) - 抽象数据库层的存储库
* [Lada Cache](https://github.com/spiritix/lada-cache) - 基于 Redis 的、完全自动化和可扩展的数据库缓存层
* [Laravel MySQL Spatial extension](https://github.com/grimzy/laravel-mysql-spatial) - 轻松使用 MySQL 空间数据类型和 MySQL 空间函数

##### Search

* [Algolia Search](https://github.com/algolia/algoliasearch-laravel) - 将 Algolia 搜索 API 集成到 Laravel Eloquent ORM
* [Elasticquent](https://github.com/elasticquent/Elasticquent) - Elasticsearch for Eloquent 模型
* [Plastic](https://github.com/sleimanx2/plastic) - 流畅地映射和搜索 Elasticsearch
* [Laravel Search](https://github.com/mmanos/laravel-search) - Elasticsearch、Algolia 和 ZendSearch 的统一 API
* [SearchIndex](https://github.com/spatie/searchindex) - 从 Algolia 或 Elasticsearch 存储和检索对象
* [Searchable](https://github.com/nicolaslopezj/searchable) - 为 Eloquent 模型添加简单搜索功能的特征
* [TNTSearch](https://github.com/teamtnt/tntsearch) - 用 PHP 编写的功能齐全的全文搜索引擎
* [TNTSearch driver](https://github.com/teamtnt/laravel-scout-tntsearch-driver) - 司机 [Laravel Scout](https://github.com/laravel/scout) 基于TNTSearch的搜索包
* [Laravel-Searchy](https://github.com/TomLingham/Laravel-Searchy) - 模糊搜索，基本字符串匹配，编辑距离

##### APIs

* [ApiGuard](https://github.com/chrisbjr/api-guard) - 允许使用 API 密钥进行 API 身份验证
* [Dingo API](https://github.com/dingo/api) - 用于开发 RESTful API 的多用途工具包
* [Laravel CORS](https://github.com/barryvdh/laravel-cors) - 添加 CORS（跨源资源共享）标头支持
* [Laravel Fractal](https://github.com/spatie/laravel-fractal) - 使用 Fractal 输出复杂、灵活、AJAX/RESTful 数据结构
* [Laravel GraphQL](https://github.com/rebing/graphql-laravel) - 支持 Relay、Eloquent 模型、验证和 GraphiQL
* [Lighthouse](https://github.com/nuwave/lighthouse) - 用于 Laravel 的新兴 GraphQL 库
* [Laravel Responder](https://github.com/flugger/laravel-responder) - 使用 Fractal 构建自定义 API 响应

##### Tasks, Commands and Scheduling

* [Dispatcher](https://github.com/indatus/dispatcher) - 工匠命令的调度程序
* [Elixir](https://github.com/laravel/elixir) - 运行 Gulp 任务的节点 (NPM) 包
* [Mix](https://github.com/JeffreyWay/laravel-mix) - 用于定义基本 webpack 构建步骤的 Fluent API
* [Envoy](https://github.com/laravel/envoy) - SSH 任务运行程序

##### Payments

* [Cashier](https://github.com/laravel/cashier) - 使用 Stripe 进行订阅计费
* [Omnipay for Laravel](https://github.com/ignited/laravel-omnipay) - 整合 [Omnipay](https://github.com/thephpleague/omnipay) PHP库

##### Optimization

* [Intervention Image Cache](https://github.com/Intervention/imagecache) - 干预图像类的缓存扩展
* [Laravel HTMLMin](https://github.com/GrahamCampbell/Laravel-HTMLMin) - 刀片/HTML/CSS/javascript 压缩器
* [Rememberable](https://github.com/dwightwatson/rememberable) - Eloquent 的查询缓存
* [Widgetize](https://github.com/imanghafoori1/laravel-widgetize) - 页面部分缓存
* [Laravel Responsecache](https://github.com/spatie/laravel-responsecache) - 通过缓存整个响应来加速应用程序

##### Monitoring

* [Horizon](https://github.com/laravel/horizon) - 使用简单的网络用户界面监控和配置队列
* [Laravel Failed Job Monitor](https://github.com/spatie/laravel-failed-job-monitor) - 当排队的作业失败时得到通知
* [Laravel Uptime Monitor](https://github.com/spatie/laravel-uptime-monitor) - 一个功能强大且易于配置的正常运行时间和 ssl 监视器
* [Larametrics](https://github.com/aschmelyun/larametrics) - Laravel 应用程序的自托管指标和通知平台

##### Localization

* [Language Files](https://github.com/caouecs/Laravel-lang) - 37 种语言的验证、分页和提醒语言行
* [Laravel Localization](https://github.com/mcamara/laravel-localization) - 通过路由添加 i18n 支持
* [Laravel Translatable](https://github.com/spatie/laravel-translatable) - 通过将翻译存储为 JSON 使 Eloquent 模型可翻译
* [Laravel Translatable](https://github.com/dimsav/laravel-translatable) - 检索和存储可翻译的 Eloquent 模型实例
* [Laravel Translator](https://github.com/vinkla/laravel-translator) - 将 Eloquent 模型翻译成多种语言
* [Laravel Date](https://github.com/jenssegers/date) - 基于 Carbon 的库，可帮助您使用多种语言处理日期
* [Laravel Langman](https://github.com/themsaid/laravel-langman) - 从 Artisan 控制台管理语言文件
* [Laravel Translation](https://github.com/waavi/translation) - 翻译和本地化管理
* [Linguist](https://github.com/keevitaja/linguist) - Laravel 的 i18n 本地化支持

##### Third-party Service Integration

* [Laravel Analytics](https://github.com/spatie/laravel-analytics) - 从 Google Analytics 检索网页浏览量和其他数据
* [Laravel DigitalOcean](https://github.com/GrahamCampbell/Laravel-DigitalOcean) - DigitalOceanV2桥
* [Laravel GitHub](https://github.com/GrahamCampbell/Laravel-GitHub) - PHP GitHub API 桥
* [Laravel Instagram](https://github.com/vinkla/laravel-instagram) - Instagram API 桥
* [Laravel Newsletter](https://github.com/spatie/laravel-newsletter) - 使用 Mailchimp 发送时事通讯
* [Laravel Pusher](https://github.com/vinkla/laravel-pusher) - 推送器 API 桥

## Development Setup

* [Homestead](https://laravel.com/docs/master/homestead) - Laravel 的官方 Vagrant 盒子
* [Valet](https://laravel.com/docs/master/valet) - Mac用户的开发环境
* [Valet Linux](https://github.com/cpriego/valet-linux) - Linux用户的开发环境
* [LaraDock](https://github.com/LaraDock/laradock) - 在 Docker 上运行 Laravel（类似于 Homestead，但用于 Docker 而不是 Vagrant）
* [LaraEdit Docker](https://github.com/laraedit/laraedit-docker) - 单个 Docker 容器中的 Homestead 环境
* [Laragon](https://laragon.org/) - Windows 上的隔离开发环境
* [Stacker](https://github.com/Maxlab/stacker) - Docker本地Web开发环境
* [Devilbox](https://github.com/cytopia/devilbox) - 每个 PHP 版本的 dockerized 和通用 LAMP/MEAN 堆栈
* [Vessel](https://vessel.shippingdocker.com) - Laravel 的简单 Docker 开发环境
* [Lando](https://docs.lando.dev/config/laravel.html) - 基于Docker构建的本地开发环境工具

## Application Hosting

* [Vapor](https://vapor.laravel.com)
* [Forge](https://forge.laravel.com/) ([ForgeRecipes](https://forgerecipes.com/))
* [FortRabbit](https://www.fortrabbit.com/laravel-hosting)
* [Heroku](https://www.heroku.com/) ([Documentation](https://devcenter.heroku.com/articles/getting-started-with-laravel))
* [AWS Elastic Beanstalk](https://aws.amazon.com/elasticbeanstalk/) ([Tutorial](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/php-laravel-tutorial.html))
* [Cloudways](https://www.cloudways.com/en/laravel-hosting.php)
* [Ploi](https://ploi.io/)
* [CodePier](https://codepier.io?ref=awesome-laravel)
* [RunCloud](https://runcloud.io/)

## Application Deployment

* [Deployer](https://deployer.org/) - 开箱即用的支持 Laravel 的部署工具
* [Envoyer](https://envoyer.io/) - PHP 和 Laravel 项目的零停机时间部署器
* [Rocketeer](https://github.com/rocketeers/rocketeer) - 任务运行器和部署包

## Code Snippets

* [Laravel LTS Cheat Sheet ](https://summerblue.github.io/laravel5-cheatsheet/) ([Chinese version](https://cs.phphub.org/))
* [Laravel Tricks](http://laravel-tricks.com/)

## Tutorials & Blogs

* [Taylor Otwell](http://taylorotwell.com/)
* [Tuts+](https://code.tutsplus.com/categories/laravel)
* [Medium](https://medium.com/tag/laravel/latest)
* [Laravel Daily](https://laraveldaily.com/)
* [Scotch](https://scotch.io/tag/laravel)
* [Digital Ocean](https://www.digitalocean.com/community/search?q=laravel&primary_filter=newest&type=tutorials)
* [Matt Stauffer](https://mattstauffer.co/blog)
* [Vegi Bit](https://vegibit.com/tag/laravel/)
* [Neon Tsunami](https://www.neontsunami.com/tags/laravel)
* [Dor.ky](https://dor.ky/tag/laravel/)
* [Stillat](https://stillat.com/explore/categories/laravel-5)
* [Easy Laravel Book Blog](http://www.easylaravelbook.com/blog/)
* [Laraveles](http://laraveles.com/blog/) （是）
* [Styde](https://styde.net/category/laravel-5/) （是）
* [Cloudways Laravel Blog](http://cloudways.com/blog/laravel)
* [Laravel Best Practices](https://github.com/alexeymezenin/laravel-best-practices)
* [Pusher Laravel Tutorials](https://pusher.com/tutorials?tag=Laravel)
* [LaraShout](https://larashout.com/)

## Videos

* [Laracasts](https://laracasts.com/)
* [Codecourse](https://www.codecourse.com/) ([YouTube](https://www.youtube.com/user/phpacademy/playlists))
* [Tuts+](http://code.tutsplus.com/categories/laravel/courses)
* [Servers for Hackers](https://serversforhackers.com/laravel-perf)
* [Test-Driven Laravel](https://course.testdrivenlaravel.com/)
* [Duilio Palacios](https://www.youtube.com/user/silencedsg/videos) （是）
* [CodigoFacilito](https://codigofacilito.com/courses/laravel) （是）
* [DevDojo](https://devdojo.com/search?value=laravel)
* [Amitav Roy](https://www.youtube.com/channel/UC4gijXR8cM4gmEt9Olse-TQ/videos)
* [Laracademy](https://laracademy.co/)
* [Dev Marketer](https://www.youtube.com/channel/UC6kwT7-jjZHHF1s7vCfg2CA/playlists)
* [Udemy](https://www.udemy.com/courses/search/?q=laravel)
* [Lynda](https://www.lynda.com/search?q=laravel)
* [Pluralsight](https://www.pluralsight.com/search?q=laravel&categories=course)
* [Bitfumes](https://www.youtube.com/bitfumes)
* [ConfidentLaravel](https://confidentlaravel.com/)

## Conferences

* [Laracon US](http://laracon.us/)
* [Laracon EU](http://laracon.eu/)
* [Laracon Online](https://laracon.net/)
* [Laraconf Brasil](http://laraconfbrasil.com.br/)
* [Laracon Australia](https://laracon.com.au/)
* [Laravel Live UK](https://laravellive.uk/)
* [Laravel Live India](https://laravellive.in/)
* [Laravel Nigeria](https://laravelnigeria.com)

##### Videos

* [Laracon EU 2018](https://www.youtube.com/playlist?list=PLMdXHJK-lGoC64wnqvm6v1R5dsuAV-MpS)
* [Laracon US 2018](https://www.youtube.com/playlist?list=PL-yJve--iT5oM2LgF37VXsBb8Os4ZulIc)
* [Laracon EU 2017](https://www.youtube.com/playlist?list=PLMdXHJK-lGoBFZgG2juDXF6LiikpQeLx2)
* [Laracon US 2017](https://www.youtube.com/playlist?list=PL-yJve--iT5oaLQA6OI8TWLVSOBP1qhs3)
* [Laracon EU 2016](https://www.youtube.com/playlist?list=PLMdXHJK-lGoCMkOxqe82hOC8tgthqhHCN)
* [Laracon US 2016](https://www.youtube.com/playlist?list=PL-yJve--iT5o9fH_cRY0u6P751pcF59GK)
* [Laracon EU 2015](https://www.youtube.com/playlist?list=PLMdXHJK-lGoA9SIsuFy0UWL8PZD1G3YFZ)
* Laracon 美国 2015
* [Laracon EU 2014](https://www.youtube.com/playlist?list=PLMdXHJK-lGoCYhxlU3OJ5bOGhcKtDMkcN)
* [Laracon US 2014](https://www.youtube.com/channel/UCRawXmZv30Vf_MivyPYb_GQ/videos)
* [Laracon EU 2013](https://www.youtube.com/playlist?list=PLMdXHJK-lGoB-CIVsiQt0WU8WcYrb5eoe)
* [Laracon US 2013](https://www.youtube.com/playlist?list=PLkwAlZpjHQbLcox_S_AgGU24QUfKgXayN)

## Books

* [Laravel Starter](https://www.amazon.com/Laravel-Starter-Shawn-McCool-ebook/dp/B00ABFQ0AS) 通过肖恩麦库尔
* [Laravel: Code Happy](https://leanpub.com/codehappy) 通过戴尔·里斯
* [Laravel: Code Bright](https://leanpub.com/codebright) 通过戴尔·里斯
* [Laravel: Code Smart](https://leanpub.com/codesmart) 通过戴尔·里斯
* [Laravel: From Apprentice To Artisan](https://leanpub.com/laravel) 泰勒·奥特威尔
* [Laravel 4 Cookbook](https://leanpub.com/laravel4cookbook) 克里斯托弗·皮特和泰勒·奥特威尔
* [Laravel Testing Decoded](https://leanpub.com/laravel-testing-decoded) 通过杰弗里方式
* [Refactoring to Collections](https://adamwathan.me/refactoring-to-collections/) 通过亚当·沃森
* [Implementing Laravel](https://leanpub.com/implementinglaravel) 克里斯·菲道
* [Getting Stuff Done with Laravel 4](https://leanpub.com/gettingstuffdonelaravel) 通过查克海因策尔曼
* [Laravel Application Development Blueprints](https://www.packtpub.com/web-development/laravel-application-development-blueprints) 作者：Arda Kılıçdağı 和 Halil İbrahim Yılmaz
* [Build APIs You Won't Hate](https://leanpub.com/build-apis-you-wont-hate) 菲尔·斯特金
* [Integrating Front end Components with Web Applications](https://leanpub.com/frontend) 马克西姆·苏吉
* [Laravel Design Patterns and Best Practices](https://www.packtpub.com/web-development/laravel-design-patterns-and-best-practices) 作者：Arda Kılıçdağı 和 Halil İbrahim Yılmaz
* [Learning Laravel 4 Application Development](https://www.packtpub.com/web-development/learning-laravel-4-application-development) 通过 Hardik Dangar
* [Getting Started with Laravel 4](https://www.packtpub.com/web-development/getting-started-laravel-4) 拉斐尔·索尼尔
* [Laravel Application Development Cookbook](https://www.packtpub.com/web-development/laravel-application-development-cookbook) 通过特里·马图拉
* [Building Web Applications Using Parse REST API](https://leanpub.com/building-web-applications-using-parse-rest-api) 通过 Mhd Zaher Ghaibeh
* [Laravel - My First Framework](https://leanpub.com/laravel-first-framework) 马克西姆·苏吉
* [Easy Laravel 5](https://leanpub.com/easylaravel/) 通过 W.杰森吉尔摩
* [Laravel 5 Essentials](https://www.packtpub.com/web-development/laravel-5-essentials) by Martin Bean
* [Easy E-Commerce Using Laravel and Stripe](https://leanpub.com/easyecommerce) 作者：W. Jason Gilmore 和 Eric L. Barnes
* [Laravel 5.1 Beauty](https://leanpub.com/l5-beauty) 通过查克海因策尔曼
* [Design Patterns with PHP and Laravel](https://leanpub.com/larasign) 通过 Kelt Dockins
* [Mastering Laravel](https://www.packtpub.com/web-development/mastering-laravel) 克里斯托弗·约翰·佩科拉罗 (Christopher John Pecoraro)
* [How to Build Real-Time Laravel Apps with Pusher](http://pusher-community.github.io/real-time-laravel/) 通过推手
* [Learning Laravel's Eloquent](https://www.amazon.com/Learning-Laravels-Eloquent-Francesco-Malatesta-ebook/dp/B00YSILQ6C) 弗朗切斯科马拉泰斯塔
* [Laravel 5 Learn Easy](https://leanpub.com/laravel5learneasy) 通过桑吉布·辛哈
* [Laravel and AngularJS](https://leanpub.com/laravel-and-angularjs) 丹尼尔·施密茨和丹尼尔·佩德里尼亚·乔治
* [Laravel Collections Unraveled](https://leanpub.com/laravelcollectionsunraveled) 通过杰夫马德森
* [Writing APIs With Lumen](https://leanpub.com/lumen-apis) 保罗·雷德蒙德
* [The Laravel Survival Guide](https://leanpub.com/laravelsurvivalguide) 通过托尼李
* [Laraboot: Laravel 5 For Beginners](https://leanpub.com/laravel-5-for-beginners-laraboot) 通过比尔凯克
* [Laravel 5.4 For Beginners](https://leanpub.com/laravel-5-4-for-beginners) 通过比尔凯克
* [Laravel Up & Running](https://www.amazon.com/gp/product/1491936088) 通过马特斯托弗
* [Laravel Companion](https://leanpub.com/laravelcompanion-secondedition) 乔纳森·科斯特 (Johnathon Koster)
* [Deploy Laravel on AWS with CloudFormation](https://leanpub.com/laravel-aws) 莱昂内尔·马丁
* [React Native and Laravel for Future Mobile Development](https://leanpub.com/rn_laravel) 来自 Ega Radiegtya
* [Servers for Hackers](https://book.serversforhackers.com) 克里斯·菲道
* [Full-Stack Vue.js 2 and Laravel 5](https://www.amazon.com/Full-Stack-Vue-js-Laravel-frontend-together/dp/1788299582) 安东尼·戈尔
* [Build an API with Laravel](https://buildanapi.com) 通过古怪的工作室

## Starter Projects

* [Spark](https://spark.laravel.com/)
* [LaraAdmin](https://github.com/dwijitsolutions/laraadmin)
* [Grafite Builder](https://github.com/GrafiteInc/Builder)
* [Laravel Boilerplate](https://github.com/rappasoft/laravel-5-boilerplate)
* [Laravel Angular Material Starter](https://github.com/jadjoubran/laravel5-angular-material-starter)
* [AdminLTE Laravel](https://github.com/acacha/adminlte-laravel)
* [Laravel Hackathon Starter](https://github.com/unicodeveloper/laravel-hackathon-starter)
* [Laravel API Starter Kit](https://github.com/joselfonseca/laravel-api)
* [Backpack for Laravel](https://github.com/Laravel-Backpack/Base)
* [SomelineStarter](https://github.com/someline/someline-starter)
* [Laravel Admin](https://github.com/z-song/laravel-admin)
* [Voyager](https://github.com/the-control-group/voyager)
* [Orchid](https://github.com/TheOrchid/Platform)
* [Laravel REST API Boilerplate](https://github.com/francescomalatesta/laravel-api-boilerplate-jwt)
* [Hello API](https://github.com/Porto-SAP/Hello-API)
* [REST API With Lumen](https://github.com/hasib32/rest-api-with-lumen)
* [Laravel Zero - Console application](https://github.com/laravel-zero/laravel-zero)
* [Apiato](https://github.com/apiato/apiato)
* [Laravel Adminpanel](https://github.com/viralsolani/laravel-adminpanel)
* [Laravel Vue Boilerplate](https://github.com/alefesouza/laravel-vue-boilerplate)
* [Laravel Enso](https://github.com/laravel-enso/enso)
* [Laravel Template with Vue](https://github.com/wmhello/laravel_template_with_vue)

## Codebases for Reference

* [Cachet](https://github.com/cachethq/Cachet) - 网站和 API 的状态页面系统
* [Deployer](https://github.com/REBELinBLUE/deployer) - 应用部署系统
* [GitScrum](https://github.com/renatomarinho/laravel-gitscrum) - 使用 Git 和 Scrum 进行任务管理
* [Invoice Ninja](https://github.com/invoiceninja/invoiceninja) - 发票、费用和时间跟踪应用程序
* [Koel](https://github.com/phanan/koel) - 个人音乐流媒体服务器
* [Laravel.io](https://github.com/laravelio/portal) - Laravel.io 社区门户的来源
* [Attendize](https://github.com/Attendize/Attendize) - 门票销售和活动管理平台
* [Antvel](https://github.com/ant-vel/App) - 电子商务平台
* [Jigsaw](https://github.com/tightenco/jigsaw) - 静态站点生成器
* [Canvas](https://github.com/cnvs/canvas) - 一个 Laravel 发布平台
* [Vuedo](https://github.com/Vuedo/vuedo) - Vuedo 是博客平台，使用 Laravel 和 Vue.js 构建
* [Screeenly](https://github.com/stefanzweifel/screeenly) - 通过 API 创建网站截图
* [Voten](https://github.com/voten-co/voten) - 21 世纪的实时社交书签
* [Monica](https://github.com/monicahq/monica) - 人际关系管理系统
* [Snipe-IT](https://github.com/snipe/snipe-it) - IT资产/许可管理系统
* [Akaunting](https://github.com/akaunting/akaunting) - 适用于小型企业和自由职业者的会计软件
* [Torch](https://github.com/mattstauffer/Torch) - 在非 Laravel 应用程序中使用每个 Illuminate 组件的示例
* [Pixelfed](https://github.com/pixelfed/pixelfed) - 一个免费且合乎道德的照片共享平台，由 ActivityPub 联合会提供支持



* [OctoberCMS](https://github.com/octobercms/october)
* [SleepingOwlAdmin](https://github.com/LaravelRUS/SleepingOwlAdmin)
* [PyroCMS](https://github.com/pyrocms/pyrocms)
* [Lavalite](https://github.com/LavaLite/cms)
* [TypiCMS](https://github.com/typicms/base)
* [Asgard CMS](https://github.com/AsgardCms/Platform)
* [Microweber](https://github.com/microweber/microweber)
* [Coaster CMS](https://github.com/web-feet/coastercms)
* [Statamic](https://statamic.com/)
* [Borgert CMS](https://github.com/odirleiborgert/borgert-cms/)
* [PJ Blog](https://github.com/jcc/blog/)
* [Laralum](https://github.com/Laralum/Laralum)
* [Twill](https://github.com/area17/twill)

## Podcasts

* [The Laravel Podcast](http://www.laravelpodcast.com/)
* [The Laravel News Podcast](https://laravel-news.com/podcast/ )
* [The Laracasts Snippet](https://laracasts.simplecast.fm/)
* [Hecho en Laravel (Spanish)](http://hechoenlaravel.com)

## Community

* [Laracasts Forum](https://laracasts.com/discuss)
* [Laravel.io Forum](http://laravel.io/forum)
* [Larachat Slack](https://larachat.slack.com/) ([Signup](https://larachat.co/register))
* [Gitter](https://gitter.im/laravel/laravel)
* [IRC Channel](http://laravel.io/chat)
* [StackOverflow](http://stackoverflow.com/questions/tagged/laravel)
* [Twitter](https://twitter.com/laravelphp)
* [Google+](https://plus.google.com/communities/106838454910116161868)
* [Reddit](https://www.reddit.com/r/laravel)
* [Quora](https://www.quora.com/topic/Laravel)
* [Facebook](https://www.facebook.com/LaravelCommunity)
* [LinkedIn](https://www.linkedin.com/groups/4419933/profile)

##### Local User Groups

* [Laravel Global Community](https://www.facebook.com/groups/group.laravel/)
* [LaravelES Slack](https://laraveles.slack.com) ([Signup](http://laraveles.com/blog/wp-login.php?action=slack-invitation))
* [Laravel India](https://laravellive.in/), [Slack Signup](https://laravelliveindia.slack.com/join/shared_invite/enQtNjQyMDE4NDA3MDQzLWMyZmIxNGZkNGVkNGFmMzE1MTgyOGNiZGY1ZmU1ZDQ3Mzk2ODBlZGJlODk3ZmI0OWNlZmI5MzQyZDJhYzg1NjE), [Twitter](https://twitter.com/LaravelLiveIN), [Facebook](https://www.facebook.com/laravellive/), [Youtube](https://www.youtube.com/channel/UC6TxYSHI7g9FMJ7VlHk72Yg)
* [Laravel UK](https://laravelphp.uk/), [Slack Signup](https://laravelphp.uk/login/slack)
* [Laravel Russia](https://laravel.ru/) ([VK group](http://m.vk.com/laravel_rus))
* [Laravel France](https://laravel.fr/)
* [Laravel Bangladesh](https://www.facebook.com/groups/LaravelBanglaDesh/)
* [Laravel Indonesia](http://id-laravel.com/) ([Facebook](https://www.facebook.com/groups/laravel/), [Telegram](https://t.me/laravelindonesia))
* [Laravel Brasil](http://www.laravel.com.br/) ([Facebook](https://www.facebook.com/groups/laravelbrasil/), [Slack](http://slack.laravel.com.br), [Telegram](https://telegram.me/laravelbr), [GitHub](https://github.com/laravelbrasil), [Discord](https://discord.gg/9dpuWeZ))
* [Laravel Turkey](http://www.laravel.gen.tr/) ([Facebook](https://www.facebook.com/groups/laravelturkiye/))
* [Laravel Nigeria](http://www.laravelnigeria.com/) ([Facebook](https://www.facebook.com/groups/laravelnigeria/))
* [Laravel China](https://phphub.org/)
* [Laravel Taiwan](https://laravel.tw/) ([Facebook](https://www.facebook.com/groups/laravel.tw/))
* [Laravel Spanish](http://laraveles.com/foro/)
* [Laravel Korea](https://www.laravel.co.kr/) ([Facebook](https://www.facebook.com/groups/laravelkorea/))
* [Laravel Japan](http://laravel.jp/) ([Facebook](https://www.facebook.com/groups/laravel.jp/))
* [Laravel Malaysia](https://www.facebook.com/groups/laravel.my/)
* [Laravel Algeria](https://www.facebook.com/groups/LaravelAlgeria/)
* [Laravel Greece](http://www.laravel.gr) ([Facebook](https://www.facebook.com/laravelgr))
* [Laravel Middle East](http://laravelme.com/) ([Facebook](https://www.facebook.com/laravelme))
* [Laravel Georgia](https://www.facebook.com/groups/laravel.georgia/)
* [Laravel Italy](http://laravel-italia.it)
* [Laravel Vietnam](https://www.facebook.com/groups/vietnam.laravel/)
* [Laravel Slovenia](https://www.facebook.com/groups/laravelslovenija/)
* [Laravel Hungary](https://laravel.hu)
* [Laravel Cameroon](https://laravelcm.com/) ([Slack](https://laravelcm.slack.com), [GitHub](https://github.com/laravelcm), [Facebook](https://www.facebook.com/laravelcm), [Twitter](https://twitter.com/laravelcm))
* [Laravel Philippines](https://www.facebook.com/groups/laravelph)

##### Meetups

* [All Meetups](http://www.meetup.com/topics/laravel/)
* [London Meetup](https://www.meetup.com/London-Laravel/)
* [Buenos Aires Meetup](https://www.meetup.com/Laravel-Buenos-Aires/)
* [Athens-Greece Meetup](https://www.meetup.com/athens-laravel-meetup/)
* [Copenhagen Meetup](https://www.meetup.com/Copenhagen-Laravel-Meetup/)
* [Detroit Meetup](https://www.meetup.com/Laravel-Detroit/)
* [Paris Meetup](https://www.meetup.com/fr-FR/Paris-Laravel-Meetup/)
* [Melbourne Meetup](https://www.meetup.com/Melbourne-laravel-Meetup/)
* [Budapest Meetup](https://www.meetup.com/Laravel-Hungary-Meetup/)

## Jobs

* [LaraJobs](https://larajobs.com/)
* [Laravel Gurus](https://laravelgurus.com/)

## Hosted Development Tools

* [Laravel Shift](https://laravelshift.com/) - Laravel 项目的自动化升级工具
* [Laravel Schema Designer](http://laravelsd.com/) - 创建、导出和共享数据库模式
* [StyleCI](https://styleci.io) - PHP编码风格服务

## Miscellaneous

* [CodeCanyon](https://codecanyon.net/tags/laravel?term=laravel) - 付费脚本和插件
* [Laravel Collections](https://laravelcollections.com) - 每个 Laravel 开发者都转到资源站点
* [LaravelLinks](https://telegram.me/laravellinks) - 一个致力于分享 Laravel 资源的电报频道

## Contributing

找到很棒的包、博客、课程或视频？ 向我发送请求请求！

#### Guidelines

* 请为每个建议提出单独的拉取请求
* 确保 Travis 测试通过你的 pull request
* 链接使用以下格式：\[Resource\]\(URL\)
 * 想推荐一个套餐？ 阅读 [Contribution Guide](https://github.com/chiraggude/awesome-laravel/blob/master/CONTRIBUTING.md)
* 欢迎新类别或改进现有分类

## License

[![CC BY 4.0](https://licensebuttons.net/l/by/4.0/88x31.png)](https://creativecommons.org/licenses/by/4.0/)

Awesome Laravel 已获得许可  [Creative Commons Attribution 4.0 International License](https://creativecommons.org/licenses/by/4.0/).
