<div class="github-widget" data-repo="ramitsurana/awesome-kubernetes"></div>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script><ins class="adsbygoogle" style="display:block" data-ad-client="ca-pub-6890694312814945" data-ad-slot="5473692530" data-ad-format="auto"  data-full-width-responsive="true"></ins><script>(adsbygoogle = window.adsbygoogle || []).push({});</script>
Awesome-Kubernetes
=======================================================================

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Build Status](https://travis-ci.org/ramitsurana/awesome-kubernetes.svg?branch=master)](https://travis-ci.org/ramitsurana/awesome-kubernetes)
[![Build Status](https://semaphoreci.com/api/v1/ramitsurana/awesome-kubernetes/branches/master/badge.svg)](https://semaphoreci.com/ramitsurana/awesome-kubernetes)
[![License](https://img.shields.io/badge/License-CC%204.0-brightgreen.svg?style=flat-square)](http://creativecommons.org/licenses/by-nc/4.0/)
[![Docker Build Status](https://img.shields.io/docker/build/ramitsurana/awesome-kubernetes.svg?style=flat-square)](https://hub.docker.com/r/ramitsurana/awesome-kubernetes)
[![Slack Widget](https://img.shields.io/badge/Slack-Channel-blue.svg?style=flat-square)](https://kubernetes.slack.com/messages/awesome-kubernetes)
[![Documentation Status](https://readthedocs.org/projects/awesome-kubernetes-by-ramitsurana/badge/?version=latest)](https://awesome-kubernetes-by-ramitsurana.readthedocs.io/en/latest/?badge=latest)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ramitsurana/awesome-kubernetes/master)

精选的受启发的kubernetes来源的清单 [@sindresorhus' awesome](https://github.com/sindresorhus/awesome)

![final-k8s](https://cloud.githubusercontent.com/assets/8342133/26794201/62c1a006-4a3e-11e7-8bf9-4449814648f2.png)

&gt;“人才赢得比赛，但团队合作和智慧赢得冠军.”
>
&gt;-迈克尔·乔丹

没有这些的帮助 [amazing contributors](https://github.com/ramitsurana/awesome-kubernetes/graphs/contributors),
 建立这个很棒的仓库是不可能的.  非常感谢你们 ！！

 **感谢Gitbook.此真棒列表现在可以下载并以书的形式阅读.  看看-&gt; https://www.gitbook.com/book/ramitsurana/awesome-kubernetes/.继续学习保持共享!! **

 **如果您在此处看到不再维护或不合适的软件包或项目，请提交请求请求以改进此文件.  谢谢！**

## What is Kubernetes? :ship:

&gt; Kubernetes是一个开源系统，用于自动化容器化应用程序的部署，扩展和管理.
它将组成应用程序的容器分组为逻辑单元，以便于管理和发现.

_Source:_ [What is Kubernetes](http://kubernetes.io/)


## History

**众所周知，Kubernetes是Google系统BORG的后代**

&gt; Google开发的第一个统一的容器管理系统是我们内部称为Borg的系统.
它是为管理长期运行的服务和批处理作业而构建的，以前这些服务是由两个独立的部门处理
 系统：保姆和全球工作队列.  后者的架构对博格产生了很大的影响，但专注于
 批处理工作；  两者都早于Linux控制组.

_Source:_ [Kubernetes Past](http://research.google.com/pubs/archive/44843.pdf)

## Date of Birth

 Kubernetes每年7月21日庆祝生日.  Kubernetes 1.0在2015年7月21日首次公开发布后 [Dockercon in June 2014](https://www.youtube.com/watch?v=YrxnVKZeqK8).

## Roadmap

awesome-kubernetes现在将以不同的发行版和软件包捆绑形式提供，这意味着您可以
 在一段时间内下载真棒kubernetes发行版，真棒kubernetes 2015捆绑包发行版发行.  请查看发布列以获取更多信息.

## Featured On

- https://cloud.google.com/community/
- https://www.freecodecamp.org/news/a-friendly-introduction-to-kubernetes-670c50ce4542/

-----------------------------------------------------------------------


Menu
=======================================================================



-----------------------------------------------------------------------


初始点
=======================================================================

*标志着旅程开始的地方*

* [Kubernetes Community Overview and Contributions Guide](https://docs.google.com/presentation/d/1JqcALpsg07eH665ZXQrIvOcin6SzzsIUjMRRVivrZMg/edit?usp=sharing) 通过 [Ihor Dvoretskyi](https://twitter.com/idvoretskyi/)
* [Are you Ready to Manage your Infrastructure like Google?](http://blog.jetstack.io/blog/k8s-getting-started-part1/)
* [Google is years ahead when it comes to the cloud, but it's happy the world is catching up](http://www.businessinsider.in/Google-is-years-ahead-when-it-comes-to-the-cloud-but-its-happy-the-world-is-catching-up/articleshow/47793327.cms)
* [An Intro to Google’s Kubernetes and How to Use It](http://www.ctl.io/developers/blog/post/what-is-kubernetes-and-how-to-use-it/) 通过 [Laura Frank](https://twitter.com/rhein_wein)
* [Kubernetes: The Future of Cloud Hosting](https://github.com/meteorhacks/meteorhacks.github.io/blob/master/_posts/2015-04-22-learn-kubernetes-the-future-of-the-cloud.md) 通过 [Meteorhacks](https://twitter.com/meteorhacks)
* [Kubernetes 通过 Google](http://thevirtualizationguy.wordpress.com/tag/kubernetes/) 通过 [Gaston Pantana](https://twitter.com/GastonPantana)
* [Key Concepts](http://blog.arungupta.me/key-concepts-kubernetes/) 通过 [Arun Gupta](https://twitter.com/arungupta)
* [Application Containers: Kubernetes and Docker from Scratch](http://keithtenzer.com/2015/06/01/application-containers-kubernetes-and-docker-from-scratch/) 通过 [Keith Tenzer](https://twitter.com/keithtenzer)
* [Learn the Kubernetes Key Concepts in 10 Minutes](http://omerio.com/2015/12/18/learn-the-kubernetes-key-concepts-in-10-minutes/) 通过 [Omer Dawelbeit](https://twitter.com/omerio)
* [The Children's Illustrated Guide to Kubernetes](https://kubernetes.io/blog/2016/06/illustrated-childrens-guide-to-kubernetes/) 通过 [Deis](https://github.com/deis)
* [The ‘kubectl run’ command](http://medium.com/@mhausenblas/the-kubectl-run-command-27c68de5cb76#.mlwi5an7o) 通过 [Michael Hausenblas](https://twitter.com/mhausenblas)
* [Docker Kubernetes Lab Handbook](https://github.com/xiaopeng163/docker-k8s-lab) 通过 [Peng Xiao](https://twitter.com/xiaopeng163)
* [Curated Resources for Kubernetes](https://hackr.io/tutorials/learn-kubernetes)
* [Kubernetes Comic](https://cloud.google.com/kubernetes-engine/kubernetes-comic/) 通过 [Google Cloud Platform](https://cloud.google.com/)
* [Kubernetes 101: Pods, Nodes, Containers, and Clusters](https://medium.com/google-cloud/kubernetes-101-pods-nodes-containers-and-clusters-c1509e409e16) 通过 [Dan Sanche](https://medium.com/@sanche)
* [An Introduction to Kubernetes](http://www.digitalocean.com/community/tutorials/an-introduction-to-kubernetes) 通过 [Justin Ellingwood](https://twitter.com/jmellingwood)
* [Kubernetes and everything else - Introduction to Kubernetes and it's context](https://rinormaloku.com/introduction-application-architecture/) 通过 [Rinor Maloku](https://twitter.com/rinormaloku)
* [Installation on Centos 7](http://severalnines.com/blog/installing-kubernetes-cluster-minions-centos7-manage-pods-services)
* [Setting Up a Kubernetes Cluster on Ubuntu 18.04](https://mherman.org/blog/2018/08/20/setting-up-a-kubernetes-cluster-on-ubuntu/)
* [Cloud Native Landscape](https://landscape.cncf.io/)

Installers
=======================================================================


* [Bootkube](https://github.com/kubernetes-incubator/bootkube) -CoreOS-不可知云
* [Breeze](https://github.com/wise2c-devops/breeze) -CentOS-不可知云
* [Conjure-up](https://github.com/conjure-up/conjure-up) -Ubuntu-云不可知
* [Docker for MAC](https://store.docker.com/editions/community/docker-ce-desktop-mac) -在您的MAC（边缘通道）上本地运行Kubernetes和Docker
* [Docker for Windows](https://store.docker.com/editions/community/docker-ce-desktop-windows) -在Windows PC（Edge Channel）上本地运行Kubernetes和Docker
* [eksctl](https://eksctl.io/) -Amazon EKS的官方CLI
* [Juju](https://jujucharms.com/canonical-kubernetes) -Ubuntu-云不可知
* [Krucible](https://usekrucible.com/) -创建临时的Kubernetes集群以进行测试和开发（无需帐户）
* [KubeSphere](https://github.com/kubesphere/kubesphere) -轻松地在多个实例中安装Kubernetes和KubeSphere，包括全栈云原生软件，例如istio，ES，Prometheus，Fluent Bit，SonarQube，Jenkins.
* [k3s](https://github.com/rancher/k3s)  -轻量级的Kubernetes.  易于安装，一半内存，所有二进制文件不到40mb
* [k3d](https://github.com/rancher/k3d) -在容器节点中运行k3s集群的工具
* [kind](https://kind.sigs.k8s.io) -使用Docker容器“节点”运行本地Kubernetes集群的工具
* [Kops](https://github.com/kubernetes/kops) -与操作系统无关-AWS
* [Konvoy](https://d2iq.com/solutions/ksphere/konvoy) -轻松部署可立即投入生产的Kubernetes集群以及所有相关的运营服务
* [Kube-ansible](https://github.com/kairen/kube-ansible) -与操作系统无关-与云无关
* [Kube-aws](https://github.com/kubernetes-incubator/kube-aws) -州长拥有AWS
* [Kube-deploy](https://github.com/kubernetes/kube-deploy)
* [Kubeadm](http://kubernetes.io/docs/admin/kubeadm/) -与操作系统无关-与云无关
* [KubeNow](https://github.com/kubenow/KubeNow) -Ubuntu-云不可知
* [Kubespray](https://github.com/kubernetes-incubator/kubespray) -与操作系统无关-与云无关
* [Kubicorn](https://github.com/kubicorn/kubicorn) -与操作系统无关-与云无关
* [Kublr](https://docs.kublr.com/quickstart/) -不可知操作系统-本地-不可知云
* [Linode](https://developers.linode.com/kubernetes/) -CoreOS-Linode
* [matchbox](https://github.com/poseidon/matchbox) -网络启动和配置Container Linux集群（例如etcd3，Kubernetes等）.
* [MetalK8s](https://github.com/scality/metalk8s) -CentOS-本地-云不可知- [Apache-2.0](https://github.com/scality/metalk8s/blob/development/1.1/LICENSE)
* [MicroK8s](https://github.com/ubuntu/microk8s) -单个k8软件包，可在42种Linux上安装
* [Minikube](https://github.com/kubernetes/minikube) -在本地运行Kubernetes
* [RKE](https://github.com/rancher/rke) -与操作系统无关-与云无关
* [sealos](https://github.com/fanux/sealos) -简单的kubernetes HA安装程序
* [Simplekube](https://github.com/valentin2105/Simplekube) -`systemd` OS-不可知云
* [Terraform](https://github.com/kz8s/tack) -CoreOS-AWS
* [Typhoon](https://typhoon.psdn.io/) -容器Linux-不可知云
* [aks-engine](https://github.com/Azure/aks-engine) -AKS Engine是在Azure上配置自管理Kubernetes群集的最简单方法.



Main Resources
=======================================================================

*来自Kubernetes团队的官方资源*

* [Kubernetes Documentation](https://kubernetes.io/docs/home/)
* [Kubernetes Source](https://github.com/kubernetes/kubernetes/)
* [Kubernetes Troubleshooting](https://kubernetes.io/docs/tasks/debug-application-cluster/troubleshooting/)

发行说明
=======================================================================

*来自Kubernetes团队的关于稳定Kubernetes发行版的正式发行说明*

* [Kubernetes-1.18](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.18.md)
* [Kubernetes-1.17](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.17.md)
* [Kubernetes-1.16](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.16.md)
* [Kubernetes-1.15](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.15.md)
* [Kubernetes-1.14](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.14.md)
* [Kubernetes-1.13](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.13.md)
* [Kubernetes-1.12](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.12.md)
* [Kubernetes-1.11](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.11.md)
* [Kubernetes-1.10](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.10.md)
* [Kubernetes-1.9](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.9.md)
* [Kubernetes-1.8](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.8.md)
* [Kubernetes-1.7](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.7.md)
* [Kubernetes-1.6](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.6.md)
* [Kubernetes-1.5](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.5.md)
* [Kubernetes-1.4](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.4.md)
* [Kubernetes-1.3](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.3.md)
* [Kubernetes-1.2](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG/CHANGELOG-1.2.md)


有用的文章
=======================================================================

*报纸，杂志或其他出版物中随附的文章*


- [Kubernetes on AWS](http://coreos.com/kubernetes/docs/latest/kubernetes-on-aws.html) 通过 [CoreOS](https://twitter.com/coreoslinux)
- [AWS Advent 2014 - CoreOS and Kubernetes on AWS](http://awsadvent.tumblr.com/post/104260597799/aws-advent-2014-coreos-and-kubernetes-on-aws) 通过 [Tim Dsyinger](https://twitter.com/dysinger)
- [Kubernetes and AWS VPC Peering](http://ben.straub.cc/2015/08/19/kubernetes-aws-vpc-peering/) 通过 [Ben Straub](https://twitter.com/benstraub)
- [Testing Kubernetes on AWS](http://alanwill.me/Testing-Kubernetes-on-AWS/) 通过 [Alan Will](https://twitter.com/alanwill)
- [Kubernetes: First steps on Amazon AWS](http://blog.dutchcoders.io/kubernetes-first-steps-on-amazon-aws/) 通过 [Remco](http://blog.dutchcoders.io/author/remco/)
- [Manage Kubernetes Clusters on AWS Using Kops](https://aws.amazon.com/blogs/compute/kubernetes-clusters-aws-kops/)
- [Production grade Kubernetes on AWS: Primer (Part 1)](https://medium.com/tailor-tech/production-grade-kubernetes-on-aws-primer-5b83e71c024) 通过 [Guy Maliar](https://github.com/gmaliar)
- [Production grade Kubernetes on AWS: 4 tools that made our lives easier (Part 2)](https://medium.com/tailor-tech/production-grade-kubernetes-on-aws-4-tools-that-made-our-lives-easier-29438e8b58ca) 通过 [Guy Maliar](https://github.com/gmaliar)
- [Production grade Kubernetes on AWS: 3 tips for networking, ingress and microservices (Part 3)](https://medium.com/tailor-tech/production-grade-kubernetes-on-aws-3-tips-for-networking-ingress-and-microservices-8d28c355a6e0) 通过 [Guy Maliar](https://github.com/gmaliar)
- [Production grade Kubernetes on AWS: 3 lessons learned scaling a cluster (Part 4)](https://medium.com/tailor-tech/production-grade-kubernetes-on-aws-3-lessons-learned-scaling-a-cluster-a421dfe786dd) 通过 [Guy Maliar](https://github.com/gmaliar)
- [Continuous Deployment with Google Container Engine and Kubernetes](http://semaphoreci.com/community/tutorials/continuous-deployment-with-google-container-engine-and-kubernetes)
- [Creating a Kubernetes Cluster on DigitalOcean with Python and Fabric](https://testdriven.io/creating-a-kubernetes-cluster-on-digitalocean)
- [Deploy a Kubernetes development cluster with Juju!](http://insights.ubuntu.com/2015/07/23/deploy-a-kubernetes-development-cluster-with-juju-2/) 通过 [Matt Bruzek](https://github.com/mbruzek)
- [Containers at Scale with Kubernetes on OpenStack](http://keithtenzer.com/2015/04/15/containers-at-scale-with-kubernetes-on-openstack/) 通过 [Keith Tenzer](https://twitter.com/keithtenzer)

- [Logging in Kubernetes with Fluentd and Elasticsearch](http://www.dasblinkenlichten.com/logging-in-kubernetes-with-fluentd-and-elasticsearch/) 通过 [Jon Langemak](https://twitter.com/blinken_lichten)
- [Logging - Kafka topic 通过 namespace](http://www.devoperandi.com/logging-kafka-topic-通过-kubernetes-namespace/) 通过 [Michael Ward](https://twitter.com/DevoperandI)
- [The Complete Guide to Kubernetes Logging](https://sematext.com/guides/kubernetes-logging/) 通过 [Adnan Rahić](https://twitter.com/adnanrahic)


- [Kubernetes Monitoring Guide](http://www.datadoghq.com/blog/monitoring-kubernetes-era/) 通过 [JM Saponaro](http://github.com/JayJayM)
- [Installing cAdvisor and Heapster on bare metal Kubernetes](http://www.dasblinkenlichten.com/installing-cadvisor-and-heapster-on-bare-metal-kubernetes/) 通过 [Jon Langemak](https://twitter.com/blinken_lichten)
- [How to Monitor Kubernetes: A 4-Part Series](http://sysdig.com/blog/monitoring-kubernetes-with-sysdig-cloud/)
- [Kubernetes Web UIs in 2019](https://srcco.de/posts/kubernetes-web-uis-in-2019.html)
- [The Complete Guide to Kubernetes Monitoring](https://sematext.com/guides/kubernetes-monitoring/) 通过 [Adnan Rahić](https://twitter.com/adnanrahic)



- [Kubernetes Security Guide](https://sysdig.com/wp-content/uploads/2019/01/kubernetes-security-guide.pdf) -RBAC，TLS，安全策略，网络策略等
- [Handling Sensitive Data In A Docker Application with Kubernetes Secrets](http://scotch.io/tutorials/google-cloud-platform-iii-handling-sensitive-data-in-a-docker-application-with-kubernetes-secrets) 通过 [John Kariuki ](https://twitter.com/_kar_is)
- [How to Create and Use Kubernetes Secrets](http://linoxide.com/containers/create-use-kubernetes-secrets/) 通过 [Mohamed Ez Ez](http://linoxide.com/author/mohamedez/)
- [Kubernetes Security Best Practices](https://dev.to/petermbenjamin/kubernetes-security-best-practices-hlk)
- [Running Vault and Consul on Kubernetes](https://testdriven.io/running-vault-and-consul-on-kubernetes) 通过 [Michael Herman](https://mherman.org/)
- [Securing Kubernetes Clusters by Eliminating Risky Permissions](https://www.cyberark.com/threat-research-blog/securing-kubernetes-clusters-by-eliminating-risky-permissions/) -由 [Eviatar Gerzi](https://twitter.com/g3rzi)
- [Eight Ways to Create a Pod](https://www.cyberark.com/threat-research-blog/eight-ways-to-create-a-pod/) -由 [Eviatar Gerzi](https://twitter.com/g3rzi)


- [Kubernetes Authentication plugins and kubeconfig](http://www.dasblinkenlichten.com/kubernetes-authentication-plugins-and-kubeconfig/) 通过 [Jon Langemak](https://twitter.com/blinken_lichten)
- [Kubernetes Authentication - OpenID Connect](http://www.devoperandi.com/kubernetes-authentication-openid-connect/) 通过 [Michael Ward](https://twitter.com/DevoperandI)
- [Kubernetes authentication via GitHub OAuth and Dex](https://medium.com/preply-engineering/k8s-auth-a81f59d4dff6) 通过 [Amet Umerov](https://github.com/Amet13)


- [Enable IPv6 on Kubernetes with Project Calico](https://www.projectcalico.org/enable-ipv6-on-kubernetes-with-project-calico/) 通过 [Valentin Ouvrard](https://twitter.com/Valentin_NC)
- [Kubernetes in IPV6-only](http://opsnotice.xyz/kubernetes-ipv6-only/) 通过 [Valentin Ouvrard](https://twitter.com/Valentin_NC)
- [Kubernetes 101 – Networking](http://www.dasblinkenlichten.com/kubernetes-101-networking/) 通过 [Jon Langemak](https://twitter.com/blinken_lichten)
- [Kubernetes with OpenStack Cloud Provider: Current state and upcoming changes (part 1 of 2)](http://medium.com/@arthur.souzamiranda/kubernetes-with-openstack-cloud-provider-current-state-and-upcoming-changes-part-1-of-2-48b161ea449a)
- [Comparison of Networking Solutions for Kubernetes](http://machinezone.github.io/research/networking-solutions-for-kubernetes/)
- [IPVS-Based In-Cluster Load Balancing Deep Dive](https://kubernetes.io/blog/2018/07/09/ipvs-based-in-cluster-load-balancing-deep-dive/)



- [GitOps: High-Velocity CI/CD for Kubernetes](http://dzone.com/articles/gitops-high-velocity-cicd-for-kubernetes)
- [Achieving CI/CD with Kubernetes](https://ramitsurana.github.io/myblog/2016/08/01/achieving-ci/cd-with-kubernetes/) 通过 [Ramit Surana](https://twitter.com/ramitsurana)
- [Jenkins declarative pipelines with Kubernetes](http://radu-matei.com/blog/kubernetes-jenkins-azure/)
- [Adding CI/CD to your Spring Boot app with Jenkins X and Kubernetes](https://developer.okta.com/blog/2018/07/11/ci-cd-spring-boot-jenkins-x-kubernetes) 通过 [Matt Raible](https://twitter.com/mraible) 使用 [Jenkins X](https://jenkins-x.io/)
- [DOCKER & KUBERNETES : JENKINS-X ON EKS](http://www.bogotobogo.com/DevOps/Docker/Docker_Kubernetes_Jenkins-X-EKS.php)
- [Continuous Integration and Delivery to AWS Kubernetes](https://semaphoreci.com/blog/continuous-integration-delivery-aws-eks-kubernetes) 使用 [Semaphore](https://semaphoreci.com)
- [CI/CD for Microservices on DigitalOcean Kubernetes](https://semaphoreci.com/blog/cicd-microservices-digitalocean-kubernetes) 使用 [Semaphore](https://semaphoreci.com)
- [How to Release Faster with Continuous Delivery for Google Kubernetes](https://semaphoreci.com/blog/continuous-delivery-google-kubernetes) 使用 [Semaphore](https://semaphoreci.com)
- [Build, Test & Deploy to Kubernetes](https://buddy.works/guides/how-optimize-kubernetes-workflow) 通过 [Buddy](https://buddy.works)
* [CircleCI](http://www.alexecollins.com/continuous-delivery-with-kubernetes-and-circleci/)
- [Kubernetes Deployments: The Ultimate Guide](https://semaphoreci.com/blog/kubernetes-deployment) 通过 [Jérôme Petazzoni](https://twitter.com/jpetazzo)


- [Automate deep learning training with Kubernetes GPU-cluster](https://github.com/Langhalsdino/Kubernetes-GPU-Guide)


- [How to pass the Certified Kubernetes Administrator (CKA) exam on the first attempt](https://medium.com/devopslinks/how-to-pass-certified-kubernetes-administrator-cka-exam-on-first-attempt-36c0ceb4c9e)


- [Try Kubernetes with Vagrant](http://lollyrock.com/articles/kubernetes-vagrant/) 通过 [Christoph Hartmann](https://twitter.com/chri_hartmann)
- [Cluster Consul using Kubernetes API](http://www.devoperandi.com/cluster-consul-using-kubernetes-api/)

*  [Packaging Multiple Resources together](https://planet.jboss.org/post/kubernetes_application_package_multiple_resources_together) 通过阿伦·古普塔（Arun Gupta）
*  [Scaling Docker with Kubernetes](http://www.infoq.com/articles/scaling-docker-with-kubernetes) 通过 [Carlos Sanchez](https://twitter.com/csanchez)
* [Creating a Kubernetes Cluster to Run Docker Formatted Container Images](http://access.redhat.com/articles/1353773) 通过 [Chris Negus](https://twitter.com/linuxcricket)
* [Containerizing Docker on Kubernetes !!](http://www.linkedin.com/pulse/containerizing-docker-kubernetes-ramit-surana) 通过 [Ramit Surana](https://twitter.com/ramitsurana)
* [Quay: Introducing an Application Registry for Kubernetes](http://coreos.com/blog/quay-application-registry-for-kubernetes.html) 通过安托万·罗格朗
* [Play With Kubernetes Quickly Using Docker](http://zwischenzugs.wordpress.com/2015/04/06/play-with-kubernetes-quickly-using-docker/)
* [What even is a kubelet?](http://kamalmarhubi.com/blog/2015/08/27/what-even-is-a-kubelet/) 通过 [Kamal Marhubi](https://twitter.com/kamalmarhubi)
* [Kubernetes from the ground up: the API server](http://kamalmarhubi.com/blog/2015/09/06/kubernetes-from-the-ground-up-the-api-server/) 通过 [Kamal Marhubi](https://twitter.com/kamalmarhubi)
* [CoreOS + Kubernetes Step By Step](http://coreos.com/tectonic/docs/latest/tutorials/kubernetes/getting-started.html) 通过 [Coreos](https://twitter.com/coreoslinux)
* [Deploying to Kubernetes with Panamax](http://www.ctl.io/developers/blog/post/deploying-to-kubernetes-with-panamax/) 通过 [Brian DeHamer](https://twitter.com/bdehamer)
* [Deploy Kubernetes with a Single Command Using Atomicapp](http://www.projectatomic.io/blog/2015/08/fun-with-kubenetes-and-atomicapp/) 通过 [Jason Brooks](https://twitter.com/jasonbrooks)
* [Deploying a Bare Metal Kubernetes Cluster](http://blog.jameskyle.org/2014/08/deploying-baremetal-kubernetes-cluster/) 通过 [James Kyle](https://twitter.com/jameskyle75)
* [Kubernetes clusters with Oh-My-Vagrant](http://ttboj.wordpress.com/2015/05/02/kubernetes-clusters-with-oh-my-vagrant/) 通过 [James](https://twitter.com/#!/purpleidea)
* [Fleet Unit Files for Kubernetes on CoreOS](http://blog.michaelhamrah.com/2015/06/fleet-unit-files-for-kubernetes-on-coreos/) 通过 [Michael Hamrah](https://twitter.com/mhamrah)
* [Kubernetes Container Orchestration through Java APIs](http://keithtenzer.com/2015/05/04/kubernetes-container-orchestration-through-java-apis/) 通过 [Keith Tenzer](https://twitter.com/keithtenzer)
* [Docker Clustering Tools Compared: Kubernetes vs Docker Swarm](http://technologyconversations.com/2015/11/04/docker-clustering-tools-compared-kubernetes-vs-docker-swarm/)
* [Kubernetes Production Patterns (and Anti-Patterns)](https://github.com/gravitational/workshop/blob/master/k8sprod.md)
* [Introducing Kubic Project](https://www.suse.com/communities/blog/introducing-kubic-project-new-open-source-project/)
* [Three post learn k8s](https://blog.alexellis.io/tag/learn-k8s/)
* [Kubernetes tips & tricks](http://opsnotice.xyz/kubernetes-tips-tricks/)
* [Running Flask on Kubernetes](https://testdriven.io/running-flask-on-kubernetes)
* [Deploying Node Apps the "Right" Way](https://kubesail.com/blog/deploying-node-apps-the-right-way) 通过 [Dan Pastusek](https://twitter.com/pastudan)
* [Simplify your research experiments with Kubernetes](https://www.ovh.com/blog/simplify-your-research-experiments-with-kubernetes/) 通过 [Parmentier Laurent](https://www.linkedin.com/in/laurent-parmentier-33187948/)
* [Self-registering compact k3OS clusters to Rancher Server via cloud-init](https://medium.com/@jamesdavidbohrman/self-registering-compact-k3os-clusters-to-rancher-server-via-cloud-init-d4a89028c1f8) 通过 [James D. Bohrman](https://github.com/jdbohrman)
* [Benchmarking 5 Popular Load Balancers: Nginx, HAProxy, Envoy, Traefik, and ALB](https://www.loggly.com/blog/benchmarking-5-popular-load-balancers-nginx-haproxy-envoy-traefik-and-alb/)
* [Magento on Kubernetes](https://buddy.works/guides/magento-kubernetes)
* [Wordpress in Docker with Kubernetes](https://buddy.works/guides/wordpress-docker-kubernetes-part-3)

托管省长
=======================================================================

  - [Platform9](http://platform9.com)
  - [OpenShift Online](http://www.openshift.com/devpreview/index.html)
  - [Eldarion Cloud](http://eldarion.cloud/)
  - [NetApp Kubernetes Service (formerly StackPoint Cloud)](https://cloud.netapp.com/kubernetes-service)
  - [Hasura](https://hasura.io/)
  - [ELASTX](https://www.elastx.se/)
  - [Nirmata](https://www.nirmata.com/)


  - [Cisco Container Platform](https://www.cisco.com/c/en/us/products/cloud-systems-management/container-platform/index.html)
  - [Gardener](https://github.com/gardener/gardener) -阿里巴巴，AWS，Azure，GCP和OpenStack集群管理器
  - [Gravity](https://gravitational.com/gravity) -前Telekube
  - [Kommander](https://d2iq.com/solutions/ksphere/kommander) -本地或云Kubernetes集群的联合管理和治理
  - [Kqueen](https://github.com/Mirantis/kqueen)
  - [Kubermatic](http://www.loodse.com/)
  - [KubeSphere](https://github.com/kubesphere/kubesphere) -具有令人敬畏的用户体验和向导UI的全堆栈且易于使用的容器平台，支持在Linux和Kubernetes上进行安装.
  - [Kublr](https://kublr.com/how-it-works/) -AWS，Azure，GCP，vSphere，vCloud Director和本地群集管理器
  - [PKS](https://pivotal.io/platform/pivotal-container-service) -Pivotal，VMWare和Google的集群管理器
  - [Rancher](https://rancher.com/)


  - [DevSpace](https://github.com/covexo/devspace) -直接在任何Kubernetes集群中构建，测试和运行代码
  - [Draft](http://draft.sh) -开发人员使用Kubernetes创建云原生应用程序的工具
  - [Eclipse Che](https://github.com/eclipse/che) -具有SSH和多用户支持的云开发工作区
  - [Garden](https://garden.io) -编排您的开发工作流程，以使开发和开发微服务更快，更轻松
  - [Humanitec](https://humanitec.com) -持续交付API
  - [Knative](https://github.com/knative/) -建立，部署和管理现代无服务器工作负载的平台
  - [Okteto](https://github.com/okteto/okteto)  -直接在任何Kubernetes集群中进行开发  无需提交，构建或推送
  - [Mantl](https://github.com/mantl/mantl) -用于快速部署全球分布式服务的现代平台
  - [Spring Cloud Kubernetes](https://github.com/spring-cloud/spring-cloud-kubernetes) -与Kubernetes的Spring Cloud集成
  - [VAMP](http://vamp.io) -原生云发布管理与编排
  - [Tilt](https://github.com/windmilleng/tilt) -为部署到Kubernetes的团队管理本地开发实例


  - [Canonical Distribution of Kubernetes - CDK](https://www.ubuntu.com/kubernetes)
  - [Docker EE](https://www.docker.com/enterprise-edition) -Docker企业版2.0
  - [IBM Cloud Private](https://www.ibm.com/cloud/private)
  - [Kublr](https://kublr.com/) -企业级Kubernetes-多云和本地Kubernetes运营中心
  - [NetApp Kubernetes Service](https://cloud.netapp.com/kubernetes-service)
  - [OpenShift - Container Platform](http://www.openshift.com/container-platform/index.html)
  - [SUSE Container as a Service](http://www.suse.com/betaprogram/caasp-beta/)
  - [VMware Tanzu Kubernetes Grid (TKG)](https://tanzu.vmware.com/kubernetes-grid) -企业就绪的多云Kubernetes运行时
  - [WorldSibu-Forma](https://worldsibu.tech/forma/) -带有Kubernetes的多云远程区块链基础架构协调器
  


   - [Alibaba Cloud](https://www.alibabacloud.com/product/kubernetes) -阿里云Kubernetes云容器服务
   - [AWS EKS](https://aws.amazon.com/eks/) -亚马逊弹性容器服务
   - [Azure AKS](https://docs.microsoft.com/en-us/azure/aks/) -Azure Kubernetes服务
   - [DigitalOcean](https://www.digitalocean.com/products/kubernetes/) -DigitalOcean州长
   - [GKE](https://cloud.google.com/container-engine/) -Google Kubernetes引擎
   - [IKS](https://www.ibm.com/cloud/container-service) -IBM Cloud Kubernetes服务
   - [OKE](https://cloud.oracle.com/containers/kubernetes-engine) -Oracle Kubernetes引擎
   - [OVH Managed Kubernetes](https://www.ovh.co.uk/kubernetes/) -OVH管理的州长
   - [Rackspace](https://www.rackspace.com/en-in) -机架空间
   - [VMware Cloud PKS](https://cloud.vmware.com/vmware-cloud-pks)


   * Kubernetes平台即服务提供商*

  - [Alauda Container Platform](http://www.alauda.cn/?lang=EN)
  - [Cloud Foundry](https://github.com/cloudfoundry/cf-for-k8s)
  - [Eldarion Cloud](http://eldarion.cloud)
  - [Hasura](http://www.hasura.io)
  - [Kel](http://www.kelproject.com)
  - [KubeSail](https://kubesail.com) -一种简单，免费的尝试Kubernetes的方法
  - [KubeSphere](https://github.com/kubesphere/kubesphere) -全栈且易于使用的容器平台，具有出色的用户体验和向导UI.
  - [Kyma](https://kyma-project.io/)  -使用无服务器功能扩展应用程序的平台.  它提供了一系列粘合在一起的云原生项目，以简化服务的创建和管理.
  - [OpenShift Online/Dedicated/Container Platform](https://www.openshift.com/)
  - [OpenShift Origin (OKD)](http://www.okd.io)
  - [Rancher](http://rancher.com/running-kubernetes-aws-rancher/)
  - [RIO](https://rio.io/) -基于Kubernetes的MicroPaaS
  - [teresa](https://github.com/luizalabs/teresa) -在Kubernetes上运行的简单PAAS.
  - [Z.A.R.V.I.S.](https://zarvis.ai) -免费将Github项目部署到托管Kubernetes

互动学习环境
=======================================================================

*使用交互式环境学习Kubernetes，无需下载或配置*

* [Katacoda](http://www.katacoda.com/courses/kubernetes)
* [Kubernetes Bootcamp](http://kubernetesbootcamp.github.io/kubernetes-bootcamp/)
* [Magic Sandbox](https://magicsandbox.com/)
* [Play with Kubernetes](http://labs.play-with-k8s.com/)

MOOC课程/教程
=======================================================================

*可用的免费在线课程列表（[MOOC](https://en.wikipedia.org/wiki/Massive_open_online_course)）和教程*


  - [Scalable Microservices with Kubernetes at Udacity](http://in.udacity.com/course/scalable-microservices-with-kubernetes--ud615)
  - [Introduction to Kubernetes at edX](http://www.edx.org/course/introduction-kubernetes-linuxfoundationx-lfs158x)
  - [Just Enough Kubernetes to be Dangerous](https://www.schoolofdevops.net/p/just-enough-kubernetes)
  - [(Classpert) A list of free and paid Kubernetes courses from popular e-learning platforms](https://classpert.com/kubernetes)


  - [Kubernetes Tutorials by Kubernetes Team](http://kubernetes.io/docs/tutorials/)
  - [Kubernetes By Example by OpenShift Team](http://kubernetesbyexample.com)
  - [Kubernetes Tutorial by Tutorialspoint](http://www.tutorialspoint.com/kubernetes/)
  - [Imperative vs. Declarative — a Kubernetes Tutorial](https://medium.com/payscale-tech/imperative-vs-declarative-a-kubernetes-tutorial-4be66c5d8914) 通过 [Adrien Trouillaud](https://github.com/adrienjt/)
  - [Learning Kubernetes, The Chinese Taoist Way](https://github.com/caicloud/kube-ladder)

实例探究
=======================================================================

*各种不同案例研究*

* [Building a Bank with Kubernetes](http://monzo.com/blog/2016/09/19/building-a-modern-bank-backend/)
* [Bringing Pokemon Go to Google Cloud](http://cloudplatform.googleblog.com/2016/09/bringing-Pokemon-GO-to-life-on-Google-Cloud.html)
* [Monitoring Kubernetes at Wayblazer](http://sysdig.com/blog/monitoring-docker-kubernetes-wayblazer/)
* [Major League Soccer Monolith to Kubernetes Transition](http://sysdig.com/blog/monoliths-kubernetes-monitoring-transitioning-docker-major-league-soccer/)
* [Using Kubernetes on AWS](https://github.com/hjacobs/kubernetes-on-aws-users)
* [Kubernetes at Github](https://github.blog/2017-08-16-kubernetes-at-github/)
* [Kubernetes the hard way (installation from scratch)](http://github.com/kelseyhightower/kubernetes-the-hard-way/)
* [Kubernetes Failure Stories](https://github.com/hjacobs/kubernetes-failure-stories)

持久卷提供者
=======================================================================

* Kubernetes的一些持久卷提供者列表. [Persistent Volume Providers](https://github.com/kubernetes/examples/tree/master/staging/persistent-volume-provisioning) 了解更多信息*

* [AWS](http://aws.amazon.com)
* [CephRBD](http://ceph.com/ceph-storage/block-storage/)
* [GCE](https://cloud.google.com/compute/)
* [Glusterfs](http://www.gluster.org/)
* [Hitachi](https://knowledge.hitachivantara.com/Documents/Adapters_and_Drivers/Storage_Adapters_and_Drivers/Containers/1.0/Storage_Plug-in_for_Containers_Quick_Reference_Guide_v1.0.0)
* [HPE](https://github.com/hpe-storage/dory)
* [Kube-Aliyun](https://github.com/kubeup/kube-aliyun)
* [Linode](https://www.linode.com/blockstorage)
* [Microsoft](https://github.com/Microsoft/K8s-Storage-Plugins)
* [NetApp Trident](https://github.com/NetApp/trident)
* [OpenEBS](http://github.com/openebs/openebs/)
* [OpenStack Cinder](http://wiki.openstack.org/cinder)
* [Portworx](http://portworx.com/)
* [Pure Storage](https://hub.docker.com/r/purestorage/k8s/)
* [QuoByte](http://www.quobyte.com/)
* [Rancher Longhorn](https://github.com/rancher/longhorn)
* [Rook](http://rook.io/)
* [StorageOS](http://storageos.com)
* [Stork](https://github.com/libopenstorage/stork)

容器存储接口插件
=======================================================================

*部分清单 [Container Storage Interface](https://kubernetes-csi.github.io/docs/)  Kubernetes的插件.  查看 [Kubernetes-CSI Drivers](https://kubernetes-csi.github.io/docs/drivers.html) 以获得完整列表*

* [Alibaba Cloud](https://github.com/kubernetes-sigs/alibaba-cloud-csi-driver)
* [AWS EBS](https://github.com/kubernetes-sigs/aws-ebs-csi-driver)
* [AWS EFS](https://github.com/kubernetes-sigs/aws-efs-csi-driver)
* [AWS FSx for Lustre](https://github.com/kubernetes-sigs/aws-fsx-csi-driver)
* [Ceph](https://github.com/ceph/ceph-csi)
* [Cinder](https://github.com/kubernetes/cloud-provider-openstack/tree/master/pkg/csi/cinder)
* [Cloudscale](https://github.com/cloudscale-ch/csi-cloudscale)
* [DigitalOcean](https://github.com/digitalocean/csi-digitalocean)
* [Ember](https://ember-csi.io)
* [Google Compute Engine Persistent Disk](https://github.com/kubernetes-sigs/gcp-compute-persistent-disk-csi-driver)
* [Intel PMEM-CSI](https://github.com/intel/pmem-CSI)
* [KaDalu - Gluster](https://github.com/kadalu/kadalu)
* [Linode Block Storage](https://github.com/linode/linode-blockstorage-csi-driver)
* [Longhorn](https://github.com/longhorn/longhorn)
* [NetApp Trident](https://github.com/NetApp/trident)
* [Nexenta](https://nexentaedge.io/docs/kubernetes-csi.html)
* [OpenSDS](https://github.com/opensds/nbp/tree/master/csi)
* [OpenStack Cinder](https://github.com/kubernetes/cloud-provider-openstack/tree/master/pkg/csi/cinder)
* [Portworx](https://github.com/libopenstorage/openstorage/tree/master/csi)
* [Quobyte](https://github.com/quobyte/quobyte-csi)
* [S3](https://github.com/ctrox/csi-s3)
* [Vault](https://github.com/kubevault/csi-driver)
* [VMware vSphere](https://github.com/kubernetes-sigs/vsphere-csi-driver)

群集API提供程序
=======================================================================

*部分清单 [Cluster API](https://github.com/kubernetes-sigs/cluster-api)  Kubernetes的提供商.  查看 [Kubernetes-CAPI Providers](https://cluster-api.sigs.k8s.io/reference/providers.html) 了解更多信息*

  ### 引导程序

   - [Kubeadm](https://github.com/kubernetes-sigs/cluster-api/tree/master/bootstrap/kubeadm)

  ### 基础设施

   - [AWS](https://github.com/kubernetes-sigs/cluster-api-provider-aws)
   - [Azure](https://github.com/kubernetes-sigs/cluster-api-provider-azure)
   - [Metal3-io](https://github.com/metal3-io/cluster-api-provider-baremetal)
   - [DigitalOcean](https://github.com/kubernetes-sigs/cluster-api-provider-digitalocean)
   - [GCP](https://github.com/kubernetes-sigs/cluster-api-provider-gcp)
   - [IBM Cloud](https://github.com/kubernetes-sigs/cluster-api-provider-ibmcloud)
   - [OpenStack](https://github.com/kubernetes-sigs/cluster-api-provider-openstack)
   - [VMware vSphere](https://github.com/kubernetes-sigs/cluster-api-provider-vsphere)

开发人员库/脚本
=======================================================================

*一些用于执行和良好引用的库和脚本的列表*


   - [Pykube](https://github.com/hjacobs/pykube)


   - [Jenkinsfile with Helm, Go, Docker, Kubectl, JNLP](https://github.com/lachie83/croc-hunter/blob/master/Jenkinsfile)

Projects
=======================================================================

*与Kubernetes相关的项目可能对您有所帮助*


## Related Software

*旨在使Kubernetes的生活更加美好，强大，可扩展的项目*

* [Ambassador](http://www.getambassador.io) -基于Envoy代理构建的API网关
* [Argo](https://github.com/argoproj/argo) -Kubernetes的工作流引擎
* [Bitnami Kubernetes Production Runtime](https://kubeprod.io)
* [Escalator](https://github.com/atlassian/escalator) -用于Kubernetes的批处理或作业优化的水平自动缩放器
* [Fission Workflows](https://github.com/fission/fission-workflows) -基于工作流的无服务器功能组合
* [Forecastle](https://github.com/stakater/Forecastle) -可以动态发现并提供启动板以访问Kubernetes上部署的应用程序的仪表板
* [Git Webhook Proxy](https://github.com/stakater/GitWebhookProxy) -代理，可让Webhook访问防火墙后的运行服务
* [Hypernetes](https://github.com/hyperhq/hypernetes)
* [Ingress Monitor Controller](https://github.com/stakater/IngressMonitorController) -监视入口端点并在配置的正常运行时间检查器上自动注册活动警报
* [k8s-label-rules-webhook](https://github.com/circa10a/k8s-label-rules-webhook) -准入网络挂钩，以强制执行在您的k8s集群中创建的资源标签的标准
* [kmachine](https://github.com/skippbox/kmachine)
* [KEDA](https://github.com/kedacore/keda) -基于Kubernetes的事件驱动自动缩放
* [kube-fledged](https://github.com/senthilrch/kube-fledged) -一个K8S插件，用于直接在集群工作程序节点上创建和管理容器映像的缓存
* [kube-openvpn](https://github.com/pieterlange/kube-openvpn)
* [Kubeform](http://capgemini.github.io/kubeform/)
* [Kubefuse](http://opencredo.com/introducing-kubefuse-file-system-kubernetes/)
* [Kubefwd](https://github.com/txn2/kubefwd) -批量端口转发Kubernetes服务以进行本地开发.
* [Kubernetes Cluster Federation (previously Ubernetes)](https://github.com/kubernetes-sigs/kubefed)
* [Kubernetes Ec2 Autoscaler](https://github.com/openai/kubernetes-ec2-autoscaler)
* [Kubic-Project](https://github.com/kubic-project)
* [Reloader](https://github.com/stakater/Reloader) -将ConfigMap和Secrets的更新自动加载到用于部署，StatefulSet和DaemonSet的容器​​中
* [Telepresence](http://www.telepresence.io) -针对远程Kubernetes集群在本地开发/调试服务
* [krane](https://github.com/Shopify/krane) -一个命令行工具，可帮助您将更改发送到Kubernetes命名空间并了解结果
* [ktunnel](https://github.com/omrikiei/ktunnel) -一个命令行工具，可在Kubernetes和您的集群之间建立反向隧道，将其用于本地开发/调试服务或与本地资源集成.
* [k8s-platform-lcm](https://github.com/arminc/k8s-platform-lcm) -一种更快，更轻松的方法来管理应用程序和工具的生命周期，在Kubernetes平台上运行和生活
* [Pixie](https://github.com/pixie-labs/pixie) -实时调试多集群K8s环境，而无需更改代码和将数据移出集群.
* [pluto](https://github.com/FairwindsOps/pluto) -帮助发现Kubernetes中不推荐使用的apiVersions的cli工具

## Package Managers

* [CNAB](https://cnab.io) -CNAB促进了容器本地应用程序及其耦合服务的捆绑，安装和管理.
* [Helm](http://helm.sh) -有关更多信息，请查看- [Awesome Helm](https://github.com/cdwv/awesome-helm).
* [Cloudsmith](https://cloudsmith.io/l/helm-repository/) -完全托管的软件包管理SaaS，为公共和私有Kubernetes注册中心提供一流的支持（Docker + Helm Charts，以及许多其他服务）.

## Monitoring Services

*保持对kubernetes的定期监视*

* [Console](http://github.com/kubernetes/dashboard)
* [BotKube](https://github.com/infracloudio/botkube) -可帮助您监控Kubernetes集群，调试关键部署并为标准做法提供建议的应用程序
* [Datadog](http://www.datadoghq.com/)
* [Dynatrace](https://www.dynatrace.com/technologies/kubernetes-monitoring/) -Kubernetes集群和工作负载监控
* [eventrouter](https://github.com/heptiolabs/eventrouter) -简单的自省型kubernetes服务，可将事件转发到指定的接收器.
* [Goldpinger](https://github.com/bloomberg/goldpinger) 显示，监视和提醒集群间连接
* [Grafana Kubernetes App](https://github.com/grafana/kubernetes-app)
* [Heapster](https://github.com/kubernetes/heapster)
* [Instana](https://www.instana.com/) -自动Kubernetes应用程序性能监控
* [kail](https://github.com/boz/kail)  -Kubernetes日志查看器.  从所有匹配的容器的所有容器中流式传输日志.
* [Kubebox](https://github.com/astefanutti/kubebox) -Kubernetes的终端控制台
* [Kubecost](https://kubecost.com/) -根据资源的财务成本监控资源
* [Kubedash](https://github.com/kubernetes/kubedash) -**不推荐使用**信息库已归档且为只读
* [Kubernetes Operational View](https://github.com/hjacobs/kube-ops-view) -多个K8s集群的只读系统仪表板
* [K8Dash](https://github.com/herbrandson/k8dash) -实时K8S替代仪表板
* [Kubernetes Web View](https://codeberg.org/hjacobs/kube-web-view) -在纯HTML前端中列出并查看具有永久链接友好URL的所有Kubernetes资源（包括CRD）
* [Kubespy](https://github.com/pulumi/kubespy) -由Pulumi提供支持的实时观察Kubernetes资源的工具.
* [Kubetail](https://github.com/johanhaleby/kubetail)
* [Kubewatch](https://github.com/skippbox/kubewatch)
* [Netdata](https://www.netdata.cloud)  -开源Kubernetes监控.  通过网络数据进行部署 [Helm chart](https://github.com/netdata/helmchart).
* [Netsil](https://github.com/netsil/manifests)
* [New Relic](https://newrelic.com/platform/kubernetes) -Kubernetes监视和可视化服务.
* [NexClipper](https://github.com/NexClipper/NexClipper) -用于监视Kubernetes和容器的开源软件.
* [Outcold Solutions](https://www.outcoldsolutions.com) -在Splunk Enterprise和Splunk Cloud中监控Kubernetes，OpenShift和Docker（指标和日志转发）
* [Prometheus](http://prometheus.io)
* [Replex.io](https://replex.io) -总督与成本控制.
* [Searchlight](https://github.com/appscode/searchlight)
* [Sematext](https://sematext.com/)
* [StatusBay](https://github.com/similarweb/statusbay) -Kubernetes部署可见性（包括松弛通知，指标和检查扩充，资源整合等）
* [Sysdig Monitoring](https://www.sysdig.com/)
* [Sysdig Open Source](http://www.sysdig.org/)
* [The Elastic Stack](https://www.elastic.co/docker-kubernetes-container-monitoring) -用于监视和可视化K8指标，日志，应用程序跟踪等的开源解决方案.
* [Weave Scope](http://www.weave.works/products/weave-scope/)
* [kube-state-metrics](https://github.com/kubernetes/kube-state-metrics) -侦听Kubernetes API服务器并生成有关对象状态的指标的简单服务.
* [loki](https://github.com/grafana/loki) -Loki是受Prometheus启发的水平可扩展，高度可用的多租户日志聚合系统.
* [Loghouse](https://github.com/flant/loghouse) -有效地存储大量日志（在ClickHouse数据库中），使用简单的查询语言进行处理，并通过Web UI在线进行监视.
* [kube-eventer](https://github.com/AliyunContainerService/kube-eventer) -kube-eventer将kubernetes事件发送到接收器（kafka，slack，webhook等）

## Testing

*测试您在Kubernetes上运行的应用程序*

* [chaoskube](https://github.com/linki/chaoskube) -定期杀死Kubernetes集群中的随机Pod
* [k8s-testsuite](https://github.com/mrahbar/k8s-testsuite) -用于Kubernetes集群的网络和负载测试的Helm图表
* [kboom](https://github.com/mhausenblas/kboom) -Kubernetes规模和均质负载测试仪
* [Krucible](https://usekrucible.com/) -快速创建临时Kubernetes集群进行测试 
* [kind](https://github.com/bsycorp/kind) -一个单节点群集，可在30秒内针对您准备好的CI运行测试
* [k3d](https://github.com/rancher/k3d) -在容器化节点中快速创建单节点或多节点k3s集群
* [kube-monkey](https://github.com/asobti/kube-monkey) -Kubernetes集群的混沌猴子
* [Kubeadm-dind-cluster](https://github.com/kubernetes-sigs/kubeadm-dind-cluster) -基于kubeadm的多节点测试集群
* [KUTTL](https://kuttl.dev) -KUTTL（Kubernetes测试工具）是用于测试Kubernetes运营商的工具包 
* [PowerfulSeal](https://github.com/bloomberg/powerfulseal) -杀死目标吊舱和机器以测试软件的可靠性
* [Sonobuoy](https://github.com/vmware-tanzu/sonobuoy) -运行Kubernetes一致性测试的诊断工具
* [Test-Infra](https://github.com/kubernetes/test-infra)
* [predator](https://github.com/Zooz/predator) -Kubernetes的分布式性能测试平台
* [Octopus](https://github.com/kyma-incubator/octopus) -Octopus是一个测试框架，可让您在Kubernetes集群上运行定义为Docker映像的集成测试.

## Continuous Delivery

*构建-测试-部署自动工作流程软件，旨在使生产环境更加稳定，并使工程师的寿命更长*

* [Jenkins](https://jenkins.io)
   * [Jenkins-Kubernetes Plugin](https://github.com/jenkinsci/kubernetes-plugin) 通过 [Carlos Sanchez](https://www.twitter.com/csanchez)
   * [Automated Image Builds with Jenkins, Packer, and Kubernetes](https://cloudplatform.googleblog.com/2015/05/Automated-Compute-Engine-and-Docker-Image-Builds-with-Jenkins-Packer-and-Kubernetes.html)
   * [On-demand Jenkins slaves with Kubernetes and the Google Container Engine](http://www.cloudbees.com/blog/demand-jenkins-slaves-kubernetes-and-google-container-engine)
   * [Lab: Build a Continuous Deployment Pipeline with Jenkins and Kubernetes](https://github.com/GoogleCloudPlatform/continuous-deployment-on-kubernetes)
   * [Jenkins Operator - Kubernetes native Jenkins operator](https://github.com/jenkinsci/kubernetes-operator)
* [Jenkins X](http://jenkins-x.io/) -使用最佳的OSS工具（如Jenkins，Helm，Skaffold，Kaniko，Knative Build，Knative Pipeline和Prow），针对带有请求的GitOps推广和预览环境的Kubernetes自动化CI / CD
* [Apollo](https://github.com/logzio/apollo) -开源应用程序，为团队提供了自助服务UI，用于创建其服务并将其部署到Kubernetes.
* [Argo CD](https://github.com/argoproj/argo-cd) -Kubernetes的声明式连续部署.
* [autoapply](https://github.com/autoapply/autoapply) -自动将Git存储库中的更改应用于Kubernetes集群
* [Buildkite](https://github.com/buildkite/charts) -具有基础架构上的代理的精益CI / CD云托管控制平面.
* [Codefresh](https://codefresh.io/) -Kubernetes CI / CD平台（带有私有Docker和Helm Chart存储库）
* [Dispatch](https://d2iq.com/solutions/ksphere/dispatch) -基于Tekton和Argo CD的企业级Kubernetes GitOps框架
* [GitLab](http://blog.lwolf.org/post/how-to-easily-deploy-gitlab-on-kubernetes/)
* [k8s-deploy-helper](https://github.com/lifechurch/k8s-deploy-helper) -通过GitLab轻松部署Kubernetes应用程序的框架.
* [kb8or](https://github.com/UKHomeOffice/kb8or)
* [Keel](https://keel.sh/)
* [Kit](http://invisionapp.github.io/kit/)
* [Kontinuous](https://github.com/AcalephStorage/kontinuous)
* [KubeCI](https://github.com/kubeciio)
* [Razee](https://github.com/razee-io/Razee)
* [Shippable](http://blog.shippable.com/topic/kubernetes)
* [Shipper](https://github.com/bookingcom/shipper) -使用Helm的Kubernetes本机多集群金丝雀或蓝绿色产品.
* [Spinnaker](http://www.spinnaker.io/blog/deploy-to-kubernetes-using-spinnaker)
* [Vili](https://github.com/airware/vili)
* [Weave Flux – GitOps reconcoliation operator](https://github.com/weaveworks/flux)
* [Wercker](http://blog.wercker.com/topic/kubernetes)
* [Werf](https://werf.io)  -具有高级功能的GitOps工具可构建映像并将其部署到Kubernetes.  与任何现有的CI系统集成.
* [Buddy](https://buddy.works)

## Serverless Implementations

* [FaaS-netes](https://github.com/alexellis/faas-netes)
* [Fission](https://github.com/platform9/fission)
* [Funktion](https://github.com/fabric8io/funktion)
* [Iron.io](http://iron.io)
* [Kubeless](https://github.com/skippbox/kubeless)
* [Nuclio](https://github.com/nuclio/nuclio)
* [OpenFaaS](https://github.com/alexellis/faas)
* [OpenWhisk](https://github.com/openwhisk)
* [Virtual Kubelet](https://github.com/virtual-kubelet/virtual-kubelet) -允许节点由其他服务和提供程序支持.

## Operators

* [Addon-operator](https://github.com/flant/addon-operator) -向舵图添加钩子和值，以增强舵的功能，并将图转换为可自我配置并响应集群更改的智能模块.
* [Cert manager](https://github.com/kelseyhightower/kube-cert-manager)
* [Cert Operator](https://github.com/giantswarm/cert-operator)
* [cert-manager](https://github.com/jetstack/cert-manager)
* [Container Linux Update Operator](https://github.com/coreos/container-linux-update-operator)
* [Couchbase](https://blog.couchbase.com/introducing-couchbase-operator/)
* [DB Operator](https://github.com/k8sdb/operator)
* [Elasticsearch](https://github.com/upmc-enterprises/elasticsearch-operator)
* [etcd](https://github.com/coreos/etcd-operator)
* [Istio](https://github.com/banzaicloud/istio-operator)
* [K8s Operator Workshop](https://github.com/lukebond/cc-au-k8s-operators-workshop)
* [Kafka](https://github.com/krallistic/kafka-operator)
* [Kong API](https://github.com/upmc-enterprises/kong-operator)
* [kooper](https://github.com/spotahome/kooper) -用于创建Kubernetes运算符和控制器的简单Go库
* [Kubernetes Operators](https://github.com/sapcc/kubernetes-operators)
* [KubeVirt](https://github.com/kubevirt)
* [KUDO](https://kudo.dev) -KUDO（Kubernetes通用声明性运算符）是用于编写Kubernetes运算符的工具集
* [Kured](https://github.com/weaveworks/kured) -Kured（Kubernetes重新启动守护程序）是一个Kubernetes守护程序集，它执行安全的节点自动重新启动
* [Memcached](https://github.com/kbst/memcached)
* [MongoDB](https://github.com/kbst/mongodb)
* [MySQL](https://github.com/oracle/mysql-operator)
* [Operator Kit](https://github.com/rook/operator-kit)
* [Operator SDK](https://github.com/operator-framework/operator-sdk)
* [OperatorHub.io](https://www.operatorhub.io) -Kubernetes社区共享运营商的新家
* [PlanetScaleDB Operator](https://docs.planetscale.com/psdb-operator/overview)
* [PostgreSQL](https://github.com/CrunchyData/postgres-operator)
* [PostgreSQL](https://github.com/zalando-incubator/postgres-operator) -使用StatefulSets和PostgreSQL管理PostgreSQL集群 [Patroni](https://github.com/zalando/patroni).
* [Prometheus](https://github.com/coreos/prometheus-operator)
* [Shell-operator](https://github.com/flant/shell-operator) - a tool for running event-driven scripts in a Kubernetes cluster.
* [TiDB Operator](https://github.com/pingcap/tidb-operator) -TiDB Operator在Kubernetes上管理TiDB集群，并自动执行与操作TiDB集群相关的任务.
* [Vitess Operator](https://github.com/planetscale/vitess-operator)

## Custom Schedulers

* [bashScheduler](https://github.com/rothgar/bashScheduler) -用bash写
* [escheduler](https://github.com/agonzalezro/escheduler) -写于长生不老药
* [firmament](https://github.com/camsas/firmament)
* [ksched](https://github.com/coreos/ksched) -基于实验流程的调度程序
* [Scheduler](https://github.com/kelseyhightower/scheduler) -基于成本的计划程序
* [Sticky Node Scheduler](https://github.com/philipn/kubernetes-sticky-node-scheduler)

## Container Support

* Kubernetes支持的Linux容器列表.*

* [Docker](http://docker.com)
* [containerd](https://github.com/containerd/containerd)
* [cri-containerd](https://github.com/kubernetes-incubator/cri-containerd) -Kubernetes容器运行时接口的基于容器的实现
* [CRI-O](https://github.com/kubernetes-incubator/cri-o)
* [Hyper.sh/frakti](https://github.com/kubernetes/frakti) -基于管理程序的容器运行时
* [virtlet](https://github.com/Mirantis/virtlet) -Kubernetes CRI实施用于运行VM工作负载
* [infranetes](https://github.com/apporbit/infranetes)
* [Kata Containers](https://katacontainers.io)

## Database

* [Apache Ignite](https://apacheignite.readme.io/docs/kubernetes-deployment) -以内存为中心的分布式数据库，缓存，处理平台
* [Cassandra / DataStax](http://blog.kubernetes.io/2016/07/thousand-instances-of-cassandra-using-kubernetes-pet-set.html)
* [CockroachDB](http://www.cockroachlabs.com/blog/running-cockroachdb-on-kubernetes/)
* [Couchbase](https://docs.couchbase.com/operator/current/install-kubernetes.html)
* [CrateDB](https://crate.io/docs/crate/guide/en/latest/deployment/containers/kubernetes.html)
* [Hazelcast](http://ppires.wordpress.com/2014/12/24/clustering-hazelcast-on-kubernetes/)
* [Minio](http://minio.io)
* [MongoDB](http://www.mongodb.com/blog/post/running-mongodb-as-a-microservice-with-docker-and-kubernetes)
* [PlanetScaleDB](https://www.planetscale.com)
* [RDS](https://github.com/sorenmat/k8s-rds) -通过Kubernetes的CRD提供RDS数据库
* [TiDB](https://github.com/pingcap/tidb) -与MySQL协议兼容的分布式HTAP数据库 
* [Vitess](http://vitess.io/) -由Youtube对MySql进行水平缩放
* [YugabyteDB](https://docs.yugabyte.com/latest/deploy/kubernetes/) -可水平扩展，与Postgres兼容的SQL数据库.

## Networking

* [Antrea](https://github.com/vmware-tanzu/antrea/) -基于Open vSwitch的Kubernetes网络解决方案
* [AWS VPC CNI](https://github.com/aws/amazon-vpc-cni-k8s) -使用弹性网络接口的网络插件
* [Calico](http://www.projectcalico.org/)
* [Canal](https://github.com/tigera/canal) 通过 [Tigera](https://github.com/tigera)
* [Cilium](https://github.com/cilium/cilium)
* [Cisco ACI](https://www.cisco.com/c/en/us/td/docs/switches/datacenter/aci/apic/sw/kb/b_Kubernetes_Integration_with_ACI.html) -思科的CNI插件支持ACI架构
* [CNI-Genie](https://github.com/Huawei-PaaS/CNI-Genie)
* [cni-ipvlan-vpc-k8s](https://github.com/lyft/cni-ipvlan-vpc-k8s)
* [Contiv](http://contiv.github.io/)
* [External DNS](https://github.com/kubernetes-incubator/external-dns) -通过Kube资源动态控制DNS记录
* [Goldpinger](https://github.com/bloomberg/goldpinger) 显示，监视和提醒集群间连接
* [illuminatio](https://github.com/inovex/illuminatio) 是用于自动测试kubernetes网络策略的工具
* [Infoblox](https://github.com/infobloxopen/cni-infoblox)
* [Kube-router](http://github.com/cloudnativelabs/kube-router)
* [KubeIP](http://github.com/doitintl/kubeip) 为GKE上的节点设置静态ip（用于将IP列入白名单）
* [kubernetes-network-policy-recipes](https://github.com/ahmetb/kubernetes-network-policy-recipes)
* [Kuryr](https://github.com/openstack/kuryr-kubernetes)
* [Linen](https://github.com/John-Lin/linen-cni)
* [Multus-cni](https://github.com/Intel-Corp/multus-cni) -在cni下多宿主
* [Network-Controller](https://github.com/linkernetworks/network-controller) -打开vSwitch，与Kubernetes Pod关联的多个网络接口
* [NSX-T](https://www.vmware.com/products/nsx/cloud-native-apps.html) -支持负载平衡和分布式防火墙的CNI插件.
* [Nuage](https://github.com/nuagenetworks/nuage-kubernetes)
* [OpenContrail](https://github.com/Juniper/contrail-kubernetes)
* [OpenVSwitch](http://openvswitch.org/)
* [Romana](http://romana.io/)
* [Weave Net](http://www.weave.works/docs/net/latest/kubernetes/kube-addon/)
* [Submariner: Cross-Cluster Network Connectivity for Kubernetes](https://submariner.io) -Submariner支持在Prem或云中的不同Kubernetes集群中的Pod之间进行直接联网.

## Service mesh

* [Consul](https://www.consul.io/docs/platform/k8s/index.html)
* [Envoy](https://www.envoyproxy.io/)
* [Istio](http://istio.io/)
* [Linkerd](http://linkerd.io/getting-started/k8s/)
* [Weave Mesh](https://github.com/weaveworks/mesh)
* [Maesh: Simpler Service Mesh](https://github.com/containous/maesh) -Maesh是直接，易于配置且非侵入式的服务网格，可对任何Kubernetes集群内部的流量进行可视化和管理.
* [Kuma: The Universal Service Mesh](https://github.com/kong/kuma) -构建，保护和观察您的现代服务网格.

## RPC

* [gRPC](http://grpc.io)


## Secret generation and management

* [CyberArk Conjur Kubernetes Authenticator](https://developer.conjur.net/reference/integrations/kubernetesopenshift.html) -使用Cyber​​Ark Conjur保护Kubernetes部署的应用程序
* [k8sec](https://github.com/dtan4/k8sec)
* [Kamus](https://github.com/Soluto/kamus) -秘密加密/解密解决方案的GitOps，零信任解决方案.
* [kube-lego](https://github.com/jetstack/kube-lego)
* [kubernetes-vault](https://github.com/Boostport/kubernetes-vault)
* [kubesec](https://github.com/shyiko/kubesec) -安全秘密管理
* [Sealed Secrets](https://github.com/bitnami-labs/sealed-secrets)
* [Secure GitOps Using Weave Cloud Deploy And Bitnami's Sealed Secrets](https://engineering.bitnami.com/articles/secure-gitops.html)
* [Vault auth plugin backend: Kubernetes](http://www.vaultproject.io/docs/auth/kubernetes.html)
* [Vault controller](https://github.com/kelseyhightower/vault-controller)

## Web applications

* [Kubernator](https://github.com/smpio/kubernator)
* [Kubernetes Resource Report](https://github.com/hjacobs/kube-resource-report) -报告Kubernetes集群和Pod资源请求与使用情况并生成静态HTML
* [Kubeapps](https://github.com/kubeapps/kubeapps) -基于Web的UI，用于在Kubernetes集群中部署和管理应用程序
* [Kubevious](https://github.com/kubevious/kubevious) -一个开源的UI，可以使Kubernetes的配置和状态变得明显且安全.
* [Polaris](https://github.com/reactiveops/polaris) -Kubernetes最佳实践的开源仪表板
* [Octant](https://github.com/vmware/octant) -基于Web的高度可扩展平台，供开发人员更好地了解Kubernetes集群的复杂性.

## Desktop applications

* [Kubernetic](https://kubernetic.com/)
* [Kube Forwarder](http://kube-forwarder.pixelpoint.io) –一个开源的Kubernetes端口转发管理器
* [Kontena Lens](https://github.com/kontena/lens) -Kubernetes的终极仪表板.

## Mobile applications

* [Cabin](https://github.com/bitnami/cabin)
* [Cockpit](http://cockpit-project.org/guide/latest/feature-kubernetes.html)

## API/CLI adaptors

* [awesome-kubectl-plugins](https://github.com/ishantanu/awesome-kubectl-plugins) -kubectl插件的精选列表.
* [click](https://github.com/databricks/click) -专注于CLI的REPL，用于与Kubernetes对象快速交互.
* [Ksql](https://github.com/brendandburns/ksql)
* [kube-prompt](https://github.com/c-bata/kube-prompt) -使用Go-Prompt构建的交互式kubernetes客户端.
* [kube-ps1](https://github.com/jonmosco/kube-ps1) -Kubernetes提示bash和zsh的帮助程序.
* [Kube-shell](https://github.com/cloudnativelabs/kube-shell) -用于Kubernetes CLI的集成外壳
* [kube-tmux](https://github.com/jonmosco/kube-tmux) -Kubernetes tmux插件显示当前上下文和名称空间
* [Kubectl Aliases](https://github.com/ahmetb/kubectl-aliases) -Kubectl的别名
* [kubectl-plugins](https://github.com/jordanwilson230/kubectl-plugins)  -一个kubectl插件集合，处理从简单的上下文切换到以任何用户（包括root）通过exec连接到容器的所有操作.  针对GKE用户量身定制.
* [kubectl-trace](https://github.com/iovisor/kubectl-trace) -使用此kubectl插件在您的kubernetes集群上调度bpftrace程序
* [kubectld](https://github.com/rancher/kubectld)
* [kubectx](https://github.com/ahmetb/kubectx) -在kubectl上的集群之间切换
* [Kubefuse](http://opencredo.com/introducing-kubefuse-file-system-kubernetes/)
* [kubens](https://github.com/ahmetb/kubectx) -在kubectl上的命名空间之间切换
* [kubensx](https://github.com/shyiko/kubensx) -Kubernetes的更简单的集群/用户/命名空间切换（具有交互模式和通配符/模糊匹配）.
* [kubeplay](https://github.com/errordeveloper/kubeplay)
* [Kubesh](https://github.com/projectodd/kubernetes/blob/kubesh/cmd/kubesh/README.md) -解决kubectl
* [Kui](https://github.com/IBM/kui) - Hybrid CLI/GUI alternative to kubectl
* [StackStorm](https://github.com/StackStorm/st2)
* [stern](https://github.com/wercker/stern) -多荚和集装箱原木尾矿
* [Vikube](https://github.com/c9s/vikube.vim) -Vim中来自Vim的Kubernetes操作
* [K9s](https://github.com/derailed/k9s) -Kubernetes CLI以时尚的方式管理您的集群！
* [tubectl](https://github.com/reconquest/tubekit) -具有模式匹配的类固醇的Kubernetes CLI
* [webkubectl](https://github.com/webkubectl/webkubectl) -基于Web的工具可帮助您管理kubernetes凭据并在Web浏览器中运行kubectl命令.
* [kubectl-neat](https://github.com/itaysk/kubectl-neat) -清理Kuberntes yaml和json输出
* [Kubie](https://github.com/sbstp/kubie) -即时修改脚本中的kubectx，kubens和k的替代

## Application deployment orchestration

* [AppController](https://github.com/Mirantis/k8s-AppController)
* [Brigade](https://github.com/Azure/brigade) -使用JavaScript的基于事件的脚本
* [Deployment manager](https://cloud.google.com/deployment-manager/)
* [ElasticKube](https://elasticbox.com/kubernetes)
* [Gitkube](https://github.com/hasura/gitkube/) -使用`git push`在Kubernetes上构建和部署docker镜像.
* [IBM UrbanCode](https://developer.ibm.com/urbancode/plugin/kubernetes/)
* [Kb8or](https://github.com/UKHomeOffice/kb8or)
* [Nulecule](https://github.com/projectatomic/nulecule)
* [Psykube](https://github.com/commercialtribe/psykube)
* [Skaffold](https://github.com/GoogleCloudPlatform/skaffold) -命令行工具，可促进Kubernetes应用程序的持续开发.
* [kubedog](https://github.com/flant/kubedog) -Kubedog是一个库和cli实用程序，它允许监视和跟踪CI / CD部署管道中的kubernetes资源.
* [kapp](https://github.com/k14s/kapp) -专注于“ Kubernetes应用程序”概念的简单部署工具-一组带有相同标签的资源

## Configuration

* [Ansible](https://docs.ansible.com/ansible/latest/modules/k8s_module.html)
* [cdk8s](https://cdk8s.io) -使用熟悉的编程语言定义Kubernetes应用和可重用组件
* [Chef](http://supermarket.chef.io/cookbooks/kubernetes)
* [Habitat](http://www.habitat.sh/docs/best-practices/#kubernetes)
* [Jsonnet](https://github.com/google/jsonnet/tree/master/case_studies/kubernetes)
* [K8comp](https://github.com/cststack/k8comp)
* [kapitan](https://github.com/deepmind/kapitan) - Manage complex deployments using jsonnet and jinja2
* [kenv](https://github.com/thisendout/kenv)
* [Kompose](https://github.com/kubernetes/kompose)
* [Konfd](https://github.com/kelseyhightower/konfd)
* [Ktmpl](https://github.com/jimmycuadra/ktmpl)
* [kubecfg](https://github.com/bitnami/kubecfg) -将jsonnet和kubectl结合使用，可以轻松覆盖系统声明系统
* [kubediff](https://github.com/weaveworks/kubediff)
* [kubegen](https://github.com/errordeveloper/kubegen)
* [kustomize](https://github.com/kubernetes-sigs/kustomize) -使用部分规格进行定制
* [Pulumi](https://www.pulumi.com/kubernetes/) -为针对本地集群和主要云供应商的托管服务的k8s部署提供一个SDK.
* [Puppet](http://forge.puppet.com/garethr/kubernetes/readme)
* [Cue](https://cue.googlesource.com/cue/+/HEAD/doc/tutorial/kubernetes/README.md)  -一种数据约束语言，旨在简化涉及定义​​和使用数据的任务.  Cue是JSON的超集
* [ytt](https://github.com/k14s/ytt) -适用于YAML结构的YAML模板工具，使您可以专注于数据，而不是如何正确地对其进行转义.
* [kosko](https://github.com/tommy351/kosko) -用JavaScript编写Kubernetes清单，并根据Kubernetes OpenAPI定义进行验证.
* [MicroConfig](https://microconfig.io)  -出色的微服务配置管理工具.  可与应用程序配置，头盔值，kubernetes资源等配合使用.

## Security
* [kubiscan](https://github.com/cyberark/KubiScan) -扫描Kubernetes集群中有风险的Pod和RBAC权限的工具
* [kubeletctl](https://github.com/cyberark/kubeletctl) -具有高级功能的kubelet客户端，例如扫描易受RCE影响​​的吊舱
* [Aquasec](http://blog.aquasec.com/topic/kubernetes)
* [Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) -使用AWS IAM凭证对Kubernetes集群进行身份验证的工具
* [Calico Network Policy (from Tigera)](https://docs.projectcalico.org/master/introduction/) -广泛采用的开源实现，统一了Kubernetes网络策略和Istio应用程序策略.
* [Deepfence Enterprise](https://deepfence.io) -用于kubernetes，虚拟机和无服务器的完整生命周期Cloud Native Workload Protection平台.
* [Deepfence Threat Mapper](https://github.com/deepfence/ThreatMapper) -强大的运行时漏洞扫描程序，适用于kubernetes，虚拟机和无服务器.
* [Dex](https://github.com/dexidp/dex) -Kubernetes的OpenID和OAuth
* [Guard](https://github.com/appscode/guard) -Authenticaton Webhook服务器，支持作为身份提供者的Github，Gitlab，Google，Azure和LDAP（AD）.
* [kiam](https://github.com/uswitch/kiam) -允许群集用户将AWS IAM角色与Pod相关联.
* [kube-bench](https://github.com/aquasecurity/kube-bench) -Kubernetes Security Bench for Go是一个Go应用程序，可根据安全最佳实践检查是否已部署Kubernetes.
* [kube-hunter](https://github.com/aquasecurity/kube-hunter) -寻找Kubernetes集群中的安全漏洞.
* [kube-psp-advisor](https://github.com/sysdiglabs/kube-psp-advisor) -帮助建立自适应且细粒度的Pod安全策略.
* [kube2iam](https://github.com/jtblin/kube2iam) -为在Kubernetes上运行的Pod提供不同的AWS IAM角色
* [kubeaudit](https://github.com/Shopify/kubeaudit) -帮助您根据常见的安全控制审核Kubernetes集群
* [Kubesec.io](http://kubesec.io/)
* [Pomerium](http://www.pomerium.io/) -受BeyondCorp启发的零信任身份识别访问代理.
* [Rakkess](https://github.com/corneliusweig/rakkess) -Kubectl插件，显示所有可用资源的访问矩阵.
* [Sysdig Falco](https://sysdig.com/opensource/falco/)
* [Sysdig Secure](http://www.sysdig.com/product/secure)
* [Tigera Secure Cloud Edition](https://www.tigera.io/tigera-secure-ce/)
* [Tigera Secure Enterprise Edition](https://www.tigera.io/tigera-secure-ee/)
* [Trireme](http://github.com/aporeto-inc/trireme-kubernetes)
* [Twistlock](http://www.twistlock.com/)

## Load balancing

* [Avi Networks - Software Load Balancer | Intelligent WAF | Elastic Service Mesh](https://avinetworks.com/)
* [AWS ALB Ingress Controller](https://github.com/kubernetes-sigs/aws-alb-ingress-controller)
* [Cloudflare Warp Ingress](https://github.com/cloudflare/cloudflare-ingress-controller)
* [Contour](https://github.com/projectcontour/contour) -Lyft的Envoy代理的Kubernetes入口控制器
* [F5 Big IP Controller](https://github.com/F5Networks/k8s-bigip-ctlr)
* [Gimbal](https://github.com/vmware-tanzu/gimbal) -能够将流量路由到多个Kubernetes和OpenStack集群的平台
* [Gloo - Envoy-based API gateway and ingress controller](https://github.com/solo-io/gloo)
* [HAProxy Ingress](https://github.com/jcmoraisjr/haproxy-ingress)
* [Linode NodeBalancer Ingress](https://github.com/linode/linode-cloud-controller-manager)
* [MetalLB](https://metallb.universe.tf/) -使用标准路由协议为裸机Kubernetes集群实现负载均衡器.
* [Porter](https://github.com/kubesphere/porter)  -为裸机Kubernetes集群设计的负载均衡器.  它由物理交换机实现，并使用BGP和ECMP来实现最佳性能和HA.
* [NGINX Ingress Controller](https://github.com/kubernetes/ingress-nginx)
* [Nginx Plus](http://www.nginx.com/blog/load-balancing-kubernetes-services-nginx-plus/)
* [Skipper](https://github.com/zalando/skipper) -用于服务组合的HTTP路由器和反向代理，包括诸如Kubernetes Ingress之类的用例
* [Traefik](https://containo.us/traefik/)
* [Voyager - Secure HAProxy based Ingress Controller](https://github.com/appscode/voyager)
* [Yggdrasil - Envoy Control Plane for Kubernetes Multi-cluster Ingress](https://github.com/uswitch/yggdrasil)

## Big Data

* [Kube-Yarn](https://github.com/Comcast/kube-yarn)
* [Spark](https://github.com/kubernetes/examples/tree/master/staging/spark)

## Machine Learning

* [FfDL](https://github.com/IBM/FfDL) -深度学习平台，在Kubernetes上提供TensorFlow，Caffe，PyTorch等作为服务
* [Fiber](https://github.com/uber/fiber) -Kubernetes上的AI分布式计算库.
* [kubeflow](https://github.com/google/kubeflow) -Kubernetes的机器学习工具包.
* [mxnet-operator](https://github.com/deepinsight/mxnet-operator) -Kubernetes上的ML / MXNet工具.
* [Polyaxon](https://github.com/polyaxon/polyaxon) -在kubernetes上可重现的机器学习和深度学习的开源平台
* [seldon-core](https://github.com/SeldonIO/seldon-core) -在Kubernetes上部署机器学习模型的开源框架
* [TensorFlow k8s](https://github.com/tensorflow/k8s)

## Service Discovery

* [Consul](http://consul.io)
  * [Kelsey Hightower Consul](https://github.com/kelseyhightower/consul-on-kubernetes)
  * [Bridge between Kubernetes and Consul](https://github.com/Beldur/kube2consul)

## Operating System

* [Bottlerocket](https://github.com/bottlerocket-os/bottlerocket)
* [Fedora CoreOS](https://getfedora.org/en/coreos/)
* [Flatcar Container Linux](https://www.flatcar-linux.org/)
* [GCI](https://cloud.google.com/container-optimized-os/docs/)
* [k3OS](https://github.com/rancher/k3os)
* [LinuxKit](https://github.com/linuxkit/kubernetes)
* [Talos](https://github.com/talos-systems/talos)
* [RancherOS](https://rancher.com/rancher-os) -从容器构建的轻量级安全Linux发行版，可以很好地运行容器.

## YAML/JSON Config

* [cdk8s](https://cdk8s.io) -使用熟悉的编程语言定义Kubernetes应用和可重用组件
* [kompose](https://github.com/kubernetes/kompose)
* [ksonnet-lib](https://github.com/ksonnet/ksonnet-lib)
* [kube-libsonnet](https://github.com/bitnami-labs/kube-libsonnet/blob/master/kube.libsonnet) -用于Jsonnet / Kubecfg的Kubernetes对象的通用库，具有对象到数组的映射，可以轻松进行覆盖.
* [kubegen](https://github.com/errordeveloper/kubegen)
* [kubeval](https://github.com/garethr/kubeval)

## Static Analysis

* [kube-score](https://github.com/zegl/kube-score) -Kubernetes对象分析并提出了改进可靠性和安全性的建议
* [popeye](https://github.com/derailed/popeye) -Kubernetes集群资源清理工具

## Tuning

* [Ktune](https://github.com/skippbox/ktune)

## Backup and Disaster Recovery

* [Velero](https://github.com/vmware-tanzu/velero)  -用于管理Kubernetes集群的备份和还原的实用程序.  前Heptio方舟.
* [K8up](https://github.com/vshn/k8up) -基于Restic的Kubernetes和OpenShift Backup Operator
* [burry.sh](https://github.com/mhausenblas/burry.sh) -为etcd，zookeeper和领事提供Cloud Native备份和恢复
* [kube-backup](https://github.com/pieterlange/kube-backup) -将kubernetes状态同步到git.
* [Stash](https://github.com/stashed/stash) -Stash是Kubernetes运营商，它使用Restic或Kubernetes CSI驱动程序VolumeSnapshotter备份您的卷和kubernetes状态.

## Policy Management

* [Kyverno](https://github.com/nirmata/kyverno) -Kubernetes本地策略管理

## Plugins

* [Krew - Plugin Manager](https://github.com/kubernetes-sigs/krew/)
* [Kboom](https://github.com/mhausenblas/kboom)
* [View-utilization](https://github.com/etopeter/kubectl-view-utilization)

## Debug

* [Kubectl-Debug](https://github.com/aylei/kubectl-debug)

## Benchmark Tools

* [Kubestone](https://github.com/xridge/kubestone/)

## Chaos Engineering

* [Chaosblade](https://github.com/chaosblade-io/chaosblade)：一个易于使用且功能强大的混沌工程实验工具包.
* [Chaos Mesh](https://github.com/pingcap/chaos-mesh)：一个云原生的混沌工程平台，可在Kubernetes环境中协调混乱. 
* [chaoskube](https://github.com/linki/chaoskube)：`chaoskube`会定期杀死Kubernetes集群中的随机Pod.
* [Chaos Toolkit](https://github.com/chaostoolkit/chaostoolkit)：一个用于混沌工程的开放API.
* [KubeInvaders](https://github.com/lucky-sideburn/KubeInvaders)  -用于Kubernetes集群的Gamified Chaos工程工具.  就像太空侵略者，但外星飞船是豆荚.
* [Litmus](https://github.com/litmuschaos/litmus)：以kubernetes本机方式进行混沌工程的工具集.

树莓派
=======================================================================

*在Kubernetes和Raspberry Pi上使用的一些很棒的发现和实验.*
* 查看 [Kubecloud](http://kubecloud.io)
* [Setting up a Kubernetes on ARM cluster](http://kubecloud.io/kubernetes-on-arm-cluster/)
* [Setup Kubernetes on a Raspberry Pi Cluster easily the official way!](https://blog.hypriot.com/post/setup-kubernetes-raspberry-pi-cluster/) 通过 [Mathias Renner and Lucas Käldström](https://blog.hypriot.com/crew/)
* [How to Build a Kubernetes Cluster with ARM Raspberry Pi then run .NET Core on OpenFaas](https://www.hanselman.com/blog/HowToBuildAKubernetesClusterWithARMRaspberryPiThenRunNETCoreOnOpenFaas.aspx) 通过 [Scott Hanselman](https://twitter.com/shanselman)
* [Building a microcloud with a few Raspberry Pis and Kubernetes](https://mirailabs.io/blog/building-a-microcloud/) 通过 [Preetam D'Souza](https://preetam.io/)
* [Anatomy of my Kubernetes Cluster](https://ttt.io/anatomy-of-my-kubernetes-cluster)

Books
=======================================================================

*书面或印刷的作品，由沿着一面胶合或缝合在一起并装订在封面中的页面组成
向我们提供信息*

* [Cloud Native DevOps with Kubernetes](http://shop.oreilly.com/product/0636920175131.do) 通过 [John Arundel](https://twitter.com/bitfield), [Justin Domingus](https://justindomingus.com/) ([blog](https://cloudnativedevopsblog.com))
* [Cloud Native Infrastructure](http://cnibook.info) 通过 [Justin Garrison](https://justingarrison.com) 和 [Kris Nòva](https://www.nivenly.com/)
* [DevOps with Kubernetes](https://www.packtpub.com/virtualization-and-cloud/devops-kubernetes) by Hideto Saito, Hui-Chuan Chloe Lee, Cheng-Yang Wu
* [Docker and Kubernetes Under the Hood](http://item.jd.com/11757034.html) （中文） [Harry Zhang](https://twitter.com/resouer)，孙建波和ZJU SEL实验室
* [Docker in Action, Second Edition](https://www.manning.com/books/docker-in-action-second-edition) 杰夫·尼克洛夫（Jeff Nickoloff）和斯蒂芬·库恩兹利（Stephen Kuenzli）
* [Docker in Practice, Second Edition](https://www.manning.com/books/docker-in-practice-second-edition) 通过 [Ian Miell](https://twitter.com/ianmiell) & [Aidan Hobson Sayers](https://twitter.com/aidanhs)
* [Getting Started with Kubernetes](http://shop.oreilly.com/product/9781784394035.do) 乔纳森·拜尔（Jonathan Baier）
* [Golden Guide to Kubernetes Application Development](https://matthewpalmer.net/kubernetes-app-developer) 马修·帕尔默（Matthew Palmer）
* [Kubernetes Book](https://github.com/Leverege/kubernetes-book) （开源书籍）由Leverege Developers开发
* [Kubernetes Cookbook - Second Edition](https://www.packtpub.com/virtualization-and-cloud/kubernetes-cookbook-second-edition) 斋藤秀人（Hideto Saito），许惠传（Choi Lee），许克J（Ke-Jou Carol Hsu）
* [Kubernetes Design Patterns and Extensions](https://www.amazon.com/dp/B07HSZHRHZ) 通过 [Onur Yilmaz](https://github.com/onuryilmaz)
* [Kubernetes Handbook](https://github.com/feiskyer/kubernetes-handbook) （中文的开源书籍）作者： [Pengfei Ni](https://github.com/feiskyer)
* [Kubernetes Handbook](https://github.com/rootsongjc/kubernetes-handbook) （中文的开源书籍）作者： [Jimmy Song](https://github.com/rootsongjc)
* [Kubernetes in Action](http://www.manning.com/books/kubernetes-in-action) 通过 [Marko Lukša](https://twitter.com/markoluksa)
* [Kubernetes: Scheduling the Future at Cloud Scale](http://www.oreilly.com/webops-perf/free/kubernetes.csp) 通过 [Dave K. Rensin](http://www.linkedin.com/in/drensin)
* [Kubernetes: Up and Running](http://shop.oreilly.com/product/0636920223788.do) 通过 [Kelsey Hightower](https://twitter.com/kelseyhightower)
* [Mastering Kubernetes](https://www.amazon.com/Mastering-Kubernetes-Gigi-Sayfan/dp/1786461005) 通过 [Gigi Sayfan](https://github.com/the-gigi)
* [OpenShift in Action](http://www.manning.com/books/openshift-in-action) 通过 [Jamie Duncan](https://twitter.com/rh_jduncan) & [John Osborne](https://www.linkedin.com/in/johnfosborneiii/)
* [Playing with Java Microservices on Kubernetes and OpenShift](https://leanpub.com/playing-with-java-microservices-on-k8s-and-ocp) 通过 [Nebrass Lamouchi](https://fr.linkedin.com/in/nebrass)
* [The DevOps 2.3 Toolkit: Kubernetes](https://leanpub.com/the-devops-2-3-toolkit) 通过 [Viktor Farcic](https://twitter.com/vfarcic)
* [Learn Azure in a Month of Lunches, Second Edition](https://www.manning.com/books/learn-azure-in-a-month-of-lunches-second-edition) 通过 [Iain Foulds](https://twitter.com/fouldsy)
* [Learn Docker in a Month of Lunches](https://www.manning.com/books/learn-docker-in-a-month-of-lunches) 通过 [Elton Stoneman](https://twitter.com/EltonStoneman)

Certifications
=======================================================================

*一些可证明自己是Kubernetes专家的可信认证的列表*

* [Certified Kubernetes Administrator (CKA)](https://www.cncf.io/certification/cka/)
* [Certified Kubernetes Application Developer (CKAD)](https://www.cncf.io/certification/ckad/)
* [Practice Mock Tests](https://github.com/ShubhamTatvamasi/kubernetes-practice-tests)

幻灯片演示
=======================================================================

*幻灯片是使用PowerPoint或OpenOffice Impress等软件创建的演示文稿的一页.

* [A brief study on Kubernetes and its components](http://www.slideshare.net/ramitsurana/a-brief-study-on-kubernetes-and-its-components) 通过 [Ramit Surana](https://www.twitter.com/ramitsurana)
* [Achieving CI/CD with Kubernetes](http://www.slideshare.net/ramitsurana/achieving-cicd-with-kubernetes) 通过 [Ramit Surana](https://twitter.com/ramitsurana)
* [An Introduction to Kubernetes](http://www.slideshare.net/imesh/an-introduction-to-kubernetes) 通过 [Imesh Gunaratne](https://www.linkedin.com/in/imesh)
* [Architecture Overview](http://www.slideshare.net/enakai/architecture-overview-kubernetes-with-red-hat-enterprise-linux-71) 通过 [enakai00](https://twitter.com/enakai00/)
* [Cluster management with Kubernetes](http://www.slideshare.net/SatnamSingh67/2015-0605-cluster-management-with-kubernetes) 萨特南·辛格（Satnam Singh）
* [Kubernetes and CoreOS @ Athens Docker meetup](http://www.slideshare.net/mistio/kubernetes-and-coreos-athens-docker-meetup) 通过 [Mist.io](https://twitter.com/mist_io)
* [Kubernetes Scaling SIG (K8Scale)](http://www.slideshare.net/kubecon/kubernetes-scaling-sig-k8scale) 通过 [Bob Wise](https://twitter.com/countspongebob)
* [Moving to Kubernetes - Tales from SoundCloud](http://www.slideshare.net/dagrobie/moving-to-kubernetes-tales-from-soundcloud) 通过 [Tobias Schmidt](https://twitter.com/dagrobie)
* [Musings on Mesos: Docker, Kubernetes, and Beyond.](http://www.slideshare.net/timothysc/apache-coneu) 通过 [Timothy St. Clair](http://timothysc.github.io/)
* [Package your Java EE Application using Docker and Kubernetes](http://www.slideshare.net/arungupta1/package-your-java-ee-application-using-docker-and-kubernetes) 通过 [Arun Gupta](https://twitter.com/arungupta)
* [Scaling Jenkins with Docker and Kubernetes](http://www.slideshare.net/carlossg/scaling-jenkins-with-docker-and-kubernetes) 通过 [Carlos Sanchez](https://www.twitter.com/csanchez)
* [The Top 5 Metrics to Monitor in Kubernetes](http://www.slideshare.net/Sysdig/the-top-5-kubernetes-metrics-to-monitor)
* [Zero downtime-java-deployments-with-docker-and-kubernetes](http://www.slideshare.net/ArjanSchaaf/zero-downtimejavadeploymentswithdockerandkubernetes) 通过 [Arjan Schaaf](https://www.linkedin.com/in/arjanschaaf)

Podcasts
=======================================================================

* [Kubernetes Podcast from Google](https://kubernetespodcast.com/)：每周的新闻和访谈显示来自Kubernetes社区的见解.
* [Electro Monkeys](https://electro-monkeys.fr/)：关于Kubernetes和Cloud Native Technologies的每周法语播客.

Videos
=======================================================================

*以数字或录像带形式录制的动态视觉图像的记录.


### Main Account

* [Google Developers](https://www.youtube.com/channel/UC_x5XG1OV2P6uZZ5FSM9Ttw)
* [Kubernetes](https://www.youtube.com/channel/UCZ2bu0qutTOM0tHYa_jkIwg)


### Other Useful Videos

* [Compromising Kubernetes Cluster 通过 Exploiting RBAC Permissions](https://www.youtube.com/watch?v=1LMo0CftVC4) 通过 [Eviatar Gerzi](https://twitter.com/g3rzi)
* [A Technical Overview of Kubernetes](https://www.youtube.com/watch?v=WwBdNXt6wO4) 通过 [Bredan Burns](https://twitter.com/brendandburns)
* [Alpaca Kubernetes on AWS](https://www.youtube.com/watch?v=jLk1pkc7kv4) 通过 [Adrien Lemaire](https://twitter.com/fandekasp)
* [Arun Gupta: Package your Java applications using Docker and Kubernetes](https://www.youtube.com/watch?v=R2nj1vRjLwE) 通过 [Arun Gupta](https://twitter.com/arungupta)
* [Container Orchestration using CoreOS and Kubernetes](https://www.youtube.com/watch?v=tA8XNVPZM2w) 通过 [Kelsey Hightower](https://twitter.com/kelseyhightower)
* [DevNation 2015 - Paul Bakker - Kubernetes: Beyond the basics](https://youtu.be/MuazGHiiGmA) 通过 [Paul Bakker](https://twitter.com/pbakker)
* [Docker Containers and Kubernetes with Brian Dorsey](https://www.youtube.com/watch?v=Fcb4aoSAZ98) 通过 [Brian Dorsey](https://twitter.com/briandorsey)
* [Google I/O 2014 - Containerizing the Cloud with Docker on Google Cloud Platform](https://www.youtube.com/watch?v=tsk0pWf4ipw) 通过 [Google Developers](https://www.youtube.com/channel/UC_x5XG1OV2P6uZZ5FSM9Ttw)
* [Kubernetes-Defined Monitoring](https://www.youtube.com/watch?v=ncSn3_9bfIQ)
* [Kubernetes: The Journey So Far - Greg DeMichillie](https://youtu.be/6a2Nirr8cI0) 通过 [Greg DeMichillie](https://twitter.com/gregde)
* [Managing Containers at Scale with CoreOS and Kubernetes](https://www.youtube.com/watch?v=pozC9rBvAIs) 通过 [Kelsey Hightower](https://twitter.com/kelseyhightower)
* [Shanghai '18: KubeCon + CloudNativeCon](https://www.youtube.com/playlist?list=PLj6h78yzYM2OK087kzLgc4jTPVbZjuNfs)
* [Testing Distributed Software on Kubernetes with PowerfulSeal at Kubecon 2017 Austin](https://youtu.be/00BMn0UjsG4) 通过 [Mikolaj Pawlikowski](https://twitter.com/mikopawlikowski)

### CI/CD Videos

- [Automating CI/CD on Kubernetes 与 Jenkins X](https://www.youtube.com/watch?v=BF3MhFjvBTU) 通过 [James Strachan](https://twitter.com/jstrachan) 使用 [Jenkins X](https://jenkins-x.io/) 与 [these slides](https://docs.google.com/presentation/d/1hwt2lFh3cCeFdP4xoT_stMPs0nh2xVZUtze6o79WfXc/edit#slide=id.p)

有趣的Twitter帐户
=======================================================================

* Twitter速度快，易于沟通，并且是充分利用品牌或企业的宝贵社交渠道，如果您充分利用它，通过关注这些新闻聚合器，滚动新闻频道和公司，您可以了解内部信息早在主流新闻媒体上抢走一个故事.*


* [DevOps Summit](https://twitter.com/DevOpsSummit)
* [Engine Yard](https://twitter.com/engineyard)
* [Google Cloud Platform](https://twitter.com/googlecloud)
* [Kismatic](https://twitter.com/kismatic)
* [Kube Con](https://twitter.com/kubecon_)
* [KubeFacts](https://twitter.com/kubefacts)
* [Kubernetes](https://twitter.com/kubernetesio)
* [KubeWeekly](https://twitter.com/kubeweekly)
* [Learnk8s](https://twitter.com/learnk8s)
* [Skippbox](https://twitter.com/skippbox) -被 [Bitnami](https://bitnami.com/news/press-releases/bitnami-acquires-skippbox)
* [Sysdig](https://twitter.com/sysdig)


神奇的人
=======================================================================

* [Ahmet Alp Balkan](https://twitter.com/ahmetb)，Google和Google Kubernetes Engine的软件工程师
* [Aparna Sinha](https://twitter.com/apbhatnagar)，小组产品经理-Google的Kubernetes
* [Arun Gupta](https://twitter.com/arungupta)，Amazon Web Services的首席开源技术专家
* [Brandon Philips](https://twitter.com/BrandonPhilips)，首席技术官
* [Brendan Burns](https://twitter.com/brendandburns)微软合伙人架构师
* [Brian Grant](https://github.com/bgrant0607)，Google首席工程师，Kubernetes首席架构师
* [Carlos Sanchez](https://www.twitter.com/csanchez)，CloudBees高级软件工程师
* [Chris Aniszczyk](https://www.twitter.com/cra)，云原生计算基金会首席运营官
* [Eric Tune](https://twitter.com/eric_tune)，Google高级工程师
* [Ihor Dvoretskyi](https://twitter.com/idvoretskyi)，云原生计算基金会的开发倡导者
* [Jessie Frazzelle](https://github.com/jessfraz)，Microsoft的云开发倡导者
* [Joe Beda](https://twitter.com/jbeda) ，VMware首席工程师.  Heptio的前创始人兼CTO
* [Joseph Jacks](https://twitter.com/asynchio)，KubeCon的创始人Kismatic（Kubernetes的第一家企业），OSS Capital的创始人，Open Core Summit，COSS Media，COSS Accelerator
* [Kelsey Hightower](https://twitter.com/kelseyhightower)，Google的开发人员助理
* [Kris Nova](https://github.com/kris-nova)，Kubicorn的创造者
* [Michelle Noorali](https://www.twitter.com/michellenoorali)，微软软件工程师
* [Paris Pittman](https://www.twitter.com/ParisInBmore)，开发人员关系经理-Google的Kubernetes
* [Patrick Reilly](https://twitter.com/preillyme)，思科CTO办公室，思科CNCF董事会成员
* [Tim Hockin](https://twitter.com/thockin)，Google高级软件工程师/工程经理

聚会小组
=======================================================================

*与世界各地的kubernauts建立联系的绝佳方式*

* [Amsterdam](https://www.meetup.com/Amsterdam-Kubernetes-Meetup/)
* [Amsterdam #2](https://www.meetup.com/Kubernetes-Addicts-Support-Group)
* [Atlanta](https://www.meetup.com/Kubernetes-Atlanta-Meetup/)
* [Bangalore](https://www.meetup.com/Bangalore-Kubernetes-Meetup)
* [Berlin](https://twitter.com/kubernetesber)
* [Boston](https://www.meetup.com/Boston-Kubernetes-Meetup)
* [Hamburg](https://www.meetup.com/Hamburg-Kubernetes-Meetup/)
* [Hong Kong](https://www.meetup.com/Kubernetes-Hong-Kong/)
* [London](https://www.meetup.com/Kubernetes-London/)
* [Munich](https://www.meetup.com/Munchen-Kubernetes-Meetup/)
* [New York](https://twitter.com/kubernetesnyc)
* [Nuremberg](https://www.meetup.com/Kubernetes-Nurnberg/)
* [Paris](https://twitter.com/kubernetesparis)
* [Pittsburgh](https://www.meetup.com/Pittsburgh-Kubernetes-Meetup)
* [Pune](https://www.meetup.com/Kubernetes-Pune/)
* [San Diego](https://twitter.com/kubernetesSD)
* [San Francisco](https://twitter.com/kubernetesSF)
* [Seattle](https://www.meetup.com/Seattle-Kubernetes-Meetup/)
* [Tunisia](https://www.meetup.com/Kubernetes-Cloud-Native-Tunisia/)
* [Worldwide](https://www.meetup.com/kubernauts/)

与Kubernetes连接
=======================================================================

* [Blog](http://blog.kubernetes.io/)
* [Community Q&A – The Office Hours](https://github.com/kubernetes/community/blob/master/events/office-hours.md)
* [Community](https://github.com/kubernetes/community)
* [Freenode](http://webchat.freenode.net/?channels=google-containers)
* [Mailing List (developer/contributor discussion)](https://groups.google.com/forum/#!forum/kubernetes-dev)
* [Mailing List (user discussion and Q&A)](https://groups.google.com/forum/#!forum/kubernetes-users)
* [Reddit](https://www.reddit.com/r/kubernetes/)
* [Slack](http://slack.k8s.io/)
* [Stackoverflow](http://stackoverflow.com/questions/tagged/kubernetes)
* [Twitter](https://twitter.com/kubernetesio)

Conferences
=======================================================================

*有些人必须去参加在kubernetes上的会议*

* [Container Camp](http://container.camp/)
* [ContainerDays](https://containerdays.io/)
* [Devoxx](http://devoxx.com)
* [Docker Con](http://dockercon.com)
* [GCP Next](http://cloudnext.withgoogle.com/)
* [Kubecon](http://events.linuxfoundation.org/events/kubecon)


Contributing
=======================================================================

欢迎捐款！

此列表刚刚起步，请做出贡献以使其变得超赞.

看看 [Contributing Guidelines](https://github.com/ramitsurana/awesome-kubernetes/blob/master/guidelines/CONTRIBUTING.md).


License
=======================================================================

<a rel="license" href="http://creativecommons.org/licenses/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc/4.0/88x31.png" /><br /> <a xmlns:cc="http://creativecommons.org" href="http://www.linkedin.com/in/ramitsurana" property="cc:attributionName" rel="cc:attributionURL">Ramit Surana的</a> <span xmlns:dct="http://purl.org/dc/terms/" href="http://purl.org/dc/dcmitype/InteractiveResource" property="dct:title" rel="dct:type">awesome-kubernetes</span>已获得<a rel="license" href="http://creativecommons.org/licenses/">知识共享署名-非商业4.0国际许可证的许可</a> .
