<div class="github-widget" data-repo="dnbard/awesome-knockout"></div>
## Awesome Knockout [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
一个精选的很棒的插件列表 [Knockout framework](http://knockoutjs.com/).

## Frameworks
- [Knockout](https://github.com/knockout/knockout) - Knockout 可以更轻松地使用 JavaScript 创建丰富的响应式 UI
- [Knockback](https://github.com/kmalakoff/knockback) - Knockback.js 为 Backbone.js 模型和集合提供 Knockout.js 魔法
- [Durandal](https://github.com/BlueSpire/Durandal/) - 一个用 JavaScript 编写的跨设备、跨平台的客户端框架，旨在构建单页应用程序
- [Falconjs](https://github.com/stoodder/falconjs) - 通过合并模型、集合和视图向 knockout.js 添加结构

## Integrations
- 查询[UI](https://github.com/madcapnmckay/Knockout-UI) - 基于 KnockoutJS 的丰富 UI 组件
- [Kendo](https://github.com/kendo-labs/knockout-kendo) - 一个为 Kendo UI 小部件创建一组健壮的 Knockout.js 绑定的项目
- [Bootstrap](https://github.com/billpull/knockout-bootstrap) - 为 twitter 引导程序对象（例如工具提示和弹出窗口）添加自定义绑定的插件
- [ASP.NET MVC](https://github.com/AndreyAkinshin/knockout-mvc) - 用于 ASP.NET MVC 的 Knockout.js 的强大功能
- [Rails](https://github.com/dnagir/knockout-rails) - 用于 Rails 的 KnockoutJS
- [Meteor](https://github.com/steveluscher/knockout.meteor) - 淘汰赛到流星桥

## Plugins and libraries
- [Mapping](https://github.com/SteveSanderson/knockout.mapping) - KnockoutJS 的对象映射插件
- [Validation](https://github.com/Knockout-Contrib/Knockout-Validation) - Knockout JS 的验证库
- [Sortable](https://github.com/rniemeyer/knockout-sortable) - 用于将 observableArrays 与 jQuery UI 可排序功能连接起来的 Knockout.js 绑定
- [Grid](https://github.com/Knockout-Contrib/KoGrid) - 用于 Knockout 的数据网格插件
- [External Template Engine](https://github.com/ifandelse/Knockout.js-External-Template-Engine) - 加载外部模板的 Knockout.js 的自定义模板引擎和模板源
- [Postbox](https://github.com/rniemeyer/knockout-postbox) - 发布/订阅独立视图模型和组件之间的解耦通信
- [Deferred Updates](https://github.com/mbest/knockout-deferred-updates) - 修改部分 Knockout 可观察/订阅系统以使用延迟更新的插件
- [Delegated Events](https://github.com/rniemeyer/knockout-delegatedEvents) - 简单灵活的插件来进行声明式事件委托
- [Projections](https://github.com/profiscience/ko-projections) - 将 lodash FP 可链接性添加到可观察数组
- [Viewmodel](https://github.com/coderenaissance/knockout.viewmodel) - 灵活的方式来创建一个淘汰赛视图模型
- [Observable Dictionary](https://github.com/jamesfoster/knockout.observableDictionary) - 可观察字典的实现
- [Model](https://github.com/thelinuxlich/knockout.model) - Knockout.js 实体的基本模型
- [Namespaces](https://github.com/hunterloftis/knockout.namespaces) - Knockout.js 的命名空间
- [Rest](https://github.com/frapontillo/knockout-rest) - 一个使用 RESTful 操作扩展 Knockout.js 对象的简单库
- [Local Storage](https://github.com/jimrhoskins/knockout.localStorage) - Knockout.js 的 LocalStorage 持久性
- [Router](https://github.com/profiscience/ko-component-router) - 单页应用程序的路由器

## Custom Bindings
- [Punches](https://github.com/mbest/knockout.punches) - 增强绑定语法的集合
- [Switch Case](https://github.com/mbest/knockout-switch-case) - 强大的控制流绑定
- [Repeat](https://github.com/mbest/knockout-repeat) - 重复绑定在许多情况下可以替代 foreach 并且更快更简单
- [Table](https://github.com/mbest/knockout-table) - 用于 Knockout 的表格绑定插件

## Components
- [Cart](https://github.com/robconery/knockout-cart) - 使用本地存储的简单的基于浏览器的购物车
- [Testing](https://github.com/profiscience/ko-component-tester) - 对 TDD + Knockout.js 有用的实用程序

## Examples
- [WebSockets](https://github.com/carlhoerberg/knockout-websocket-example) - 使用 WebSockets 和 Knockout 的实时协作网络应用程序示例
