<div class="github-widget" data-repo="francoism90/awesome-kde"></div>
## Awesome KDE [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/francoism90/awesome-kde/master/media/logo-kde-grey.svg?sanitize=true" align="right" width="144">](http://www.kde.org)

> A curated list of _awesome_ apps, extensions, modules, themes and tools for the KDE Desktop Environment.

[KDE](https://kde.org/) is a free software community dedicated to creating an open and user-friendly computing experience, offering an advanced graphical desktop, a wide variety of applications for communication, work, education and entertainment and a platform to easily build new applications upon.

> Items marked with 📌 (pushpin) are projects hosted on KDE's own infrastructure and developed by the KDE community.



---

## Applications

Tip: An overview of the most used KDE community apps are listed on the [official website](https://apps.kde.org/).

### Internet & Networking

- [Akregator](https://apps.kde.org/akregator/) - Enables you to follow news sites, blogs and other RSS/Atom-enabled websites 📌.
- [Falkon](https://www.falkon.org/) - QtWebEngine based cross-platform web browser 📌.
- [Firefox KDE](https://build.opensuse.org/package/show/mozilla:Factory/MozillaFirefox) - Standalone web browser from mozilla.org with OpenSUSE patch, integrate better with KDE.
- [GSConnect](https://extensions.gnome.org/extension/1319/gsconnect/) - A complete implementation of KDE Connect especially for GNOME Shell with Nautilus, Chrome and Firefox integration.
- [KDE Connect](https://kdeconnect.kde.org/) - A project to communicate across all your devices: receive your phone notifications on your desktop computer, control your desktop from your phone, etc 📌.
- [KGet](https://apps.kde.org/kget/) - A versatile and user-friendly download manager 📌.
- [KMail](https://apps.kde.org/kmail2/) - KMail is the email component of Kontact, the integrated personal information manager from KDE 📌.
- [KNetworkManager](https://userbase.kde.org/KNetworkManager) - A KDE client for the back end NetworkManager software 📌.
- [Konqueror](https://konqueror.org/) - Uses the KHTML rendering engine (and optionally Webkit) so it supports the latest web standards such as HTML5, JavaScript, CSS3, and others 📌.
- [Konversation](https://konversation.kde.org/) - A user-friendly Internet Relay Chat (IRC) client built on the KDE Platform 📌.
- [KRDC](https://apps.kde.org/krdc/) - A client application that allows you to view or control a desktop session on another machine that is running a compatible server (VNC & RDP) 📌.
- [KTorrent](https://apps.kde.org/ktorrent/) - A BitTorrent application which allows you to download files using the BitTorrent protocol 📌.
- [NeoChat](https://apps.kde.org/neochat/) - Matrix network client for KDE 📌.
- [Otter Browser](https://otter-browser.org/) - Otter Browser aims to recreate the best aspects of the classic Opera (12.x) UI using Qt5.
- [Plasma-browser-integration](https://userbase.kde.org/Plasma-browser-integration) - A suite of new features which make [Firefox](https://addons.mozilla.org/en-US/firefox/addon/plasma-integration/), [Chrome](https://chrome.google.com/webstore/detail/plasma-integration/cimiefiiaegbelhefglklhhakcgmhkai) and Chromium-based browsers work with your desktop 📌.
- [qBittorrent](https://www.qbittorrent.org/) - An advanced BitTorrent client programmed in C++, based on Qt toolkit and libtorrent-rasterbar.
- [Qt WebBrowser](http://doc.qt.io/QtWebBrowser/) - Qt WebBrowser is a browser for embedded devices developed using the capabilities of Qt and Qt WebEngine.
- [Smb4K](https://apps.kde.org/en/smb4k) - Advanced Network Neighborhood Browser and Samba Share Mounting Utility 📌.
- [Tokodon](https://apps.kde.org/pt-br/tokodon/) - Tokodon is a Mastodon client. It allows you to interact with the Fediverse community 📌. 

### Graphics & Imaging

- [digiKam](https://www.digikam.org/) - Professional Photo Management with the Power of Open Source 📌.
- [Gwenview](https://apps.kde.org/gwenview/) - A fast and easy to use image viewer by KDE 📌.
- [KColorChooser](https://apps.kde.org/kcolorchooser/) - A simple application to select the color from the screen or from a pallete 📌.
- [KolourPaint](https://apps.kde.org/kolourpaint/) - A simple painting program to quickly create raster images. It is useful as a touch-up tool and simple image editing tasks 📌.
- [Krita](https://apps.kde.org/krita/) - Painting tool designed for concept artists, illustrators, matte and texture artists, and the VFX industry 📌.
- [Okular](https://apps.kde.org/okular/) - A universal document viewer 📌.
- [Spectacle](https://apps.kde.org/spectacle/) - An application for capturing desktop screenshots 📌.

### Multimedia

- [Amarok](https://amarok.kde.org/) - Amarok is a powerful music player for Linux, Unix and Windows with an intuitive interface 📌.
- [Elisa](https://elisa.kde.org/) - A music player developed by the KDE community that strives to be simple and nice to use 📌.
- [Haruna](https://invent.kde.org/multimedia/haruna) - Open source video player built with Qt/QML and libmpv 📌.
- [Kdenlive](https://www.kdenlive.org/) - A non-linear video editor for Linux using the MLT video framework.
- [KMix](https://apps.kde.org/kmix/) - A sound channel mixer and volume control 📌.
- [KWave](https://apps.kde.org/kwave/) - A sound editor built on the KDE Frameworks 5 📌.
- [SMPlayer](https://www.smplayer.info/) - Media player with built-in codecs that can play virtually all video and audio formats.
- [VLC](https://www.videolan.org/vlc/) - A free and open source cross-platform multimedia player and framework that plays most multimedia files, and various streaming protocols.

### Office & Productivity

- [Calligra](https://www.calligra.org/) - Includes efficient and capable office components 📌.
- [GhostWriter](https://ghostwriter.kde.org/) - No distraction markdown editor 📌.
- [Kate](https://apps.kde.org/kate/) - A multi-document, multi-view text editor by KDE 📌.
- [Kronometer](https://apps.kde.org/kronometer/) A stopwatch application for KDE 📌.
- [KWrite](https://apps.kde.org/kwrite/) - A text editor by KDE, based on the KDE Frameworks editor component 📌.
- [RSI Break](https://apps.kde.org/rsibreak/) - RSIBreak can be used to remind you to take a break now and then 📌.

### System Administration

- [Discover](https://apps.kde.org/discover/) - Intended for users and distros where the terminal isn't the optimal solution for installation of apps and add-ons or updates 📌.
- [Dolphin](https://apps.kde.org/dolphin/) - File manager included in the KDE desktop 📌.
- [KDiskFree](https://apps.kde.org/kdf/) - Displays the available file devices (hard drive partitions, drives, etc.) along with information on their capacity, free space, type and mount point 📌.
- [KInfoCenter](https://userbase.kde.org/KInfoCenter) - A utility that provides detailed information about a computer system 📌.
- [Konsole](https://apps.kde.org/konsole/) - Terminal emulator included in the KDE desktop 📌.
- [Krusader](https://krusader.org/) - An advanced twin panel (commander style) file manager for KDE 📌.
- [KSystemLog](https://apps.kde.org/ksystemlog/) - A system log viewer tool 📌.
- [Kup](https://apps.kde.org/kup/) - A backup scheduler for KDE's Plasma desktop 📌.
- [Sweeper](https://apps.kde.org/sweeper/) - Sweeper helps to clean unwanted traces the user leaves on the system and to regain disk space removing unused temporary files 📌.
- [Yakuake](https://apps.kde.org/yakuake/) - A drop-down terminal emulator based on KDE's Konsole technology 📌.

### Utilities & Tools

- [Android File Transfer](https://whoozle.github.io/android-file-transfer-linux/) - Reliable MTP client with minimalistic UI.
- [Ark](https://apps.kde.org/ark/) - Archiving Tool 📌.
- [fancontrol-gui](https://github.com/Maldela/fancontrol-gui) - GUI for fancontrol which is part of lm_sensors.
- [KDE Wallet Manager](https://invent.kde.org/utilities/kwalletmanager/) - Manage the passwords on KDE systems. The KDE wallet subsystem allows access and password management of every application that integrates with the KDE wallet 📌.
- [KeePassXC](https://keepassxc.org/) - Cross-platform community-driven port of Keepass password manager.
- [KFind](https://apps.kde.org/kfind/) - A standalone search tool, launched by KRunner or from your menu. It is also integrated into Konqueror as "Find File" in the "Tools" menu 📌.
- [KRename](https://apps.kde.org/krename/) - A utility to rename multiple files 📌.
- [KWin-lowlatency](https://github.com/tildearrow/kwin-lowlatency) - An attempt to reduce latency and stuttering in the popular KWin compositor used in KDE.
- [KWinFT](https://gitlab.com/kwinft/kwinft) - Wayland compositor and X11 window manager.
- [QOwnNotes](https://www.qownnotes.org/) - Note taking app with cloud integration, web and mobile support.
- [QtPass](https://qtpass.org/) - A multi-platform GUI for [pass](https://www.passwordstore.org/).
- [Wacom GUI](https://github.com/tb2097/wacom-gui) - Python/PyQt Wacom GUI for KDE.
- [Yin-Yang](https://github.com/daehruoydeef/Yin-Yang) - Auto Night-mode for Linux.

### Development & Programming

- [Kate](https://kate-editor.org/) - Kate is a Feature-Packed Code Editor with advanced support for LSP, Syntax Highlighting, multi-cursoe and more 📌.
- [KDevelop](https://www.kdevelop.org/) - A cross-platform IDE for C, C++, Python, QML/JavaScript and PHP 📌.
- [Kompare](https://apps.kde.org/kompare/) - A diff/patch frontend 📌.
- [Okteta](https://apps.kde.org/okteta/) - Hex Editor 📌.
- [Qt Designer](http://doc.qt.io/qt-5/qtdesigner-manual.html) - Qt tool for designing and building graphical user interfaces (GUIs) with Qt Widgets.
- [Umbrello](https://apps.kde.org/umbrello/) - UML Modeller is a Unified Modelling Language (UML) diagram program based on KDE Technology 📌.

### Education

- [KTurtle](https://apps.kde.org/kturtle/) - An educational programming environment that aims to make learning how to program as easy as possible 📌.
- [LabPlot](https://labplot.kde.org/) - Interactive graphing and analysis of scientific data 📌.

## Customization

Note: Customizations quickly become outdated, it is recommended to look in the [KDE Store](https://store.kde.org/browse/) or use [Discover](https://userbase.kde.org/Discover) instead.

### Plasma desktop

#### Extensions

- [Bismuth](https://github.com/Bismuth-Forge/bismuth) - A KDE Plasma extension that lets you tile windows automatically and manage them via keyboard, just like in classical tiling window managers (i3, dwm or XMondad). (**NOTE** for KDE Plasma 6, check Polonium listed below)
- [Dynamic Wallpaper Engine](https://github.com/zzag/plasma5-wallpapers-dynamic) - A wallpaper plugin that continuously updates the desktop background based on the current time in your location.
- [Hoppla](https://github.com/Fuchs/hoppla-sa) - KDE Plasma desktop widget to control Philips Hue lights.
- [Kvantum](https://github.com/tsujan/Kvantum) - An SVG-based theme engine for Qt4/Qt5, KDE and LXQt, with an emphasis on elegance, usability and practicality.
- [Latte-Dock](https://invent.kde.org/plasma/latte-dock) - Latte is a dock based on Plasma frameworks that provides an elegant and intuitive experience for your tasks and plasmoids 📌.
- [Places Widget](https://github.com/dfaust/plasma-applet-places-widget) - Plasma 5 widget that gives access to user places.
- [Polonium](https://zeroxoneafour.github.io/polonium/) - The successor of Bismuth for KDE Plasma 6.
- [Window AppMenu Applet](https://github.com/psifidotos/applet-window-appmenu) - Plasma 5 applet in order to show the window appmenu.
- [Window Title Applet](https://github.com/psifidotos/applet-window-title/) - Plasma 5 applet that shows the current window title and icon in your panels.
- [Karousel](https://github.com/peterfajdiga/karousel) - KWin tiling script with scrolling. Works especially well with ultrawide screens.

#### KCM Modules and Systems

- [kcm-wacomtablet](https://invent.kde.org/plasma/wacomtablet/) - KDE GUI for the Wacom Linux Drivers 📌.
- [kde-gtk-config](https://invent.kde.org/plasma/kde-gtk-config) - GTK2 and GTK3 Configurator for KDE 📌.
- [kded_rotation](https://github.com/dos1/kded_rotation) - A small, hacky KDED module for handling automatic screen rotation on tablets and hybrid laptops.

#### Themes

- [Adapta KDE](https://github.com/PapirusDevelopmentTeam/adapta-kde) - A port of the popular GTK theme Adapta for Plasma 5 desktop with a few additions and extras.
- [Arc KDE](https://github.com/PapirusDevelopmentTeam/arc-kde) - A port of the popular GTK theme Arc for Plasma 5 desktop with a few additions and extras.
- [Breath](https://gitlab.manjaro.org/artwork/themes/breath) - Breath Theme for Manjaro Linux (Plasma 5).
- [Canta](https://github.com/vinceliuice/Canta-kde) - A flat design theme for KDE Plasma desktop.
- [ChromeOS](https://github.com/vinceliuice/ChromeOS-kde) - A materia Design theme for KDE Plasma desktop.
- [Darkine KDE](https://github.com/Rokin05/darkine-kde) - Theme for KDE Plasma 5 desktop, SDDM and more.
- [Fluent](https://github.com/vinceliuice/Fluent-kde) - A Microsoft inspired fluent Design theme for the KDE Plasma desktop.
- [Helium](https://store.kde.org/p/998869/) - A translucent theme for Plasma 5.
- [Hello](https://github.com/n4n0GH/hello) - A compilation of various color-schemes, themes, icons and more for the KDE Plasma desktop. It is unopinionated, putting you in charge.
- [Layan](https://github.com/vinceliuice/Layan-kde) - A flat design theme for KDE Plasma desktop.
- [Materia KDE](https://github.com/PapirusDevelopmentTeam/materia-kde) - A port of the popular GTK theme Materia for Plasma 5 desktop with a few additions and extras.
- [McMojave](https://github.com/vinceliuice/McMojave-kde) - A MacOSX Mojave like theme for KDE Plasma desktop.
- [Orchis](https://github.com/vinceliuice/Orchis-kde) - A materia Design theme for KDE Plasma desktop.
- [Qogir](https://github.com/vinceliuice/Qogir-kde) - A flat design theme for KDE Plasma desktop.
- [WhiteSur](https://github.com/vinceliuice/WhiteSur-kde) - A MacOS Big Sur theme for KDE Plasma.

#### Qt and GTK+ Applications Appearance

- [Akava-Kv](https://github.com/Akava-Design/Akava-Kv) - User oriented Kvantum theme for KDE.
- [breeze-gtk](https://github.com/KDE/breeze-gtk) - A GTK Theme Built to Match KDE's Breeze 📌.
- [Breeze10](https://github.com/fauzie811/Breeze10) - A Windows 10 style windows decoration for KDE Plasma.
- [BreezeBlurred](https://github.com/alex47/BreezeBlurred) - A fork of KDE Breeze window decoration written in Qt C++.
- [BreezeEnhanced](https://github.com/tsujan/BreezeEnhanced) - A fork of KDE Breeze decoration with additional options.
- [Chrome-KDE5BreezeDark](https://github.com/pdeljanov/Chrome-KDE5BreezeDark) - A theme for Chrome on KDE5 when using the Breeze Dark window decoration.
- [KDE-Rounded-Corners](https://github.com/alex47/KDE-Rounded-Corners) - Rounds the corners of your windows.
- [SierraBreeze](https://github.com/ishovkun/SierraBreeze) - OSX-like window decoration for KDE Plasma written in C++.
- [Sweet KDE](https://github.com/EliverLara/Sweet-kde) - A dark and modern theme for KDE plasma.
- [XBoomer](https://github.com/efskap/XBoomer) - XP Window Decorations for KDE Plasma.

#### Icons

- [Antu](https://gitlab.com/froodo_alexis/Antu-icons) - A smooth icon theme designed for Plasma Desktop.
- [Candy](https://github.com/EliverLara/candy-icons) - Sweet gradient icons.
- [Flatery](https://github.com/cbrnix/Flatery) - Icon theme for Linux in flat style.
- [La Capitaine](https://github.com/keeferrourke/la-capitaine-icon-theme) - Icon pack with inspiration taken from the latest iterations of macOS and Google's Material Design.
- [Papirus](https://github.com/PapirusDevelopmentTeam/papirus-icon-theme) - Material icon theme, initially based on Paper.
- [Tela](https://github.com/vinceliuice/Tela-icon-theme) - A flat colorful Design icon theme.
- [Zafiro](https://github.com/zayronxio/Zafiro-icons) - Minimalist icons created with the flat-desing technique, utilizing washed out colors and always accompanied by white. The priority is simplicity.

#### Cursors

- [Bibata](https://store.kde.org/p/1197198/) - Material Based Cursor Theme.
- [Capitaine](https://github.com/keeferrourke/capitaine-cursors) - An x-cursor theme inspired by macOS and based on KDE Breeze.

#### Scripts

- [Grid-Tiling-Kwin](https://github.com/lingtjien/Grid-Tiling-Kwin) - A kwin script that automatically tiles windows.
- [Kröhnkite](https://github.com/esjeon/krohnkite) - A dynamic tiling extension for KWin.
- [kwin-tiling](https://github.com/faho/kwin-tiling) - Tiling script for kwin.

#### Display Manager

- [Chili](https://github.com/MarianArlt/kde-plasma-chili) - The hottest login theme around for KDE Plasma 5.
- [Delicious](https://github.com/stuomas/delicious-sddm-theme) - A delicious SDDM theme for DE collectors/addicts.
- [Sugar Candy](https://framagit.org/MarianArlt/sddm-sugar-candy) - The sweetest login theme available for the SDDM display manager.

## Documentation and Resources

- [KDE Wikis](https://wiki.kde.org/) - The KDE wikis are a source of information and documentation for the KDE desktop, applications, teams, events and more 📌.
- [KDE Invent](https://invent.kde.org/) - Discover KDE projects, groups and snippets 📌.
- [KDE Bugtracker](https://bugs.kde.org/) - KDE's official Bugtracker 📌.
- [ArchWiki](https://wiki.archlinux.org/index.php/KDE) - Arch Linux KDE Wiki.
- [Gentoo Wiki](https://wiki.gentoo.org/wiki/KDE) - Gentoo KDE Wiki.
- [KDE Configs](https://github.com/shalva97/kde-configuration-files) - List of KDE configuration files and more.

## Articles

- [KDE.news](https://dot.kde.org/) - The official KDE news website 📌.
- [Planet KDE](https://planet.kde.org/) - Blogs of KDE contributors 📌.
- [Phoronix](https://www.phoronix.com/scan.php?page=news_topic&q=KDE) - Phoronix KDE News Archives.
- [Nate Graham's Blog](https://pointieststick.wordpress.com/) - Adventures in Linux and KDE.
- [Nico's Blog](https://nicolasfella.wordpress.com/) - Programmer from Germany that is working on KDE.
- [Kai Uwe's Blog](https://blog.broulik.de/) - Stories of a Plasma developer.

## Communities

- [Kreddit](https://www.reddit.com/r/kde/) - KDE Community on Reddit.
- [KDE Store](https://store.kde.org/) - Official KDE Store for developers to share Plasma customizations 📌.
- [Stack Overflow](https://stackoverflow.com/questions/tagged/kde) - Questions tagged with `kde`.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
