<div class="github-widget" data-repo="gamontal/awesome-katas"></div>
![banner](https://github.com/gmontalvoriv/katas/blob/master/images/kata_guruma.png)

## Awesome Katas [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
> A curated list of code katas



## Introduction
A kata, or code kata, is defined as an exercise in programming which helps hone your skills through practice and repetition. Dave Thomas [@pragdave](https://twitter.com/pragdave), started this movement for programming. This project aims to provide you with a list of some kata exercises that I've found in the Internet and the Github community. These exercises vary from general to more complex algorithms and real life situations for you to try using your preferred programming language. Remember that code katas are not quizzes or puzzles. You should not only try to 'solve' it, but find a very good solution, following best practices of the programming language you are using.

## [CodeKata](http://codekata.com/)
  - [Kata01: Supermarket Pricing](http://codekata.com/kata/kata01-supermarket-pricing/)
  - [Kata02: Karate Chop](http://codekata.com/kata/kata02-karate-chop/)
  - [Kata03: How Big? How Fast?](http://codekata.com/kata/kata03-how-big-how-fast/)
  - [Kata04: Data Munging](http://codekata.com/kata/kata04-data-munging/)
  - [Kata05: Bloom Filters](http://codekata.com/kata/kata05-bloom-filters/)
  - [Kata06: Anagrams](http://codekata.com/kata/kata06-anagrams/)
  - [Kata07: How'd I Do?](http://codekata.com/kata/kata07-howd-i-do/)
  - [Kata08: Conflicting Objectives](http://codekata.com/kata/kata08-conflicting-objectives/)
  - [Kata09: Back to the Checkout](http://codekata.com/kata/kata09-back-to-the-checkout/)
  - [Kata10: Hashes vs. Classes](http://codekata.com/kata/kata10-hashes-vs-classes/)
  - [Kata11: Sorting It Out](http://codekata.com/kata/kata11-sorting-it-out/)
  - [Kata12: Best Sellers](http://codekata.com/kata/kata12-best-sellers/)
  - [Kata13: Counting Code Lines](http://codekata.com/kata/kata13-counting-code-lines/)
  - [Kata14: Tom Swift Under the Milkwood](http://codekata.com/kata/kata14-tom-swift-under-the-milkwood/)
  - [Kata15: A Diversion](http://codekata.com/kata/kata15-a-diversion/)
  - [Kata16: Business Rules](http://codekata.com/kata/kata16-business-rules/)
  - [Kata17: More Business Rules](http://codekata.com/kata/kata17-more-business-rules/)
  - [Kata18: Transitive Dependencies](http://codekata.com/kata/kata18-transitive-dependencies/)
  - [Kata19: Word Chains](http://codekata.com/kata/kata19-word-chains/)
  - [Kata20: Klondike](http://codekata.com/kata/kata20-klondike/)
  - [Kata21: Simple Lists](http://codekata.com/kata/kata21-simple-lists/)

## [Wonderland Clojure Katas](https://github.com/gigasquid/wonderland-clojure-katas)
  - [Alphabet Cipher](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/alphabet-cipher)
  - [Card game War](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/card-game-war)
  - [Doublets](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/doublets)
  - [Fox Goose Bag of Corn](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/fox-goose-bag-of-corn)
  - [Magic Square](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/magic-square)
  - [Tiny Maze](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/tiny-maze)
  - [Wonderland Number](https://github.com/gigasquid/wonderland-clojure-katas/tree/master/wonderland-number)

## [SensioLabs PoleDev Katas](https://github.com/devdrops/Katas)
  - [Kata 1: (Form) DataTransformer](https://github.com/devdrops/Katas/tree/kata-data-transformers)
  - [Kata 2: (EventDispatcher) Event Listener / Event Dispatcher](https://github.com/devdrops/Katas/tree/kata-event-listener)
  - [Kata 3: (Form) Inherit data / Virtual Form](https://github.com/devdrops/Katas/tree/kata-inherit-data)
  - [Kata 4: (Form) File Upload](https://github.com/devdrops/Katas/tree/kata-upload-file)
  - [Kata 5: (Translation) Manage translations](https://github.com/devdrops/Katas/tree/kata-translation)

## [Gaurav Arora's TDD Katas Collection](https://github.com/garora/TDD-Katas)
  - [String Sum Kata](https://github.com/garora/TDD-Katas#string-sum-kata)
  - [String Calculator Kata](https://github.com/garora/TDD-Katas#string-calculator-kata-via-roy-osherove)
  - [The Bowling Game Kata](https://github.com/garora/TDD-Katas#the-bowling-game-kata-via-uncle-bob)
  - [The FizzBuzz Kata](https://github.com/garora/TDD-Katas#the-fizzbuzz-kata)
  - [The OddEven Kata](https://github.com/garora/TDD-Katas#the-oddeven-kata)
  - [The PrimeFactor Kata](https://github.com/garora/TDD-Katas#the-primefactor-kata-via-uncle-bob)
  - [Game of Life](https://github.com/garora/TDD-Katas#game-of-life-)
  - [Harry Potter](https://github.com/garora/TDD-Katas#harry-potter-)
  - [LCD Digits](https://github.com/garora/TDD-Katas#lcd-digits-)
  - [Leap Year](https://github.com/garora/TDD-Katas#leap-year-)
  - [Mine Fields](https://github.com/garora/TDD-Katas#mine-fields-)
  - [Poker Hands](https://github.com/garora/TDD-Katas#poker-hands)
  - [Recently Used List](https://github.com/garora/TDD-Katas#recently-used-list-)
  - [Reversi](https://github.com/garora/TDD-Katas#reversi-)
  - [Yehtzee](https://github.com/garora/TDD-Katas#yehtzee-)
  - [The Word Wrap Kata](http://codingdojo.org/cgi-bin/wiki.pl?KataWordWrap)

## Others
  - [Look and Say Sequence](https://en.wikipedia.org/wiki/Look-and-say_sequence)
  - [AKS primality test](https://en.wikipedia.org/wiki/AKS_primality_test)
  - [Roman Numeral Converter](https://en.wikipedia.org/wiki/Roman_numerals)
  - [Natural sort order](https://en.wikipedia.org/wiki/Natural_sort_order)
  - [ES6 Katas](http://es6katas.org/)
  - [.Net Code Katas](https://github.com/AlanBarber/CodeKatas)
  - [Bank OCR](http://code.joejag.com/coding-dojo/bank-ocr/)
  - [Bubble sort](https://en.wikipedia.org/wiki/Bubble_sort)
  - [Racing Car Katas](https://github.com/emilybache/Racing-Car-Katas)
  - [Coding Dojo's KataCatalogue](http://codingdojo.org/KataCatalogue/)
  - [The OCP Kata](http://matteo.vaccari.name/blog/archives/293)
  - [The Birthday Greetings Kata](http://matteo.vaccari.name/blog/archives/154)
  - [Social Networking Kata](https://github.com/sandromancuso/social_networking_kata)
  - [Tell don't ask kata](https://github.com/gabrieletondi/tell-dont-ask-kata)  
  - [Functional Structures Refactoring Kata](https://github.com/matteobaglini/functional-structures-refactoring-kata)
  - [incremental_katas](https://github.com/Gianfrancoalongi/incremental_katas)
  - [CLI Arguments Parser Kata](https://github.com/ivoputzer/cli-args-parser-kata)
  - [Git katas](https://github.com/praqma-training/gitkatas)
  - [Pdt256 katas (php, go, python, java, haskell, typescript)](https://github.com/pdt256/kata)
  - [Opening Hours Kata](https://github.com/christian-fei/opening-hours-kata)
  - [The Quantum Katas](https://github.com/Microsoft/QuantumKatas)
  - [Katalyst](https://katalyst.codurance.com/)
  - [The Beverages Prices Refactoring Kata](https://github.com/trikitrok/beverages_pricing_refactoring_kata)
  - [The Goose Game Kata](https://github.com/xpeppers/goose-game-kata)
  - [Salary slip kata](https://github.com/sandromancuso/salaryslipkata)
  - [RPG Game kata](https://github.com/ardalis/kata-catalog/blob/master/katas/RPG%20Combat.md)
  - [Train Reservation kata](https://github.com/emilybache/KataTrainReservation)
  - [Password-strength Checker TDD Kata](https://github.com/xpepper/PasswordStrengthChecker)
  - [Parrot Refactoring Kata](https://github.com/emilybache/Parrot-Refactoring-Kata)
  - [Gilded Rose - Many languages](https://github.com/emilybache/GildedRose-Refactoring-Kata)
  - [Gilded Rose Original - C#](https://github.com/NotMyself/GildedRose)
  - [Java by Comparison Kata](https://java.by-comparison.com/kata)
  - [DNA Transcription Kata](https://github.com/nickdelgrosso/dna-transcription-kata)
  - [Refactoring Golf Kata](https://github.com/daviddenton/refactoring-golf)
  - [Promotion Text Kata](https://github.com/nealhu/promotion-text-kata)
  - [Args Kata](https://github.com/nealhu/args-kata)
  - [CodeCrafters(Build your own Git, Redis, Docker etc.)](https://app.codecrafters.io/tracks?r=8Ol)
  - [Tennis Refactoring Kata](https://github.com/emilybache/Tennis-Refactoring-Kata)
  
## Contribution
  
#### Please read the [contribution guidelines](https://github.com/gmontalvoriv/katas/blob/master/CONTRIBUTING.md).

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)
