<div class="github-widget" data-repo="petk/awesome-jquery"></div>
## Awesome jQuery

<a href="https://raw.githubusercontent.com/sindresorhus/awesome"><img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" alt="Awesome" height="18"></a>
[![Join the chat at https://gitter.im/peterkokot/awesome-jquery](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/peterkokot/awesome-jquery?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![CCO License](https://img.shields.io/badge/license-CC0-blue.svg?style=plastic "CC0 License")](#contributing-and-license)
[![Project Maintained](https://img.shields.io/badge/project-maintained-brightgreen.svg?style=plastic "Project Maintained")](https://github.com/petk/awesome-jquery/commits/master)
[![Build Status](https://img.shields.io/travis/petk/awesome-jquery/master.svg)](https://travis-ci.org/petk/awesome-jquery)

A curated list of awesome [jQuery](http://jquery.com/) plugins, resources and other shiny things. Inspired by the `awesome-*` trend on GitHub.

> [jQuery](http://jquery.com/) is a fast, small, and feature-rich [JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript) library. It makes things like HTML document traversal and manipulation, event handling, animation, and Ajax much simpler with an easy-to-use API that works across a multitude of browsers. With a combination of versatility and extensibility, jQuery has changed the way that millions of people write JavaScript.


<img width="400" src="https://raw.githubusercontent.com/petk/awesome-jquery/master/awesome-jquery.png" alt="awesome-jquery" align=right>


## Resources

*Awesome learning material to get to know jQuery and JavaScript or learn something more advanced. Some friendly advice: Before diving deep into jQuery learn JavaScript well.*

* [API documentation](http://api.jquery.com/) - Official jQuery documentation.
* [Code School](https://www.pluralsight.com/courses/code-school-try-jquery) - Learn the basics of jQuery, a JavaScript library, to modify elements on a webpage and improve user interaction.
* [Codecademy jQuery track](https://www.codecademy.com/learn/learn-jquery) - Beginners track for learning jQuery.
* [Learning jQuery](https://www.learningjquery.com/) - Tips, techniques, and tutorials for the jQuery JavaScript library.
* [Style guides](https://contribute.jquery.org/style-guide/) - jQuery's code style guides when contributing to jQuery projects.
* [Tuts+](https://code.tutsplus.com/categories/jquery) - Useful and indepth articles about jQuery.
* [jQuery guide for teams](https://github.com/voorhoede/jquery-style-guide) - Tips to write consistent jQuery code, easy to use and understand by your team.

### Tutorials

*Awesome free tutorials and courses to learn jQuery.*

* [jQuery patterns](https://github.com/jquery-boilerplate/jquery-patterns) - A variety of jQuery plugin patterns for jump starting your plugin development.
* [Learning jQuery Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#jquerypluginpatterns) - jQuery Plugin Design Patterns
* [Learn jQuery](http://learn.jquery.com/) - jQuery learning center.
* [Snoopcode](http://www.snoopcode.com/jquery/) - jQuery tutorials.
* [Extending jQuery](https://j11y.io/javascript/extending-jquerys-selector-capabilities/) - Extending jQuery’s selector capabilities.
* [Free jQuery Courses at Classpert](https://classpert.com/search?filter[free_course][]=true&filter[price][]=0&filter[price][]=0&p=1&tag=jquery) - List of Free jQuery Courses at Classpert Online Course Search


### Books

*Recommended and not too much outdated jQuery books.*

#### Free Books

* [JavaScript plus a dash of JQuery](http://nicholasjohnson.com/javascript-book/) - A Sensible Introduction to Coding with JavaScript and jQuery, *by Nicholas Johnson*.
* [jQuery Succinctly, Syncfusion](https://www.syncfusion.com/ebooks/jquery) (PDF, mobi, epub) *(Registration required)*.
* [jQuery fundamentals](https://github.com/bocoup/jqfundamentals.com) - Comfortable working through common problems you'll be called upon to solve using jQuery.

#### Paid Books

* [jQuery in Action, Third Edition](https://www.manning.com/books/jquery-in-action-third-edition) - Fast-paced and complete guide to jQuery, *by Bear Bibeault, Yehuda Katz, and Aurelio De Rosa*.
* [jQuery: Novice to Ninja: New Kicks And Tricks](https://www.sitepoint.com/premium/books/jquery-novice-to-ninja-new-kicks-and-tricks) - fast track to mastering jQuery, *by Earle Castledine & Craig Sharkie*.
* [Learning jQuery - Fourth Edition](https://www.packtpub.com/web-development/learning-jquery-fourth-edition) - Guide to jQuery, *by Jonathan Chaffer and Karl Swedberg*.


### Blogs

*Interesting jQuery related blogs and websites.*

* [jQuery Blog](http://blog.jquery.com/) - News from the official jQuery website.
* [jQuery UI Blog](http://blog.jqueryui.com/) - Official jQuery UI blog.
* [Sitepoint](https://www.sitepoint.com/javascript/jquery/) - Sitepoint's jQuery category section with useful articles.
* [Smashing Magazine](https://www.smashingmagazine.com/category/jquery) - jQuery tag, useful jQuery articles and tutorial alike blog posts.


### Miscellaneous Resources

*Various types of resources.*

* [jQuery Foundation](https://jquery.org/) - Providing jQuery and many other projects home and support.
* [jQuery Source Viewer](https://j11y.io/jquery/) - Browser of jQuery method implementations.
* [Alternative jQuery Documentation Browser](http://jqapi.com/) - Faster way to browse the jQuery documentation.
* [TodoMVC](https://github.com/tastejs/todomvc) - Helps you select JavaScript framework. Same Todo application created in multiple popular JavaScript MV* frameworks including [jQuery](http://todomvc.com/examples/jquery/).
* [jQuery CheatSheet](http://lab.abhinayrathore.com/jquery-cheatsheet/)
* [Programming Community Curated Resources for Learning jQuery](https://hackr.io/tutorials/learn-jquery)
* [HTML Tutorial by Scaler](https://www.scaler.com/topics/html/)


## Plugins

*Awesome plugins from all across the jQuery universe.*

* [Plugins](https://www.npmjs.com/search?q=keywords:jquery-plugin) - Registry of jQuery plugins, [previous one](http://plugins.jquery.com/) is now in read-only mode.
* [jQuery Rain](http://www.jqueryrain.com/) - Top & Best jQuery plugins, tutorials, cool effects, examples, demos.
* [jQuery Unheap](http://www.unheap.com/) - A tidy repository of jQuery plugins.


## Animation

*Animations, transitions.*

* [Animsition](https://github.com/blivesta/animsition/) - A simple and easy jQuery plugin for CSS animated page transitions.
* [fakeLoader.js](https://github.com/joaopereirawd/fakeLoader.js) - Lightweight plugin that helps you create an animated spinner with a fullscreen loading mask to simulate the page preloading effect.
* [Fullpage.js](https://github.com/alvarotrigo/fullPage.js) - Create full screen pages fast and simple.
* [jQuery Transit](https://github.com/rstacruz/jquery.transit) - Super-smooth CSS3 transformations and transitions for jQuery.
* [Material Design Preloader!s](https://github.com/aarondo/Material-Preloader) - Recreation of the Material Design preloader.
* [Midnight](https://github.com/Aerolab/midnight.js) - Switches fixed headers on the fly.
* [Parallax.js](https://github.com/pixelcog/parallax.js/) - Scrolling effect.
* [Scrollify](https://github.com/lukehaas/Scrollify/) - Assists scrolling and snaps to sections. Touch optimised.
* [Waves](https://github.com/fians/Waves) - Click effect inspired by Google's Material Design.
* [jQuery DrawSVG](https://github.com/lcdsantos/jquery-drawsvg) - Lightweight, simple to use jQuery plugin to animate SVG paths
* [jQuery Particles](https://github.com/matteobruni/tsparticles/tree/master/components/jquery) - A plugin to easily add Particles animations to your web application


### Editors

*WYSIWYG editors.*

* [Froala WYSIWYG HTML Editor](https://github.com/froala/wysiwyg-editor) - jQuery WYSIWYG Rich Text Editor based on HTML5.
* [jQuery Notebook](https://github.com/raphaelcruzeiro/jquery-notebook) - A modern, simple and elegant WYSIWYG rich text editor.
* [jQuery TE](http://jqueryte.com/) - Lightweight HTML editor.
* [TinyMCE](https://www.tiny.cloud/) - Popular WYSIWYG editor with jQuery build and a jQuery integration plugin.


### Forms

*Plugins for Forms, AJAX, validation.*

* [Bootstrap Multiselect](https://github.com/davidstutz/bootstrap-multiselect) - Multiselect for Bootstrap.
* [File Upload](https://github.com/blueimp/jQuery-File-Upload) - File Upload widget with multiple file selection, drag&drop support, progress bar, validation and preview images, audio and video.
* [Ideal Forms](https://github.com/elclanrs/jq-idealforms) - Framework for building and validating responsive HTML5 forms.
* [jQuery Form Plugin](https://github.com/jquery-form/form) - Easy and unobtrusive HTML forms upgrade to use AJAX.
* [jquery-minicolors](https://github.com/claviska/jquery-minicolors) - A tiny color picker plugin.
* [Justified Gallery](https://github.com/miromannino/Justified-Gallery) - Allows you to create a gallery with a justified grid.
* [Labelauty](https://github.com/fntneves/jquery-labelauty) - A lightweight and beautiful plugin for radio and checkbox inputs.
* [Payform](https://github.com/jondavidjohn/payform) - A library (with jQuery plugin) for building credit card forms, validating inputs, and formatting numbers.
* [Pickadate](https://github.com/amsul/pickadate.js) - The mobile-friendly, responsive, and lightweight date & time input picker.
* [Select2](https://github.com/select2/select2) - Select box with support for searching, tagging, remote data sets, infinite scrolling.
* [selectize.js](https://github.com/selectize/selectize.js/) - jQuery based hybrid of a textbox and \<select\> box.


### Images, Maps and Charts

*Plugins related to images, image manipulation, galleries, maps and charts.*

* [AnyChart-jQuery](https://github.com/AnyChart/AnyChart-jQuery) - Plugin for easily using AnyChart JavaScript charting library with jQuery.
* [Arbor](https://github.com/samizdatco/arbor) - Graph visualization library using web workers and jQuery.
* [BackStretch](https://github.com/jquery-backstretch/jquery-backstretch) - jQuery plugin that allows you to add a dynamically-resized, slideshow-capable background image to any page or element.
* [Chart.js](https://github.com/chartjs/Chart.js) - Simple HTML5 Charts using the \<canvas\> tag.
* [Cropper](https://github.com/fengyuanchen/cropper) - A simple image cropping plugin.
* [Dense.js](https://github.com/gocom/dense) - Serving retina-ready, high pixel ratio images with ease.
* [Flot](https://github.com/flot/flot) - Attractive charts.
* [Gridder](https://github.com/oriongunning/gridder) - Displays a thumbnail grid expanding preview similar to the effect seen on Google Images.
* [jquery.sparkline](https://github.com/gwatts/jquery.sparkline) - Generate small sparkline charts.
* [jQuery.eraser](https://github.com/boblemarin/jQuery.eraser) - Erasing image with mouse or touch movements.
* [jQuery Mapael](https://github.com/neveldo/jQuery-Mapael) - Plugin based on raphael.js that allows you to display dynamic vector maps.
* [jQueryGantt](https://github.com/robicch/jQueryGantt) - Gantt editor.
* [jQuery Images Compare](https://github.com/sylvaincombes/jquery-images-compare) - Plugin for comparing two images.
* [Nivo Slider](https://github.com/Codeinwp/Nivo-Slider-jQuery) - Beautiful and easy to use image slider.
* [Owl Carousel 2](https://github.com/OwlCarousel2/OwlCarousel2) - Responsive carousel slider.
* [Slick](https://github.com/kenwheeler/slick) - The last carousel you'll ever need.
* [Peity](https://github.com/benpickles/peity) - Progressive \<svg\> pie, donut, bar and line charts.
* [Unite Gallery](https://github.com/vvvmax/unitegallery/) - Responsive jQuery image and video gallery plugin.
* [Viewer](https://github.com/fengyuanchen/viewer) - A simple jQuery image viewing plugin.
* [JQuery-linechart](https://github.com/kis/jquery-linechart) - Simple and lightweight library for creating line charts


### Menus

*Menus animation, usability enhancements and beautification.*

* [jQuery contextMenu](https://github.com/swisnl/jQuery-contextMenu) - Management facility for context menus.
* [jPanelMenu](https://github.com/acolangelo/jPanelMenu) - Creates a paneled-style menu (like the type seen in the mobile versions of Facebook, Google and native iPhone applications).
* [jQuery-menu-aim](https://github.com/kamens/jQuery-menu-aim) - Fires events when user's cursor aims at particular dropdown menu items.
* [mmenu](https://github.com/FrDH/mmenu-js) - App look-alike on- and off-canvas menus with sliding submenus.
* [Multi-level push menu](https://github.com/adgsm/multi-level-push-menu) - Allows endless nesting of navigation elements.
* [Slidebars](https://github.com/adchsm/Slidebars) - jQuery framework for off-canvas menus and sidebars.
* [stickUp](https://github.com/LiranCohen/stickUp) - Sticks an element to the top of the browser window while scrolling past it, always keeping it in view.
* [Superfish](https://github.com/joeldbirch/superfish) - Adds usability enhancements to existing multi-level drop-down menus.
* [Yamm](https://github.com/geedmo/yamm3) - Yet another megamenu for Bootstrap 3.


### Modals and Popups

*Plugins for modals (dialog box/popups), tooltips, and similar popup windows.*

* [animatedModal.js](https://github.com/joaopereirawd/animatedModal.js) - Plugin for creating fullscreen modals with CSS3 transitions. You can use the transitions from `animate.css` or create your own.
* [Avgrund](https://github.com/voronianski/jquery.avgrund.js) - Plugin for your modal boxes and popups with new concept of showing depth between popup and page.
* [Bootstrap Modal](https://github.com/jschr/bootstrap-modal) - Extends the default Bootstrap Modal class. Responsive, stackable and ajax.
* [iziModal](https://github.com/marcelodolza/iziModal) - Elegant, responsive, flexible and lightweight modal plugin with jQuery.
* [jBox](https://github.com/StephanWagner/jBox) - Powerful and flexible plugin which takes care of all modal windows, tooltips and notices.
* [jQuery Modal](https://github.com/kylefox/jquery-modal) - Simple and lightweight method of displaying modal windows.
* [jQuery Popup Overlay](https://github.com/vast-engineering/jquery-popup-overlay) - Responsive and accessible modal windows and tooltips.
* [Lightbox](https://github.com/lokesh/lightbox2/) - JavaScript library used to overlay images on top of the current page.
* [Magnific Popup](https://github.com/dimsemenov/Magnific-Popup) - Fast, light and responsive lightbox plugin.
* [SweetAlert](https://github.com/t4t5/sweetalert) - A beautiful replacement for JavaScript's alert.
* [tipso](https://github.com/object505/tipso) - A Lightweight Responsive jQuery Tooltip Plugin.
* [vex](https://github.com/hubspot/vex) - A modern dialog library which is highly configurable and easy to style.


### Tables

*Grid plugins and plugins for creating and showcasing data in form of tables.*

* [Bootgrid](https://github.com/rstaib/jquery-bootgrid) - A grid control especially designed for bootstrap.
* [Bootstrap table](https://bootstrap-table.com/) - A powerful table control designed for bootstrap.
* [DataTables](https://www.datatables.net/) - Advanced interaction controls for HTML tables.
* [FancyGrid](https://fancygrid.com/) - JavaScript grid library with charts integration and server communication.
* [Filter Table](https://github.com/sunnywalker/jQuery.FilterTable) - Live searching/filtering for HTML tables.
* [FloatThead](https://github.com/mkoryak/floatThead) - Sticky headers. Supports responsive, window and overflow scrolling.
* [FooTable](https://github.com/fooplugins/FooTable/) - Make HTML tables responsive.
* [Isotope](https://github.com/metafizzy/isotope) - Filter & sort magical layouts.
* [HighchartTable](https://github.com/highchartTable/jquery-highchartTable-plugin) - Simple way to convert HTML data tables to Highcharts graphs.
* [jqGrid](https://github.com/tonytomov/jqGrid) - Grid plugin.
* [jQuery treetable](https://github.com/ludo/jquery-treetable) - Show a tree structure in a table.
* [jsGrid](https://github.com/tabalinas/jsgrid) - Lightweight grid plugin.
* [Stackable.js](https://github.com/johnpolacek/stacktable.js/) - Stacking tables on small screens.
* [Stupid Table Sort](https://github.com/joequery/Stupid-Table-Plugin) - A stupidly small and simple jQuery table sorter plugin.
* [tableExport.jquery.plugin](https://github.com/hhurz/tableExport.jquery.plugin) - Export HTML table to JSON, XML, CSV, TXT, SQL, Word, Excel, PNG or PDF.
* [jquery.table-shrinker](https://github.com/VagnerDomingues/jquery.table-shrinker) - make HTML Table responsive across all devices, the right way!


### Time and Date

*Plugins for handling, manipulating or formating time and date.*

* [jQuery Timer Plugin](https://github.com/walmik/timer.jquery) - Start/Stop/Resume/Remove pretty timer inside any HTML element.
* [Timeago](https://github.com/rmm5t/jquery-timeago) - Easy support of automatic updating fuzzy timestamps (e.g. "4 minutes ago").


### Translations

*Internationalization (i18n) and localization (l10n).*

* [i18n properties](https://github.com/jquery-i18n-properties/jquery-i18n-properties) - Lightweight plugin for providing internationalization to JavaScript from [.properties](https://en.wikipedia.org/wiki/.properties) files
* [jquery.i18n](https://github.com/wikimedia/jquery.i18n) - jQuery based Javascript internationalization library for easy internationalization of web application
* [jquery.localize.js](https://github.com/coderifous/jquery-localize) - Easy internationalization of your static web site


### Validation

*Validation plugins.*

* [FormValidation](https://github.com/formvalidation/formvalidation) - Form fields validator, designed for Bootstrap, Foundation, Pure, Semantic UI, UIKit and other frameworks.
* [h5Validate](https://github.com/ericelliott/h5Validate) - An HTML5 form validation plugin for jQuery.
* [jQuery Form Validator](https://github.com/victorjonsson/jQuery-Form-Validator/) - Validate user input while keeping your HTML markup clean from JavaScript code.
* [jquery-validation](https://github.com/jquery-validation/jquery-validation) - Drop-in validation for your existing forms, while making all kinds of customizations to fit your application really easy.
* [jQuery.validationEngine](https://github.com/posabsolute/jQuery-Validation-Engine) - Validation of form fields in the browser.
* [jQuery-form-validation](https://github.com/bnabriss/jquery-form-validation) - Validatie html forms using Laravel syntax.


### Miscellaneous Plugins

*Plugins that couldn't be sorted in above categories yet.*

* [Boilerplate](https://github.com/jquery-boilerplate/jquery-boilerplate) - A jump-start for jQuery plugins development.
* [Interlink](https://gist.github.com/Golpha/c5c7ae9b6ed11dc93ce6) - Event interlink plugin.
* [Sisyphus](https://github.com/simsalabim/sisyphus) - Gmail-like client-side drafts and bit more.
* [Slugify](https://github.com/pmcelhaney/jQuery-Slugify-Plugin) - Creates a URL slug as you type a page title (like Django slugify()).
* [Readmore.js](https://github.com/jedfoster/Readmore.js) - A lightweight jQuery plugin for collapsing and expanding long blocks of text with "Read more" and "Close" links.
* [Yahoo! Emoticons](http://michael-designs.com/yahoo-emoticons-jquery-plugin/) - Yahoo! Emoticons JQuery Plugin.
* [autoNumberic](https://github.com/autoNumeric/autoNumeric) - autoNumeric is a standalone library that provides live as-you-type formatting for international numbers and currencies.


## Mobile

*Mobile section.*

* [jQuery mobile](http://jquerymobile.com/) - Lightweight framework for building mobile web apps with HTML5.
* [Interdimensional](https://github.com/VodkaBears/Interdimensional) - Spatial scrolling on mobile devices for your web pages.
* [OhSnap!.js](https://github.com/justindomingue/ohSnap) - A simple jQuery/Zepto notification library designed to be used in mobile apps.


## UI

*User Interface section.*

* [Dragula](https://github.com/bevacqua/dragula) - Framework agnostic drag and drop library, supports jQuery integration.
* [jQuery UI](http://jqueryui.com/) - Curated set of user interface interactions, effects, widgets, and themes built on top of the jQuery.
* [tabulous.js](https://github.com/aarondo/tabulous.js) - Tabs for todays web
* [X-editable](https://github.com/vitalets/x-editable) - In-place editing with Twitter Bootstrap, jQuery UI or pure jQuery.
* [macon](https://github.com/LoganTann/macon) - Tiny utility (430B) to create reactive jquery components using a JSX-like syntax.


## Testing

*Unit tests, testing section.*

* [Qunit](http://qunitjs.com/) - A JavaScript Unit Testing framework, used by the jQuery, jQuery UI and jQuery mobile projects.
* [Mockjax](https://github.com/jakerella/jquery-mockjax) - Provides a simple and extremely flexible interface for mocking or simulating ajax requests and responses.


## Server-side Integrations

*Best practices of integrating client-side jQuery with server-side technologies.*

* Node.js:
    * [Bower](https://bower.io/) - Useful package manager optimized for the front-end.
    * [cheerio](https://cheerio.js.org/) - jQuery for server-side manipulations. It makes possible to construct jQuery instance from HTML string then query and manipulate it. Does not implement ajax and effects API.
* PHP:
    * [PHP front end setup without Node](https://www.sitepoint.com/look-ma-no-nodejs-a-php-front-end-workflow-without-node/) - Tutorial how to combine BowerPHP, Mini-Asset and Robo.li into a PHP front end asset building pipeline.
    * [symfony-collection](https://github.com/ninsuo/symfony-collection) - jQuery Plugin that manages adding, deleting and moving elements from a Symfony2 collection.
* Python:
    * [django-static-jquery](https://pypi.org/project/django-static-jquery/) - jQuery packaged in an handy Django app to speed up new applications and deployment.
* Ruby:
    * [jquery-rails](https://github.com/rails/jquery-rails) - A gem to automate using jQuery with Rails.
    * [jquery-ui-rails](https://github.com/jquery-ui-rails/jquery-ui-rails) - jQuery UI for the Rails asset pipeline.


## Community

*Ask and answer questions, share and get jQuery related stuff and get in touch with the community.*

* [Forum](https://forum.jquery.com/) - Official forum.
* [Freenode](http://irc.lc/freenode/jquery) - Support IRC channel for users of jQuery, jQuery UI, and jQuery Mobile.
* [Stack Overflow](https://stackoverflow.com/tags/jquery) - Support on Stack Overflow.
* [Facebook](https://www.facebook.com/groups/jquerycode/) - Large and active group on Facebook.
* [Linked.in](https://www.linkedin.com/groups/100943) - Large and active group on Linked.in.
* [Reddit](https://www.reddit.com/r/jquery) - Discussion and sharing news, articles, plugins and tutorials, covering jQuery Core, jQuery UI, jQuery Mobile, and other related projects.
* [Quora](https://www.quora.com/jQuery) - Ask and answer questions on Quora website.
* [Meetup](https://www.meetup.com/topics/jquery/) - Get involved locally.
* [Twitter](https://twitter.com/jquery) - Official news and updates from the jQuery team on Twitter.


## Alternatives

*Alternative implementations of jQuery API.*

* [cash](https://github.com/kenwheeler/cash) - small jQuery alternative for modern browsers. Includes all API with deliberate exception for ajax.
* [Zepto](https://zeptojs.com/) - small jQuery alternative, which includes ajax, effects and additional utilities.
* [jBone](http://jbone.js.org/) - jQuery implementation to use with Backbone. Supports only subset of API which is required for Backbone to work. Can be a byte-saver if you don't intend to use jQuery directly, but have Backbone in your project.


## Looking for more lists like this?

* Awesome lists:
    * [awesome](https://github.com/sindresorhus/awesome) - Awesome lists
    * [awesome-all](https://github.com/bradoyler/awesome-all) - Awesome lists
    * [emijrp/awesome-awesome](https://github.com/emijrp/awesome-awesome) - Awesome lists
    * [erichs/awesome-awesome](https://github.com/erichs/awesome-awesome) - Awesome lists
    * [GetAwesomeness](https://getawesomeness.herokuapp.com/) - Awesome lists
    * [lists](https://github.com/jnv/lists) - Awesome lists
* [awesome-javascript](https://github.com/sorrycc/awesome-javascript) - Awesome JavaScript list
* [awesome-javascript-books](https://github.com/heatroom/awesome-javascript-books) - Awesome JavaScript books
* [js-must-watch](https://github.com/bolshchikov/js-must-watch) - List of must-watch videos devoted to JavaScript
* Translations:
    * [Chinese](https://github.com/Iamlars/awesome-jquery/tree/chinese) - Chinese translation of Awesome jQuery.


## Contributing and License

You are most welcome to [contribute](https://github.com/petk/awesome-jquery/blob/master/CONTRIBUTING.md) to this awesome jQuery list as well. Big thanks to all [contributors](https://github.com/petk/awesome-jquery/graphs/contributors) who have helped to build this list.

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Peter Kokot](https://github.com/petk) has waived all copyright and related or neighboring rights to this work.
