<div class="github-widget" data-repo="automata/awesome-jamstack"></div>
<div align="center">
  <br /><br />
  <a href="https://awesome.re"><img src="https://awesome.re/badge-flat.svg" /></a>
  <br /><br /><br />
  <img width="500" src="https://raw.githubusercontent.com/automata/awesome-jamstack/master/media/jamstack-full-logo.svg?sanitize=true" alt="Jamstack">
  <br /><br /><br />
  <p>
    <strong>Jamstack</strong>: noun \’jam-stak’\<br />
    Modern web development architecture based on client-side JavaScript, reusable APIs, and prebuilt Markup.
  </p>
  <br /><br />
  <p>
    <b>
      This is a carefully curated list of awesome <a href="https://jamstack.org">Jamstack</a> resources.
    </b>
  </p>
  <br /><br />
  <p>
    <i>
      You might also like <a href="https://github.com/myles/awesome-static-generators">Awesome Static Generators</a>.
    </i>
  </p>
  <p>
    <i>
      Want to contribute with some resource? Great! Please, read the <a href="contributing.md">contribution guidelines</a> before contributing.
    </i>
  </p>
  <br /><br />
</div>



---

## General

- [Jamstack](https://jamstack.org/)
- [Jamstack resources](https://jamstack.org/resources/) - Videos and articles about Jamstack.
- [the New Dynamic](https://www.thenewdynamic.org/) - Pick up tools in our Directory to work with the Jamstack. Browse our showcase and get inspired.
- [Statichunt](https://statichunt.com/) - Jamstack Themes and Resources directory.
- [Built At Lightspeed](https://www.builtatlightspeed.com/) - A large directory of Jamstack themes, starters & UI kits.

## Chats

- [Jamstack Gitter Chat](https://gitter.im/jamstack/community)
- [Netlify Gitter Chat](https://gitter.im/netlify/community)
- [NetlifyCMS Gitter Chat](https://gitter.im/netlify/NetlifyCMS)
- [the New Dynamic Slack](https://join.slack.com/t/thenewdynamic/shared_invite/enQtMjkwNjYwNTY0NjkxLWI1NDhlNjZkZjA5ZGJmODE1OThiMjkwN2ZkMzE1YjEwN2YwNWUxYTNjZTUxMGQ2MzU3NWQ0YmVjNGU1NTkxMDk)

## Platforms

- [Netlify](https://netlify.com) - All-in-one platform for automating modern web projects.
- [Vercel](https://vercel.com) - All-in-one serverless platform for modern web apps with config-free tools and workflows.
- [Layer0](https://layer0.co) - All-in-one Jamstack platform focused on large, dynamic websites and best-in-class performance through an integrated CDN, EdgeJS, predictive prefetching, and performance monitoring.
- [Azure Static Web Apps](https://azure.microsoft.com/services/app-service/static/) - Full-stack serverless hosting with integrated CI/CD workflow, authentication, CDN and more.
- [Stormkit](https://stormkit.io) - Powerful all in one infrastructure for modern javascript apps. It integrates with your git flow and builds, deploys and scales your apps seamlessly.
- [Cloud 66](https://www.cloud66.com/) - Builds and deploys static websites to your own cloud account.

_For more resources about Static Web Apps see (Awesome Static Web Apps)[https://github.com/staticwebdev/awesome-azure-static-web-apps]._

## No-Code Platforms

- [Jamstack.new](https://jamstack.new) - Create a new Jamstack website with 1 click, brought to you by Stackbit
- [Storipress](https://storipress.com) - All-in-one publishing + blogging platform with integrated site builder and workflow management.
- [Draftbox](https://draftbox.co) - Lightning fast, secure front-end for your WordPress or Ghost blog, without coding.
- [Plasmic](https://www.plasmic.app/) - Powerful design tool for building your React components and Jamstack websites visually.
- [TeleportHQ](https://teleporthq.io/) - Front-end Design & Development Platform. TeleportHQ is the collaborative front-end platform to create and publish your headless static websites instantly. Free code export, 3 free projects, unlimited collaborators.

## Jamstack Sites Showcase

- [React](https://reactjs.org/) - Built on Gatsby.
- [Squoosh.app](https://squoosh.app/) - Hosted on Netlify, demonstrates advanced features from a modern Web Application.
- [Hopper](https://travel.hopper.com/) - Built on Gatsby and hosted on Netlify.
- [VSCode Power User Course](https://vscode.pro/) - PWA built on Gatsby and hosted on Netlify.
- [CloudyCam](https://CloudyCam.dev/) - PWA built on Next.js and hosted on Zeit Now v2 Serverless platform.
- [FbaMonthly](https://www.fbamonthly.com) - Hosted on Netlify, built with Jekyll, Netlify Functions and Netlify Forms.
- [Jarod Peachey](https://jarodpeachey.netlify.com) - Built with Gatsby + MaterialUI and hosted on Netlify
- [ProtonDB](https://www.protondb.com) - React/MaterialUI/Firebase hosted on Netlify since August 2018. Prominent in Linux gaming community.
- [Creative Designs Guru](https://creativedesignsguru.com) - Built on Eleventy.js hosted on Netlify and styled with Tailwind CSS
- [HandleDroid](https://handledroid.com/) - Built with Next.js, MongoDB, Auth0, AWS CloudWatch, SendGrid, Stripe and hosted on Netlify.
- [Backlinko](https://bejamas.io/blog/backlinko-case-study/) - Built with Next.js, headless WordPress and Netlify.

## Static Site Generators

- [Gatsby](https://gatsbyjs.org) - Blazing-fast static site generator for React.
- [Next.js](https://nextjs.org/) - Lightweight framework for static and server-rendered applications.
- [Hugo](https://gohugo.io) - Hugo is a static site generator written in Go.
- [Jekyll](https://jekyllrb.com) - Jekyll is a simple, blog-aware, static site generator perfect for personal, project, or organization sites.
- [Hexo](https://hexo.io) - A fast, simple & powerful blog framework, powered by Node.js.
- [Metalsmith](https://metalsmith.io) - An extremely simple, pluggable static site generator.
- [Phenomic](https://phenomic.io/) - A modular website compiler.
- [Gridsome](https://gridsome.org/) - Vue-powered static site generator for building CDN-ready websites for any Headless CMS, APIs or Markdown-files.
- [Nuxt.js](https://nuxtjs.org/) - Versatile vue-based framework for server-side-rendered, static and traditional single page applications.
- [eleventy](https://www.11ty.io/) - A simpler static site generator transforming various template files into HTML.
- [Nift](https://nift.dev) - A cross-platform open source website generator developed in C++ that is lightning fast and extremely powerful.
- [Astro](https://astro.build) - Build faster websites, while shipping less to almost no Javascript.
- [FactorJS](https://www.factorjs.org) - Next-generation framework powered by Vite.

_For a more complete list see [StaticGen](https://www.staticgen.com/)._

## CMS

- [Cosmic](https://cosmicjs.com) - Headless CMS with REST and GraphQL API options.
- [Kentico Kontent](https://kontent.ai) - A cloud-native headless CMS that scales.
- [Contentful](https://contentful.com) - Content infrastructure for digital teams.
- [Decap CMS](https://decapcms.org/) - Open source Git-based CMS _(Formerly known as [Netlify CMS](https://v1.netlifycms.org/))_.
- [ButterCMS](https://buttercms.com/) - Headless CMS and Content API.
- [Scrivito](https://scrivito.com) - Cloud-based JavaScript CMS built for digital agencies and medium to large-sized businesses.
- [GraphCMS](https://graphcms.com) - The GraphQL Headless CMS.
- [Apito](https://apito.io) - A Cloud Based Headless CMS with CDN, Webhooks, Team Collaborations, Content Revision, Cloud Functions.
- [Prismic](https://prismic.io) - Headless API CMS for both developers and marketers.
- [Siteleaf](https://siteleaf.com) - A friendly CMS for your static site.
- [DatoCMS](https://datocms.com) - The API-based CMS your editors will love.
- [Prose](https://prose.io) - Prose is a content editor for GitHub designed for managing websites.
- [Forestry](https://forestry.io) - Headless CMS for sites built with static site generators.
- [Coisas](https://github.com/fiatjaf/coisas) - A client-side CMS for editing GitHub Markdown (and other) files.
- [Cockpit](https://getcockpit.com/) - A self-hosted headless and api-driven CMS.
- [HeadlessCMS](https://headlesscms.org/) - A List of Content Management Systems for Jamstack Sites.
- [TakeShape](https://www.takeshape.io/) - Headless GraphQL API CMS with 1-click deploy to Netlify.
- [Ghost](https://ghost.org/) - A headless CMS for online publications
- [Strapi](https://strapi.io) - The open source Headless CMS Front-End Developers love.
- [Flotiq](https://flotiq.com) - An effortless headless CMS.
- [TreacleWP](https://www.treaclewp.com) - WordPress API hosting.
- [Agility CMS](https://agilitycms.com) - The best of both worlds for developers and content editors.
- [CloudCannon](https://cloudcannon.com/) - The Git-based CMS for your Jamstack sites.
- [Contember](https://www.contember.com) - Bespoke content management. Build and run GraphQL API and user-centric administration without any hassle.

## API

### Authentication

- [Auth0](https://auth0.com/) - Single sign on and token based authentication.
- [Netlify Identity](https://www.netlify.com/docs/identity/) - Brings a full suite of authentication functionality, backed by the [GoTrue API](https://www.gotrueapi.org).
- [Stytch](https://stytch.com) - Passwordless authentication and session management API, try it out [on Vercel](https://github.com/vercel/next.js/tree/canary/examples/auth-with-stytch).
- [Clerk](https://clerk.com) – Complete user management UIs and APIs, purpose-built for React, Next.js, and the modern web.
- [Corbado](https://www.corbado.com) – Corbado helps you go passwordless by adding passkeys to your website or app in a few lines of code.

### Comments

- [Disqus](https://disqus.com) - Global comment system that improves discussion on websites and connects conversations across the web.
- [Facebook Comments](https://developers.facebook.com/docs/plugins/comments) - The comments plugin lets people comment on content on your site using their Facebook account.
- [Utterances](https://utteranc.es/) - A lightweight comments widget built on GitHub issues. Use GitHub issues for blog comments, wiki pages and more.

### Forms

- [Fetch Forms](https://www.fetchforms.io/) - Create forms with the speed of a form builder and use them in your applications by calling a simple API.
- [Formcarry](https://formcarry.com) - Hassle-free HTML form endpoints for your form, powerful dashboard, reliable spam blocking, attachment uploads and Zapier integrations.
- [Formcake](https://formcake.com) - A form backend built for developers: Zapier integrations, zero dependencies, a simple API, and unlimited forms.
- [Getform](https://getform.io) - Form backend platform for designers and developers. Setup your form endpoints for your static site within minutes and expand your data with Zapier integration and Webhooks support.
- [Netlify Forms](https://www.netlify.com/docs/form-handling/) - Built-in form handling on building time by parsing HTML files directly at deploy time.
- [Arengu](https://www.arengu.com) - Build signup and login forms with Arengu, enable social login, add 2FA or use passwordless flows to authenticate users with your API or identity provider.
- [Static Forms](https://www.staticforms.xyz/) - Integrate HTML forms easily without any server side code. After user submits the form we'll send you content of the form to your registered email.

### E-commerce

- [Astro Snipcart](https://github.com/lloydjatkinson/astro-snipcart) - Astro Snipcart allows developers to build E-Commerce sites using the Astro framework and the Snipcart platform.
- [Flatmarket](https://github.com/christophercliff/flatmarket) - Flatmarket is a free, open source e-commerce platform for static websites.
- [GoCommerce](https://www.gocommerceapi.org) - A headless e-commerce for Jamstack sites.
- [Snipcart](https://snipcart.com/) - A powerful shopping cart platform for developers.
- [Moltin](https://moltin.com/) - eCommerce API for developers.
- [Trolley](https://trolley.link) - A shopping cart designed for the Jamstack.
- [Shopify](https://www.shopify.co.uk/plus/solutions/headless-commerce) - Shopify headless e-commerce solution.
- [Commerce.js](https://commercejs.com/) - API-first eCommerce platform for developers.
- [CartQL](https://cartql.com/) - GraphQL Shopping Cart and Checkout API built for the Jamstack and to work with any framework and inventory.
- [Medusa](https://medusajs.com/) - Medusa is an open-source headless commerce engine that enables developers to create amazing digital commerce experiences.
- [Saleor](https://saleor.io/) - Saleor is [open-source](https://github.com/saleor/saleor), GraphQL-first, technology agnostic commerce engine.

### Search

- [Algolia](https://www.algolia.com/) - The most reliable platform for building search into your business.
- [Lunr](https://lunrjs.com/) - Search made simple (on frontend).
- [CloudSh](https://cloudsh.com/) - Powerful search with a few lines of JavaScript.

### Database

- [GraphQL](https://graphql.org) - Query language for APIs and a runtime for fulfilling those queries with your existing data.
- [Graphcool](https://graph.cool) - Open-source and self-hosted backend-as-a-service to develop serverless GraphQL backends.
- [FaunaDB](https://fauna.com) - Relational NoSQL database with joins, indexes, and multi-region ACID transactions in the cloud or on-premise.
- [Fireproof](https://use-fireproof.com/) - Zero dependency, offline-capable CRDT database, runs in the browser and connects to any cloud.
- [Jexia DataSet](https://jexia.com) - REST API Schema & Schemaless cloud data storage with built-in validators, relations, aggregation functions.
- [Tigris](https://www.tigrisdata.com) - Open-source data platform with databases, automatic search indexing for real-time search, caching and real-time pub/sub.

### File management

- [Jexia FileSet](https://jexia.com) - REST API File manager for your application with indexing and extra functions.

### Automation

- [Zapier](https://zapier.com/) - Trigger actions connecting more than 1000 apps together.
- [DataFire](https://github.com/DataFire/DataFire) - DataFire is an open source framework for building and integrating APIs.

## Serverless

- [Netlify Functions](https://www.netlify.com/docs/functions/) - Netlify lets you deploy Lambda functions without an AWS account, and with function management handled directly within Netlify.
- [Amazon Lambda](https://aws.amazon.com/lambda/) - Lets you run code without provisioning or managing servers.
- Microsoft Azure
  - [Azure Functions](https://docs.microsoft.com/en-us/azure/azure-functions/) - Serverless compute service that enables you to run code on-demand without having to explicitly provision or manage infrastructure.
  - [Azure Logic Apps](https://docs.microsoft.com/en-us/azure/logic-apps/) - Simplifies building automated scalable workflows that integrate apps and data across cloud services and on-premises systems.
- Google Cloud
  - [App Engine](https://cloud.google.com/appengine/) - Serverless application that completely abstracts away infrastructure so you focus only on code.
  - [Cloud Functions](https://cloud.google.com/functions/) - Serverless environment to build and connect cloud services.
  - [Cloud Datastore](https://cloud.google.com/datastore/) - Highly-scalable NoSQL database with automatic sharding and replication.
  - [Cloud Storage](https://cloud.google.com/storage/) - Geo-redundant object storage for high QPS needs.
  - [Cloud Pub/Sub](https://cloud.google.com/pubsub/) - Geo-redundant real-time messaging for all message sizes and velocities.
  - [Apigee](https://apigee.com/) - Enterprise API management for multi-cloud environments.
  - [Endpoints](https://cloud.google.com/endpoints/) - API management apps built on Google Cloud.
  - [Cloud Dataflow](https://cloud.google.com/dataflow/) - Serverless stream and batch data processing service.
  - [BigQuery](https://cloud.google.com/bigquery/) - Serverless data warehousing services that help you to deploy advanced cloud data warehousing solutions for your enterprise.
  - [Cloud ML Engine](https://cloud.google.com/ml-engine/) - Serverless machine learning services that automatically scales built on custom Google hardware (Tensor Processing Units).
- [Serverless](https://serverless.com/) - Toolkit for deploying and operating serverless architectures.
- [Cloudinary](https://cloudinary.com/) - Serverless media (images/videos) management platform. Provides SDKs in every popular language and media widgets for Jamstack to make it easy to manage media, CDN, storage, transformations, and more.
- [imgix](https://www.imgix.com/) - Serverless image delivery and management service. imgix connects to where your images are stored (e.g. S3, GCS, web folder) and transforms, optimizes, and intelligently delivers your images using simple and robust URL parameters.
- [TwicPics](https://twicpics.com/) - Serverless images & videos optimization and transformation service. TwicPics can be plugged into any stack to optimize medias in real-time by giving full control to frontend developers.

_For a more complete list see [Awesome Serverless](https://github.com/pmuens/awesome-serverless)._

## Videos

- [The New Front-end Stack. JavaScript, APIs and Markup](https://vimeo.com/163522126) - Matt Biilmann.
- [Rise of the Jamstack](https://www.youtube.com/watch?v=uWTMEDEPw8c) - Mathias Biillman.
- [Jamstack: Silly name, serious stuff](https://www.youtube.com/watch?v=XOYtS91QWQI) - Phil Hawksworth.
- [Git-based or API-driven CMS](https://www.youtube.com/watch?v=KX4G49ZrvY0) - Chris Macrae.
- [Jamstack Tutorial - Full site using Netlify & Hugo](https://www.youtube.com/watch?v=NSts93C9UeE) - freeCodeCamp.org.
- [Gatsby JS Crash Course](https://www.youtube.com/watch?v=6YhqQ2ZW1sc) - Traversy Media.
- [How We Got Here and The Future of the Web](https://www.gatsbyjs.com/gatsby-days-keynote-kyle/) - Kyle Mathews.
- [Talks from all the Jamstack Conferences](https://www.youtube.com/channel/UC8bRyfU7ycLXnEBfvdorpUg/videos) - Jamstack Conf.
- [How I Used React, Vue, & Node to Build a Single Jamstack App](https://www.youtube.com/watch?v=dwpn1pd9kT8) - Ahmad Awais.
- [React vs Vue, Gatsby vs Gridsome - building the same site](https://www.youtube.com/watch?v=H19fF7ITtaI) - Ondrej Polesny.
- [WTF is Jamstack?](https://youtu.be/ReSvk5MQek4) - Ondrej Polesny.

## Tutorials / Articles

- [Ghost on the Jamstack](https://blog.ghost.org/jamstack/)
- [Jamstack Ecosystem](https://bejamas.io/blog/jamstack-ecosystem/)
- [Building a contact form in Gatsby using Getform](https://blog.getform.io/building-a-gatsby-contact-form-using-getform)
- [Getting Started with Gatsby and Cockpit — Part 1 of 2](https://blog.ginetta.net/getting-started-with-gatsby-and-cockpit-part-1-of-2-d86871932d44)
- [Creating Static E-commerce site with GatsbyJs](https://medium.com/@pinku1/creating-static-e-commerce-site-with-gatsbyjs-a349d7e022a)
- [For Static Sites, There’s No Excuse Not to Use a CDN](https://forestry.io/blog/for-static-sites-theres-no-excuse-not-to-use-a-cdn/)
- [E-commerce front-end for Vue.js, Nuxt.js and Snipcart](https://www.sanity.io/blog/e-commerce-vue-nuxt-snipcart)
- [Jamstack and Netlify: Do We really need another buzzword?](https://noti.st/philhawksworth/qp7jZC/jamstack-and-netlify-do-we-really-need-another-buzzword)
- [The Jamstack Startup Landscape](https://medium.com/@CRVVC/the-jamstack-startup-landscape-c06cc3cdb917)
- [How I built my blog using Gatsby and Netlify](https://blog.pavsidhu.com/how-i-built-my-blog-using-gatsby-and-netlify/)
- [Developer's Guide to Headless E-Commerce](https://snipcart.com/blog/headless-ecommerce-guide)
- [Handling Static Forms, Auth & Serverless Functions with Gatsby on Netlify](https://snipcart.com/blog/static-forms-serverless-gatsby-netlify)
- [Jamstack for Clients: Benefits, Static Site CMS, & Limitations](https://snipcart.com/blog/jamstack-clients-static-site-cms)
- [Exploring Netlify CMS, a React & Git-Based Content Management System](https://snipcart.com/blog/netlify-cms-react-git-workflow)
- [Jamstack PWA — Let’s Build a Polling App. with Gatsby.js, Firebase, and Styled-components Pt. 1](https://medium.com/@UnicornAgency/jamstack-pwa-lets-build-a-polling-app-with-gatsby-js-firebase-and-styled-components-pt-1-78a03a633092)
- [Dynamic Static Sites with Netlify and iOS Shortcuts; Use Netlify Functions, a Gulp build process and iOS Shortcuts to publish dynamic content to your static site](https://bryanlrobinson.com/blog/2018/11/12/ios-shortcuts-pushing-data-to-netlify-static-site/)
- [Gatsby for Apps](https://www.gatsbyjs.org/blog/2018-11-07-gatsby-for-apps/)
- [Turning the Static Dynamic](https://www.gatsbyjs.org/blog/2018-12-17-turning-the-static-dynamic/)
- [Going Jamstack with Netlify and Nuxt](https://blog.lichter.io/posts/going-jamstack-with-netlify-and-nuxt/)
- [Getting Started With Gridsome](https://scotch.io/tutorials/getting-started-with-gridsome)
- [The Complete Beginner's Guide to Deploying Your First Static Website to IPFS](https://interplanetarygatsby.com/ipfs-deploy/)
- [A Broad Discussion on Jamstack & E-Commerce (Podcast & Transcript)](https://snipcart.com/jamstack-ecommerce-podcast)
- [The Beginner's Guide to Static Site Generators](https://bejamas.io/blog/static-site-generators/)
- [Headless CMS Options for Your Jamstack Site](https://bejamas.io/blog/headless-cms/)
- [State of Jamstack 2020 report](https://kontent.ai/resources/state-of-jamstack-2020-report)
- [Jamify Tutorials — Publish flaring fast blogs with Gatsby and Ghost](https://www.jamify.org)
- [Why is Next.js my ultimate choice over Gatsby, Gridsome, and Nuxt?](https://kontent.ai/blog/gatsby-vs-next-gridsome-nuxt)
- [Generating a Static Site with Flask and Deploying it to Netlify](https://testdriven.io/blog/static-site-flask-and-netlify/) - Leverage the JAMstack with Python and Flask by creating a static site and deploying it to Netlify.
- [Static Site Comments: A Jamstack How-To](https://snipcart.com/blog/jamstack-static-site-comments)

## Podcasts

- [Jamstack Radio](https://www.netlify.com/tags/podcast/)
- [That's my Jamstack](https://thatsmyjamstack.com)

## Books

- [Modern Web Development on the Jamstack](https://www.netlify.com/pdf/oreilly-modern-web-development-on-the-jamstack.pdf) - By Mathias Biilmann & Phil Hawksworth (published by O'Reilly).
- [Hugo in Action](https://www.manning.com/books/hugo-in-action)
- [Jumpstart Jamstack Development](https://www.packtpub.com/web-development/jumpstart-jamstack-development) - By Christopher Pecoraro and Vincenzo Gambino
- [The Jamstack Book](https://www.manning.com/books/the-jamstack-book) - by Raymond Camden and Brian Rinaldi

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
