<div class="github-widget" data-repo="harpribot/awesome-information-retrieval"></div>
## Awesome Information Retrieval [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[![Join the chat at https://gitter.im/awesome-information-retrieval/Lobby](https://badges.gitter.im/awesome-information-retrieval/Lobby.svg)](https://gitter.im/awesome-information-retrieval/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

来自整个网络的信息检索和网络搜索资源的精选列表.
## Introduction
[Information Retrieval](https://en.wikipedia.org/wiki/Information_retrieval) 涉及为用户查询查找相关信息，范围从简单的数据库搜索领域到复杂的网络搜索（例如 - Google、Bing、Yahoo）. 目前，研究人员正在开发算法来解决 [Information Need](https://en.wikipedia.org/wiki/Information_needs) 用户，通过最大化 [User and Topic Relevance](https://en.wikipedia.org/wiki/Relevance_(information_retrieval)) 的检索结果，同时最小化 [Information Overload](https://en.wikipedia.org/wiki/Information_overload) 和检索时间.
## Contributing
请随时寄给我 [pull requests](https://github.com/harpribot/awesome-information-retrieval/pulls) 或 [电子邮件] (mailto:harshal.priyadarshi@utexas.edu) 我添加新链接. 我非常愿意接受建议和更正. 请看 [contributions guide](https://github.com/harpribot/awesome-information-retrieval/blob/master/contributing.md).


## Books
- [Introduction to Information Retrieval](http://www-nlp.stanford.edu/IR-book/)  - CD Manning、P. Raghavan、H. Schütze. 剑桥大学出版社，2008 年.（信息检索入门的第一本书）.
- [Search Engines: Information Retrieval in Practice](http://ciir.cs.umass.edu/downloads/SEIRiP.pdf)  - Bruce Croft、Don Metzler 和 Trevor Strohman.  2009 年.（对于有兴趣了解搜索引擎如何工作的读者来说是一本好书.这本书非常详细）.
- [Modern Information Retrieval](http://people.ischool.berkeley.edu/~hearst/irbook/)  - R. Baeza-Yates，B. Ribeiro-Neto. 艾迪生卫斯理出版社，1999 年.
- [Information Retrieval in Practice](http://www.search-engines-book.com/)  - B. Croft、D. Metzler、T. Strohman. 培生教育，2009 年.
- [Mining the Web: Analysis of Hypertext and Semi Structured Data](http://www.cse.iitb.ac.in/%7Esoumen/mining-the-web/)  - S. Chakrabarti. 摩根考夫曼，2002 年.
- [Language Modeling for Information Retrieval](http://www.springer.com/prod/b/1-4020-1216-0?referer=www.wkap.nl)  - WB Croft, J. Lafferty.  Springer，2003.（处理信息检索的语言建模方面.它还广泛详细介绍了该领域的概率观点，这很有趣）.
- [Information Retrieval: A Survey](http://www.csee.umbc.edu/cadip/readings/IR.report.120600.book.pdf) - Ed Greengrass，2000 年.（传统信息检索的综合调查，深度学习时代之前）.
- [Introduction to  Modern Information Retrieval](https://github.com/harpribot/awesome-information-retrieval/blob/master/ https://www.amazon.com/Introduction-Modern-Information-Retrieval-Third/dp/185604694X)  - GG 乔杜里.  Neal-Schuman，2003 年.（面向图书馆和信息研究专业的学生）.
- [Text Information Retrieval Systems](https://www.amazon.com/Information-Retrieval-Systems-Library-Hardcover/dp/0123694124)  - CT Meadow、BR Boyce、DH Kraft、CL Barry.  Academic Press，2007（图书馆/信息科学视角）.


## Courses
- [INF384H / CS395T / INF350E: Concepts of Information Retrieval (and Web Search)](http://courses.ischool.utexas.edu/Lease_Matt/2016/Fall/INF384H/) - Matthew Lease（德克萨斯大学奥斯汀分校）.
- [CS 276 / LING 286: Information Retrieval and Web Search](http://web.stanford.edu/class/cs276/) - Chris Manning 和 Pandu Nayak（斯坦福大学）.
- [CS 371R: Information Retrieval and Web Search](https://www.cs.utexas.edu/~mooney/ir-course/) - Raymond J. Mooney（德克萨斯大学奥斯汀分校）.
- [CS 172: Introduction to Information Retrieval](http://www.cs.ucr.edu/~vagelis/classes/CS172/) - Vagelis Hristidis（加州大学河滨分校）.
- [SIMS 240: Principles of Information Retrieval](http://www2.sims.berkeley.edu/academics/courses/is240/s06/) - Ray R. Larson（加州大学伯克利分校）.
- [11-442 / 11-642: Search Engines](http://boston.lti.cs.cmu.edu/classes/11-642/) - 杰米·卡兰 (CMU).
- [600.466: Information Retrieval and Web Agents](http://www.cs.jhu.edu/%7Eyarowsky/cs466.html) - David Yarowsky（约翰霍普金斯大学）.
- [CS 435: Information Retrieval, Discovery, and Delivery](http://www.cs.princeton.edu/courses/archive/spring06/cos435/) - Andrea LaPaugh（普林斯顿大学）.
- [Information Retrieval and Data Mining](https://www.mpi-inf.mpg.de/departments/databases-and-information-systems/teaching/winter-semester-201516/information-retrieval-and-data-mining/)  - 博士.  Jilles Vreeken，教授，博士. 博士格哈德·魏库姆 (MPI).
- [Coursera - Text Retrieval and Search Engines](https://www.coursera.org/learn/text-retrieval) - ChengXiang Zhai 教授（伊利诺伊大学香槟分校）.

## Software
- [Apache Lucene](http://lucene.apache.org/core/)  - 可用于测试信息检索算法的开源搜索引擎.  Twitter 使用这个核心进行实时搜索.
- [The Lemur Project](http://www.lemurproject.org) - Lemur 项目开发搜索引擎、浏览器工具栏、文本分析工具和数据资源，以支持信息检索和文本挖掘软件的研究和开发.
  - [Indri Search Engine](http://www.lemurproject.org/indri.php) - Apache Lucene 的另一个开源搜索引擎竞争对手.
  - [Lemur Toolkit](http://www.lemurproject.org/lemur.php) - 用于语言建模、过滤和分类研究的开源工具包.

## Datasets
#### Standard IR Collections
- [DBPedia](http://wiki.dbpedia.org/Downloads2015-10) - 关联数据网.
- [Cranfield Collections](http://ir.dcs.gla.ac.uk/resources/test_collections/cran/) - 这是 IR 领域的首批集合之一，但数据集对于任何统计显着性分析来说都太小，但仍然适合试点运行.
- [TREC Collections](http://trec.nist.gov/data.html)  - TREC 是大多数 IR 和 Web 搜索算法使用的基准数据集. 它有多个轨道，每个轨道都包含用于测试特定任务的数据集. 轨道以及建议的用例是：
  - [Blog](http://trec.nist.gov/data/blog.html) - 探索博客圈中的信息搜索行为.
  - [Chemical IR](http://trec.nist.gov/data/chem-ir.html) - 应对为化学 IR 构建大型化学试验台的挑战.
  - [Clinical Decision Support](http://trec.nist.gov/data/clinical.html) - 研究将医疗案例与患者护理相关信息联系起来的技术.
  - [Confusion](http://trec.nist.gov/data/confusion.html) - 学习 [Known Item Searching](http://trec.nist.gov/data/confusion/t5confusion.ps) 问题.
  - [Contextual Suggestion](http://trec.nist.gov/data/context.html) - 研究复杂信息需求的搜索技术（基于上下文和用户兴趣）.
  - [Crowdsourcing](http://trec.nist.gov/data/crowd.html) - 探索执行和评估搜索的众包方法.
  - [Enterprise](http://trec.nist.gov/data/enterprise.html) - 研究搜索组织数据.
  - [Entity](http://trec.nist.gov/data/entity.html) - 对 Web 数据执行与实体相关的搜索（查找实体及其属性）.
  - [Filtering](http://trec.nist.gov/data/filtering.html) - 鉴于稳定的信息需求，二元决定检索新传入的文档.
  - [Federated Web Search](http://trec.nist.gov/data/federated.html) - 研究各种搜索服务结果的合并性能.
  - [Genomics](http://trec.nist.gov/data/genomics.html) - 研究基因组数据和相应文档的检索效率.
  - [HARD](http://trec.nist.gov/data/hard.html) - 通过利用搜索者的上下文从文档中获得高精度检索.
  - [Interactive Track](http://trec.nist.gov/data/interactive.html) - 研究用户与文本检索系统的交互.
  - [Knowledge base acceleration](http://trec.nist.gov/data/kba.html) - 研究提高人类知识库效率的算法.
  - [Legal Track](http://trec.nist.gov/data/legal.html) - 研究对法律文件用例具有高召回率的检索系统.
  - [Medical Track](http://trec.nist.gov/data/medical.html) - 探索对患者记录数据的非结构化搜索性能.
  - [Microblog Track](http://trec.nist.gov/data/microblog.html) - 检查微博站点对实时信息需求的满意度.
  - [Million Query Track](http://trec.nist.gov/data/million.query.html) - 探索对大量查询的临时检索.
  - [Novelty Track](http://trec.nist.gov/data/novelty.html) - 调查系统定位新（非冗余）信息的能力.
  - [Question Answering Track](http://trec.nist.gov/data/qamain.html) - 超出文档检索范围的测试系统，以检索事实、列表和定义类型问题的答案.
  - [Relevance Feedback Track](http://trec.nist.gov/data/relevance.feedback.html) - 用于深入评估相关反馈过程.
  - [Robust Track](http://trec.nist.gov/data/robust.html) - 研究个别主题的有效性.
  - [Session Track](http://trec.nist.gov/data/session.html) - 开发用于测量信息需要漂移的多查询会话的方法.
  - [SPAM Track](http://trec.nist.gov/data/spam.html) - 基准垃圾邮件过滤方法.
  - [Tasks Track](http://trec.nist.gov/data/tasks.html) - 测试系统是否可以引发可能的任务，用户可能会尝试完成查询.
  - [Temporal Summarization Track](http://trec.nist.gov/data/tempsumm.html) - 开发允许用户随着时间的推移有效监控与事件相关的信息的系统.
  - [Terabyte Track](http://trec.nist.gov/data/terabyte.html) - 测试 IR 系统对大规模收集的可扩展性.
  - [Web Track](http://trec.nist.gov/data/webmain.html) - 探索一般网络搜索中常见的信息搜索行为.
- [GOV2 Test Collection](http://ir.dcs.gla.ac.uk/test_collections/gov2-summary.htm) - 这是最大的 Web 文档集合之一，由 Charlie Clarke 和 Ian Soboroff 使用 NIST 硬件和网络从政府网站抓取，然后由 Nick Craswel 格式化.
- [NTCIR Test Collection](http://research.nii.ac.jp/ntcir/data/data-en.html)  - 这是各种数据集的集合，从临时集合、中国 IR 集合、移动点击集合到医学集合. 该合集的重点主要是东亚语言和跨语言信息检索.
  - [CLIR Test Collections](http://research.nii.ac.jp/ntcir/permission/ntcir-6/perm-en-CLIR.html)  - 该数据集可用于 CJKE（中日韩英）语言之间的跨语言 IR. 它适用于以下任务：
    - 多语言 CLIR
    - CLEAR 双语
    - 单一语言 CLIR
  - [Cross Language Q&A (CLQA) dataset collection](http://research.nii.ac.jp/ntcir/permission/ntcir-6/perm-en-CLQA.html) - 它支持以下双语和单语：
    - Bi-lingua
      - 日语到英语.
      - 中文到英文.
      - 英语到日语.
      - 英文到中文.
    - 单一语言
      - 中文到中文.
      - 日语到日语.
      - 英语到英语.
  - [Advanced Cross Linugal Information Retrieval and Question Answering (ACLIA)](http://research.nii.ac.jp/ntcir/permission/ntcir-8/perm-en-ACLIA.html) - 该数据集用于跨语言问答任务，但该任务的复杂度高于 CLQA 数据集.
- [Conference and Labs of the Evaluation Forum (CLEF) dataset](http://www.clef-initiative.eu/dataset/test-collection)  - 它包含多语言文档集. 测试套件包括：
  - AdHoc - 新闻测试套件.
  - 领域特定测试套件 - 关于科学文章的集合.
  - 问答测试套件.
- [Reuters Corpora](http://trec.nist.gov/data/reuters/reuters.html)  - 语料库现在可通过 NIST 获得. 语料库包括以下内容：
  - RCV1（路透社语料库第 1 卷）- 仅包含英语新闻故事.
   - RCV2（路透社语料库第 2 卷）- 包含 13 种语言的故事（荷兰语、法语、德语、中文、日语、俄语、葡萄牙语、西班牙语、拉丁美洲西班牙语、意大利语、丹麦语、挪威语和瑞典语）. 请注意，这些故事不是平行的.
  - TRC（汤森路透文本研究合集）- 这是一个相当新的语料库，包含 1,800,370 条新闻报道，涵盖从 2008-01-01 00:00:03 到 2009-02-28 23:54:14 的时间段.
- [20 Newsgroup dataset](https://kdd.ics.uci.edu/databases/20newsgroups/20newsgroups.html) - 该数据集包含 20000 条新闻组消息.来自 20 个新闻组主题的帖子.
- [English Gigaword Fifth Edition](https://catalog.ldc.upenn.edu/LDC2011T07) - 该数据集是英文新闻专线文本数据的综合档案，包括标题、日期线和文章.
- [Document Understanding Conference (DUC) datasets](http://www-nlpir.nist.gov/projects/duc/data.html) - 过去的新闻专线/论文数据集 (DUC 2001 - DUC 2007) 可应要求提供.

#### External Curation Links
- [CMU List](http://boston.lti.cs.cmu.edu/callan/Data/#DIR)
- [Stanford List](http://nlp.stanford.edu/IR-book/html/htmledition/standard-test-collections-1.html)
- [University of Tennesse Knoxville](http://web.eecs.utk.edu/research/lsi/corpa.html)

## Talks
#### Technical Talks
- [Extreme Classification: A New Paradigm for Ranking & Recommendation](https://youtu.be/1X71fTx1LKA) - Manik Verma（微软研究院）
- [The next web](https://www.ted.com/talks/tim_berners_lee_on_the_next_web)  - Tim Berners-Lee (Ted Talk) [Tim Berners-Lee 发明了万维网. 他领导万维网联盟 (W3C)，监督 Web 的标准和开发].
- [Is Pivot a turning point for web exploration?](https://www.ted.com/talks/gary_flake_is_pivot_a_turning_point_for_web_exploration?utm_source=tedcomshare&utm_medium=referral&utm_campaign=tedspread) - Gary Flake，微软技术研究员（TED 演讲）.
- [Challenges in Building Large-Scale Information Retrieval Systems](http://videolectures.net/wsdm09_dean_cblirs/) - Jeff Dean（WSDM 会议，2009 年）.
- [Knowledge-based Information Retrieval with Wikipedia](https://youtu.be/NFCZuzA4cFc) - David Wilne（怀卡托大学，2008 年）.
- [Music Information Retrieval Using Locality Sensitive Hashing](https://www.youtube.com/watch?v=SghMq1xBJPI&list=PLdktw5AjQqP2gpQNgHRJaSgEkHiaVLfTi&index=24) - Steve Tjoa（RackSpace 开发人员）[这个演讲表明 IR 不仅仅是文本和图像].
- [The Functional Web -- The Future of Apps and the Web](https://youtu.be/u6oqr3gMyxk) - Liron Shapira（Box Tech Talk）.
- [Information Experience - Solution to Information Overload on Web](https://youtu.be/EnvtsbCfiAI) - Doug Imbruce (Techcrunch Disrupt)[Doug Imbruce is the Founder of Qwiki, Inc, a technology startup in New York, NY, acquired by Yahoo! in 2013].
- [Internet Privacy](https://youtu.be/tnsyhKHalGs) - Alma Whitten 博士（谷歌布鲁塞尔技术讲座）.


#### Philosophical Talks
- [The moral bias behind your search results](https://www.ted.com/talks/andreas_ekstrom_the_moral_bias_behind_your_search_results) - Andreas Ekström（瑞典作家兼记者，TED 演讲）.
- [Beware online "filter bubbles"](https://www.ted.com/talks/eli_pariser_beware_online_filter_bubbles?language=en) - Eli Pariser（过滤气泡的作者，TED 演讲）.
- [Think your email's private? Think again](https://www.ted.com/talks/andy_yen_think_your_email_s_private_think_again) - Andy Yen（CERN，TED 演讲）[本次演讲讨论隐私、搜索引擎侵犯的隐私以及人们如何保护隐私].
- [Do we have the right to be forgotten?](https://youtu.be/YO0lbdhF30g) - Michael Douglas [TEDx SouthBank].
- [The case for anonymity online](https://www.ted.com/talks/christopher_m00t_poole_the_case_for_anonymity_online?utm_source=tedcomshare&utm_medium=referral&utm_campaign=tedspread) - Christopher &quot;moot&quot; Poole&quot; (Ted Talks) [Christopher &quot;moot&quot; Poole 是 4chan 的创始人，4chan 是一个在线图像板，其匿名居民催生了网络上最令人困惑和最具影响力的亚文化].

## Conferences
- 网络搜索与数据挖掘会议 - [WSDM](http://www.wsdm-conference.org).
- 信息检索特别兴趣小组 - [SIGIR](http://sigir.org).
- 文本检索会议 - [TREC](http://trec.nist.gov).
- 欧洲信息检索会议 - [ECIR](http://irsg.bcs.org/ecir.php).
- 万维网大会 - [WWW](http://www.iw3c2.org).
- 信息和知识管理会议 - [CIKM](http://www.cikmconference.org).
- 信息检索评估论坛 - [FIRE](http://fire.irsi.res.in/fire/2016/home).
- 评估论坛的会议和实验室 - [CLEF](http://www.clef-initiative.eu/).
- NII 信息访问研究试验台和社区 - [NTCIR](http://research.nii.ac.jp/ntcir/index-en.html).

## Blogs
- [Information Retrieval and the Web](http://research.google.com/pubs/InformationRetrievalandtheWeb.html) - 谷歌研究.
- [IR Thoughts](https://irthoughts.wordpress.com)  - 博士埃德尔·加西亚

#### Interesting Reads 
- [Deep Neural Network Learns to Judge Books by Their Covers](https://www.technologyreview.com/s/602807/deep-neural-network-learns-to-judge-books-by-their-covers/?utm_campaign=socialflow&utm_source=facebook&utm_medium=post) - 信息提取.
- [Can Deep Learning help solve Deep Learning](http://www.theverge.com/2016/11/7/13551210/ai-deep-learning-lip-reading-accuracy-oxford) - 唇读信息检索.
- [To reduce biases in machine learning start with openly discussing the problem](https://enterprisersproject.com/article/2016/9/reduce-biases-machine-learning-start-openly-discussing-problem?sc_cid=70160000000q8YTAAY) - 相关性偏差.
- [Whoa, Google’s AI Is Really Good at Pictionary](https://www.wired.com/2016/11/woah-googles-ai-really-good-pictionary/) - 基于草图的搜索.
- [Neural Network Learns to Identify Criminals by Their Faces](https://www.technologyreview.com/s/602955/neural-network-learns-to-identify-criminals-by-their-faces/?utm_campaign=socialflow&utm_source=facebook&utm_medium=post) - 信息提取.


## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Harshal Priyadarshi](http://www.harshalpriyadarshi.com) 并且所有贡献者都放弃了该作品的所有版权和相关或邻接权.
