<div class="github-widget" data-repo="mezod/awesome-indie"></div>
## Awesome Indie [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
Resources to help independent developers make money.

Making money from your own code has never been easier, but it's still hard. Here, I try to curate a list of resources to help everyone interested in making money from their digital products get inspired and give it a try. Be it monetizing side-projects, bootstrapping business ideas, etc.

Projects don't need to be big, actually, it's better if they are not, they just need to be profitable. They might provide a passive income after the initial bulk of work, and who knows, maybe even help you reach financial independence.

Going indie does have lots of lifestyle perks :)

All these resources might help inspire you and put you on the right track but in the end what matters is to **MAKE and TRY stuff**. So devour this content responsibly :)

Contributions are more than welcome.

by **[@mezod](https://twitter.com/mezood)** (Doing things every day with **[everyday.app](https://everyday.app)**)

**Notes:**

- If [$], it means it's not free and probably means I haven't tried it but still decided to add it because of the several references.
- This repo was once [#1 on Github Trending](https://medium.com/@mezood/making-money-from-your-own-code-has-never-been-easier-but-its-still-hard-2242ddaae6a1)! :_)
- [Icepy](https://github.com/icepy) translated this repo to [Chinese](https://github.com/icepy/awesome-indie) :)

<!-- In general, I'd be wary of the several paid content-like products specially targeted to indie devs, so unless you can prove their value I'd like to keep them off of this list as much as possible. -->



### Communities
- **[IndieHackers](https://www.indiehackers.com/businesses)**

  Learn from profitable businesses and side projects. IndieHackers is probably the catalyst for this new wave of interest on making an independent income. It is a collection of interviews to successful developers about their products. IndieHackers has been especially interesting to follow since it's been an indie project itself. [Courtland Allen](https://twitter.com/csallen?lang=ca) has been very transparent about [how he built it](https://www.indiehackers.com/blog). The last news make one think that the forum/community will grow.

- **[bootstrapped.fm Forum](http://discuss.bootstrapped.fm/)**

  A forum for bootstrappers. Started in 2013 by [Ian Landsman](https://twitter.com/ianlandsman) and [Andrey Butov](https://twitter.com/andrey_butov) as a continuation to the now defunct [The Business of Software](http://discuss.joelonsoftware.com/default.asp?biz).
  
- **[##passiveincome](http://webchat.freenode.net/?channels=%23%23passiveincome&uio=d4)** on freenode 

  [Matthew Mallard](https://news.ycombinator.com/user?id=matbram) created this channel on the freenode IRC network in early 2017 and it has been pretty active and growing ever since.
  
- **[HackerNews](https://news.ycombinator.com/)**

  News for hackers, mostly technology and entrepreneurship. Not specific to indie devs but a must for everyone interested in computer science, creating products and making money. A lot of indie devs lurking around. Started by [Paul Graham](https://twitter.com/paulg) and maintained by the seed accelerator YCombinator.
  
- **[MegaMaker Club](https://megamaker.co/club/)** [$]

  Exclusive community for indie makers run by [Justin Jackson](https://twitter.com/mijustin). Currently there's a waitlist. Cost is $249 for lifetime access. I'm not a member so I can't personally endorse it. Generally, I'm skeptic on products targeting indie makers but I still found it relevant to add this specific product because of cross references. Some people might find it interesting. Feel free to reference to reviews!
  
- **[FounderCafe](https://www.foundercafe.com/)** [$]

  FounderCafe is an invite-only, online community of entrepreneurs helping each other succeed run by [Rob Walling](https://twitter.com/robwalling) and [Mike Taber](https://twitter.com/SingleFounder). $99 every 3 months. I'm not a member so I can't personally endorse it.
  
- **[Nugget.one](https://nugget.one/)** [$]

  Nugget.one focuses on helping software developers launch successful side projects. Being part of the community gives access to case studios, bi-weekly webinars and live mentoring. Run by [Justin Vincent](https://twitter.com/justinvincent). $19.99 per month.
  
- **[Makerlog](https://getmakerlog.com)**

  Makerlog is a free community of makers shipping products together. There's discussions + a task management tracker that allows you to get a streak (to keep you motivated shipping).
  
- **[Aussie Founders](https://www.aussiefounders.com.au/)**

  Aussie Founders is a free community bringing together & supporting Aussies having a go at their own business.

##### Other
- **[r/Entrepreneur](https://www.reddit.com/r/Entrepreneur/)** - Not exclusive to indies/bootstrappers but still with relevant content for us.
- **[Bootstrapped Slack](https://bootstrapped.slack.com)** ([invite here](http://www.bootstrappedchat.com/) invite link currently dead, working on it!) - Slack that probably originated from the bootstrapped.fm forum. Not really moderated.
- **[r/SideProject](https://www.reddit.com/r/SideProject/)** - Quite active
- **[Sideprojectxyz](https://sideprojectxyz.slack.com)** ([invite here](http://sideproject.xyz/)) - Slack community for people working on their side-projects.
- **[r/IndieBiz](https://www.reddit.com/r/indiebiz/)** - A subreddit for small and independent businesses.
- **[/r/EntrepreneurRideAlong](https://www.reddit.com/r/EntrepreneurRideAlong/)**
- **[Work In Progress](https://wip.chat)** [$] - A public todo list for accountability, and a [Telegram chat](https://t.me/wipchat) of 800+ makers. Freemium.
- **[r/Startups](https://www.reddit.com/r/startups/)** - Not exclusive to indies/bootstrappers but still with relevant content for us.

<!-- - lobsters -->

### Newsletters
- **[Bootstrappers.io](https://bootstrappers.io/)**

  Weekly digest of the best user-submitted articles featured on bootstrapped.io. Curated by [Darren Stuart](https://twitter.com/ninjamonk).

- **[IndieHackers](https://www.indiehackers.com/businesses)**

  Newsletter containing the newest interviews of the site and also the best threads from the forum. Normally ships on Thursdays. By [Courtland Allen](https://twitter.com/csallen?lang=ca).

- **[Indie](https://justinjackson.ca/indie/)**

  Stories, lessons, and inspiration for independent makers. By [Justin Jackson](https://twitter.com/mijustin).
  
- **[The SaaS Bootstrapper](http://thesaasbootstrapper.com/resources/)**

  Content about bootstrapping, SaaS, growth, marketing, and other startup topics curated by [Mac Martine](http://macmartine.com/).
  
- **[Hackerpreneur](https://hackerpreneur.co/)**

  For indie entrepreneurs & makers who live and work on their own terms. Every Friday, you’ll get hand-picked startup resources & essays exploring the future of work in the exponential age. By [Marc Eglon](https://twitter.com/MarcEglon).
  
- **[Bootstrap Money](https://bootstrap.money)**
  
  Weekly roundups of stories, guides and resources to help you grow your internet business. Every Friday. Free.
  Curated by [Nicolas de Thoré](https://twitter.com/ndethore)

### Podcasts

- **[Startups for the rest of us](http://www.startupsfortherestofus.com/)**

  Started in 2010 by [Rob Walling](https://twitter.com/robwalling) and [Mike Taber](https://twitter.com/SingleFounder) have covered almost everything there is to cover in micropreneurship. [Here](http://www.startupsfortherestofus.com/greatest-hits) you can find a 'best of' selection of their podcast.

- **[Product People](http://www.productpeople.tv/)**

  A podcast focused on great products and the people who make them. Since 2012. By [Justin Jackson](https://twitter.com/mijustin).

- **[bootstrapped.fm](http://bootstrapped.fm/)**

  Several different topics around bootstrapping online businesses. Started in 2013 by [Ian Landsman](https://twitter.com/ianlandsman) and [Andrey Butov](https://twitter.com/andrey_butov).
  
- **[Bootstrapped Web](http://bootstrappedweb.com)**

  "To share the lessons we learn by doing, and learn from the things that others are doing, to help us all get ahead as we bootstrap our businesses online." Since 2013 by [Brian Casel](https://twitter.com/CasJam) and [Jordan Gal](https://twitter.com/JordanGal).
  
- **[Entreprogrammers](http://entreprogrammers.com/)**

  A podcast for developreneurs. Run by [Josh Earl](https://twitter.com/josh_earl), [John Sonmez](https://twitter.com/jsonmez), [Derick Bailey](https://twitter.com/derickbailey) and [Charles Max Wood](https://twitter.com/cmaxw) since 2014.

- **[IndieHackers](https://www.indiehackers.com/businesses)**

  Podcast where [Courtland Allen](https://twitter.com/csallen?lang=ca) interviews some of the most successful indiehackers featured on the site. Started in early 2017 already has 12 episodes with great content and very carefully crafted related notes and links.
  
- **[The SaaS Bootstrapper](http://thesaasbootstrapper.com/)**

  Interviews with entrepreneurs and bootstrappers about bootstrapping, SaaS, growth, marketing, and other startup topics. By [Mac Martine](http://macmartine.com/).
  
- **[Smart Passive Income](https://www.smartpassiveincome.com/podcasts/)**

  Not really specific to developers but with great content on the several types of products to make a living online. By [Pat Flynn](https://twitter.com/patflynn).

- **[Giant Robots](http://giantrobots.fm/)**

  [Ben Orenstein](http://www.benorenstein.com/) (former growth/product lead at Thoughtbot) and [Derrick Reimer](https://twitter.com/derrickreimer) (co-founder of Drip) talk weekly about growing their SaaS businesses.
  
- **[Mixergy](https://itunes.apple.com/us/podcast/mixergy-startup-stories-1000-entrepreneurs-businesses/id348690336?mt=2)**

  Startup Interview podcast hosted by [Andrew Warner](https://twitter.com/andrewwarner), who made $1 million a month from an online greeting card business.
  
- **[How I Built This](https://www.npr.org/podcasts/510313/how-i-built-this)**

  A podcast hosted by [Guy Raz](https://twitter.com/guyraz) where startup founders tell their story.

- **[Build your SaaS](https://saas.transistor.fm/)**

  What does it take to build a SaaS in 2019? Podcast by [Jon Buda](https://twitter.com/jonbuda) and [Justin Jackson](https://twitter.com/mijustin) as they grow Transistor.fm.

### Talks

- **[David Heinemeier Hansson at Startup School 08](https://www.youtube.com/watch?v=0CDXJ6bMkMY)** by [David Heinemeier Hansson](https://twitter.com/dhh)

  Bootstrapping as the better alternative to VC funded startups.
  
- **[Tyler Tringas on Storemapper and MicroSaaS](https://www.youtube.com/watch?v=i3d1asTrWUQ)** by [Tyler Tringas](https://twitter.com/tylertringas)

  15 minutes filled with a lot of valuable information and insights where Tyler presents the concept of Micro-SaaS and tells us his story.
  
- **[Bootstrapping Side Projects To Profit by Pieter Levels](https://www.youtube.com/watch?v=m3nb_Qj3mRA)** by [Pieter Levels](https://twitter.com/levelsio)

  Probably one of the most known indie hackers of the last couple of years talks about how to turn our side-projects into profitable businesses. Very straight to the point, Pieter always provides a lot of insightful thoughts. By the way, don't get fooled by his lifestyle, his success is 500% work. 
  
- **[Marketing for Minorities](http://businessofsoftware.org/2011/03/hello-ladies-patrick-mckenzie-at-business-of-software-2010-marketing-to-minorities/)** by [Patrick McKenzie](https://twitter.com/patio11?lang=ca)

  Lightning 7-minute talk by one of the most respected indie developers. The point Patrick is trying to make, is that solo developers can target way smaller and niche markets which might have low competition and be very profitable from a solo business point of view.
  
- **[Talking about CoderPad and business at Dropbox](https://www.youtube.com/watch?v=J8UwcyYT3z0)** by [Vincent Woo](https://twitter.com/fulligin?lang=ca)

  Talk on building a successful small solo business.
  
- **[Paul Buchheit at Startup School 08](https://www.youtube.com/watch?v=EZxP0i9ah8E)**

  In this classic talk, AdSense/GMail/like button inventor explains how to listen to your users and why you should be critical of startup advice.
  
##### Other

- **[Talks from the MicroConf](https://vimeo.com/user12790628/videos)**
- **[Talks from the BaconBizConf](http://baconbiz.com/)**
- **[Talks from Business of Software](http://businessofsoftware.org/2016/07/all-talks-from-business-of-software-conferences-in-one-place-saas-software-talks/)**

### Posts

- **[I’m Launching 12 Startups in 12 Months](https://levels.io/12-startups-12-months/)** by [Pieter Levels](https://twitter.com/levelsio)

  The challenge that started it all for Pieter. It inspired me to do something similar. What matters is to create and ship a lot, learning in the process, until something is worth pushing further.

- **[Don't Call Yourself A Programmer, And Other Career Advice](http://www.kalzumeus.com/2011/10/28/dont-call-yourself-a-programmer/)** by [Patrick McKenzie](https://twitter.com/patio11?lang=ca)

  Patrick has written over 500 posts and I have obviously not read all of them, but of the many I've read, I chose this one...

- **[Running A Software Business On 5 Hours A Week](http://www.kalzumeus.com/2010/03/20/running-a-software-business-on-5-hours-a-week/)** by [Patrick McKenzie](https://twitter.com/patio11?lang=ca)

  ...and this one too :D

- **[Storemapper: Bootstrapped to $50,000/year in 2 years (with live metrics)](https://tylertringas.com/storemapper-bootstrapped-to-50000year-in-2-years-with-live-metrics/)** by [Tyler Tringas](https://twitter.com/tylertringas)

  This is just an example of a business more than one would be happy with :-) Besides liking how Tyler shares his story building Storemapper, I think he always maximizes for valuable content.

- **[Why You Should Do A Tiny Product First](https://unicornfree.com/2013/why-you-should-do-a-tiny-product-first)** by [Amy Hoy](https://twitter.com/amyhoy)

  This is the first of a series by Amy Hoy. I'll be honest, I don't even remember what this was about, just that I found it worth my time. Oh wait, yeah, Amy told me not to code, at least at first. I haven't still gotten there...

- **[The Epic Guide to Bootstrapping a SaaS Startup from Scratch — By Yourself](https://medium.com/@cliffordoravec/the-epic-guide-to-bootstrapping-a-saas-startup-from-scratch-by-yourself-part-1-4d834e1df8c1)** by [Clifford Oravec](https://twitter.com/cliffordoravec)

  Another series on what solo bootstrapping is about, with an offensive twist. 

- **[How to get more customers](https://medium.com/product-people/how-to-get-more-customers-54f64220e430)** by [Justin Jackson](https://twitter.com/mijustin).

  This is a bit of a too specific topic for this general selection of posts, but the hell, you need to read it before it's too late. Ok, I'm starting to sound marketingy :D 

- **[Indie Startups: The Ingredients of Success](https://hackernoon.com/indie-startups-the-ingredients-of-success-74531fe3a019)** by [fpgaminer](https://hackernoon.com/@fpgaminer)

  Numbers with meaning. fpgaminer analyzed all the products featured on IndieHackers, extracted some statistics and got to some conclusions. Also worth reading for the approach.

- **[What you should know as a founder of a software company](https://qotoqot.com/blog/founder-skills/)** by [Ivan Mir](https://twitter.com/ivmirx)

  A guide to the complex world of modern software business: everything from UX design to marketing and writing, with a list of resources to start with each topic.
  

##### Others
There's obviously a million posts on the topic. I'm sure this is not a good selection but it'll get you started. Here you can find some more:

- **[Bootstrappers.io](https://bootstrappers.io/)**
- **[HackerNoon](https://hackernoon.com/)**
- **[HackerNews](https://news.ycombinator.com/)**
- **[7 Articles for Indie Devs to Start Shipping](https://hackernoon.com/7-articles-for-indie-devs-to-start-shipping-12b22f5e5660)** - great selection by [Alex Moskovski](https://twitter.com/mskvsk)

### Blogs

- **[Patrick Mackenzie](http://www.kalzumeus.com/)**

  Over 500 posts that show how Patrick went from being a software engineer to running successful software businesses.
  
- **[Rob Walling](http://www.softwarebyrob.com/)**

  Lessons Learned by a Solo Entrepreneur.
  
- **[Pieter Levels](https://levels.io/)**

  Lots of advice on bootstrapping businesses if you dig between Pieter's multiple interests.
  
- **[Tyler Tringas](https://tylertringas.com/)**

  On SaaS and his journey with Storemapper.
  
- **[Joel Spolsky](https://www.joelonsoftware.com/)**

  Software and business have always been topics Joel has covered. StackOverflow and Trello prove he knows what he's talking about.
  
- **[Signal v. Noise](https://m.signalvnoise.com/)**

  The blog of the basecamp people, mostly David Heinemeier Hansson and Jason Fried, on business and how to run bootstrapped companies.
  
- **[Pinboard](https://blog.pinboard.in/)**

  Maciej Cegłowski's blog for his bookmarking tool, pinboard, useful in showing the growth of a successful solo business.
  
- **[The Bootstrapped Founder](https://thebootstrappedfounder.com/)**

  How to start, run, and sell a bootstrapped SaaS company without burning out — by Arvid Kahl
  
##### Others
  
- **[The Foundation](https://thefoundation.com/blog)** - Turning the process of creating a B2B SaaS business into a formula.
- **[Price Intelligently](http://www.priceintelligently.com/blog)** - Blog focused on the economics of the SaaS business model and SaaS pricing.
- **[Moz Blog](https://moz.com/blog)** - For anything related to SEO.
- **[Paul Graham](http://www.paulgraham.com/articles.html)** - A lot of content for big funded startups, but still relevant to bootstrappers.
- **[John O'Nolan](https://john.onolan.org/)** - Especially the older posts on how he started ghost.

### Case Studies

- **[IndieHackers](https://www.indiehackers.com/blog)**

  From capturing a trend to getting acquired in less than one year.

- **[NomadList](https://levels.io/product-hunt-hacker-news-number-one/)**

  Solving your own pain, representing a movement, moving fast and working hard by a serial bootstrapper.

- **[Bugmuncher](https://www.bugmuncher.com/blog/)**

  Transparent growth and financial reports by a solo saas founder.

- **[Basecamp](https://basecamp.com/bootstrapped)**

  A collection of bootstrapped companies by the people at 37 signals.

- **[Baremetrics](https://baremetrics.com/blog)**

  An example of riding the wave.
  
- **[Carrd.co](https://themakingof.carrd.co/#)**

  [AJ](https://twitter.com/ajlkn) writes about the making of carrd.co and the different steps that he took on the way to a successful product.
  
- **[CandyJapan](https://www.candyjapan.com/behind-the-scenes)**

  Revenue numbers and learnings from running a Japanese candy subscription box.
  
- **[Awesome Self Funded](https://github.com/awesome-self-funded/awesome-self-funded)**

  Awesome list of successful self-funded tech businesses with >$1M revenue

### Events

- **[MicroConf](http://www.microconf.com/)** [$]

  "The world's biggest conference for the world's smallest self-funded software companies". It has two editions, one more focused to starters, and another one focused on growth. Both last two days. Las Vegas. Run by [Rob Walling](https://twitter.com/robwalling) and [Mike Taber](https://twitter.com/SingleFounder).
  
- **[MicroConf Europe](http://www.microconfeurope.com/)** [$]

  MicroConf's European edition. Barcelona. Run by [Rob Walling](https://twitter.com/robwalling) and [Mike Taber](https://twitter.com/SingleFounder).
  
- **[BaconBizConf](http://baconbiz.com/)** [$]

  "An alliance for B2B bootstrappers". Philadelphia. By [Amy Hoy](https://twitter.com/amyhoy) and [Alex Hillman](https://twitter.com/alexhillman).
  
- **[StartupSchool](https://www.startupschool.org/)**

  Free event organized by seed accelerator [YCombinator](http://www.ycombinator.com/). You have to be a bit lucky to get in. Also, this suggestion goes a little bit against the idea of "bootstrapped" but YCombinator has a lot of good resources for us indie hackers!
  
##### Not specific to indie founders:

- **[Business of Software](http://businessofsoftware.org/)** [$]

  "Business of Software is not based in Silicon Valley for good reason. It is about building long term, sustainable software businesses. …a thoughtful conference, where people come to listen and learn, not self promote and shout". Boston. [Team behind BoS](http://thebln.com/team/).
  
- **[Business of Software Europe](http://businessofsoftware.eu/)** [$]

  BoS European edition. London. [Team behind BoS](http://thebln.com/team/).

- **[B2B Rocks](https://b2brocks.co/)** [$]

  "Leading conferences for B2B and SaaS startups". Popular business model for indie devs. Paris. Sydney.

- **[PeersConf](http://peersconf.com/)** [$]

  "A conference for those who make the web, and make it their business". Seattle (changes every year). By [Jessica D'Amico](https://twitter.com/justjessdc).

### Books

- **[Start Small, Stay Small](https://www.amazon.com/Start-Small-Stay-Developers-Launching-ebook/dp/B003YH9MMI/ref=sr_1_1?s=digital-text&ie=UTF8&qid=1493983910&sr=1-1&keywords=start+small+stay+small)** [$] by [Rob Walling](https://twitter.com/robwalling).
- **[Building Micro-SaaS Businesses](https://tylertringas.com/micro-saas-ebook/)** by [Tyler Tringas](https://twitter.com/tylertringas). - A collection of very well structured posts that cover the most initial struggles of an indie dev on the way to build a MicroSaaS. I can personally endorse it and I'm eager to read the yet to be written chapters :)
- **[The Single Founder Handbook](http://www.singlefounderhandbook.com/)** [$] by [Mike Taber](https://twitter.com/SingleFounder).
- **[Getting Real](https://gettingreal.37signals.com/)** by [37signals](https://37signals.com). - More focused on building web applications, I really recommend it. Short, straight to the point, very easy to read and full of valuable content.
- **[MAKE](https://makebook.io/)** [$] by [Pieter Levels](https://twitter.com/levelsio).
- **[Rework](https://37signals.com/rework)** [$] by [37signals](https://37signals.com).
- **[Just Fucking Ship](https://unicornfree.com/just-fucking-ship/)** [$] by [Amy Hoy](https://twitter.com/amyhoy) and [Alex Hillman](https://twitter.com/alexhillman).
- **[Marketing for Developers](https://justinjackson.withcoach.com/marketing-for-developers-the-book)** [$] by [Justin Jackson](https://twitter.com/mijustin).
- **[Hackers&Painters](http://www.paulgraham.com/hackpaint.html)** [$] by [Paul Graham](http://www.paulgraham.com/).
- **[The $100 Startup](http://100startup.com/)** [$] by [Chris Guillebeau](https://chrisguillebeau.com/).
- **[Technical Blogging (2nd Edition)](https://pragprog.com/book/actb2/technical-blogging-second-edition)** [$] by [Antonio Cangiano](https://antoniocangiano.com/).
- **[The Mom Test](http://momtestbook.com/)** [$] by [Rob Fitzpatrick](https://robfitz.com/).
- **[Zero to Sold](http://zerotosoldbook.com/)** [$] by [Arvid Kahl](https://thebootstrappedfounder.com/about-me/). How Arvid and his partner Danielle started, ran, and sold the bootstrapped EdTech SaaS FeedbackPanda, with everything that worked, should have worked, and didn't work.

##### Other

- **[SideProject Books](https://books.makesideproject.com/)** - Side Project Books is a curated collection of books for anyone interested in building a business on the side. By [Mubashar Iqbal](https://twitter.com/mubashariqbal)
- **[The SaaS Bootstrapper book list](http://thesaasbootstrapper.com/book-list/)** - Collection curated by [Mac Martine](http://macmartine.com/). 
- **[Badass: Making Users Awesome](https://www.amazon.com/Badass-Making-Awesome-Kathy-Sierra-ebook/dp/B00VAUIM18/ref=sr_1_1?s=books&ie=UTF8&qid=1493985078&sr=1-1&keywords=badass+kathy+sierra)** [$] by [Kathy Sierra](http://seriouspony.com/).
- **[Anything You Want](https://www.amazon.com/dp/B00SI0B5FS/ref=dp-kindle-redirect?_encoding=UTF8&btkr=1)** [$] by [Derek Sivers](https://twitter.com/sivers).
- **[Founders at Work](https://www.amazon.com/Founders-Work-Stories-Startups-Early-ebook/dp/B009IXMK4O/ref=sr_1_1?s=digital-text&ie=UTF8&qid=1493985002&sr=1-1&keywords=founders+at+work)** [$] by [Jessica Livingston](https://twitter.com/jesslivingston).
- **[SideProject Book](http://www.sideprojectbook.com/)** - [$49].

### Tools

- **[free-for-dev](https://github.com/ripienaar/free-for-dev)**

  A list of SaaS, PaaS and IaaS offerings that have free tiers of interest to devops and infradev. Very useful for bootstrappers to keep initial costs low ;) By [R. I. Pienaar](https://github.com/ripienaar/).
  
- **[Stack-on-a-budget](https://github.com/255kb/stack-on-a-budget)**

  Another list of SaaS, PaaS, and Iaas offerings that have free tiers for developers on a budget. Very useful for exploring ideas and building out proof of concept. By [Guillaume (256kb)](https://github.com/255kb/).

- **[Tools Of The Trade](https://github.com/cjbarber/ToolsOfTheTrade)**

  Spectacular list of categorized tools for developers resulting from HackerNews threads. By [Chris Barber](https://twitter.com/chrisbarber) and [Craig Davison](https://twitter.com/davisonio).

- **[awesome-selfhosted](https://github.com/Kickball/awesome-selfhosted)**

  "This is a list of Free Software network services and web applications which can be hosted locally. Selfhosting is the process of locally hosting and managing applications instead of renting from SaaS providers." Lots of salvageable software :P by [Edward D](https://github.com/Kickball).

### Courses

Again, I'm not quite fond of listing [$] products made by indie developers targeting indie developers, especially because I haven't tried them myself, but due to several references I assume they are probably worth it and some people might find value in learning about them.

- **[Marketing for Developers](https://devmarketing.xyz/)** [$]

  "An online marketing course for software developers & product people". Read some reviews [here](https://www.producthunt.com/posts/marketing-for-developers). By [Justin Jackson](https://twitter.com/mijustin).
  
- **[30x500 Academy](https://30x500.com/academy/)** [$]

  "Pick your customer. Learn how they tick. Learn what they need, want, and are ready to buy." Find reviews [here](http://codefol.io/posts/30x500-why)(good), [here](https://news.ycombinator.com/item?id=8119354)(bad) and [here](https://www.quora.com/How-do-30x500-and-How-To-Make-Your-First-Dollar-compare). By [Amy Hoy](https://twitter.com/amyhoy) and [Alex Hillman](https://twitter.com/alexhillman). 

<!-- https://www.appsumo.com/how-to-make-your-first-dollar/ -->
<!-- https://fizzle.co/ -->

## Specific topics

In the future, I'd like to have a list of resources for more specific topics or FAQs such as: 

 - 'how to get ideas'
 <!-- http://www.oppsdaily.com/ -->
 <!-- https://nugget.one/daily -->
 <!-- https://www.oppslist.com/ -->
 - 'how to find betatesters'
 - 'how to find my first 100 users'
 <!-- https://promotehour.com/ -->
 <!-- awesome places to post your startup -->
 - 'how to validate my idea'
 <!-- https://training.kalzumeus.com/newsletters/archive/validating_product_ideas -->
 - 'where to advertise my project'
 - 'what paid ads work better'
 - 'i've got 100 users, how to grow'
 - 'how do i deal with support'
 - 'types of digital products'
 - 'legal aspects'
 <!-- https://termsfeed.com -->
 - 'typical mistakes'
 <!-- https://www.47hats.com/2017/05/10/startup-mistake-1-anonymous-startup/ -->
 
Help me make a proper list of specific topics!
