<div class="github-widget" data-repo="koolamusic/awesome-imba"></div>
<p align="center">
	<a href="http://imba.io" align="center" target="_blank">
		<img width="400" src="https://raw.githubusercontent.com/koolamusic/awesome-imba/master/./logo/imba-awesome-logo.min.svg?sanitize=true">
	</a>
</p>


## Awesome Imba [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![GitHub contributors](https://img.shields.io/github/contributors/koolamusic/awesome-imba)](#contributors)

&gt; 精选的 Imba 框架、库、软件和资源列表

Imba 是一种受 Ruby 和 Python 启发的编程语言，可使用内置转译器和 webpack 加载器编译为高性能和可读的 JavaScript.





## Resources

#### Official Resources

- [Website](https://imba.io)
- [Docs](https://imba.io/docs)
- [Gitter](https://gitter.im/somebee/imba)
- [GitHub Repo](https://github.com/imba/imba)
- [GitHub Organization](https://github.com/imba)


#### Toolkits and Frameworks

- [Start Imba](https://github.com/athif23/start-imba) - 受 Create React App 和 Vue CLI 启发的用于引导 Imba 保护的工具.
- [Hello World Imba](https://github.com/imba/hello-world-imba)  - 官方 Imba“Hello World”示例. 您也可以将其用作 GitHub 模板.
- [Imba Router](https://github.com/somebee/imba-router) - Imba 的实验路由器.
- [UXA](https://github.com/somebee/uxa) - Imba 的实验框架.
- [Parcel Plugin Imba](https://github.com/imba/parcel-plugin-imba) - [Parcel Bundler](https://parceljs.org/) 启用插件 
处理 Imba 文件.
- [Material Imba](https://github.com/nathanjohnson320/material-imba) - 用 Imba 编写的 Material Design 组件.
- [Imba Inertia Adapter](https://github.com/haikyuu/imba-inertia-adapter) - 房子 [Inertia](https://inertiajs.com) 适配器.
- [Formidable](https://www.formidablejs.org/) - 用于快速 API 开发的 Imba 框架.
- [Imba Shell](https://github.com/donaldp/imba-shell) - 用于 Imba 的交互式调试器和 REPL.

#### Editor Plugins and IDEs

- [Atom](http://github.com/somebee/language-imba) - Atom 的 Imba 插件.
- [Sublime Text](http://github.com/somebee/sublime-imba) - 用于 Sublime 的 Imba 插件.
- [VSCode](http://github.com/somebee/vscode-imba) - 用于 VSCode 的 Imba 插件.


#### Guides and Tutorials

- [Official Guide](https://imba.io/guides)
- [Imba more depth Guide](https://imba.github.io/imba-guide/)
- [Hello World Imba Tutorial](https://github.com/jiggneshhgohel/hello-world-imba-tutorial) - 这是一份详细的教程，记录了使用 Node.js、Imba 和 Webpack 构建“Hello World”应用程序所采取的步骤.
- [Why is Imba so fast?](https://scrimba.com/p/pJkZsB/c6B9rAM) - 了解为什么 Imba 速度快，它是如何工作的，然后开始使用它.
- [Quick introduction to Imba Router](https://scrimba.com/playlist/pMvYcg) - 了解 imba-router 在 Imba 中的工作原理.
- [Creating a todo-list app in Imba](https://scrimba.com/p/pDzDSZ/cRvRMSB) - 了解如何使用 Imba 更快、更轻松地创建应用程序.


#### Articles

- [An Intro to Imba: the JavaScript-compatible language for lightning fast DOM updates - freeCodeCamp](https://medium.freecodecamp.org/introduction-to-imba-the-alternative-to-javascript-e2aa1e3d1769)
- [New JavaScript-based Web Language Challenges React - ADTMag](https://adtmag.com/articles/2016/01/14/imba-web-language.aspx)


## Built with Imba

#### Real World Apps

- [Scrimba](http://scrimba.com) - 交互式截屏平台 Scrimba.com 是用 Imba 编写的，包括前端和后端.
- [Iceland Fish Auction Market](https://rsf.is) - 冰岛鱼市网站.
- [GitSpeak](https://gitspeak.com) - 开发人员的项目管理工具.


#### Tools

- [html2imba](https://github.com/konsumer/html2imba) - [view online](http://konsumer.js.org/html2imba/) - 将 HTML 转换为 Imba 标签源的工具.
- [JSON pretty printer](https://github.com/taw/imba-json-beautifier) - [view online](https://taw.github.io/imba-json-beautifier) - JSON 更漂亮.
- [Monoalphabetic Cipher Decoder](https://github.com/taw/imba-monoalphabetic) - [view online](https://taw.github.io/imba-monoalphabetic) - 单字母密码解码器.
- [RegExp Explorer](https://github.com/taw/imba-regexp-explorer) - [view online](https://taw.github.io/imba-regexp-explorer) - 正则表达式工具.


#### Apps/Websites

- [Imba Todo MVC](https://github.com/somebee/todomvc-imba) - 主页 TodoMVC 示例.
- [Other Todo MVC](https://github.com/shapkarin/imba-todo) - [view online](https://shapkarin.github.io/imba-todo/) - TodoMVC 实现如下 [tastejs/todomvc](https://github.com/tastejs/todomvc) 规则.
- [Simple Todo](https://github.com/taw/imba-todo-list) - [view online](https://taw.github.io/imba-todo-list) - 更基本的待办事项列表应用程序.
- [Imba Realworld App](https://github.com/cartonalexandre/imba-realworld-example-app) - [view online](https://imba-realworld-example-app.netlify.com/) - 创建项目是为了演示一个完全成熟的全栈应用程序，它遵守 [RealWorld](https://github.com/gothinkster/realworld) 规范和API.
- [Imba HackerNews Clone](https://github.com/SamirHodzic/imba-capacitor-hn) - 用于构建 Hacker News 克隆的 Imba 和 Capacitor 的演示.
- [2048 Game](https://github.com/taw/imba-2048) - [view online](https://taw.github.io/imba-2048) - 2048 游戏.
- [Calculator](https://github.com/taw/imba-calculator) - [view online](https://taw.github.io/imba-calculator)  - 计算器.
- [Emoji Memory Game](https://github.com/taw/imba-emoji-memory) - [view online](https://taw.github.io/imba-emoji-memory) - 记忆游戏.
- [Eyes](https://github.com/taw/imba-eyes) - [view online](https://taw.github.io/imba-eyes) - 一个很酷的互动网站.
- [Fifteen Puzzle](https://github.com/taw/imba-fifteen) - [view online](https://taw.github.io/imba-fifteen) - 十五个难题.
- [Game of Life](https://github.com/taw/imba-game-of-life) - [view online](https://taw.github.io/imba-game-of-life) - 生命游戏.
- [Matrix Rain](https://github.com/taw/imba-matrix-rain) - [view online](https://taw.github.io/imba-matrix-rain) - 很酷的矩阵式下雨动画.
- [Quote Machine](https://github.com/taw/imba-quote-machine) - [view online](https://taw.github.io/imba-quote-machine) - 生成随机报价的应用程序.
- [ROT-N](https://github.com/taw/imba-rotn) - [view online](https://taw.github.io/imba-rotn) - ROOT-N 应用程序.
- [Snake Game](https://github.com/taw/imba-snake) - [view online](https://taw.github.io/imba-snake) - 蛇游戏.
- [Weather App](https://github.com/taw/imba-weather) - [view online](https://taw.github.io/imba-weather) - 天气应用.
- [Top Down Shooter](https://github.com/CassianoSF/imba-top-down-shooter) - [view online](https://cassianosf.github.io/imba-top-down-shooter/dist/index.html) - 2D僵尸射击游戏.
- [Ping CRM](https://github.com/haikyuu/perfect-stack)  - 具有登录、帐户、组织和联系人管理功能的 CRUD 应用程序. 使用 Inertia、Edgedb 和 Imba 构建


## Contribution
随时欢迎您的贡献和建议. 你在用 Imba 构建伟大的东西吗？ 欢迎与我们分享！  ：脸红：

这里是 [instructions](https://github.com/koolamusic/awesome-imba/blob/master/./CONTRIBUTING.md) . 请阅读 [Code of Conduct](https://github.com/koolamusic/awesome-imba/blob/master/.github/CODE_OF_CONDUCT.md) 以及.


## Contributors

感谢这些优秀的人（[emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore -->
<table>
  <tr>
    <td align="center"><a href="http://shapkarin.me"><img src="https://avatars1.githubusercontent.com/u/1463086?v=4" width="100px;" alt="Yury Shapkarin"/><br /><sub><b>Yury Shapkarin</b></sub></a><br /><a href="#infra-shapkarin" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=shapkarin" title="Tests">⚠️</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=shapkarin" title="Code">💻</a> <a href="#example-shapkarin" title="Examples">💡</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=shapkarin" title="Documentation">📖</a></td>
    <td align="center"><a href="http://bit.ly/2EnR6Gf"><img src="https://avatars3.githubusercontent.com/u/8960757?v=4" width="100px;" alt="Andrew Miracle"/><br /><sub><b>Andrew Miracle</b></sub></a><br /><a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=koolamusic" title="Code">💻</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=koolamusic" title="Documentation">📖</a> <a href="#review-koolamusic" title="Reviewed Pull Requests">👀</a> <a href="#tool-koolamusic" title="Tools">🔧</a></td>
    <td align="center"><a href="https://raw.githubusercontent.com/activestylus"><img src="https://avatars0.githubusercontent.com/u/285?v=4" width="100px;" alt="activestylus"/><br /><sub><b>activestylus</b></sub></a><br /><a href="#example-activestylus" title="Examples">💡</a></td>
    <td align="center"><a href="https://b1001.herokuapp.com/"><img src="https://avatars3.githubusercontent.com/u/1680341?v=4" width="100px;" alt="Nathaniel Johnson"/><br /><sub><b>Nathaniel Johnson</b></sub></a><br /><a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=nathanjohnson320" title="Documentation">📖</a> <a href="#example-nathanjohnson320" title="Examples">💡</a></td>
    <td align="center"><a href="http://imba.io"><img src="https://avatars2.githubusercontent.com/u/8467?v=4" width="100px;" alt="Sindre Aarsaether"/><br /><sub><b>Sindre Aarsaether</b></sub></a><br /><a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=somebee" title="Code">💻</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=somebee" title="Documentation">📖</a> <a href="#example-somebee" title="Examples">💡</a></td>
    <td align="center"><a href="https://keybase.io/konsumer"><img src="https://avatars1.githubusercontent.com/u/83857?v=4" width="100px;" alt="David Konsumer"/><br /><sub><b>David Konsumer</b></sub></a><br /><a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=konsumer" title="Code">💻</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=konsumer" title="Documentation">📖</a> <a href="#example-konsumer" title="Examples">💡</a></td>
    <td align="center"><a href="https://raw.githubusercontent.com/athif23"><img src="https://avatars3.githubusercontent.com/u/15215827?v=4" width="100px;" alt="At Indo"/><br /><sub><b>At Indo</b></sub></a><br /><a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=athif23" title="Code">💻</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=athif23" title="Documentation">📖</a> <a href="#design-athif23" title="Design">🎨</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://raw.githubusercontent.com/SamirHodzic"><img src="https://avatars0.githubusercontent.com/u/10077663?v=4" width="100px;" alt="SamirH"/><br /><sub><b>SamirH</b></sub></a><br /><a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=SamirHodzic" title="Code">💻</a> <a href="https://raw.githubusercontent.com/koolamusic/awesome-imba/commits?author=SamirHodzic" title="Documentation">📖</a> <a href="#example-SamirHodzic" title="Examples">💡</a></td>
  </tr>
</table>

<!-- ALL-CONTRIBUTORS-LIST:END -->

该项目遵循 [all-contributors](https://github.com/all-contributors/all-contributors) 规格. 欢迎任何形式的贡献！


## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0/)

See [https://github.com/koolamusic/awesome-imba/blob/master/LICENSE.md](https://github.com/koolamusic/awesome-imba/blob/master/LICENSE.md)
