<div class="github-widget" data-repo="victorshinya/awesome-ibmcloud"></div>
## Awesome IBM Cloud

[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
[![IBM Cloud powered](https://img.shields.io/badge/IBM%20Cloud-powered-blue.svg)](https://cloud.ibm.com)
[![LICENSE](https://img.shields.io/badge/license-CC0%201.0-white.svg)](https://github.com/victorshinya/awesome-ibmcloud/blob/master/LICENSE)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](https://github.com/victorshinya/awesome-ibmcloud/pulls)
[![Build Status](https://travis-ci.org/victorshinya/awesome-ibmcloud.svg?branch=master)](https://travis-ci.org/victorshinya/awesome-ibmcloud)

精选的 IBM Cloud SDK、开源存储库、工具、博客和其他资源的精选列表.



## Carbon Design System

*使用 IBM 构建的设计系统的附加组件、组件、图标和其他资源.*

- [carbon](https://github.com/carbon-design-system/carbon) - IBM 构建的设计系统.
- [carbon-addons-angular](https://github.com/IBM/carbon-addons-angular) - Carbon Angular 项目的通用插件.
- [carbon-addons-ics](https://github.com/carbon-design-system/carbon-addons-ics) - 用于 IBM 协作解决方案的 Carbon 插件.
- [carbon-addons-iot-react](https://github.com/IBM/carbon-addons-iot-react)  - 该库包含在所有 IBM IoT 产品之间共享的 React 组件，以统一我们的外观. 这些小部件通常基于 carbon-components-react 小部件.
- [carbon-angular-starter](https://github.com/carbon-design-system/carbon-angular-starter) - 一个简单的入门应用程序，用于使用 Carbon 组件引导应用程序.
- [carbon-badges](https://github.com/carbon-design-system/carbon-badges) - 申请碳徽章的网站.
- [carbon-charts](https://github.com/carbon-design-system/carbon-charts) - 使用 D3 和打字稿实现的可重用图表.
- [carbon-components-angular](https://github.com/IBM/carbon-components-angular) - IBM Carbon 设计系统的 Angular 实现.
- [carbon-components-react](https://github.com/carbon-design-system/carbon-components-react) - 碳设计系统的反应组件.
- [carbon-components-svelte](https://github.com/IBM/carbon-components-svelte) - 碳设计系统的巧妙实施.
- [carbon-components-vue](https://github.com/carbon-design-system/carbon-components-vue) - Carbon 设计系统的 Vue 实施.
- [carbon-design-kit](https://github.com/carbon-design-system/carbon-design-kit) - Carbon Design System 视觉资产（组件、图标、调色板、网格、模板）的版本化综合套件.
- [carbon-icons](https://github.com/carbon-design-system/carbon-icons) - Carbon 设计系统的 SVG 图标库.
- [carbon-icons-angular](https://github.com/carbon-design-system/carbon-icons-angular) - Angular 中的碳图标！
- [carbon-icons-svelte](https://github.com/IBM/carbon-icons-svelte) - 使用 Carbon Design System 的数字和软件产品图标的 Svelte 组件.
- [carbon-language-website](https://github.com/carbon-design-system/design-language-website) - IBM 设计语言网站.
- [carbon-sandbox](https://github.com/carbon-design-system/carbon-sandbox) - Carbon Components 的主题游乐场.
- [carbon-tutorial](https://github.com/carbon-design-system/carbon-tutorial) - Carbon Design System 教程的应用程序.
- [carbon-web-components](https://github.com/carbon-design-system/carbon-web-components) - Web 组件之上的 Carbon Design System 变体.
- [carbon-website](https://github.com/carbon-design-system/carbon-website) - 碳设计系统的网站.
- [gatsby-starter-carbon-theme](https://github.com/carbon-design-system/gatsby-starter-carbon-theme) - 演示 Gatsby Carbon 主题的 Gatsby 启动器.
- [gatsby-theme-carbon](https://github.com/carbon-design-system/gatsby-theme-carbon) - 以 Carbon 为灵感的 Gatsby 主题.
- [ibm-dotcom-library](https://github.com/carbon-design-system/ibm-dotcom-library) - 基于 IBM Carbon 设计系统的 IBM.com 库.
- [ibm-dotcom-library-nextjs-template](https://github.com/carbon-design-system/ibm-dotcom-library-nextjs-template) - 这是一个利用 IBMdotcom React 库的 IBMdotcom NextJS 模板.
- [ibm-dotcom-library-website](https://github.com/carbon-design-system/ibm-dotcom-library-website) - 这是 IBM.com 图书馆网站，其中包括有关 IBM.com 设计和开发的文档和指南.
- [ibm-security](https://github.com/carbon-design-system/ibm-security) - 由 IBM Security 构建的 Carbon 体验框架.

## Command Line Tools

*适用于 MacOS、Windows 和 Linux 的命令行工具.*

- [Cloud Foundry CLI](https://github.com/cloudfoundry/cli) - Cloud Foundry 的官方命令行客户端.
- [The Kui Framework for Graphical Terminals](https://github.com/IBM/kui) - 用于云原生开发的混合命令行/UI 开发体验.
- [IBM Cloud CLI Release](https://github.com/IBM-Cloud/ibm-cloud-cli-release) - 这是 IBM Cloud 的命令行客户端.
- [IBM Cloud Docker Containers](https://jjasghar.github.io/ibm-docker/) - **非官方*- 不同 Docker 容器的集合，用于与 IBM Cloud 交互.
- [Universal Command Line Interface](https://cloud.ibm.com/docs/cli/reference/ibmcloud?topic=cloud-cli-install-ibmcloud-cli#install_use) - IBM Cloud CLI 提供命令行界面用于管理 IBM Cloud 中的资源.
- [Windows 64-bit](https://clis.cloud.ibm.com/download/bluemix-cli/latest/win64) - 适用于 64 位 Windows 的命令行界面.

## Infrastructure

*使用 Softlayer 部署和管理您的应用程序.*

- [cloudland](https://github.com/IBM/cloudland) - Cloudland 是一个轻量级基础架构即服务项目，加上 OpenShift 4 平台即服务部署引擎，是一个用于管理 VM 实例、软件定义网络 (SDN) 和卷的系统框架.
- [cp4d-deployment](https://github.com/IBM/cp4d-deployment) - 这些 terraform 脚本被开发用于在公共云上部署 CloudPakforData.
- [ibm-spectrum-scale-cloud-install](https://github.com/IBM/ibm-spectrum-scale-cloud-install) - IBM Spectrum Scale 的云资源配置框架.
- [lamp-terraform-ibm](https://github.com/IBM-Cloud/LAMP-terraform-ibm) - 使用基础架构即代码自动部署环境.
- [terraform-provider-ibm](https://github.com/IBM-Cloud/terraform-provider-ibm) - Terraform IBM Cloud 提供商.
- [vision-terraform](https://github.com/IBM/vision-terraform) - 用于在 IBM Cloud 中部署的 IBM Visual Insights 示例地形模板（以前称为 IBM PowerAI Vision）.

## Platform

*使用 Cloud Foundry 部署和管理您的应用程序.*

- [charts](https://github.com/IBM/charts) - IBM/charts 存储库为 IBM 和第三方中间件提供了 helm 图表.
- [cloud-foundry](https://github.com/cloudfoundry/) - IBM 云平台即服务.
  - [binary-buildpack](https://github.com/cloudfoundry/binary-buildpack) - 将二进制文件部署到 Cloud Foundry.
  - [dotnet-buildpack](https://github.com/cloudfoundry/dotnet-core-buildpack) - Linux 上 .NET Core 的 Cloud Foundry 构建包.
  - [go-buildpack](https://github.com/cloudfoundry/go-buildpack) - 用于 Go 语言的 Cloud Foundry buildpack.
  - [ibm-websphere-liberty-buildpack](https://github.com/cloudfoundry/ibm-websphere-liberty-buildpack) - IBM WebSphere Application Server Liberty Buildpack.
  - [java-buildpack](https://github.com/cloudfoundry/java-buildpack) - 用于运行 Java 应用程序的 Cloud Foundry buildpack.
  - [nginx-buildpack](https://github.com/cloudfoundry/nginx-buildpack) - 提供 NGINX 的 Cloud Foundry buildpack.
  - [nodejs-buildpack](https://github.com/cloudfoundry/nodejs-buildpack) - 用于 Node.js 的 Cloud Foundry buildpack.
  - [php-buildpack](https://github.com/cloudfoundry/php-buildpack) - 用于 PHP 的 Cloud Foundry 构建包.
  - [python-buildpack](https://github.com/cloudfoundry/python-buildpack) - Python 语言的 Cloud Foundry buildpack.
  - [r-buildpack](https://github.com/cloudfoundry/r-buildpack) - 用于 R 的 Cloud Foundry buildpack.
  - [ruby-buildpack](https://github.com/cloudfoundry/ruby-buildpack) - 用于 Ruby、Sinatra 和 Rails 的 Cloud Foundry buildpack.
  - [staticfile-buildpack](https://github.com/cloudfoundry/staticfile-buildpack) - 将静态 HTML/JS/CSS 应用程序部署到 Cloud Foundry.
- [cloud-operators](https://github.com/IBM/cloud-operators) - IBM 公共云服务运营商.
- [cloud-pak](https://github.com/IBM/cloud-pak)  - IBM Cloud Paks 是企业级容器化软件，将容器镜像与企业功能相结合，用于在生产用例中进行部署，并集成了管理和生命周期操作. 基于产品专业知识的预配置部署、滚动升级、回滚、安全/漏洞测试等功能.
- [generator-swiftserver](https://github.com/IBM-Swift/generator-swiftserver) - Kitura REST 网络服务服务器的生成器.
- [go-cloud](https://github.com/victorshinya/go-cloud) - 用于对托管 Go 应用程序的云平台进行基准测试的 Golang 样板代码.
- [go-website](https://github.com/victorshinya/go-website) - 使用 Golang 服务器部署您的网站.
- [ibm-cloud-go](https://github.com/IBM-Cloud/bluemix-go) - 用于访问 IBM Cloud API 的 Go 库.
- [insurance-bot](https://github.com/IBM-Cloud/insurance-bot) - 基于消息的保险体验.
- [kitura](https://github.com/IBM-Swift/Kitura) - A Swift web framework and HTTP server.
- [kitura-couchdb](https://github.com/IBM-Swift/Kitura-CouchDB) - 用于 Kitura 的 CouchDB 适配器.
- [kitura-credentials](https://github.com/IBM-Swift/Kitura-Credentials) - A pluggable framework for validating user credentials in a Swift server using Kitura.
- [kitura-credentials-google](https://github.com/IBM-Swift/Kitura-CredentialsGoogle) - Kitura-Credentials 框架的插件，使用 Google 网络登录进行身份验证.
- [kitura-net](https://github.com/IBM-Swift/Kitura-net) - Kitura 网络.
- [kitura-nio](https://github.com/IBM-Swift/Kitura-NIO) - 基于 SwiftNIO 的 Kitura 网络库.
- [kitura-sample](https://github.com/IBM-Swift/Kitura-Sample) - 一个示例应用程序，展示了如何使用 Kitura 的各种功能.
- [kitura-session](https://github.com/IBM-Swift/Kitura-Session) - 使用 Kitura 在 Swift 服务器中管理用户会话的可插入框架.
- [kitura-starter](https://github.com/IBM-Cloud/Kitura-Starter) - 用于 IBM Cloud 的基于 Kitura 的服务器启动器应用程序.
- [logistics-wizard](https://github.com/IBM-Cloud/logistics-wizard) - Logistics Wizard 是一种端到端的智能供应链管理解决方案.
- [multiple-deployment-options](https://github.com/IBM-Cloud/multiple-deployment-options) - 显示如何将一项服务部署到多个部署选项.
- [node-mqtt-for-anki-overdrive](https://github.com/IBM-Cloud/node-mqtt-for-anki-overdrive) - Node.js Controller and MQTT API for Anki Overdrive.
- [swift-ubuntu-docker](https://github.com/IBM-Swift/swift-ubuntu-docker) - 与 Swift 二进制文件打包在一起的 Docker 图像.
- [swifty-request](https://github.com/IBM-Swift/SwiftyRequest) - SwiftyRequest 是一个为 Swift 构建的 HTTP 网络库.
- [watson-assistant-variables](https://github.com/IBM-Cloud/watson-conversation-variables) - 在 IBM Watson Assistant（以前称为 Conversation）服务中使用上下文变量和（系统）实体的样本.
- [webiste-base](https://github.com/victorshinya/website-base) - 使用 Node.js 服务器部署您的网站.

## Serverless

*使用 IBM Cloud Functions（基于 IBM Cloud 的 Apache OpenWhisk）部署和管理您的操作/功能.*

- [openwhisk-darkvisionapp](https://github.com/IBM-Cloud/openwhisk-darkvisionapp) - 使用 IBM Watson 和 IBM Cloud Functions 发现视频中的暗数据.
- [openwhisk-visionapp](https://github.com/IBM-Cloud/openwhisk-visionapp) - 使用 IBM Cloud Functions 构建的用于图像标记和面部检测的示例 iOS 应用程序.
- [serverless-chatbot](https://github.com/victorshinya/serverless-chatbot) - 使用无服务器服务（无服务器架构/功能即服务）构建您自己的聊天机器人.

## Data & AI

*Watson 服务的 SDK 和代码模式.*

- [assistant-simple](https://github.com/watson-developer-cloud/assistant-simple) - 演示 Watson Assistant API 的简单示例应用程序.
- [botkit-middleware](https://github.com/watson-developer-cloud/botkit-middleware) - 使用 Botkit 将 Watson Assistant Service 连接到不同聊天频道的中间件.
- [chatbot-watson-android](https://github.com/IBM-Cloud/chatbot-watson-android) - 由 Watson 服务提供支持的 Android ChatBot - IBM Cloud 上的助手、语音转文本和文本转语音.
- [discovery-nodejs](https://github.com/watson-developer-cloud/discovery-nodejs) - 这是 Watson Discovery 服务演示.
- [food-coach](https://github.com/watson-developer-cloud/food-coach) - 一个简单的示例 Web 应用程序，演示了 Watson Tone Analyzer 与 Watson Assistant 的集成.
- [ibm-watson-iot](https://github.com/ibm-watson-iot) - 围绕 IBM Watson IoT Platform 构建的代码存储库.
- [max-audio-classifier](https://github.com/IBM/MAX-Audio-Classifier) - 识别短音频片段中的声音.
- [max-audio-embedding-generator](https://github.com/IBM/MAX-Audio-Embedding-Generator) - 从音频文件生成嵌入向量.
- [max-audio-sample-generator](https://github.com/IBM/MAX-Audio-Sample-Generator) - 生成语音命令和低保真乐器样本的短音频剪辑.
- [max-base](https://github.com/IBM/MAX-Base) - 这是 IBM Model Asset Exchange 的基础镜像.
- [max-breast-cancer-mitosis-detector](https://github.com/IBM/MAX-Breast-Cancer-Mitosis-Detector) - 检测乳腺癌肿瘤细胞图像中是否存在有丝分裂.
- [max-chinese-phonetic-similarity-estimator](https://github.com/IBM/MAX-Chinese-Phonetic-Similarity-Estimator) - 估计中文单词之间的语音距离并获得发音相似的候选词.
- [max-fast-neural-style-transfer](https://github.com/IBM/MAX-Fast-Neural-Style-Transfer) - 生成一个混合了源图像内容和另一个图像风格的新图像.
- [max-human-pose-estimator](https://github.com/IBM/MAX-Human-Pose-Estimator) - 检测图像中的人并估计每个人的姿势.
- [max-image-caption-generator](https://github.com/IBM/MAX-Image-Caption-Generator) - IBM 代码模型资产交换：显示和讲述图像标题生成器.
- [max-image-colorizer](https://github.com/IBM/MAX-Image-Colorizer) - 为黑白图像添加颜色.
- [max-image-resolution-enhancer](https://github.com/IBM/MAX-Image-Resolution-Enhancer) - 将图像放大 4 倍，同时生成逼真的细节.
- [max-image-segmenter](https://github.com/IBM/MAX-Image-Segmenter) - 识别图像中的对象，另外将图像的每个像素分配给特定对象.
- [max-inception-resnet-v2](https://github.com/IBM/MAX-Inception-ResNet-v2) - 使用第三代深度残差网络识别图像中的对象.
- [max-named-entity-tagger](https://github.com/IBM/MAX-Named-Entity-Tagger) - 在文本中定位并标记命名实体.
- [max-news-text-generator](https://github.com/IBM/MAX-News-Text-Generator) - 生成类似于十亿单词数据集中新闻文章的英文文本.
- [max-nucleus-segmenter](https://github.com/IBM/MAX-Nucleus-Segmenter) - 识别显微镜图像中的细胞核并将图像的每个像素分配给特定的细胞核.
- [max-object-detector](https://github.com/IBM/MAX-Object-Detector) - 定位和识别单个图像中的多个对象.
- [max-ocr](https://github.com/IBM/MAX-OCR) - 最大光学字符识别.
- [max-question-answering](https://github.com/IBM/Max-Question-Answering) - 回答有关给定文本语料库的问题.
- [max-resnet-50](https://github.com/IBM/MAX-ResNet-50) - 使用第一代深度残差网络识别图像中的对象.
- [max-review-text-generator](https://github.com/IBM/MAX-Review-Text-Generator) - 生成类似于 Yelp® 评论数据集中文本的英文文本.
- [max-scene-classifier](https://github.com/IBM/MAX-Scene-Classifier) - 基于 Places365-CNN 模型的物理地点/位置的图像分类器.
- [max-speech-to-text-converter](https://github.com/IBM/MAX-speech-to-text-converter) - 将口语转换为文本形式.
- [max-sports-video-classifier](https://github.com/IBM/MAX-Sports-Video-Classifier) - 根据视频描述的运动对体育视频进行分类.
- [max-text-sentiment-classifier](https://github.com/IBM/MAX-Text-Sentiment-Classifier) - 检测短文本中捕获的情绪.
- [max-text-summarizer](https://github.com/IBM/MAX-Text-Summarizer) - 生成文本正文的摘要描述.
- [max-toxic-comment-classifier](https://github.com/IBM/MAX-Toxic-Comment-Classifier) - 检测用户评论中的 6 种类型的毒性.
- [max-weather-forecaster](https://github.com/IBM/MAX-Weather-Forecaster) - 根据特定位置的历史数据预测每小时的天气特征.
- [max-word-embedding-generator](https://github.com/IBM/MAX-Word-Embedding-Generator) - 从文本文件生成嵌入向量.
- [natural-language-classifier-nodejs](https://github.com/watson-developer-cloud/natural-language-classifier-nodejs) - 查看分类器服务如何使用自然语言来确定您的问题背后的意图.
- [natural-language-understanding-nodejs](https://github.com/watson-developer-cloud/natural-language-understanding-nodejs) - 自然语言理解服务的演示代码.
- [node-red-labs](https://github.com/watson-developer-cloud/node-red-labs) - Node-RED 实验室使用 Watson Developer Cloud 服务.
- [node-red-node-watson](https://github.com/watson-developer-cloud/node-red-node-watson) - IBM Watson 服务的节点集合.
- [personality-insights-nodejs](https://github.com/watson-developer-cloud/personality-insights-nodejs) - IBM Watson Personality Insights 服务的示例 Nodejs 应用程序.
- [personality-insights-python](https://github.com/watson-developer-cloud/personality-insights-python) - IBM Watson Personality Insights 服务的示例 Python 应用程序.
- [simple-chat-swift](https://github.com/watson-developer-cloud/simple-chat-swift) - 使用来自 Watson Developer Cloud Swift SDK 的认知服务的 iOS 聊天应用程序.
- [speech-javascript-sdk](https://github.com/watson-developer-cloud/speech-javascript-sdk) - 用于在 Web 浏览器中使用 IBM Watson Speech to Text 和 Text to Speech 服务的库.
- [speech-to-text-nodejs](https://github.com/watson-developer-cloud/speech-to-text-nodejs) - 用于 IBM Watson 语音转文本服务的示例 Node.js 应用程序.
- [tone-analyzer-nodejs](https://github.com/watson-developer-cloud/tone-analyzer-nodejs) - IBM Tone Analyzer 服务的示例 Node.js 应用程序.
- [visual-recognition-coreml](https://github.com/watson-developer-cloud/visual-recognition-coreml) - 使用 Watson Visual Recognition 和 Core ML 对图像进行离线分类.
- [visual-recognition-nodejs](https://github.com/watson-developer-cloud/visual-recognition-nodejs) - IBM Watson 视觉识别服务的示例 Node.js 应用程序.
- [watson-developer-cloud](https://github.com/watson-developer-cloud) - 一组使用认知计算解决复杂问题的 REST API 和 SDK.
  - [android-sdk](https://github.com/watson-developer-cloud/android-sdk) - 用于使用 IBM Watson 服务的 Android SDK.
  - [dotnet-standard-sdk](https://github.com/watson-developer-cloud/dotnet-standard-sdk) - 用于访问 Watson 服务的 .NET Standard 库.
  - [go-sdk](https://github.com/watson-developer-cloud/go-sdk) - 用于 IBM Watson 服务的 Go SDK.
  - [java-sdk](https://github.com/watson-developer-cloud/java-sdk) - 用于使用 IBM Watson 服务的 Java SDK.
  - [node-sdk](https://github.com/watson-developer-cloud/node-sdk) - ☄️ Node.js 库，用于访问 IBM Watson 服务.
  - [openwhisk-sdk](https://github.com/watson-developer-cloud/openwhisk-sdk) - 用于在 IBM Cloud Functions（基于 Apache Openwhisk）上使用 Watson Services 的 SDK.
  - [python-sdk](https://github.com/watson-developer-cloud/python-sdk) - 客户端库，用于在 Python 中使用 IBM Watson 服务，并在 pip 中作为 watson-developer-cloud 提供.
  - [ruby-sdk](https://github.com/watson-developer-cloud/ruby-sdk) - ♦️ Ruby SDK 使用 IBM Watson 服务.
  - [salesforce-sdk](https://github.com/watson-developer-cloud/salesforce-sdk) - 用于与 IBM Watson REST API 通信的 Salesforce 库.
  - [swift-sdk](https://github.com/watson-developer-cloud/swift-sdk) - Watson Swift SDK 使开发人员能够快速将 Watson 认知计算服务添加到他们的 Swift 应用程序中.
  - [unity-sdk](https://github.com/watson-developer-cloud/unity-sdk) - Unity SDK 使用 IBM Watson 服务.
- [with-watson](https://github.com/victorshinya/with-watson) - 运行 Visual Recognition 默认模型的 iOS 应用程序.
- [with-watson-custom-model](https://github.com/victorshinya/with-watson-custom-model) - 运行 Visual Recognition 自定义模型的 iOS 应用程序.
- [your-celebrity-match](https://github.com/watson-developer-cloud/your-celebrity-match) - Celebrity Match 应用程序使用 Watson Personality Insights Service 和 Twitter 数据来识别 Twitter 上的名人，这些名人的推文在概念上最接近您的推文.

## Resources

*用于了解有关 IBM Cloud 和服务的更多信息的资源列表.*

- [API Docs](https://cloud.ibm.com/apidocs) - API 文档列出了 IBM Cloud 支持的 API 的文档.
- [Documentation](https://cloud.ibm.com/docs) - 阅读服务文档了解有关特定服务的更多信息.
- [Enterprise Design Thinking](https://www.ibm.com/design/thinking/) - 将设计思维应用于复杂的团队、问题和组织.
- [Getting Started with IBM Cloud](https://cloud.ibm.com/docs/overview?topic=overview-whatis-platform) - 什么是 IBM Cloud 平台？
- [IBM Cloud Architecture Center](https://www.ibm.com/cloud/architecture/architectures)  - IBM 的架构提供了在云上构建应用程序的实践. 参考架构定义了基本模式，而实现则提供了特定的技术、实践和工具选择来构建和部署该模式.
- [IBM Cloud Blog](https://www.ibm.com/blogs/bluemix) - IBM Cloud 的操作方法、新闻和公告.
- [IBM Cloud Favorites](https://ibm.biz/ibmcloudhelp) - 有关 IBM Cloud Platform 的链接和资源列表.
- [IBM Cloud Stencils](https://github.com/ibm-cloud-architecture/ibm-cloud-stencils) - IBM Cloud Stencils，用于使用流行的图表工具创建 IBM Cloud 图表.
- [IBM Cloud What's new](https://www.ibm.com/cloud-computing/learn-more/new/) - 了解最新的 IBM Cloud 产品和服务.
- [IBM Demos](https://www.ibm.com/demos/) - IBM Demos 是探索、学习和试用各种 IBM 产品和解决方案的首选目的地.
- [IBM Developer Brasil on Medium](https://medium.com/ibmdeveloperbr) - 巴西葡萄牙语版的 IBM Cloud 平台及其服务的操作方法和学习.
- [IBM Developer Website](https://developer.ibm.com)  - 全球编码员社区. 查找开源程序、代码模式、文章、教程和其他内容.
- [IBM Garage Methodology](https://www.ibm.com/garage/method)  - IBM Garage 的基础是一种独特的方法论，它以只有 IBM 才能带来的丰富经验来管理行业最佳实践.  IBM Garage 与 IBM Garage Methodology 相结合可以推动前所未有的转型变革.
- [IBM Watson on Medium](https://medium.com/ibm-watson) - IBM Watson on Medium 的操作方法、新闻和公告.
- [My Catalog](http://mycatalog.mybluemix.net/) - IBM Cloud 目录的另一种非官方视图，对于想要获得强大的基于过滤器的视图的架构师特别有用.

## YouTube Channels

*观看并了解有关 IBM Cloud 和服务的更多信息.*

- [Digital Technical Engagement](https://www.youtube.com/channel/UCrVRMfpe968pW8vBU_hzplA)  - 云产品演示. 有关更多信息，请查看<http://ibm.biz/dte-live> .
- [IBM Cloud](https://www.youtube.com/ibmcloud)  - 通往云的道路比您想象的要快. 加入为您的企业构建的云，它拥有使人工智能成为现实的工具、数据和 API. 这是你的云. 我们保护它. 你控制它.
- [IBM Developer](https://www.youtube.com/channel/UCUm6InQvGI9-6vo1teGWINA) - 开源技术、学习资源以及与我们的专业开发者倡导者的本地聚会.
- [IBM Watson](https://www.youtube.com/channel/UCxPJljXUHvUd9idyfEHvXqg) - 使用 Watson 服务的教程、开发人员工具包、教育剪辑、活动回顾等.
- [IBM Watson Internet of Things](https://www.youtube.com/channel/UCFNoGF7Ea-FfmAjfK4ReFpA) - 有关 Watson 服务和 IoT 平台的视频、访谈、教育剪辑等.

## Twitter Accounts

- [IBM](https://twitter.com/IBM)  - 与我们的客户一起，我们正在使用人工智能、云、区块链和物联网等技术来改变商业、行业和世界. 让我们让智能发挥作用.
- [IBMorg](https://twitter.com/IBMorg) - IBM’s approach to corporate responsibility reflects our business — applied technology, continuous transformation, and sustainable change. #GoodTechIBM.
- [IBM Accessibility](https://twitter.com/IBMAccess)  - 官方 IBM Accessibility Twitter 帐户. 此帐户遵循 IBM 社交计算指南.
- [IBM Blockchain](https://twitter.com/IBMBlockchain) - Official Twitter of #IBM #Blockchain. All blockchain all the time. DMs are open. Run by Kyle Schlapkohl & Bret Bardeli.
- [IBM Cloud](https://twitter.com/IBMcloud) - Built for your business, #IBMCloud has the tools, data & APIs to make AI real now. Follows IBM Social Computing Guidelines.
- [IBM Data and AI](https://twitter.com/IBMData) - The IBM tools, resources and industry news you need to get the most value from your #data and make it truly #AI-ready. For Support: <https://ibm.com/mysupport>.
- [IBM Design](https://twitter.com/ibmdesign)  - 在 IBM，设计不仅仅是一份工作——它是对我们所服务的人的一种深刻责任. 由 @willfanguy 根据 IBM 指南管理.
- [IBM Developer](https://twitter.com/IBMDeveloper) - Open source, code patterns, tutorials, meet-ups, challenges, & a global coding community— #IBMDeveloper has it all in one place. #AI #Cloud #Blockchain.
- [IBM FinTech](https://twitter.com/IBMFinTech)  - ️Ⓜ 由 Claudia Masseo 管理的官方帐户. 关于监管科技、支付、SPM、保险和银行业的所有最新信息……
- [IBM Industries](https://twitter.com/IBMindustries)  - 立即下载工业杂志第 8 期：<https://ibm.co/industrious>  .
- [IBM iX](https://twitter.com/IBM_iX)  - 我们设想未来的业务——并帮助我们的客户将其变为现实. 遵循 IBM 社会指南.
- [IBM Live](https://twitter.com/ibmlive) - Your home for #IBM's immersive event experiences. Learn more about our upcoming worldwide events. Managed by Rafiat K and Ixel M. Follows IBM Social Guidelines.
- [IBM News Room](https://twitter.com/IBMNews)  - 关于 IBM 的业务、技术和人员的所有新消息和值得注意的官方中心. 帐户遵循 IBM 社交计算指南.
- [IBM Policy](https://twitter.com/IBMpolicy)  - IBM 政府与监管事务和 IBM 政策实验室的官方帐户. 关于技术和创新政策问题的推文. 由 Adam Pratt 和 Ashley Bright 管理.
- [IBM Power Systems](https://twitter.com/IBMPowerSystems) - Official Twitter account for IBM Power Systems—built to crush the most advanced data applications from mission-critical workloads to the next generation of #AI.
- [IBM Research](https://twitter.com/IBMResearch)  - 这是 IBM Research 的官方 Twitter ID. 该帐户由 Chris Sciacca 管理，并遵循 IBM 社交计算指南.
- [IBM Security](https://twitter.com/IBMSecurity)  - 我们保护业务，让您在面对网络不确定性的情况下自由发展. 如需支持，@AskIBMSecurity. 遵循 IBM 社交计算准则.
- [IBM Sports & Entertainment](https://twitter.com/IBMSports) - Official IBM Twitter account. Managed by Noah Syken and Elizabeth O'Brien. Follows the IBM Social Computing Guidelines. #IBMsports.
- [IBM Sterling Supply Chain](https://twitter.com/IBMSupplyChain) - #SupplyChain and #B2BCollaboration news & innovation from #IBMSterling. We help you build smarter business networks. Follows IBM Social Computing Guidelines.
- [IBM Storage](https://twitter.com/IBMStorage) - 利用业界最广泛的存储解决方案组合之一捕捉数据的力量，跨多云和 AI 环境统一、管理和保护数据.
- [IBM Systems](https://twitter.com/IBMSystems) - From servers and mainframes to storage systems and software, IBM provides the building blocks of a next-gen #ITinfrastructure that empowers your enterprise.
- [IBM thinkLeaders](https://twitter.com/IBMthinkLeaders)  - 数字时代转型与创新的思想领导力. 查看我们的播客：<https://ibm.biz/thinkpoditunes>  .
- [IBM Watson](https://twitter.com/IBMWatson) - Watson 是为专业人士设计的 AI，专为您的业务而设计.
- [IBM Watson Commerce](https://twitter.com/ibmcommerce)  - HCL Technologies 收购了多个 IBM Commerce 解决方案. 了解更多：<https://ibm.co/2Jm59iP>  .
- [IBM Watson Health](https://twitter.com/IBMWatsonHealth) - Watson Health is Smarter Health – Using data, analytics and #IBM technologies and services to help make smarter health a reality.
- [IBM Watson IoT](https://twitter.com/IBMIoT) - Intelligence is your greatest asset. Follow us for the latest on insightful #IIoT solutions using #AI. Official IBM #IoT, managed by @theRab & @graemeknows.
- [IBM Watson Media](https://twitter.com/IBMWatsonMedia) - IBM Watson Media 利用行业领先的 AI 来发现深入的视频洞察，提高内容价值和性能，并提供卓越的观看体验.

## Meetups

- [Amsterdam, Netherlands - IBM Cloud - Benelux](https://www.meetup.com/IBM-Cloud-Benelux/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business in the Benelux region. Meetups will be organized in one or more cities in Belgium, Luxembourg and The Netherlands. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Atlanta, GA - IBM Cloud - Atlanta](https://www.meetup.com/IBM-Cloud-Atlanta/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Austin, TX - IBM Developer Austin](https://www.meetup.com/IBM-Developer-Austin/) - IBM Developer 是一个资源平台，可帮助您进一步开发应用程序！
- [Bangalore, India - Blockchain, Data Science & Cloud - Technology Meetup](https://www.meetup.com/Blockchain-Data-Science-Cloud-Technology-Meetup/)  - 这个聚会小组是为有抱负和崭露头角的开发人员准备的，他们愿意在区块链、数据科学、云和人工智能上进行编码. 也可以加入学习云上的新技术和新兴技术.
- [Bangalore, India - IBM DevConnect Bangalore](https://www.meetup.com/IBMDevConnect-Bangalore/) - 一个与对最新的云、人工智能和数据感兴趣的开发人员联系的小组.
- [Bangkok, Thailand - IBM Developer Thailand: Meetup Group](https://www.meetup.com/IBM-Developer-Thailand/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Beijing, China - IBM Developer (BeiJing)](https://www.meetup.com/IBM-Developer-BeiJing/) - 这是为会见正在编写代码、对人工智能、区块链、云、数据科学等技术感兴趣的北京开发人员而设的.我们定期会面以共享代码，帮助您加速构建您的应用程序.
- [Berlin, Germany - IBM Developer](https://www.meetup.com/IBM-Developer-Berlin/) - 欢迎来到 IBM Developer 聚会！
- [Bordeaux, France - IBM Cloud Bordeaux Meetup](https://www.meetup.com/IBM-Cloud-Bordeaux-Meetup/) - 该小组面向对支持云的创新能力感兴趣的任何人.
- [Boston, MA - IBM Cloud - Boston](https://www.meetup.com/IBM-Cloud-Boston/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Bucharest, Romania - IBM Developer Romania](https://www.meetup.com/IBM-Developer-Romania/) - 如果您对云计算、认知技术、物联网、区块链或开源软件感兴趣，请加入我们.
- [Buenos Aires, Argentina - Meet and Think by IBM](https://www.meetup.com/Meet-Think-by-IBM/) - 开放小组交流人工智能（机器学习、深度学习）、云计算、物联网、网络安全等领域的知识、良好实践、创新思想和发展！
- [Cairo, Egypt - IBM Developer Egypt](https://www.meetup.com/IBM-Developer-Egypt/) - This is a meetup group for developers, architects, and Cloud enthusiasts. We learn all about IBM Cloud, Watson, Microservices, IoT, Data Science & Blockchain. Our meetups are free.
- [Casablanca, Morocco - IBM Developer Morocco](https://www.meetup.com/IBM-Developer-Morocco/)  - 在 IBM Developer &amp; Startup Meetup Group，我们将分享我们对技术和创业的热情. 我们是开发人员和科技初创公司的倡导者团队，他们努力解决当今的问题，激发创新并创造令人惊叹的事物.
- [Chennai, India - Chennai CodeWeekend Meetup](https://www.meetup.com/Chennai-CodeWeekend-Meetup/)  - 这个小组是为开发商和钦奈的开发商而设的. 创建这个小组的目的是让钦奈的开发人员能够使用新兴的和颠覆性的信息技术.
- [Chicago, IL - IBM Cloud - Chicago](https://www.meetup.com/IBM-Cloud-Chicago/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Copenhagen, Denmark - IBM Cloud - Copenhagen](https://www.meetup.com/IBM-Cloud-Copenhagen/) - Dette er en gruppe for alle interesserede der vil lære mere om #IBMCloud, "the cloud built for business". Du er enten en eksisterende #IBMCloud-bruger eller har aldrig været i berøring med #IBMCloud før. Meetup emnerne vil variere og er typisk af interesse for udviklere, administratorer eller forretningsledelse.
- [Dallas, TX - IBM Cloud - Dallas](https://www.meetup.com/IBM-Cloud-AI-IoT-Data-Science-Blockchain/)  - 这是一个针对 DFW 地区的人工智能、数据科学、物联网、区块链和云感兴趣的任何人的小组. 欢迎所有技能水平. 我们将有许多关于这些主题的系列. 有时我们会专注于高层次的业务和战略，有时我们会非常亲力亲为并深入细节. 我们还将邀请 IBM 和 Industry 演讲者进行专题演讲.
- [Denver, CO - IBM Cloud Denver](https://www.meetup.com/IBM-Cloud-Denver/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Detroit, MI - IBM Cloud - Detroit](https://www.meetup.com/IBM-Cloud-Detroit/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Dubai, U.A.E. - IBM Developer Dubai](https://www.meetup.com/IBMDeveloper-Dubai/) - 这是一个面向开发人员、架构师和云爱好者的聚会小组.
- [Dubai, U.A.E. - IBM Tech@Home MEA](https://www.meetup.com/IBM-Cloud-MEA/)  - 这是一个面向任何有兴趣了解 IBM Cloud 和认知软件的人的小组. 您可以是熟悉的用户，也可以是以前从未使用过 IBM 软件的人.  Meetup 主题会有所不同，并且可能会引起开发人员、管理员或业务负责人的兴趣.
- [Dublin, Ireland - IBM Cloud Dublin](https://www.meetup.com/IBM-Cloud-Dublin/)  - 这个聚会小组面向开发人员、架构师和所有 IBM Cloud 爱好者. 我们与其他开发人员一起亲身体验 IBM Cloud.
- [Frankfurt, Germany - Meet and Think@IBM Rhein-Main](https://www.meetup.com/meet-and-think-at-ibm/) - 与 IBM 专家和嘉宾会面，讨论 IBM 的最新技术和创新.
- [Göteborg, Sweden - IBM TechTalks & Labs Gothenburg](https://www.meetup.com/IBM-techtalksandlabs-gbg/) - 加入我们的一系列实践研讨会 (BYOD*) 和各种技术的技术讲座！
- [Gurgaon, India - IBM cloud developer's ecosystem Delhi NCR](https://www.meetup.com/IBM-cloud-developers-ecosystem-Delhi-NCR/)  - 学习具有共同兴趣领域的尖端技术的社区. 这个小组是为喜欢探索 IaaS/PaaS、容器、Kubernetes、DevOps、人工智能和其他在云平台上运行的微服务等技术领域的技术爱好者创建的.
- [Hong Kong, Hong Kong - AI/Blockchain/Cloud/BigData Meetup by IBM HK](https://www.meetup.com/Hong-Kong-Artificial-Intelligence-Meetup-Group/) - 这个小组适合任何想了解 ABCD、人工智能、区块链、云和大数据最新趋势的人.
- [Hong Kong, Hong Kong - IBM Cloud - Hong Kong](https://www.meetup.com/IBM-Cloud-Hong-Kong/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Hyderabad, India - Hyderabad CodeWeekend](https://www.meetup.com/codeweekend/)  - 朋友你好，这个群是开发商给开发商的. 对于热衷于学习人工智能、深度学习、机器学习、区块链、物联网、微服务、Docker、函数等新技术的人来说，这是一个完美的地方. 我们每个月就上述任何技术举行一次聚会.
- [Islamabad, Pakistan - IBM Developer Islamabad](https://www.meetup.com/IBM-Developer-Islamabad-Meetup/)  - 这是一个面向开发人员、架构师和云爱好者的聚会小组. 我们全面了解 IBM Cloud、Watson、IoT、数据科学和区块链. 我们的聚会是免费的.
- [Istanbul, Turkey - IBM Developer Turkey](https://www.meetup.com/IBMDeveloperTR/) - 欢迎来到 IBM Developer Turkey 活动公告页面！
- [Johannesburg, South Africa - IBM Cloud - South Africa](https://www.meetup.com/ZA-IBMCloud/) - 面向开发人员、架构师、PaaS 和 Cloud Foundry 爱好者，我们通过动手演示和讨论了解 IBM Cloud.
- [Karachi, Pakistan - IBM Developer Karachi](https://www.meetup.com/IBMKarachi/)  - 这是一个面向开发人员、架构师和云爱好者的聚会小组. 我们全面了解 IBM Cloud、Watson、IoT、数据科学和区块链. 我们的聚会是免费的.
- [Kuala Lumpur, Malaysia - IBM Cloud - Malaysia](https://www.meetup.com/IBM-Cloud-Malaysia/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Las, Nigeria - IBM Developer Nigeria](https://www.meetup.com/IBM-Developer-Nigeria/) - 召集所有有兴趣聚在一起交流想法和学习新技术的开发人员、初创公司和企业家，例如认知计算、物联网、区块链、人工智能、机器学习、数据分析和云.
- [Lima, Peru - IBM Developers Perú](https://www.meetup.com/IBM-Developers-Peru/)  - 这是一个由秘鲁 IBM 赞助的聚会. 它面向开发人员、架构师和所有想要以动手模式开始测试此解决方案的 IBM Cloud 爱好者.
- [London, United Kingdom - IBM Cloud - London](https://www.meetup.com/IBM-Cloud-London/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Madrid, Spain - Meetup para desarrolladores Cloud](https://www.meetup.com/desarrolladores-cloud-meetup/)  - 本次聚会面向开发人员、架构师、学生和所有 PaaS 和 Cloud Foundry 爱好者，以及一般开发人员. 该小组的目标是展示云平台等的能力（<http://ibm.biz/BluemixES>  ) 以一种非常实用的方式.
- [Melbourne, Australia - IBM Cloud - Melbourne](https://www.meetup.com/IBM-Cloud-Melbourne/)  - 墨尔本 ️☁️ 聚会是开发人员、工程师、建筑师、设计师和其他人交流和讨论技术的地方. 涵盖认知计算、物联网、区块链、人工智能、机器学习、数据分析、开源等主题.
- [México City, Mexico - IBM Cloud - Mexico](https://www.meetup.com/IBM-Cloud-Mexico/) - Este es un grupo para personas interesadas en aprender acerca de #IBMCloud, la nube construida para el negocio. Usted puede ser un usuario de #IBMCloud o alguien que nunca ha estado en contacto con #IBMCloud anteriormente.
- [México City, Mexico - IBM Developer Mexico](https://www.meetup.com/ibmdevelopermexico/)  - “一台机器可以完成 50 个普通人的工作.没有一台机器可以完成一个非凡人的工作.” 加入这次聚会，我们将在会上尝试弄清楚如何使用新兴技术来解决我们国家和其中公司面临的最复杂的挑战. 我们将分享成功和失败的故事，伴随着流动的灵感，无论是清晰的还是黑暗的.
- [Milano, Italy - IBM Cloud Italia](https://www.meetup.com/IBM-Cloud-Italia/) - Questo è un gruppo dedicato a chi vuole apprendere cos'è il Cloud di IBM, il Cloud nato per il business. Si rivolge a chi è gia un utente #IBMCloud o a chiunque non abbia precedente esperienza di #IBMCloud. Gli argomenti del Meetup sono vari e di interesse per sviluppatori, amministratori IT o utenti business.
- [Minneapolis, MN - IBM Cloud - Minneapolis / St. Paul](https://www.meetup.com/IBM-Cloud-Minneapolis-St-Paul/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Montevideo, Uruguay - IBM Developers Montevideo Meetup](https://www.meetup.com/IBM-Developers-Montevideo/)  - 这是由 IBM 乌拉圭赞助的聚会. 它面向开发人员、架构师和所有想要以动手模式开始测试此解决方案的 IBM Cloud 爱好者.
- [Montpellier, France - Client Center Montpellier - Cognitive, Big Data, Cloud](https://www.meetup.com/Client-Center-Montpellier-Cognitive-BigData-Cloud/) - 客户中心蒙彼利埃是一个全球能力中心，专家和架构师团队可以访问最新的 IT 技术，为大数据、人工智能 (AI)、分析、区块链、云和其他开源解决方案提供解决方案.
- [Mumbai, India - Mumbai BlockChain Meetup](https://www.meetup.com/Mumbai-BlockChain-Meetup/) - 云计算·货币·IBM·PaaS（平台即服务）·比特币·加密货币·比特币矿工·去中心化系统·BlueMix·比特币安全·IBM Bluemix·区块链.
- [New York, NY - IBM Cloud - New York](https://www.meetup.com/IBM-Cloud-New-York/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [New York, NY - IBM Developer New York](https://www.meetup.com/ibmcodenyc/) - IBM Developer 是一个资源平台，可帮助您进一步开发应用程序！
- [Nice, France - IBM Cloud Côte d'Azur Meetup](https://www.meetup.com/IBM-Cloud-Cote-d-Azur-Meetup/) - 该小组面向所有对在 IBM® Cloud 上学习和开发应用程序充满热情的初学者、开发人员、主题专家、IT 顾问和研究人员.
- [Oslo, Norway - IBM TenkTorsdag](https://www.meetup.com/IBM-TenkTorsdag/)  - 数字化的发展速度比以往任何时候都快，忽视市场趋势可能是致命的. 以此为背景，在这个小组中，我们将讨论趋势，以及这对您的业务有何影响.
- [Paris, France - IBM Cloud Paris Meetup](https://www.meetup.com/IBM-Cloud-Paris-Meetup/) - 该小组面向所有对在 IBM® Cloud 上学习和开发应用程序充满热情的初学者、开发人员、主题专家、IT 顾问和研究人员.
- [Perth, Australia - IBM Cloud - Perth](https://www.meetup.com/IBM-Cloud-Perth/)  - 珀斯 ️☁️ 聚会是开发人员、工程师、建筑师、设计师和其他人交流和讨论技术的地方. 涵盖云、应用程序现代化、物联网、区块链、人工智能、机器学习、数据分析、开源等主题.
- [Pune, India - Cloud Pune Meetup](https://www.meetup.com/Cloud-Pune-Meetup/)  - 这是一个针对任何有兴趣了解云解决方案平台即服务 (PaaS) 的人的小组. 我成立这个小组是为了结识初创公司、学术界、开发人员和云爱好者. 很期待见到你.
- [Riyadh, Saudi Arabia - IBM Developer KSA](https://www.meetup.com/IBM-Developer-KSA/)  - 好奇的？ 爱学习？ 一直在寻找更好地工作的方法？ 那么这个聚会小组就是为你准备的.
- [San Francisco, CA - IBM Cloud - San Francisco](https://www.meetup.com/IBM-Cloud-San-Francisco/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [San Francisco, CA - IBM Developer SF Bay Area](https://www.meetup.com/IBM-Developer-SF-Bay-Area-Meetup/) - 召集所有有兴趣聚在一起交流想法和学习新技术的开发人员和企业家，例如认知计算、物联网、区块链、人工智能、机器学习、数据分析和云.
- [Santiago, Chile - IBM Cloud](https://www.meetup.com/meetup-group-fFKMjMnd/) - 该小组的目标是以非常实用的方式向学生、开发人员、IT 专业人员和所有云爱好者或想要了解这些有趣主题（云、DevOps、虚拟化、Watson、物联网、数据科学和区块链）.
- [São Paulo, Brazil - Bluetalks](https://www.meetup.com/bluetalks/)  - Bluetalks 是关于技术、创新、创业和多样性的丰富讨论的聚会. 敞开心扉接受当前问题的颠覆和新观点，并以开放的心态与我们一起投入.
- [São Paulo, Brazil - Comunidade IBM Cloud Brasil](https://www.meetup.com/Comunidade-IBM-Cloud-Brasil/) - Software developers, IT Architects, Cloud administrators, Full-stack developer, IT Manager, IT Leaders, Cloud Leadership, Business Development.
- [São Paulo, Brazil - Iniciativa Z](https://www.meetup.com/iniciativaz/)  - 我们的目标是创建巴西最大的大型机社区. 通过这个小组，我们希望传播与大型机相关的所有内容、生成内容、宣传机会、举办活动并鼓励经验丰富的专业人士与我们正在开发的新一代大型机之间建立联系.
- [Seoul, Korea (South) - IBM Cloud - Korea](https://www.meetup.com/IBM-Cloud-Korea/) - 本次会议向任何想要了解如何使用 IBM Cloud 开展业务的人开放.
- [Seoul, Korea (South) - IBM Developer Meetup](https://www.meetup.com/IBM-developerWorks-Meetup/)  - IBM Developer Meetup 是每月一次的会议，开发人员聚集在一起并动手实践/练习可以在 IBM Cloud 上运行的各种主题的技术. 主题和时间表将在此聚会页面上更新.
- [Shenzhen, China - IBM Developer (ShenZhen)](https://www.meetup.com/IBM-Developer-shenzhen/) - 专为正在编码、对人工智能、区块链、云、数据科学等技术感兴趣的深圳开发者而设.我们定期聚会以共享代码，帮助开发者加速构建应用程序.
- [Singapore, Singapore - IBM Cloud Singapore](https://www.meetup.com/IBM-Cloud-Singapore/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Stockholm, Sweden - IBM Cloud & Cognitive - Stockholm](https://www.meetup.com/IBM-Cloud-Stockholm/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Stockholm, Sweden - IBM TechTalks & Labs STHLM](https://www.meetup.com/IBM-techtalksandlabs/) - 加入我们的一系列实践研讨会 (BYOD*) 和各种技术的技术讲座！
- [Stockholm, Sweden - Towards the Tech of Tomorrow](https://www.meetup.com/Towards-the-Tech-of-Tomorrow/)  - 你有没有想过你的数字音乐服务是如何推荐一首完全符合你口味的新歌的？ 您是否对加密货币的影响感到困惑并想了解底层区块链技术？ 您是否对云的概念感兴趣？ 最有价值数据的抽象物理位置？
- [Sydney, Australia - Sydney IBM Coders Meetup Group](https://www.meetup.com/Sydney-IBM-Coders-Meetup/)  - 悉尼 IBM Coders 聚会小组的存在是为了帮助悉尼开发人员、工程师、架构师和中间的每个人更好地了解 IBM 的公共云产品. 我们鼓励我们的所有成员展示我们的会议，并旨在将我们的会议分散到 IBM Cloud 产品的范围内，讨论以开发人员为中心和以基础架构为中心的主题.
- [Taipei, Taiwan - IBM Cloud Taiwan](https://www.meetup.com/IBM-Cloud-Taiwan/) - 這是一個為想學習為#IBMCloud 的任何人所建的群組。您可能是＃IBMCloud的既有用戶，或從未曾接觸過＃IBMCloud。Meetup的主題包羅萬象, 且主要對象可能包涵開發者、管理員或是業務領袖.
- [Tel Aviv-Yafo, Israel - Statup & Developer - IBM Israel](https://www.meetup.com/IBM-Startup-Developer-Tel-Aviv/)  - 在 IBM Developer &amp; Startup Meetup Group，我们将分享我们对技术和企业家精神的热情. 我们是开发人员和科技初创公司的倡导者团队，他们努力解决当今的问题，激发创新并创造令人惊叹的事物.
- [Tokyo, Japan - IBM Cloud - 東京 (Tokyo)](https://www.meetup.com/IBM-Cloud-東京-Tokyo) - このグループは、最新テクノロジーを活用して、ビジネスの拡大や、より良い世界を実現する事が目的です。このグループは、#IBMCloud　について学び、クラウドサービスをビジネスに活用したい全ての方が対象となります。　グループの参加者は新規、既存は問いません。　Meetupのトピックは、開発者や管理者、またはビジネスリーダー等の参加対象者によって異なり、様々なトピックについて活動します。このグループで想定しているテクノロジーのトピックとしては、クラウドプラットフォーム、Artificial Intelligence (AI/人工知能）、ブロクチェーン、分析、オートメーション、クラウドサービス/API、データサイエンス、イテグレーション、アプリケーション開発や、ガバナンス等です.
- [Tokyo, Japan - IBM Developer Tokyo](https://www.meetup.com/IBM-Developer-Tokyo/)  - “这个小组面向任何对使用人工智能、物联网、区块链等技术进行开发感兴趣的人.欢迎所有技能水平的人. 期待与大家一起学习和构建新的应用程序.”
- [Toronto, ON - IBM Cloud - Toronto](https://www.meetup.com/IBM-Cloud-Toronto/) - This is a group for anyone interested in learning about #IBMCloud, the cloud built for business. You can be an existing #IBMCloud user, or someone who has never touched the #IBMCloud before. Meetup topics will vary and could be of interest to developers, administrators, or business leaders.
- [Wellington, New Zealand - IBM Cloud - Wellington](https://www.meetup.com/IBM-Cloud-Wellington/)  - 惠灵顿 ️☁️ 聚会是开发人员、工程师、建筑师、设计师和其他人交流和讨论技术的地方. 涵盖云、应用程序现代化、物联网、区块链、人工智能、机器学习、数据分析、开源等主题.
- [Zürich, Switzerland - Quantum Computing Switzerland - Qool Stuff](https://www.meetup.com/Quantum-Computing-Switzerland-Qool-Stuff/)  - 在瑞士有许多值得探索的东西：山脉、巧克力、奶酪火锅、量子计算机、火车……等等量子？ 是的！ 加入这个 MeetUp 群组，聆听和交流关于量子计算机、开发者平台、Qiskit、量子用例和更多 Qool Stuff 的最新和最重要的消息.

## Contributing

如果您想做出贡献，请随时提交您的合并请求或创建一个新问题. 但首先，请花点时间阅读 [contribution guidelines](https://github.com/victorshinya/awesome-ibmcloud/blob/master/CONTRIBUTING.md) . 谢谢大家 [contributors](https://github.com/victorshinya/awesome-ibmcloud/graphs/contributors)! **#YouROCK**!

 ***如果您在这里看到不再维护或不合适的包或项目，请提交拉取请求以改进此文件. 谢谢你！***

## Contact

如有任何讨论、问题或评论，请随时与我联系. 你可以在我的网站上找到 [GitHub page](https://github.com/victorshinya) 或者你可以和我谈谈 [Twitter](https://twitter.com/victorshinya).
