<div class="github-widget" data-repo="bnb/awesome-hyper"></div>
## Awesome Hyper [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Awesome](https://img.shields.io/travis/bnb/awesome-hyper.svg)](https://travis-ci.org/bnb/awesome-hyper)

[<img src="https://raw.githubusercontent.com/bnb/awesome-hyper/master/hyper-3-color-logo.svg?sanitize=true" align="right" width="240">](https://hyper.is)

&gt; 甜美 Hyper 精选清单 [packages](#packages), [themes](#themes)， 和 [resources](#resources).

*灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出事情. 你可能还喜欢 [awesome-node](https://github.com/sindresorhus/awesome-nodejs) 和 [awesome-npm](https://github.com/sindresorhus/awesome-npm)，它们都有可以与 Hyper 一起使用的 CLI 内容！*

*请阅读 [contribution guidelines](https://github.com/bnb/awesome-hyper/blob/master/CONTRIBUTING.md) 在贡献之前.*

**查看官方 [Hyper site](https://hyper.is)， 查看 [Vercel](https://vercel.com)，以及他们有趣的托管产品， [Now](https://vercel.com/home).**

想要添加很棒的 Hyper 包、主题或资源吗？ 做出改变并 [open a pull request](https://opensource.guide/how-to-contribute/#opening-a-pull-request)!

喜欢 `awesome-hyper`？ 伸出援手 [@bitandbang](https://twitter.com/bitandbang), [@matheusfrndes](https://twitter.com/matheusfrndes)， 和 [@iamstarkov](https://twitter.com/iamstarkov) 在推特上说*嗨*！

<!-- AWESOME ITEM TEMPLATE --

* [Hyper Awesome Name](hyper.awesome.link) - 关于为什么包、主题或资源很棒的描述！

-- /AWESOME 项目模板 --&gt;



## Packages
知道另一个 Hyper 包吗？ [Help add it!](https://github.com/bnb/awesome-hyper/issues/new)

## Productivity

名称和描述 | 下载
-------------------- | -------------
[hyperline](https://www.npmjs.com/package/hyperline)  - Hyper 底部的状态行！  | [![npm](https://img.shields.io/npm/dm/hyperline.svg?label=DL)](https://www.npmjs.com/package/hyperline)
[hypercwd](https://www.npmjs.com/package/hypercwd)  - 使用与当前选项卡相同的目录打开新选项卡.  | [![npm](https://img.shields.io/npm/dm/hypercwd.svg?label=DL)](https://www.npmjs.com/package/hypercwd)
[hyperterm-visor](https://www.npmjs.com/package/hyperterm-visor)  - 使用全局热键等显示/隐藏您的超级终端.  | [![npm](https://img.shields.io/npm/dm/hyperterm-visor.svg?label=DL)](https://www.npmjs.com/package/hyperterm-visor)
[hyper-sync-settings](https://www.npmjs.com/package/hyper-sync-settings)  - 将 Hyper 设置备份和恢复到 Github 的简单方法.  | [![npm](https://img.shields.io/npm/dm/hyper-sync-settings.svg?label=DL)](https://www.npmjs.com/package/hyper-sync-settings)
[hyperterm-summon](https://www.npmjs.com/package/hyperterm-summon)  - 使用系统范围的热键召唤您的 Hyper 窗口.  | [![npm](https://img.shields.io/npm/dm/hyperterm-summon.svg?label=DL)](https://www.npmjs.com/package/hyperterm-summon)
[hyperterm-paste](https://www.npmjs.com/package/hyperterm-paste)  - 粘贴到终端使安全和容易.  | [![npm](https://img.shields.io/npm/dm/hyperterm-paste.svg?label=DL)](https://www.npmjs.com/package/hyperterm-paste)
[hyperterm-lastpass](https://www.npmjs.com/package/hyperterm-lastpass)  - 用于在 Hyper 中自动填充密码的 LastPass 插件.  | [![npm](https://img.shields.io/npm/dm/hyperterm-lastpass.svg?label=DL)](https://www.npmjs.com/package/hyperterm-lastpass)
[hyperterm-dibdabs](https://www.npmjs.com/package/hyperterm-dibdabs)  - 选项卡左侧添加了独特的彩色圆点，以便根据标题快速识别常用选项卡.  | [![npm](https://img.shields.io/npm/dm/hyperterm-dibdabs.svg?label=DL)](https://www.npmjs.com/package/hyperterm-dibdabs)
[hyperterm-tabs](https://www.npmjs.com/package/hyperterm-tabs) - Rearrange tabs by drag&dropping them. | [![npm](https://img.shields.io/npm/dm/hyperterm-tabs.svg?label=DL)](https://www.npmjs.com/package/hyperterm-tabs)
[hyperterm-focus-reporting](https://www.npmjs.com/package/hyperterm-focus-reporting)  - 向 Hyper 添加焦点报告 - 类似于 iTerm2.  | [![npm](https://img.shields.io/npm/dm/hyperterm-focus-reporting.svg?label=DL)](https://www.npmjs.com/package/hyperterm-focus-reporting)
[hyperlinks](https://www.npmjs.com/package/hyperlinks)  - 自动链接 URL 的 Hyper 扩展.  | [![npm](https://img.shields.io/npm/dm/hyperlinks.svg?label=DL)](https://www.npmjs.com/package/hyperlinks)
[hyper-statusline](https://www.npmjs.com/package/hyper-statusline)  - 显示当前 cwd 和 git 分支状态的状态行.  | [![npm](https://img.shields.io/npm/dm/hyper-statusline.svg?label=DL)](https://www.npmjs.com/package/hyper-statusline)
[hyper-statusline-extended]https://github.com/bnb/awesome-hyper/blob/master/(https://www.npmjs.com/package/hyper-statusline-extended) hyper-statusline 重写和扩展为 Hyper 3 提供更多功能. [![npm](https://img.shields.io/npm/dm/hyper-statusline-extended.svg?label=DL)](https://github.com/bnb/awesome-hyper/blob/master/(https://www.npmjs.com/package/hyper-statusline-extended))
[hypernpm](https://www.npmjs.com/package/hypernpm)  - 使用键盘快捷键运行 npm 脚本命令.  | [![npm](https://img.shields.io/npm/dm/hypernpm.svg?label=DL)](https://www.npmjs.com/package/hypernpm)
[hyper-startup](https://www.npmjs.com/package/hyper-startup)  - 在 Hyper 加载时执行任何配置的命令.  | [![npm](https://img.shields.io/npm/dm/hyper-startup.svg?label=DL)](https://www.npmjs.com/package/hyper-startup)
[hyper-fileio](https://www.npmjs.com/package/hyper-fileio)  - 直接从 Hyper 共享临时文件.  | [![npm](https://img.shields.io/npm/dm/hyper-fileio.svg?label=DL)](https://www.npmjs.com/package/hyper-fileio)
[hyper-history](https://www.npmjs.com/package/hyper-history)  - 显示历史命令列表.  | [![npm](https://img.shields.io/npm/dm/hyper-history.svg?label=DL)](https://www.npmjs.com/package/hyper-history)
[hyper-alt-click](https://www.npmjs.com/package/hyper-alt-click)  - 允许通过 alt+click&#39;ing 将光标移动到您想要的位置.  | [![npm](https://img.shields.io/npm/dm/hyper-alt-click.svg?label=DL)](https://www.npmjs.com/package/hyper-alt-click)
[hyperterm-safepaste](https://www.npmjs.com/package/hyperterm-safepaste)  - 在执行之前编辑您的粘贴.  | [![npm](https://img.shields.io/npm/dm/hyperterm-safepaste.svg?label=DL)](https://www.npmjs.com/package/hyperterm-safepaste)
[hyper-broadcast](https://www.npmjs.com/package/hyper-broadcast)  - 将用户输入广播到多个术语.  | [![npm](https://img.shields.io/npm/dm/hyper-broadcast.svg?label=DL)](https://www.npmjs.com/package/hyper-broadcast)
[hyperdocs](https://www.npmjs.com/package/hyperdocs)  - 在您的终端中获取文档页面.  | [![npm](https://img.shields.io/npm/dm/hyperdocs.svg?label=DL)](https://www.npmjs.com/package/hyperdocs)
[hyper-search](https://www.npmjs.com/package/hyper-search)  - 在您的终端中搜索文本.  | [![npm](https://img.shields.io/npm/dm/hyper-search.svg?label=DL)](https://www.npmjs.com/package/hyper-search)
[hypergoogle](https://www.npmjs.com/package/hypergoogle)  - 从您的终端搜索谷歌.  | [![npm](https://img.shields.io/npm/dm/hypergoogle.svg?label=DL)](https://www.npmjs.com/package/hypergoogle)
[hyperduck](https://www.npmjs.com/package/hyperduck)  - 从您的终端搜索 DuckDuckGo.  | [![npm](https://img.shields.io/npm/dm/hyperduck.svg?label=DL)](https://www.npmjs.com/package/hyperduck)
[hyper-quit](https://www.npmjs.com/package/hyper-quit)  - 最后一个窗口关闭时退出 macOS 上的 Hyper.  | [![npm](https://img.shields.io/npm/dm/hyper-quit.svg?label=DL)](https://www.npmjs.com/package/hyper-quit)
[hyper-confirm](https://www.npmjs.com/package/hyper-confirm)  - 在退出 Hyper 之前显示确认对话框.  | [![npm](https://img.shields.io/npm/dm/hyper-confirm.svg?label=DL)](https://www.npmjs.com/package/hyper-confirm)
[hyper-match](https://www.npmjs.com/package/hyper-match)  - 将 url、电子邮件和文件路径等模式链接到已配置的命令.  | [![npm](https://img.shields.io/npm/dm/hyper-match.svg?label=DL)](https://www.npmjs.com/package/hyper-match)
[hyper-savetext](https://www.npmjs.com/package/hyper-savetext)  - 将终端的文本保存到文件中.  | [![npm](https://img.shields.io/npm/dm/hyper-savetext.svg?label=DL)](https://www.npmjs.com/package/hyper-savetext)
[hyper-visual](https://www.npmjs.com/package/hyper-visual)  - 来自历史和上下文的 CLI 命令现在列在可点击的 GUI 中.  | [![npm](https://img.shields.io/npm/dm/hyper-visual.svg?label=DL)](https://www.npmjs.com/package/hyper-visual)
[hyper-init](https://www.npmjs.com/package/hyper-init)  - 在 Hyper 终端启动之前和之后初始化命令的最终和最完整的扩展.  | [![npm](https://img.shields.io/npm/dm/hyper-init.svg?label=DL)](https://www.npmjs.com/package/hyper-init)
[hyper-gcp-status-line](https://www.npmjs.com/package/hyper-gcp-status-line)  - 状态行显示本地配置的 GCP 项目、GCE 区域和 Kubernetes 上下文，以及当前的 Google Cloud 可用性.  | [![npm](https://img.shields.io/npm/dm/hyper-gcp-status-line.svg?label=DL)](https://www.npmjs.com/package/hyper-gcp-status-line)
[hyperalfred](https://www.npmjs.com/package/hyperalfred) - 从 Alfred 3 打开 Hyper. [![npm](https://img.shields.io/npm/dm/hyperalfred.svg?label=DL)](https://www.npmjs.com/package/hyperalfred)
[hyperinator](https://www.npmjs.com/package/hyperinator)  - 布局自动化工具，例如用于 Hyper 的 tmuxinator.  | [![npm](https://img.shields.io/npm/dm/hyperinator.svg?label=DL)](https://www.npmjs.com/package/hyperinator)
[hyper-drop-file](https://www.npmjs.com/package/hyper-drop-file)  - 将文件路径从文件资源管理器拖放到您的终端.  | [![npm](https://img.shields.io/npm/dm/hyper-drop-file.svg?label=DL)](https://www.npmjs.com/package/hyper-drop-file)
[hyper-dnd-tabs](https://www.npmjs.com/package/hyper-dnd-tabs)  - 拖放标签.  | [![npm](https://img.shields.io/npm/dm/hyper-dnd-tabs.svg?label=DL)](https://www.npmjs.com/package/hyper-dnd-tabs)
[hyper-manager](https://www.npmjs.com/package/hyper-manager)  - 在一个地方管理所有连接的终极和最完整的扩展.  | [![npm](https://img.shields.io/npm/dm/hyper-manager.svg?label=DL)](https://www.npmjs.com/package/hyper-manager)


## Customization

名称和描述 | 下载
-------------------- | -------------
[hypertheme](https://www.npmjs.com/package/hypertheme)  - Hyper 的主题管理器，立即发布. 您应该导入您最喜欢的文本编辑器或终端主题，然后 [add it to awesome-hyper](https://github.com/bnb/awesome-hyper/issues/new)! | [![npm](https://img.shields.io/npm/dm/hypertheme.svg?label=DL)](https://www.npmjs.com/package/hypertheme)
[hyper-blink](https://www.npmjs.com/package/hyper-blink)  - 让你的光标闪烁.  | [![npm](https://img.shields.io/npm/dm/hyper-blink.svg?label=DL)](https://www.npmjs.com/package/hyper-blink)
[hyperborder](https://www.npmjs.com/package/hyperborder)  - 添加与 Hyper 徽标颜色相同的渐变边框.  | [![npm](https://img.shields.io/npm/dm/hyperborder.svg?label=DL)](https://www.npmjs.com/package/hyperborder)
[hyper-transparent-bg](https://www.npmjs.com/package/hyper-transparent-bg)  - 通过有趣的 HTML hack 为您的 Hyper 添加透明背景.  | [![npm](https://img.shields.io/npm/dm/hyper-transparent-bg.svg?label=DL)](https://www.npmjs.com/package/hyper-transparent-bg)
[hyperterm-close-on-left](https://www.npmjs.com/package/hyperterm-close-on-left)  - 将关闭选项卡按钮放置在左侧.  | [![npm](https://img.shields.io/npm/dm/hyperterm-close-on-left.svg?label=DL)](https://www.npmjs.com/package/hyperterm-close-on-left)
[hyperterm-mactabs](https://www.npmjs.com/package/hyperterm-mactabs)  - 更好的选项卡样式，采用 macOS 风格的设计和左侧的关闭按钮，与大多数主题兼容.  | [![npm](https://img.shields.io/npm/dm/hyperterm-mactabs.svg?label=DL)](https://www.npmjs.com/package/hyperterm-mactabs)
[hyper-final-say](https://www.npmjs.com/package/hyper-final-say)  - 允许用户设置覆盖在默认值 `./.hyperterm.js` 之上应用的任何插件或主题设置.  | [![npm](https://img.shields.io/npm/dm/hyper-final-say.svg?label=DL)](https://www.npmjs.com/package/hyper-final-say)
[hyperterm-overlay](https://www.npmjs.com/package/hyperterm-overlay)  - Hyper 中覆盖窗口的完整且可自定义的解决方案.  | [![npm](https://img.shields.io/npm/dm/hyperterm-overlay.svg?label=DL)](https://www.npmjs.com/package/hyperterm-overlay)
[hyper-overlay](https://www.npmjs.com/package/hyper-overlay) - Hyper 2 的覆盖解决方案. [![npm](https://img.shields.io/npm/dm/hyper-overlay.svg?label=DL)](https://www.npmjs.com/package/hyper-overlay)
[hyper-tab-icons](https://www.npmjs.com/package/hyper-tab-icons)  - 将图标添加到 Hyper 中当前运行进程的标题选项卡.  | [![npm](https://img.shields.io/npm/dm/hyper-tab-icons.svg?label=DL)](https://www.npmjs.com/package/hyper-tab-icons)
[config-hyperterm](https://www.npmjs.com/package/config-hyperterm)  - 轻松设置/获取 `Hyper` 配置.  | [![npm](https://img.shields.io/npm/dm/config-hyperterm.svg?label=DL)](https://www.npmjs.com/package/config-hyperterm)
[hyperfullscreen](https://www.npmjs.com/package/hyperfullscreen)  - 将全屏启动 Hyper.  | [![npm](https://img.shields.io/npm/dm/hyperfullscreen.svg?label=DL)](https://www.npmjs.com/package/hyperfullscreen)
[hyperterm-crosshair](https://www.npmjs.com/package/hyperterm-crosshair)  - 使用水平和垂直突出显示/标尺显示光标位置.  | [![npm](https://img.shields.io/npm/dm/hyperterm-crosshair.svg?label=DL)](https://www.npmjs.com/package/hyperterm-crosshair)
[hyperterm-cursor](https://www.npmjs.com/package/hyperterm-cursor)  - 允许通过色差查看光标后面的字符.  | [![npm](https://img.shields.io/npm/dm/hyperterm-cursor.svg?label=DL)](https://www.npmjs.com/package/hyperterm-cursor)
[hypersixteen](https://www.npmjs.com/package/hypersixteen)  - 用于 Hyper 的 base16 加载程序.  | [![npm](https://img.shields.io/npm/dm/hypersixteen.svg?label=DL)](https://www.npmjs.com/package/hypersixteen)
[hyper-stylesheet](https://www.npmjs.com/package/hyper-stylesheet)  - 添加对外部超级样式表的支持.  | [![npm](https://img.shields.io/npm/dm/hyper-stylesheet.svg?label=DL)](https://www.npmjs.com/package/hyper-stylesheet)
[hyperlayout](https://www.npmjs.com/package/hyperlayout)  - Hyper 的布局预设.  | [![npm](https://img.shields.io/npm/dm/hyperlayout.svg?label=DL)](https://www.npmjs.com/package/hyperlayout)
[hyper-autohide-tabs](https://www.npmjs.com/package/hyper-autohide-tabs)  - 当只有一个标签时自动隐藏标签栏.  | [![npm](https://img.shields.io/npm/dm/hyper-autohide-tabs.svg?label=DL)](https://www.npmjs.com/package/hyper-autohide-tabs)
[hyperminimal](https://www.npmjs.com/package/hyperminimal)  - 删除窗口标题以获得更多空间并减少干扰.  | [![npm](https://img.shields.io/npm/dm/hyperminimal.svg?label=DL)](https://www.npmjs.com/package/hyperminimal)
[hyper-autoprofile](https://www.npmjs.com/package/hyper-autoprofile)  - 根据当前 shell 提示更改终端外观（背景颜色、字体...）.  | [![npm](https://img.shields.io/npm/dm/hyper-autoprofile.svg?label=DL)](https://www.npmjs.com/package/hyper-autoprofile)
[hyper-tabs-enhanced](https://www.npmjs.com/package/hyper-tabs-enhanced)  - 带有选项卡图标等的可配置增强选项卡.  | [![npm](https://img.shields.io/npm/dm/hyper-tabs-enhanced.svg?label=DL)](https://www.npmjs.com/package/hyper-tabs-enhanced)
[hyper-arc-dark-controls](https://www.npmjs.com/package/hyper-arc-dark-controls)  - 来自 Hyper 的 Arc Dark 主题的漂亮窗口控件.  | [![npm](https://img.shields.io/npm/dm/hyper-arc-dark-controls.svg?label=DL)](https://www.npmjs.com/package/hyper-arc-dark-controls)
[hyper-mac-controls](https://www.npmjs.com/package/hyper-mac-controls)  - 适用于 Hyper 的类似 Mac 的窗口控件.  | [![npm](https://img.shields.io/npm/dm/hyper-mac-controls.svg?label=DL)](https://www.npmjs.com/package/hyper-mac-controls)
[hyper-terminal-tabs](https://www.npmjs.com/package/hyper-terminal-tabs)  - 为 Hyper 带来 Terminal.app 的外观和感觉.  | [![npm](https://img.shields.io/npm/dm/hyper-terminal-tabs.svg?label=DL)](https://www.npmjs.com/package/hyper-terminal-tabs)
[hyper-dark-scrollbar](https://www.npmjs.com/package/hyper-dark-scrollbar)  - Hyper 的漂亮滚动条.  | [![npm](https://img.shields.io/npm/dm/hyper-dark-scrollbar.svg?label=DL)](https://www.npmjs.com/package/hyper-dark-scrollbar)
[hyper-pane](https://www.npmjs.com/package/hyper-pane)  - 使用箭头浏览窗格，直接跳转到带有数字的特定窗格或在鼠标悬停时更改焦点.  | [![npm](https://img.shields.io/npm/dm/hyper-pane.svg?label=DL)](https://www.npmjs.com/package/hyper-pane)
[hyper-always-on-top](https://www.npmjs.com/package/hyper-always-on-top)  - 添加一个菜单项，使应用程序窗口始终位于顶部.  | [![npm](https://img.shields.io/npm/dm/hyper-always-on-top.svg?label=DL)](https://www.npmjs.com/package/hyper-always-on-top)
[hyper-transparent-dynamic](https://www.npmjs.com/package/hyper-transparent-dynamic)  - 根据当前主题动态设置透明背景.  | [![npm](https://img.shields.io/npm/dm/hyper-transparent-dynamic.svg?label=DL)](https://www.npmjs.com/package/hyper-transparent-dynamic)
[hyper-vsplit-fix](https://www.npmjs.com/package/hyper-vsplit-fix)  - 修复了 Hyper 中的垂直分割边框高度.  | [![npm](https://img.shields.io/npm/dm/hyper-vsplit-fix.svg?label=DL)](https://www.npmjs.com/package/hyper-vsplit-fix)
[hyper-hide-title](https://www.npmjs.com/package/hyper-hide-title)  - 当只有一个选项卡时隐藏窗口标题.  | [![npm](https://img.shields.io/npm/dm/hyper-hide-title.svg?label=DL)](https://www.npmjs.com/package/hyper-hide-title)
[hyper-wal](https://www.npmjs.com/package/hyper-wal) - 使用由生成的配色方案的扩展 [wal](https://github.com/dylanaraps/wal) 在超.  | [![npm](https://img.shields.io/npm/dm/hyper-wal.svg?label=DL)](https://www.npmjs.com/package/hyper-wal)
[hyper-hover-header](https://www.npmjs.com/package/hyper-hover-header)  - 隐藏的标题/标题栏. 将光标移动到窗口的顶部边框以使页眉/标题栏淡入. [![npm](https://img.shields.io/npm/dm/hyper-hover-header.svg?label=DL)](https://www.npmjs.com/package/hyper-hover-header)
[hyper-transparent](https://www.npmjs.com/package/hyper-transparent) - [Hyper](https://hyper.is) 轻松设置窗口透明度和活力的插件.  | [![npm](https://img.shields.io/npm/dm/hyper-transparent.svg?label=DL)](https://www.npmjs.com/package/hyper-transparent)
[hyper-spotify](https://www.npmjs.com/package/hyper-spotify)  - 在终端底部显示 Spotify 上当前正在播放的歌曲，并允许您控制自己喜欢的音乐.  | [![npm](https://img.shields.io/npm/dm/hyper-spotify.svg?label=DL)](https://www.npmjs.com/package/hyper-spotify)
[hyper-background](https://www.npmjs.com/package/hyper-background)  - 更改超级终端的背景！  | [![npm](https://img.shields.io/npm/dm/hyper-background.svg?label=DL)](https://www.npmjs.com/package/hyper-background)
[hyper-vertical-tabs](https://www.npmjs.com/package/hyper-vertical-tabs)  - 将选项卡放在左侧边栏上，这在 iTerm2 和 ROXTerm 中是可能的.  | [![npm](https://img.shields.io/npm/dm/hyper-vertical-tabs.svg?label=DL)](https://www.npmjs.com/package/hyper-vertical-tabs)
[themer](https://www.npmjs.com/package/themer) - 为 Hyper 和所有其他开发工具生成主题 | [![npm](https://img.shields.io/npm/dm/themer.svg?label=DL)](https://www.npmjs.com/package/themer)
[hyper-native-window-decoration](https://www.npmjs.com/package/hyper-native-window-decoration)  - HyperTerm 中的本机窗口装饰.  | [![npm](https://img.shields.io/npm/dm/hyper-native-window-decoration.svg?label=DL)](https://www.npmjs.com/package/hyper-native-window-decoration)
[hyper-hide-scroll](https://www.npmjs.com/package/hyper-hide-scroll)  - 隐藏终端滚动条的扩展.  | [![npm](https://img.shields.io/npm/dm/hyper-hide-scroll.svg?label=DL)](https://www.npmjs.com/package/hyper-hide-scroll)
[hyper-systray](https://www.npmjs.com/package/hyper-systray)  - 本机 Windows 系统托盘中的 Hyper. 从任务栏隐藏. 显示/隐藏窗口的全局快捷方式.  | [![npm](https://img.shields.io/npm/dm/hyper-systray.svg?label=DL)](https://www.npmjs.com/package/hyper-systray)
[hyper-window-size](https://www.npmjs.com/package/hyper-window-size)  - 设置 Hyper 的默认窗口大小！  | [![npm](https://img.shields.io/npm/dm/hyper-window-size.svg?label=DL)](https://www.npmjs.com/package/hyper-window-size)
[hyper-media-control](https://www.npmjs.com/package/hyper-media-control)  - 显示和控制各种媒体播放器中的当前歌曲.  | [![npm](https://img.shields.io/npm/dm/hyper-media-control.svg?label=DL)](https://npmjs.com/package/hyper-media-control)
[hyper-folder-icon](https://www.npmjs.com/package/hyper-folder-icon)  - 在选项卡中显示 Mac 和 Linux 的自定义文件夹图标.  | [![npm](https://img.shields.io/npm/dm/hyper-folder-icon.svg?label=DL)](https://www.npmjs.com/package/hyper-folder-icon)
[hyper-tab-touchbar](https://www.npmjs.com/package/hyper-tab-touchbar)  - 从 MacBook Pro 的触控栏查看和访问您的终端选项卡. 支持带有 `hyper-folder-icon` 的图标.  | [![npm](https://img.shields.io/npm/dm/hyper-tab-touchbar.svg?label=DL)](https://www.npmjs.com/package/hyper-tab-touchbar)
[hyper-opacity](https://www.npmjs.com/package/hyper-opacity)  - 设置 Hyper 窗口的不透明度.  | [![npm](https://img.shields.io/npm/dm/hyper-opacity.svg?label=DL)](https://www.npmjs.com/package/hyper-opacity)
[hyper-custom-touchbar](https://www.npmjs.com/package/hyper-custom-touchbar)  - 在 MacBook Pro 的 Touch Bar 中添加自定义按钮.  | [![npm](https://img.shields.io/npm/dm/hyper-custom-touchbar.svg?label=DL)](https://www.npmjs.com/package/hyper-custom-touchbar)
[hyper-save-windowstate](https://www.npmjs.com/package/hyper-save-windowstate)  - 重启后保存和恢复 Hyper 窗口位置/大小.  | [![npm](https://img.shields.io/npm/dm/hyper-save-windowstate.svg?label=DL)](https://www.npmjs.com/package/hyper-save-windowstate)
[hyper-tabs-autohide](https://www.npmjs.com/package/hyper-tabs-autohide)  - 用于自动隐藏所有选项卡的 Hyper 插件.  | [![npm](https://img.shields.io/npm/dm/hyper-tabs-autohide.svg?label=DL)](https://www.npmjs.com/package/hyper-tabs-autohide)


## Development

名称和描述 | 下载
-------------------------------------------------------------------------------------------------------------------------------------------- | -------------
[hyperterm-open-devtools](https://www.npmjs.com/package/hyperterm-open-devtools)  - 打开 DevTools 以使用热键显示当前网页.  | [![npm](https://img.shields.io/npm/dm/hyperterm-open-devtools.svg?label=DL)](https://www.npmjs.com/package/hyperterm-open-devtools)
[hyperterm-install-devtools](https://www.npmjs.com/package/hyperterm-install-devtools)  - 在 Hyper 上使用 Chrome DevTools 扩展.  | [![npm](https://img.shields.io/npm/dm/hyperterm-install-devtools.svg?label=DL)](https://www.npmjs.com/package/hyperterm-install-devtools)
[is-hyper](https://www.npmjs.com/package/is-hyper)  - 检查您的 Node.js 脚本是否在 Hyper 中运行.  | [![npm](https://img.shields.io/npm/dm/is-hyper.svg?label=DL)](https://www.npmjs.com/package/is-hyper)


## Fun
名称和描述 | 下载
---------------------------------- | -------------
[hyperpower](https://www.npmjs.com/package/hyperpower)  - 为您的 Hyper 增添一抹狂野的原始力量！ 添加已在多个文本编辑器中实现的像素爆炸和抖动效果.  | [![npm](https://img.shields.io/npm/dm/hyperpower.svg?label=DL)](https://www.npmjs.com/package/hyperpower)
[htyt](https://www.npmjs.com/package/htyt)  - 在 Hyper 中搜索和播放 youtube 视频.  | [![npm](https://img.shields.io/npm/dm/htyt.svg?label=DL)](https://www.npmjs.com/package/htyt)
[hyper-john](https://www.npmjs.com/package/hyper-john)  - 打开选项卡、窗口和拆分时有 10% 的几率被 John Cena 主题击中.  | [![npm](https://img.shields.io/npm/dm/hyper-john.svg?label=DL)](https://www.npmjs.com/package/hyper-john)
[hyper-command-gifs](https://www.npmjs.com/package/hyper-command-gifs)  - 为您的终端命令提供匹配的 GIF.  | [![npm](https://img.shields.io/npm/dm/hyper-command-gifs.svg?label=DL)](https://www.npmjs.com/package/hyper-command-gifs)
[hyper-cat](https://www.npmjs.com/package/hyper-cat)  - 打字时将您的终端变成 nyan cat.  | [![npm](https://img.shields.io/npm/dm/hyper-cat.svg?label=DL)](https://www.npmjs.com/package/hyper-cat)
[hyper-cat-cursor](https://www.npmjs.com/package/hyper-cat-cursor)  - 用猫表情符号序列替换光标.  | [![npm](https://img.shields.io/npm/dm/hyper-cat-cursor.svg?label=DL)](https://www.npmjs.com/package/hyper-cat-cursor)
[gitrocket](https://www.npmjs.com/package/gitrocket)  - 当您使用 Git 推送代码时，在您的终端中发射一艘火箭飞船！  | [![npm](https://img.shields.io/npm/dm/gitrocket.svg?label=DL)](https://www.npmjs.com/package/gitrocket)
[hypergravity](https://www.npmjs.com/package/hypergravity)  - 为您的终端添加一些奇特的物理学！  | [![npm](https://img.shields.io/npm/dm/hypergravity.svg?label=DL)](https://www.npmjs.com/package/hypergravity)
[space-pull](https://www.npmjs.com/package/space-pull)  - 在使用 git 提取代码时在终端中添加着陆火箭的动画.  | [![npm](https://img.shields.io/npm/dm/space-pull.svg?label=DL)](https://www.npmjs.com/package/space-pull)
[hyper-bloodbath](https://www.npmjs.com/package/hyper-bloodbath)  - 对超级大国的残酷重新想象. 从你的光标滴血.  | [![npm](https://img.shields.io/npm/dm/hyper-bloodbath.svg?label=DL)](https://www.npmjs.com/package/hyper-bloodbath)
[hyper-postprocessing](https://www.npmjs.com/package/hyper-postprocessing)  - 将片段着色器添加到超级终端.  | [![npm](https://img.shields.io/npm/dm/hyper-postprocessing.svg?label=DL)](https://www.npmjs.com/package/hyper-postprocessing)
[git-falcon9](https://www.npmjs.com/package/git-falcon9) - Launch and land SpaceX's Falcon rockets when pushing and pulling code with git! | [![npm](https://img.shields.io/npm/dm/git-falcon9.svg?label=DL)](https://www.npmjs.com/package/git-falcon9)


## Themes

名称和描述 | 下载
-------------------- | -------------
[an-old-hype](https://www.npmjs.com/package/an-old-hype) - 受遥远星系启发的 Hyper 主题......以及 Jesse Leites [atom syntax theme](https://atom.io/themes/an-old-hope-syntax). | [![npm](https://img.shields.io/npm/dm/an-old-hype.svg?label=DL)](https://www.npmjs.com/package/an-old-hype)
[hyper-adventure-time](https://www.npmjs.com/package/hyper-adventure-time) - 来自 Adventure Time 主题的超级端口 [iTerm2 Color Schemes](https://github.com/mbadolato/iTerm2-Color-Schemes). | [![npm](https://img.shields.io/npm/dm/hyper-adventure-time.svg?label=DL)](https://www.npmjs.com/package/hyper-adventure-time)
[hyper-altair](https://www.npmjs.com/package/hyper-altair)  - 优雅、可定制且色彩鲜艳的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-altair.svg?label=DL)](https://www.npmjs.com/package/hyper-altair)
[hyper-atom-dark-transparent](https://www.npmjs.com/package/hyper-atom-dark-transparent)  - 基于 hyperterm-atom-dark 的超主题，但具有透明度.  | [![npm](https://img.shields.io/npm/dm/hyper-atom-dark-transparent.svg?label=DL)](https://www.npmjs.com/package/hyper-atom-dark-transparent)
[hyper-aurora](https://www.npmjs.com/package/hyper-aurora)  - 基于北极光的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-aurora.svg?label=DL)](https://www.npmjs.com/package/hyper-aurora)
[hyper-aww](https://www.npmjs.com/package/hyper-aww)  - 每次打开 Hyper 时，将终端背景更改为不同可爱动物 gif 的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-aww.svg?label=DL)](https://www.npmjs.com/package/hyper-aww)
[hyper-ayu](https://www.npmjs.com/package/hyper-ayu)  - 主题基于 Ayu Theme for Sublime Text.  | [![npm](https://img.shields.io/npm/dm/hyper-ayu.svg?label=DL)](https://www.npmjs.com/package/hyper-ayu)
[hyper-ayu-light](https://www.npmjs.com/package/hyper-ayu-light)  - 主题基于 Ayu Light Theme for Sublime Text.  | [![npm](https://img.shields.io/npm/dm/hyper-ayu-light.svg?label=DL)](https://www.npmjs.com/package/hyper-ayu-light)
[hyper-ayu-light-special](https://www.npmjs.com/package/hyper-ayu-light-special)  - 主题基于 Ayu Light 主题，但为了便于阅读而添加了黑色.  | [![npm](https://img.shields.io/npm/dm/hyper-ayu-light-special.svg?label=DL)](https://www.npmjs.com/package/hyper-ayu-light-special)
[hyper-ayu-mirage](https://www.npmjs.com/package/hyper-ayu-mirage)  - 主题基于 Sublime Text 的 Ayu Mirage 主题.  | [![npm](https://img.shields.io/npm/dm/hyper-ayu-mirage.svg?label=DL)](https://www.npmjs.com/package/hyper-ayu-mirage)
[hyper-bloody](https://www.npmjs.com/package/hyper-bloody)  - 令人惊叹的深色主题，色彩鲜艳.  | [![npm](https://img.shields.io/npm/dm/hyper-bloody.svg?label=DL)](https://www.npmjs.com/package/hyper-bloody)
[hyper-captain-sweetheart](https://www.npmjs.com/package/hyper-captain-sweetheart)  - 凝灰岩但甜美的超级主题.  | [![npm](https://img.shields.io/npm/dm/hyper-captain-sweetheart.svg?label=DL)](https://www.npmjs.com/package/hyper-captain-sweetheart)
[hyper-chesterish](https://www.npmjs.com/package/hyper-chesterish)  - 基于切斯特语法的饱和主题.  | [![npm](https://img.shields.io/npm/dm/hyper-chesterish.svg?label=DL)](https://www.npmjs.com/package/hyper-chesterish)
[hyper-city-lights](https://www.npmjs.com/package/hyper-city-lights) - 基于的深色主题 [City Lights](http://citylights.xyz) 句法.  | [![npm](https://img.shields.io/npm/dm/hyper-city-lights.svg?label=DL)](https://www.npmjs.com/package/hyper-city-lights)
[hyper-clean](https://www.npmjs.com/package/hyper-clean) - 一个干净的主题 [IBM Design colors](https://github.com/IBM-Design/colors). | [![npm](https://img.shields.io/npm/dm/hyper-clean.svg?label=DL)](https://www.npmjs.com/package/hyper-clean)
[hyper-cobalt-next](https://www.npmjs.com/package/hyper-cobalt-next) - 主题基于 [Cobalt Next VS Code Theme](https://marketplace.visualstudio.com/items?itemName=dline.CobaltNext). | [![npm](https://img.shields.io/npm/dm/hyper-cobalt-next.svg?label=DL)](https://www.npmjs.com/package/hyper-cobalt-next)
[hyper-criollo](https://www.npmjs.com/package/hyper-criollo)  - 基于蒸汽波颜色的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-criollo.svg?label=DL)](https://www.npmjs.com/package/hyper-criollo)
[hyper-cyan](https://www.npmjs.com/package/hyper-cyan)  - 为令人难以置信的 hyper 创建的美丽极简主义主题.  | [![npm](https://img.shields.io/npm/dm/hyper-cyan.svg?label=DL)](https://www.npmjs.com/package/hyper-cyan)
[hyper-darkmatter](https://www.npmjs.com/package/hyper-darkmatter) - Dark - Hyper 的 Darkmatter 主题，灵感来自 [Sublime Darkmatter](https://github.com/patrickemuller/Sublime-Darkmatter-Theme). | [![npm](https://img.shields.io/npm/dm/hyper-darkmatter.svg?label=DL)](https://www.npmjs.com/package/hyper-darkmatter)
[hyper-dracula](https://www.npmjs.com/package/hyper-dracula) - 基于 Hyper 的深色主题 [Dracula theme](https://draculatheme.com/hyper/). | [![npm](https://img.shields.io/npm/dm/hyper-dracula.svg?label=DL)](https://www.npmjs.com/package/hyper-dracula)
[hyper-firewatch](https://www.npmjs.com/package/hyper-firewatch)  - 受 Campo Santo 的 Firewatch 视频游戏启发的深色 Hyper 主题.  | [![npm](https://img.shields.io/npm/dm/hyper-firewatch.svg?label=DL)](https://www.npmjs.com/package/hyper-firewatch)
[hyper-flat-2](https://www.npmjs.com/package/hyper-flat-2)  - 另一个基于终端平面主题的 Hyper 平面主题.  | [![npm](https://img.shields.io/npm/dm/hyper-flat-2.svg?label=DL)](https://www.npmjs.com/package/hyper-flat-2)
[hyper-flat](https://www.npmjs.com/package/hyper-flat)  - Hyper 的平面主题.  | [![npm](https://img.shields.io/npm/dm/hyper-flat.svg?label=DL)](https://www.npmjs.com/package/hyper-flat)
[hyper-frontend-delight](https://www.npmjs.com/package/hyper-frontend-delight)  - 深色 - 基于 Frontend Delight iTerm2 配色方案.  | [![npm](https://img.shields.io/npm/dm/hyper-frontend-delight.svg?label=DL)](https://www.npmjs.com/package/hyper-frontend-delight)
[hyper-github-dark-dimmed](https://www.npmjs.com/package/hyper-github-dark-dimmed) - 港口 [GitHub Dark Dimmed theme](https://github.com/primer/github-vscode-theme). | [![npm](https://img.shields.io/npm/dm/hyper-github-dark-dimmed.svg?label=DL)](https://www.npmjs.com/package/hyper-github-dark-dimmed)
[hyper-github-light](https://www.npmjs.com/package/hyper-github-light) - 港口 [GitHub Light theme](https://github.com/primer/github-vscode-theme). | [![npm](https://img.shields.io/npm/dm/hyper-github-light.svg?label=DL)](https://www.npmjs.com/package/hyper-github-light)
[hyper-gruv](https://www.npmjs.com/package/hyper-gruv) - 深色 - Gruvbox 主题基于 [gruvbox](https://github.com/morhetz/gruvbox). | [![npm](https://img.shields.io/npm/dm/hyper-gruv.svg?label=DL)](https://www.npmjs.com/package/hyper-gruv)
[hyper-hybrid-reduced-contrast](https://www.npmjs.com/package/hyper-hybrid-reduced-contrast) - 降低对比度版本的一个端口 [vim-hybrid](https://github.com/w0ng/vim-hybrid). | [![npm](https://img.shields.io/npm/dm/hyper-hybrid-reduced-contrast.svg?label=DL)](https://www.npmjs.com/package/hyper-hybrid-reduced-contrast)
[hyper-hypest](https://www.npmjs.com/package/hyper-hypest)  - 美丽而简约的 macOS 主题，充满活力.  | [![npm](https://img.shields.io/npm/dm/hyper-hypest.svg?label=DL)](https://www.npmjs.com/package/hyper-hypest)
[hyper-loved](https://www.npmjs.com/package/hyper-loved)  - 一个黑暗，优雅的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-loved.svg?label=DL)](https://www.npmjs.com/package/hyper-loved)
[hyper-macos](https://www.npmjs.com/package/hyper-macos)  - 具有活力支持的原生 macOS 主题.  | [![npm](https://img.shields.io/npm/dm/hyper-macos.svg?label=DL)](https://www.npmjs.com/package/hyper-macos)
[hyper-mahoushoujo](https://www.npmjs.com/package/hyper-mahoushoujo) - 受魔法少女启发的浅色主题✨ | [![npm](https://img.shields.io/npm/dm/hyper-mahoushoujo.svg?label=DL)](https://www.npmjs.com/package/hyper-mahoushoujo)
[hyper-material-box](https://www.npmjs.com/package/hyper-material-box)  - 最适合您最喜爱的终端 Hyper 的黑客主题.  | [![npm](https://img.shields.io/npm/dm/hyper-material-box.svg?label=DL)](https://www.npmjs.com/package/hyper-material-box)
[hyper-material-theme](https://www.npmjs.com/package/hyper-material-theme)  - 深色 - Hyper App 上最史诗般的材​​质主题.  | [![npm](https://img.shields.io/npm/dm/hyper-material-theme.svg?label=DL)](https://www.npmjs.com/package/hyper-material-theme)
[hyper-materialshell](https://www.npmjs.com/package/hyper-materialshell)  - 深色材料设计主题，在重要部分具有良好的对比度和色彩. 旨在让眼睛轻松，基于 [materialshell](https://github.com/carloscuesta/materialshell). | [![npm](https://img.shields.io/npm/dm/hyper-materialshell.svg?label=DL)](https://www.npmjs.com/package/hyper-materialshell)
[hyper-midnight](https://www.npmjs.com/package/hyper-midnight)  - 超级终端的极简主义主题.  | [![npm](https://img.shields.io/npm/dm/hyper-midnight.svg?label=DL)](https://www.npmjs.com/package/hyper-midnight)
[hyper-monochrome](https://www.npmjs.com/package/hyper-monochrome) - 单色主题，基于 [vim-monochrome](https://github.com/fxn/vim-monochrome). | [![npm](https://img.shields.io/npm/dm/hyper-monochrome.svg?label=DL)](https://www.npmjs.com/package/hyper-monochrome)
[hyper-monokai-deluxe](https://www.npmjs.com/package/hyper-monokai-deluxe)  - Monokai Deluxe 主题以更好的方式和标签突出显示超边框.  | [![npm](https://img.shields.io/npm/dm/hyper-monokai-deluxe.svg?label=DL)](https://www.npmjs.com/package/hyper-monokai-deluxe)
[hyper-moonlite](https://www.npmjs.com/package/hyper-moonlite) - 的分拆 [New Moon Syntax Theme](https://github.com/taniarascia/new-moon) 对于超级.  | [![npm](https://img.shields.io/npm/dm/hyper-moonlite.svg?label=DL)](https://www.npmjs.com/package/hyper-moonlite)
[hyper-nord](https://www.npmjs.com/package/hyper-nord)  - Hyper 的 Nord 主题.  | [![npm](https://img.shields.io/npm/dm/hyper-nord.svg?label=DL)](https://www.npmjs.com/package/hyper-nord)
[hyper-oceans16](https://www.npmjs.com/package/hyper-oceans16)  - 基于 Base16 Ocean 语法的饱和主题.  | [![npm](https://img.shields.io/npm/dm/hyper-oceans16.svg?label=DL)](https://www.npmjs.com/package/hyper-oceans16)
[hyper-oldschool](https://www.npmjs.com/package/hyper-oldschool)  - Hyper 的老式终端主题.  | [![npm](https://img.shields.io/npm/dm/hyper-oldschool.svg?label=DL)](https://www.npmjs.com/package/hyper-oldschool)
[hyper-omni-theme](https://www.npmjs.com/package/hyper-omni-theme)  - Hyper 的 Omni 主题.  | [![npm](https://img.shields.io/npm/dm/hyper-omni-theme.svg?label=DL)](https://www.npmjs.com/package/hyper-omni-theme)
[hyper-one-dark-vivid](https://www.npmjs.com/package/hyper-one-dark-vivid)  - 基于 Atom One Dark 的深色主题，文字颜色更鲜艳.  | [![npm](https://img.shields.io/npm/dm/hyper-one-dark-vivid.svg?label=DL)](https://www.npmjs.com/package/hyper-one-dark-vivid)
[hyper-one-light](https://www.npmjs.com/package/hyper-one-light) - Light - 一个非常可爱的主题，带有额外的浅色背景，基于 [Atom One Light](https://github.com/atom/one-light-syntax) 调色板.  | [![npm](https://img.shields.io/npm/dm/hyper-one-light.svg?label=DL)](https://www.npmjs.com/package/hyper-one-light)
[hyper-papercolor](https://www.npmjs.com/package/hyper-papercolor) - [PaperColor](https://github.com/NLKNguyen/papercolor-theme)  Hyper 的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-papercolor.svg?label=DL)](https://www.npmjs.com/package/hyper-papercolor)
[hyper-peacock](https://www.npmjs.com/package/hyper-peacock)  - Hyper 的孔雀主题.  | [![npm](https://img.shields.io/npm/dm/hyper-peacock.svg?label=DL)](https://www.npmjs.com/package/hyper-peacock)
[hyper-pokemon](https://www.npmjs.com/package/hyper-pokemon)  - 为您的超级终端量身定制的神奇宝贝主题.  | [![npm](https://img.shields.io/npm/dm/hyper-pokemon.svg?label=DL)](https://www.npmjs.com/package/hyper-pokemon)
[hyper-polarbear](https://www.npmjs.com/package/hyper-polarbear)  - 一个漂亮的 Hyper 白色主题.  | [![npm](https://img.shields.io/npm/dm/hyper-polarbear.svg?label=DL)](https://www.npmjs.com/package/hyper-polarbear)
[hyper-ramda](https://www.npmjs.com/package/hyper-ramda)  - 主题灵感来自 RamdaJS REPL.  | [![npm](https://img.shields.io/npm/dm/hyper-ramda.svg?label=DL)](https://www.npmjs.com/package/hyper-ramda)
[hyper-relaxed](https://www.npmjs.com/package/hyper-relaxed)  - 以更轻松的方式看待事物的主题.  | [![npm](https://img.shields.io/npm/dm/hyper-relaxed.svg?label=DL)](https://www.npmjs.com/package/hyper-relaxed)
[hyper-rose-pine](https://www.npmjs.com/package/hyper-rose-pine)  - 纯天然松木、人造毛皮和一些适合优雅极简主义者的 Soho 氛围.  | [![npm](https://img.shields.io/npm/dm/hyper-rose-pine.svg?label=DL)](https://www.npmjs.com/package/hyper-rose-pine)
[hyper-seashells](https://www.npmjs.com/package/hyper-seashells) - 的超级端口 [iTerm2 SeaShells](https://github.com/mbadolato/iTerm2-Color-Schemes/blob/master/screenshots/sea_shells.png) 配色方案.  | [![npm](https://img.shields.io/npm/dm/hyper-seashells.svg?label=DL)](https://www.npmjs.com/package/hyper-seashells)
[hyper-sierra-vibrancy](https://www.npmjs.com/package/hyper-sierra-vibrancy)  - 充满活力的超级山脉.  | [![npm](https://img.shields.io/npm/dm/hyper-sierra-vibrancy.svg?label=DL)](https://www.npmjs.com/package/hyper-sierra-vibrancy)
[hyper-sierra](https://www.npmjs.com/package/hyper-sierra)  - 受内华达山脉启发的 Hyper 深色主题.  | [![npm](https://img.shields.io/npm/dm/hyper-sierra.svg?label=DL)](https://www.npmjs.com/package/hyper-sierra)
[hyper-snazzy](https://www.npmjs.com/package/hyper-snazzy)  - 深色 - 优雅的主题，色彩鲜艳.  | [![npm](https://img.shields.io/npm/dm/hyper-snazzy.svg?label=DL)](https://www.npmjs.com/package/hyper-snazzy)
[hyper-solarized-dark](https://www.npmjs.com/package/hyper-solarized-dark) - 基于流行的宜人和精心挑选的颜色 [solarized](https://ethanschoonover.com/solarized/) 调色板.  | [![npm](https://img.shields.io/npm/dm/hyper-solarized-dark.svg?label=DL)](https://www.npmjs.com/package/hyper-solarized-dark)
[hyper-solarized-light](https://www.npmjs.com/package/hyper-solarized-light) - 基于流行的宜人和精心挑选的颜色 [solarized](https://ethanschoonover.com/solarized/) 调色板.  | [![npm](https://img.shields.io/npm/dm/hyper-solarized-light.svg?label=DL)](https://www.npmjs.com/package/hyper-solarized-light)
[hyper-solarized-one](https://www.npmjs.com/package/hyper-solarized-one) - 一个 2 对 1 [Solarized](https://ethanschoonover.com/solarized/) 超级终端的主题. 它知道它是什么... | [![npm](https://img.shields.io/npm/dm/hyper-solarized-one.svg?label=DL)](https://www.npmjs.com/package/hyper-solarized-one)
[hyper-star-wars](https://www.npmjs.com/package/hyper-star-wars)  - 超级棒，你的超级终端应该看起来.  | [![npm](https://img.shields.io/npm/dm/hyper-star-wars.svg?label=DL)](https://www.npmjs.com/package/hyper-star-wars)
[hyper-sweet](https://www.npmjs.com/package/hyper-sweet)  - 带有一些霓虹灯的黑暗和现代主题.  | [![npm](https://img.shields.io/npm/dm/hyper-sweet.svg?label=DL)](https://www.npmjs.com/package/hyper-sweet)
[hyper-teatime](https://www.npmjs.com/package/hyper-teatime)  - 带有甜美柔和色彩的浅色主​​题.  | [![npm](https://img.shields.io/npm/dm/hyper-teatime.svg?label=DL)](https://www.npmjs.com/package/hyper-teatime)
[hyper-tender](https://www.npmjs.com/package/hyper-tender)  - 受 tender.vim 启发的深色主题.  | [![npm](https://img.shields.io/npm/dm/hyper-tender.svg?label=DL)](https://www.npmjs.com/package/hyper-tender)
[hyper-theme](https://www.npmjs.com/package/hyper-theme)  - 超级终端的超级颜色主题.  | [![npm](https://img.shields.io/npm/dm/hyper-theme.svg?label=DL)](https://www.npmjs.com/package/hyper-theme)
[hyper-thirtyone](https://www.npmjs.com/package/hyper-thirtyone)  - 针对 Hyper 略微修改的经典 Linux 终端主题.  | [![npm](https://img.shields.io/npm/dm/hyper-thirtyone.svg?label=DL)](https://www.npmjs.com/package/hyper-thirtyone)
[hyper-white-theme](https://www.npmjs.com/package/hyper-white-theme)  - Hyper 的白色和紫色主题.  | [![npm](https://img.shields.io/npm/dm/hyper-white-theme.svg?label=DL)](https://www.npmjs.com/package/hyper-white-theme)
[hyper-zenburn](https://www.npmjs.com/package/hyper-zenburn)  - 最初为 vim 制作的经典低对比度主题适用于 Hyper.  | [![npm](https://img.shields.io/npm/dm/hyper-zenburn.svg?label=DL)](https://www.npmjs.com/package/hyper-zenburn)
[hyper-zigorat](https://www.npmjs.com/package/hyper-zigorat)  - Hyper 的最小语法主题.  | [![npm](https://img.shields.io/npm/dm/hyper-zigorat.svg?label=DL)](https://www.npmjs.com/package/hyper-zigorat)
[hyperambient](https://www.npmjs.com/package/hyperambient)  - 深色/浅色 - 对环境光变化做出反应的主题.  | [![npm](https://img.shields.io/npm/dm/hyperambient.svg?label=DL)](https://www.npmjs.com/package/hyperambient)
[hyperatompunk](https://www.npmjs.com/package/hyperatompunk)  - 超级扩展使您的终端看起来像 Fallout 中的 CRT.  | [![npm](https://img.shields.io/npm/dm/hyperatompunk.svg?label=DL)](https://www.npmjs.com/package/hyperatompunk)
[hyperblue-vibrancy](https://www.npmjs.com/package/hyperblue-vibrancy)  - 与 Hyperblue 相同的冷色调，现在充满活力！  | [![npm](https://img.shields.io/npm/dm/hyperblue-vibrancy.svg?label=DL)](https://www.npmjs.com/package/hyperblue-vibrancy)
[hyperblue](https://www.npmjs.com/package/hyperblue)  - 深色、冷色调. 变成超级蓝色.  | [![npm](https://img.shields.io/npm/dm/hyperblue.svg?label=DL)](https://www.npmjs.com/package/hyperblue)
[hyperganymede](https://www.npmjs.com/package/hyperganymede)  - 受木星卫星冰冷启发的配色方案.  | [![npm](https://img.shields.io/npm/dm/hyperganymede.svg?label=DL)](https://www.npmjs.com/package/hyperganymede)
[hyperhue](https://www.npmjs.com/package/hyperhue)  - 深色/彩虹色 - 可对飞利浦 Hue 灯的颜色作出反应的主题.  | [![npm](https://img.shields.io/npm/dm/hyperhue.svg?label=DL)](https://www.npmjs.com/package/hyperhue)
[hypernasa](https://www.npmjs.com/package/hypernasa)  - 用 NASA 的每日图片替换航站楼背景的主题.  | [![npm](https://img.shields.io/npm/dm/hypernasa.svg?label=DL)](https://www.npmjs.com/package/hypernasa)
[hyperocean](https://www.npmjs.com/package/hyperocean)  - 深海蓝色超级主题.  | [![npm](https://img.shields.io/npm/dm/hyperocean.svg?label=DL)](https://www.npmjs.com/package/hyperocean)
[hyperpanic](https://www.npmjs.com/package/hyperpanic)  - 深色 - 一个非常漂亮的主题，接近 Panic 主题的颜色. 深蓝色背景，带有非常明亮的高亮颜色.  | [![npm](https://img.shields.io/npm/dm/hyperpanic.svg?label=DL)](https://www.npmjs.com/package/hyperpanic)
[hyperpunk](https://www.npmjs.com/package/hyperpunk)  - 超级扩展让你的终端看起来像赛博朋克/科幻.  | [![npm](https://img.shields.io/npm/dm/hyperpunk.svg?label=DL)](https://www.npmjs.com/package/hyperpunk)
[hypersolar-dark](https://www.npmjs.com/package/hypersolar-dark)  - 一个松散地基于 Solarized Dark 的深色主题，修复了实际出现在您的终端中的通常带有黑色的 solarized 深色！  | [![npm](https://img.shields.io/npm/dm/hypersolar-dark.svg?label=DL)](https://www.npmjs.com/package/hypersolar-dark)
[hyperterm-adventurous](https://www.npmjs.com/package/hyperterm-adventurous)  - 基于 Adventurous Atom 主题的冒险时间主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-adventurous.svg?label=DL)](https://www.npmjs.com/package/hyperterm-adventurous)
[hyperterm-atom-dark](https://www.npmjs.com/package/hyperterm-atom-dark) - 黑暗 - 非常漂亮的 Atom One Dark 主题导入 [official Atom theme](https://github.com/atom/one-dark-syntax). | [![npm](https://img.shields.io/npm/dm/hyperterm-atom-dark.svg?label=DL)](https://www.npmjs.com/package/hyperterm-atom-dark)
[hyperterm-base-16-ocean](https://www.npmjs.com/package/hyperterm-base-16-ocean) - 用于超级术语的简单 Base 16 海洋主题 | [![npm](https://img.shields.io/npm/dm/hyperterm-base-16-ocean.svg?label=DL)](https://www.npmjs.com/package/hyperterm-base-16-ocean)
[hyperterm-base16-tomorrow-dark](https://www.npmjs.com/package/hyperterm-base16-tomorrow-dark)  - Dark - Atom 的“Base16 Tomorrow Dark”主题的超级端口，带有漂亮柔和的柔和调色板.  | [![npm](https://img.shields.io/npm/dm/hyperterm-base16-tomorrow-dark.svg?label=DL)](https://www.npmjs.com/package/hyperterm-base16-tomorrow-dark)
[hyperterm-bold-tab](https://www.npmjs.com/package/hyperterm-bold-tab)  - 粗体是您的活动标签文本. 使跟踪您当前的选项卡变得轻松.  | [![npm](https://img.shields.io/npm/dm/hyperterm-bold-tab.svg?label=DL)](https://www.npmjs.com/package/hyperterm-bold-tab)
[hyperterm-cobalt2-theme](https://www.npmjs.com/package/hyperterm-cobalt2-theme)  - 尘土飞扬的蓝色，深色，重要的东西带有鲜艳的流行色. 与 Cobalt2 ZSH 主题配合得很好.  | [![npm](https://img.shields.io/npm/dm/hyperterm-cobalt2-theme.svg?label=DL)](https://www.npmjs.com/package/hyperterm-cobalt2-theme)
[hyperterm-colors](https://www.npmjs.com/package/hyperterm-colors)  - 深色 - 甜美的深色配色方案，带有巧克力色棕色背景和一组漂亮的柔和色彩！  | [![npm](https://img.shields.io/npm/dm/hyperterm-colors.svg?label=DL)](https://www.npmjs.com/package/hyperterm-colors)
[hyperterm-dark-drifter](https://www.npmjs.com/package/hyperterm-dark-drifter)  - 受 Heart Machine 的 Hyper Light Drifter 启发的（深色）Hyper 主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-dark-drifter.svg?label=DL)](https://www.npmjs.com/package/hyperterm-dark-drifter)
[hyperterm-dark-fusion](https://www.npmjs.com/package/hyperterm-dark-fusion)  - 基于原子暗融合的超术语主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-dark-fusion.svg?label=DL)](https://www.npmjs.com/package/hyperterm-dark-fusion)
[hyperterm-dark-macos](https://www.npmjs.com/package/hyperterm-dark-macos)  - 与 macOS 深色模式完美搭配的主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-dark-macos.svg?label=DL)](https://www.npmjs.com/package/hyperterm-dark-macos)
[hyperterm-deep-space](https://www.npmjs.com/package/hyperterm-deep-space)  - 深色 - 深色、柔和的主题，颜色匹配良好.  | [![npm](https://img.shields.io/npm/dm/hyperterm-deep-space.svg?label=DL)](https://www.npmjs.com/package/hyperterm-deep-space)
[hyperterm-duotone-darkspace](https://www.npmjs.com/package/hyperterm-duotone-darkspace) - 深色/橙色 - 一个美丽的深色主题，灵感来自 [Duotone Themes](http://simurai.com/projects/2016/01/01/duotone-themes) 经过 [Simurai](http://simurai.com/) . 可以找到更多颜色变化 [here](https://www.npmjs.com/search?q=hyperterm-duotone-*). | [![npm](https://img.shields.io/npm/dm/hyperterm-duotone-darkspace.svg?label=DL)](https://www.npmjs.com/package/hyperterm-duotone-darkspace)
[hyperterm-earthsong](https://www.npmjs.com/package/hyperterm-earthsong)  - Hyper 的自然而平静的主题. 移植自 iTerm 的 Earthsong 主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-earthsong.svg?label=DL)](https://www.npmjs.com/package/hyperterm-earthsong)
[hyper-electron-highlighter](https://www.npmjs.com/package/hyper-electron-highlighter)  - 深色 - Atom One 的端口深色语法颜色具有更鲜艳的颜色.  （之前 [hyperterm-electron-highlighter](https://www.npmjs.com/package/hyperterm-electron-highlighter)) | [![npm](https://img.shields.io/npm/dm/hyper-electron-highlighter.svg?label=DL)](https://www.npmjs.com/package/hyper-electron-highlighter)
[hyperterm-firewatch](https://www.npmjs.com/package/hyperterm-firewatch) - 深色 - 发光的深色主题深受 [Firewatch game](http://www.firewatchgame.com/) 和 [atom syntax theme](https://atom.io/themes/firewatch-syntax) 基于它.  | [![npm](https://img.shields.io/npm/dm/hyperterm-firewatch.svg?label=DL)](https://www.npmjs.com/package/hyperterm-firewatch)
[hyperterm-gooey](https://www.npmjs.com/package/hyperterm-gooey)  - 基于原子暗的带有醒目的绿色和紫色的深色主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-gooey.svg?label=DL)](https://www.npmjs.com/package/hyperterm-gooey)
[hyperterm-gruvbox-dark](https://www.npmjs.com/package/hyperterm-gruvbox-dark) - 深色 - Hyper 主题带有复古、朴实的凹槽颜色，基于 [gruvbox](https://github.com/morhetz/gruvbox)  vim 配色方案.  | [![npm](https://img.shields.io/npm/dm/hyperterm-gruvbox-dark.svg?label=DL)](https://www.npmjs.com/package/hyperterm-gruvbox-dark)
[hyperterm-gruvbox](https://www.npmjs.com/package/hyperterm-gruvbox)  - 基于 gruvbox 的主题，具有深色、浅色风格和对比度选项.  | [![npm](https://img.shields.io/npm/dm/hyperterm-gruvbox.svg?label=DL)](https://www.npmjs.com/package/hyperterm-gruvbox)
[hyperterm-hipster](https://www.npmjs.com/package/hyperterm-hipster)  - 基于 Atom 的时髦语法主题的时髦主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-hipster.svg?label=DL)](https://www.npmjs.com/package/hyperterm-hipster)
[hyperterm-horizon](https://www.npmjs.com/package/hyperterm-horizon) - VSCode 主题的非官方端口 [Horizon](https://github.com/jolaleye/horizon-theme-vscode) 超级.  | [![npm](https://img.shields.io/npm/dm/hyperterm-horizon.svg?label=DL)](https://www.npmjs.com/package/hyperterm-horizon)
[hyperterm-hybrid](https://www.npmjs.com/package/hyperterm-hybrid) - 黑暗 - 美丽的主题，基于 [vim-hybrid](https://github.com/w0ng/vim-hybrid), 结合了 [Tomorrow-Night](https://github.com/chriskempson/vim-tomorrow-theme), [Codecademy](https://www.codecademy.com/), [Jellybeans](https://github.com/nanotech/jellybeans.vim)， 和 [Solarized](https://github.com/altercation/vim-colors-solarized) 主题在一起.  | [![npm](https://img.shields.io/npm/dm/hyperterm-hybrid.svg?label=DL)](https://www.npmjs.com/package/hyperterm-hybrid)
[hyperterm-light-drifter](https://www.npmjs.com/package/hyperterm-light-drifter)  - 受 Heart Machine 的 Hyper Light Drifter 启发的（轻型）Hyper 主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-light-drifter.svg?label=DL)](https://www.npmjs.com/package/hyperterm-light-drifter)
[hyperterm-material-spacegray](https://www.npmjs.com/package/hyperterm-material-spacegray)  - 低对比度 Material Spacegray 主题的端口.  | [![npm](https://img.shields.io/npm/dm/hyperterm-material-spacegray.svg?label=DL)](https://www.npmjs.com/package/hyperterm-material-spacegray)
[hyperterm-material](https://www.npmjs.com/package/hyperterm-material)  - 深色 - 在 Hyper 中引入著名的 Material Design 配色方案.  | [![npm](https://img.shields.io/npm/dm/hyperterm-material.svg?label=DL)](https://www.npmjs.com/package/hyperterm-material)
[hyperterm-mild-dark](https://www.npmjs.com/package/hyperterm-mild-dark)  - 适用于 Hyper 的温和深色主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-mild-dark.svg?label=DL)](https://www.npmjs.com/package/hyperterm-mild-dark)
[hyperterm-monokai](https://www.npmjs.com/package/hyperterm-monokai)  - 黑暗 - 流行的 monokai 主题的一个端口. 色彩温暖、放松、赏心悦目.  | [![npm](https://img.shields.io/npm/dm/hyperterm-monokai.svg?label=DL)](https://www.npmjs.com/package/hyperterm-monokai)
[hyperterm-new-moon-theme](https://www.npmjs.com/package/hyperterm-new-moon-theme)  - 为网络开发优化的深色主题. 主题基于 [New Moon Syntax Theme](https://github.com/taniarascia/new-moon). | [![npm](https://img.shields.io/npm/dm/hyperterm-new-moon-theme.svg?label=DL)](https://www.npmjs.com/package/hyperterm-new-moon-theme)
[hyperterm-oceanic-next](https://www.npmjs.com/package/hyperterm-oceanic-next)  - 为 ES2015 优化的深蓝色主题. 移植自 [Oceanic Next](https://github.com/voronianski/oceanic-next-color-scheme). | [![npm](https://img.shields.io/npm/dm/hyperterm-oceanic-next.svg?label=DL)](https://www.npmjs.com/package/hyperterm-oceanic-next)
[hyperterm-panda](https://www.npmjs.com/package/hyperterm-panda)  — Panda syntax theme 一个极简的、黑暗的 Syntax Theme — Hyper 端口.  | [![npm](https://img.shields.io/npm/dm/hyperterm-panda.svg?label=DL)](https://www.npmjs.com/package/hyperterm-panda)
[hyperterm-retro](https://www.npmjs.com/package/hyperterm-retro) - 一个复古的 Hyper 主题，灵感来自 [cool-retro-term](https://github.com/Swordfish90/cool-retro-term) 终端模拟器.  | [![npm](https://img.shields.io/npm/dm/hyperterm-retro.svg?label=DL)](https://www.npmjs.com/package/hyperterm-retro)
[hyperterm-sourcerer](https://www.npmjs.com/package/hyperterm-sourcerer) - 基于 16 位深色主题 [xero/sourcerer](https://github.com/xero/sourcerer). | [![npm](https://img.shields.io/npm/dm/hyperterm-sourcerer.svg?label=DL)](https://www.npmjs.com/package/hyperterm-sourcerer)
[hyperterm-spacegray](https://www.npmjs.com/package/hyperterm-spacegray)  - 流行的 Spacegray 主题的端口，针对终端使用进行了优化.  | [![npm](https://img.shields.io/npm/dm/hyperterm-spacegray.svg?label=DL)](https://www.npmjs.com/package/hyperterm-spacegray)
[hyperterm-tomorrow-night](https://www.npmjs.com/package/hyperterm-tomorrow-night)  - 黑暗 - 流行的明日之夜主题的港口.  | [![npm](https://img.shields.io/npm/dm/hyperterm-tomorrow-night.svg?label=DL)](https://www.npmjs.com/package/hyperterm-tomorrow-night)
[hyperterm-ubuntu-theme](https://www.npmjs.com/package/hyperterm-ubuntu-theme)  - Ubuntu风格的主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-ubuntu-theme.svg?label=DL)](https://www.npmjs.com/package/hyperterm-ubuntu-theme)
[hyperterm-ultrasweet](https://www.npmjs.com/package/hyperterm-ultrasweet)  - Hyper 的星云色调深色主题.  | [![npm](https://img.shields.io/npm/dm/hyperterm-ultrasweet.svg?label=DL)](https://www.npmjs.com/package/hyperterm-ultrasweet)
[hyperterm-unlease](https://www.npmjs.com/package/hyperterm-unlease)  - 一个全新的 Hyper 主题，让您感觉终端机上挂着一种松树汽车空气清新剂.  | [![npm](https://img.shields.io/npm/dm/hyperterm-unlease.svg?label=DL)](https://www.npmjs.com/package/hyperterm-unlease)
[hyperterm-wp-theme](https://www.npmjs.com/package/hyperterm-wp-theme)  - 对流行的 JetBrains Darcula 主题的改编，支持彩色标签.  | [![npm](https://img.shields.io/npm/dm/hyperterm-wp-theme.svg?label=DL)](https://www.npmjs.com/package/hyperterm-wp-theme)
[shades-of-purple-hyper](https://www.npmjs.com/package/shades-of-purple-hyper)  - 专业的 Hyper™ 主题，带有精心挑选的大胆紫色色调. 紫色可以是天才.  | [![npm](https://img.shields.io/npm/dm/shades-of-purple-hyper.svg?label=DL)](https://www.npmjs.com/package/shades-of-purple-hyper)
[verminal](https://www.npmjs.com/package/verminal)  - 充满活力的深色 Hyper 主题.  | [![npm](https://img.shields.io/npm/dm/verminal.svg?label=DL)](https://www.npmjs.com/package/verminal)

知道另一个非常棒的主题吗？ [Get it on awesome-hyper!](https://github.com/bnb/awesome-hyper/issues/new)


## Resources
* [Official Hyper Website](https://hyper.is/) - Hyper 官方网站.
* [hyperzsh](https://www.npmjs.com/package/hyperzsh) - 用于 Hyper 的 Zsh.
* [Extending Hyper](https://www.youtube.com/watch?v=q_O-VEermsk&list=PL31ehRjJCA6Ez9Y_dZWymd_LDV7Ydc_0D&index=2) - Matthew Conlen 的演讲（[@mathisonian](https://github.com/mathisonian)) 在 EmpireNode 2016 上.
* [Hyper Themes screenshot browser](https://hyperthemes.matthi.coffee) 经过 [@MatthiasWinkelmann](https://github.com/MatthiasWinkelmann) 以可视方式浏览 Hyper 主题的屏幕截图.
* [Carbon](https://carbon.now.sh/) 是一种轻松创建基于 Hyper 的屏幕截图的工具.
* 知道另一个 Hyper 资源吗？ [Share the love!](https://github.com/bnb/awesome-hyper/issues/new)
