<div class="github-widget" data-repo="shopify/awesome-hydrogen"></div>
<img width="400" src="https://raw.githubusercontent.com/shopify/awesome-hydrogen/master/./assets/hydrogen-logo.svg?sanitize=true">

## Awesome Hydrogen [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

Hydrogen is Shopify's open source stack for headless commerce.



## Official Resources

- [Docs](https://shopify.dev/docs/custom-storefronts/hydrogen)
- [Hydrogen React](https://shopify.dev/docs/custom-storefronts/hydrogen-react)
- [GitHub](https://github.com/Shopify/hydrogen)

## Getting Started

- [Quickstart](https://shopify.dev/docs/custom-storefronts/hydrogen/getting-started/quickstart) - Create a Hydrogen app locally.
- [Tutorial](https://shopify.dev/docs/custom-storefronts/hydrogen/building) - From "Hello World" to a fully built out Shopify custom storefront.

## Tools

- [Hydrogen for VSCode](https://marketplace.visualstudio.com/items?itemName=crtogrm.hydrogen-vscode&ssr=false#overview)

## Community

- [Discord](https://discord.gg/shopifydevs)
- [GitHub Discussions](https://github.com/Shopify/hydrogen-v1/discussions)

## Examples

- [Hydrogen NodeJS Express Example](https://github.com/Shopify/hydrogen/tree/2023-04/examples/express)
- [Tokengated Storefront Example](https://github.com/Shopify/gated-hydrogen-example)

## Apps & Integrations

- [Algolia](https://github.com/algolia/shopify-hydrogen-algolia) - Search & discovery.
- [Crossing Minds](https://github.com/Crossing-Minds/hydrogen-demo-store) - Product recommendation engine.
- [Dynamic Yield](https://github.com/DynamicYield/shopify-hydrogen-demo) - Personalization.
- [Gorgias](https://github.com/gorgias/hydrogen-demo/) - Customer support.
- [Nosto](https://github.com/Nosto/shopify-hydrogen-demo) - Personalization.
- [Okendo](https://github.com/okendo/okendo-shopify-hydrogen-demo) - Customer reviews.
- [Pack Digital](https://github.com/packdigital/pack-hydrogen-demo) - Digital Experience Platform.
- [Rebuy](https://bitbucket.org/rebuyengine/npm-rebuy-hydrogen) - Product recommendations.
- [Sanity](https://github.com/sanity-io/hydrogen-sanity-demo) - Headless CMS.
- [Swym](https://github.com/swym-corp/swym-hydrogen-store) - Wishlists.
- [Vercel](https://vercel.com/templates/remix/hydrogen-2) - Deploy to Vercel.
- Contentful (Coming Soon)
- Yotpo (Coming Soon)
- Netlify (Coming Soon)


## Blog Posts

- [Remixing Hydrogen](https://hydrogen.shopify.dev/roadmap#remixing-hydrogen)
- [Headless Shopify - Hydrogen & Oxygen Pros & Cons + Alternative Routes](https://vervaunt.com/shopify-hydrogen-oxygen-pros-cons)

## Podcasts

- [JS Party – Episode #228 Live from Remix Conf!](https://jsparty.fm/228#t=31:29)
- [Remixing Hydrogen - Lessons learnt embracing the platform by JP Prieto](https://www.youtube.com/watch?v=MbfKZmvefNs)
- [Headless commerce with Shopify's Hydrogen with Bret Little](https://www.youtube.com/watch?v=dTh1esIxw1k)

## Conference Talks

- [Juan Pablo Prieto at Remix Conf 2023](https://www.youtube.com/watch?v=qVkRyjSrhXs&t=22990s)

## Showcase

- [Patta x Tommy](https://hydrogen.shopify.dev/case-studies/patta-x-tommy)
- [Kamp Grizzly](https://hydrogen.shopify.dev/case-studies/kamp-grizzly)
- [AllBirds](https://hydrogen.shopify.dev/case-studies/allbirds)
- [The Headless Club](https://theheadlessclub.com/tool/hydrogen)
