<div class="github-widget" data-repo="homematic-community/awesome-homematic"></div>
## Awesome Homematic [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; Homematic 相关链接的精选列表

[Homematic](https://www.homematic.com/) 是制造商的一系列智能家居设备 [eQ-3](https://www.eq-3.de)，尤其在德国流行.



- [https://github.com/homematic-community/awesome-homematic/blob/master/License](https://github.com/homematic-community/awesome-homematic/blob/master/License)


## Community Ressources (mostly german language)

* [Haus Automatisierung](https://haus-automatisierung.com/) - 新闻、博客、Youtube、教程……
* [Homematic Forum](https://homematic-forum.de/forum/) - 论坛
* [Homematic Forum: Link/Skript-Sammlung](https://homematic-forum.de/forum/viewtopic.php?f=26&t=27907) - 由 AndiN 策划的链接列表.
* [Homematic Forum: HomeMatic - Tipps für Anfänger](https://homematic-forum.de/forum/viewtopic.php?f=31&t=22801) - Sammy 的初学者必备读物
* [Homematic Guru](https://homematic-guru.de/) - 新闻、博客、教程等.
* [Homematic Inside](https://www.homematic-inside.de/) - 新闻、博客、教程等.
* [Homematic Blog Lison](https://homematic-blog.lison.ch/) - 博客、教程等..
* [Technikkram](https://technikkram.net) - 新闻、博客、教程等.
* [OwnSmartHome](https://ownsmarthome.de/category/homematic/) - 新闻、博客、教程等.
* [Verdrahtet](https://www.verdrahtet.info/) - 新闻、博客、Youtube、教程……
* [Wikimatic](http://www.wikimatic.de/wiki/Hauptseite) - 社区维基.


## Documentation

* [Dissecting HomeMatic AES](https://git.zerfleddert.de/hmcfgusb/AES/) - BidCos 协议 AES 握手说明.
* [Direktverknüpfungen im Expertenmodus](https://www.youtube.com/watch?v=1B4iwtK1Rmo) - 弗兰克·格拉斯的演讲.
* [Virtuelle Aktorkanäle](https://www.youtube.com/watch?v=Cwxwtig6Q1I) - 弗兰克·格拉斯的演讲.
* [Script Documentation](http://www.wikimatic.de/wiki/Script_Dokumentation) - 非官方 Homematic 脚本参考.
* [Keymatic Konfiguration](https://homematic-forum.de/forum/viewtopic.php?f=31&t=19196) - rewe0815 在 Homematic 论坛中的贡献.

## Mobile Apps

* [@home](https://www.athomeapp.de/) - iOS -（应用内购买去除广告）
* [HistClient](https://www.sa-com.de/smarthome-special/histclient-handbuch/) - (inApp-Purchase) - CCU-Historian 客户端，具有适用于 iOS 和 Android 的扩展功能
* [Home-24](http://www.home-24.net/index.php?page=sites/home.php&app=home24) - 安卓 
* [HomeControl](http://www.ksquare.de/myhomecontrol/) - iOS
* [TinyMatic](https://www.tinymatic.de/) - Android（以前：HomeDroid）
* [Pocket Control](https://www.penzler.de) - iOS
* [Battery Status for HomeMatic](https://zeezide.com/en/products/hmbattery/) - iOS


## CCU Alternatives

* [debmatic](https://github.com/alexreinert/debmatic) - 在基于 Debian 的 amd64、armhf 和 arm64 系统（Debian、Ubuntu、Raspbian、Armbian）上安装 Homematic OCCU
* [docker-ccu](https://github.com/angelnu/docker-ccu) - Homematic CCU固件运行为 [Docker](https://www.docker.com) 手臂上的容器和（模拟）x86.
* [Homegear](https://homegear.eu/index.php/Main_Page) - 免费和开源程序，将您的智能家居设备与您的家庭自动化软件或您自己的脚本连接起来.
* [piVCCU](https://github.com/alexreinert/piVCCU) - 在 Raspbian 或 Armbian 上的虚拟化容器 (lxc) 中安装原始 Homematic CCU 固件.
* [RaspberryMatic](https://github.com/jens-maus/RaspberryMatic) - 轻量级、OCCU 和基于 Linux/buildroot 的发行版，用于在 RaspberryPi 等嵌入式设备上运行 HomeMatic CCU.


## Alternative Sensors, Actuators and Hardware Modifications

* [AskSinPPCollection](https://jp112sdl.github.io/AskSinPPCollection/) - 关于使用 AskSinPP 自建组件的介绍、文档和项目
* [Beispiel_AskSinPP](https://github.com/jp112sdl/Beispiel_AskSinPP) - 使用示例草图 [AskSinPP](https://github.com/pa-pa/AskSinPP) 图书馆
* [HAUS-BUS.DE](http://www.haus-bus.de/) - Homematic 有线兼容设备.
* [Homematic Wired Hombrew Hardware](https://github.com/jfische) - 适用于 Homematic Wired 的各种自制传感器/执行器.
* [stall.biz](https://www.stall.biz/) - 替代天线，客厅的多传感器，气象站，...


## CCU Addons

* [CCU Historian](https://ccu-historian.de/) - 长期存档和图表.
* [CUxD](https://www.homematic-inside.de/software/tag/Zusatzsoftware )  - CCU 的“Leatherman”. 连接 FS20，...（EnOcean，...），提供虚拟设备和有用的工具.
* [Email](https://github.com/jens-maus/hm_email) - 用于发送电子邮件的 HomeMatic CCU 插件.
* [HAP-HomeMatic](https://github.com/thkl/hap-homematic)  - 用于从 HomeKit 访问 HomeMatic 设备的 RaspberryMatic / CCU3 插件. 它很像 https://github.com/thkl/homebridge-homematic 但没有 homebridge.
* [hm-print](https://github.com/litti/hm-print) - 打印 CCU 程序.
* [hm-tools](https://github.com/fhetty/hm-tools) - RaspberryMatic 工具集.
* [hm_pdetect](https://github.com/jens-maus/hm_pdetect) - 通过 FRITZ! Box 进行存在检测
* [Homeputer](https://www.contronics.de/shop/HomeMatic-System/Zentralen-und-Software.html) -
* [Homematic-addon-hue](https://github.com/j-a-n/homematic-addon-hue) - 飞利浦 Hue 的 HomeMatic 插件.
* [homematic_check_mk](https://github.com/alexreinert/homematic_check_mk) - Homematic CCU2 或充当 check_mk_agent 的 Raspberrymatic 设备的插件.
* [jq](https://github.com/hobbyquaker/ccu-addon-jq) - jq 打包为 Homematic CCU3 的插件.
* [Mosquitto](https://github.com/hobbyquaker/ccu-addon-mosquitto) - Mosquitto 打包为 Homematic CCU3 和 RaspberryMatic 的插件
* [Patcher](https://github.com/hobbyquaker/Patcher) - CCU3 插件，用于舒适地应用补丁.
* [rmupdate](https://github.com/j-a-n/raspberrymatic-addon-rmupdate) - 可以更新 RaspberryMatic 本身的 RaspberryMatic 插件，使用 GUI 简化 WLAN 配置，并且可以安装和更新其他插件而无需强制重启
* [Redis](https://github.com/hobbyquaker/ccu-addon-redis) - Redis 打包为 Homematic CCU3 和 RaspberryMatic 的插件
* [RedMatic](https://github.com/rdmtc/RedMatic) - [Node-RED](https://nodered.org/) 作为 Homematic CCU3 和 RaspberryMatic 的插件. 除其他外，提供方便的 HomeKit 集成和用于将 CCU 连接到 MQTT 的特殊节点.
* [XML-API](https://github.com/hobbyquaker/xml-api) - 通过 HTTP/XML 简化了 CCU 访问.


## Interfacing Software

* [CCU-Jack](https://github.com/mdzio/ccu-jack) - CCU-Jack 提供对 CCU 的基于 REST 的简单安全访问，也可作为插件使用.
* [homebridge-homematic](https://github.com/thkl/homebridge-homematic) - [Homebridge](https://github.com/nfarina/homebridge) 用于将 Homematic 设备集成到 HomeKit 中的插件.
* [homebridge-homematicip](https://github.com/marcsowen/homebridge-homematicip) - [Homebridge](https://github.com/nfarina/homebridge) 用于通过云将 Homematic IP 与 HmIP-HAP 集成的插件.
* [hvl - Homematic Virtual Interface](https://github.com/thkl/Homematic-Virtual-Interface) - 通过插件集成外部设备（例如 Hue、Harmony、Netatmo、Sonos），也可作为插件使用.
* [node-red-contrib-ccu](https://github.com/rdmtc/node-red-contrib-ccu) - [Node-RED](https://nodered.org) Homematic CCU 的节点.



## Misc Software

* [check_homematic](https://github.com/hobbyquaker/check_homematic) - 用于检查 Homematic CCU 的 Nagios/Icinga 插件.
* [hm-simulator](https://github.com/hobbyquaker/hm-simulator) - 模拟（部分）Homematic CCU.
* [hmcfgusb](https://git.zerfleddert.de/cgi-bin/gitweb.cgi/hmcfgusb) - 在 Linux/Unix 上使用 HM-CFG-USB(2) 的实用程序.
* [HomeHub](https://github.com/Gerti1972/homehub) - 基于 PHP/XML-API 的 Web 前端. [Forum](https://homematic-forum.de/forum/viewtopic.php?f=41&t=50538)
* [homematic-manager](https://github.com/hobbyquaker/homematic-manager) - 管理 homematic 界面进程 (rfd/hs485d/homegear).
* [language-homematic](https://github.com/Ayngush/language-homematic) - 为 Atom 中的 HomeMatic 脚本文件添加语法高亮和片段.
* [occu-test](https://github.com/hobbyquaker/occu-test) - ReGaHss 的自动化系统测试 - HomeMatic (O)CCU“逻辑层”.
* [HMScriptEditor](https://zeezide.com/en/products/hmscripteditor/) - 一个非常简单的 macOS 编辑器和 HomeMatic（“Rega”）脚本的运行器.

## Software Modules

* [binrpc](https://github.com/hobbyquaker/binrpc) - Xmlrpc_bin 协议客户端和服务器 Node.js 模块.
* [hm-discover](https://github.com/hobbyquaker/hm-discover) - 用于发现 Homematic CCU 和接口的 Node.js 模块.
* [homematic-rega](https://github.com/hobbyquaker/homematic-rega) - Node.js Homematic CCU ReGaHSS 远程脚本接口.
* [homematicip-rest-api](https://github.com/coreGreenberet/homematicip-rest-api) - 用于 homematicIP REST API（基于云/接入点）的 Python 包装器.
* [homematic-gqls](https://github.com/martin-riedl/homematic-gqls) - 基于 GraphQL 服务查询 Homematic IP 组件 [homematicip-rest-api](https://github.com/coreGreenberet/homematicip-rest-api).
* [homematic-xmlrpc](https://github.com/hobbyquaker/homematic-xmlrpc) - Xmlrpc 客户端和服务器 Node.js 模块.
* [pmatic](https://github.com/LarsMichelsen/pmatic)  - 用于 Homematic 的 Python API. 便于使用.
* [pyhomematic](https://github.com/danielperna84/pyhomematic) - 用于与 Homematic 设备交互的 Python 3 接口.

## Smart Home Software supporting Homematic

* [everHome](https://everhome.de) -
* [FHEM](https://fhem.de/)
* [Home Assistant](https://www.home-assistant.io/)
* [ioBroker](https://www.iobroker.net/?lang=de)
* [IP-Symcon](https://www.symcon.de/) -
* [Mediola](https://www.mediola.com/) -
* [OpenHAB](https://www.openhab.org/)
* [Pimatic](https://pimatic.org/)

## Misc

* [AskSinAnalyzer](https://github.com/jp112sdl/AskSinAnalyzer) - 用于 HomeMatic 环境的无线电报解码器，有助于故障排除，例如当占空比过高时.
* [AskSinAnalyzerXS](https://github.com/psi-4ward/AskSinAnalyzerXS) - AskSinAnalyzer 作为桌面应用程序，不使用 ESP.
* [eagle-homematic](https://github.com/dersimn/eagle-homematic) - Homematic 模块 Eagle 库.
* [Tablet Wallmount](https://homematic-forum.de/forum/viewtopic.php?f=18&t=49421) - 用于平板电脑齐平安装的框架.
* [Homematic 3D Druck Collection auf Thingiverse](https://www.thingiverse.com/hobbyquaker/collections/homematic) - 与 Homematic 相关的各个部分自己打印.


## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/homematic-community/awesome-homematic/blob/master/contributing.md) 第一的.


## License

[Public Domain CC0](https://creativecommons.org/publicdomain/zero/1.0/)
