<div class="github-widget" data-repo="frenck/awesome-home-assistant"></div>
## Awesome Home Assistant [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
<!--lint disable double-link-->

<div align="center">
  <a href="https://awesome-ha.com">
    <img width="400" src="https://www.awesome-ha.com/images/awesome-home-assistant.svg" alt="Awesome Home Assistant">
  </a>
  <br>
  <a href="https://awesome-ha.com"><strong>https://awesome-ha.com</strong></a>
</div>

Home Assistant 是一种开源的家庭自动化软件，可以将本地控制和
隐私第一. 由全球修补匠和 DIY 社区提供支持
爱好者. 非常适合在 Raspberry Pi 或本地服务器上运行.

如果你想对外观和感觉有印象，
你应该看看 [Home Assistant online demo](https://demo.home-assistant.io).

Awesome Home Assistant 是一个精选的很棒的列表
[Home Assistant](https://www.home-assistant.io) 资源.
附加软件、教程、自定义集成、附加组件、
自定义仪表板卡和插件、说明书、示例设置等等.

该列表分为几类. 这些类别中的链接没有
预定顺序； 订单是贡献. 如果你想贡献，
请阅读 [guide](https://github.com/frenck/awesome-home-assistant/blob/main/.github/CONTRIBUTING.md)
或提出 [issue](https://github.com/frenck/awesome-home-assistant/issues/new/choose)
建议添加、更新或删除.



## How to use

Awesome Home Assistant 是一个很棒的列表，适合那些试图自动化每个
他们家的一面. 实现家庭自动化是一项漫长、艰巨且从未完成的工作
通常涉及大量修补的任务.

您可以通过以下方式浏览列表：

- 只需按<kbd>command/ctrl</kbd> + <kbd>F</kbd>即可搜索关键字
- 或者，使用我们网站上的搜索：<https://www.awesome-ha.com>

## Installing

 Home Assistant 有几种安装方式； 各有优势
缺点. 许多人有不同的意见和个人喜好.
重要的是要知道这里没有对错； 每种技术安装
同一个家庭助理.

Home Assistant 推荐 Home Assistant OS 安装方式.

- [Home Assistant Installation](https://www.home-assistant.io/installation/) - 官方安装指南.
- [Compare Installation Methods](https://www.home-assistant.io/installation/#compare-installation-methods) - 比较可用的安装方法.

## In case you need help

_有多种方式可以与 Home Assistant 社区取得联系.
如果您有问题、需要帮助、想要请求功能，都没有关系，
或者只是说&#39;嗨&#39;._

### Official Communities

- [Home Assistant Discord](https://discordapp.com/invite/c5DvZ4e) - 加入聊天，我们大多数人都在那里.
- [Home Assistant Community](https://community.home-assistant.io/?u=frenck) - 论坛，也用于功能请求.
- [Home Assistant Subreddit](https://www.reddit.com/r/homeassistant/) - 如果您喜欢 Reddit，请订阅.
- [Home Assistant Facebook Group](https://www.facebook.com/groups/HomeAssistant/) - 爱好者的 Facebook 群组.

### Other Communities

- [Dr. ZZs](https://www.facebook.com/groups/1969622823351838/) - Zzs 博士的 Facebook 群组.
- [Home Assistant Community Add-ons Discord](https://discord.me/hassioaddons) - 获得对 Home Assistant Community Add-ons 的支持.
- [ESPHome Discord](https://discord.gg/KhAMKrd) - 获得对您的 DIY ESPHome 项目的支持.
- [Dutch Domotics Discord](https://discord.gg/Ee5X7T7) - 家庭自动化爱好者的荷兰 Discord 服务器.

## Public Configurations

 _有些人将他们的完整 Home Assistant 配置存储在 GitHub 上. 他们是
一个很棒的学习来源和一个很好的灵感来源._

- [Carlo Costanzo](https://github.com/CCOSTAN/Home-AssistantConfig#logo) - 可能是目前记录最多的配置.
- [DubhAd](https://github.com/DubhAd/Home-AssistantConfig) - 也称为 Tinkerer 分享他的配置文件.
- [geekofweek](https://github.com/geekofweek/homeassistant) - 拥有超过 300 种自动化.
- [Mahasri Kalavala](https://github.com/skalavala/mysmarthome) - 令人印象深刻的设置，许多不同的硬件协同工作.
- [Alok Saboo](https://github.com/arsaboo/homeassistant-config)  - 也称为 arsaboo. 定期更新.
- [Aaron Bach](https://github.com/bachya/smart-home)  - 也称为 bachya. 定期更新并包含大量 Dockerized 服务.
- [Franck Nijhof](https://github.com/frenck/home-assistant-config) - 基于 Hass.io，与其他配置结构非常不同.
- [Klaas Schoute](https://github.com/klaasnicolaas/Student-homeassistant-config) - 基于 Hass.io、Intel NUC、Ubuntu Server、Docker 并定期更新.
- [Andrea Iannucci](https://github.com/SeLLeRoNe/HA-Config)  - 也称为 SeLLeRoNe. 定期更新.

## Add-ons

_Add-ons 是额外的应用程序和服务，可以一起运行
家庭助理.  Home Assistant 操作系统和监督安装类型，
提供 Supervisor，它能够运行和管理这些附加组件._

### Official Add-ons

_由 Home Assistant 团队创建和维护._

- [DuckDNS](https://github.com/home-assistant/hassio-addons/blob/master/duckdns/DOCS.md) - 更新您的 Duck DNS IP 地址并使用 Let&#39;s Encrypt 生成 SSL.
- [File editor](https://github.com/home-assistant/hassio-addons/blob/master/configurator/DOCS.md) - 基于浏览器的配置文件编辑器.
- [Mosquitto](https://github.com/home-assistant/hassio-addons/blob/master/mosquitto/DOCS.md) - 快速可靠的 MQTT 经纪人.
- [Terminal & SSH](https://github.com/home-assistant/hassio-addons/blob/master/ssh/DOCS.md) - 允许远程登录到使用网络终端或 SSH 客户端.
- [Samba](https://github.com/home-assistant/hassio-addons/blob/master/samba/DOCS.md) - 使用 Windows 网络共享访问您的配置文件.
- [NGINX SSL proxy](https://github.com/home-assistant/hassio-addons/blob/master/nginx_proxy/DOCS.md) - 带 SSL 终止的反向代理.
- [deCONZ](https://github.com/home-assistant/hassio-addons/blob/master/deconz/DOCS.md) - 使用 Dresden Elektronik 的 ConBee 或 RaspBee 硬件控制 ZigBee 网络.
- [TellStick](https://github.com/home-assistant/hassio-addons/blob/master/tellstick/DOCS.md) - 运行 TellStick 和 TellStick Duo 服务.
- [Ada](https://github.com/home-assistant/hassio-addons/blob/master/ada/DOCS.md) - Ada 是由 Almond 驱动的语音助手，开放且保护隐私.
- [Almond](https://github.com/home-assistant/hassio-addons/blob/master/almond/DOCS.md) - 开放的、保护隐私的虚拟助手.
- [HomeMatic](https://github.com/home-assistant/hassio-addons/blob/master/homematic/DOCS.md) - 基于 OCCU 的 HomeMatic 中央.
- [Let's Encrypt](https://github.com/home-assistant/hassio-addons/blob/master/letsencrypt/DOCS.md)  - 从 Let&#39;s Encrypt 获取免费的 SSL 证书； 一个开放和自动化的证书颁发机构 (CA).
- [MariaDB](https://github.com/home-assistant/hassio-addons/blob/master/mariadb/DOCS.md) - 一个开源关系数据库（MySQL 的分支）.

### Third Party Add-ons

_任何人都可以创建附加组件，以下是由社区创建的._

- [SSH & Web Terminal](https://github.com/hassio-addons/addon-ssh) - SSH 和基于 Web 的终端，带有大量预装的有用工具.
- [UniFi Controller](https://github.com/hassio-addons/addon-unifi) - UniFi 控制器允许您使用网络浏览器管理您的 UniFi 网络.
- [Node-RED](https://github.com/hassio-addons/addon-node-red) - 基于流的物联网编程.
- [Plex Media Server](https://github.com/hassio-addons/addon-plex) - 您录制的媒体精美组织并准备流式传输.
- [IDE](https://github.com/hassio-addons/addon-ide) - 基于 Cloud9 IDE 的高级基于 Web 的 IDE.
- [Dasshio](https://github.com/danimtb/dasshio) - 轻松使用您的 Amazon Dash 按钮.
- [InfluxDB](https://github.com/hassio-addons/addon-influxdb) - 用于指标、事件和实时分析的可扩展数据存储.
- [Grafana](https://github.com/hassio-addons/addon-grafana) - 用于漂亮分析和监控的开放平台.
- [Tor](https://github.com/hassio-addons/addon-tor) - 保护您的隐私并通过 Tor 访问您的实例.
- [Spotify Connect](https://github.com/hassio-addons/addon-spotify-connect) - Spotify Connect 客户端，用于在您的 Home Assistant 设备上播放音乐.
- [zigbee2mqtt](https://github.com/danielwelch/hassio-zigbee2mqtt) - Zigbee 到 MQTT 桥，摆脱您专有的 Zigbee 桥.
- [AppDaemon](https://github.com/hassio-addons/addon-appdaemon) - Python 应用程序和 HADashboard.
- [TasmoAdmin](https://github.com/hassio-addons/addon-tasmoadmin) - 集中管理您所有的 Sonoff-Tasmota 设备.
- [Aircast](https://github.com/hassio-addons/addon-aircast) - 适用于 Chromecast 播放器的 AirPlay 功能.
- [AirSonos](https://github.com/hassio-addons/addon-airsonos) - 适用于 Sonos 播放器的 AirPlay 功能.
- [Dropbox Sync](https://github.com/danielwelch/hassio-dropbox-sync) - 将您的备份快照上传到 Dropbox.
- [Log Viewer](https://github.com/hassio-addons/addon-log-viewer) - 基于浏览器的实时日志查看实用程序.
- [Tautulli](https://github.com/hassio-addons/addon-tautulli) - 监控并从您的 Plex 服务器获取统计信息.
- [motionEye](https://github.com/hassio-addons/addon-motioneye) - 为您的相机提供简单、优雅且功能丰富的 CCTV/NVR.
- [JupyterLab](https://github.com/hassio-addons/addon-jupyterlab) - 创建包含实时代码、方程式、可视化效果和解释性文本的文档.
- [Backup to Google Drive](https://github.com/samccauley/addon-hassiogooglebackup) - 备份快照到谷歌驱动器.
- [Glances](https://github.com/hassio-addons/addon-glances) - 一个用 Python 编写的跨平台系统监控工具.
- [Matrix](https://github.com/hassio-addons/addon-matrix) - 一个安全和去中心化的通信平台.
- [AdGuard Home](https://github.com/hassio-addons/addon-adguard-home) - 具有家长控制功能的全网广告和跟踪器阻止 DNS 服务器.
- [Traccar](https://github.com/hassio-addons/addon-traccar) - Traccar 是现代 GPS 跟踪平台.
- [Home Panel](https://github.com/hassio-addons/addon-home-panel) - 用于控制家庭的触摸兼容网络前端.
- [Hass.io Google Drive Backup](https://github.com/sabeechen/hassio-google-drive-backup) - 一个完整且易于配置的解决方案，用于将快照备份到 Google 云端硬盘.
- [Grocy](https://github.com/hassio-addons/addon-grocy)  - 冰箱之外的 ERP！ 适用于您家的杂货和家庭管理解决方案.
- [EmonCMS](https://github.com/inverse/hassio-addon-emoncms) - 一个强大的开源网络应用程序，用于处理、记录和可视化能源、温度和其他环境数据.
- [CrowdSec](https://github.com/crowdsecurity/home-assistant-addons) - 下一代协作 IPS/IDS 可保护您免受入侵.

## Dashboards

_Home Assistant 前端已经很漂亮了，但您可以自定义它以
适合您的需求或味道更好._

- [Dashboards Documentation](https://www.home-assistant.io/dashboards/) - 官方文档.
- [Getting started with Lovelace UI](https://www.youtube.com/watch?v=ObfRzMIEJPgx) - DrZzs 对 Lovelace UI 的精彩介绍.
- [Share the Love](https://sharethelove.io) - Lovelace 的自定义卡片演示和配置示例.
- [How to set up Lovelace](https://www.youtube.com/watch?v=n5xMtONydEo) - JuanMTech 为初学者提供的优秀分步视频.

### Icon packs

- [Font Awesome Icons](https://github.com/thomasloven/hass-fontawesome) - 在前端使用 Font Awesome 的免费图标.
- [Hass Hue Icons](https://github.com/arallsopp/hass-hue-icons) - 额外的飞利浦 Hue 灯泡和灯具图标.
- [simpleicons](https://github.com/vigonotion/hass-simpleicons) - 使用 simpleicons 集中的免费图标.

### Themes

_一切都与外观有关，应用一些风格._

- [Themes Tutorial](https://www.youtube.com/watch?v=3Xpd4zB2eRM) - 关于如何配置主题的快速教程/示例.
- [Midnight](https://community.home-assistant.io/t/midnight-theme/28598?u=frenck) - Marcel Hoffs 的深色主题.
- [Dark Cyan](https://community.home-assistant.io/t/dark-cyan-theme/28594?u=frenck) - 由 Ryoen Deprouw 设计的带有青色点缀的深色主题.
- [Grey Night](https://community.home-assistant.io/t/grey-night-theme/30848?u=frenck) - ksya 的带有灰色调的深色主题.
- [Dark Red](https://community.home-assistant.io/t/dark-red-theme/28592?u=frenck) - 由 Ryoen Deprouw 设计的带有红色点缀的深色主题.
- [Halloween](https://community.home-assistant.io/t/halloween-theme/30872?u=frenck) - 由 Mahasri Kalavala 着色的南瓜.
- [Black and Green](https://community.home-assistant.io/t/black-and-green-theme/28602?u=frenck) - GreenTurtwig 的深色主题，带有淡绿色调.
- [Vintage](https://community.home-assistant.io/t/vintage-theme/42806?u=frenck) - 用 Anup Surendran 的这个主题给你的前端一个复古的外观.
- [Carbon Green](https://community.home-assistant.io/t/share-your-themes/22018/95?u=frenck) - Reua 的绿色点缀的轻碳主题.
- [Many Themes, One Repo](https://github.com/maartenpaauw/home-assistant-community-themes/) - 一个方便的 ZIP 文件中的 13 个主题.
- [Slate](https://github.com/seangreen2/slate_theme) - seangreen2 中接近香草的深色主题.
- [Synthwave](https://github.com/bbbenji/synthwave-hass) - 受现代 Synthwave 乐队封面艺术影响的主题.
- [Google Home Theme](https://github.com/liri/lovelace-themes) - 两个主题（浅色和深色）与 Google Home Hub 的设计相匹配.

### Custom Cards

_Home Assistant Dashboards 允许人们在其上构建自定义卡片，
您可以轻松地将其添加到您的实例中._

- [Auto-Entities Card](https://github.com/thomasloven/lovelace-auto-entities) - 动态添加实体：魔法.
- [Canvas Gauge Card](https://github.com/custom-cards/canvas-gauge-card) - 使用来自 canvas-gauges.com 的超赞仪表.
- [Big Number Card](https://github.com/custom-cards/bignumber-card) - 显示传感器的大数字，包括严重级别作为背景.
- [Animated Weather Card](https://github.com/bramkragten/weather-card) - 漂亮的卡片显示天气，带有微妙的动画.
- [Thermostat Card](https://github.com/ciotlosm/lovelace-thermostat-dark-card) - 看起来像 Nest Thermostat 的恒温器控制卡.
- [Mini Media Player](https://github.com/kalkih/mini-media-player) - 简约的媒体播放器卡.
- [Mini Graph Card](https://github.com/kalkih/mini-graph-card) - 简约的传感器图形卡.
- [Button card](https://github.com/kuuji/button-card) - 您实体的按钮卡.
- [Slider Entity Row](https://github.com/thomasloven/lovelace-slider-entity-row) - 添加一个滑块来调整，例如，lovelace 实体卡中的灯光亮度.
- [Power Wheel Card](https://github.com/gurbyz/power-wheel-card) - 一种直观的方式来表示您家正在消耗或产生的能量.
- [Simple Thermostat](https://github.com/nervetattoo/simple-thermostat) - 更简单、更灵活的恒温卡.
- [Card Modder](https://github.com/thomasloven/lovelace-card-mod) - 设计你的 Lovelace 卡片.
- [Bar Card](https://github.com/Gluwc/bar-card) - Customizable animated bar card.
- [forked-daapd Card](https://github.com/kalkih/forked-daapd-card) - 控制分叉的 daapd 实例.
- [Dual Gauge Card](https://github.com/Rocka84/dual-gauge-card) - 将两个仪表合二为一.
- [Atomic Calendar Revive](https://github.com/totaldebug/atomic-calendar-revive) - 具有高级设置的日历卡.
- [Xiaomi Vacuum Card](https://github.com/benct/lovelace-xiaomi-vacuum-card) - 小米吸尘器（及其他）的详细卡片.
- [Simple Weather Card](https://github.com/kalkih/simple-weather-card) - 受 Google Material Design 启发的简约天气卡片.
- [Home Card](https://github.com/postlund/home-card) - 快速浏览您家的状况.
- [Banner Card](https://github.com/nervetattoo/banner-card) - 蓬松的可链接横幅，带有互动式外观，可为您的家庭仪表板增添趣味.
- [Spotify Card](https://github.com/custom-cards/spotify-card) - 列出并选择当前可用的设备和用户在 Spotify 上的热门播放列表.
- [Battery Entity](https://github.com/cbulock/lovelace-battery-entity) - 显示电池实体的电池电量.
- [Multiple Entity Row](https://github.com/benct/lovelace-multiple-entity-row) - 在实体行上显示多个实体状态或属性.
- [Vacuum Map Card](https://github.com/PiotrMachowski/Home-Assistant-Lovelace-Xiaomi-Vacuum-Map-card) - 此卡提供了一种用户友好的方式来完全控制小米（Roborock/Viomi/Dreame/Roidmi）和 Neato（可能还有其他）真空吸尘器.
- [Home Feed Card](https://github.com/gadgetchnnel/lovelace-home-feed-card) - 以提要的样式显示持久通知、日历事件和实体的组合.
- [Config Template Card](https://github.com/custom-cards/config-template-card) - 允许在 Lovelace 中使用模板.
- [RGB Light Card](https://github.com/bokub/rgb-light-card) - 用于控制 RGB 灯的彩色按钮.
- [LG WebOS Remote Control](https://github.com/madmicio/LG-WebOS-Remote-Control) - LG TV WebOS 的远程控制.
- [Restriction Card](https://github.com/iantrich/restriction-card) - 提供对其中定义的 Lovelace 卡的限制的卡.
- [Vacuum Card](https://github.com/denysdovhan/vacuum-card) - 用于控制真空吸尘器机器人的卡对卡.
- [Purifier Card](https://github.com/denysdovhan/purifier-card) - 一张用于控制空气净化器的卡片.
- [Raspberry Pi Status Card](https://github.com/ironsheep/lovelace-rpi-monitor-card) - 显示你的树莓派的状态.

### Alternative Dashboards

- [TileBoard](https://github.com/resoai/TileBoard) - 一个简单但高度可配置的仪表板.
- [Dwains Dashboard](https://github.com/dwainscheeren/dwains-lovelace-dashboard) - 适用于台式机、平板电脑和移动设备的完全自动生成的仪表板.

## Custom Integrations

_Home Assistant 的其他集成，由社区创建._

- [Lutron Caseta Pro](https://github.com/upsert/lutron-caseta-pro) - 集成 Lutron Caseta Smart Bridge PRO / RA2 Select.
- [SmartIR](https://github.com/smartHomeHub/SmartIR) - 使用 Broadlink IR 集成设备.
- [Xiaomi Hygrothermo](https://github.com/dolezsa/Xiaomi_Hygrothermo) - 小米米家BT Hygrothermo温湿度传感器传感器平台.
- [Volkswagen Carnet](https://github.com/robinostlund/homeassistant-volkswagencarnet) - 集成大众汽车 Carnet（需要有效的 Carnet 订阅）.
- [Untappd](https://github.com/custom-components/sensor.untapped) - 与您的 Untappd 帐户连接.
- [Elasticsearch](https://github.com/legrego/homeassistant-elasticsearch) - 将事件发布到 Elasticsearch.
- [Alexa Media Player](https://github.com/keatontaylor/alexa_media_player) - 允许控制 Amazon Alexa 设备.
- [iCloud3](https://github.com/gcobb321/icloud3) - 改进版的 iCloud 设备跟踪器组件具有很多功能.
- [HACS](https://hacs.xyz/) - 这是您自定义集成（组件）和插件（lovelace 元素）需求的管理器.
- [Circadian Lighting](https://github.com/claytonjn/hass-circadian_lighting) - 昼夜节律照明使您的变色灯光与全天天空的常规自然色温缓慢同步.
- [HASS Aarlo](https://github.com/twrecked/hass-aarlo)  - 异步 Arlo 集成. 类似于 Arlo 网站； 监控所有基站、摄像头和门铃的事件和状态.
- [Xiaomi Cloud Map Extractor](https://github.com/PiotrMachowski/Home-Assistant-custom-components-Xiaomi-Cloud-Map-Extractor) - 呈现小米（Roborock/Viomi/Roidmi/Dreame）吸尘器地图的实时视图，无需生根.
- [WebRTC Camera](https://github.com/AlexxIT/WebRTC) - 通过带有平移/缩放控件的 WebRTC 或 MSE 实时查看来自 IP 摄像机的 RTSP 流.
- [Sonoff LAN](https://github.com/AlexxIT/SonoffLAN) - 通过 LAN 和/或云使用 eWeLink（原始）固件控制 Sonoff 设备.
- [Spotcast](https://github.com/fondberg/spotcast) - 在空闲的 Chromecast 设备上启动 Spotify 播放以及控制 Spotify 连接设备.
- [The Watchman](https://github.com/dummylabs/thewatchman) - 跟踪配置文件中缺失的实体和服务.

## DIY

 _自己做; 而不是购买家庭自动化硬件或解决方案，你
也可以自己建造！_

- [ESPHome](https://esphome.io/) - 使用 YAML 对 ESP8266 板和 ESP32 板进行编程.
- [Magic Cards](https://github.com/maddox/magic-cards) - RFID 可扫描卡，您可以对其进行编程以执行任何操作.
- [Tasmota](https://github.com/arendst/Tasmota) - ESP8266 板和设备的固件.

### DIY Gateways

- [OpenMQTTGateway](https://github.com/1technophile/OpenMQTTGateway) - 适用于 IR、RF、BLE、MiFlora、SMS 和许多传感器的灵活 MQTT 网关.
- [esp8266 Milight Hub](https://github.com/sidoh/esp8266_milight_hub) - 使用 MQTT 的 Milight/LimitlessLED 设备的替代集线器.
- [zigbee2mqtt](https://github.com/Koenkk/zigbee2mqtt) - Zigbee 到 MQTT 桥，摆脱您专有的 Zigbee 桥.

### DIY Projects

- [HA SwitchPlate](https://community.home-assistant.io/t/ha-switchplate-diy-lcd-touchscreen-wall-switch-replacement/25464?u=frenck) - LCD 触摸屏墙壁开关更换.
- [DIY Multisensor](https://www.youtube.com/watch?v=jpjfVc-9IrQ) - 15 美元，温度、湿度、光线、运动和 RGB LED，无需焊接.
- [$10 WiFi RGB Bulb](https://community.home-assistant.io/t/how-to-inexpensive-10-us-wifi-rgb-bulb-that-works-with-home-assistant/14735?u=frenck) - 采用适用于 WiFi 的廉价 RGB 灯泡.
- [433mhz/IR Bidirectional Gateway](https://community.home-assistant.io/t/433mhz-infrared-ir-to-and-from-mqtt-on-esp8266/6779?u=frenck) - 使用 ESP8266 和 MQTT 的 IR 和 433mhz 双向.
- [esp8266MQTTBlinds](https://community.home-assistant.io/t/esp8266-window-blinds-mqtt/14863?u=frenck) - 使用 ESP8266、伺服和 MQTT 使您的百叶窗自动化.
- [Home Assistant's Hackster.io](https://www.hackster.io/home-assistant?f=1#_=_) - 一个包含多个 DIY 项目的 Hackster 频道.
- [ESP MQTT Digital LEDs](https://github.com/bruhautomation/ESP-MQTT-JSON-Digital-LEDs) - 用于 BRUH 的 JSON 灯组件的 WS2811 LED 条纹.
- [Bed Presence Detection](https://selfhostedhome.com/diy-bed-presence-detection-home-assistant/) - 基于 ESP8266 的床存在检测.
- [NFC Scanner](https://github.com/klaasnicolaas/ha_nfc_scanner) - 使用 ESP8266、PN532 和 MQTT 构建 NFC 标签/卡扫描器.
- [ESP32-Cam Facebox](https://www.dopebuild.com/i-am-sorry-dave-i-am-unable-to-do-that/) - 将 ESP32-CAM、HA 和 Facebox 结合在一起以获得廉价的面部识别/家庭监控解决方案.
- [RaspiPool](https://github.com/segalion/raspipool) - 具有成本效益、易于构建、易于使用的“游泳池自动化系统”.
- [QuinLED](https://quinled.info/) - 使用 ESP32 板 DIY Wi-Fi LED 调光器和控制器.

## Online Resources

_指向定期发布 Home Assistant 重点内容的 Home Assistant 各种用户的链接._

### Blogs

- [DIY Futurism](https://diyfuturism.com/) - Brad 发表文章，为新用户提供很好的指导.
- [Phil Hawthorne](https://philhawthorne.com/homeautomation) - 家庭助理播客的联合主持人.
- [Smart Home Hobby](https://smarthomehobby.com/) - 提供预算友好的指南和信息.
- [Self Hosted Home](https://selfhostedhome.com/) - 关于 DIY 家庭自动化项目和自托管服务的文章.
- [Tinkering with Home Automation](https://blog.ceard.tech/) - Tinkerer 的博客和指南.
- [HomeTechHacker](https://HomeTechHacker.com) - DIY 智能家居指南、评论和建议.
- [Intermittent Technology](https://blog.quindorian.org) - Quindor 的个人博客，用于随机粘贴（主要是与技术相关的）内容.

### YouTube Channels

_坐下来，放松，观看，学习._

- [Home Assistant](https://www.youtube.com/channel/UCbX3YkedQunLt7EQAdVxh7w) - 举办新品发布和直播的官方 YouTube 频道.
- [BRUH](https://www.youtube.com/channel/UCLecVrux63S6aYiErxdiy4w) - Ben 有很棒的入门教程，不幸的是，最近不活跃.
- [BurnsHA](https://www.youtube.com/channel/UCSKQutOXuNLvFetrKuwudpg) - 很棒的信息和教程视频.
- [DrZzs](https://www.youtube.com/channel/UC7G4tLa4Kt6A9e3hJ-HO8ng) - 很棒的操作视频和直播.
- [The Hook Up](https://www.youtube.com/channel/UC2gyzKcHbYfqoXA5xbyGXtQ) - 教程等，还有关于一般家庭自动化的视频.
- [HASSCASTS](https://www.youtube.com/channel/UCGOCeqMJnLvr-5C-ypUw7IQ) - 提示、技巧和教程，主要转向直播.
- [JuanMTech](https://www.youtube.com/juanmtech) - 易于理解操作视频、产品评论等.
- [vCloudInfo](https://www.youtube.com/vCloudInfo) - 根据他的家庭和 GitHub 存储库发布视频.
- [digiblurDIY](https://www.youtube.com/channel/UC5ZdPKE2ckcBhljTc2R_qNA) - 硬件项目和 Tasmota 自动化教程.
- [Intermit.Tech](https://www.youtube.com/channel/UCv7UOhZ2XuPwm9SN5oJsCjA) - 教程和评论：相机、家庭网络、ESP8266 开发板、Node-RED.
- [BeardedTinker](https://www.youtube.com/channel/UCuqokNoK8ZFNQdXxvlE129g) - 教程和 3D 打印.
- [Smart Home Junkie](https://www.youtube.com/channel/UCVtQ4AOSmCFUuvixddYiSxw/) - 面向初学者和高级用户的操作视频和教程.
- [Everything Smart Home](https://www.youtube.com/c/EverythingSmartHome) - 专注于智能家居、家庭自动化、一般技术评论、指南和分步 DIY 项目.

### Podcasts

_在上下班途中、做早上的例行公事或在健身房获得灵感！_

- [Home Assistant Podcast](https://hasspodcast.io) - 双周播客，提供最新消息和有趣的嘉宾.

### Twitter

_了解最新消息和更新，一次 280 个字符！_

- [@home_assistant](https://twitter.com/home_assistant) - 将本地控制和隐私放在首位的开源家庭自动化.
- [@hass_devs](https://twitter.com/hass_devs) - 为投稿人提供 Home Assistant 开发的最新消息.
- [@balloob](https://twitter.com/balloob) - Home Assistant 项目的创始人.
- [@pvizeli](https://twitter.com/pvizeli) - Hass.io 项目的核心开发者和创建者.
- [@frenck](https://twitter.com/frenck) - 这个 Awesome 列表的创建者和 Community Hass.io Add-ons 项目的维护者.
- [@ccostan](https://twitter.com/ccostan) - Blogger of all things Tech. Smart Home, #IOT & other Geeky subjects.
- [@HomeTechHacker](https://twitter.com/HomeTechHacker) - Guy friends call when #tech happens. Tweet 25-50x/week about #smarthome, #homenetwork, #cybersecurity, #Linux, #gadgets, and #life.
- [@hassioaddons](https://twitter.com/hassioaddons) - 对于所有社区附加新闻和更新.
- [@Dr_Zzs](https://twitter.com/Dr_Zzs) - 很棒的操作视频和直播.

## Uncategorized

_有价值的链接，不属于上述任何类别（还！）._

- [Room Assistant](https://github.com/mKeRix/room-assistant) - 一个伴侣客户端来处理多个房间的传感器.
- [Home Assistant Companion](https://itunes.apple.com/us/app/home-assistant-open-source-home-automation/id1099568401?mt=8) - iPhone/iPad/iOS 应用程序远程控制和监控您的家.
- [Mi Flora via MQTT daemon](https://github.com/ThomDietrich/miflora-mqtt-daemon) - 通过 MQTT 收集和传输小米 Mi Flora 植物传感器数据.
- [hassctl](https://github.com/dale3h/hassctl) - 简单的命令行实用程序可帮助调试您的配置.
- [rhasspy](https://github.com/rhasspy/rhasspy) - 用于开发自定义语音助手的工具包.
- [Fully Kiosk Browser](https://www.ozerov.de/fully-kiosk-browser/) - 高度可配置的 Android Kiosk 浏览器和应用程序启动器.
- [AppDaemon](https://github.com/AppDaemon/appdaemon) - AppDaemon 是一个松散耦合的多线程沙盒 Python 执行环境，用于编写自动化应用程序.
- [Developer Documentation](https://developers.home-assistant.io/) - 官方开发者文档.
- [HASS Configurator](https://github.com/danielperna84/hass-configurator) - 基于浏览器的配置文件编辑器.
- [HA-Dockermon](https://github.com/philhawthorne/ha-dockermon) - 用于 RESTful 开关的 Node.js 服务，用于控制 Docker 容器.
- [Python Amazon Dash](https://github.com/Nekmo/amazon-dash)  - 破解您的 Amazon Dash 以运行您想要的. 没有焊工.
- [homekit2mqtt](https://github.com/hobbyquaker/homekit2mqtt) - HomeKit 到 MQTT 桥.
- [Home Assistant Device Database](https://www.hadevices.com/) - 支持/确认工作设备的数据库.
- [Jinja Scripts for Curious Minds](https://github.com/skalavala/mysmarthome/tree/master/jinja_helpers) - 一堆 Jinja2 脚本帮助你更好地理解它.
- [Ariela](https://play.google.com/store/apps/details?id=com.surodev.ariela) - Freemium Android client application with widget support.
- [Gitlab CI/CD](https://about.gitlab.com/2018/08/02/using-the-gitlab-ci-slash-cd-for-smart-home-configuration-management/) - 如何使用 GitLab CI/CD 简化您的智能家居配置.
- [Monitor](https://github.com/andrewjfreyer/monitor) - 通过 MQTT 报告的分布式基于广告的 BTLE 存在检测.
- [HASS-data-detective](https://github.com/robmarkcole/HASS-data-detective) - 探索和分析您的数据库数据.
- [ADB Intents](https://gist.github.com/mcfrojd/9e6875e1db5c089b1e3ddeb7dba0f304) - 用于控制 Android 设备的 ADB 意图列表.
- [Home Assistant Config Helper for VSCode](https://marketplace.visualstudio.com/items?itemName=keesschollaart.vscode-home-assistant) - Visual Studio 代码扩展，在编辑配置时提供自动完成、配置验证和代码片段.
- [Home Assistant Taskbar Menu](https://github.com/PiotrMachowski/Home-Assistant-Taskbar-Menu) - 一个 Windows 客户端，可以显示 Lovelace 视图、控制实体并显示持久通知.

## Alternative Home Automation Software

_Home Assistant 不是唯一的家庭自动化框架，在这里
有一些选择._

- [openHAB](https://github.com/openhab) - 基于Java，旨在成为一个通用的集成平台.
- [Domoticz](https://github.com/domoticz/domoticz) - 轻量级家庭自动化系统.
- [Gladys](https://github.com/GladysProject/Gladys) - 在您的 Raspberry Pi 上运行的开源程序.
- [SmartThings](https://www.smartthings.com/) - 三星的商业家庭自动化中心.

## Other Awesome Lists

_Other amazingly awesome lists that can be found on the great and dangerous
interwebs._

- [awesome-smarthome](https://github.com/pfalcon/awesome-smarthome) - 很棒的智能家居/家庭自动化事物的精选列表.
- [awesome-iot](https://github.com/HQarroum/awesome-iot) - 很棒的物联网项目和资源的精选列表.
- [awesome-open-iot](https://github.com/Agile-IoT/awesome-open-iot) - 精选的开源物联网框架、库和软件列表.
- [awesome-amazon-alexa](https://github.com/miguelmota/awesome-amazon-alexa#readme) - 亚马逊 Alexa 平台的精选资源列表.
- [awesome-mqtt](https://github.com/hobbyquaker/awesome-mqtt#readme) - 精选的 MQTT 相关内容列表.
- [awesome-selfhosted](https://github.com/awesome-selfhosted/awesome-selfhosted) - 很棒的自托管软件的精选列表.

## Contributing

这个很棒的列表是一个活跃的开源项目，并且始终对
想为之做出贡献的人. 我们已经建立了一个单独的文档
包含我们 [Contribution Guidelines](https://github.com/frenck/awesome-home-assistant/blob/master/CONTRIBUTING.md).

这个很棒的列表的原始设置是 [Franck Nijhof](https://twitter.com/frenck).

有关所有作者和贡献者的完整列表，请查看
[contributor's page](https://github.com/frenck/awesome-home-assistant/graphs/contributors).

感谢您的参与！

## Trademark Legal Notice

这个 Awesome 列表不是创建、开发、附属、支持、维护
或由 Home Assistant 认可.

所有产品名称、标识、品牌、商标和注册商标均为
各自所有者的财产. 所有公司、产品和服务名称
此列表中使用的仅用于识别目的.

使用这些名称、徽标、商标和品牌并不意味着认可.
