<div class="github-widget" data-repo="Dvergar/awesome-haxe-gamedev"></div>
<div align="center"><a href="https://haxe.org/"><img src="https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/master/images/haxe-logo.png" width="500"></a></div>

## Awesome Haxe Game Development [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

A curated list of game development resources for **[Haxe 4](https://haxe.org/)**, a high level strictly typed programming language which is used to produce cross-platform native code.

Feel free to update it.


## Game engines

Those are Haxe 4 compatible game engines
* [Armory (Kha)](https://github.com/armory3d/armory) - An open-source 3D game engine with full Blender integration (`Web`, `Mobile`, `Desktop`, `Consoles`).
* [Away3D](https://github.com/openfl/away3d) - An open source, real-time 3D engine for OpenFL (`Web`, `Mobile`, `Desktop`).
* [ceramic](https://github.com/ceramic-engine/ceramic) - Cross-platform 2D framework (`Web`, `Mobile`, `Desktop`, `Unity`).
* [HaxeFlixel (OpenFL)](https://github.com/HaxeFlixel/flixel) - Free, cross-platform 2D game engine powered by OpenFL (`Web`, `Mobile`, `Desktop`, `Consoles`).
* [Haxegon (OpenFL)](https://github.com/haxegon/haxegon) - A programming library for beginners. Powered by OpenFL and Starling (`Web`, `Mobile`, `Desktop`, `Consoles`).
* [Heaps](https://github.com/HeapsIO/heaps) - High Performance Game Framework (`Web`, `Mobile`, `Desktop`, `Consoles`).
* [hxdefold](https://github.com/hxdefold/hxdefold) - Haxe/Lua externs for Defold game engine (`Web`, `Mobile`, `Desktop`).
* [OpenFL](https://github.com/openfl/openfl) - Interactive game and app development library (`Web`, `Mobile`, `Desktop`, `Consoles`).
* [Starling](https://github.com/openfl/starling) - The "Cross-Platform Game Engine", a popular Stage3D framework (`Web`, `Mobile`, `Desktop`).
* [Stencyl (OpenFL)](https://github.com/Stencyl/stencyl-engine) - Create Flash, HTML5, iOS, Android, and desktop games with no code (`Mobile`, `Desktop`).
* [unreal.hx](https://github.com/proletariatgames/unreal.hx) - Haxe Integration for Unreal (`Web`, `Mobile`, `Desktop`, `Consoles`).
* [HxGodot (Godot 4.0)](https://github.com/HxGodot/hxgodot) - A Haxe GDExtension for Godot 4 (`Web`, `Mobile`, `Desktop`, `Consoles`).

## Low-level Engine
* [Kha](https://github.com/Kode/Kha) - Ultra-portable, high performance, open source multimedia framework (`Web`, `Mobile`, `Desktop`, `Consoles`).    
* [Lime](https://github.com/openfl/lime) - A flexible, lightweight layer for Haxe cross-platform developers (`Web`, `Mobile`, `Desktop`).      
* [linc_glfw](https://github.com/Sunjammer/linc_glfw) - Desktop - GLFW binding (multi-platform library for OpenGL, OpenGL ES and Vulkan) _(Desktop)_.
* [NME](https://github.com/haxenme/nme) - A cross-platform native backend (`Web`, `Mobile`, `Desktop`).
* [3DSHaxe](https://github.com/Krismowo/3DSHaxe) - Make 3ds homebrew! (`3DS`).

## Physics
* [echo](https://github.com/AustinEast/echo/) - Simple Physics Library.
* [haxebullet](https://github.com/armory3d/haxebullet) - Bullet 3D Physics.
* [nape-haxe4](https://github.com/HaxeFlixel/nape-haxe4) - Physics Engine (the original Haxe3 version of nape can be found [here](https://github.com/deltaluca/nape)).



## Architecture
```
IoC == Inversion of Control  
EC == Entity Component  
ECS == Entity-Component-System
FSM == Finite State Machine
MVC == Model View Controller
```

* [awe6](https://github.com/hypersurge/awe6) - `IoC`, `EC` - The inverted game framework, is a development tool focused on Future Proofing.
* [ecx](https://github.com/eliasku/ecx) - `ECS` - An Entity Component System framework.
* [hexMachina](https://github.com/DoclerLabs/hexCore) - `MVC` - A powerful multi-modular MVC framework.
* [OSIS](https://github.com/Dvergar/OSIS) - `ECS` - Entity Component System architecture with networking support.


## Networking
* [Anette](https://github.com/Dvergar/Anette) - Simple network library (no UDP).
* [colyseus-hx](https://github.com/colyseus/colyseus-hx) - Multiplayer Game Client.
* [haxe-simple-peer (js)](https://github.com/melonin/haxe-simple-peer) - Haxe externs for simple-peer.
* [hxWebSockets](https://github.com/ianharrigan/hxWebSockets) - Websockets for all platforms.
* Built-in - Heaps, OpenFL (HaxeFlixel & co), Kha (Armory).


## Serialization and storage
* [Bits](https://github.com/RealyUniqueName/Bits) - Binary bit flags with unlimited amount of bits.
* [CastleDB](https://github.com/ncannasse/castle) - A structured static database easing collaboration.
* [hxbit](https://github.com/ncannasse/hxbit) - A binary serialization and network synchronization library.
* [PODStream](https://github.com/Dvergar/PODStream) - Plain Old Data serializer.



<!--lint disable awesome-list-item-->
## Games
* [Darksburg](https://store.steampowered.com/app/939100/Darksburg/) - Heaps - `Desktop`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/darksburg.jpg)
* [Dead Cells](https://dead-cells.com/) - Heaps - `Desktop`, `Consoles`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/dead-cells.jpg)
* [Defender's Quest](http://www.defendersquest.com/) - HaxeFlixel (OpenFL) - `Desktop`, `Consoles`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/defenders-quest.jpg)
* [Defender's Quest 2](https://store.steampowered.com/app/252190/Defenders_Quest_2_Mists_of_Ruin/) - HaxeFlixel (OpenFL) - `Desktop`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/defenders-quest-2.jpg)
* [Dicey Dungeons](http://diceydungeons.com/) - Haxegon (OpenFL) - `Desktop`, `Consoles`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/dicey-dungeons.jpg)
* [Evoland](http://evoland.shirogames.com/) - Heaps - `Desktop`, `Mobile`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/evoland.jpg)
* [Northgard](http://northgard.net/) - Heaps - `Desktop`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/northgard.jpg)
* [Papers, Please](http://papersplea.se/) - OpenFL - `Desktop`, `iOS`, `PsVita`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/papers-please.jpg)
* [Pocket Kingdom](https://store.steampowered.com/app/462620/Pocket_Kingdom/) - HaxePunk (OpenFL)- `Desktop`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/pocket-kingdom.jpg)
* [rymdkapsel](https://rymdkapsel.com/) - OpenFL - `Desktop`, `Mobile`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/rymdkapsel.jpg)
* [Spellbreak](https://playspellbreak.com/) - unreal.hx -  `PC`, `PS`, `Xbox`, `Switch`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/spellbreak.jpg)
* [The Westport Independent](http://www.doublezeroonezero.com/westport.html) - Luxe - `Desktop`, `Mobile`.
    * ![Screenshot](https://raw.githubusercontent.com/Dvergar/awesome-haxe-gamedev/main/images/westport-independent.jpg)
<!--lint enable-->


More showcase :
* [OpenFL showcase](https://www.openfl.org/showcase)
* [HaxeFlixel showcase](https://haxeflixel.com/showcase/)
* [itch.io showcase](https://itch.io/games/made-with-haxe)
* [HaxePunk showcase](https://haxepunk.com/games/)
* [Flambe showcase](https://github.com/aduros/flambe/wiki/Showcase)
* [Kha showcase](https://github.com/Kode/Kha/wiki/Games-Built-With-Kha)

## Miscellaneous

### 3rd party API
* [SteamWrap](https://github.com/larsiusprime/SteamWrap) - Native extension for the SteamAPI.
* [newgrounds](https://lib.haxe.org/p/newgrounds) - Newgrounds API.
* [hxgamejolt-api](https://github.com/MAJigsaw77/hxgamejolt-api) - Haxe bindings for GameJolt API.

### AI
[goap](https://gitlab.com/haath/goap) - Goal-oriented action planner for AI.

### Animation
* [spine-hx](https://github.com/jeremyfa/spine-hx) - Spine runtime automatically converted from the official Java/libgdx runtime.
* HaxeFlixel - Spine parser.
* [Heaps-Spine](https://github.com/Beeblerox/Heaps-Spine) - Spine player for heaps.
* [heaps-aseprite](https://github.com/AustinEast/heaps-aseprite) - Load and render sprites and animations in Aseprite format.
* [openfl-aseprite](https://github.com/miriti/openfl-aseprite) - Load and render sprites and animations in Aseprite format.
* [openfl-spine](https://github.com/rainyt/openfl-spine) - Render Spine animation in the OpenFL engine, rendering processing can be achieved throughSprite and Tilemap.
* [ase](https://github.com/miriti/ase) - File format reader/writer for .ase/.aseprite without external dependencies.
* [flxgif](https://github.com/MAJigsaw77/flxgif) - Yagp's Gif Player for HaxeFlixel.

### Audio
* [sfxr-hx](https://github.com/jobf/sfxr-hx) - Pure haxe implementation of Sfxr.

### Color manipulation
* [nxColor](https://github.com/oscarcs/nxColor) - Color manipulation library.

### Collision
* [differ](https://github.com/snowkit/differ) - A separation axis theorem collision library.

### Computer Vision
* [Vision](https://github.com/ShaharMS/Vision) - Cross platform computer vision library.

### Data structures
* [polygonal-ds](https://github.com/polygonal/ds) - Data structures for games.

### Dialogues
* [hxyarn](https://github.com/cxsquared/hxyarn) - Parser and runner for Yarn dialogue files.

### Editor
* [flixel-studio](https://github.com/Dovyski/flixel-studio) - In-game editor for HaxeFlixel.

### Helpers
* [deepnightLibs](https://github.com/deepnight/deepnightLibs) - General gamedev purpose libs.

### Localization
* [firetongue](https://github.com/larsiusprime/firetongue) - A translation/localization framework.

### Map parser
* [PyxelEdit Map Importer](https://github.com/Dvergar/PyxelEdit-Map-Importer) - Parser for maps generated by the editor PyxelEdit.
* Heaps - Built-in parser for Tiled.
* HaxeFlixel - Parser for Tiled & Ogmo.
* [LEd](https://github.com/deepnight/led-haxe-api) - 2D level editor with a typed compile time loader.
* [TiledHX](https://github.com/yanrishatum/tiledhx) - A comprehensive modern Tiled parser.

### Math helpers
* [hxmath](https://github.com/tbrosman/hxmath) - A game-oriented math library.
* [haxe-glm](https://github.com/hamaluik/haxe-glm) - A toolset for using 2, 3, and 4 dimensional vectors and matrices, as well as quaternions.
* [hx-vector2d](https://github.com/markknol/hx-vector2d) - Worlds most complete Vector2d / Point class. With operator overloading.

### Modding
* [polymod](https://github.com/larsiusprime/polymod) - An atomic modding framework for games/apps.

### Particles
* [Sparkler](https://github.com/RudenkoArts/sparkler) - Modular Particle System.

### Monetization
* [extension-iap](https://github.com/charmdev/extension-iap) - Provides an access to in-app purchases (iOS) and in-app billing (Android) for OpenFL projects using a common API. Fork of [this](https://github.com/HaxeExtension/extension-iap).

### Pathfinding
* [pathfinder](https://github.com/hypersurge/pathfinder) - Easy A* pathfinding algorithm.
* [astar](https://gitlab.com/haath/astar) - Versatile framework-agnostic A-star solver Library.

### Procedural generation
* [Dungeon builder](https://github.com/julsam/dungeon-builder) - A set of dungeon generation algorithm (works w/ hx4 w/ minor changes).

### Shaders
* [HGSL](https://github.com/saharan/HGSL) - Haxe to GL Shading Language.
* [parasol](https://github.com/47rooks/parasol) - HaxeFlixel library of shaders.

### Sprite 
* [haxe-aseprite](https://github.com/PongoEngine/haxe-aseprite) - Parser for .ase and .aseprite files.

### Texture Packer 
* [hxpk](https://github.com/bendmorris/hxpk) - Port of the libGDX Texture Packer.

### Tweening 
* [actuate](https://github.com/jgranick/actuate) - A flexible, fast "tween" library.
* [YATL](https://github.com/Yanrishatum/yatl) - Yet Another (Haxe) Tweening Library.
* [TweenX/TweenXCore](https://github.com/shohei909/tweenx) - Tween library.

### UI 
* [domkit](https://github.com/ncannasse/domkit) - CSS Components based strictly typed UI framework.
* [flixel-ui](https://github.com/HaxeFlixel/flixel-ui) - GUI library for HaxeFlixel.
* [HaxeUI](http://haxeui.org/) - UI library with multiple framework backends (HTML5, Kha, OpenFL, PixiJS, WxWidgets, and a number of others as works in progress).
* [Feathers UI](https://feathersui.com/) - Cross-platform graphical user interface components for creative frontend projects.

### Video
* [hxCodec](https://github.com/polybiusproxy/hxCodec) - Adds native video playback on HaxeFlixel and OpenFL.

## Articles
* [Flash is dead, long live OpenFL!](http://gamasutra.com/blogs/LarsDoucet/20140318/213407/Flash_is_dead_long_live_OpenFL.php)
* [Flash is gone, what now?](https://www.linkedin.com/pulse/flash-gone-what-now-matan-uberstein/)
* [How I wrote my own 3D game engine and shipped a game with it in 20 months](https://kircode.com/post/how-i-wrote-my-own-3d-game-engine-and-shipped-a-game-with-it-in-20-months)
* [Building 42 games within a year — Insane game development](https://medium.com/@mknol/building-42-games-within-a-year-insane-game-development-5340d506068f)
* [Porting to console via Unity](https://do-games.com/blog/the-adventure-pals-console-tech-part1)

## Other haxe lists
* [awesome haxe](https://github.com/nadako/awesome-haxe)
* [awesome snowkit](https://github.com/anissen/awesome-snowkit)
* [awesome haxe js](https://github.com/MatthijsKamstra/awesome-haxe-js)
