<div class="github-widget" data-repo="dribdat/awesome-hackathon"></div>
## Awesome Hackathon

A curated open list of platforms and tools that can help you to **organize and run** tolerant and productive hackathons. 

> This list tries to cover what is ⚡️awesome⚡️ about [hackathons](https://en.wikipedia.org/wiki/Hackathon), hackdays and hacknights, and the community of organizers who run them! See also 🕶️[awesome-hackathons](https://github.com/mbiesiad/awesome-hackathons), 🕶️[awesome-hackathon-projects](https://github.com/Olanetsoft/awesome-hackathon-projects) and 🕶️[awesome-hackathon-starters](https://github.com/geekcamp-ph/awesome-hackathon-starters/issues/12). Are you interested in the _science_ of hackathons? Join our new 📚 [Zotero library](https://www.zotero.org/groups/5538025/awesome_hackathons).

To help improve this list, please check out the [Contributing](#Contributing) section.



## Platforms

By _awesome 🕶️ hackathon platforms_, we mean web or mobile applications that are specifically designed to run a hackathon, or which have effectively adapted for use in events of this type. They typically allow organizers to announce the schedule and topics, register participants, and document the results.

### Open Source 🌳

> These can be run with a cloud provider or self-hosted, to take full control of the data. Being open source efforts, they typically embrace open standards. Several are developed by non-profits and volunteer communities. 

- [ApplicantAtlas](https://github.com/ApplicantAtlas/ApplicantAtlas) - Made for managing applicants, RSVPs and other communications.
- [Civic Tech Exchange](https://github.com/DemocracyLab/CivicTechExchange) - Online platform for Democracy Lab projects.
- [DeltaHacks Portal](https://github.com/deltahacks/portal) - The attendee & admin portal for DeltaHacks 10, the hackathon for change.
- [Dribdat](https://github.com/dribdat/dribdat) - **Hackathons for impact, based on open data and web standards.** `python` `js`
- [Hack the Back](https://github.com/hackthevalley/hack-the-back) - An elegant backend, with ready-made GraphQL and REST endpoints. 
- [HackAssistant](https://github.com/HackAssistant/hackassistant) - Hackathon registration server.
- [Hackatuning](https://github.com/leognmotta/hackatuning) - Early stage hackathon management platform. `js`
- [HackathonManager](https://github.com/codeRIT/hackathon-manager) - Hackathon registration & logistics, compatible with MyMLH.
- [HackDash](https://github.com/impronunciable/hackdash) - Organize hackaton ideas into a dashboard.
- [Hackerspace3](https://github.com/govhackaustralia/hackerspace3) - Competition Management System for the GovHack Hackathon. `ruby`
- [HackPortal](https://github.com/acmutd/hackportal) - A platform from HackUTD for user-friendly event management.
- [Halo](https://github.com/tcnj-acm/halo) - Hackathon Management System built on Django.
- [Hibiscus](https://github.com/HackSC/hibiscus) - An all-in-one, plug-and-play hackathon platform, created for HackSC.
- [JunctionApp](https://github.com/hackjunction/JunctionApp) -  All-in-one hackathon platform for organisers, maintained by Junction.
- [OpenHackathon](https://github.com/kaiyuanshe/OpenHackathon-Web) - Platform with Git-based Cloud Development Environment based on Next.js.
- [Opportunity Hack](https://github.com/opportunity-hack) - Skills-Based Volunteering for Social Good, matching people to projects.
- [project-hackathon](https://github.com/pheralb/project-hackathon) - Hackathon management tool created at Hackafor. `typescript`

### Closed Source 🔒

> Despite having a presence on GitHub, the core sources of these applications are at this time closed, or the licenses are unspecified.

- [Agorize](https://github.com/agorize) - A French company that provides open innovation software.
- [Devfolio](https://github.com/devfolioco) - Supporting India's 'largest and fastest growing community of builders'.
- [Devpost](https://github.com/challengepost) - U.S. company whose customers market developer tools and jobs to the community.
- [Hacksuite](https://github.com/DevtranetHQ/Hacksuite) - A fullstack suite of apps from Devtranet for hosting virtual hackathons.
- [Hackworks](https://github.com/hackworks) ([docs](https://help.hackworks.com/knowledge)) - Open innovation challenge platform from experienced event organizers in Canada. 
- [Stackref](https://github.com/StackRef) ([docs](https://docs.stackref.com/)) - Internal hackathon and ideation, with cloud provisioning and judging features.
- [TAIKAI](https://github.com/taikai) - Connects creators and companies, using hackathons, bounties and hiring challenges.

### Unmaintained 🧊

> These projects, while open source, are no longer showing signs of active development. Please contact us if you think otherwise! They might need your help, or have valuable content that could be reused.

- [chronicel](https://github.com/kbohinski/chronicel) - A minimal registration system for a smaller, more personal hackathon.
- [Find Hackathon](https://github.com/Find-Hackathon) - A Cross-Platform Mobile Application for finding Hackathons.
- [Hackfoldr](https://github.com/hackfoldr/hackfoldr) - Organize gdoc and hackpad documents for hackathons.
- [Kent Hack Enough](https://github.com/hacksu/kenthackenough) - Legacy registration and staff management API for HackSU events.
- [LaraHack](https://github.com/ScientificClubofESI/LaraHack) - Administration system designed for hackathons and similar competitions.
- [Ninjathon](https://github.com/shilomagen/hackathon-matching-platform) - Hackathon managing platform.
- [Nucleus](https://github.com/hacktx/nucleus) - Hackathon application system that integrates with MyMLH, Slack and more from HackTX.
- [Pepper](https://github.com/rohitdatta/pepper) - Designed to work with MyMLH for sign in.
- [Quill](https://github.com/techx/quill) - A registration system designed especially for large hackathons, maintained by HackMIT.
- [React Hackathon Board](https://github.com/hirako2000/react-hackathon-board) - Web application to manage Hackathon events.
- [Scout24](https://github.com/Scout24/hackathon-management-system) - Hackathon management system from a company.
- [Sledge](https://github.com/HackRU/sledge) - A judging system for hackathons developed at Rutgers University.
- [VersusVirus App](https://github.com/VersusVirus-Hackathons/VersusVirus-App) - For managing teams at large online hackathons.

### Organisations

> Companies that provide products and services for, or regularly organise, hackathons.

- [Hack the Hackathon](https://hackthackathon.github.io/) is an interdisciplinary community exploring scientific collaboration, learning & civic engagement.
- [Hack2Skill](https://hack2skill.com) hosts events on their [own platform](https://hack2skill.com/organizeHack) and [shares resources](https://blog.hack2skill.com/what-is-a-hackathon-a-complete-guide-about-hackathon) for technology innovators.
- [Hackathon.com](https://www.hackathon.com/) from [BeMyApp Corporation](https://www.bemyapp.com/organize-your-hackathon.html) promotes events globally, and offers [commercial services](https://corporate.hackathon.com/).
- [HackerEarth](https://www.hackerearth.com/) is a commercial platform for sourcing, assessing, interviewing, and upskilling developers.
- [HYPE](https://www.hypeinnovation.com/about) provides software to help idea and innovation managers collect and manage ideas.
- [Mercer | Mettl](https://mettl.com/about/) sees [hackathons as a tool](https://mettl.com/online-hackathons/) for building tech teams and fostering collaboration.
- [Microsoft](https://www.microsoft.com/en-us/garage/blog/category/hackathons/) sponsors and [offers advice](https://learn.microsoft.com/en-us/power-platform/guidance/adoption/hackathons) for hackathons - see the [AcademicContent](https://github.com/microsoft/AcademicContent/blob/main/hackathon-content.md) repo for participants.
- [Random Hacks of Kindness](https://github.com/randomhacks) global hackathon series for charities, non-profits and social enterprise (see also: [RHOK, Jr.](https://rhokjr.org/) and [RHOK CPH](https://www.rhok-cph.org/)).
- [Tulula](https://tulu.la/hackathons-and-challenges) runs online competitions and hackathons based on an [online platform](https://tulula.gitbook.io/docs/setup-guide/quick-start).
- [Unstop](https://unstop.com/) provides virtual event platforms to organize hackathons and coding tests.

## Tooling

> These are frameworks, utilities and online tools for solving a variety of issues that hackathon organizers commonly face. They often have some way of integrating with the platforms above. See also the [Guides](#guides) listed further down, which cover many of the same topics.

### Organizing

- [BoilerBot](https://github.com/BoilerMake/boilerbot) - Take control of your Slack by creating groups, assigning tasks, and more.
- [Hackme](https://github.com/p1utoze/Hackme) (unmaintained?) - Minimalistic hackathon registration and participant status monitoring.
- [HaQR](https://github.com/drewthoennes/HaQR) (unmaintained) - A modular QR code management system for hackathons and other events.
- [Hubot-RedisRed](https://github.com/Detry322/hubot-redisred) - As well as [hubot-group](https://github.com/anishathalye/hubot-group), [hubot-conf](https://github.com/anishathalye/hubot-conf), [hubot-shortcut](https://github.com/anishathalye/hubot-shortcut) by HackMIT are [Hubot](https://hubot.github.com/) plugins to make organizing easier.
- [Planning Kit](https://hackathon-planning-kit.org/) - Get information about how to design a hackathon that fits your needs.

### Promoting

- [Hackathon Sponsorship](https://github.com/Neuro-Hack/sponsorship#readme) 🕶️  A crowdsourced 'Awesome List' of companies to contact.
- [Hackalist](https://github.com/Hackalist/Hackalist.github.io#readme) - A list of upcoming hackathons from around the world. 
- [Hack Club](https://github.com/hackclub/hackathons#readme) - A curated list of hackathons organized for high schoolers.
- [Scrapbook](https://github.com/hackclub/scrapbook) by HackClub - A daily streak system & portfolio for your projects.
- [Open Source Events](https://github.com/Catalyst-IN/OpenSourceEvents-Frontend) - This website contains a monthly calendar of events and hackathons (project is archived as of Feb 5, 2024).
- [Upcoding](https://github.com/sahanmndl/UpCoding-Web) - Get event details of competitive programming contests, hackathons etc.

### Teambuilding

- [Dridbot](https://github.com/dribdat/dridbot) - Multiplatform chatbot, for pepping up the experience for participants and organizers of hackathons.
- [Steps to Building an Effective Team](https://hr.berkeley.edu/hr-network/central-guide-managing-hr/managing-hr/interaction/team-building/steps) - A bullet-point list from UC Berkley.
- [Team Builder for MS Teams](https://techcommunity.microsoft.com/t5/healthcare-and-life-sciences/hackathon-team-builder-a-teams-tab-application/ba-p/3334437) - Sample app that allows hackathon participants to form a team based on challenges they want to tackle.
- [Team building activities](https://www.sessionlab.com/blog/team-building-activities/) - 64 fun ideas from SessionLab.
- [volunTree](https://github.com/Anant1902/volunTree) - Volunteer Management System for DSC Hack4Good Hackathon.

### Coaching

- [HELPq](https://github.com/ehzhang/helpq) - Queue application with interfaces for mentors and hackers to answer/submit questions, respectively.
- [Hangar](https://github.com/AmericanAirlines/Hangar) - A Slack bot to help with judging and coaching at hackathons.
- [Leadership & Governance](https://opensource.guide/leadership-and-governance/) - Handbook for open source project, that also applies well for hackathon teams.
- [TreeHacks Slack Mentorship System](https://github.com/hacktx/slack-mentorship) - A Slack bot that queues requests in a #mentors channel (unmaintained as of 2015).

### Evaluating

- [@CivicWhitaker Anthology](https://smartchicagocollaborative.org/launch-the-civicwhitaker-anthology/) - Evaluates three years of organizing hackathons in Chicago civic tech.
- [Eventflare's Journal](https://eventflare.io/journal/crafting-effective-hackathon-judging-criteria-a-step-by-step-guide) - Strategies for determining criteria & [recruiting judges](https://eventflare.io/journal/how-to-select-the-right-hackathon-judges-for-your-event).
- [Expo Table app](https://github.com/nealrs/expo#fork-destination-box) - Create a Devpost Expo table frontend.
- [Gavel](https://github.com/anishathalye/gavel) - A project expo judging system by HackMIT that uses fancy math to get good results.
- [Rankeer](https://github.com/Lucasbrunoferreira/rankeer) - An elaborate student project about management and evaluation of hackathons.

## Guides

> These are helpful handbooks, literature collections and articles that will give you some orientation, and help you to prepare a plan for organizing your event.

- [Dribdat wiki](https://github.com/dribdat/docs/wiki) - Community sourced guidelines from an open source project.
- [GitHub Guide to Hackathons](https://hackathons.github.com/) - Join a community connected by code, with tips & tricks from GitHub.
- [hack.athon.uk](https://hack.athon.uk/) - A wiki for helping hackers get into hackathons and organise them! 
- [Hackathon Guidelines - Opendata.ch](https://opendata.ch/guidelines) - Principles for hackathons from the Swiss open data community.
- [Hackathon Hackers Guide](https://github.com/HackathonHackers/Hackathon-Resources/blob/master/RESOURCES.md) - Collection of high quality hackathon resources. See also [Etiquette](https://medium.com/hackathon-hackers/hackathon-hackers-etiquette-cbcb9d1cda54#.dmgz1wp4y) and [Subgroups](https://github.com/HackathonHackers/groups).
- [Hackathon Leitfaden](https://github.com/okfde/hackathon-leitfaden) - (In German) Printed guide for municipalities.
- [Hackathon Toolbox](https://hackathontoolbox.com/) - Suggests technical tools by stage of hackathon development.
- [Hackathon.guide](https://github.com/JoshData/hackathon.guide) - A step-by-step guide by seasoned organizer Joshua Tauberer.
- [Hackday Manifesto](https://github.com/hackdaymanifesto/site) - How to make your event a success, and avoid common pitfalls.
- [Hack Tools](https://hack-tools.github.io/) - Theodoros Ploumis has great advice for attendees, evaluators and organizers.
- [Handbuch Jugend-Hackathons](https://handbuch.jugendhackt.de/) - (In German) An in-depth guide to organizing youth events.
- [Mattermost Handbook](https://handbook.mattermost.com/contributors/contributors/how-to-run-a-hackathon) - Practical guidelines from the open source Mattermost chat server.
- [McKinsey: Demystifying the hackathon](https://www.mckinsey.com/capabilities/mckinsey-digital/our-insights/demystifying-the-hackathon) - For digital transformation of large organizations.
- [Mediawiki Handbook](https://www.mediawiki.org/wiki/Hackathons/Handbook) - Suggestions from the Mediawiki community (which powers Wikipedia).
- [MLH Organizer Guide](https://github.com/MLH/mlh-hackathon-organizer-guide) - Guide from Major League Hacking, popular at US schools.
- [MLH Software for Hackathons](https://guide.mlh.io/organizer-resources/software-for-hackathons) - A short and tidy list of hackathon software that overlaps with the one you're reading now.
- [OpenDataLab.eu Handbook](http://handbook.opendatalab.eu/) - Open 4 Citizens hackathon handbook from an EU project.
- [Ultimate Ethereum Hackathon Survival Guide](https://consensys.net/developers/ultimate-hackathon-survival-guide/) - From a popular Web3 community.
- [Zotero - Awesome Hackathon](https://www.zotero.org/groups/5538025/awesome_hackathons) - A web library of references on research into the Impacts, Landscape, Motivation and Organizing of hackathons.

## Contributing

Contributions welcome! Please read the [guidelines](https://github.com/dribdat/awesome-hackathon/blob/master/contributing.md) first. Make sure to provide a name, link, description, in alphabetical order, in the appropriate section. Don't worry about making a mistake: your [Pull Request](https://www.freecodecamp.org/news/how-to-make-your-first-pull-request-on-github-3/) will be an opportunity to discuss and make amends.

## Footnotes

This repo is made with [generator-awesome-list](https://github.com/dar5hak/generator-awesome-list) by Darshak Parikh and :heart: motivated by [awesome-hackathons](https://github.com/cconsidine/awesome-hackathons) by Camille Considine.

Licensed [CC0 - Creative Commons Public Domain](https://github.com/dribdat/awesome-hackathon/blob/master/LICENSE)
