<div class="github-widget" data-repo="alferov/awesome-gulp"></div>
## Awesome Gulp [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 精选清单 [gulp](https://github.com/gulpjs/gulp) 资源、插件和样板，以实现更好的开发工作流程自动化.

 _寻找其他东西？ 看看其他 [awesome lists](https://github.com/sindresorhus/awesome)._

## Contribution

 :octocat: 欢迎所有贡献. 随意贡献（[guidelines](https://github.com/alferov/awesome-gulp/blob/master/contributing.md)).



## Legend

[:no_entry:] - 弃用通知；

## Resources

### General Resources

- [Official Website](http://gulpjs.com/)
- [Github Repository](https://github.com/gulpjs/gulp)
- [Plugin Registry](http://gulpjs.com/plugins/)
- [NPM Module](https://www.npmjs.com/package/gulp)
- [Blacklisted Plugins](https://github.com/gulpjs/plugins/blob/master/src/blackList.json)

### Official Documentation

- [Getting Started](https://github.com/gulpjs/gulp/blob/master/docs/getting-started.md)
- [API Documentation](https://github.com/gulpjs/gulp/blob/master/docs/API.md)
- [CLI Documentation](https://github.com/gulpjs/gulp/tree/master/docs#articles)
- [Writing a Plugin](https://github.com/gulpjs/gulp/blob/master/docs/writing-a-plugin/README.md)
- [Recipes](https://github.com/gulpjs/gulp/tree/master/docs/recipes)

### Community

- [StackOverflow](http://stackoverflow.com/questions/tagged/gulp)
- [Twitter](https://twitter.com/gulpjs)

### Tutorials

#### Gulp Tutorials

- [Building with Gulp](https://www.smashingmagazine.com/2014/06/building-with-gulp/)
- [Automate Your Tasks Easily with Gulp.js](https://scotch.io/tutorials/automate-your-tasks-easily-with-gulp-js)
- [Gulp - The Vision, History, and Future of the Project](https://medium.com/@contrahacks/gulp-3828e8126466)
- [Introduction to Gulp.js](http://stefanimhoff.de/tag/gulp/)
- [Video: Learning Gulp](http://leveluptuts.com/tutorials/learning-gulp)
- [Using Gulp to Inject Scripts and Styles Tags Directly into Your HTML](http://blog.johnnyreilly.com/2015/02/using-gulp-in-asp-net-instead-of-web-optimization.html)
- [5 Lessons Learned Using Gulp.js](http://denbuzze.com/post/5-lessons-learned-using-gulpjs/)
- [Automating Linkage: How I Learned to Stop Worrying and Love the Build](http://conan.is/bower/gulp/wiredep/javascript/2014/08/18/automating_linkage-or-how-i-learned-to-stop-worrying-and-love-the-build.html)
- [Setting Up Gulp Tasks for the First Time](https://www.codementor.io/development-process/tutorial/how-to-set-up-gulp-beginner-guide#/)
- [Why You Shouldn’t Create a Gulp Plugin (or, How to Stop Worrying and Learn to Love Existing Node Packages)](http://blog.overzealous.com/post/74121048393/why-you-shouldnt-create-a-gulp-plugin-or-how-to)
- [6 Gulp Best Practices You Can Use Today to Radically Improve Your Development Experience](http://blog.rangle.io/angular-gulp-bestpractices/)
- [Gulp for Beginners](https://css-tricks.com/gulp-for-beginners/)

#### Gulp 4 Tutorials

- [Migrating to Gulp 4 by Example](https://blog.wearewizards.io/migrating-to-gulp-4-by-example)
- [Gulp 4: The new task execution system - gulp.parallel and gulp.series](http://fettblog.eu/gulp-4-parallel-and-series/)

#### Gulp with Browserify

- [Gulp + Browserify, the Gulp-y Way](https://medium.com/@sogko/gulp-browserify-the-gulp-y-way-bb359b3f9623)
- [Gulp + Browserify](https://viget.com/extend/gulp-browserify-starter-faq)
- [Fast Browserify Builds with Watchify](https://github.com/gulpjs/gulp/blob/master/docs/recipes/fast-browserify-builds-with-watchify.md)

#### Gulp with Angular

- [What Every Angular Project Likely Needs - and a Gulp Build to Provide It](http://blog.jhades.org/what-every-angular-project-likely-needs-and-a-gulp-build-to-provide-it/)

#### Gulp with Angular and Browserify

- [Advanced AngularJS Structure with Gulp, Node and Browserify](http://omarfouad.com/blog/2015/03/21/advanced-angularjs-structure-with-gulp-node-and-browserify/)

#### Gulp with Angular and Webpack

- [Angular, Webpack and Gulp for an SPA: Part I](https://luwenhuang.wordpress.com/2015/01/18/refactoring-an-angular-app-to-use-webpack-and-gulp/)
- [Angular, Webpack and Gulp for an SPA: Part II](https://luwenhuang.wordpress.com/2015/01/19/angular-webpack-and-gulp-for-an-spa-part-ii/)
- [Angular, Webpack and Gulp for an SPA: Part III](https://luwenhuang.wordpress.com/2015/01/28/angular-webpack-and-gulp-for-an-spa-part-iii/)

#### Gulp with React and Browserify

- [Browserify and Gulp with React](https://hacks.mozilla.org/2014/08/browserify-and-gulp-with-react/)
- [Taking React to the Next Level: Mixins, Gulp, and Browserify](http://pomax.github.io/1420592591221/taking-react-to-the-next-level-mixins-gulp-and-browserify)

#### Gulp with Ember

- [Improving Your Ember.js Workflow Using Gulp.js](http://www.sitepoint.com/improving-ember-js-workflow-using-gulp-js/)

#### Gulp with WordPress

- [Advanced WordPress Development Using Gulp](https://premium.wpmudev.org/blog/advanced-wordpress-development-using-gulp/)

### Miscellaneous Resources

- [Gulp Cheatsheet](https://github.com/osscafe/gulp-cheatsheet)
- [Playground for Gulp Recipes](https://github.com/johnpapa/gulp-patterns)

## Plugins

### Compilation

- [gulp-sass](https://github.com/dlmanning/gulp-sass) - Sass → CSS 与 [libsass](https://github.com/sass/libsass).
- [gulp-ruby-sass](https://github.com/sindresorhus/gulp-ruby-sass) - Sass → CSS 与 Ruby Sass.
- [gulp-compass](https://github.com/appleboy/gulp-compass) - Sass → 使用 Ruby Sass 和 Compass 的 CSS.
- [gulp-less](https://github.com/plus3network/gulp-less) - [Less](https://github.com/less/less.js) → CSS.
- [gulp-stylus](https://github.com/stevelacy/gulp-stylus) - [Stylus](https://github.com/stylus/stylus) → CSS.
- [gulp-postcss](https://github.com/postcss/gulp-postcss) - 通过管道 CSS [PostCSS](https://github.com/postcss/postcss) 具有单个解析的处理器.
- [gulp-coffee](https://github.com/contra/gulp-coffee) - [Coffeescript](https://github.com/jashkenas/coffeescript) → JavaScript.
- [gulp-typescript](https://github.com/ivogabe/gulp-typescript) - [TypeScript](https://github.com/Microsoft/TypeScript) → JavaScript.
- [gulp-react](https://github.com/sindresorhus/gulp-react) - Facebook [React](https://github.com/facebook/react) JSX 模板 → JavaScript.
- [webpack-stream](https://github.com/shama/webpack-stream) - 跑步 [webpack](https://github.com/webpack/webpack) 作为一个流来方便地与 gulp 集成.

### Transpilation

- [gulp-babel](https://github.com/babel/gulp-babel) - ES6 → ES5 与 [babel](https://github.com/babel/babel).
- [gulp-traceur](https://github.com/sindresorhus/gulp-traceur) - ES6 → ES5 使用 [Traceur](https://github.com/google/traceur-compiler).
- [gulp-regenerator](https://github.com/sindresorhus/gulp-regenerator) - ES6 → ES5 与 [Regenerator](https://github.com/facebook/regenerator).
- [gulp-es6-transpiler](https://github.com/sindresorhus/gulp-es6-transpiler) - [:no_entry:] ES6 → ES5 with [es6-transpiler](https://github.com/termi/es6-transpiler).
- [gulp-myth](https://github.com/sindresorhus/gulp-myth) - [Myth](https://github.com/segmentio/myth) - 用于 CSS 规范未来版本的 polyfill.
- [gulp-cssnext](https://github.com/MoOx/gulp-cssnext) - [:no_entry:] 使用明天的 CSS 语法，今天使用 [cssnext](https://github.com/MoOx/postcss-cssnext).

### Concatenation

- [gulp-concat](https://github.com/contra/gulp-concat) - 连接文件.

### Minification

- [gulp-clean-css](https://github.com/scniro/gulp-clean-css) - 缩小 CSS [clean-css](https://github.com/jakubpawlowicz/clean-css).
- [gulp-csso](https://github.com/ben-eb/gulp-csso) - 缩小 CSS [CSSO](https://github.com/css/csso).
- [gulp-uglify](https://github.com/terinjokes/gulp-uglify) - 缩小 JavaScript [UglifyJS2](https://github.com/mishoo/UglifyJS2).
- [gulp-htmlmin](https://github.com/jonschlinkert/gulp-htmlmin) - 缩小 HTML [html-minifier](https://github.com/kangax/html-minifier).
- [gulp-imagemin](https://github.com/sindresorhus/gulp-imagemin) - 缩小 PNG、JPEG、GIF 和 SVG 图像 [imagemin](https://github.com/imagemin/imagemin).
- [gulp-svgmin](https://github.com/ben-eb/gulp-svgmin) - 使用 gulp 缩小 SVG 文件.

### Optimization

- [gulp-uncss](https://github.com/ben-eb/gulp-uncss) - 删除未使用的 CSS 选择器 [UnCSS](https://github.com/giakki/uncss).
- [gulp-css-base64](https://github.com/zckrs/gulp-css-base64) - 将 CSS 文件中找到的所有资源（在 url() 声明中的资源）转换为 base64 编码的数据 URI 字符串.
- [gulp-svg2png](https://github.com/akoenig/gulp-svg2png) - 将 SVG 转换为 PNG.
- [gulp-responsive](https://github.com/mahnunchik/gulp-responsive) - 生成不同尺寸的图像.
- [gulp-svgstore](https://github.com/w0rm/gulp-svgstore)  - 将 svg 文件与 ` 合并为一个<symbol> ` 元素.
- [gulp-iconfont](https://github.com/nfroidure/gulp-iconfont) - 从多个 SVG 图标创建图标字体.

### Injecting Assets

- [gulp-useref](https://github.com/jonkemp/gulp-useref) - 解析 HTML 文件中的构建块以替换对未优化脚本或样式表的引用.
- [gulp-inject](https://github.com/klei/gulp-inject) - 将每个文件转换为字符串并将每个转换后的字符串注入目标流文件中的占位符.
- [wiredep](https://github.com/taptapship/wiredep) - 将 Bower 依赖项连接到您的源代码.

### Templating

- [gulp-angular-templatecache](https://github.com/miickel/gulp-angular-templatecache) - 在 $templateCache 中连接并注册 AngularJS 模板.
- [gulp-jade](https://github.com/phated/gulp-jade) - [Jade](https://github.com/pugjs/jade) → HTML.
- [gulp-handlebars](https://github.com/lazd/gulp-handlebars) - [Handlebars](https://github.com/wycats/handlebars.js) 模板 → JavaScript.
- [gulp-hb](https://github.com/shannonmoeller/gulp-hb) - [Handlebars](https://github.com/wycats/handlebars.js) 模板 → HTML.
- [gulp-nunjucks](https://github.com/sindresorhus/gulp-nunjucks) - [Nunjucks](https://github.com/mozilla/nunjucks) 模板 → JavaScript.
- [gulp-dustjs](https://github.com/sindresorhus/gulp-dust) - [Dust](https://github.com/linkedin/dustjs) 模板 → JavaScript.
- [gulp-riot](https://github.com/e-jigsaw/gulp-riot) - [Riot](https://github.com/riot/riot) 模板 → JavaScript.
- [gulp-markdown](https://github.com/sindresorhus/gulp-markdown) - 降价 → HTML.
- [gulp-template](https://github.com/sindresorhus/gulp-template) - [Lodash](https://github.com/lodash/lodash) 模板 → JavaScript.
- [gulp-swig](https://github.com/colynb/gulp-swig) - [Swig](https://github.com/paularmstrong/swig) 模板 → HTML.
- [gulp-remark](https://github.com/denysdovhan/gulp-remark) - Gulp 插件 [remark](https://github.com/wooorm/remark) - 由插件驱动的降价处理器

### Linting

- [gulp-csslint](https://www.npmjs.com/package/gulp-csslint) - 自动检查 CSS [CSSLint](https://github.com/CSSLint/csslint).
- [gulp-htmlhint](https://github.com/bezoerb/gulp-htmlhint) - [HTMLHint](https://github.com/yaniswang/HTMLHint) 包装器来验证您的 HTML.
- [gulp-jshint](https://github.com/spalger/gulp-jshint) - 检测 JavaScript 中的错误和潜在问题 [JSHint](https://github.com/jshint/jshint).
- [gulp-jscs](https://github.com/jscs-dev/gulp-jscs) - 检查 JavaScript 代码风格 [jscs](https://github.com/jscs-dev/node-jscs).
- [gulp-coffeelint](https://github.com/janraasch/gulp-coffeelint) - 一个风格检查器，有助于保持 [CoffeeScript](https://github.com/jashkenas/coffeescript) 代码干净.
- [gulp-tslint](https://github.com/panuhorsmalahti/gulp-tslint) - [TypeScript](https://github.com/Microsoft/TypeScript) gulp 的 linter 插件.
- [gulp-eslint](https://github.com/adametry/gulp-eslint) - 识别并报告在 ECMAScript/JavaScript 代码中发现的模式.
- [gulp-w3cjs](https://github.com/callumacrae/gulp-w3cjs) - 验证 HTML [w3cjs](https://github.com/thomasdavis/w3cjs).
- [gulp-lesshint](https://github.com/lesshint/gulp-lesshint) - 减少文件 [lesshint](https://github.com/lesshint/lesshint).
- [gulp-check-unused-css](https://github.com/zalando/gulp-check-unused-css) - 检查您的 HTML 模板是否有未使用的 CSS 类.

### Live Reload

- [browser-sync](https://github.com/BrowserSync/browser-sync) - 在构建网站时保持多个浏览器和设备同步（[recipes](https://github.com/BrowserSync/gulp-browser-sync)).
- [gulp-livereload](https://github.com/vohof/gulp-livereload) - 用于实时加载的 Gulp 插件.

### Caching

- [gulp-changed](https://github.com/sindresorhus/gulp-changed) - 仅通过更改的文件.
- [gulp-cached](https://github.com/contra/gulp-cached) - 一个简单的内存文件缓存.
- [gulp-remember](https://github.com/ahaurw01/gulp-remember) - 记住并调用通过它的文件.
- [gulp-newer](https://github.com/tschaub/gulp-newer) - 仅通过较新的源文件.

### Flow Control

- [merge-stream](https://github.com/grncdr/merge-stream) - 将多个流合并为一个交错的流.
- [streamqueue](https://github.com/nfroidure/StreamQueue) - 逐步管道排队流.
- [run-sequence](https://github.com/OverZealous/run-sequence) - 按顺序运行一系列依赖的 gulp 任务.
- [gulp-if](https://github.com/robrich/gulp-if) - 有条件地运行任务.

### Logging

- [gulp-notify](https://github.com/mikaelbr/gulp-notify) - gulp 的通知插件.
- [gulp-size](https://github.com/sindresorhus/gulp-size) - 显示项目的大小.
- [gulp-debug](https://github.com/sindresorhus/gulp-debug) - 调试乙烯基文件流以查看哪些文件通过您的 gulp 管道运行.
- [gulp-beer](https://github.com/lordgiotto/gulp-beer) - 更好的错误报告与交互式系统通知和错误显示的自定义服务器.

### Testing

- [gulp-mocha](https://github.com/sindresorhus/gulp-mocha) - 跑步 [Mocha](https://github.com/mochajs/mocha) 测试.
- [gulp-jasmine](https://github.com/sindresorhus/gulp-jasmine) - 跑步 [Jasmine 2](https://github.com/jasmine/jasmine) 在 Node.js 中测试.
- [gulp-protractor](https://github.com/mllrsohn/gulp-protractor) - Gulp 包装器 [Protractor](https://github.com/angular/protractor) 测试.
- [gulp-coverage](https://github.com/dylanb/gulp-coverage) - 独立于测试运行器的 Node.js 覆盖率报告.
- [gulp-karma](https://github.com/karma-runner/gulp-karma) - gulp 的 Karma 测试运行程序.
- [gulp-ava](https://github.com/sindresorhus/gulp-ava)- 跑步 [AVA](https://github.com/sindresorhus/ava) 用 gulp 测试.

### Miscellaneous Plugins

- [gulp-util](https://github.com/gulpjs/gulp-util) - 一组有用的实用程序.
- [gulp-plumber](https://github.com/floatdrop/gulp-plumber) - 防止错误导致管道破裂.
- [gulp-load-plugins](https://github.com/jackfranklin/gulp-load-plugins) - 自动加载 gulp 插件.
- [main-bower-files](https://github.com/ck86/main-bower-files) - 通过动态获取库文件简化构建过程设置.
- [autoprefixer](https://github.com/postcss/autoprefixer) - 通过 Can I Use 解析 CSS 并将供应商前缀添加到规则中.
- [gulp-sourcemaps](https://github.com/floridoo/gulp-sourcemaps) - 提供源地图支持.
- [gulp-replace](https://github.com/lazd/gulp-replace) - 用于 gulp 的字符串替换插件.
- [gulp-rename](https://github.com/hparra/gulp-rename) - 轻松重命名文件.
- [gulp-rev](https://github.com/sindresorhus/gulp-rev) - 通过将内容哈希附加到文件名来修改静态资产：unicorn.css → unicorn-d41d8cd98f.css.
- [del](https://github.com/sindresorhus/del) - 使用 glob 删除文件/文件夹.
- [gulp-exec](https://github.com/robrich/gulp-exec) - 运行 shell 命令.
- [gulp-strip-debug](https://github.com/sindresorhus/gulp-strip-debug) - 从 JavaScript 代码中剥离控制台、警报和调试器语句.
- [gulp-cssimport](https://github.com/unlight/gulp-cssimport) - 解析 CSS 文件，查找导入，获取链接文件的内容并用它替换导入语句.
- [gulp-inline-css](https://github.com/jonkemp/gulp-inline-css) - 将 CSS 属性内嵌到 HTML 文件的样式属性中.
- [gulp-gh-pages](https://github.com/shinnn/gulp-gh-pages) - 将内容发布到 Github 页面.
- [gulp-ng-annotate](https://github.com/Kagami/gulp-ng-annotate) - 添加 AngularJS 依赖注入注解 [ng-annotate](https://github.com/olov/ng-annotate).
- [gulp-bump](https://github.com/stevelacy/gulp-bump) - 碰撞任何 semver JSON 版本.
- [gulp-file-include](https://github.com/coderhaoxin/gulp-file-include) - 包含带有 gulp 的文件.
- [gulp-zip](https://github.com/sindresorhus/gulp-zip) - ZIP 压缩文件.
- [gulp-git](https://github.com/stevelacy/gulp-git) - 使用 gulp 运行 Git 命令.
- [gulp-filter](https://github.com/sindresorhus/gulp-filter) - 使用 globbing 过滤乙烯基流中的文件.
- [gulp-preprocess](https://github.com/jas/gulp-preprocess) - 根据自定义上下文或环境配置预处理文件.
- [gulp-eval](https://github.com/gulp-bem/gulp-eval) - 评估 JS 表达式或需要 CommonJS 模块和 JSON 文件.

## Scaffolding

### Boilerplates

- [web-starter-kit](https://github.com/google/web-starter-kit) - 谷歌网络初学者工具包.
- [gulp-plugin-boilerplate](https://github.com/sindresorhus/gulp-plugin-boilerplate) - 用于启动创建 gulp 插件的样板.
- [polymer-starter-kit](https://github.com/polymerelements/polymer-starter-kit) - Polymer 1.0 应用程序的起点.
- [este](https://github.com/este/este) - 最完整的 React/Flux 开发堆栈和同构功能 Web 应用程序的入门工具包.
- [mnml](https://github.com/mrmrs/mnml) - 启动响应式 HTML5/Sass 项目的最小样板.
- [kraken](https://github.com/cferdinandi/kraken) - 面向前端 Web 开发人员的轻量级、移动优先样板.
- [angularjs-gulp-browserify-boilerplate](https://github.com/jakemmarsh/angularjs-gulp-browserify-boilerplate) - 使用 AngularJS、Sass、gulp 和 Browserify 的样板.
- [hapi-ninja](https://github.com/poeticninja/hapi-ninja) - Node.js、Hapi 和 Swig 样板.
- [laravel-5-boilerplate](https://github.com/rappasoft/laravel-5-boilerplate) - Laravel 5 样板项目.
- [react-starterkit](https://github.com/wbkd/react-starterkit) - React 入门套件，包含 react-router、Reflux、jest、webpack、gulp 和 Stylus.
- [gulp-front](https://github.com/zoxon/gulp-front) - 基于 gulp、pug、stylus、postcss、webpack 和 babel 的前端样板和模块化 BEM css 框架.
- [Front End Starter](https://github.com/Puritanic/Frontend-Starter-Kit) - 由 Gulp、HTML5 bolierplate、Sass、PostCss 和 Webpack（用于 Babel 转译）提供支持的前端项目样板.

### Yeoman Generators

- [generator-gulp-webapp](https://github.com/yeoman/generator-gulp-webapp) - 用于现代网络应用程序的 gulp 生成器.
- [generator-gulp-angular](https://github.com/Swiip/generator-gulp-angular) - 带有 gulp 的 AngularJS 的 Yeoman 生成器.
- [generator-react-gulp-browserify](https://github.com/randylien/generator-react-gulp-browserify)  - 用于 React 库的 Yeoman 生成器. 它包括 gulp、Browserify、Browsersync 和 Bootstrap.
- [generator-node-gulp](https://github.com/youngmountain/generator-node-gulp) - 一个 Node.js 模块生成器，包括 gulp 和 Mocha.
- [generator-gulp-bootstrap](https://github.com/niallobrien/generator-gulp-bootstrap) - Yeoman generator for Bootstrap, gulp & libsass.
- [generator-angulpify](https://github.com/jgoux/generator-angulpify) - 涉及 AngularJS、gulp 和 Browserify 的 Yeoman 生成器.
- [generator-ionic-gulp](https://github.com/tmaximini/generator-ionic-gulp) - 用于带有 gulp 的 Ionic 项目的 Yeoman 生成器.
- [generator-gulp-plugin-boilerplate](https://github.com/sindresorhus/generator-gulp-plugin-boilerplate) - 搭建一个 [gulp plugin boilerplate](https://github.com/sindresorhus/gulp-plugin-boilerplate).
- [generator-jekyllized](https://github.com/sondr3/generator-jekyllized) - 带有 gulp、Sass、AutoPrefixer、资产优化和缓存清除等功能的 Jekyll 工作流.

## Miscellaneous

- [elixir](https://github.com/laravel/elixir) - 一个干净、流畅的 API，用于为你的 Laravel 应用程序定义基本的 gulp 任务.
- [gulp-app](https://github.com/sindresorhus/gulp-app) - Gulp 作为应用程序 (OS X).
- [lmn-gulp-tasks](https://github.com/Lostmyname/lmn-gulp-tasks) - gulp 任务单元测试示例.
- [gulp-chef](http://gulp-cookery.github.io/gulp-chef/) - 一种优雅、直观的方式来重用 gulp 任务.

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Philipp Alferov](https://github.com/alferov) 已放弃该作品的所有版权和相关或邻接权.
