<div class="github-widget" data-repo="Kazhnuz/awesome-gnome"></div>
## Awesome GNOME [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://rawgit.com/kazhnuz/awesome-gnome/master/images/gnome-logo.svg" align="right" width="150">](http://www.gnome.org)

> A curated list of _awesome_ apps, extensions, modules, themes and tools for the GNOME Desktop Environment.

[GNOME](https://www.gnome.org) is a desktop environment for Linux and Unix-like operating systems, designed to put the user in control and get things done. It uses GTK for its applications and Clutter and JavaScript for its official desktop shell.

> Items marked with ![GNOME Core][GNOME Core] are applications officially maintained and distributed by the GNOME Project as part of the core set of applications and tools, or extensions that are maintained and distributed as part of the Classic mode.

> Items marked with ![GNOME Circle][GNOME Circle] are applications championed by the [GNOME Circle](https://circle.gnome.org) initiative that aims to showcase the best apps and libraries for GNOME.



---

## Applications

### Internet and Networking

- [GNOME Web](https://apps.gnome.org/Epiphany) - Official web browser project of GNOME. ![GNOME Core][GNOME Core]
- [Fragments](https://apps.gnome.org/Fragments) - BitTorrent client. ![GNOME Circle][GNOME Circle]
- [Newsflash](https://apps.gnome.org/NewsFlash) - RSS feeds reader. ![GNOME Circle][GNOME Circle]
- [Font Downloader](https://flathub.org/apps/org.gustavoperedo.FontDownloader) - Install fonts from online sources
- [Tangram](https://apps.gnome.org/Tangram) - Browser for your pinned tabs. ![GNOME Circle][GNOME Circle]
- [Polari](https://apps.gnome.org/Polari) - Talk to people on IRC. ![GNOME Circle][GNOME Circle]
- [Warp](https://apps.gnome.org/Warp) - Fast and secure file transfer. ![GNOME Circle][GNOME Circle]
- [Wike](https://apps.gnome.org/Wike) - Search and read Wikipedia articles. ![GNOME Circle][GNOME Circle]
- [Feeds](https://gitlab.gnome.org/World/gfeeds) - An RSS/Atom feed reader.
- [Haguichi](https://www.haguichi.net) - Graphical frontend for Hamachi.
- [Parabolic](https://flathub.org/apps/org.nickvision.tubeconverter) - `yt-dlp` graphical fronted.
- [Geopard](https://ranfdev.com/projects/geopard) - Colorful Gemini client.
- [Fractal](https://flathub.org/apps/org.gnome.Fractal) - Matrix client.
- [Dino](https://dino.im) - XMPP Client.
- [Dissent](https://flathub.org/apps/so.libdb.dissent) - Third-party Discord client prioritasing speed over feature completeness (with user theming through CSS).
- [Tuba](https://apps.gnome.org/Tuba) - Client for federated social networks (Mastodon, GoToSocial, Akkoma). ![GNOME Circle][GNOME Circle]
- [Pipeline](https://flathub.org/apps/de.schmidhuberj.tubefeeder) - YouTube Client.
- [Netsleuth](https://github.com/vmkspv/netsleuth) - Utility for the calculation and analysis of IP subnet values.

### Office

- [Apostrophe](https://apps.gnome.org/Apostrophe) - Distraction-free Markdown editor. ![GNOME Circle][GNOME Circle]
- [Citations](https://apps.gnome.org/Citations) - Manage your bibliography. ![GNOME Circle][GNOME Circle]
- [NFO Viewer](https://flathub.org/apps/details/io.otsaloma.nfoview) - Simple viewer for NFO files, beating text editors with preset font and encoding settings and clickable hyperlink support.
- [Foliate](https://flathub.org/apps/com.github.johnfactotum.Foliate) - Simple and modern eBook reader.
- [Paper Clip](https://flathub.org/apps/io.github.diegoivan.pdf_metadata_editor) - PDF metadata editor.
- [RNote](https://flathub.org/apps/com.github.flxzt.rnote) - Sketch and take handwritten notes.
- [Morphosis](https://flathub.org/apps/garden.jamie.Morphosis) - Document converter (using Pandoc) supporting PDF, Markdown, RST, LaTeX, HTML, Microsoft Word, Open/Libre Office and EPUB formats.

### Productivity and Time

- [Solanum](https://apps.gnome.org/Solanum) - Balance working time and break time. ![GNOME Circle][GNOME Circle]
- [Khronos](https://apps.gnome.org/Khronos) - Log the time it took to do tasks. ![GNOME Circle][GNOME Circle]
- [Errands](https://apps.gnome.org/List) - Todo application for those who prefer simplicity. ![GNOME Circle][GNOME Circle]
- [Endeavour](https://flathub.org/apps/details/org.gnome.Todo) - Manage your tasks.
- [Timetrack](https://flathub.org/apps/net.danigm.timetrack) - Time tracker.
- [Teleprompter](https://flathub.org/apps/io.github.nokse22.teleprompter) - Simple application to read scrolling text from your screen.
- [Planify](https://flathub.org/apps/io.github.alainm23.planify) - Project and task manager with Todoist support.
- [Time Tracker](https://flathub.org/apps/com.lynnmichaelmartin.TimeTracker) - Local-first project time tracker with sync option via cloud or network storage (CSV file).
- [Newelle](https://github.com/qwersyk/Newelle) - Virtual assistant (local, based on GPT4All) that interacts with the system by running shell commands and execute Python code.

### Well Being

- [Blanket](https://apps.gnome.org/Blanket) - Listen to different sounds. ![GNOME Circle][GNOME Circle]
- [Health](https://apps.gnome.org/Health) - Health tracking. ![GNOME Circle][GNOME Circle]

### Multimedia

- [Shortwave](https://apps.gnome.org/Shortwave) - Client for web-based radio. ![GNOME Circle][GNOME Circle]
- [Video Trimer](https://apps.gnome.org/VideoTrimmer) - Trim video quickly. ![GNOME Circle][GNOME Circle]
- [Amberol](https://apps.gnome.org/Amberol) - Plays music, and nothing else. ![GNOME Circle][GNOME Circle]
- [Mousai](https://apps.gnome.org/Mousai) - Identify any songs in seconds. ![GNOME Circle][GNOME Circle]
- [Podcasts](https://apps.gnome.org/Podcasts) - Listen to your favourite podcasts. ![GNOME Circle][GNOME Circle]
- [Decibels](https://apps.gnome.org/Decibels) - Simple music player with waveform view. ![GNOME Circle][GNOME Circle]
- [Cozy](https://flathub.org/apps/com.github.geigi.cozy) - Audiobook player.
- [Celluloid](https://flathub.org/apps/io.github.celluloid_player.Celluloid) - Simple frontend for mpv.
- [Parlatype](http://gkarsay.github.io/parlatype) - Audio player specialized for transcription.
- [Easy Effects](https://flathub.org/apps/com.github.wwmm.easyeffects) - Audio effects for PipeWire applications .
- [Spot](https://flathub.org/apps/dev.alextren.Spot) - Spotify Client.
- [Clapper](https://rafostar.github.io/clapper) - Simple and modern media player.
- [Footage](https://gitlab.com/adhami3310/Footage) - Application to trim, flip, rotate and crop individual clips.
- [Aviator](https://flathub.org/apps/net.natesales.Aviator) - Utility for encoding with SVT-AV1 & Opus.
- [Gapless](https://flathub.org/apps/com.github.neithern.g4music) - Play your music elegantly.
- [Monophony](https://flathub.org/fr/apps/io.gitlab.zehkira.Monophony) - Stream music from YouTube.
- [Collector](https://mijorus.it/projects/collector) - Dropover utility that allows to drag files/images/text into a collection window and drop them anywhere.
- [Fotema](https://flathub.org/apps/app.fotema.Fotema) - Photo gallery with support for iOS Live Photos and Samsung Motion Photos and with map view.

### Graphics

- [Curtail](https://apps.gnome.org/en/Curtail) - Simple & useful image compressor. ![GNOME Circle][GNOME Circle]
- [Identity](https://apps.gnome.org/Identity) - Compare image and video. ![GNOME Circle][GNOME Circle]
- [Switcheroo](https://apps.gnome.org/Converter) - Image converter and manipulator ([ImageMagick](https://imagemagick.org) frontend). ![GNOME Circle][GNOME Circle]
- [Coulr](https://flathub.org/apps/com.github.huluti.Coulr) - Convert between RGB and hexadecimal codes for colours.
- [ASCII Draw](https://flathub.org/apps/io.github.nokse22.asciidraw) - Draw graphs and more using only characters.
- [Mingle](https://flathub.org/apps/io.github.halfmexican.Mingle) - Application to combine emojis using Google's Emoji Kitchen.

### Scientific Tooling

- [Graphs](https://apps.gnome.org/Graphs) - Plot and manipulate data. ![GNOME Circle][GNOME Circle]
- [Plots](https://flathub.org/apps/com.github.alexhuntley.Plots) - Simple graph plotting.

### Gaming

- [Cartridges](https://apps.gnome.org/Cartridges) - Game launcher with Steam, Lutris, Heroic, Bottles and itch library import. ![GNOME Circle][GNOME Circle]
- [Chess Clock](https://flathub.org/apps/com.clarahobbs.chessclock) - Timer for over-the-board chess games.
- [Crosswords](https://flathub.org/apps/org.gnome.Crosswords) - Game of crosswords with squpport for shaped and colors crosswords and `.ipuz`, `.jpuz`, `.xd`, and `.puz` files.
- [Mahjongg](https://flathub.org/apps/org.gnome.Mahjongg) - Solitaire (one player) version of the classic Eastern tile game, Mahjongg.
- [Ultimate Tic Tac Toe](https://flathub.org/apps/io.github.nokse22.ultimate-tic-tac-toe) - [Ultimate Tic Tac Toe](https://en.wikipedia.org/wiki/Ultimate_tic-tac-toe) to play with friends or against an AI.
- [Libellus](https://flathub.org/apps/de.hummdudel.Libellus) - Tab-based wiki/Lexicon for DnD 5th edition.

### System and Customization

- [Pika Backup](https://apps.gnome.org/PikaBackup) - Simple backups based on borg. ![GNOME Circle][GNOME Circle]
- [Déjà Dup Backups](https://apps.gnome.org/DejaDup) - Simple backups tool. ![GNOME Circle][GNOME Circle]
- [GNOME Tweaks](https://gitlab.gnome.org/GNOME/gnome-tweaks) - Graphical interface for advanced GNOME settings.
- [HydraPaper](https://hydrapaper.gabmus.org) - Set a different background for each monitor.
- [Dynamic Gnome Wallpapers](https://github.com/manishprivet/dynamic-gnome-wallpapers) - Gallery of MacOS like dynamic wallpapers, and easy scripts to install them
- [GDM Settings](https://gdm-settings.github.io) - A settings app for GDM (GNOME's Login Screen a.k.a GNOME Display Manager).
- [AdwSteamGtk](https://flathub.org/apps/io.github.Foldex.AdwSteamGtk) - [Adwaita for Steam](https://github.com/tkashkin/Adwaita-for-Steam) skin installer.
- [Flatseal](https://flathub.org/apps/com.github.tchx84.Flatseal) - Flatpak permission manager.
- [Mission Center](https://missioncenter.io) - Monitor your CPU, Memory, Disk, Network and GPU usage.
- [Bottles](https://flathub.org/apps/com.usebottles.bottles) - Wine environments manager to run Windows software and games.
- [BoxBuddy](https://flathub.org/apps/io.github.dvlv.boxbuddyrs) - Graphical Distrobox manager.
- [Pods](https://flathub.org/apps/com.github.marhkb.Pods) - Podman containers manager.
- [Ptyxis](https://flathub.org/apps/app.devsuite.Ptyxis) - Terminal with first-class support for containers.
- [Damask](https://gitlab.gnome.org/subpop/damask) - Application that automatically sets wallpaper from a variety or sources (local folder, Wallhaven, Bing Wallpaper, NASA Astronomy, etc).
- [Luminance](https://github.com/sidevesh/Luminance) - Simple application to control brightness of displays (including external) supporting DDC/CI.
- [Bustle](https://flathub.org/apps/org.freedesktop.Bustle) - D-Bus activity viewer that draws diagram sequences.
- [Embellish](https://flathub.org/apps/io.github.getnf.embellish) - Application to install and manage Nerd Fonts on the system.
- [Resources](https://apps.gnome.org/Resources) - Monitor for system resources and processes that can terminate graphical applications and processes. ![GNOME Circle][GNOME Circle]

### Utilities

- [Dialect](https://apps.gnome.org/Dialect) - Translate text. ![GNOME Circle][GNOME Circle]
- [Audio Sharing](https://apps.gnome.org/AudioSharing) - Share your computer audio. ![GNOME Circle][GNOME Circle]
- [Boatswain](https://apps.gnome.org/Boatswain) - Control your Elgato Stream Decks. ![GNOME Circle][GNOME Circle]
- [Decoder](https://apps.gnome.org/Decoder) - Scan and Generate QR Codes. ![GNOME Circle][GNOME Circle]
- [Junction](https://apps.gnome.org/Junction) - Junction lets you choose the application to open files and links. ![GNOME Circle][GNOME Circle]
- [Impression](https://flathub.org/apps/io.gitlab.adhami3310.Impression) - Bootable driver flasher application ![GNOME Circle][GNOME Circle]
- [Kooha](https://flathub.org/apps/io.github.seadve.Kooha) - Elegantly record your screen.
- [Lan Mouse](https://github.com/feschber/lan-mouse) - Mouse and keyboard sharing software (software KVM switch).
- [Moussam](https://amit9838.github.io/mousam) - Weather application with 7 days forecast from Open-Meteo.com.
- [Snoop](https://flathub.org/apps/de.philippun1.Snoop) - Application (with Nautilus extension) to search through file contents in a given folder.

### Security and Privacy

- [Obfuscate](https://apps.gnome.org/Obfuscate) - Censor private information. ![GNOME Circle][GNOME Circle]
- [Metadata Cleaner](https://apps.gnome.org/MetadataCleaner) - View and clean metadata in files. ![GNOME Circle][GNOME Circle]
- [Secrets](https://apps.gnome.org/Secrets) - Keepass-compatible password manager. ![GNOME Circle][GNOME Circle]
- [Authenticator](https://apps.gnome.org/Authenticator) - Generate Two-Factor Codes. ![GNOME Circle][GNOME Circle]
- [Collisions](https://apps.gnome.org/Collision) - Check hashes for your files. ![GNOME Circle][GNOME Circle]
- [File Shredder](https://apps.gnome.org/Raider) - Securely delete your files. ![GNOME Circle][GNOME Circle]
- [Key Rack](https://flathub.org/apps/app.drey.KeyRack) - Tool that allows to view and edit keys, like passwords or tokens, stored by apps.

### Development and Design

- [GNOME Builder](https://apps.gnome.org/Builder) - Official IDE for creating GNOME applications. ![GNOME Core][GNOME Core]
- [Gaphor](https://gaphor.org) - The simple modeling tool for UML and SysML. ![GNOME Circle][GNOME Circle]
- [Webfont Kit Generator](https://apps.gnome.org/WebfontKitGenerator) - Create @font-face kits easily. ![GNOME Circle][GNOME Circle]
- [Commit](https://apps.gnome.org/Commit) - Commit message editor. ![GNOME Circle][GNOME Circle]
- [Workbench](https://apps.gnome.org/Workbench) - Learn and prototype with GNOME technologies. ![GNOME Circle][GNOME Circle]
- [Lorem](https://apps.gnome.org/Lorem) - Generate placeholder text. ![GNOME Circle][GNOME Circle]
- [Share Preview](https://apps.gnome.org/SharePreview) - Test social media cards locally. ![GNOME Circle][GNOME Circle]
- [Text Pieces](https://apps.gnome.org/TextPieces) - Transform text without using random websites. ![GNOME Circle][GNOME Circle]
- [Forge Sparks](https://flathub.org/apps/com.mardojai.ForgeSparks) - Git forge (GitHub, Gitea, Forgejo) desktop notification application. ![GNOME Circle][GNOME Circle]
- [Biblioteca](https://apps.gnome.org/en/Biblioteca) - GNOME documentation (offline) reader with fuzzy search, dark mode and mobile support. ![GNOME Circle][GNOME Circle]
- [Hieroglyphic](https://apps.gnome.org/Hieroglyphic) - Application to search for LaTeX symbols by sketching. ![GNOME Circle][GNOME Circle]
- [Sysprof](https://apps.gnome.org/Sysprof) - Profile an application or entire system.
- [DevHelp](https://apps.gnome.org/Devhelp) - Developer tool for browsing and searching API documentation.
- [Escambo](https://github.com/CleoMenezesJr/escambo) - HTTP-based APIs test application.
- [Turtle](https://gitlab.gnome.org/philippun1/turtle) - Tool to manage Git repositories within Nautilus by providing emblems and context menus.
- [Aurea](https://flathub.org/apps/io.github.cleomenezesjr.aurea) - Simple preview banner made to read metainfo files from Flatpak apps and represent them as they would on Flathub.
- [Exhibit](https://flathub.org/apps/io.github.nokse22.Exhibit) - 3D model previewer based on the F3D library that supports many formats.
- [Cartero](https://cartero.danirod.es) - Graphical HTTP client to perform HTTP requests and test web APIs.
- [Dev Toolbox](https://flathub.org/apps/me.iepure.devtoolbox) - Toolbox for developers providing converters, formatters, Regex/Cron testers, hash generators and more.

#### Design Tooling

- [App Icon Preview](https://flathub.org/apps/org.gnome.design.AppIconPreview) - Simple utility to preview icons.
- [Palette](https://flathub.org/apps/org.gnome.design.Palette) - Tool for viewing the GNOME colour palette.
- [Contrast](https://flathub.org/apps/org.gnome.design.Contrast) - Check the contrast between two colors.
- [Icon Library](https://flathub.org/apps/org.gnome.design.IconLibrary) - Symbolic icons for your apps.
- [Symbolic Preview](https://flathub.org/apps/org.gnome.design.SymbolicPreview) - Symbolics Made Easy.
- [Emblem](https://apps.gnome.org/Emblem) - Generate project avatars. ![GNOME Circle][GNOME Circle]

### Others

- [Boxes](https://apps.gnome.org/Boxes) - View, access, and manage remote and virtual systems.

## Third-party Apps Plugins

- [Nautilus Terminal](https://github.com/flozz/nautilus-terminal) - Integrates a terminal into Nautilus.

## Extensions

### Docks and Panels

- [Dash-to-Dock](https://extensions.gnome.org/extension/307/dash-to-dock) - A fully-featured dock.
- [Dash-to-Panel](https://extensions.gnome.org/extension/1160/dash-to-panel) - Make your desktop more similar to W7/KDE.
- [Dock-from-Dash](https://extensions.gnome.org/extension/4703/dock-from-dash) - Simply transform your Dash into a Dock.

### Customization and Tweaks

- [Just Perfection](https://extensions.gnome.org/extension/3843/just-perfection) - Customize GNOME Shell.
- [Custom Hot Corners - Extended](https://extensions.gnome.org/extension/4167/custom-hot-corners-extended) - Customize hot corners.
- [Quick Settings Tweaker](https://extensions.gnome.org/extension/5446/quick-settings-tweaker) - Tweak your quick settings menu.

### Menus

- [Application Menu](https://extensions.gnome.org/extension/6/applications-menu) - Category-based menu for applications. ![GNOME Classic][GNOME Core]
- [Places Indicator](https://extensions.gnome.org/extension/8/places-status-indicator) - Menu that provides fast access to your folders. ![GNOME Classic][GNOME Core]
- [Arc Menu](https://extensions.gnome.org/extension/3628/arcmenu) - Windows7-like application menu inspired by the one in Zorin OS.
- [Fly-Pie](https://extensions.gnome.org/extension/3433/fly-pie) - Mouse-based menu.

### Applets

- [RunCat](https://extensions.gnome.org/extension/2986/runcat/) — The cat tells you the CPU usage by running speed.
- [Caffeine](https://extensions.gnome.org/extension/517/caffeine) - Applet that let you deactivate the GNOME lock screen.
- [Removable Drive Menu](https://extensions.gnome.org/extension/7/removable-drive-menu) - Status menu to show your removable drives.
- [OpenWeather](https://extensions.gnome.org/extension/6655/openweather/) - Weather applet.
- [Clipboard Indicator](https://extensions.gnome.org/extension/779/clipboard-indicator) - Simple clipboard applet.
- [Todo.txt](https://extensions.gnome.org/extension/570/todotxt) - Interface for todo.txt.
- [GSConnect](https://extensions.gnome.org/extension/1319/gsconnect) - KDE Connect implementation.
- [KStatusNotifiers/AppIndicator Support](https://extensions.gnome.org/extension/615/appindicator-support) - Appindicator systray.

### Windows

- [PaperWM](https://extensions.gnome.org/extension/6099/paperwm/) - Tiled scrollable window management.
- [Coverflow Alt-Tab](https://extensions.gnome.org/extension/97/coverflow-alt-tab/) - Advanced fullscreen app switcher.

### Visual Changes

- [Blur-my-shell](https://extensions.gnome.org/extension/3193/blur-my-shell/) - Apply a blur effect to the overview and top panel background.
- [Compiz windows effect](https://extensions.gnome.org/extension/3210/compiz-windows-effect) - Adds wobbly effects to windows.
- [Useless Gaps](https://extensions.gnome.org/extension/4684/useless-gaps) - For aesthetic purposes adds useless gaps around tiled and maximized windows.
- [Desktop Cube](https://extensions.gnome.org/extension/4648/desktop-cube/) - A Desktop Cube for GNOME Shell
- [Burn My Windows](https://extensions.gnome.org/extension/4679/burn-my-windows/) - Open/Close your windows with style.

## Look and Feel

### Icons

#### Upstream Style

- [MoreWaita](https://github.com/somepaulo/MoreWaita) - An Adwaita-style icon theme for Gnome Shell.
- [GNOME++](https://github.com/Bonandry/gnome-plus) - Third-party application icons compatible with GNOME's current guidelines.
- [Pop!](https://github.com/pop-os/icon-theme) - Official icon theme of Pop!\_OS by System76.

#### Material Icons

- [Paper](https://snwh.org/paper) - Material icon theme.
- [Papirus](https://github.com/PapirusDevelopmentTeam/papirus-icon-theme) - Material icon theme, initially based on Paper.

#### Flat Icons

- [La Capitaine](https://github.com/keeferrourke/la-capitaine-icon-theme) - Icon inspired by macOS and Material Design guidelines.

#### Homogeneous Icons

- [Obsidian](https://github.com/madmaxms/iconpack-obsidian) - Continuation of the famous Faenza theme.
- [Numix Circle](https://github.com/numixproject/numix-icon-theme-circle) - Flat rounded icon theme.
- [Numix Square](https://github.com/numixproject/numix-icon-theme-square) - Flat square icon theme.

#### Skeumorphic Icons

- [Elementary XFCE](https://github.com/shimmerproject/elementary-xfce) - Desktop-agnostic version of the icons of elementary OS.

### Cursors

- [ComixCursors](https://www.gnome-look.org/p/999996) - X11 mouse theme with a comics feeling.
- [Bibata](https://github.com/KaizIqbal/Bibata_Cursor) - Silm material-based cursor theme.
- [Capitaine Cursors](https://github.com/keeferrourke/capitaine-cursors) - An x-cursor theme inspired by macOS and based on KDE Breeze. Designed to be paired with La Capitaine icons.

### Themes for non-GTK apps

- [Adwaita for Steam](https://github.com/tkashkin/Adwaita-for-Steam) - Skin to make Steam look more like a native GNOME app.
- [Adwaita theme for VS Code](https://github.com/piousdeer/vscode-adwaita) - Dark and light themes for VS Code based on GNOME's look and GNOME Builder's syntax highlighting.
- [Discord GNOME Theme](https://github.com/ricewind012/discord-gnome-theme) - A GNOME theme for Discord, following the Adwaita style & GNOME Human Interface Guidelines.
- [Firefox GNOME Theme](https://github.com/rafaelmardojai/firefox-gnome-theme) - Integrate Firefox into GNOME-based desktop using Adwaita.
- [Thunderbird GNOME Theme](https://github.com/rafaelmardojai/thunderbird-gnome-theme) - Integrate Thunderbird into GNOME-based desktop using Adwaita.
- [Obsidian Adwaita Theme](https://github.com/birneee/obsidian-adwaita-theme) - [Obsidian](https://obsidian.md) theme in the style of GNOME Adwaita.

## Community

### Official Venues

- [GNOME News Feed](https://www.gnome.org/news) - Official news posts.
- [This Week in GNOME](https://thisweek.gnome.org) - Weekly news from project maintainers from the community.
- [Apps for GNOME](https://apps.gnome.org)
- [Planet GNOME](http://planet.gnome.org) - Federation of GNOME Developers' blogs.
- [GNOME's Discourse](https://discourse.gnome.org)
- [GNOME Project Handbook](https://handbook.gnome.org)
- [GNOME Wiki (depreciated)](https://wiki.gnome.org)
- [`#gnome` on GIMPNet](https://kiwiirc.com/client/irc.gnome.org#gnome) - General-purpose GNOME IRC channel ([complete list of channels](https://wiki.gnome.org/Community/GettingInTouch/IRC))

### GNOME Communities

- [Reddit](https://www.reddit.com/r/gnome)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/gnome)

### GNOME on Social Networks

- [`@gnome` on Twitter](https://twitter.com/gnome)
- [`@gnome` on floss.social](https://floss.social/@gnome)
- [`@GNOMEDesktop` on Facebook](https://www.facebook.com/GNOMEDesktop)
- [`GNOMEDesktop` on Youtube](https://www.youtube.com/user/GNOMEDesktop)
- [`GNOMEDesktop` on Peertube](https://peertube.video/accounts/gnome)

## Developer Resources

### Libraries

- [libadwaita](https://gitlab.gnome.org/GNOME/libadwaita) - Library that contain official GNOME patterns and widgets (GTK4)
- [libhandy](https://gitlab.gnome.org/GNOME/libhandy) - Building blocks for modern adaptive GNOME apps (GTK3)
- [Relm4](https://relm4.org) - Building native applications with Rust and GTK4

### Examples

- [Hello](https://gitlab.gnome.org/chergert/hello) - Set of Hello World examples for GNOME/GTK in different languages.

### Documentations

- [GNOME Newcomers Wiki](https://wiki.gnome.org/Newcomers) - Perfect place to start contributing to GNOME.
- [GNOME Developer Center](https://developer.gnome.org) - Contains all the official GNOME documentations.
- [GTK Documentation](https://docs.gtk.org) - Official GTK documentation.
- [Valadoc](https://valadoc.org) - Documentation about Vala.
- [GJS Documentation](https://gjs-docs.gnome.org) - Documentation for the JavaScript GTK bindings.
- [GJS Guide](https://gjs.guide) - Guide for GJS.
- [The Python GTK+ 3 Tutorial](https://python-gtk-3-tutorial.readthedocs.io/en/latest) - Introduction to writing GTK+ 3 applications in Python.

[GNOME Core]: https://cdn.rawgit.com/kazhnuz/awesome-gnome/master/images/gnome-icon-symbolic.svg
[GNOME Circle]: https://cdn.rawgit.com/kazhnuz/awesome-gnome/master/images/gnome-circle.png
